/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.geometry;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.types.HexType;
import com.databricks.labs.mosaic.core.types.InternalGeometryType;
import com.databricks.labs.mosaic.core.types.package$;
import com.databricks.labs.mosaic.expressions.geometry.FlattenPolygons;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class FlattenPolygons$
implements scala.Serializable {
    public static FlattenPolygons$ MODULE$;

    static {
        new FlattenPolygons$();
    }

    public TraversableOnce<InternalRow> evalImpl(InternalRow input, Expression child, String geometryAPIName) {
        GeometryAPI geometryAPI = GeometryAPI$.MODULE$.apply(geometryAPIName);
        MosaicGeometry geometry = geometryAPI.geometry(child.eval(input), child.dataType());
        return geometry.flatten().map((Function1<MosaicGeometry, InternalRow> & Serializable & scala.Serializable)g -> InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{geometryAPI.serialize((MosaicGeometry)g, child.dataType())}))), Seq$.MODULE$.canBuildFrom());
    }

    public TypeCheckResult checkInputDataTypesImpl(Expression child) {
        DataType dataType = child.dataType();
        Object object = dataType instanceof BinaryType ? TypeCheckResult.TypeCheckSuccess$.MODULE$ : (dataType instanceof StringType ? TypeCheckResult.TypeCheckSuccess$.MODULE$ : (dataType instanceof HexType ? TypeCheckResult.TypeCheckSuccess$.MODULE$ : (dataType instanceof InternalGeometryType ? TypeCheckResult.TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(59).append("input to function explode should be array or map type, ").append("not ").append(child.dataType().catalogString()).toString()))));
        return object;
    }

    public StructType elementSchemaImpl(Expression child) {
        StructType structType;
        DataType dataType = child.dataType();
        if (dataType instanceof BinaryType) {
            structType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("element", (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        } else if (dataType instanceof StringType) {
            structType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("element", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        } else if (dataType instanceof HexType) {
            structType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("element", package$.MODULE$.HexType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        } else if (dataType instanceof InternalGeometryType) {
            structType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("element", package$.MODULE$.InternalGeometryType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        } else {
            throw new MatchError(dataType);
        }
        return structType;
    }

    public Expression makeCopyImpl(Object[] newArgs, Expression instance, String geometryAPIName) {
        Expression[] asArray = (Expression[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps(newArgs)).take(1))).map((Function1<Object, Expression> & Serializable & scala.Serializable)x$1 -> (Expression)x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
        FlattenPolygons res = new FlattenPolygons(asArray[0], geometryAPIName);
        res.copyTagsFrom((TreeNode)instance);
        return res;
    }

    public ExpressionInfo registryExpressionInfo(Option<String> db) {
        return new ExpressionInfo(FlattenPolygons.class.getCanonicalName(), (String)db.orNull(Predef$.MODULE$.$conforms()), "flatten_polygons", new StringOps(Predef$.MODULE$.augmentString("\n            |    _FUNC_(geometry) - The geometry instance can contain both Polygons and MultiPolygons.\n            |    The flattened representation will only contain Polygons.\n            |    MultiPolygon rows will be exploded into Polygon rows\n            ")).stripMargin(), "", new StringOps(Predef$.MODULE$.augmentString("\n            |    Examples:\n            |      > SELECT _FUNC_(a);\n            |        Polygon ((...))\n            |        Polygon ((...))\n            |        ...\n            |        Polygon ((...))\n            |  ")).stripMargin(), "", "generator_funcs", "1.0", "", "built-in");
    }

    public FlattenPolygons apply(Expression geom, String geometryAPIName) {
        return new FlattenPolygons(geom, geometryAPIName);
    }

    public Option<Tuple2<Expression, String>> unapply(FlattenPolygons x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2<Expression, String>>(new Tuple2<Expression, String>(x$0.geom(), x$0.geometryAPIName()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FlattenPolygons$() {
        MODULE$ = this;
    }
}

