/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.index;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineString;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.index.BNG$;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.index.IndexSystemID;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.MosaicChip;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import scala.Tuple2$mcII$sp;
import scala.Tuple2$mcJZ$sp;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcZJ$sp;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class BNGIndexSystem$
implements IndexSystem {
    public static BNGIndexSystem$ MODULE$;
    private final Seq<String> quadrants;
    private final Map<String, Object> resolutionMap;
    private final Map<String, Object> sizeMap;
    private final Seq<Seq<String>> letterMap;

    static {
        new BNGIndexSystem$();
    }

    @Override
    public String name() {
        return IndexSystem.name$(this);
    }

    @Override
    public Option<GeometryAPI> polyfill$default$3() {
        return IndexSystem.polyfill$default$3$(this);
    }

    @Override
    public Seq<MosaicChip> getBorderChips(MosaicGeometry geometry, Seq<Object> borderIndices, boolean keepCoreGeom, GeometryAPI geometryAPI) {
        return IndexSystem.getBorderChips$(this, geometry, borderIndices, keepCoreGeom, geometryAPI);
    }

    public Seq<String> quadrants() {
        return this.quadrants;
    }

    public Map<String, Object> resolutionMap() {
        return this.resolutionMap;
    }

    public Map<String, Object> sizeMap() {
        return this.sizeMap;
    }

    public Seq<Seq<String>> letterMap() {
        return this.letterMap;
    }

    public String format(long index) {
        String string;
        Seq<Object> digits = this.indexDigits(index);
        if (digits.length() < 6) {
            String prefix;
            string = prefix = ((Object)BoxesRunTime.boxToCharacter(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString((String)((SeqLike)this.letterMap().apply(new StringOps(Predef$.MODULE$.augmentString(((TraversableOnce)digits.slice(3, 5)).mkString())).toInt())).apply(new StringOps(Predef$.MODULE$.augmentString(((TraversableOnce)digits.slice(1, 3)).mkString())).toInt())), 0))).toString();
        } else {
            int quadrant = BoxesRunTime.unboxToInt(digits.last());
            String prefix = (String)((SeqLike)this.letterMap().apply(new StringOps(Predef$.MODULE$.augmentString(((TraversableOnce)digits.slice(3, 5)).mkString())).toInt())).apply(new StringOps(Predef$.MODULE$.augmentString(((TraversableOnce)digits.slice(1, 3)).mkString())).toInt());
            Seq coords = (Seq)((IterableLike)digits.drop(5)).dropRight(1);
            int k = coords.length() / 2;
            String xStr = coords.isEmpty() ? "" : ((TraversableOnce)((SeqLike)coords.slice(0, k)).padTo(k, BoxesRunTime.boxToInteger(0), Seq$.MODULE$.canBuildFrom())).mkString();
            String yStr = coords.isEmpty() ? "" : ((TraversableOnce)((SeqLike)coords.slice(k, 2 * k)).padTo(k, BoxesRunTime.boxToInteger(0), Seq$.MODULE$.canBuildFrom())).mkString();
            String qStr = (String)this.quadrants().apply(quadrant);
            string = new StringBuilder(0).append(prefix).append(xStr).append(yStr).append(qStr).toString();
        }
        return string;
    }

    @Override
    public double getBufferRadius(MosaicGeometry geometry, int resolution, GeometryAPI geometryAPI) {
        int size = this.getEdgeSize(resolution);
        return (double)size * package$.MODULE$.sqrt(2.0) / (double)2;
    }

    @Override
    public Seq<Object> polyfill(MosaicGeometry geometry, int resolution, Option<GeometryAPI> geometryAPI) {
        Seq seq;
        Predef$.MODULE$.require(geometryAPI.isDefined(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "GeometryAPI cannot be None for BNG Index System.");
        if (geometry.isEmpty()) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            Seq<MosaicLineString> shells = geometry.getShells();
            Seq startPoints = shells.map((Function1<MosaicLineString, MosaicPoint> & Serializable & scala.Serializable)x$4 -> (MosaicPoint)x$4.asSeq().head(), Seq$.MODULE$.canBuildFrom());
            Seq startIndices = startPoints.map((Function1<MosaicPoint, Object> & Serializable & scala.Serializable)p -> BoxesRunTime.boxToLong(BNGIndexSystem$.MODULE$.pointToIndex(p.getX(), p.getY(), resolution)), Seq$.MODULE$.canBuildFrom());
            seq = this.visit$1(startIndices.toSet(), (Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty(), geometry, geometryAPI).toSeq();
        }
        return seq;
    }

    @Override
    public Seq<MosaicChip> getCoreChips(Seq<Object> coreIndices, boolean keepCoreGeom, GeometryAPI geometryAPI) {
        return coreIndices.map((Function1<Object, MosaicChip> & Serializable & scala.Serializable)index -> BNGIndexSystem$.$anonfun$getCoreChips$1(keepCoreGeom, geometryAPI, BoxesRunTime.unboxToLong(index)), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public MosaicGeometry indexToGeometry(long index, GeometryAPI geometryAPI) {
        Seq<Object> digits = this.indexDigits(index);
        int resolution = this.getResolution(digits);
        int edgeSize = this.getEdgeSize(resolution);
        int x = this.getX(digits, edgeSize);
        int y = this.getY(digits, edgeSize);
        MosaicPoint p1 = geometryAPI.fromCoords((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{x, y})));
        MosaicPoint p2 = geometryAPI.fromCoords((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{x + edgeSize, y})));
        MosaicPoint p3 = geometryAPI.fromCoords((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{x + edgeSize, y + edgeSize})));
        MosaicPoint p4 = geometryAPI.fromCoords((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{x, y + edgeSize})));
        return geometryAPI.geometry((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new MosaicPoint[]{p1, p2, p3, p4, p1})), GeometryTypeEnum$.MODULE$.POLYGON());
    }

    public Seq<Object> indexDigits(long index) {
        return new StringOps(Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToLong(index)).toString())).map((Function1<Object, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger(RichChar$.MODULE$.asDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar(x$5)))), Predef$.MODULE$.fallbackStringCanBuildFrom());
    }

    public int getEdgeSize(int resolution) {
        int n;
        if (resolution == -1) {
            n = 500000;
        } else {
            int multiplier = resolution < 0 ? 5 : 1;
            double edgeSize = (double)multiplier * package$.MODULE$.pow(10.0, 6 - package$.MODULE$.abs(resolution));
            Predef$.MODULE$.require(edgeSize < (double)500000, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Invalid edge size. Index format not supported.");
            n = (int)edgeSize;
        }
        return n;
    }

    public int getResolution(Seq<Object> digits) {
        int n;
        if (digits.length() < 6) {
            n = -1;
        } else {
            int quadrant = BoxesRunTime.unboxToInt(digits.last());
            int n2 = digits.length();
            int k = (n2 - 6) / 2;
            n = quadrant > 0 ? -(k + 2) : k + 1;
        }
        return n;
    }

    public int getY(Seq<Object> digits, int edgeSize) {
        int n = digits.length();
        int k = (n - 6) / 2;
        Seq yDigits = ((TraversableLike)digits.slice(3, 5)).$plus$plus((GenTraversableOnce)digits.slice(5 + k, 5 + 2 * k), Seq$.MODULE$.canBuildFrom());
        int quadrant = BoxesRunTime.unboxToInt(digits.last());
        int edgeSizeAdj = quadrant > 0 ? 2 * edgeSize : edgeSize;
        int yOffset = quadrant == 2 || quadrant == 3 ? edgeSize : 0;
        return new StringOps(Predef$.MODULE$.augmentString(yDigits.mkString())).toInt() * edgeSizeAdj + yOffset;
    }

    public int getX(Seq<Object> digits, int edgeSize) {
        int n = digits.length();
        int k = (n - 6) / 2;
        Seq xDigits = ((TraversableLike)digits.slice(1, 3)).$plus$plus((GenTraversableOnce)digits.slice(5, 5 + k), Seq$.MODULE$.canBuildFrom());
        int quadrant = BoxesRunTime.unboxToInt(digits.last());
        int edgeSizeAdj = quadrant > 0 ? 2 * edgeSize : edgeSize;
        int xOffset = quadrant == 3 || quadrant == 4 ? edgeSize : 0;
        return new StringOps(Predef$.MODULE$.augmentString(xDigits.mkString())).toInt() * edgeSizeAdj + xOffset;
    }

    @Override
    public IndexSystemID getIndexSystemID() {
        return BNG$.MODULE$;
    }

    @Override
    public Seq<Object> kRing(long index, int n) {
        return n == 1 ? ((TraversableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapLongArray(new long[]{index}))).$plus$plus(this.kDisk(index, 1), Seq$.MODULE$.canBuildFrom()) : ((TraversableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapLongArray(new long[]{index}))).$plus$plus(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n).flatMap((Function1<Object, Seq> & Serializable & scala.Serializable)x$6 -> BNGIndexSystem$.MODULE$.kDisk(index, BoxesRunTime.unboxToInt(x$6)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<Object> kDisk(long index2, int k) {
        Seq<Object> digits = this.indexDigits(index2);
        int resolution = this.getResolution(digits);
        int edgeSize = this.getEdgeSize(resolution);
        int x = this.getX(digits, edgeSize);
        int y = this.getY(digits, edgeSize);
        IndexedSeq bottom = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2 * k).map((Function1<Object, Tuple2> & Serializable & scala.Serializable)c -> BNGIndexSystem$.$anonfun$kDisk$1(x, k, edgeSize, y, BoxesRunTime.unboxToInt(c)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq right = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2 * k).map((Function1<Object, Tuple2> & Serializable & scala.Serializable)c -> BNGIndexSystem$.$anonfun$kDisk$2(x, k, edgeSize, y, BoxesRunTime.unboxToInt(c)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq top = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2 * k).map((Function1<Object, Tuple2> & Serializable & scala.Serializable)c -> BNGIndexSystem$.$anonfun$kDisk$3(x, k, edgeSize, y, BoxesRunTime.unboxToInt(c)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq left = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2 * k).map((Function1<Object, Tuple2> & Serializable & scala.Serializable)c -> BNGIndexSystem$.$anonfun$kDisk$4(x, k, edgeSize, y, BoxesRunTime.unboxToInt(c)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq neighbours = ((TraversableLike)((TraversableLike)((TraversableLike)bottom.$plus$plus(right, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus(top, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus(left, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong(BNGIndexSystem$.$anonfun$kDisk$5(resolution, x0$1)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq result = (IndexedSeq)neighbours.filter((JFunction1$mcZJ$sp & scala.Serializable)index -> MODULE$.isValid(index));
        return result;
    }

    public boolean isValid(long index) {
        Seq<Object> digits = this.indexDigits(index);
        int resolution = this.getResolution(digits);
        int edgeSize = this.getEdgeSize(resolution);
        int x = this.getX(digits, edgeSize);
        int y = this.getY(digits, edgeSize);
        return x >= 0 && x <= 700000 && y >= 0 && y <= 1300000;
    }

    @Override
    public long pointToIndex(double eastings, double northings, int resolution) {
        int eastingsInt = (int)eastings;
        int northingsInt = (int)northings;
        int eLetter = (int)package$.MODULE$.floor(eastingsInt / 100000);
        int nLetter = (int)package$.MODULE$.floor(northingsInt / 100000);
        int offset = resolution < -1 ? 1 : 0;
        double divisor = resolution < 0 ? package$.MODULE$.pow(10.0, 6 - package$.MODULE$.abs(resolution) + 1) : package$.MODULE$.pow(10.0, 6 - resolution);
        int quadrant = this.getQuadrant(resolution, eastingsInt, northingsInt, divisor);
        int nPositions = package$.MODULE$.abs(resolution) - offset;
        int eBin = (int)package$.MODULE$.floor((double)(eastingsInt % 100000) / divisor);
        int nBin = (int)package$.MODULE$.floor((double)(northingsInt % 100000) / divisor);
        double idPlaceholder = package$.MODULE$.pow(10.0, 5 + 2 * nPositions - 2);
        double eLetterShift = package$.MODULE$.pow(10.0, 3 + 2 * nPositions - 2);
        double nLetterShift = package$.MODULE$.pow(10.0, 1 + 2 * nPositions - 2);
        double eShift = package$.MODULE$.pow(10.0, nPositions);
        int nShift = 10;
        double id = resolution == -1 ? (idPlaceholder + (double)eLetter * eLetterShift) / (double)100 + (double)quadrant : idPlaceholder + (double)eLetter * eLetterShift + (double)nLetter * nLetterShift + (double)eBin * eShift + (double)(nBin * nShift) + (double)quadrant;
        return (long)id;
    }

    public int getQuadrant(int resolution, double eastings, double northings, double divisor) {
        int n;
        if (resolution < 0) {
            double n2;
            double e;
            double n3;
            double e2;
            double nDecimal;
            double eQ = eastings / divisor;
            double nQ = northings / divisor;
            double eDecimal = eQ - package$.MODULE$.floor(eQ);
            Tuple2$mcDD$sp tuple2$mcDD$sp = new Tuple2$mcDD$sp(eDecimal, nDecimal = nQ - package$.MODULE$.floor(nQ));
            int n4 = tuple2$mcDD$sp != null && (e2 = ((Tuple2)tuple2$mcDD$sp)._1$mcD$sp()) < 0.5 & (n3 = ((Tuple2)tuple2$mcDD$sp)._2$mcD$sp()) < 0.5 ? 1 : (tuple2$mcDD$sp != null && (e = ((Tuple2)tuple2$mcDD$sp)._1$mcD$sp()) < 0.5 ? 2 : (tuple2$mcDD$sp != null && (n2 = ((Tuple2)tuple2$mcDD$sp)._2$mcD$sp()) < 0.5 ? 4 : 3));
            n = n4;
        } else {
            n = 0;
        }
        int quadrant = n;
        return quadrant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getResolution(Object res) {
        Try try_;
        Tuple2 tuple2 = new Tuple2(Try$.MODULE$.apply((JFunction0$mcI$sp & scala.Serializable)() -> BoxesRunTime.unboxToInt(res)), Try$.MODULE$.apply((Function0<String> & Serializable & scala.Serializable)() -> (String)res));
        if (tuple2 != null && (try_ = tuple2._1()) instanceof Success) {
            Success success = (Success)try_;
            int value = BoxesRunTime.unboxToInt(success.value());
            if (this.resolutions().contains(BoxesRunTime.boxToInteger(value))) {
                return value;
            }
        }
        if (tuple2 == null) throw new IllegalStateException(new StringBuilder(36).append("BNG resolution not supported; found ").append(res).toString());
        Try try_2 = tuple2._2();
        if (!(try_2 instanceof Success)) throw new IllegalStateException(new StringBuilder(36).append("BNG resolution not supported; found ").append(res).toString());
        Success success = (Success)try_2;
        String value = (String)success.value();
        if (!this.resolutionMap().contains(value)) throw new IllegalStateException(new StringBuilder(36).append("BNG resolution not supported; found ").append(res).toString());
        return BoxesRunTime.unboxToInt(this.resolutionMap().apply(value));
    }

    @Override
    public Set<Object> resolutions() {
        return (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapIntArray(new int[]{1, -1, 2, -2, 3, -3, 4, -4, 5, -5, 6, -6}));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$polyfill$2(MosaicGeometry geometry$1, Option geometryAPI$1, long index) {
        return new Tuple2$mcJZ$sp(index, geometry$1.intersects(MODULE$.indexToGeometry(index, (GeometryAPI)geometryAPI$1.get())));
    }

    private final Set visit$1(Set queue, Set visited, Set result, MosaicGeometry geometry$1, Option geometryAPI$1) {
        Set newResult;
        while (true) {
            Set visits = queue.map((Function1<Object, Tuple2> & Serializable & scala.Serializable)index -> BNGIndexSystem$.$anonfun$polyfill$2(geometry$1, geometryAPI$1, BoxesRunTime.unboxToLong(index)), Set$.MODULE$.canBuildFrom());
            Set matches = (Set)visits.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1._2$mcZ$sp()));
            Set newVisited = (Set)visited.$plus$plus(visits.map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong(x$2._1$mcJ$sp()), Set$.MODULE$.canBuildFrom()));
            Set newQueue = matches.flatMap((Function1<Tuple2, Seq> & Serializable & scala.Serializable)c -> (Seq)MODULE$.kDisk(c._1$mcJ$sp(), 1).filterNot((JFunction1$mcZJ$sp & scala.Serializable)elem -> newVisited.contains(BoxesRunTime.boxToLong(elem))), Set$.MODULE$.canBuildFrom());
            newResult = (Set)result.$plus$plus(matches.map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong(x$3._1$mcJ$sp()), Set$.MODULE$.canBuildFrom()));
            if (queue.isEmpty()) break;
            result = newResult;
            visited = newVisited;
            queue = newQueue;
        }
        return newResult;
    }

    public static final /* synthetic */ MosaicChip $anonfun$getCoreChips$1(boolean keepCoreGeom$1, GeometryAPI geometryAPI$2, long index) {
        MosaicGeometry indexGeom = keepCoreGeom$1 ? MODULE$.indexToGeometry(index, geometryAPI$2) : null;
        return new MosaicChip(true, index, indexGeom);
    }

    public static final /* synthetic */ Tuple2 $anonfun$kDisk$1(int x$7, int k$1, int edgeSize$1, int y$1, int c) {
        return new Tuple2$mcII$sp(x$7 + (c - k$1) * edgeSize$1, y$1 - k$1 * edgeSize$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$kDisk$2(int x$7, int k$1, int edgeSize$1, int y$1, int c) {
        return new Tuple2$mcII$sp(x$7 + k$1 * edgeSize$1, y$1 + (c - k$1) * edgeSize$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$kDisk$3(int x$7, int k$1, int edgeSize$1, int y$1, int c) {
        return new Tuple2$mcII$sp(x$7 + (k$1 - c) * edgeSize$1, y$1 + k$1 * edgeSize$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$kDisk$4(int x$7, int k$1, int edgeSize$1, int y$1, int c) {
        return new Tuple2$mcII$sp(x$7 - k$1 * edgeSize$1, y$1 + (k$1 - c) * edgeSize$1);
    }

    public static final /* synthetic */ long $anonfun$kDisk$5(int resolution$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int x = tuple2._1$mcI$sp();
        int y = tuple2._2$mcI$sp();
        long l = MODULE$.pointToIndex(x, y, resolution$2);
        return l;
    }

    private BNGIndexSystem$() {
        MODULE$ = this;
        IndexSystem.$init$(this);
        this.quadrants = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "SW", "NW", "NE", "SE"}));
        this.resolutionMap = (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("500km"), BoxesRunTime.boxToInteger(-1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("100km"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("50km"), BoxesRunTime.boxToInteger(-2)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("10km"), BoxesRunTime.boxToInteger(2)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("5km"), BoxesRunTime.boxToInteger(-3)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("1km"), BoxesRunTime.boxToInteger(3)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("500m"), BoxesRunTime.boxToInteger(-4)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("100m"), BoxesRunTime.boxToInteger(4)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("50m"), BoxesRunTime.boxToInteger(-5)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("10m"), BoxesRunTime.boxToInteger(5)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("5m"), BoxesRunTime.boxToInteger(-6)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("1m"), BoxesRunTime.boxToInteger(6))}));
        this.sizeMap = (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("500km"), BoxesRunTime.boxToInteger(500000)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("100km"), BoxesRunTime.boxToInteger(100000)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("50km"), BoxesRunTime.boxToInteger(50000)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("10km"), BoxesRunTime.boxToInteger(10000)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("5km"), BoxesRunTime.boxToInteger(5000)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("1km"), BoxesRunTime.boxToInteger(1000)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("500m"), BoxesRunTime.boxToInteger(500)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("100m"), BoxesRunTime.boxToInteger(100)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("50m"), BoxesRunTime.boxToInteger(50)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("10m"), BoxesRunTime.boxToInteger(10)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("5m"), BoxesRunTime.boxToInteger(5)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("1m"), BoxesRunTime.boxToInteger(1))}));
        this.letterMap = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SV", "SW", "SX", "SY", "SZ", "TV", "TW"})), (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SQ", "SR", "SS", "ST", "SU", "TQ", "TR"})), (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SL", "SM", "SN", "SO", "SP", "TL", "TM"})), (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SF", "SG", "SH", "SJ", "SK", "TF", "TG"})), (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SA", "SB", "SC", "SD", "SE", "TA", "TB"})), (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NV", "NW", "NX", "NY", "NZ", "OV", "OW"})), (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NQ", "NR", "NS", "NT", "NU", "OQ", "OR"})), (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NL", "NM", "NN", "NO", "NP", "OL", "OM"})), (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NF", "NG", "NH", "NJ", "NK", "OF", "OG"})), (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NA", "NB", "NC", "ND", "NE", "OA", "OB"})), (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HV", "HW", "HX", "HY", "SZ", "TV", "TW"})), (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HQ", "HR", "HS", "HT", "HU", "JQ", "JR"})), (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HL", "HM", "HN", "HO", "HP", "JL", "JM"}))}));
    }
}

