/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry.api;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.types.HexType;
import com.databricks.labs.mosaic.core.types.InternalGeometryType;
import com.databricks.labs.mosaic.core.types.JSONType;
import com.databricks.labs.mosaic.core.types.KryoType;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.package$;
import com.uber.h3core.util.GeoCoord;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!\u0002\u0011\"\u0003\u0003\u0001\u0004\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u000b}\u0002A\u0011\u0001!\t\u000b\u0011\u0003a\u0011A#\t\u000b\u0011\u0002A\u0011A)\t\u000b\u0011\u0002A\u0011\u0001/\t\u000b\u0011\u0002A\u0011A?\t\r\u0011\u0002A\u0011AA\u0016\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!!\r\u0001\t\u0003\tI\u0004C\u0004\u0002B\u00011\t!a\u0011\t\u000f\u0005m\u0003A\"\u0001\u0002^\u001d9\u00111N\u0011\t\u0002\u00055dA\u0002\u0011\"\u0011\u0003\ty\u0007\u0003\u0004@\u001b\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003gjA\u0011AA;\u0011\u001d\tI(\u0004C\u0001\u0003w:q!a \u000e\u0011\u0003\t\tIB\u0004\u0002\u00066A\t!a\"\t\r}\u0012B\u0011AAE\u0011\u0015!%\u0003\"\u0011F\u0011\u001d\t\tE\u0005C!\u0003\u0017Cq!a\u0017\u0013\t\u0003\ny\tC\u0005\u0002\u0014J\t\t\u0011\"\u0003\u0002\u0016\u001e9\u0011qU\u0007\t\u0002\u0005%faBAV\u001b!\u0005\u0011Q\u0016\u0005\u0007\u007fe!\t!a,\t\u000b\u0011KB\u0011I#\t\u000f\u0005\u0005\u0013\u0004\"\u0011\u00022\"9\u00111L\r\u0005B\u0005]\u0006\"CAJ3\u0005\u0005I\u0011BAK\u0011%\t\u0019*DA\u0001\n\u0013\t)JA\u0006HK>lW\r\u001e:z\u0003BK%B\u0001\u0012$\u0003\r\t\u0007/\u001b\u0006\u0003I\u0015\n\u0001bZ3p[\u0016$(/\u001f\u0006\u0003M\u001d\nAaY8sK*\u0011\u0001&K\u0001\u0007[>\u001c\u0018-[2\u000b\u0005)Z\u0013\u0001\u00027bENT!\u0001L\u0017\u0002\u0015\u0011\fG/\u00192sS\u000e\\7OC\u0001/\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005IB\u0014BA\u001d4\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019\u0011X-\u00193feB\u0011A(P\u0007\u0002G%\u0011ah\t\u0002\u000f\u000f\u0016|W.\u001a;ssJ+\u0017\rZ3s\u0003\u0019a\u0014N\\5u}Q\u0011\u0011i\u0011\t\u0003\u0005\u0002i\u0011!\t\u0005\u0006u\t\u0001\raO\u0001\u0005]\u0006lW-F\u0001G!\t9eJ\u0004\u0002I\u0019B\u0011\u0011jM\u0007\u0002\u0015*\u00111jL\u0001\u0007yI|w\u000e\u001e \n\u00055\u001b\u0014A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!T\u001a\u0015\u0007I+&\f\u0005\u0002='&\u0011Ak\t\u0002\u000f\u001b>\u001c\u0018-[2HK>lW\r\u001e:z\u0011\u00151F\u00011\u0001X\u0003\u0015Ig\u000e];u!\t\u0011\u0004,\u0003\u0002Zg\t\u0019\u0011I\\=\t\u000bm#\u0001\u0019\u0001$\u0002\u0011QL\b/\u001a(b[\u0016$2AU/o\u0011\u0015qV\u00011\u0001`\u0003\u0019\u0001x.\u001b8ugB\u0019\u0001-\u001a5\u000f\u0005\u0005\u001cgBA%c\u0013\u0005!\u0014B\u000134\u0003\u001d\u0001\u0018mY6bO\u0016L!AZ4\u0003\u0007M+\u0017O\u0003\u0002egA\u0011\u0011\u000e\\\u0007\u0002U*\u00111nI\u0001\u0006a>Lg\u000e^\u0005\u0003[*\u00141\"T8tC&\u001c\u0007k\\5oi\")q.\u0002a\u0001a\u0006Aq-Z8n)f\u0004X\r\u0005\u0002rs:\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0006[>$W\r\u001c\u0006\u0003m\u0016\nQ\u0001^=qKNL!\u0001_:\u0002!\u001d+w.\\3uef$\u0016\u0010]3F]Vl\u0017B\u0001>|\u0005\u00151\u0016\r\\;f\u0013\ta8GA\u0006F]VlWM]1uS>tG\u0003\u0002*\u007f\u0003;Aaa \u0004A\u0002\u0005\u0005\u0011!C5oaV$H)\u0019;b!\u0011\t\u0019!!\u0007\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t\u0001bY1uC2L8\u000f\u001e\u0006\u0005\u0003\u0017\ti!A\u0002tc2TA!a\u0004\u0002\u0012\u0005)1\u000f]1sW*!\u00111CA\u000b\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qC\u0001\u0004_J<\u0017\u0002BA\u000e\u0003\u000b\u00111\"\u00138uKJt\u0017\r\u001c*po\"9\u0011q\u0004\u0004A\u0002\u0005\u0005\u0012\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\t\u0005\r\u0012qE\u0007\u0003\u0003KQ1A^A\u0005\u0013\u0011\tI#!\n\u0003\u0011\u0011\u000bG/\u0019+za\u0016$RAUA\u0017\u0003_AQa`\u0004A\u0002]Cq!a\b\b\u0001\u0004\t\t#A\u0005tKJL\u0017\r\\5{KR)q+!\u000e\u00028!)A\u0005\u0003a\u0001%\"9\u0011q\u0004\u0005A\u0002\u0005\u0005B#B,\u0002<\u0005u\u0002\"\u0002\u0013\n\u0001\u0004\u0011\u0006BBA \u0013\u0001\u0007a)\u0001\u0007eCR\fG+\u001f9f\u001d\u0006lW-\u0001\u0007ge>lw)Z8D_>\u0014H\rF\u0002i\u0003\u000bBaa\u001b\u0006A\u0002\u0005\u001d\u0003\u0003BA%\u0003/j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\u0005kRLGN\u0003\u0003\u0002R\u0005M\u0013A\u000254G>\u0014XMC\u0002\u0002V5\nA!\u001e2fe&!\u0011\u0011LA&\u0005!9Um\\\"p_J$\u0017A\u00034s_6\u001cun\u001c:egR\u0019\u0001.a\u0018\t\u000f\u0005\u00054\u00021\u0001\u0002d\u000511m\\8sIN\u0004B\u0001Y3\u0002fA\u0019!'a\u001a\n\u0007\u0005%4G\u0001\u0004E_V\u0014G.Z\u0001\f\u000f\u0016|W.\u001a;ss\u0006\u0003\u0016\n\u0005\u0002C\u001bM\u0019Q\"M\u001c\u0015\u0005\u00055\u0014!B1qa2LHcA!\u0002x!)Ai\u0004a\u0001\r\u0006Iq-\u001a;SK\u0006$WM\u001d\u000b\u0004w\u0005u\u0004\"\u0002#\u0011\u0001\u00041\u0015\u0001B#T%&\u00032!a!\u0013\u001b\u0005i!\u0001B#T%&\u001b\"AE!\u0015\u0005\u0005\u0005Ec\u00015\u0002\u000e\"11.\u0006a\u0001\u0003\u000f\"2\u0001[AI\u0011\u001d\t\tG\u0006a\u0001\u0003G\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0013\t\u0005\u00033\u000b\u0019+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0016\u0001\u00026bm\u0006LA!!*\u0002\u001c\n1qJ\u00196fGR\f1A\u0013+T!\r\t\u0019)\u0007\u0002\u0004\u0015R\u001b6CA\rB)\t\tI\u000bF\u0002i\u0003gCq!!.\u001d\u0001\u0004\t9%\u0001\u0005hK>\u001cun\u001c:e)\rA\u0017\u0011\u0018\u0005\b\u0003Cj\u0002\u0019AA2\u0001")
public abstract class GeometryAPI
implements Serializable {
    private final GeometryReader reader;

    public static GeometryReader getReader(String string) {
        return GeometryAPI$.MODULE$.getReader(string);
    }

    public static GeometryAPI apply(String string) {
        return GeometryAPI$.MODULE$.apply(string);
    }

    public abstract String name();

    public MosaicGeometry geometry(Object input, String typeName) {
        MosaicGeometry mosaicGeometry;
        String string = typeName;
        if ("WKT".equals(string)) {
            mosaicGeometry = this.reader.fromWKT((String)input);
        } else if ("HEX".equals(string)) {
            mosaicGeometry = this.reader.fromHEX((String)input);
        } else if ("WKB".equals(string)) {
            mosaicGeometry = this.reader.fromWKB((byte[])input);
        } else if ("GEOJSON".equals(string)) {
            mosaicGeometry = this.reader.fromJSON((String)input);
        } else {
            throw new UnsupportedOperationException();
        }
        return mosaicGeometry;
    }

    public MosaicGeometry geometry(Seq<MosaicPoint> points, Enumeration.Value geomType) {
        return this.reader.fromSeq(points, geomType);
    }

    public MosaicGeometry geometry(InternalRow inputData, DataType dataType) {
        MosaicGeometry mosaicGeometry;
        DataType dataType2 = dataType;
        if (dataType2 instanceof BinaryType) {
            mosaicGeometry = this.reader.fromWKB(inputData.getBinary(0));
        } else if (dataType2 instanceof StringType) {
            mosaicGeometry = this.reader.fromWKT(inputData.getString(0));
        } else if (dataType2 instanceof HexType) {
            mosaicGeometry = this.reader.fromHEX(((InternalRow)inputData.get(0, package$.MODULE$.HexType())).getString(0));
        } else if (dataType2 instanceof JSONType) {
            mosaicGeometry = this.reader.fromJSON(((InternalRow)inputData.get(0, package$.MODULE$.JSONType())).getString(0));
        } else if (dataType2 instanceof InternalGeometryType) {
            mosaicGeometry = this.reader.fromInternal((InternalRow)inputData.get(0, package$.MODULE$.InternalGeometryType()));
        } else {
            throw new MatchError(dataType2);
        }
        return mosaicGeometry;
    }

    public MosaicGeometry geometry(Object inputData, DataType dataType) {
        MosaicGeometry mosaicGeometry;
        DataType dataType2 = dataType;
        if (dataType2 instanceof BinaryType) {
            mosaicGeometry = this.reader.fromWKB((byte[])inputData);
        } else if (dataType2 instanceof StringType) {
            mosaicGeometry = this.reader.fromWKT(((UTF8String)inputData).toString());
        } else if (dataType2 instanceof HexType) {
            mosaicGeometry = this.reader.fromHEX(((InternalRow)inputData).getString(0));
        } else if (dataType2 instanceof JSONType) {
            mosaicGeometry = this.reader.fromJSON(((InternalRow)inputData).getString(0));
        } else if (dataType2 instanceof InternalGeometryType) {
            mosaicGeometry = this.reader.fromInternal((InternalRow)inputData);
        } else if (dataType2 instanceof KryoType) {
            mosaicGeometry = this.reader.fromKryo((InternalRow)inputData);
        } else {
            throw new MatchError(dataType2);
        }
        return mosaicGeometry;
    }

    public Object serialize(MosaicGeometry geometry, DataType dataType) {
        Object object;
        DataType dataType2 = dataType;
        if (dataType2 instanceof BinaryType) {
            object = geometry.toWKB();
        } else if (dataType2 instanceof StringType) {
            object = UTF8String.fromString((String)geometry.toWKT());
        } else if (dataType2 instanceof HexType) {
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new UTF8String[]{UTF8String.fromString((String)geometry.toHEX())})));
        } else if (dataType2 instanceof JSONType) {
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new UTF8String[]{UTF8String.fromString((String)geometry.toJSON())})));
        } else if (dataType2 instanceof InternalGeometryType) {
            object = geometry.toInternal().serialize();
        } else if (dataType2 instanceof KryoType) {
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(GeometryTypeEnum$.MODULE$.fromString(geometry.getGeometryType()).id()), geometry.toKryo()})));
        } else {
            throw new Error(new StringBuilder(15).append(dataType).append(" not supported.").toString());
        }
        return object;
    }

    public Object serialize(MosaicGeometry geometry, String dataTypeName) {
        Object object;
        String string = dataTypeName.toUpperCase(Locale.ROOT);
        if ("WKB".equals(string)) {
            object = geometry.toWKB();
        } else if ("WKT".equals(string)) {
            object = UTF8String.fromString((String)geometry.toWKT());
        } else if ("HEX".equals(string)) {
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new UTF8String[]{UTF8String.fromString((String)geometry.toHEX())})));
        } else if ("GEOJSON".equals(string)) {
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new UTF8String[]{UTF8String.fromString((String)geometry.toJSON())})));
        } else if ("COORDS".equals(string)) {
            object = geometry.toInternal().serialize();
        } else if ("KRYO".equals(string)) {
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(GeometryTypeEnum$.MODULE$.fromString(geometry.getGeometryType()).id()), geometry.toKryo()})));
        } else {
            throw new Error(new StringBuilder(15).append(dataTypeName).append(" not supported.").toString());
        }
        return object;
    }

    public abstract MosaicPoint fromGeoCoord(GeoCoord var1);

    public abstract MosaicPoint fromCoords(Seq<Object> var1);

    public GeometryAPI(GeometryReader reader) {
        this.reader = reader;
    }
}

