#Beetroot, a general purpose library for all sorts of uses.

#Imports
import sys

from .exception import *

if not str(sys.version).startswith("3"):
    #HOW DARE YOU USE PYTHON2 IDIOT. or python4, if that ever exists
    #well I mean, if it's like a massive database or smth and you don't wanna migrate 1k+ lines of code then I understand, BUT STILL.
    #And if you're using Python1, then the following emoji is for you. 😲
    raise VersionError("Python version is not supported.")

#More imports
import platform
import getpass
import socket
import uuid
import hashlib
import webbrowser
import datetime
import os
import ctypes
import shutil
import subprocess
import re
import zlib
import lzma
    
try:
    import PIL
    
except (ModuleNotFoundError, ImportError):
    pass

try:
    import pyautogui
    
except (ModuleNotFoundError, ImportError):
    pass

try:
    import psutil
    
except (ModuleNotFoundError, ImportError):
    pass

try:
    from setuptools import setup
    
except (ModuleNotFoundError, ImportError):
    pass

try:
    from Cython.Build import cythonize
    
except (ModuleNotFoundError, ImportError):
    pass

try:
    import keyboard
    
except (ModuleNotFoundError, ImportError):
    pass

from pathlib import Path as p
from functools import cache, lru_cache, wraps
from contextlib import contextmanager, redirect_stderr, redirect_stdout
from inspect import signature, Signature

from .metadata import __version__, __author__, __authoremail__, __url__
from .random import *
from .stopwatch import *
from .file import *
from .tts import *
from .objtype import *
from .obf import *
from .mem import *
from .yt import *
from .hashl import *
from .text import *
from .comp import *
from .pkl import *
from .math import *
from .static import typed

#Constants
gen = mrandom.SystemRandom()

class recursion:
    """A recursion context manager.
    Be careful when using this, settings a recursionlimit
    too high can literally crash python. To use, do
    with beetroot.recursion(<some recursion limit here>):
        <do something here>
        
    Warning, you can cause Python to segfault if recursion limit
    is set too high.
    """
    def __init__(self, limit):
        self.limit = limit
        self.old_limit = sys.getrecursionlimit()
        
    def __enter__(self):
        self.old_limit = sys.getrecursionlimit()
        sys.setrecursionlimit(self.limit)
        
    def __exit__(self, type, value, tb):
        sys.setrecursionlimit(self.old_limit)
        
def retargs(func):
    """Return all args in function in a list."""
    return list(map(str, str(signature(func))[1:-1].split(", ")))
        
def speed(f=None, **kwargs):
    """Memoization and Cython compiling for python functions.
    If you are using this for a random function, pass the nocache=True argument."""
    if not callable(f) and f != None:
        raise FunctionError("\"f\" must be callable.")
    
    maxsize = kwargs.get(
        "maxsize",
        None
    )
    typ = bool(
        kwargs.get(
            "typed",
            True
        )
    )
    nocache = bool(
        kwargs.get(
            "nocache",
            False
        )
    )
    def inner(func):
        func = typed(func)
        if not nocache:
            func = lru_cache(maxsize=maxsize, typed=typ)(func)
        
        @wraps(func)
        def out(*args, **kwargs):
            return func(*args, **kwargs)
            
        return out
    
    if callable(f):
        return inner(f)
    
    else:
        return inner

def cython(filepath:"filepath to .py or .pyx file", **kwargs) -> "Cython File":
    """Builds a cython extension thingy."""
    try:
        pypath = kwargs.get(
            "pypath",
            sys.executable
        ).replace("\\", r"\\")
        
        if pypath == sys.executable:
            pass
        
        else:
            pypath = os.path.abspath(pypath)
            
        #print(pypath)
            
        file.dump("./setup.py", rf"""#Generated by python-beetroot
try:
    from setuptools import setup
    from Cython.Build import cythonize
    
    setup(
        ext_modules=cythonize(
            r"{os.path.abspath(str(filepath))}"
        )
    )
    
except (ModuleNotFoundError, ImportError):
    raise ModuleNotFoundError("setuptools and Cython must be installed. Try pip install setuptools Cython or pip install beetroot[cython].")
        """)
        
        outdir = str(".".join(os.path.basename(filepath).split(".")[:-1]))
        subprocess.call(pypath + " " + os.path.abspath("setup.py") + " build_ext --build-lib " + outdir)
        
        try:
            shutil.rmtree(os.path.abspath("build"))
            
        except FileNotFoundError:
            pass
        
        try:
            file.delete(os.path.abspath("setup.py"))
            
        except FileNotFoundError:
            pass
        
        for filename in os.listdir(os.path.abspath(".")):
            if (filename.endswith(".exp") or filename.endswith(".lib") or filename.endswith(".obj")) and (filename.startswith(outdir)):
                try:
                    file.delete(os.path.abspath(".") + filename)
                    
                except FileNotFoundError:
                    pass
                    
        try:
            c = str(p("".join(["./", outdir, ".c"])))
            file.move(c, str(p("".join(["./", outdir, "/", c]))))
            
        except FileNotFoundError:
            pass
        
        return 0
        
    except NameError:
        raise ModuleError("setuptools and Cython must be installed. Try `pip install setuptools Cython` or `pip install beetroot[cython]`.")

def printn(str_:"string to print"=""):
    """Prints a string without a trailing newline"""
    if objtype(str_) == "bytes":
        print(str_.decode("iso-8859-1"), end="", flush=True)
        
    else:
        print(str(str_), end="", flush=True)
        
    return 0

def getch(str_:"string to print before getch()ing"="") -> "Single Char":
    """input() but it only waits for one character."""
    try:
        printn(str_)
        alphabet = [chr(i) for i in range(97, 123)]
        
        while True:
            for letter in alphabet:
                if keyboard.is_pressed(letter):
                    print()
                    return letter
                
                for num in range(0, 10):
                    if keyboard.is_pressed(str(num)):
                        print()
                        return str(num)
    
    except NameError:
        raise ModuleError("keyboard must be installed. Try `pip install keyboard` or `pip install beetroot[keyboard]`.")

def isAdmin() -> "UAC Admin perms in Windows":
    """Checks if python program has administrator prviliges."""
    if platform.system() == "Windows":
        try:
            return ctypes.windll.shell32.IsUserAnAdmin()
        
        except:
            return False
        
    else:
        raise OSError("beetroot.isAdmin() only works for windows.")

def admin():
    """Requests UAC Admin on Windows"""
    if platform.system() == "Windows":
        ctypes.windll.shell32.ShellExecuteW(
            None, 'runas', sys.executable, ' '.join(sys.argv), None, None
        )
        
        return isAdmin()
        
    else:
        raise OSError("beetroot.admin() only works for windows.")
      
def test() -> "Hello, world!":
    """Test"""
    print("Hello, world!")
    return 0

def remove(str_:"a string", ting:"also a string"):
    """Removes all occurences of "ting" in str_"""
    return str_.replace(str(ting), "")

def siteize(str_:"a string"):
    """Turns the string into a malformed url so you can talk
    in a weird way. For example, "Hello, world!", gets
    turned into "www.HelloWorld.com"."""
    a = list(str_)
    b = []
    
    for item in a:
        if item.isalnum() or item == " ":
            b.append(item)
            
    b = remove("".join(b).title(), " ")
    return "".join(["www.", b, ".com"])
    
def taskkill(tasque):
    """Kills a task by name with psutil."""
    try:
        for proc in psutil.process_iter():
            if proc.name() == tasque:
                proc.kill()
                
    except NameError:
        raise ModuleError("psutil must be installed to use beetroot.taskkill(). Use pip install psutil or pip install beetroot[ram].")
    
def crash() -> "Crashes python or smth idk":
    """This causes python to cra- cra- cra- cras- cra- crash."""
    
    taskkill(os.path.basename(sys.executable).replace(".EXE", ".exe"))    
    
    with recursion(1<<30):
        f = lambda a : f(a)
        f(f)
    
    return 1
    
def quicksort(array) -> "Sorted array":
    """Quicksort algorithm"""

    less = []
    equal = []
    greater = []

    if len(array) > 1:
        pivot = array[0]
        
        for x in array:
            if x < pivot:
                less.append(x)
                
            elif x == pivot:
                equal.append(x)
                
            elif x > pivot:
                greater.append(x)
                
        return quicksort(less) + equal + quicksort(greater)
    
    else:
        return array

def execfile(file:"a filepath to a .py file"):
    """Executes a python .py script"""
    with open(p(file), "r", encoding="iso-8859-1") as f:
        exec(f.read())
        f.close()
        
    return 0

def systemstats():
    """Returns info about system and hardware"""
    return [getpass.getuser(), platform.system(), platform.version(), platform.machine(), platform.node(), socket.gethostbyname(socket.gethostname()), ':'.join(("%012X" % uuid.getnode())[i:i+2] for i in range(0, 12, 2)).lower()]

def unline(str_:"a string"):
    """Makes multi-line strings single-line"""
    return str(str_).replace("\n", "\\n").replace("\t", "\\t").replace("\r", "\\r").replace("\a", "\\a").replace("\b", "\\b")

def reline(str_:"a string"):
    """Reverses beetroot.unline()"""
    return str(str_).replace("\\n", "\n").replace("\\t", "\t").replace("\\r", "\r").replace("\\a", "\a").replace("\\b", "\b")

def pixelgrab(i_x:"x coordinate", i_y:"y coordinate"):
    """Grabs colour of pixel at (i_x, i_y)"""
    try:
        import PIL.ImageGrab
        return PIL.ImageGrab.grab().load()[int(i_x), int(i_y)]
    
    except (ModuleNotFoundError, ImportError):
        raise ModuleError("PIL most be installed to use beetroot.pixelgrab(). Try pip install pillow.")
    
    except ValueError:
        raise InvalidTypeError("Arguement \"i_x\" and \"i_y\" must be ints or floats")
    
def mousepixelgrab():
    """Grabs colour of pixel at mouse-pointer"""
    try:
        import PIL.ImageGrab
        import pyautogui
        
        pos = pyautogui.position()
        return PIL.ImageGrab.grab().load()[pos.x, pos.y]

    except (ModuleNotFoundError, ImportError):
        raise ModuleError("PIL and pyautogui most be installed to use beetroot.mousepixelgrab(). Try pip install pillow pyautogui.")
    
def beetroot() -> "BEETROOT":
    """BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT BEETROOT-"""
    while True:
        get_beetrolled = True
        print("""

██████╗░███████╗███████╗████████╗██████╗░░█████╗░░█████╗░████████╗
██╔══██╗██╔════╝██╔════╝╚══██╔══╝██╔══██╗██╔══██╗██╔══██╗╚══██╔══╝
██████╦╝█████╗░░█████╗░░░░░██║░░░██████╔╝██║░░██║██║░░██║░░░██║░░░
██╔══██╗██╔══╝░░██╔══╝░░░░░██║░░░██╔══██╗██║░░██║██║░░██║░░░██║░░░
██████╦╝███████╗███████╗░░░██║░░░██║░░██║╚█████╔╝╚█████╔╝░░░██║░░░
╚═════╝░╚══════╝╚══════╝░░░╚═╝░░░╚═╝░░╚═╝░╚════╝░░╚════╝░░░░╚═╝░░░""", end="", flush=True)
        time.sleep(0.5)
        
    return 69420

def totally_not_a_rickroll() -> "definitely not a rickroll >:)":
    """Definitely absolutely 100% totally completely not a rickroll"""
    for i in range(0, 100):
        rickrolled = True
        
    webbrowser.open("https://www.youtube.com/watch?v=dQw4w9WgXcQ", new=0)
    return "".join(["U JUST GOT RICKROLLED IN ", str(datetime.datetime.now().year)])