# sequences

This is a simple Mathematical Module which is easy to use. The module provides many of the most famous **sequences** from the On-Line Encyclopedia of International Sequences (OEIS) as Python Functions that return a **list** of the first 'n' terms of that sequence. Help text is included for each function so that the user gets an idea of what to expect as the output to each function.

## Examples of Functions provided

- whole(n)
    > [0, 1, 2, 3, ..., n]
- square(n)
    > [0, 1, 4, 9, ..., pow(n, 2)]
- prime(n)
    > [2, 3, 5, 7, 11, ...]
- composite(n)
    > [4, 6, 8, 9, 10, ...]
- fibonacci(n)
    > [0, 1, 1, 2, 3, ..., sum([F(n-1), F(n-2)])]
- tribonacci(n)
    > [0, 1, 1, 2, 4, ..., sum([T(n-1), T(n-2), T(n-3)])]
- pascal(n):
    > [[1], [1, 1], [1, 2, 1], [1, 3, 3, 1], [1, 4, 6, 4, 1], ...] \
    > the nth row of Pascal's triangle (as a List) \
    > P(n) = comb(n, r) for r in range(n+1)
- look_say(n)
    > [1, 11, 21, 1211, 111221, ...] \
    > T(n) = 0 if n == 0 \
    > T(n) = int(word for T(n-1)) otherwise
- recaman(n)
    > [0, 1, 3, 6, 2, ...] \
    > T(n) = 0 if n == 0 \
    > T(n) = T(n-1) - n if positive and not already in sequence \
    > T(n) = T(n-1) + n otherwise
- van_eck(n)
    > [0, 0, 1, 0, 2, ...] \
    > T(n) = 0 if n == 0 \
    > T(n) = 0 if T(n-1) is a new number \
    > T(n) = x if T(n) occured x steps earlier in the sequence

And many more... Access the names of all the functions through dir() in python. Each function contains help text that can be accessed through help() in python to know more about it.

## Updates (0.0.5)
Minor bug fixes

## Updates (0.0.6)
Added new sequences like:
- catalan(n)
    > [1, 1, 2, 5, 14, ..., comb(2n, n) / (n+1)]
- aronson(n)
    > [1, 4, 11, 16, 24, ...] \
    > these numbers are obtained from the index of english letter "T" or "t" in the sentence: "T is the first, fourth, eleventh, sixteenth, ... letter in this sentence." ignoring spaces and punctuation marks
- cantral_polygon(n)
    > [1, 2, 4, 7, 11, ..., (pow(n, 2) + n+2) / 2]

## Updates (0.0.7)
Added new sequences like:
- lucas(n)
    > [2, 1, 3, 4, 7, ..., sum([L(n-1) + L(n-2)])]
- negalucas(n)
    > [2, -1, 3, -4, 7, ..., pow(-1, n) * L(n)]
- euclid_mullin(n)
    > [2, 3, 7, 43, 13, ...] \
    > T(n) = 2 if n == 1 \
    > T(n) = smallest prime factor of product(euclid_mullin(n)) + 1 otherwise
- prime_powers(n)
    > [2, 3, 4, 5, 7, ...] \
    > these numbers are of the form pow(x, n) where x is a prime and n is a positive integer
- central_binomial(n)
    > [1, 2, 6, 20, 70, ..., comb(2n, n)]
- semiprime(n)
    > [4, 6, 9, 10, 14, ...] \
    > these numbers are the product of two primes not necessarily distinct

And many more... Access the names of all the functions through dir() in python.

## Updates (0.0.8)
Minor bug fixes

## Reach out to me
If you face issues, contact me through my e-mail: knightt1821@gmail.com