/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.util.ToHuman;

public abstract class SsaInsn
implements ToHuman,
Cloneable {
    private final SsaBasicBlock block;
    private RegisterSpec result;

    protected SsaInsn(RegisterSpec registerSpec, SsaBasicBlock ssaBasicBlock) {
        if (ssaBasicBlock == null) {
            throw new NullPointerException("block == null");
        }
        this.block = ssaBasicBlock;
        this.result = registerSpec;
    }

    public static SsaInsn makeFromRop(Insn insn, SsaBasicBlock ssaBasicBlock) {
        return new NormalSsaInsn(insn, ssaBasicBlock);
    }

    public SsaInsn clone() {
        try {
            return (SsaInsn)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("unexpected", cloneNotSupportedException);
        }
    }

    public RegisterSpec getResult() {
        return this.result;
    }

    protected void setResult(RegisterSpec registerSpec) {
        if (registerSpec == null) {
            throw new NullPointerException("result == null");
        }
        this.result = registerSpec;
    }

    public abstract RegisterSpecList getSources();

    public SsaBasicBlock getBlock() {
        return this.block;
    }

    public boolean isResultReg(int n) {
        return this.result != null && this.result.getReg() == n;
    }

    public void changeResultReg(int n) {
        if (this.result != null) {
            this.result = this.result.withReg(n);
        }
    }

    public final void setResultLocal(LocalItem localItem) {
        LocalItem localItem2 = this.result.getLocalItem();
        if (!(localItem == localItem2 || localItem != null && localItem.equals(this.result.getLocalItem()))) {
            this.result = RegisterSpec.makeLocalOptional(this.result.getReg(), this.result.getType(), localItem);
        }
    }

    public final void mapRegisters(RegisterMapper registerMapper) {
        RegisterSpec registerSpec = this.result;
        this.result = registerMapper.map(this.result);
        this.block.getParent().updateOneDefinition(this, registerSpec);
        this.mapSourceRegisters(registerMapper);
    }

    public abstract void mapSourceRegisters(RegisterMapper var1);

    public abstract Rop getOpcode();

    public abstract Insn getOriginalRopInsn();

    public RegisterSpec getLocalAssignment() {
        if (this.result != null && this.result.getLocalItem() != null) {
            return this.result;
        }
        return null;
    }

    public boolean isRegASource(int n) {
        return null != this.getSources().specForRegister(n);
    }

    public abstract Insn toRopInsn();

    public abstract boolean isPhiOrMove();

    public abstract boolean hasSideEffect();

    public boolean isNormalMoveInsn() {
        return false;
    }

    public boolean isMoveException() {
        return false;
    }

    public abstract boolean canThrow();

    public abstract void accept(Visitor var1);

    public static interface Visitor {
        public void visitMoveInsn(NormalSsaInsn var1);

        public void visitPhiInsn(PhiInsn var1);

        public void visitNonMoveInsn(NormalSsaInsn var1);
    }
}

