/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.ssa.Optimizer;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;

public final class NormalSsaInsn
extends SsaInsn
implements Cloneable {
    private Insn insn;

    NormalSsaInsn(Insn insn, SsaBasicBlock ssaBasicBlock) {
        super(insn.getResult(), ssaBasicBlock);
        this.insn = insn;
    }

    @Override
    public final void mapSourceRegisters(RegisterMapper registerMapper) {
        RegisterSpecList registerSpecList = this.insn.getSources();
        RegisterSpecList registerSpecList2 = registerMapper.map(registerSpecList);
        if (registerSpecList2 != registerSpecList) {
            this.insn = this.insn.withNewRegisters(this.getResult(), registerSpecList2);
            this.getBlock().getParent().onSourcesChanged(this, registerSpecList);
        }
    }

    public final void changeOneSource(int n, RegisterSpec registerSpec) {
        RegisterSpecList registerSpecList = this.insn.getSources();
        int n2 = registerSpecList.size();
        RegisterSpecList registerSpecList2 = new RegisterSpecList(n2);
        for (int i = 0; i < n2; ++i) {
            registerSpecList2.set(i, i == n ? registerSpec : registerSpecList.get(i));
        }
        registerSpecList2.setImmutable();
        RegisterSpec registerSpec2 = registerSpecList.get(n);
        if (registerSpec2.getReg() != registerSpec.getReg()) {
            this.getBlock().getParent().onSourceChanged(this, registerSpec2, registerSpec);
        }
        this.insn = this.insn.withNewRegisters(this.getResult(), registerSpecList2);
    }

    public final void setNewSources(RegisterSpecList registerSpecList) {
        RegisterSpecList registerSpecList2 = this.insn.getSources();
        if (registerSpecList2.size() != registerSpecList.size()) {
            throw new RuntimeException("Sources counts don't match");
        }
        this.insn = this.insn.withNewRegisters(this.getResult(), registerSpecList);
    }

    @Override
    public NormalSsaInsn clone() {
        return (NormalSsaInsn)super.clone();
    }

    @Override
    public RegisterSpecList getSources() {
        return this.insn.getSources();
    }

    @Override
    public String toHuman() {
        return this.toRopInsn().toHuman();
    }

    @Override
    public Insn toRopInsn() {
        return this.insn.withNewRegisters(this.getResult(), this.insn.getSources());
    }

    @Override
    public Rop getOpcode() {
        return this.insn.getOpcode();
    }

    @Override
    public Insn getOriginalRopInsn() {
        return this.insn;
    }

    @Override
    public RegisterSpec getLocalAssignment() {
        RegisterSpec registerSpec = this.insn.getOpcode().getOpcode() == 54 ? this.insn.getSources().get(0) : this.getResult();
        if (registerSpec == null) {
            return null;
        }
        LocalItem localItem = registerSpec.getLocalItem();
        if (localItem == null) {
            return null;
        }
        return registerSpec;
    }

    public void upgradeToLiteral() {
        RegisterSpecList registerSpecList = this.insn.getSources();
        this.insn = this.insn.withSourceLiteral();
        this.getBlock().getParent().onSourcesChanged(this, registerSpecList);
    }

    @Override
    public boolean isNormalMoveInsn() {
        return this.insn.getOpcode().getOpcode() == 2;
    }

    @Override
    public boolean isMoveException() {
        return this.insn.getOpcode().getOpcode() == 4;
    }

    @Override
    public boolean canThrow() {
        return this.insn.canThrow();
    }

    @Override
    public void accept(SsaInsn.Visitor visitor) {
        if (this.isNormalMoveInsn()) {
            visitor.visitMoveInsn(this);
        } else {
            visitor.visitNonMoveInsn(this);
        }
    }

    @Override
    public boolean isPhiOrMove() {
        return this.isNormalMoveInsn();
    }

    @Override
    public boolean hasSideEffect() {
        Rop rop = this.getOpcode();
        if (rop.getBranchingness() != 1) {
            return true;
        }
        boolean bl = Optimizer.getPreserveLocals() && this.getLocalAssignment() != null;
        switch (rop.getOpcode()) {
            case 2: 
            case 5: 
            case 55: {
                return bl;
            }
        }
        return true;
    }
}

