/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecSet;
import com.android.dx.ssa.LocalVariableInfo;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.util.IntList;
import java.util.ArrayList;
import java.util.BitSet;

public class LocalVariableExtractor {
    private final SsaMethod method;
    private final ArrayList<SsaBasicBlock> blocks;
    private final LocalVariableInfo resultInfo;
    private final BitSet workSet;

    public static LocalVariableInfo extract(SsaMethod ssaMethod) {
        LocalVariableExtractor localVariableExtractor = new LocalVariableExtractor(ssaMethod);
        return localVariableExtractor.doit();
    }

    private LocalVariableExtractor(SsaMethod ssaMethod) {
        if (ssaMethod == null) {
            throw new NullPointerException("method == null");
        }
        ArrayList<SsaBasicBlock> arrayList = ssaMethod.getBlocks();
        this.method = ssaMethod;
        this.blocks = arrayList;
        this.resultInfo = new LocalVariableInfo(ssaMethod);
        this.workSet = new BitSet(arrayList.size());
    }

    private LocalVariableInfo doit() {
        if (this.method.getRegCount() > 0) {
            int n = this.method.getEntryBlockIndex();
            while (n >= 0) {
                this.workSet.clear(n);
                this.processBlock(n);
                n = this.workSet.nextSetBit(0);
            }
        }
        this.resultInfo.setImmutable();
        return this.resultInfo;
    }

    private void processBlock(int n) {
        RegisterSpecSet registerSpecSet = this.resultInfo.mutableCopyOfStarts(n);
        SsaBasicBlock ssaBasicBlock = this.blocks.get(n);
        ArrayList<SsaInsn> arrayList = ssaBasicBlock.getInsns();
        int n2 = arrayList.size();
        if (n == this.method.getExitBlockIndex()) {
            return;
        }
        SsaInsn ssaInsn = (SsaInsn)arrayList.get(n2 - 1);
        boolean bl = ssaInsn.getOriginalRopInsn().getCatches().size() != 0;
        boolean bl2 = bl && ssaInsn.getResult() != null;
        int n3 = n2 - 1;
        RegisterSpecSet registerSpecSet2 = registerSpecSet;
        for (int i = 0; i < n2; ++i) {
            RegisterSpec registerSpec;
            SsaInsn ssaInsn2;
            RegisterSpec registerSpec2;
            if (bl2 && i == n3) {
                registerSpecSet.setImmutable();
                registerSpecSet = registerSpecSet.mutableCopy();
            }
            if ((registerSpec2 = (ssaInsn2 = (SsaInsn)arrayList.get(i)).getLocalAssignment()) == null) {
                registerSpec2 = ssaInsn2.getResult();
                if (registerSpec2 == null || registerSpecSet.get(registerSpec2.getReg()) == null) continue;
                registerSpecSet.remove(registerSpecSet.get(registerSpec2.getReg()));
                continue;
            }
            if ((registerSpec2 = registerSpec2.withSimpleType()).equals(registerSpec = registerSpecSet.get(registerSpec2))) continue;
            RegisterSpec registerSpec3 = registerSpecSet.localItemToSpec(registerSpec2.getLocalItem());
            if (registerSpec3 != null && registerSpec3.getReg() != registerSpec2.getReg()) {
                registerSpecSet.remove(registerSpec3);
            }
            this.resultInfo.addAssignment(ssaInsn2, registerSpec2);
            registerSpecSet.put(registerSpec2);
        }
        registerSpecSet.setImmutable();
        IntList intList = ssaBasicBlock.getSuccessorList();
        int n4 = intList.size();
        int n5 = ssaBasicBlock.getPrimarySuccessorIndex();
        for (int i = 0; i < n4; ++i) {
            RegisterSpecSet registerSpecSet3;
            int n6 = intList.get(i);
            RegisterSpecSet registerSpecSet4 = registerSpecSet3 = n6 == n5 ? registerSpecSet : registerSpecSet2;
            if (!this.resultInfo.mergeStarts(n6, registerSpecSet3)) continue;
            this.workSet.set(n6);
        }
    }
}

