/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io.instructions;

import com.android.dex.DexException;
import com.android.dx.io.IndexType;
import com.android.dx.io.OpcodeInfo;
import com.android.dx.io.instructions.CodeInput;
import com.android.dx.io.instructions.CodeOutput;
import com.android.dx.io.instructions.DecodedInstruction;
import com.android.dx.io.instructions.FillArrayDataPayloadDecodedInstruction;
import com.android.dx.io.instructions.FiveRegisterDecodedInstruction;
import com.android.dx.io.instructions.FourRegisterDecodedInstruction;
import com.android.dx.io.instructions.OneRegisterDecodedInstruction;
import com.android.dx.io.instructions.PackedSwitchPayloadDecodedInstruction;
import com.android.dx.io.instructions.RegisterRangeDecodedInstruction;
import com.android.dx.io.instructions.SparseSwitchPayloadDecodedInstruction;
import com.android.dx.io.instructions.ThreeRegisterDecodedInstruction;
import com.android.dx.io.instructions.TwoRegisterDecodedInstruction;
import com.android.dx.io.instructions.ZeroRegisterDecodedInstruction;
import com.android.dx.util.Hex;
import java.io.EOFException;

public enum InstructionCodec {
    FORMAT_00X{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            return new ZeroRegisterDecodedInstruction(this, n, 0, null, 0, 0L);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(decodedInstruction.getOpcodeUnit());
        }
    }
    ,
    FORMAT_10X{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            return new ZeroRegisterDecodedInstruction(this, n2, 0, null, 0, n3);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(decodedInstruction.getOpcodeUnit());
        }
    }
    ,
    FORMAT_12X{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.nibble2(n);
            int n4 = InstructionCodec.nibble3(n);
            return new TwoRegisterDecodedInstruction(this, n2, 0, null, 0, 0L, n3, n4);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcodeUnit(), InstructionCodec.makeByte(decodedInstruction.getA(), decodedInstruction.getB())));
        }
    }
    ,
    FORMAT_11N{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.nibble2(n);
            int n4 = InstructionCodec.nibble3(n) << 28 >> 28;
            return new OneRegisterDecodedInstruction(this, n2, 0, null, 0, n4, n3);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcodeUnit(), InstructionCodec.makeByte(decodedInstruction.getA(), decodedInstruction.getLiteralNibble())));
        }
    }
    ,
    FORMAT_11X{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            return new OneRegisterDecodedInstruction(this, n2, 0, null, 0, 0L, n3);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getA()));
        }
    }
    ,
    FORMAT_10T{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = codeInput.cursor() - 1;
            int n3 = InstructionCodec.byte0(n);
            byte by = (byte)InstructionCodec.byte1(n);
            return new ZeroRegisterDecodedInstruction(this, n3, 0, null, n2 + by, 0L);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            int n = decodedInstruction.getTargetByte(codeOutput.cursor());
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), n));
        }
    }
    ,
    FORMAT_20T{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = codeInput.cursor() - 1;
            int n3 = InstructionCodec.byte0(n);
            int n4 = InstructionCodec.byte1(n);
            short s = (short)codeInput.read();
            return new ZeroRegisterDecodedInstruction(this, n3, 0, null, n2 + s, n4);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            short s = decodedInstruction.getTargetUnit(codeOutput.cursor());
            codeOutput.write(decodedInstruction.getOpcodeUnit(), s);
        }
    }
    ,
    FORMAT_20BC{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            int n4 = codeInput.read();
            return new ZeroRegisterDecodedInstruction(this, n2, n4, IndexType.VARIES, 0, n3);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getLiteralByte()), decodedInstruction.getIndexUnit());
        }
    }
    ,
    FORMAT_22X{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            int n4 = codeInput.read();
            return new TwoRegisterDecodedInstruction(this, n2, 0, null, 0, 0L, n3, n4);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getA()), decodedInstruction.getBUnit());
        }
    }
    ,
    FORMAT_21T{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = codeInput.cursor() - 1;
            int n3 = InstructionCodec.byte0(n);
            int n4 = InstructionCodec.byte1(n);
            short s = (short)codeInput.read();
            return new OneRegisterDecodedInstruction(this, n3, 0, null, n2 + s, 0L, n4);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            short s = decodedInstruction.getTargetUnit(codeOutput.cursor());
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getA()), s);
        }
    }
    ,
    FORMAT_21S{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            short s = (short)codeInput.read();
            return new OneRegisterDecodedInstruction(this, n2, 0, null, 0, s, n3);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getA()), decodedInstruction.getLiteralUnit());
        }
    }
    ,
    FORMAT_21H{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            long l = (short)codeInput.read();
            return new OneRegisterDecodedInstruction(this, n2, 0, null, 0, l <<= n2 == 21 ? 16 : 48, n3);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            int n = decodedInstruction.getOpcode();
            int n2 = n == 21 ? 16 : 48;
            short s = (short)(decodedInstruction.getLiteral() >> n2);
            codeOutput.write(InstructionCodec.codeUnit(n, decodedInstruction.getA()), s);
        }
    }
    ,
    FORMAT_21C{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            int n4 = codeInput.read();
            IndexType indexType = OpcodeInfo.getIndexType(n2);
            return new OneRegisterDecodedInstruction(this, n2, n4, indexType, 0, 0L, n3);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getA()), decodedInstruction.getIndexUnit());
        }
    }
    ,
    FORMAT_23X{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            int n4 = codeInput.read();
            int n5 = InstructionCodec.byte0(n4);
            int n6 = InstructionCodec.byte1(n4);
            return new ThreeRegisterDecodedInstruction(this, n2, 0, null, 0, 0L, n3, n5, n6);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getA()), InstructionCodec.codeUnit(decodedInstruction.getB(), decodedInstruction.getC()));
        }
    }
    ,
    FORMAT_22B{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            int n4 = codeInput.read();
            int n5 = InstructionCodec.byte0(n4);
            byte by = (byte)InstructionCodec.byte1(n4);
            return new TwoRegisterDecodedInstruction(this, n2, 0, null, 0, by, n3, n5);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getA()), InstructionCodec.codeUnit(decodedInstruction.getB(), decodedInstruction.getLiteralByte()));
        }
    }
    ,
    FORMAT_22T{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = codeInput.cursor() - 1;
            int n3 = InstructionCodec.byte0(n);
            int n4 = InstructionCodec.nibble2(n);
            int n5 = InstructionCodec.nibble3(n);
            short s = (short)codeInput.read();
            return new TwoRegisterDecodedInstruction(this, n3, 0, null, n2 + s, 0L, n4, n5);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            short s = decodedInstruction.getTargetUnit(codeOutput.cursor());
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), InstructionCodec.makeByte(decodedInstruction.getA(), decodedInstruction.getB())), s);
        }
    }
    ,
    FORMAT_22S{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.nibble2(n);
            int n4 = InstructionCodec.nibble3(n);
            short s = (short)codeInput.read();
            return new TwoRegisterDecodedInstruction(this, n2, 0, null, 0, s, n3, n4);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), InstructionCodec.makeByte(decodedInstruction.getA(), decodedInstruction.getB())), decodedInstruction.getLiteralUnit());
        }
    }
    ,
    FORMAT_22C{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.nibble2(n);
            int n4 = InstructionCodec.nibble3(n);
            int n5 = codeInput.read();
            IndexType indexType = OpcodeInfo.getIndexType(n2);
            return new TwoRegisterDecodedInstruction(this, n2, n5, indexType, 0, 0L, n3, n4);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), InstructionCodec.makeByte(decodedInstruction.getA(), decodedInstruction.getB())), decodedInstruction.getIndexUnit());
        }
    }
    ,
    FORMAT_22CS{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.nibble2(n);
            int n4 = InstructionCodec.nibble3(n);
            int n5 = codeInput.read();
            return new TwoRegisterDecodedInstruction(this, n2, n5, IndexType.FIELD_OFFSET, 0, 0L, n3, n4);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), InstructionCodec.makeByte(decodedInstruction.getA(), decodedInstruction.getB())), decodedInstruction.getIndexUnit());
        }
    }
    ,
    FORMAT_30T{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = codeInput.cursor() - 1;
            int n3 = InstructionCodec.byte0(n);
            int n4 = InstructionCodec.byte1(n);
            int n5 = codeInput.readInt();
            return new ZeroRegisterDecodedInstruction(this, n3, 0, null, n2 + n5, n4);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            int n = decodedInstruction.getTarget(codeOutput.cursor());
            codeOutput.write(decodedInstruction.getOpcodeUnit(), InstructionCodec.unit0(n), InstructionCodec.unit1(n));
        }
    }
    ,
    FORMAT_32X{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            int n4 = codeInput.read();
            int n5 = codeInput.read();
            return new TwoRegisterDecodedInstruction(this, n2, 0, null, 0, n3, n4, n5);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            codeOutput.write(decodedInstruction.getOpcodeUnit(), decodedInstruction.getAUnit(), decodedInstruction.getBUnit());
        }
    }
    ,
    FORMAT_31I{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            int n4 = codeInput.readInt();
            return new OneRegisterDecodedInstruction(this, n2, 0, null, 0, n4, n3);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            int n = decodedInstruction.getLiteralInt();
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getA()), InstructionCodec.unit0(n), InstructionCodec.unit1(n));
        }
    }
    ,
    FORMAT_31T{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = codeInput.cursor() - 1;
            int n3 = InstructionCodec.byte0(n);
            int n4 = InstructionCodec.byte1(n);
            int n5 = n2 + codeInput.readInt();
            switch (n3) {
                case 43: 
                case 44: {
                    codeInput.setBaseAddress(n5, n2);
                }
            }
            return new OneRegisterDecodedInstruction(this, n3, 0, null, n5, 0L, n4);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            int n = decodedInstruction.getTarget(codeOutput.cursor());
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getA()), InstructionCodec.unit0(n), InstructionCodec.unit1(n));
        }
    }
    ,
    FORMAT_31C{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            int n4 = codeInput.readInt();
            IndexType indexType = OpcodeInfo.getIndexType(n2);
            return new OneRegisterDecodedInstruction(this, n2, n4, indexType, 0, 0L, n3);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            int n = decodedInstruction.getIndex();
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getA()), InstructionCodec.unit0(n), InstructionCodec.unit1(n));
        }
    }
    ,
    FORMAT_35C{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            return InstructionCodec.decodeRegisterList((InstructionCodec)this, n, codeInput);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            InstructionCodec.encodeRegisterList(decodedInstruction, codeOutput);
        }
    }
    ,
    FORMAT_35MS{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            return InstructionCodec.decodeRegisterList((InstructionCodec)this, n, codeInput);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            InstructionCodec.encodeRegisterList(decodedInstruction, codeOutput);
        }
    }
    ,
    FORMAT_35MI{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            return InstructionCodec.decodeRegisterList((InstructionCodec)this, n, codeInput);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            InstructionCodec.encodeRegisterList(decodedInstruction, codeOutput);
        }
    }
    ,
    FORMAT_3RC{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            return InstructionCodec.decodeRegisterRange((InstructionCodec)this, n, codeInput);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            InstructionCodec.encodeRegisterRange(decodedInstruction, codeOutput);
        }
    }
    ,
    FORMAT_3RMS{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            return InstructionCodec.decodeRegisterRange((InstructionCodec)this, n, codeInput);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            InstructionCodec.encodeRegisterRange(decodedInstruction, codeOutput);
        }
    }
    ,
    FORMAT_3RMI{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            return InstructionCodec.decodeRegisterRange((InstructionCodec)this, n, codeInput);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            InstructionCodec.encodeRegisterRange(decodedInstruction, codeOutput);
        }
    }
    ,
    FORMAT_51L{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = InstructionCodec.byte0(n);
            int n3 = InstructionCodec.byte1(n);
            long l = codeInput.readLong();
            return new OneRegisterDecodedInstruction(this, n2, 0, null, 0, l, n3);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            long l = decodedInstruction.getLiteral();
            codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getA()), InstructionCodec.unit0(l), InstructionCodec.unit1(l), InstructionCodec.unit2(l), InstructionCodec.unit3(l));
        }
    }
    ,
    FORMAT_PACKED_SWITCH_PAYLOAD{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = codeInput.baseAddressForCursor() - 1;
            int n3 = codeInput.read();
            int n4 = codeInput.readInt();
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = n2 + codeInput.readInt();
            }
            return new PackedSwitchPayloadDecodedInstruction(this, n, n4, nArray);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            PackedSwitchPayloadDecodedInstruction packedSwitchPayloadDecodedInstruction = (PackedSwitchPayloadDecodedInstruction)decodedInstruction;
            int[] nArray = packedSwitchPayloadDecodedInstruction.getTargets();
            int n = codeOutput.baseAddressForCursor();
            codeOutput.write(packedSwitchPayloadDecodedInstruction.getOpcodeUnit());
            codeOutput.write(InstructionCodec.asUnsignedUnit(nArray.length));
            codeOutput.writeInt(packedSwitchPayloadDecodedInstruction.getFirstKey());
            for (int n2 : nArray) {
                codeOutput.writeInt(n2 - n);
            }
        }
    }
    ,
    FORMAT_SPARSE_SWITCH_PAYLOAD{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2;
            int n3 = codeInput.baseAddressForCursor() - 1;
            int n4 = codeInput.read();
            int[] nArray = new int[n4];
            int[] nArray2 = new int[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                nArray[n2] = codeInput.readInt();
            }
            for (n2 = 0; n2 < n4; ++n2) {
                nArray2[n2] = n3 + codeInput.readInt();
            }
            return new SparseSwitchPayloadDecodedInstruction(this, n, nArray, nArray2);
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            SparseSwitchPayloadDecodedInstruction sparseSwitchPayloadDecodedInstruction = (SparseSwitchPayloadDecodedInstruction)decodedInstruction;
            int[] nArray = sparseSwitchPayloadDecodedInstruction.getKeys();
            int[] nArray2 = sparseSwitchPayloadDecodedInstruction.getTargets();
            int n = codeOutput.baseAddressForCursor();
            codeOutput.write(sparseSwitchPayloadDecodedInstruction.getOpcodeUnit());
            codeOutput.write(InstructionCodec.asUnsignedUnit(nArray2.length));
            for (int n2 : nArray) {
                codeOutput.writeInt(n2);
            }
            for (int n2 : nArray2) {
                codeOutput.writeInt(n2 - n);
            }
        }
    }
    ,
    FORMAT_FILL_ARRAY_DATA_PAYLOAD{

        @Override
        public DecodedInstruction decode(int n, CodeInput codeInput) throws EOFException {
            int n2 = codeInput.read();
            int n3 = codeInput.readInt();
            switch (n2) {
                case 1: {
                    byte[] byArray = new byte[n3];
                    boolean bl = true;
                    int n4 = 0;
                    for (int i = 0; i < n3; ++i) {
                        if (bl) {
                            n4 = codeInput.read();
                        }
                        byArray[i] = (byte)(n4 & 0xFF);
                        n4 >>= 8;
                        bl = !bl;
                    }
                    return new FillArrayDataPayloadDecodedInstruction((InstructionCodec)this, n, byArray);
                }
                case 2: {
                    short[] sArray = new short[n3];
                    for (int i = 0; i < n3; ++i) {
                        sArray[i] = (short)codeInput.read();
                    }
                    return new FillArrayDataPayloadDecodedInstruction((InstructionCodec)this, n, sArray);
                }
                case 4: {
                    int[] nArray = new int[n3];
                    for (int i = 0; i < n3; ++i) {
                        nArray[i] = codeInput.readInt();
                    }
                    return new FillArrayDataPayloadDecodedInstruction((InstructionCodec)this, n, nArray);
                }
                case 8: {
                    long[] lArray = new long[n3];
                    for (int i = 0; i < n3; ++i) {
                        lArray[i] = codeInput.readLong();
                    }
                    return new FillArrayDataPayloadDecodedInstruction((InstructionCodec)this, n, lArray);
                }
            }
            throw new DexException("bogus element_width: " + Hex.u2(n2));
        }

        @Override
        public void encode(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
            FillArrayDataPayloadDecodedInstruction fillArrayDataPayloadDecodedInstruction = (FillArrayDataPayloadDecodedInstruction)decodedInstruction;
            short s = fillArrayDataPayloadDecodedInstruction.getElementWidthUnit();
            Object object = fillArrayDataPayloadDecodedInstruction.getData();
            codeOutput.write(fillArrayDataPayloadDecodedInstruction.getOpcodeUnit());
            codeOutput.write(s);
            codeOutput.writeInt(fillArrayDataPayloadDecodedInstruction.getSize());
            switch (s) {
                case 1: {
                    codeOutput.write((byte[])object);
                    break;
                }
                case 2: {
                    codeOutput.write((short[])object);
                    break;
                }
                case 4: {
                    codeOutput.write((int[])object);
                    break;
                }
                case 8: {
                    codeOutput.write((long[])object);
                    break;
                }
                default: {
                    throw new DexException("bogus element_width: " + Hex.u2(s));
                }
            }
        }
    };


    public abstract DecodedInstruction decode(int var1, CodeInput var2) throws EOFException;

    public abstract void encode(DecodedInstruction var1, CodeOutput var2);

    private static DecodedInstruction decodeRegisterList(InstructionCodec instructionCodec, int n, CodeInput codeInput) throws EOFException {
        int n2 = InstructionCodec.byte0(n);
        int n3 = InstructionCodec.nibble2(n);
        int n4 = InstructionCodec.nibble3(n);
        int n5 = codeInput.read();
        int n6 = codeInput.read();
        int n7 = InstructionCodec.nibble0(n6);
        int n8 = InstructionCodec.nibble1(n6);
        int n9 = InstructionCodec.nibble2(n6);
        int n10 = InstructionCodec.nibble3(n6);
        IndexType indexType = OpcodeInfo.getIndexType(n2);
        switch (n4) {
            case 0: {
                return new ZeroRegisterDecodedInstruction(instructionCodec, n2, n5, indexType, 0, 0L);
            }
            case 1: {
                return new OneRegisterDecodedInstruction(instructionCodec, n2, n5, indexType, 0, 0L, n7);
            }
            case 2: {
                return new TwoRegisterDecodedInstruction(instructionCodec, n2, n5, indexType, 0, 0L, n7, n8);
            }
            case 3: {
                return new ThreeRegisterDecodedInstruction(instructionCodec, n2, n5, indexType, 0, 0L, n7, n8, n9);
            }
            case 4: {
                return new FourRegisterDecodedInstruction(instructionCodec, n2, n5, indexType, 0, 0L, n7, n8, n9, n10);
            }
            case 5: {
                return new FiveRegisterDecodedInstruction(instructionCodec, n2, n5, indexType, 0, 0L, n7, n8, n9, n10, n3);
            }
        }
        throw new DexException("bogus registerCount: " + Hex.uNibble(n4));
    }

    private static void encodeRegisterList(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
        codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), InstructionCodec.makeByte(decodedInstruction.getE(), decodedInstruction.getRegisterCount())), decodedInstruction.getIndexUnit(), InstructionCodec.codeUnit(decodedInstruction.getA(), decodedInstruction.getB(), decodedInstruction.getC(), decodedInstruction.getD()));
    }

    private static DecodedInstruction decodeRegisterRange(InstructionCodec instructionCodec, int n, CodeInput codeInput) throws EOFException {
        int n2 = InstructionCodec.byte0(n);
        int n3 = InstructionCodec.byte1(n);
        int n4 = codeInput.read();
        int n5 = codeInput.read();
        IndexType indexType = OpcodeInfo.getIndexType(n2);
        return new RegisterRangeDecodedInstruction(instructionCodec, n2, n4, indexType, 0, 0L, n5, n3);
    }

    private static void encodeRegisterRange(DecodedInstruction decodedInstruction, CodeOutput codeOutput) {
        codeOutput.write(InstructionCodec.codeUnit(decodedInstruction.getOpcode(), decodedInstruction.getRegisterCount()), decodedInstruction.getIndexUnit(), decodedInstruction.getAUnit());
    }

    private static short codeUnit(int n, int n2) {
        if ((n & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("bogus lowByte");
        }
        if ((n2 & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("bogus highByte");
        }
        return (short)(n | n2 << 8);
    }

    private static short codeUnit(int n, int n2, int n3, int n4) {
        if ((n & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("bogus nibble0");
        }
        if ((n2 & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("bogus nibble1");
        }
        if ((n3 & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("bogus nibble2");
        }
        if ((n4 & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("bogus nibble3");
        }
        return (short)(n | n2 << 4 | n3 << 8 | n4 << 12);
    }

    private static int makeByte(int n, int n2) {
        if ((n & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("bogus lowNibble");
        }
        if ((n2 & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("bogus highNibble");
        }
        return n | n2 << 4;
    }

    private static short asUnsignedUnit(int n) {
        if ((n & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("bogus unsigned code unit");
        }
        return (short)n;
    }

    private static short unit0(int n) {
        return (short)n;
    }

    private static short unit1(int n) {
        return (short)(n >> 16);
    }

    private static short unit0(long l) {
        return (short)l;
    }

    private static short unit1(long l) {
        return (short)(l >> 16);
    }

    private static short unit2(long l) {
        return (short)(l >> 32);
    }

    private static short unit3(long l) {
        return (short)(l >> 48);
    }

    private static int byte0(int n) {
        return n & 0xFF;
    }

    private static int byte1(int n) {
        return n >> 8 & 0xFF;
    }

    private static int byte2(int n) {
        return n >> 16 & 0xFF;
    }

    private static int byte3(int n) {
        return n >>> 24;
    }

    private static int nibble0(int n) {
        return n & 0xF;
    }

    private static int nibble1(int n) {
        return n >> 4 & 0xF;
    }

    private static int nibble2(int n) {
        return n >> 8 & 0xF;
    }

    private static int nibble3(int n) {
        return n >> 12 & 0xF;
    }
}

