/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.FieldIdItem;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.MemberIdsSection;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstFieldRef;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.Collection;
import java.util.TreeMap;

public final class FieldIdsSection
extends MemberIdsSection {
    private final TreeMap<CstFieldRef, FieldIdItem> fieldIds = new TreeMap();

    public FieldIdsSection(DexFile dexFile) {
        super("field_ids", dexFile);
    }

    @Override
    public Collection<? extends Item> items() {
        return this.fieldIds.values();
    }

    @Override
    public IndexedItem get(Constant constant) {
        if (constant == null) {
            throw new NullPointerException("cst == null");
        }
        this.throwIfNotPrepared();
        IndexedItem indexedItem = this.fieldIds.get((CstFieldRef)constant);
        if (indexedItem == null) {
            throw new IllegalArgumentException("not found");
        }
        return indexedItem;
    }

    public void writeHeaderPart(AnnotatedOutput annotatedOutput) {
        int n;
        this.throwIfNotPrepared();
        int n2 = this.fieldIds.size();
        int n3 = n = n2 == 0 ? 0 : this.getFileOffset();
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, "field_ids_size:  " + Hex.u4(n2));
            annotatedOutput.annotate(4, "field_ids_off:   " + Hex.u4(n));
        }
        annotatedOutput.writeInt(n2);
        annotatedOutput.writeInt(n);
    }

    public synchronized FieldIdItem intern(CstFieldRef cstFieldRef) {
        if (cstFieldRef == null) {
            throw new NullPointerException("field == null");
        }
        this.throwIfPrepared();
        FieldIdItem fieldIdItem = this.fieldIds.get(cstFieldRef);
        if (fieldIdItem == null) {
            fieldIdItem = new FieldIdItem(cstFieldRef);
            this.fieldIds.put(cstFieldRef, fieldIdItem);
        }
        return fieldIdItem;
    }

    public int indexOf(CstFieldRef cstFieldRef) {
        if (cstFieldRef == null) {
            throw new NullPointerException("ref == null");
        }
        this.throwIfNotPrepared();
        FieldIdItem fieldIdItem = this.fieldIds.get(cstFieldRef);
        if (fieldIdItem == null) {
            throw new IllegalArgumentException("not found");
        }
        return fieldIdItem.getIndex();
    }
}

