/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.AnnotationItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.MixedItemSection;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.Section;
import com.android.dx.rop.annotation.Annotation;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;

public final class AnnotationSetItem
extends OffsettedItem {
    private static final int ALIGNMENT = 4;
    private static final int ENTRY_WRITE_SIZE = 4;
    private final Annotations annotations;
    private final AnnotationItem[] items;

    public AnnotationSetItem(Annotations annotations, DexFile dexFile) {
        super(4, AnnotationSetItem.writeSize(annotations));
        this.annotations = annotations;
        this.items = new AnnotationItem[annotations.size()];
        int n = 0;
        for (Annotation annotation : annotations.getAnnotations()) {
            this.items[n] = new AnnotationItem(annotation, dexFile);
            ++n;
        }
    }

    private static int writeSize(Annotations annotations) {
        try {
            return annotations.size() * 4 + 4;
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("list == null");
        }
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public int hashCode() {
        return this.annotations.hashCode();
    }

    @Override
    protected int compareTo0(OffsettedItem offsettedItem) {
        AnnotationSetItem annotationSetItem = (AnnotationSetItem)offsettedItem;
        return this.annotations.compareTo(annotationSetItem.annotations);
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_ANNOTATION_SET_ITEM;
    }

    @Override
    public String toHuman() {
        return this.annotations.toString();
    }

    @Override
    public void addContents(DexFile dexFile) {
        MixedItemSection mixedItemSection = dexFile.getByteData();
        int n = this.items.length;
        for (int i = 0; i < n; ++i) {
            this.items[i] = mixedItemSection.intern(this.items[i]);
        }
    }

    @Override
    protected void place0(Section section, int n) {
        AnnotationItem.sortByTypeIdIndex(this.items);
    }

    @Override
    protected void writeTo0(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        boolean bl = annotatedOutput.annotates();
        int n = this.items.length;
        if (bl) {
            annotatedOutput.annotate(0, this.offsetString() + " annotation set");
            annotatedOutput.annotate(4, "  size: " + Hex.u4(n));
        }
        annotatedOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            AnnotationItem annotationItem = this.items[i];
            int n2 = annotationItem.getAbsoluteOffset();
            if (bl) {
                annotatedOutput.annotate(4, "  entries[" + Integer.toHexString(i) + "]: " + Hex.u4(n2));
                this.items[i].annotateTo(annotatedOutput, "    ");
            }
            annotatedOutput.writeInt(n2);
        }
    }
}

