/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.DexOptions;
import com.android.dx.dex.code.CodeAddress;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.OutputFinisher;
import java.util.ArrayList;

public final class OutputCollector {
    private final OutputFinisher finisher;
    private ArrayList<DalvInsn> suffix;

    public OutputCollector(DexOptions dexOptions, int n, int n2, int n3, int n4) {
        this.finisher = new OutputFinisher(dexOptions, n, n3, n4);
        this.suffix = new ArrayList(n2);
    }

    public void add(DalvInsn dalvInsn) {
        this.finisher.add(dalvInsn);
    }

    public void reverseBranch(int n, CodeAddress codeAddress) {
        this.finisher.reverseBranch(n, codeAddress);
    }

    public void addSuffix(DalvInsn dalvInsn) {
        this.suffix.add(dalvInsn);
    }

    public OutputFinisher getFinisher() {
        if (this.suffix == null) {
            throw new UnsupportedOperationException("already processed");
        }
        this.appendSuffixToOutput();
        return this.finisher;
    }

    private void appendSuffixToOutput() {
        int n = this.suffix.size();
        for (int i = 0; i < n; ++i) {
            this.finisher.add(this.suffix.get(i));
        }
        this.suffix = null;
    }
}

