/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.cf;

import com.android.dx.dex.code.DalvCode;
import com.android.dx.rop.code.RopMethod;
import java.io.PrintStream;

public final class CodeStatistics {
    private static final boolean DEBUG = false;
    public static int runningDeltaRegisters = 0;
    public static int runningDeltaInsns = 0;
    public static int runningTotalInsns = 0;
    public static int dexRunningDeltaRegisters = 0;
    public static int dexRunningDeltaInsns = 0;
    public static int dexRunningTotalInsns = 0;
    public static int runningOriginalBytes = 0;

    private CodeStatistics() {
    }

    public static void updateOriginalByteCount(int n) {
        runningOriginalBytes += n;
    }

    public static void updateDexStatistics(DalvCode dalvCode, DalvCode dalvCode2) {
        dexRunningDeltaInsns += dalvCode2.getInsns().codeSize() - dalvCode.getInsns().codeSize();
        dexRunningDeltaRegisters += dalvCode2.getInsns().getRegistersSize() - dalvCode.getInsns().getRegistersSize();
        dexRunningTotalInsns += dalvCode2.getInsns().codeSize();
    }

    public static void updateRopStatistics(RopMethod ropMethod, RopMethod ropMethod2) {
        int n = ropMethod.getBlocks().getEffectiveInstructionCount();
        int n2 = ropMethod.getBlocks().getRegCount();
        int n3 = ropMethod2.getBlocks().getEffectiveInstructionCount();
        runningDeltaInsns += n3 - n;
        runningDeltaRegisters += ropMethod2.getBlocks().getRegCount() - n2;
        runningTotalInsns += n3;
    }

    public static void dumpStatistics(PrintStream printStream) {
        printStream.printf("Optimizer Delta Rop Insns: %d total: %d (%.2f%%) Delta Registers: %d\n", runningDeltaInsns, runningTotalInsns, 100.0 * (double)((float)runningDeltaInsns / (float)(runningTotalInsns + Math.abs(runningDeltaInsns))), runningDeltaRegisters);
        printStream.printf("Optimizer Delta Dex Insns: Insns: %d total: %d (%.2f%%) Delta Registers: %d\n", dexRunningDeltaInsns, dexRunningTotalInsns, 100.0 * (double)((float)dexRunningDeltaInsns / (float)(dexRunningTotalInsns + Math.abs(dexRunningDeltaInsns))), dexRunningDeltaRegisters);
        printStream.printf("Original bytecode byte count: %d\n", runningOriginalBytes);
    }
}

