/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.direct;

import com.android.dx.cf.code.ByteOps;
import com.android.dx.cf.code.BytecodeArray;
import com.android.dx.cf.code.SwitchList;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstDouble;
import com.android.dx.rop.cst.CstFloat;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstKnownNull;
import com.android.dx.rop.cst.CstLong;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import java.util.ArrayList;

public class CodeObserver
implements BytecodeArray.Visitor {
    private final ByteArray bytes;
    private final ParseObserver observer;

    public CodeObserver(ByteArray byteArray, ParseObserver parseObserver) {
        if (byteArray == null) {
            throw new NullPointerException("bytes == null");
        }
        if (parseObserver == null) {
            throw new NullPointerException("observer == null");
        }
        this.bytes = byteArray;
        this.observer = parseObserver;
    }

    @Override
    public void visitInvalid(int n, int n2, int n3) {
        this.observer.parsed(this.bytes, n2, n3, this.header(n2));
    }

    @Override
    public void visitNoArgs(int n, int n2, int n3, Type type) {
        this.observer.parsed(this.bytes, n2, n3, this.header(n2));
    }

    @Override
    public void visitLocal(int n, int n2, int n3, int n4, Type type, int n5) {
        String string = n3 <= 3 ? Hex.u1(n4) : Hex.u2(n4);
        boolean bl = n3 == 1;
        String string2 = "";
        if (n == 132) {
            string2 = ", #" + (n3 <= 3 ? Hex.s1(n5) : Hex.s2(n5));
        }
        String string3 = "";
        if (type.isCategory2()) {
            string3 = (bl ? "," : " //") + " category-2";
        }
        this.observer.parsed(this.bytes, n2, n3, this.header(n2) + (bl ? " // " : " ") + string + string2 + string3);
    }

    @Override
    public void visitConstant(int n, int n2, int n3, Constant constant, int n4) {
        if (constant instanceof CstKnownNull) {
            this.visitNoArgs(n, n2, n3, null);
            return;
        }
        if (constant instanceof CstInteger) {
            this.visitLiteralInt(n, n2, n3, n4);
            return;
        }
        if (constant instanceof CstLong) {
            this.visitLiteralLong(n, n2, n3, ((CstLong)constant).getValue());
            return;
        }
        if (constant instanceof CstFloat) {
            this.visitLiteralFloat(n, n2, n3, ((CstFloat)constant).getIntBits());
            return;
        }
        if (constant instanceof CstDouble) {
            this.visitLiteralDouble(n, n2, n3, ((CstDouble)constant).getLongBits());
            return;
        }
        String string = "";
        if (n4 != 0) {
            string = ", ";
            string = n == 197 ? string + Hex.u1(n4) : string + Hex.u2(n4);
        }
        this.observer.parsed(this.bytes, n2, n3, this.header(n2) + " " + constant + string);
    }

    @Override
    public void visitBranch(int n, int n2, int n3, int n4) {
        String string = n3 <= 3 ? Hex.u2(n4) : Hex.u4(n4);
        this.observer.parsed(this.bytes, n2, n3, this.header(n2) + " " + string);
    }

    @Override
    public void visitSwitch(int n, int n2, int n3, SwitchList switchList, int n4) {
        int n5 = switchList.size();
        StringBuffer stringBuffer = new StringBuffer(n5 * 20 + 100);
        stringBuffer.append(this.header(n2));
        if (n4 != 0) {
            stringBuffer.append(" // padding: " + Hex.u4(n4));
        }
        stringBuffer.append('\n');
        for (int i = 0; i < n5; ++i) {
            stringBuffer.append("  ");
            stringBuffer.append(Hex.s4(switchList.getValue(i)));
            stringBuffer.append(": ");
            stringBuffer.append(Hex.u2(switchList.getTarget(i)));
            stringBuffer.append('\n');
        }
        stringBuffer.append("  default: ");
        stringBuffer.append(Hex.u2(switchList.getDefaultTarget()));
        this.observer.parsed(this.bytes, n2, n3, stringBuffer.toString());
    }

    @Override
    public void visitNewarray(int n, int n2, CstType cstType, ArrayList<Constant> arrayList) {
        String string = n2 == 1 ? " // " : " ";
        String string2 = cstType.getClassType().getComponentType().toHuman();
        this.observer.parsed(this.bytes, n, n2, this.header(n) + string + string2);
    }

    @Override
    public void setPreviousOffset(int n) {
    }

    @Override
    public int getPreviousOffset() {
        return -1;
    }

    private String header(int n) {
        int n2 = this.bytes.getUnsignedByte(n);
        String string = ByteOps.opName(n2);
        if (n2 == 196) {
            n2 = this.bytes.getUnsignedByte(n + 1);
            string = string + " " + ByteOps.opName(n2);
        }
        return Hex.u2(n) + ": " + string;
    }

    private void visitLiteralInt(int n, int n2, int n3, int n4) {
        String string = n3 == 1 ? " // " : " ";
        n = this.bytes.getUnsignedByte(n2);
        String string2 = n3 == 1 || n == 16 ? "#" + Hex.s1(n4) : (n == 17 ? "#" + Hex.s2(n4) : "#" + Hex.s4(n4));
        this.observer.parsed(this.bytes, n2, n3, this.header(n2) + string + string2);
    }

    private void visitLiteralLong(int n, int n2, int n3, long l) {
        String string = n3 == 1 ? " // " : " #";
        String string2 = n3 == 1 ? Hex.s1((int)l) : Hex.s8(l);
        this.observer.parsed(this.bytes, n2, n3, this.header(n2) + string + string2);
    }

    private void visitLiteralFloat(int n, int n2, int n3, int n4) {
        String string = n3 != 1 ? " #" + Hex.u4(n4) : "";
        this.observer.parsed(this.bytes, n2, n3, this.header(n2) + string + " // " + Float.intBitsToFloat(n4));
    }

    private void visitLiteralDouble(int n, int n2, int n3, long l) {
        String string = n3 != 1 ? " #" + Hex.u8(l) : "";
        this.observer.parsed(this.bytes, n2, n3, this.header(n2) + string + " // " + Double.longBitsToDouble(l));
    }
}

