from __future__ import annotations
from dataclasses import dataclass, field
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, TYPE_CHECKING, Union

if TYPE_CHECKING:
    from .log_level import LogLevel
    from .named_log_configuration import NamedLogConfiguration

from .named_log_configuration import NamedLogConfiguration

@dataclass
class LogConfiguration(NamedLogConfiguration):
    # The level property
    level: Optional[LogLevel] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> LogConfiguration:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parse_node: The parse node to use to read the discriminator value and create the object
        Returns: LogConfiguration
        """
        if not parse_node:
            raise TypeError("parse_node cannot be null.")
        return LogConfiguration()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        from .log_level import LogLevel
        from .named_log_configuration import NamedLogConfiguration

        from .log_level import LogLevel
        from .named_log_configuration import NamedLogConfiguration

        fields: Dict[str, Callable[[Any], None]] = {
            "level": lambda n : setattr(self, 'level', n.get_enum_value(LogLevel)),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if not writer:
            raise TypeError("writer cannot be null.")
        super().serialize(writer)
        writer.write_enum_value("level", self.level)
    

