# How to contribute

Thank you for offering a pull request! Here's a quick guide:

## Getting Started
- Make sure you have a [GitHub](https://github.com/) account.
- Make sure you have `python` and `make` installed.
- Submit a ticket for your issue, assuming one does not already exist.
- Clearly describe the issue, including steps to reproduce when it is a bug.
- Fork the repository on GitHub.
- Create a topic branch from where you want to base your work.
- Install needed development dependencies with `make develop`

## Making Changes
- Make commits of logical units.
- Please add tests for any new features.
- Run `make lint`, `make test`, and `make coverage` to ensure all style and test checks pass.

## Submitting Changes
- Push your changes to a topic branch in your fork of the repository.
- Submit a pull request to the repository.
- Reference the pull request in the issue you've resolved.

# Additional Resources

- [General GitHub Documentation](https://help.github.com/)
- [GitHub Pull Request Documentation](https://help.github.com/articles/about-pull-requests)