# -*- coding: utf-8 -*-

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
from __future__ import unicode_literals

from django.test import TestCase
import datetime
from lck.lang import Null, nullify

from ralph.discovery.plugins import hp_oa
from ralph.discovery.models import DeviceType


class HpOaPluginTest(TestCase):
    DATA = {'INFRA2': {'ADDR': 'A9FE0111',
            'ASSET': Null,
            'BLADES': {'BAYS': {'BAY': [{'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 0,
                                         'mmYOffset': 7},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 56,
                                         'mmYOffset': 7},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 112,
                                         'mmYOffset': 7},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 168,
                                         'mmYOffset': 7},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 224,
                                         'mmYOffset': 7},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 280,
                                         'mmYOffset': 7},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 336,
                                         'mmYOffset': 7},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 392,
                                         'mmYOffset': 7},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 0,
                                         'mmYOffset': 188},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 56,
                                         'mmYOffset': 188},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 112,
                                         'mmYOffset': 188},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 168,
                                         'mmYOffset': 188},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 224,
                                         'mmYOffset': 188},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 280,
                                         'mmYOffset': 188},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 336,
                                         'mmYOffset': 188},
                                        {'SIDE': 'FRONT',
                                         'mmDepth': 480,
                                         'mmHeight': 181,
                                         'mmWidth': 56,
                                         'mmXOffset': 392,
                                         'mmYOffset': 188}]},
                       'BLADE': [{'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 1},
                                  'BSN': 'GB8849BBRD      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.151',
                                  'PORTMAP': {'MEZZ': [{'DEVICE': {'NAME': 'Emulex LPe1105-HP 4Gb FC HBA for HP c-Class BladeSystem',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:64:9a'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:64:9b'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_ONE'},
                                                        'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 1},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 1}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 1},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 1},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 1},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 1}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:22:64:9C:6F:F6',
                                                                             'iSCSI': '00:22:64:9C:6F:F7'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:22:64:9C:7F:42',
                                                                             'iSCSI': '00:22:64:9C:7F:43'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 1},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 1}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 186},
                                  'SPN': 'ProLiant BL460c G1',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 20,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 38,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 43,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '447707GB8849BBRD',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '37373434-3730-4247-3838-343942425244'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 2},
                                  'BSN': 'CZJ70601RN      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.152',
                                  'PORTMAP': {'MEZZ': [{'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 2},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 2}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'DEVICE': {'NAME': 'QLogic QMH2462 4Gb FC HBA for HP c-Class BladeSystem',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'UNKNOWN',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '50:01:10:a0:00:19:b5:a0'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'UNKNOWN',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '50:01:10:a0:00:19:b5:a2'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_ONE'},
                                                        'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 2},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 2},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 2},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 2}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:1A:4B:D0:DC:14',
                                                                             'iSCSI': '00:1A:4B:D0:DC:15'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:1A:4B:D0:CC:0E',
                                                                             'iSCSI': '00:1A:4B:D0:CC:0F'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 2},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 2}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 309},
                                  'SPN': 'ProLiant BL460c G1',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 20,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 38,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 43,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '416656CZJ70601RN',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '36363134-3635-5A43-4A37-30363031524E'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 3},
                                  'BSN': 'GB8926V80C      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.153',
                                  'PORTMAP': {'MEZZ': [{'DEVICE': {'NAME': 'QLogic QMH2462 4Gb FC HBA for HP c-Class BladeSystem',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '50:01:43:80:03:b9:e7:c0'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '50:01:43:80:03:b9:e7:c2'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_ONE'},
                                                        'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 3},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 3}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 3},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 3},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 3},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 3}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Flex-10 Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:14:68',
                                                                             'iSCSI': '00:25:B3:A3:14:69'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:14:6C',
                                                                             'iSCSI': '00:25:B3:A3:14:6D'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 3},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 3}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 232},
                                  'SPN': 'ProLiant BL460c G6',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 20,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 42,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 46,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '507864GB8926V80C',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '38373035-3436-4247-3839-323656383043'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 4},
                                  'BSN': 'GB8908J72D      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.154',
                                  'PORTMAP': {'MEZZ': [{'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 4},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 4}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 4},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 4},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 4},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 4}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:23:7D:A9:2A:76',
                                                                             'iSCSI': '00:23:7D:A9:2A:77'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:23:7D:A9:2A:70',
                                                                             'iSCSI': '00:23:7D:A9:2A:71'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 4},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 4}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 227},
                                  'SPN': 'ProLiant BL460c G1',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 20,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 38,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 43,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '447707GB8908J72D',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '37373434-3730-4247-3839-30384A373244'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 5},
                                  'BSN': 'CZJ70601PU      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.155',
                                  'PORTMAP': {'MEZZ': [{'DEVICE': {'NAME': 'QLogic QMH2462 4Gb FC HBA for HP c-Class BladeSystem',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '50:01:10:a0:00:19:b2:a8'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '50:01:10:a0:00:19:b2:aa'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_ONE'},
                                                        'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 5},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 5}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 5},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 5},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 5},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 5}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:1A:4B:D0:B5:64',
                                                                             'iSCSI': '00:1A:4B:D0:B5:65'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:1A:4B:D0:B5:70',
                                                                             'iSCSI': '00:1A:4B:D0:B5:71'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 5},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 5}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 304},
                                  'SPN': 'ProLiant BL460c G1',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 19,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 38,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 43,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '416656CZJ70601PU',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '36363134-3635-5A43-4A37-303630315055'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 6},
                                  'BSN': 'GB8908J72R      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.156',
                                  'PORTMAP': {'MEZZ': [{'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 6},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 6}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 6},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 6},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 6},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 6}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:23:7D:A9:2B:B0',
                                                                             'iSCSI': '00:23:7D:A9:2B:B1'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:23:7D:A9:2B:B2',
                                                                             'iSCSI': '00:23:7D:A9:2B:B3'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 6},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 6}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 223},
                                  'SPN': 'ProLiant BL460c G1',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 20,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 38,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 43,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '447707GB8908J72R',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '37373434-3730-4247-3839-30384A373252'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 7},
                                  'BSN': 'GB8926V807      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.157',
                                  'PORTMAP': {'MEZZ': [{'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 7},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 7}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 7},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 7},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 7},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 7}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Flex-10 Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:24:81:AE:C0:98',
                                                                             'iSCSI': '00:24:81:AE:C0:99'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:24:81:AE:C0:9C',
                                                                             'iSCSI': '00:24:81:AE:C0:9D'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 7},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 7}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 229},
                                  'SPN': 'ProLiant BL460c G6',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 21,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 42,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 46,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '507864GB8926V807',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '38373035-3436-4247-3839-323656383037'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 8},
                                  'BSN': 'GB8926V7WH      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.158',
                                  'PORTMAP': {'MEZZ': [{'DEVICE': {'NAME': 'Emulex LPe1105-HP 4Gb FC HBA for HP c-Class BladeSystem',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:fc:2c'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:fc:2d'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_ONE'},
                                                        'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 8},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 8}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 8},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 8},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 8},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 8}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Flex-10 Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:6D:38',
                                                                             'iSCSI': '00:25:B3:A3:6D:39'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:6D:3C',
                                                                             'iSCSI': '00:25:B3:A3:6D:3D'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 8},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 8}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 227},
                                  'SPN': 'ProLiant BL460c G6',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 22,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 42,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 46,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '507864GB8926V7WH',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '38373035-3436-4247-3839-323656375748'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 9},
                                  'BSN': 'GB8926V82E      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.159',
                                  'PORTMAP': {'MEZZ': [{'DEVICE': {'NAME': 'Emulex LPe1105-HP 4Gb FC HBA for HP c-Class BladeSystem',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:b9:82'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:b9:83'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_ONE'},
                                                        'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 9},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 9}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 9},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 9},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 9},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 9}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Flex-10 Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:A2:88',
                                                                             'iSCSI': '00:25:B3:A3:A2:89'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:A2:8C',
                                                                             'iSCSI': '00:25:B3:A3:A2:8D'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 9},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 9}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 237},
                                  'SPN': 'ProLiant BL460c G6',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 26,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 42,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 46,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '507864GB8926V82E',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '38373035-3436-4247-3839-323656383245'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 10},
                                  'BSN': 'GB8926V7X3      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.160',
                                  'PORTMAP': {'MEZZ': [{'DEVICE': {'NAME': 'QLogic QMH2462 4Gb FC HBA for HP c-Class BladeSystem',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '50:01:10:a0:00:19:aa:cc'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '50:01:10:a0:00:19:aa:ce'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_ONE'},
                                                        'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 10},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 10}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 10},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 10},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 10},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 10}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Flex-10 Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:54:E0',
                                                                             'iSCSI': '00:25:B3:A3:54:E1'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:54:E4',
                                                                             'iSCSI': '00:25:B3:A3:54:E5'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 10},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 10}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 225},
                                  'SPN': 'ProLiant BL460c G6',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 24,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 42,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 46,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '507864GB8926V7X3',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '38373035-3436-4247-3839-323656375833'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 11},
                                  'BSN': 'GB8926V81D      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.161',
                                  'PORTMAP': {'MEZZ': [{'DEVICE': {'NAME': 'Emulex LPe1105-HP 4Gb FC HBA for HP c-Class BladeSystem',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:fc:24'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:fc:25'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_ONE'},
                                                        'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 11},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 11}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 11},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 11},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 11},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 11}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Flex-10 Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:24:81:AE:F1:78',
                                                                             'iSCSI': '00:24:81:AE:F1:79'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:24:81:AE:F1:7C',
                                                                             'iSCSI': '00:24:81:AE:F1:7D'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 11},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 11}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 228},
                                  'SPN': 'ProLiant BL460c G6',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 26,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 42,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 46,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '507864GB8926V81D',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '38373035-3436-4247-3839-323656383144'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 12},
                                  'BSN': 'GB8926V800      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.162',
                                  'PORTMAP': {'MEZZ': [{'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 12},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 12}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 12},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 12},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 12},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 12}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Flex-10 Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:15:20',
                                                                             'iSCSI': '00:25:B3:A3:15:21'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:15:24',
                                                                             'iSCSI': '00:25:B3:A3:15:25'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 12},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 12}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 193},
                                  'SPN': 'ProLiant BL460c G6',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 26,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 42,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 46,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '507864GB8926V800',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '38373035-3436-4247-3839-323656383030'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 13},
                                  'BSN': 'GB8926V7XT      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.163',
                                  'PORTMAP': {'MEZZ': [{'DEVICE': {'NAME': 'Emulex LPe1105-HP 4Gb FC HBA for HP c-Class BladeSystem',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:b4:2e'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:b4:2f'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_ONE'},
                                                        'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 13},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 13}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 13},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 13},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 13},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 13}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Flex-10 Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:24:81:AD:DD:08',
                                                                             'iSCSI': '00:24:81:AD:DD:09'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:24:81:AD:DD:0C',
                                                                             'iSCSI': '00:24:81:AD:DD:0D'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 13},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 13}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 239},
                                  'SPN': 'ProLiant BL460c G6',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 25,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 42,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 46,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '507864GB8926V7XT',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '38373035-3436-4247-3839-323656375854'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 14},
                                  'BSN': 'GB8926V7XL      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.164',
                                  'PORTMAP': {'MEZZ': [{'DEVICE': {'NAME': 'Emulex LPe1105-HP 4Gb FC HBA for HP c-Class BladeSystem',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:b5:46'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:b5:47'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_ONE'},
                                                        'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 14},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 14}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 14},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 14},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 14},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 14}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Flex-10 Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:7D:08',
                                                                             'iSCSI': '00:25:B3:A3:7D:09'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:7D:0C',
                                                                             'iSCSI': '00:25:B3:A3:7D:0D'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 14},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 14}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 489},
                                  'SPN': 'ProLiant BL460c G6',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 23,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 42,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 46,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '507864GB8926V7XL',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '38373035-3436-4247-3839-32365637584C'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 15},
                                  'BSN': 'GB8926V7Y9      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.165',
                                  'PORTMAP': {'MEZZ': [{'DEVICE': {'NAME': 'Emulex LPe1105-HP 4Gb FC HBA for HP c-Class BladeSystem',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:99:cc'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '10:00:00:00:c9:81:99:cd'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_ONE'},
                                                        'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 15},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 15}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 15},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 15},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 15},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 15}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Flex-10 Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:1C:A0',
                                                                             'iSCSI': '00:25:B3:A3:1C:A1'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:1C:A4',
                                                                             'iSCSI': '00:25:B3:A3:1C:A5'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 15},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 15}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 221},
                                  'SPN': 'ProLiant BL460c G6',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 23,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 42,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 46,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '507864GB8926V7Y9',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '38373035-3436-4247-3839-323656375939'},
                                 {'ASSOCIATEDBLADE': 0,
                                  'BAY': {'CONNECTION': 16},
                                  'BSN': 'GB8926V80S      ',
                                  'CONJOINABLE': 'false',
                                  'DIAG': {'AC': 'NOT_RELEVANT',
                                           'Cooling': 'NO_ERROR',
                                           'Degraded': 'NO_ERROR',
                                           'FRU': 'NO_ERROR',
                                           'Failure': 'NO_ERROR',
                                           'Keying': 'NO_ERROR',
                                           'Location': 'NOT_TESTED',
                                           'MgmtProc': 'NO_ERROR',
                                           'Power': 'NO_ERROR',
                                           'i2c': 'NOT_RELEVANT',
                                           'oaRedundancy': 'NOT_RELEVANT',
                                           'thermalDanger': 'NOT_TESTED',
                                           'thermalWarning': 'NOT_TESTED'},
                                  'MANUFACTURER': 'HP',
                                  'MGMTIPADDR': '10.235.28.166',
                                  'PORTMAP': {'MEZZ': [{'DEVICE': {'NAME': 'QLogic QMH2462 4Gb FC HBA for HP c-Class BladeSystem',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '50:01:43:80:03:b9:ee:b0'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_FIB',
                                                                             'WWPN': '50:01:43:80:03:b9:ee:b2'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_ONE'},
                                                        'NUMBER': 1,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 3,
                                                                           'TRAYPORTNUMBER': 16},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 4,
                                                                           'TRAYPORTNUMBER': 16}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_ONE'}},
                                                       {'NUMBER': 2,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 5,
                                                                           'TRAYPORTNUMBER': 16},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 6,
                                                                           'TRAYPORTNUMBER': 16},
                                                                          {'NUMBER': 3,
                                                                           'TRAYBAYNUMBER': 7,
                                                                           'TRAYPORTNUMBER': 16},
                                                                          {'NUMBER': 4,
                                                                           'TRAYBAYNUMBER': 8,
                                                                           'TRAYPORTNUMBER': 16}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_TWO'}},
                                                       {'DEVICE': {'NAME': 'Flex-10 Embedded Ethernet',
                                                                   'PORT': [{'NUMBER': 1,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:83:90',
                                                                             'iSCSI': '00:25:B3:A3:83:91'},
                                                                            {'NUMBER': 2,
                                                                             'STATUS': 'OK',
                                                                             'TYPE': 'INTERCONNECT_TYPE_ETH',
                                                                             'WWPN': '00:25:B3:A3:83:94',
                                                                             'iSCSI': '00:25:B3:A3:83:95'}],
                                                                   'STATUS': 'OK',
                                                                   'TYPE': 'MEZZ_DEV_TYPE_FIXED'},
                                                        'NUMBER': 9,
                                                        'SLOT': {'PORT': [{'NUMBER': 1,
                                                                           'TRAYBAYNUMBER': 1,
                                                                           'TRAYPORTNUMBER': 16},
                                                                          {'NUMBER': 2,
                                                                           'TRAYBAYNUMBER': 2,
                                                                           'TRAYPORTNUMBER': 16}],
                                                                 'TYPE': 'MEZZ_SLOT_TYPE_FIXED'}}],
                                              'STATUS': 'OK'},
                                  'POWER': {'POWERMODE': 'UNKNOWN',
                                            'POWERSTATE': 'ON',
                                            'POWER_CONSUMED': 232},
                                  'SPN': 'ProLiant BL460c G6',
                                  'STATUS': 'OK',
                                  'TEMPS': {'TEMP': {'C': 24,
                                                     'DESC': 'AMBIENT',
                                                     'LOCATION': 14,
                                                     'THRESHOLD': [{'C': 42,
                                                                    'DESC': 'CAUTION',
                                                                    'STATUS': 'Degraded'},
                                                                   {'C': 46,
                                                                    'DESC': 'CRITICAL',
                                                                    'STATUS': 'Non-Recoverable Error'}]}},
                                  'TYPE': 'SERVER',
                                  'UIDSTATUS': 'OFF',
                                  'UUID': '507864GB8926V80S',
                                  'VMSTAT': {'CDROMSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'CDROMURL': Null,
                                             'FLOPPYSTAT': 'VM_DEV_STATUS_DISCONNECTED',
                                             'FLOPPYURL': Null,
                                             'SUPPORT': 'VM_SUPPORTED'},
                                  'cUUID': '38373035-3436-4247-3839-323656383053'}]},
            'DATETIME': datetime.datetime(2012, 7, 11, 19, 6, 20),
            'DIAG': {'AC': 'NOT_RELEVANT',
                     'Cooling': 'NOT_RELEVANT',
                     'Degraded': 'NOT_TESTED',
                     'FRU': 'NO_ERROR',
                     'Failure': 'NOT_TESTED',
                     'Keying': 'NOT_RELEVANT',
                     'Location': 'NOT_RELEVANT',
                     'MgmtProc': 'NOT_RELEVANT',
                     'Power': 'NOT_RELEVANT',
                     'i2c': 'NOT_RELEVANT',
                     'oaRedundancy': 'NO_ERROR',
                     'thermalDanger': 'NOT_RELEVANT',
                     'thermalWarning': 'NOT_RELEVANT'},
            'DIM': {'mmDepth': 756, 'mmHeight': 445, 'mmWidth': 444},
            'ENCL': 'HP_Blade_208-3',
            'ENCL_SN': '9B8925V2C9',
            'FANS': {'BAYS': {'BAY': [{'SIDE': 'REAR',
                                       'mmDepth': 194,
                                       'mmHeight': 93,
                                       'mmWidth': 78,
                                       'mmXOffset': 20,
                                       'mmYOffset': 0},
                                      {'SIDE': 'REAR',
                                       'mmDepth': 194,
                                       'mmHeight': 93,
                                       'mmWidth': 78,
                                       'mmXOffset': 98,
                                       'mmYOffset': 0},
                                      {'SIDE': 'REAR',
                                       'mmDepth': 194,
                                       'mmHeight': 93,
                                       'mmWidth': 78,
                                       'mmXOffset': 176,
                                       'mmYOffset': 0},
                                      {'SIDE': 'REAR',
                                       'mmDepth': 194,
                                       'mmHeight': 93,
                                       'mmWidth': 78,
                                       'mmXOffset': 254,
                                       'mmYOffset': 0},
                                      {'SIDE': 'REAR',
                                       'mmDepth': 194,
                                       'mmHeight': 93,
                                       'mmWidth': 78,
                                       'mmXOffset': 332,
                                       'mmYOffset': 0},
                                      {'SIDE': 'REAR',
                                       'mmDepth': 194,
                                       'mmHeight': 93,
                                       'mmWidth': 78,
                                       'mmXOffset': 20,
                                       'mmYOffset': 261},
                                      {'SIDE': 'REAR',
                                       'mmDepth': 194,
                                       'mmHeight': 93,
                                       'mmWidth': 78,
                                       'mmXOffset': 98,
                                       'mmYOffset': 261},
                                      {'SIDE': 'REAR',
                                       'mmDepth': 194,
                                       'mmHeight': 93,
                                       'mmWidth': 78,
                                       'mmXOffset': 176,
                                       'mmYOffset': 261},
                                      {'SIDE': 'REAR',
                                       'mmDepth': 194,
                                       'mmHeight': 93,
                                       'mmWidth': 78,
                                       'mmXOffset': 254,
                                       'mmYOffset': 261},
                                      {'SIDE': 'REAR',
                                       'mmDepth': 194,
                                       'mmHeight': 93,
                                       'mmWidth': 78,
                                       'mmXOffset': 332,
                                       'mmYOffset': 261}]},
                     'FAN': [{'BAY': {'CONNECTION': 1},
                              'PN': '412140-B21',
                              'PRODUCTNAME': 'Active Cool 200 Fan',
                              'PWR_USED': 17,
                              'RPM_CUR': 8498,
                              'RPM_MAX': 18000,
                              'RPM_MIN': 10,
                              'STATUS': 'OK'},
                             {'BAY': {'CONNECTION': 2},
                              'PN': '412140-B21',
                              'PRODUCTNAME': 'Active Cool 200 Fan',
                              'PWR_USED': 15,
                              'RPM_CUR': 8499,
                              'RPM_MAX': 18000,
                              'RPM_MIN': 10,
                              'STATUS': 'OK'},
                             {'BAY': {'CONNECTION': 3},
                              'PN': '412140-B21',
                              'PRODUCTNAME': 'Active Cool 200 Fan',
                              'PWR_USED': 20,
                              'RPM_CUR': 8500,
                              'RPM_MAX': 18000,
                              'RPM_MIN': 10,
                              'STATUS': 'OK'},
                             {'BAY': {'CONNECTION': 4},
                              'PN': '412140-B21',
                              'PRODUCTNAME': 'Active Cool 200 Fan',
                              'PWR_USED': 13,
                              'RPM_CUR': 8300,
                              'RPM_MAX': 18000,
                              'RPM_MIN': 10,
                              'STATUS': 'OK'},
                             {'BAY': {'CONNECTION': 5},
                              'PN': '412140-B21',
                              'PRODUCTNAME': 'Active Cool 200 Fan',
                              'PWR_USED': 20,
                              'RPM_CUR': 8300,
                              'RPM_MAX': 18000,
                              'RPM_MIN': 10,
                              'STATUS': 'OK'},
                             {'BAY': {'CONNECTION': 6},
                              'PN': '412140-B21',
                              'PRODUCTNAME': 'Active Cool 200 Fan',
                              'PWR_USED': 12,
                              'RPM_CUR': 7000,
                              'RPM_MAX': 18000,
                              'RPM_MIN': 10,
                              'STATUS': 'OK'},
                             {'BAY': {'CONNECTION': 7},
                              'PN': '412140-B21',
                              'PRODUCTNAME': 'Active Cool 200 Fan',
                              'PWR_USED': 10,
                              'RPM_CUR': 7000,
                              'RPM_MAX': 18000,
                              'RPM_MIN': 10,
                              'STATUS': 'OK'},
                             {'BAY': {'CONNECTION': 8},
                              'PN': '412140-B21',
                              'PRODUCTNAME': 'Active Cool 200 Fan',
                              'PWR_USED': 12,
                              'RPM_CUR': 7160,
                              'RPM_MAX': 18000,
                              'RPM_MIN': 10,
                              'STATUS': 'OK'},
                             {'BAY': {'CONNECTION': 9},
                              'PN': '412140-B21',
                              'PRODUCTNAME': 'Active Cool 200 Fan',
                              'PWR_USED': 10,
                              'RPM_CUR': 7147,
                              'RPM_MAX': 18000,
                              'RPM_MIN': 10,
                              'STATUS': 'OK'},
                             {'BAY': {'CONNECTION': 10},
                              'PN': '412140-B21',
                              'PRODUCTNAME': 'Active Cool 200 Fan',
                              'PWR_USED': 11,
                              'RPM_CUR': 7160,
                              'RPM_MAX': 18000,
                              'RPM_MIN': 10,
                              'STATUS': 'OK'}],
                     'NEEDED_FANS': 9,
                     'REDUNDANCY': 'REDUNDANT',
                     'STATUS': 'OK',
                     'WANTED_FANS': 10},
            'LCDS': {'BAYS': {'BAY': {'SIDE': 'FRONT',
                                      'mmDepth': 15,
                                      'mmHeight': 55,
                                      'mmWidth': 92,
                                      'mmXOffset': 145,
                                      'mmYOffset': 365}},
                     'LCD': {'BAY': {'CONNECTION': 1},
                             'BUTTON_LOCK_ENABLED': 'false',
                             'DIAG': {'AC': 'NOT_RELEVANT',
                                      'Cooling': 'NOT_RELEVANT',
                                      'Degraded': 'NOT_TESTED',
                                      'FRU': 'NO_ERROR',
                                      'Failure': 'NOT_TESTED',
                                      'Keying': 'NOT_RELEVANT',
                                      'Location': 'NOT_RELEVANT',
                                      'MgmtProc': 'NOT_RELEVANT',
                                      'Power': 'NOT_RELEVANT',
                                      'i2c': 'NOT_RELEVANT',
                                      'oaRedundancy': 'NOT_RELEVANT',
                                      'thermalDanger': 'NOT_RELEVANT',
                                      'thermalWarning': 'NOT_RELEVANT'},
                             'FWRI': '2.2.2',
                             'IMAGE_URL': '/cgi-bin/getLCDImage?oaSessionKey=',
                             'MANUFACTURER': 'HP',
                             'PIN_ENABLED': 'false',
                             'PN': '441203-001',
                             'SPN': 'BladeSystem c7000 Insight Display',
                             'STATUS': 'OK',
                             'USERNOTES': 'Touch my^balls^^^^'}},
            'MANAGERS': {'BAYS': {'BAY': [{'SIDE': 'REAR',
                                           'mmDepth': 177,
                                           'mmHeight': 21,
                                           'mmWidth': 160,
                                           'mmXOffset': 0,
                                           'mmYOffset': 225},
                                          {'SIDE': 'REAR',
                                           'mmDepth': 177,
                                           'mmHeight': 21,
                                           'mmWidth': 160,
                                           'mmXOffset': 255,
                                           'mmYOffset': 225}]},
                         'MANAGER': [{'BAY': {'CONNECTION': 1},
                                      'BSN': 'OB93BP1773    ',
                                      'DIAG': {'AC': 'NOT_RELEVANT',
                                               'Cooling': 'NOT_RELEVANT',
                                               'Degraded': 'NOT_TESTED',
                                               'FRU': 'NO_ERROR',
                                               'Failure': 'NOT_TESTED',
                                               'Keying': 'NOT_RELEVANT',
                                               'Location': 'NOT_RELEVANT',
                                               'MgmtProc': 'NOT_TESTED',
                                               'Power': 'NOT_RELEVANT',
                                               'i2c': 'NOT_RELEVANT',
                                               'oaRedundancy': 'NOT_TESTED',
                                               'thermalDanger': 'NOT_RELEVANT',
                                               'thermalWarning': 'NOT_RELEVANT'},
                                      'FWRI': 3.32,
                                      'IPV6STATUS': 'DISABLED',
                                      'MACADDR': '00:24:81:A4:3D:A9',
                                      'MANUFACTURER': 'HP',
                                      'MGMTIPADDR': '10.235.28.31',
                                      'NAME': 'OA-002481A43DA9',
                                      'POWER': {'POWERSTATE': 'ON'},
                                      'ROLE': 'ACTIVE',
                                      'SPN': 'BladeSystem c7000 DDR2 Onboard Administrator with KVM',
                                      'STATUS': 'OK',
                                      'TEMPS': {'TEMP': {'C': 41,
                                                         'DESC': 'AMBIENT',
                                                         'LOCATION': 17,
                                                         'THRESHOLD': [{'C': 75,
                                                                        'DESC': 'CAUTION',
                                                                        'STATUS': 'Degraded'},
                                                                       {'C': 80,
                                                                        'DESC': 'CRITICAL',
                                                                        'STATUS': 'Non-Recoverable Error'}]}},
                                      'UIDSTATUS': 'OFF',
                                      'UUID': '09OB93BP1773    ',
                                      'WIZARDSTATUS': 'WIZARD_SETUP_COMPLETE',
                                      'YOUAREHERE': 'true'},
                                     {'BAY': {'CONNECTION': 2},
                                      'BSN': 'OB94BP2794    ',
                                      'DIAG': {'AC': 'NOT_RELEVANT',
                                               'Cooling': 'NOT_RELEVANT',
                                               'Degraded': 'NOT_TESTED',
                                               'FRU': 'NO_ERROR',
                                               'Failure': 'NOT_TESTED',
                                               'Keying': 'NOT_RELEVANT',
                                               'Location': 'NOT_RELEVANT',
                                               'MgmtProc': 'NOT_TESTED',
                                               'Power': 'NOT_RELEVANT',
                                               'i2c': 'NOT_RELEVANT',
                                               'oaRedundancy': 'NOT_TESTED',
                                               'thermalDanger': 'NOT_RELEVANT',
                                               'thermalWarning': 'NOT_RELEVANT'},
                                      'FWRI': 3.32,
                                      'IPV6STATUS': 'DISABLED',
                                      'MACADDR': '00:24:81:AE:28:3B',
                                      'MANUFACTURER': 'HP',
                                      'MGMTIPADDR': '10.235.28.32',
                                      'NAME': 'OA-002481AE283B',
                                      'POWER': {'POWERSTATE': 'ON'},
                                      'ROLE': 'STANDBY',
                                      'SPN': 'BladeSystem c7000 DDR2 Onboard Administrator with KVM',
                                      'STATUS': 'OK',
                                      'TEMPS': {'TEMP': {'C': 42,
                                                         'DESC': 'AMBIENT',
                                                         'LOCATION': 17,
                                                         'THRESHOLD': [{'C': 75,
                                                                        'DESC': 'CAUTION',
                                                                        'STATUS': 'Degraded'},
                                                                       {'C': 80,
                                                                        'DESC': 'CRITICAL',
                                                                        'STATUS': 'Non-Recoverable Error'}]}},
                                      'UIDSTATUS': 'OFF',
                                      'UUID': '09OB94BP2794    ',
                                      'WIZARDSTATUS': 'WIZARD_SETUP_COMPLETE',
                                      'YOUAREHERE': 'false'}]},
            'PART': '507019-B21',
            'PN': 'BladeSystem c7000 Enclosure G2',
            'POWER': {'BAYS': {'BAY': [{'SIDE': 'FRONT',
                                        'mmDepth': 700,
                                        'mmHeight': 56,
                                        'mmWidth': 70,
                                        'mmXOffset': 0,
                                        'mmYOffset': 365},
                                       {'SIDE': 'FRONT',
                                        'mmDepth': 700,
                                        'mmHeight': 56,
                                        'mmWidth': 70,
                                        'mmXOffset': 70,
                                        'mmYOffset': 365},
                                       {'SIDE': 'FRONT',
                                        'mmDepth': 700,
                                        'mmHeight': 56,
                                        'mmWidth': 70,
                                        'mmXOffset': 140,
                                        'mmYOffset': 365},
                                       {'SIDE': 'FRONT',
                                        'mmDepth': 700,
                                        'mmHeight': 56,
                                        'mmWidth': 70,
                                        'mmXOffset': 210,
                                        'mmYOffset': 365},
                                       {'SIDE': 'FRONT',
                                        'mmDepth': 700,
                                        'mmHeight': 56,
                                        'mmWidth': 70,
                                        'mmXOffset': 280,
                                        'mmYOffset': 365},
                                       {'SIDE': 'FRONT',
                                        'mmDepth': 700,
                                        'mmHeight': 56,
                                        'mmWidth': 70,
                                        'mmXOffset': 350,
                                        'mmYOffset': 365}]},
                      'CAPACITY': 7200,
                      'DYNAMICPOWERSAVER': 'true',
                      'NEEDED_PS': 2,
                      'OUTPUT_POWER': 12228,
                      'PDU': '413374-B21',
                      'POWERONFLAG': 'false',
                      'POWERSUPPLY': [{'ACINPUT': 'OK',
                                       'ACTUALOUTPUT': 543,
                                       'BAY': {'CONNECTION': 1},
                                       'CAPACITY': 2400,
                                       'DIAG': {'AC': 'NO_ERROR',
                                                'Cooling': 'NOT_RELEVANT',
                                                'Degraded': 'NOT_TESTED',
                                                'FRU': 'NO_ERROR',
                                                'Failure': 'NO_ERROR',
                                                'Keying': 'NOT_RELEVANT',
                                                'Location': 'NOT_TESTED',
                                                'MgmtProc': 'NOT_RELEVANT',
                                                'Power': 'NOT_RELEVANT',
                                                'i2c': 'NOT_RELEVANT',
                                                'oaRedundancy': 'NOT_RELEVANT',
                                                'thermalDanger': 'NOT_RELEVANT',
                                                'thermalWarning': 'NOT_RELEVANT'},
                                       'FWRI': 0.0,
                                       'PN': '499253-B21',
                                       'SN': '5AGUD0AHLWY1Q5',
                                       'STATUS': 'OK'},
                                      {'ACINPUT': 'OK',
                                       'ACTUALOUTPUT': 543,
                                       'BAY': {'CONNECTION': 2},
                                       'CAPACITY': 2400,
                                       'DIAG': {'AC': 'NO_ERROR',
                                                'Cooling': 'NOT_RELEVANT',
                                                'Degraded': 'NOT_TESTED',
                                                'FRU': 'NO_ERROR',
                                                'Failure': 'NO_ERROR',
                                                'Keying': 'NOT_RELEVANT',
                                                'Location': 'NOT_TESTED',
                                                'MgmtProc': 'NOT_RELEVANT',
                                                'Power': 'NOT_RELEVANT',
                                                'i2c': 'NOT_RELEVANT',
                                                'oaRedundancy': 'NOT_RELEVANT',
                                                'thermalDanger': 'NOT_RELEVANT',
                                                'thermalWarning': 'NOT_RELEVANT'},
                                       'FWRI': 0.0,
                                       'PN': '499253-B21',
                                       'SN': '5AGUD0AHLX10GO',
                                       'STATUS': 'OK'},
                                      {'ACINPUT': 'OK',
                                       'ACTUALOUTPUT': 0,
                                       'BAY': {'CONNECTION': 3},
                                       'CAPACITY': 2400,
                                       'DIAG': {'AC': 'NO_ERROR',
                                                'Cooling': 'NOT_RELEVANT',
                                                'Degraded': 'NOT_TESTED',
                                                'FRU': 'NO_ERROR',
                                                'Failure': 'NO_ERROR',
                                                'Keying': 'NOT_RELEVANT',
                                                'Location': 'NOT_TESTED',
                                                'MgmtProc': 'NOT_RELEVANT',
                                                'Power': 'NOT_RELEVANT',
                                                'i2c': 'NOT_RELEVANT',
                                                'oaRedundancy': 'NOT_RELEVANT',
                                                'thermalDanger': 'NOT_RELEVANT',
                                                'thermalWarning': 'NOT_RELEVANT'},
                                       'FWRI': 0.0,
                                       'PN': '499253-B21',
                                       'SN': '5AGUD0AHLX11UY',
                                       'STATUS': 'OK'},
                                      {'ACINPUT': 'OK',
                                       'ACTUALOUTPUT': 543,
                                       'BAY': {'CONNECTION': 4},
                                       'CAPACITY': 2400,
                                       'DIAG': {'AC': 'NO_ERROR',
                                                'Cooling': 'NOT_RELEVANT',
                                                'Degraded': 'NOT_TESTED',
                                                'FRU': 'NO_ERROR',
                                                'Failure': 'NO_ERROR',
                                                'Keying': 'NOT_RELEVANT',
                                                'Location': 'NOT_TESTED',
                                                'MgmtProc': 'NOT_RELEVANT',
                                                'Power': 'NOT_RELEVANT',
                                                'i2c': 'NOT_RELEVANT',
                                                'oaRedundancy': 'NOT_RELEVANT',
                                                'thermalDanger': 'NOT_RELEVANT',
                                                'thermalWarning': 'NOT_RELEVANT'},
                                       'FWRI': 0.0,
                                       'PN': '499253-B21',
                                       'SN': '5AGUD0AHLX11WW',
                                       'STATUS': 'OK'},
                                      {'ACINPUT': 'OK',
                                       'ACTUALOUTPUT': 543,
                                       'BAY': {'CONNECTION': 5},
                                       'CAPACITY': 2400,
                                       'DIAG': {'AC': 'NO_ERROR',
                                                'Cooling': 'NOT_RELEVANT',
                                                'Degraded': 'NOT_TESTED',
                                                'FRU': 'NO_ERROR',
                                                'Failure': 'NO_ERROR',
                                                'Keying': 'NOT_RELEVANT',
                                                'Location': 'NOT_TESTED',
                                                'MgmtProc': 'NOT_RELEVANT',
                                                'Power': 'NOT_RELEVANT',
                                                'i2c': 'NOT_RELEVANT',
                                                'oaRedundancy': 'NOT_RELEVANT',
                                                'thermalDanger': 'NOT_RELEVANT',
                                                'thermalWarning': 'NOT_RELEVANT'},
                                       'FWRI': 0.0,
                                       'PN': '499253-B21',
                                       'SN': '5AGUD0AHLX10DK',
                                       'STATUS': 'OK'},
                                      {'ACINPUT': 'OK',
                                       'ACTUALOUTPUT': 0,
                                       'BAY': {'CONNECTION': 6},
                                       'CAPACITY': 2400,
                                       'DIAG': {'AC': 'NO_ERROR',
                                                'Cooling': 'NOT_RELEVANT',
                                                'Degraded': 'NOT_TESTED',
                                                'FRU': 'NO_ERROR',
                                                'Failure': 'NO_ERROR',
                                                'Keying': 'NOT_RELEVANT',
                                                'Location': 'NOT_TESTED',
                                                'MgmtProc': 'NOT_RELEVANT',
                                                'Power': 'NOT_RELEVANT',
                                                'i2c': 'NOT_RELEVANT',
                                                'oaRedundancy': 'NOT_RELEVANT',
                                                'thermalDanger': 'NOT_RELEVANT',
                                                'thermalWarning': 'NOT_RELEVANT'},
                                       'FWRI': 0.0,
                                       'PN': '499253-B21',
                                       'SN': '5AGUD0AHLWY1Y7',
                                       'STATUS': 'OK'}],
                      'POWER_CONSUMED': 4691,
                      'REDUNDANCY': 'REDUNDANT',
                      'REDUNDANCYMODE': 'AC_REDUNDANT',
                      'REDUNDANT_CAPACITY': 2509,
                      'STATUS': 'OK',
                      'TYPE': 'INTERNAL_DC',
                      'WANTED_PS': 4},
            'RACK': 'Rack_208',
            'SOLUTIONSID': 0,
            'STATUS': 'OK',
            'SWITCHES': {'BAYS': {'BAY': [{'SIDE': 'REAR',
                                           'mmDepth': 268,
                                           'mmHeight': 28,
                                           'mmWidth': 193,
                                           'mmXOffset': 0,
                                           'mmYOffset': 95},
                                          {'SIDE': 'REAR',
                                           'mmDepth': 268,
                                           'mmHeight': 28,
                                           'mmWidth': 193,
                                           'mmXOffset': 193,
                                           'mmYOffset': 95},
                                          {'SIDE': 'REAR',
                                           'mmDepth': 268,
                                           'mmHeight': 28,
                                           'mmWidth': 193,
                                           'mmXOffset': 0,
                                           'mmYOffset': 123},
                                          {'SIDE': 'REAR',
                                           'mmDepth': 268,
                                           'mmHeight': 28,
                                           'mmWidth': 193,
                                           'mmXOffset': 193,
                                           'mmYOffset': 123},
                                          {'SIDE': 'REAR',
                                           'mmDepth': 268,
                                           'mmHeight': 28,
                                           'mmWidth': 193,
                                           'mmXOffset': 0,
                                           'mmYOffset': 151},
                                          {'SIDE': 'REAR',
                                           'mmDepth': 268,
                                           'mmHeight': 28,
                                           'mmWidth': 193,
                                           'mmXOffset': 193,
                                           'mmYOffset': 151},
                                          {'SIDE': 'REAR',
                                           'mmDepth': 268,
                                           'mmHeight': 28,
                                           'mmWidth': 193,
                                           'mmXOffset': 0,
                                           'mmYOffset': 179},
                                          {'SIDE': 'REAR',
                                           'mmDepth': 268,
                                           'mmHeight': 28,
                                           'mmWidth': 193,
                                           'mmXOffset': 193,
                                           'mmYOffset': 179}]},
                         'SWITCH': [{'BAY': {'CONNECTION': 1},
                                     'BSN': 'FOC1316T07G',
                                     'DIAG': {'AC': 'NOT_RELEVANT',
                                              'Cooling': 'NOT_RELEVANT',
                                              'Degraded': 'NO_ERROR',
                                              'FRU': 'NO_ERROR',
                                              'Failure': 'NO_ERROR',
                                              'Keying': 'NO_ERROR',
                                              'Location': 'NOT_RELEVANT',
                                              'MgmtProc': 'NOT_TESTED',
                                              'Power': 'NO_ERROR',
                                              'i2c': 'NOT_RELEVANT',
                                              'oaRedundancy': 'NOT_RELEVANT',
                                              'thermalDanger': 'NO_ERROR',
                                              'thermalWarning': 'NO_ERROR'},
                                     'FABRICTYPE': 'INTERCONNECT_TYPE_ETH',
                                     'FAULT': 'CPUFAULT',
                                     'MANUFACTURER': 'Cisco Systems, Inc.',
                                     'MGMTIPADDR': '10.235.28.33',
                                     'MGMTURL': 'http://10.235.28.33',
                                     'PORTMAP': {'PASSTHRU_MODE_ENABLED': 'DISABLED',
                                                 'SLOT': {'NUMBER': 1,
                                                          'PORT': [{'BLADEBAYNUMBER': 1,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 1,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 2,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 2,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 3,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 3,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 4,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 4,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 5,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 5,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 6,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 6,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 7,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 7,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 8,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 8,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 9,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 9,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 10,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 10,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 11,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 11,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 12,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 12,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 13,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 13,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 14,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 14,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 15,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 15,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 16,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 16,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'}],
                                                          'TYPE': 'INTERCONNECT_TYPE_ETH'},
                                                 'STATUS': 'OK'},
                                     'POWER': {'POWERSTATE': 'ON',
                                               'POWER_OFF_WATTAGE': 2,
                                               'POWER_ON_WATTAGE': 60},
                                     'SPN': 'Cisco Catalyst Blade Switch 3020 for HP',
                                     'STATUS': 'OK',
                                     'TEMPS': {'TEMP': {'C': 0,
                                                        'DESC': 'AMBIENT',
                                                        'LOCATION': 13,
                                                        'THRESHOLD': [{'C': 0,
                                                                       'DESC': 'CAUTION',
                                                                       'STATUS': 'Degraded'},
                                                                      {'C': 0,
                                                                       'DESC': 'CRITICAL',
                                                                       'STATUS': 'Non-Recoverable Error'}]}},
                                     'THERMAL': 'OK',
                                     'UIDSTATUS': 'OFF'},
                                    {'BAY': {'CONNECTION': 2},
                                     'BSN': 'FOC1316T0D6',
                                     'DIAG': {'AC': 'NOT_RELEVANT',
                                              'Cooling': 'NOT_RELEVANT',
                                              'Degraded': 'NO_ERROR',
                                              'FRU': 'NO_ERROR',
                                              'Failure': 'NO_ERROR',
                                              'Keying': 'NO_ERROR',
                                              'Location': 'NOT_RELEVANT',
                                              'MgmtProc': 'NOT_TESTED',
                                              'Power': 'NO_ERROR',
                                              'i2c': 'NOT_RELEVANT',
                                              'oaRedundancy': 'NOT_RELEVANT',
                                              'thermalDanger': 'NO_ERROR',
                                              'thermalWarning': 'NO_ERROR'},
                                     'FABRICTYPE': 'INTERCONNECT_TYPE_ETH',
                                     'FAULT': 'CPUFAULT',
                                     'MANUFACTURER': 'Cisco Systems, Inc.',
                                     'MGMTIPADDR': '10.235.28.34',
                                     'MGMTURL': 'http://10.235.28.34',
                                     'PORTMAP': {'PASSTHRU_MODE_ENABLED': 'DISABLED',
                                                 'SLOT': {'NUMBER': 1,
                                                          'PORT': [{'BLADEBAYNUMBER': 1,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 1,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 2,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 2,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 3,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 3,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 4,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 4,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 5,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 5,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 6,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 6,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 7,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 7,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 8,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 8,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 9,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 9,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 10,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 10,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 11,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 11,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 12,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 12,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 13,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 13,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 14,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 14,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 15,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 15,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 16,
                                                                    'BLADEMEZZNUMBER': 9,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 16,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'}],
                                                          'TYPE': 'INTERCONNECT_TYPE_ETH'},
                                                 'STATUS': 'OK'},
                                     'POWER': {'POWERSTATE': 'ON',
                                               'POWER_OFF_WATTAGE': 2,
                                               'POWER_ON_WATTAGE': 60},
                                     'SPN': 'Cisco Catalyst Blade Switch 3020 for HP',
                                     'STATUS': 'OK',
                                     'TEMPS': {'TEMP': {'C': 0,
                                                        'DESC': 'AMBIENT',
                                                        'LOCATION': 13,
                                                        'THRESHOLD': [{'C': 0,
                                                                       'DESC': 'CAUTION',
                                                                       'STATUS': 'Degraded'},
                                                                      {'C': 0,
                                                                       'DESC': 'CRITICAL',
                                                                       'STATUS': 'Non-Recoverable Error'}]}},
                                     'THERMAL': 'OK',
                                     'UIDSTATUS': 'OFF'},
                                    {'BAY': {'CONNECTION': 3},
                                     'BSN': 'CN89197024',
                                     'DIAG': {'AC': 'NOT_RELEVANT',
                                              'Cooling': 'NOT_RELEVANT',
                                              'Degraded': 'NO_ERROR',
                                              'FRU': 'NO_ERROR',
                                              'Failure': 'NO_ERROR',
                                              'Keying': 'NO_ERROR',
                                              'Location': 'NOT_RELEVANT',
                                              'MgmtProc': 'NO_ERROR',
                                              'Power': 'NO_ERROR',
                                              'i2c': 'NOT_RELEVANT',
                                              'oaRedundancy': 'NOT_RELEVANT',
                                              'thermalDanger': 'NO_ERROR',
                                              'thermalWarning': 'NO_ERROR'},
                                     'FABRICTYPE': 'INTERCONNECT_TYPE_FIB',
                                     'MANUFACTURER': 'BROCADE',
                                     'MGMTIPADDR': '10.235.28.35',
                                     'MGMTURL': 'http://10.235.28.35',
                                     'PORTMAP': {'PASSTHRU_MODE_ENABLED': 'DISABLED',
                                                 'SLOT': {'NUMBER': 1,
                                                          'PORT': [{'BLADEBAYNUMBER': 1,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 1,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 0,
                                                                    'BLADEMEZZNUMBER': 0,
                                                                    'BLADEMEZZPORTNUMBER': 0,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 2,
                                                                    'STATUS': 'UNKNOWN',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 3,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 3,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 0,
                                                                    'BLADEMEZZNUMBER': 0,
                                                                    'BLADEMEZZPORTNUMBER': 0,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 4,
                                                                    'STATUS': 'UNKNOWN',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 5,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 5,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 0,
                                                                    'BLADEMEZZNUMBER': 0,
                                                                    'BLADEMEZZPORTNUMBER': 0,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 6,
                                                                    'STATUS': 'UNKNOWN',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 0,
                                                                    'BLADEMEZZNUMBER': 0,
                                                                    'BLADEMEZZPORTNUMBER': 0,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 7,
                                                                    'STATUS': 'UNKNOWN',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 8,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 8,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 9,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 9,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 10,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 10,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 11,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 11,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 0,
                                                                    'BLADEMEZZNUMBER': 0,
                                                                    'BLADEMEZZPORTNUMBER': 0,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 12,
                                                                    'STATUS': 'UNKNOWN',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 13,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 13,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 14,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 14,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 15,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 15,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 16,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 1,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 16,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'}],
                                                          'TYPE': 'INTERCONNECT_TYPE_FIB'},
                                                 'STATUS': 'OK'},
                                     'POWER': {'POWERSTATE': 'ON',
                                               'POWER_OFF_WATTAGE': 1,
                                               'POWER_ON_WATTAGE': 35},
                                     'SPN': 'Brocade 4/24 SAN Switch for HP c-Class BladeSystem',
                                     'STATUS': 'OK',
                                     'TEMPS': {'TEMP': {'C': 0,
                                                        'DESC': 'AMBIENT',
                                                        'LOCATION': 13,
                                                        'THRESHOLD': [{'C': 0,
                                                                       'DESC': 'CAUTION',
                                                                       'STATUS': 'Degraded'},
                                                                      {'C': 0,
                                                                       'DESC': 'CRITICAL',
                                                                       'STATUS': 'Non-Recoverable Error'}]}},
                                     'THERMAL': 'OK',
                                     'UIDSTATUS': 'OFF'},
                                    {'BAY': {'CONNECTION': 4},
                                     'BSN': 'CN89207019',
                                     'DIAG': {'AC': 'NOT_RELEVANT',
                                              'Cooling': 'NOT_RELEVANT',
                                              'Degraded': 'NO_ERROR',
                                              'FRU': 'NO_ERROR',
                                              'Failure': 'NO_ERROR',
                                              'Keying': 'NO_ERROR',
                                              'Location': 'NOT_RELEVANT',
                                              'MgmtProc': 'NO_ERROR',
                                              'Power': 'NO_ERROR',
                                              'i2c': 'NOT_RELEVANT',
                                              'oaRedundancy': 'NOT_RELEVANT',
                                              'thermalDanger': 'NO_ERROR',
                                              'thermalWarning': 'NO_ERROR'},
                                     'FABRICTYPE': 'INTERCONNECT_TYPE_FIB',
                                     'MANUFACTURER': 'BROCADE',
                                     'MGMTIPADDR': '10.235.28.36',
                                     'MGMTURL': 'http://10.235.28.36',
                                     'PORTMAP': {'PASSTHRU_MODE_ENABLED': 'DISABLED',
                                                 'SLOT': {'NUMBER': 1,
                                                          'PORT': [{'BLADEBAYNUMBER': 1,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 1,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 0,
                                                                    'BLADEMEZZNUMBER': 0,
                                                                    'BLADEMEZZPORTNUMBER': 0,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 2,
                                                                    'STATUS': 'UNKNOWN',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 3,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 3,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 0,
                                                                    'BLADEMEZZNUMBER': 0,
                                                                    'BLADEMEZZPORTNUMBER': 0,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 4,
                                                                    'STATUS': 'UNKNOWN',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 5,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 5,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 0,
                                                                    'BLADEMEZZNUMBER': 0,
                                                                    'BLADEMEZZPORTNUMBER': 0,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 6,
                                                                    'STATUS': 'UNKNOWN',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 0,
                                                                    'BLADEMEZZNUMBER': 0,
                                                                    'BLADEMEZZPORTNUMBER': 0,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 7,
                                                                    'STATUS': 'UNKNOWN',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 8,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 8,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 9,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 9,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 10,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 10,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 11,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 11,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 0,
                                                                    'BLADEMEZZNUMBER': 0,
                                                                    'BLADEMEZZPORTNUMBER': 0,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 12,
                                                                    'STATUS': 'UNKNOWN',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 13,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 13,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 14,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 14,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 15,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 15,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'},
                                                                   {'BLADEBAYNUMBER': 16,
                                                                    'BLADEMEZZNUMBER': 1,
                                                                    'BLADEMEZZPORTNUMBER': 2,
                                                                    'ENABLED': 'UNKNOWN',
                                                                    'LINK_LED_STATUS': 'UNKNOWN',
                                                                    'NUMBER': 16,
                                                                    'STATUS': 'OK',
                                                                    'UID_STATUS': 'UNKNOWN'}],
                                                          'TYPE': 'INTERCONNECT_TYPE_FIB'},
                                                 'STATUS': 'OK'},
                                     'POWER': {'POWERSTATE': 'ON',
                                               'POWER_OFF_WATTAGE': 1,
                                               'POWER_ON_WATTAGE': 35},
                                     'SPN': 'Brocade 4/24 SAN Switch for HP c-Class BladeSystem',
                                     'STATUS': 'OK',
                                     'TEMPS': {'TEMP': {'C': 0,
                                                        'DESC': 'AMBIENT',
                                                        'LOCATION': 13,
                                                        'THRESHOLD': [{'C': 0,
                                                                       'DESC': 'CAUTION',
                                                                       'STATUS': 'Degraded'},
                                                                      {'C': 0,
                                                                       'DESC': 'CRITICAL',
                                                                       'STATUS': 'Non-Recoverable Error'}]}},
                                     'THERMAL': 'OK',
                                     'UIDSTATUS': 'OFF'}]},
            'TEMPS': {'TEMP': {'C': 26,
                               'DESC': 'AMBIENT',
                               'LOCATION': 9,
                               'THRESHOLD': [{'C': 42,
                                              'DESC': 'CAUTION',
                                              'STATUS': 'Degraded'},
                                             {'C': 46,
                                              'DESC': 'CRITICAL',
                                              'STATUS': 'Non-Recoverable Error'}]}},
            'TIMEZONE': 'Europe/Warsaw',
            'UIDSTATUS': 'OFF',
            'UUID': '09GB8925V2C9',
            'VCM': {'vcmDomainId': Null,
                    'vcmDomainName': Null,
                    'vcmMode': 'false',
                    'vcmUrl': 'empty'},
            'VM': {'DVDDRIVE': 'ABSENT'}},
 'MP': {'CIMOM': 'false',
        'FWRI': 3.32,
        'HWRI': 65.5,
        'PN': 'BladeSystem c7000 DDR2 Onboard Administrator with KVM',
        'PRIM': 'true',
        'SN': 'OB93BP1773    ',
        'SSO': 'false',
        'ST': 1,
        'STE': 'false',
        'USESTE': 'false',
        'UUID': '09OB93BP1773    '},
 'RK_TPLGY': {'ICMB': {'LEFT': Null, 'RIGHT': Null}, 'RUID': '09GB8925V2C9'}}

    def test_encl(self):
        encl = hp_oa.make_encl(self.DATA)
        self.assertEquals(encl.name, '')
        self.assertEquals(encl.sn, '9B8925V2C9')
        self.assertEquals(encl.model.type, DeviceType.blade_system.id)
        self.assertEquals(encl.model.name, 'HP BladeSystem c7000 Enclosure G2')


    def test_devices(self):
        encl = hp_oa.make_encl(self.DATA)
        data = nullify(self.DATA)
        hp_oa._add_hp_oa_devices(data['INFRA2']['MANAGERS']['MANAGER'],
            DeviceType.management, parent=encl)
        hp_oa._add_hp_oa_devices(data['INFRA2']['SWITCHES']['SWITCH'],
            DeviceType.switch, parent=encl)
        hp_oa._add_hp_oa_devices(data['INFRA2']['BLADES']['BLADE'],
            DeviceType.blade_server, parent=encl)
        models = [d.model.name for d in encl.child_set.all()]
        self.maxDiff = None
        self.assertEqual(models, [
            'HP Cisco Catalyst Blade Switch 3020 for HP',
            'HP Cisco Catalyst Blade Switch 3020 for HP',
            'HP Brocade 4/24 SAN Switch for HP c-Class BladeSystem',
            'HP Brocade 4/24 SAN Switch for HP c-Class BladeSystem',
            'HP ProLiant BL460c G1',
            'HP ProLiant BL460c G1',
            'HP ProLiant BL460c G6',
            'HP ProLiant BL460c G1',
            'HP ProLiant BL460c G1',
            'HP ProLiant BL460c G1',
            'HP ProLiant BL460c G6',
            'HP ProLiant BL460c G6',
            'HP ProLiant BL460c G6',
            'HP ProLiant BL460c G6',
            'HP ProLiant BL460c G6',
            'HP ProLiant BL460c G6',
            'HP ProLiant BL460c G6',
            'HP ProLiant BL460c G6',
            'HP ProLiant BL460c G6',
            'HP ProLiant BL460c G6',
        ])
        macs = [[e.mac for e in d.ethernet_set.all()] for d in encl.child_set.all()]
        self.assertEqual(macs, [
            [],
            [],
            [],
            [],
            ['0022649C6FF6', '0022649C7F42'],
            ['001A4BD0CC0E', '001A4BD0DC14'],
            ['0025B3A31468', '0025B3A3146C'],
            ['00237DA92A70', '00237DA92A76'],
            ['001A4BD0B564', '001A4BD0B570'],
            ['00237DA92BB0', '00237DA92BB2'],
            ['002481AEC098', '002481AEC09C'],
            ['0025B3A36D38', '0025B3A36D3C'],
            ['0025B3A3A288', '0025B3A3A28C'],
            ['0025B3A354E0', '0025B3A354E4'],
            ['002481AEF178', '002481AEF17C'],
            ['0025B3A31520', '0025B3A31524'],
            ['002481ADDD08', '002481ADDD0C'],
            ['0025B3A37D08', '0025B3A37D0C'],
            ['0025B3A31CA0', '0025B3A31CA4'],
            ['0025B3A38390', '0025B3A38394'],
        ])
        positions = [d.position for d in encl.child_set.all()]
        self.assertEqual(positions, ['1', '2', '3', '4', '1', '2', '3', '4',
            '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16'])


