"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBClusterEndpointAddress = exports.DBClusterEndpointAddressProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBClusterEndpointAddressProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBClusterEndpointAddress; } });
/**
 * A ROS resource type:  `ALIYUN::POLARDB::DBClusterEndpointAddress`
 */
class DBClusterEndpointAddress extends ros.Resource {
    /**
     * Create a new `ALIYUN::POLARDB::DBClusterEndpointAddress`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBClusterEndpointAddress = new polardb_generated_1.RosDBClusterEndpointAddress(this, id, {
            dbEndpointId: props.dbEndpointId,
            dbClusterId: props.dbClusterId,
            connectionStringPrefix: props.connectionStringPrefix,
            netType: props.netType === undefined || props.netType === null ? 'Public' : props.netType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBClusterEndpointAddress;
        this.attrAddress = rosDBClusterEndpointAddress.attrAddress;
        this.attrConnectionString = rosDBClusterEndpointAddress.attrConnectionString;
    }
}
exports.DBClusterEndpointAddress = DBClusterEndpointAddress;
//# sourceMappingURL=data:application/json;base64,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