"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBClusterAccessWhiteList = exports.DBClusterAccessWhiteListProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBClusterAccessWhiteListProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBClusterAccessWhiteList; } });
/**
 * A ROS resource type:  `ALIYUN::POLARDB::DBClusterAccessWhiteList`
 */
class DBClusterAccessWhiteList extends ros.Resource {
    /**
     * Create a new `ALIYUN::POLARDB::DBClusterAccessWhiteList`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBClusterAccessWhiteList = new polardb_generated_1.RosDBClusterAccessWhiteList(this, id, {
            securityIps: props.securityIps,
            dbClusterIpArrayName: props.dbClusterIpArrayName,
            dbClusterId: props.dbClusterId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBClusterAccessWhiteList;
        this.attrDbClusterId = rosDBClusterAccessWhiteList.attrDbClusterId;
    }
}
exports.DBClusterAccessWhiteList = DBClusterAccessWhiteList;
//# sourceMappingURL=data:application/json;base64,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