"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBCluster = exports.DBClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBClusterProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBCluster; } });
/**
 * A ROS resource type:  `ALIYUN::POLARDB::DBCluster`
 */
class DBCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::POLARDB::DBCluster`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBCluster = new polardb_generated_1.RosDBCluster(this, id, {
            defaultTimeZone: props.defaultTimeZone,
            cloneDataPoint: props.cloneDataPoint === undefined || props.cloneDataPoint === null ? 'LATEST' : props.cloneDataPoint,
            gdnId: props.gdnId,
            resourceGroupId: props.resourceGroupId,
            backupRetentionPolicyOnClusterDeletion: props.backupRetentionPolicyOnClusterDeletion,
            sourceResourceId: props.sourceResourceId,
            dbType: props.dbType,
            scaleRoNumMin: props.scaleRoNumMin,
            dbVersion: props.dbVersion,
            clusterNetworkType: props.clusterNetworkType === undefined || props.clusterNetworkType === null ? 'VPC' : props.clusterNetworkType,
            securityIpList: props.securityIpList,
            dbClusterParameters: props.dbClusterParameters,
            maintainTime: props.maintainTime,
            tags: props.tags,
            lowerCaseTableNames: props.lowerCaseTableNames,
            autoRenewPeriod: props.autoRenewPeriod === undefined || props.autoRenewPeriod === null ? 1 : props.autoRenewPeriod,
            tdeStatus: props.tdeStatus,
            zoneId: props.zoneId,
            vSwitchId: props.vSwitchId,
            scaleRoNumMax: props.scaleRoNumMax,
            renewalStatus: props.renewalStatus === undefined || props.renewalStatus === null ? 'Normal' : props.renewalStatus,
            dbClusterDescription: props.dbClusterDescription,
            period: props.period,
            payType: props.payType,
            scaleMax: props.scaleMax,
            creationCategory: props.creationCategory,
            securityGroupIds: props.securityGroupIds,
            dbNodeClass: props.dbNodeClass,
            creationOption: props.creationOption === undefined || props.creationOption === null ? 'Normal' : props.creationOption,
            allowShutDown: props.allowShutDown,
            vpcId: props.vpcId,
            serverlessType: props.serverlessType,
            scaleMin: props.scaleMin,
            periodUnit: props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBCluster;
        this.attrClusterConnectionString = rosDBCluster.attrClusterConnectionString;
        this.attrClusterEndpointId = rosDBCluster.attrClusterEndpointId;
        this.attrCustomConnectionStrings = rosDBCluster.attrCustomConnectionStrings;
        this.attrCustomEndpointIds = rosDBCluster.attrCustomEndpointIds;
        this.attrDbClusterId = rosDBCluster.attrDbClusterId;
        this.attrDbNodeIds = rosDBCluster.attrDbNodeIds;
        this.attrOrderId = rosDBCluster.attrOrderId;
        this.attrPrimaryConnectionString = rosDBCluster.attrPrimaryConnectionString;
        this.attrPrimaryEndpointId = rosDBCluster.attrPrimaryEndpointId;
    }
}
exports.DBCluster = DBCluster;
//# sourceMappingURL=data:application/json;base64,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