"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secrets = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Secrets required for GitHub runners operation.
 */
class Secrets extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.webhook = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'Webhook', {
            generateSecretString: {
                secretStringTemplate: '{}',
                generateStringKey: 'webhookSecret',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
        this.github = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'GitHub', {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({
                    domain: 'github.com',
                    clientSecret: '',
                    clientId: '',
                    appId: '',
                    installationId: '',
                    personalAuthToken: '',
                }),
                generateStringKey: 'dummy',
                includeSpace: false,
                excludePunctuation: true,
            },
        });
        // we create a separate secret for the private key because putting it in JSON secret is hard for the user
        this.githubPrivateKey = new aws_cdk_lib_1.aws_secretsmanager.Secret(this, 'GitHub Private Key', {
            secretStringValue: cdk.SecretValue.unsafePlainText('-----BEGIN RSA PRIVATE KEY-----\n...\n-----END RSA PRIVATE KEY-----'),
        });
    }
}
exports.Secrets = Secrets;
_a = JSII_RTTI_SYMBOL_1;
Secrets[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.Secrets", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,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