# Warning!!!
# This python module is generated from the MetaWear C++ API header files
# Do not edit
from ctypes import * 
import sys
import copy

if sys.version_info[0] == 2:
    range = xrange

def array_ubyte_eq(a, a_len, b, b_len):
    if (a_len != b_len):
        return False
    for i in range(a_len):
        if (a[i] != b[i]):
            return False
    return True

def array_ubyte_to_hex_string(a, a_len):
    if (a_len == 0):
        return "[]"
    string = "[" + "0x%02x" % (a[0])
    for i in range(a_len - 1):
        string+= ", " + "0x%02x" % (a[i + 1])
    string+= "]"
    return string

def array_ubyte_deep_copy(a, a_len):
    ptr = cast(a, POINTER(c_ubyte * a_len))
    return cast(copy.deepcopy(ptr.contents), POINTER(c_ubyte))

def module_info_eq(this, that):
    return (this.name == that.name and array_ubyte_eq(this.extra, this.extra_len, that.extra, that.extra_len) and this.present == that.present and this.implementation == that.implementation and this.revision == that.revision)

def module_info_repr(this):
    return "{name : %s, extra : %s, extra_len : %d, present : %d, implementation : %d, revision : %d}" % (this.name, array_ubyte_to_hex_string(this.extra, this.extra_len), this.extra_len, this.present, this.implementation, this.revision)

def module_info_deepcopy(this, memo):
    return ModuleInfo(name = this.name, extra = array_ubyte_deep_copy(this.extra, this.extra_len), extra_len = this.extra_len, present = this.present, implementation = this.implementation, revision = this.revision)

# taken from https://www.python.org/dev/peps/pep-0485/#proposed-implementation
def is_close(fst, snd):
    return abs(fst - snd) <= max( 0.001 * max(abs(fst), abs(snd)), 0.001 )

class GpioAnalogReadMode:
    ABS_REF = 0
    ADC = 1

class ConductanceRange:
    _50uS = 0
    _100uS = 1
    _150uS = 2
    _200uS = 3

class GyroBoschRange:
    _2000dps = 0
    _1000dps = 1
    _500dps = 2
    _250dps = 3
    _125dps = 4

class MagBmm150Odr:
    _10Hz = 0
    _2Hz = 1
    _6Hz = 2
    _8Hz = 3
    _15Hz = 4
    _20Hz = 5
    _25Hz = 6
    _30Hz = 7

class ColorDetectorTcs34725Gain:
    _1X = 0
    _4X = 1
    _16X = 2
    _60X = 3

class AlsLtr329MeasurementRate:
    _50ms = 0
    _100ms = 1
    _200ms = 2
    _500ms = 3
    _1000ms = 4
    _2000ms = 5

class AlsLtr329Gain:
    _1X = 0
    _2X = 1
    _4X = 2
    _8X = 3
    _48X = 4
    _96X = 5

class ProximityTsl2671Current:
    _100mA = 0
    _50mA = 1
    _25mA = 2
    _12_5mA = 3

class AccMma8452qOdr:
    _800Hz = 0
    _400Hz = 1
    _200Hz = 2
    _100Hz = 3
    _50Hz = 4
    _12_5Hz = 5
    _6_25Hz = 6
    _1_56Hz = 7

class GpioPullMode:
    UP = 0
    DOWN = 1
    NONE = 2

class BaroBme280StandbyTime:
    _0_5ms = 0
    _62_5ms = 1
    _125ms = 2
    _250ms = 3
    _500ms = 4
    _1000ms = 5
    _10ms = 6
    _20ms = 7

class SpiMode:
    _0 = 0
    _1 = 1
    _2 = 2
    _3 = 3

class AccMma8452qCutoffFreq:
    HIGHEST = 0
    HIGH = 1
    MEDIUM = 2
    LOW = 3

class BaroBoschIirFilter:
    OFF = 0
    AVG_2 = 1
    AVG_4 = 2
    AVG_8 = 3
    AVG_16 = 4

class SensorFusionData:
    CORRECTED_ACC = 0
    CORRECTED_GYRO = 1
    CORRECTED_MAG = 2
    QUATERNION = 3
    EULER_ANGLE = 4
    GRAVITY_VECTOR = 5
    LINEAR_ACC = 6

class AccMma8452qRange:
    _2G = 0
    _4G = 1
    _8G = 2

class SensorFusionAccRange:
    _2G = 0
    _4G = 1
    _8G = 2
    _16G = 3

class ProximityTsl2671Channel:
    _0 = 1
    _1 = 2
    BOTH = 3

class BaroBoschOversampling:
    SKIP = 0
    ULTRA_LOW_POWER = 1
    LOW_POWER = 2
    STANDARD = 3
    HIGH = 4
    ULTRA_HIGH = 5

class ThresholdMode:
    ABSOLUTE = 0
    BINARY = 1

class SensorFusionMode:
    SLEEP = 0
    NDOF = 1
    IMU_PLUS = 2
    COMPASS = 3
    M4G = 4

class NeoPixelColorOrdering:
    WS2811_RGB = 0
    WS2811_RBG = 1
    WS2811_GRB = 2
    WS2811_GBR = 3

class WhitelistFilter:
    ALLOW_FROM_ANY = 0
    SCAN_REQUESTS = 1
    CONNECTION_REQUESTS = 2
    SCAN_AND_CONNECTION_REQUESTS = 3

class LedPreset:
    BLINK = 0
    PULSE = 1
    SOLID = 2

class SpiFrequency:
    _125KHz = 0
    _250KHz = 1
    _500KHz = 2
    _1MHz = 3
    _2MHz = 4
    _4MHz = 5
    _8MHz = 6

class MagBmm150Preset:
    LOW_POWER = 0
    REGULAR = 1
    ENHANCED_REGULAR = 2
    HIGH_ACCURACY = 3

class SensorFusionGyroRange:
    _2000DPS = 0
    _1000DPS = 1
    _500DPS = 2
    _250DPS = 3

class AccBoschAxisXyzSign:
    _000 = 0
    _100 = 1
    _110 = 2
    _101 = 3
    _010 = 4
    _011 = 5
    _001 = 6
    _111 = 7

class TimeMode:
    ABSOLUTE = 0
    DIFFERENTIAL = 1

class AlsLtr329IntegrationTime:
    _100ms = 0
    _50ms = 1
    _200ms = 2
    _400ms = 3
    _150ms = 4
    _250ms = 5
    _300ms = 6
    _350ms = 7

class BleAdType:
    CONNECTED_UNDIRECTED = 0
    CONNECTED_DIRECTED = 1

class AccBoschTapShockTime:
    _50ms = 0
    _75ms = 1

class MathOperation:
    ADD = 1
    MULTIPLY = 2
    DIVIDE = 3
    MODULUS = 4
    EXPONENT = 5
    SQRT = 6
    LSHIFT = 7
    RSHIFT = 8
    SUBTRACT = 9
    ABS_VALUE = 10
    CONSTANT = 11

class AccBmi160Odr:
    _0_78125Hz = 0
    _1_5625Hz = 1
    _3_125Hz = 2
    _6_25Hz = 3
    _12_5Hz = 4
    _25Hz = 5
    _50Hz = 6
    _100Hz = 7
    _200Hz = 8
    _400Hz = 9
    _800Hz = 10
    _1600Hz = 11

class AccBma255Odr:
    _15_62Hz = 0
    _31_26Hz = 1
    _62_5Hz = 2
    _125Hz = 3
    _250Hz = 4
    _500Hz = 5
    _1000Hz = 6
    _2000Hz = 7

class DataTypeId:
    UINT32 = 0
    FLOAT = 1
    CARTESIAN_FLOAT = 2
    INT32 = 3
    BYTE_ARRAY = 4
    BATTERY_STATE = 5
    TCS34725_ADC = 6
    EULER_ANGLE = 7
    QUATERNION = 8
    CORRECTED_CARTESIAN_FLOAT = 9
    OVERFLOW_STATE = 10
    SENSOR_ORIENTATION = 11
    STRING = 12
    LOGGING_TIME = 13
    BTLE_ADDRESS = 14
    BOSCH_ANY_MOTION = 15
    CALIBRATION_STATE = 16
    DATA_ARRAY = 17
    BOSCH_TAP = 18
    BOSCH_GESTURE = 19

class GpioPinChangeType:
    RISING = 1
    FALLING = 2
    ANY = 3

class Model:
    NA = -1
    METAWEAR_R = 0
    METAWEAR_RG = 1
    METAWEAR_RPRO = 2
    METAWEAR_C = 3
    METAWEAR_CPRO = 4
    METAENV = 5
    METADETECT = 6
    METAHEALTH = 7
    METATRACKER = 8
    METAMOTION_R = 9
    METAMOTION_RL = 10
    METAMOTION_C = 11
    METAMOTION_S = 12

class GattCharWriteType:
    WITH_RESPONSE = 0
    WITHOUT_RESPONSE = 1

class Module:
    SWITCH = 1
    LED = 2
    ACCELEROMETER = 3
    TEMPERATURE = 4
    GPIO = 5
    NEO_PIXEL = 6
    IBEACON = 7
    HAPTIC = 8
    DATA_PROCESSOR = 9
    EVENT = 10
    LOGGING = 11
    TIMER = 12
    I2C = 13
    MACRO = 15
    CONDUCTANCE = 16
    SETTINGS = 17
    BAROMETER = 18
    GYRO = 19
    AMBIENT_LIGHT = 20
    MAGNETOMETER = 21
    HUMIDITY = 22
    COLOR_DETECTOR = 23
    PROXIMITY = 24
    SENSOR_FUSION = 25
    DEBUG = 254

class DeltaMode:
    ABSOLUTE = 0
    DIFFERENTIAL = 1
    BINARY = 2

class ComparatorMode:
    ABSOLUTE = 0
    REFERENCE = 1
    ZONE = 2
    BINARY = 3

class MetaWearRChannel:
    ON_DIE = 0
    EXT_THERMISTOR = 1

class NeoPixelRotDirection:
    TOWARDS = 0
    AWAY = 1

class LedColor:
    GREEN = 0
    RED = 1
    BLUE = 2

class SensorOrientation:
    FACE_UP_PORTRAIT_UPRIGHT = 0
    FACE_UP_PORTRAIT_UPSIDE_DOWN = 1
    FACE_UP_LANDSCAPE_LEFT = 2
    FACE_UP_LANDSCAPE_RIGHT = 3
    FACE_DOWN_PORTRAIT_UPRIGHT = 4
    FACE_DOWN_PORTRAIT_UPSIDE_DOWN = 5
    FACE_DOWN_LANDSCAPE_LEFT = 6
    FACE_DOWN_LANDSCAPE_RIGHT = 7

class ComparatorOperation:
    EQ = 0
    NEQ = 1
    LT = 2
    LTE = 3
    GT = 4
    GTE = 5

class PassthroughMode:
    ALL = 0
    CONDITIONAL = 1
    COUNT = 2

class MetaWearRProChannel:
    ON_DIE = 0
    ON_BOARD_THERMISTOR = 1
    EXT_THERMISTOR = 2
    BMP280 = 3

class AccBoschTypewrist:
    NONE = 0
    WEARK_WAKEUP = 1
    GESTURE = 2

class AccBmi160StepCounterMode:
    NORMAL = 0
    SENSITIVE = 1
    ROBUST = 2

class PulseOutput:
    WIDTH = 0
    AREA = 1
    PEAK = 2
    ON_DETECTION = 3

class AccBoschActivity:
    STILL = 0
    WALKING = 1
    RUNNING = 2
    UNKNOWN = 3

class AccBoschOrientationMode:
    SYMMETRICAL = 0
    HIGH_ASYMMETRICAL = 1
    LOW_ASYMMETRICAL = 2

class BaroBmp280StandbyTime:
    _0_5ms = 0
    _62_5ms = 1
    _125ms = 2
    _250ms = 3
    _500ms = 4
    _1000ms = 5
    _2000ms = 6
    _4000ms = 7

class TemperatureSource:
    INVALID = -1
    NRF_DIE = 0
    EXT_THERM = 1
    BMP280 = 2
    PRESET_THERM = 3

class AccBoschGesture:
    UNKNOWN = 0
    PUSH_ARM_DOWN = 1
    PIVOT_UP = 2
    SHAKE = 3
    ARM_FLICK_IN = 4
    ARM_FLICK_OUT = 5

class AccBoschRange:
    _2G = 0
    _4G = 1
    _8G = 2
    _16G = 3

class HumidityBme280Oversampling:
    _1X = 1
    _2X = 2
    _4X = 3
    _8X = 4
    _16X = 5

class AccBoschMotion:
    SIGMOTION = 0
    NOMOTION = 1
    ANYMOTION = 2

class AccBmi270Odr:
    _0_78125Hz = 0
    _1_5625Hz = 1
    _3_125Hz = 2
    _6_25Hz = 3
    _12_5Hz = 4
    _25Hz = 5
    _50Hz = 6
    _100Hz = 7
    _200Hz = 8
    _400Hz = 9
    _800Hz = 10
    _1600Hz = 11

class AccBoschTapQuietTime:
    _30ms = 0
    _20ms = 1

class AccBoschDoubleTapWindow:
    _50ms = 0
    _100ms = 1
    _150ms = 2
    _200ms = 3
    _250ms = 4
    _375ms = 5
    _500ms = 6
    _700ms = 7

class GyroBoschOdr:
    _25Hz = 6
    _50Hz = 7
    _100Hz = 8
    _200Hz = 9
    _400Hz = 10
    _800Hz = 11
    _1600Hz = 12
    _3200Hz = 13

class AccBoschAxisXyzRemap:
    XYZ = 0
    YZX = 1
    ZXY = 2
    XZY = 3
    YXZ = 4
    ZYX = 5

class CalibrationData(Structure):
    _fields_ = [
        ("acc" , (c_ubyte * 10)),
        ("gyro" , (c_ubyte * 10)),
        ("mag" , (c_ubyte * 10))
    ]

    def __neq__(self, other):
        return not self.__eq__(other)

    def __eq__(self, other):
        return (array_ubyte_eq(self.acc, 10, other.acc, 10) and array_ubyte_eq(self.gyro, 10, other.gyro, 10) and array_ubyte_eq(self.mag, 10, other.mag, 10))

    def __repr__(self):
        return "{acc : %s, gyro : %s, mag : %s}" % (array_ubyte_to_hex_string(self.acc, 10), array_ubyte_to_hex_string(self.gyro, 10), array_ubyte_to_hex_string(self.mag, 10))

    def __deepcopy__(self, memo):
        return CalibrationData(acc = copy.deepcopy(self.acc), gyro = copy.deepcopy(self.gyro), mag = copy.deepcopy(self.mag))

