# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.0.6349, generator: {generator})
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse

from .. import models as _models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, IO, List, Optional, TypeVar, Union

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class SmartDiagnosticsApiOperationsMixin(object):

    def get_analytics_model(
        self,
        model_id,  # type: int
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.AnalyticsModelResponse", "_models.ProblemDetails"]
        """Gets an Analytics Model.

        Gets an Analytics Model.

        :param model_id:
        :type model_id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AnalyticsModelResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.AnalyticsModelResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.AnalyticsModelResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_analytics_model.metadata['url']  # type: ignore
        path_format_arguments = {
            'modelId': self._serialize.url("model_id", model_id, 'int'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('AnalyticsModelResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_analytics_model.metadata = {'url': '/api/v3.0/Analytics/Models/{modelId}'}  # type: ignore

    def delete_analytics_model(
        self,
        model_id,  # type: int
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Deletes an Analytics Model.

        Deletes an Analytics Model.

        :param model_id:
        :type model_id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.delete_analytics_model.metadata['url']  # type: ignore
        path_format_arguments = {
            'modelId': self._serialize.url("model_id", model_id, 'int'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_analytics_model.metadata = {'url': '/api/v3.0/Analytics/Models/{modelId}'}  # type: ignore

    def get_analytics_models(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelAnalyticsModelResponse", "_models.ProblemDetails"]
        """Gets Analytics Models.

        Gets Analytics Models.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``CorporationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``CorporationName`` | String | ``eq, neq, in, like`` |
         | ``Created`` | DateTime | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``GroupType`` | GroupTypeCodes? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsDeprecated`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsGlobal`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |
         | ``Type`` | AnalyticModelType | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``Version`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Created`` | DateTime |
         | ``GroupType`` | GroupTypeCodes? |
         | ``Name`` | String |
         | ``Version`` | String |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelAnalyticsModelResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelAnalyticsModelResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelAnalyticsModelResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_analytics_models.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelAnalyticsModelResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_analytics_models.metadata = {'url': '/api/v3.0/Analytics/Models'}  # type: ignore

    def create_analytics_models(
        self,
        body=None,  # type: Optional["_models.AnalyticsModelCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.AnalyticsModelResponse", "_models.ProblemDetails"]
        """Creates an Analytics Model.

        Creates an Analytics Model.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.AnalyticsModelCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AnalyticsModelResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.AnalyticsModelResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.AnalyticsModelResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_analytics_models.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'AnalyticsModelCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('AnalyticsModelResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_analytics_models.metadata = {'url': '/api/v3.0/Analytics/Models'}  # type: ignore

    def get_asset(
        self,
        asset_id,  # type: str
        include_analytics_models=False,  # type: Optional[bool]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.AssetResponse", "_models.ProblemDetails"]
        """Gets an Asset.

        Gets an Asset.

        :param asset_id:
        :type asset_id: str
        :param include_analytics_models: Determines whether to include the Analytics Model with the
         asset.
        :type include_analytics_models: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AssetResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.AssetResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.AssetResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_asset.metadata['url']  # type: ignore
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if include_analytics_models is not None:
            query_parameters['includeAnalyticsModels'] = self._serialize.query("include_analytics_models", include_analytics_models, 'bool')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('AssetResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_asset.metadata = {'url': '/api/v3.0/Assets/{assetId}'}  # type: ignore

    def update_asset(
        self,
        asset_id,  # type: str
        body=None,  # type: Optional["_models.AssetUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.AssetResponse", "_models.ProblemDetails"]
        """Updates a asset.

        Updates a asset.

        :param asset_id:
        :type asset_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.AssetUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AssetResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.AssetResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.AssetResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_asset.metadata['url']  # type: ignore
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'AssetUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('AssetResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_asset.metadata = {'url': '/api/v3.0/Assets/{assetId}'}  # type: ignore

    def delete_asset(
        self,
        asset_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Deletes an asset.

        Deletes an asset.

        :param asset_id:
        :type asset_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.delete_asset.metadata['url']  # type: ignore
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_asset.metadata = {'url': '/api/v3.0/Assets/{assetId}'}  # type: ignore

    def get_assets(
        self,
        include_analytics_models=False,  # type: Optional[bool]
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelAssetResponse", "_models.ProblemDetails"]
        """Gets Assets.

        Gets Assets.

        :param include_analytics_models: Determines whether to include the Analytics Model with the
         asset.
        :type include_analytics_models: bool
        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Abbreviation`` | String | ``eq, neq, in, like`` |
         | ``Active`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``AnalyticsModelCount`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``AnalyticsModelId`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``AnalyticsModelName`` | String | ``eq, neq, in, like`` |
         | ``CategoryCode`` | String | ``eq, neq, in, like`` |
         | ``CategoryId`` | Int32? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``CategoryName`` | String | ``eq, neq, in, like`` |
         | ``CorporationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``CorporationName`` | String | ``eq, neq, in, like`` |
         | ``Created`` | DateTime | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``CriticalityId`` | Int32? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``CriticalityName`` | String | ``eq, neq, in, like`` |
         | ``IsOperatorView`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsPaused`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``Manufacturer`` | String | ``eq, neq, in, like`` |
         | ``ModelName`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |
         | ``NodeId`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``NodeSerialNumber`` | String | ``eq, neq, in, like`` |
         | ``SizeCode`` | String | ``eq, neq, in, like`` |
         | ``SizeId`` | Int32? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``SizeName`` | String | ``eq, neq, in, like`` |
         | ``Supplier`` | String | ``eq, neq, in, like`` |
         | ``TagId`` | Guid | ``eq, neq, in`` |
         | ``TagName`` | String | ``eq, neq, in, like`` |
         | ``TypeCode`` | String | ``eq, neq, in, like`` |
         | ``TypeId`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``TypeName`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Abbreviation`` | String |
         | ``CategoryCode`` | String |
         | ``CategoryName`` | String |
         | ``CorporationName`` | String |
         | ``Created`` | DateTime |
         | ``CriticalityId`` | Int32? |
         | ``CriticalityName`` | String |
         | ``LocationName`` | String |
         | ``Name`` | String |
         | ``SizeCode`` | String |
         | ``SizeName`` | String |
         | ``TypeCode`` | String |
         | ``TypeName`` | String |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelAssetResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelAssetResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelAssetResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_assets.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if include_analytics_models is not None:
            query_parameters['includeAnalyticsModels'] = self._serialize.query("include_analytics_models", include_analytics_models, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelAssetResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_assets.metadata = {'url': '/api/v3.0/Assets'}  # type: ignore

    def create_asset(
        self,
        body=None,  # type: Optional["_models.AssetCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.AssetResponse", "_models.ProblemDetails"]
        """Creates a asset.

        Creates a asset.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.AssetCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AssetResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.AssetResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.AssetResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_asset.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'AssetCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('AssetResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_asset.metadata = {'url': '/api/v3.0/Assets'}  # type: ignore

    def move_asset(
        self,
        asset_id,  # type: str
        body=None,  # type: Optional["_models.GroupMoveRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.AssetResponse", "_models.ProblemDetails"]
        """Moves a asset.

        Moves a asset.

        :param asset_id:
        :type asset_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.GroupMoveRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AssetResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.AssetResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.AssetResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.move_asset.metadata['url']  # type: ignore
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'GroupMoveRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('AssetResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    move_asset.metadata = {'url': '/api/v3.0/Assets/{assetId}/Move'}  # type: ignore

    def get_asset_status(
        self,
        asset_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.GroupStatusResponse", "_models.ProblemDetails"]
        """Gets an asset's status.

        Gets an asset's status.

        :param asset_id:
        :type asset_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GroupStatusResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.GroupStatusResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.GroupStatusResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_asset_status.metadata['url']  # type: ignore
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('GroupStatusResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_asset_status.metadata = {'url': '/api/v3.0/Assets/{assetId}/Status'}  # type: ignore

    def get_asset_statuses(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelGroupStatusResponse", "_models.ProblemDetails"]
        """Gets Asset Statuses.

        Gets Asset Statuses.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``AlarmCount`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``DamageScore`` | Double? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``HierarchyId`` | Guid | ``eq, neq, in`` |
         | ``Id`` | Guid | ``eq, neq, in`` |
         | ``IsPaused`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsSnoozed`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``Name`` | String | ``eq, neq, in, like`` |
         | ``WarningCount`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``AlarmCount`` | Int32 |
         | ``DamageScore`` | Double? |
         | ``Name`` | String |
         | ``WarningCount`` | Int32 |.
        :type order_by: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelGroupStatusResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelGroupStatusResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelGroupStatusResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_asset_statuses.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelGroupStatusResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_asset_statuses.metadata = {'url': '/api/v3.0/Assets/Status'}  # type: ignore

    def get_asset_types(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelAssetTypeResponse", "_models.ProblemDetails"]
        """Gets Asset Types.

        Gets Asset Types.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``CategoryCode`` | String | ``eq, neq, in, like`` |
         | ``CategoryId`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``CategoryName`` | String | ``eq, neq, in, like`` |
         | ``Code`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Code`` | String |
         | ``Name`` | String |.
        :type order_by: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelAssetTypeResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelAssetTypeResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelAssetTypeResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_asset_types.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelAssetTypeResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_asset_types.metadata = {'url': '/api/v3.0/Assets/Types'}  # type: ignore

    def get_asset_markers(
        self,
        asset_id,  # type: str
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelMarkerResponse", "_models.ProblemDetails"]
        """Gets all markers on an asset.

        Gets all markers on an asset.

        :param asset_id: Id of asset.
        :type asset_id: str
        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``MarkerType`` | MarkerType | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``Name`` | String | ``eq, neq, in, like`` |
         | ``Value`` | Double | ``eq, neq, in, lt, gt, leq, geq`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Name`` | String |
         | ``Order`` | Int32 |
         | ``Value`` | Double |.
        :type order_by: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelMarkerResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelMarkerResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelMarkerResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_asset_markers.metadata['url']  # type: ignore
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelMarkerResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_asset_markers.metadata = {'url': '/api/v3.0/Assets/{assetId}/markers'}  # type: ignore

    def replace_asset_markers(
        self,
        asset_id,  # type: str
        body=None,  # type: Optional[List["_models.MarkerUpdateRequest"]]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union[List["_models.MarkerResponse"], "_models.ProblemDetails"]
        """Replaces all the existing markers on the asset with new ones.

        Replaces all the existing markers on the asset with new ones.

        :param asset_id: Id of the asset.
        :type asset_id: str
        :param body: Request containing marker information.
        :type body: list[~smartdiagnostics_sdk.models.MarkerUpdateRequest]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of MarkerResponse or ProblemDetails, or the result of cls(response)
        :rtype: list[~smartdiagnostics_sdk.models.MarkerResponse] or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union[List["_models.MarkerResponse"], "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.replace_asset_markers.metadata['url']  # type: ignore
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, '[MarkerUpdateRequest]')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('[MarkerResponse]', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    replace_asset_markers.metadata = {'url': '/api/v3.0/Assets/{assetId}/markers'}  # type: ignore

    def get_base_station(
        self,
        base_station_id,  # type: int
        include_state=False,  # type: Optional[bool]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.BaseStationResponse", "_models.ProblemDetails"]
        """Gets a Base Station by Id.

        Gets a Base Station by Id.

        :param base_station_id: Specifies the id of the Base Station to get.
        :type base_station_id: long
        :param include_state: Determines whether to include the states for
                     the LastDataUpdate, LastStatusUpdate, and IsOnline.
        :type include_state: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BaseStationResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.BaseStationResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.BaseStationResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_base_station.metadata['url']  # type: ignore
        path_format_arguments = {
            'baseStationId': self._serialize.url("base_station_id", base_station_id, 'long'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('BaseStationResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_base_station.metadata = {'url': '/api/v3.0/BaseStations/{baseStationId}'}  # type: ignore

    def edit_base_station(
        self,
        base_station_id,  # type: int
        include_state=False,  # type: Optional[bool]
        body=None,  # type: Optional["_models.BaseStationUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.BaseStationResponse", "_models.ProblemDetails"]
        """Edits a Base Station.

        Edits a Base Station.

        :param base_station_id: The id of the Base Station to edit.
        :type base_station_id: long
        :param include_state: Determines whether to include the states for
                     the LastDataUpdate, LastStatusUpdate, and IsOnline.
        :type include_state: bool
        :param body: Contains the properties to update.
        :type body: ~smartdiagnostics_sdk.models.BaseStationUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BaseStationResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.BaseStationResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.BaseStationResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.edit_base_station.metadata['url']  # type: ignore
        path_format_arguments = {
            'baseStationId': self._serialize.url("base_station_id", base_station_id, 'long'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'BaseStationUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('BaseStationResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    edit_base_station.metadata = {'url': '/api/v3.0/BaseStations/{baseStationId}'}  # type: ignore

    def get_base_stations(
        self,
        include_state=False,  # type: Optional[bool]
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelBaseStationResponse", "_models.ProblemDetails"]
        """Gets a paged list of Base Stations.

        Gets a paged list of Base Stations.

        :param include_state: Determines whether to include the states for
                     the LastDataUpdate, LastStatusUpdate, and IsOnline.
        :type include_state: bool
        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``CorporationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``CorporationName`` | String | ``eq, neq, in, like`` |
         | ``CurrentSoftwareReleaseId`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``CurrentSoftwareReleaseName`` | String | ``eq, neq, in, like`` |
         | ``HardwareRevisionId`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``HardwareRevisionName`` | String | ``eq, neq, in, like`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``ReceiverFirmwareVersion`` | String | ``eq, neq, in, like`` |
         | ``ReceiverId`` | Int64 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``ReceiverNetworkId`` | String | ``eq, neq, in, like`` |
         | ``ReceiverNickname`` | String | ``eq, neq, in, like`` |
         | ``ReceiverPendingRfChannel`` | Int32? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``ReceiverRfChannel`` | Int32? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``ReceiverSerialNumber`` | String | ``eq, neq, in, like`` |
         | ``ReleaseRingId`` | Guid | ``eq, neq, in`` |
         | ``ReleaseRingName`` | String | ``eq, neq, in, like`` |
         | ``SerialNumber`` | String | ``eq, neq, in, like`` |
         | ``TargetedSoftwareReleaseId`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``TargetedSoftwareReleaseName`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``CorporationName`` | String |
         | ``CurrentSoftwareReleaseName`` | String |
         | ``HardwareRevisionId`` | Int32 |
         | ``HardwareRevisionName`` | String |
         | ``LocationName`` | String |
         | ``Nickname`` | String |
         | ``PushToStage`` | Boolean |
         | ``ReceiverFirmwareVersion`` | String |
         | ``ReceiverNetworkId`` | String |
         | ``ReceiverNickname`` | String |
         | ``ReceiverPendingRfChannel`` | Int32? |
         | ``ReceiverRfChannel`` | Int32? |
         | ``ReleaseRingId`` | Guid |
         | ``ReleaseRingName`` | String |
         | ``SerialNumber`` | String |
         | ``TargetedSoftwareReleaseName`` | String |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelBaseStationResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelBaseStationResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelBaseStationResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_base_stations.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelBaseStationResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_base_stations.metadata = {'url': '/api/v3.0/BaseStations'}  # type: ignore

    def create_base_station(
        self,
        body=None,  # type: Optional["_models.BaseStationCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.BaseStationResponse", "_models.ProblemDetails"]
        """Creates a new Base Station.

        Creates a new Base Station.

        :param body: Specifies the properties for the new Base Station.
        :type body: ~smartdiagnostics_sdk.models.BaseStationCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BaseStationResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.BaseStationResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.BaseStationResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_base_station.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'BaseStationCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('BaseStationResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_base_station.metadata = {'url': '/api/v3.0/BaseStations'}  # type: ignore

    def get_bearings(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelBearingResponse", "_models.ProblemDetails"]
        """Gets all bearings.

        Gets all bearings.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelBearingResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelBearingResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelBearingResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_bearings.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelBearingResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_bearings.metadata = {'url': '/api/v3.0/Bearings'}  # type: ignore

    def get_bearing(
        self,
        bearing_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.BearingResponse", "_models.ProblemDetails"]
        """Gets a bearing.

        Gets a bearing.

        :param bearing_id: Id of bearing to return.
        :type bearing_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BearingResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.BearingResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.BearingResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_bearing.metadata['url']  # type: ignore
        path_format_arguments = {
            'bearingId': self._serialize.url("bearing_id", bearing_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('BearingResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_bearing.metadata = {'url': '/api/v3.0/Bearings/{bearingId}'}  # type: ignore

    def create_corporation(
        self,
        body=None,  # type: Optional["_models.CorporationCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.CorporationResponse", "_models.ProblemDetails"]
        """Creates a new corporation.

        Creates a new corporation.

        :param body: A corporation create request.
        :type body: ~smartdiagnostics_sdk.models.CorporationCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CorporationResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.CorporationResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.CorporationResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_corporation.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'CorporationCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('CorporationResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_corporation.metadata = {'url': '/api/v3.0/Corporations'}  # type: ignore

    def get_corporations(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelCorporationResponse", "_models.ProblemDetails"]
        """Returns paginated list corporations.

        Returns paginated list corporations.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelCorporationResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelCorporationResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelCorporationResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_corporations.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelCorporationResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_corporations.metadata = {'url': '/api/v3.0/Corporations'}  # type: ignore

    def get_corporation(
        self,
        id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.CorporationResponse", "_models.ProblemDetails"]
        """Returns a single corporation.

        Returns a single corporation.

        :param id: Id of the corporation.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CorporationResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.CorporationResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.CorporationResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_corporation.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('CorporationResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_corporation.metadata = {'url': '/api/v3.0/Corporations/{id}'}  # type: ignore

    def update_corporation(
        self,
        id,  # type: str
        body=None,  # type: Optional["_models.CorporationUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.CorporationResponse", "_models.ProblemDetails"]
        """Updates a Corporation.

        Updates a Corporation.

        :param id: Id of the Corporation to be updated.
        :type id: str
        :param body: Corporation Update Request.
        :type body: ~smartdiagnostics_sdk.models.CorporationUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CorporationResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.CorporationResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.CorporationResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_corporation.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'CorporationUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('CorporationResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_corporation.metadata = {'url': '/api/v3.0/Corporations/{id}'}  # type: ignore

    def upload_corporation_icon(
        self,
        id,  # type: str
        file=None,  # type: Optional[IO]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.CorporationResponse", "_models.ProblemDetails"]
        """Updates a Corporations Icon.

        Updates a Corporations Icon.

        :param id: Id of the Corporation to be updated.
        :type id: str
        :param file: The image file to upload.
        :type file: IO
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CorporationResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.CorporationResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.CorporationResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "multipart/form-data")
        accept = "application/json, text/json"

        # Construct URL
        url = self.upload_corporation_icon.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        # Construct form data
        _form_content = {
            'file': file,
        }
        request = self._client.post(url, query_parameters, header_parameters, form_content=_form_content)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404, 422]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('CorporationResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 422:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    upload_corporation_icon.metadata = {'url': '/api/v3.0/Corporations/{id}/Icon'}  # type: ignore

    def get_corporation_roi(
        self,
        corporation_id,  # type: str
        start_date=None,  # type: Optional[datetime.datetime]
        end_date=None,  # type: Optional[datetime.datetime]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.RoiResponse", "_models.ProblemDetails"]
        """Gets ROI information for a corporation.

        Gets ROI information for a corporation.

        :param corporation_id:
        :type corporation_id: str
        :param start_date:
        :type start_date: ~datetime.datetime
        :param end_date:
        :type end_date: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RoiResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.RoiResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.RoiResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_corporation_roi.metadata['url']  # type: ignore
        path_format_arguments = {
            'corporationId': self._serialize.url("corporation_id", corporation_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if start_date is not None:
            query_parameters['StartDate'] = self._serialize.query("start_date", start_date, 'iso-8601')
        if end_date is not None:
            query_parameters['EndDate'] = self._serialize.query("end_date", end_date, 'iso-8601')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('RoiResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_corporation_roi.metadata = {'url': '/api/v3.0/Corporations/{corporationId}/roi'}  # type: ignore

    def get_dashboard(
        self,
        id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.DashboardResponse", "_models.ProblemDetails"]
        """get_dashboard.

        :param id:
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DashboardResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.DashboardResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.DashboardResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_dashboard.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('DashboardResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_dashboard.metadata = {'url': '/api/v3.0/Dashboards/{id}'}  # type: ignore

    def update_dashboard(
        self,
        id,  # type: str
        body=None,  # type: Optional["_models.DashboardUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.DashboardResponse", "_models.ProblemDetails"]
        """Updates a dashboard.

        Updates a dashboard.

        :param id: Id of the dashboard.
        :type id: str
        :param body: Updated dashboard details.
        :type body: ~smartdiagnostics_sdk.models.DashboardUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DashboardResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.DashboardResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.DashboardResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_dashboard.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'DashboardUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 403, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('DashboardResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_dashboard.metadata = {'url': '/api/v3.0/Dashboards/{id}'}  # type: ignore

    def delete_dashboard(
        self,
        id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Deletes a dashboard.

        Deletes a dashboard.

        :param id: Id of the dashboard.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.delete_dashboard.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204, 401, 403, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_dashboard.metadata = {'url': '/api/v3.0/Dashboards/{id}'}  # type: ignore

    def get_dashboards(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelDashboardResponse", "_models.ProblemDetails"]
        """Gets all dashboards available to the user.

        Gets all dashboards available to the user.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``CorporationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``CorporationName`` | String | ``eq, neq, in, like`` |
         | ``DashboardTypeId`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``DashboardTypeName`` | String | ``eq, neq, in, like`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |
         | ``PowerBiReportUrl`` | Uri | ``eq, neq, in, lt, gt, leq, geq`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``CorporationName`` | String |
         | ``DashboardTypeName`` | String |
         | ``LocationName`` | String |
         | ``Name`` | String |.
        :type order_by: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelDashboardResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelDashboardResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelDashboardResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_dashboards.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelDashboardResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_dashboards.metadata = {'url': '/api/v3.0/Dashboards'}  # type: ignore

    def create_dashboard(
        self,
        body=None,  # type: Optional["_models.DashboardCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.DashboardResponse", "_models.ProblemDetails"]
        """Creates a new dashboard.

        Creates a new dashboard.

        :param body: Contains dashboard details.
        :type body: ~smartdiagnostics_sdk.models.DashboardCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DashboardResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.DashboardResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.DashboardResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_dashboard.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'DashboardCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 403, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('DashboardResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_dashboard.metadata = {'url': '/api/v3.0/Dashboards'}  # type: ignore

    def get_dashboard_templates(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelDashboardTemplateResponse", "_models.ProblemDetails"]
        """Gets dashboard templates.

        Gets dashboard templates.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``DashboardTypeId`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelDashboardTemplateResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelDashboardTemplateResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelDashboardTemplateResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_dashboard_templates.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelDashboardTemplateResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_dashboard_templates.metadata = {'url': '/api/v3.0/Dashboards/templates'}  # type: ignore

    def update_dashboard_permissions(
        self,
        id,  # type: str
        body=None,  # type: Optional["_models.DashboardPermissionsUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.DashboardResponse", "_models.ProblemDetails"]
        """Updates dashboard permissions.

        Updates dashboard permissions.

        :param id: Id of the dashboard.
        :type id: str
        :param body: Dashboard permission details.
        :type body: ~smartdiagnostics_sdk.models.DashboardPermissionsUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DashboardResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.DashboardResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.DashboardResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_dashboard_permissions.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'DashboardPermissionsUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 403, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('DashboardResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_dashboard_permissions.metadata = {'url': '/api/v3.0/Dashboards/{id}/permissions'}  # type: ignore

    def export_events(
        self,
        group_id,  # type: str
        body=None,  # type: Optional["_models.TimeRangeModelV3"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Enqueues a report that contains all events for the params.

        Enqueues a report that contains all events for the params.

        :param group_id: Id of a group.
        :type group_id: str
        :param body: Time Range.
        :type body: ~smartdiagnostics_sdk.models.TimeRangeModelV3
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.export_events.metadata['url']  # type: ignore
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'TimeRangeModelV3')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    export_events.metadata = {'url': '/api/v3.0/Events/{groupId}/export'}  # type: ignore

    def update_event(
        self,
        event_id,  # type: str
        body=None,  # type: Optional["_models.EventModelV3"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.EventModelV3", "_models.ProblemDetails"]
        """Updates an Event.

        Updates an Event.

        :param event_id:
        :type event_id: str
        :param body: New Event values.
        :type body: ~smartdiagnostics_sdk.models.EventModelV3
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EventModelV3 or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.EventModelV3 or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.EventModelV3", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_event.metadata['url']  # type: ignore
        path_format_arguments = {
            'eventId': self._serialize.url("event_id", event_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'EventModelV3')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('EventModelV3', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_event.metadata = {'url': '/api/v3.0/Events/{eventId}'}  # type: ignore

    def create_event(
        self,
        body=None,  # type: Optional["_models.EventModelV3"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.EventModelV3", "_models.ProblemDetails"]
        """Creates an event.

        Creates an event.

        :param body: Model for the new event.
        :type body: ~smartdiagnostics_sdk.models.EventModelV3
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EventModelV3 or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.EventModelV3 or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.EventModelV3", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_event.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'EventModelV3')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('EventModelV3', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_event.metadata = {'url': '/api/v3.0/Events'}  # type: ignore

    def get_location_files(
        self,
        location_id,  # type: str
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelFileResponse", "_models.ProblemDetails"]
        """Gets all files for a location.

        Gets all files for a location.

        :param location_id:
        :type location_id: str
        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``GroupIds`` | IEnumerable:code:`<Guid>` | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsRootFolder`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``ParentFolderId`` | Guid? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``TagId`` | Guid | ``eq, neq, in`` |
         | ``TagName`` | String | ``eq, neq, in, like`` |
         | ``Type`` | ContentType | ``eq, neq, in, lt, gt, leq, geq`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``CreationDate`` | DateTime |
         | ``DisplayName`` | String |
         | ``FileName`` | String |
         | ``UpdateDate`` | DateTime |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelFileResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelFileResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelFileResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_location_files.metadata['url']  # type: ignore
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelFileResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_location_files.metadata = {'url': '/api/v3.0/Files/locations/{locationId}'}  # type: ignore

    def get_corporation_files(
        self,
        corporation_id,  # type: str
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelFileResponse", "_models.ProblemDetails"]
        """Gets all files for a corporation.

        Gets all files for a corporation.

        :param corporation_id:
        :type corporation_id: str
        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``GroupIds`` | IEnumerable:code:`<Guid>` | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsRootFolder`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``ParentFolderId`` | Guid? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``TagId`` | Guid | ``eq, neq, in`` |
         | ``TagName`` | String | ``eq, neq, in, like`` |
         | ``Type`` | ContentType | ``eq, neq, in, lt, gt, leq, geq`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``CreationDate`` | DateTime |
         | ``DisplayName`` | String |
         | ``FileName`` | String |
         | ``UpdateDate`` | DateTime |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelFileResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelFileResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelFileResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_corporation_files.metadata['url']  # type: ignore
        path_format_arguments = {
            'corporationId': self._serialize.url("corporation_id", corporation_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelFileResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_corporation_files.metadata = {'url': '/api/v3.0/Files/corporations/{corporationId}'}  # type: ignore

    def get_file(
        self,
        id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.FileResponse", "_models.ProblemDetails"]
        """Gets a file.

        Gets a file.

        :param id:
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: FileResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.FileResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.FileResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_file.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('FileResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_file.metadata = {'url': '/api/v3.0/Files/{id}'}  # type: ignore

    def delete_file(
        self,
        file_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Deletes a file.

        Deletes a file.

        :param file_id: File id.
        :type file_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.delete_file.metadata['url']  # type: ignore
        path_format_arguments = {
            'fileId': self._serialize.url("file_id", file_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_file.metadata = {'url': '/api/v3.0/Files/{fileId}'}  # type: ignore

    def update_file(
        self,
        file_id,  # type: str
        body=None,  # type: Optional["_models.FilesUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.FileResponse", "_models.ProblemDetails"]
        """Update a file.

        Update a file.

        :param file_id:
        :type file_id: str
        :param body: File object to update.
        :type body: ~smartdiagnostics_sdk.models.FilesUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: FileResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.FileResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.FileResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_file.metadata['url']  # type: ignore
        path_format_arguments = {
            'fileId': self._serialize.url("file_id", file_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'FilesUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('FileResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_file.metadata = {'url': '/api/v3.0/Files/{fileId}'}  # type: ignore

    def create_file(
        self,
        type,  # type: Union[str, "_models.PostContentSchemaType"]
        parent_folder_id,  # type: str
        display_name=None,  # type: Optional[str]
        description=None,  # type: Optional[str]
        location_id=None,  # type: Optional[str]
        corporation_id=None,  # type: Optional[str]
        group_ids=None,  # type: Optional[List[str]]
        files=None,  # type: Optional[IO]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.FileResponse", "_models.ProblemDetails"]
        """Creates a file.

        Creates a file.

        :param type: Type of file.
        :type type: str or ~smartdiagnostics_sdk.models.PostContentSchemaType
        :param parent_folder_id: The id of the folder that the file is inside of.
        :type parent_folder_id: str
        :param display_name: Name of file.
        :type display_name: str
        :param description: File Description.
        :type description: str
        :param location_id: Location id of file.
        :type location_id: str
        :param corporation_id: Corporation id of file.
        :type corporation_id: str
        :param group_ids: Ids of groups the file belongs to.
        :type group_ids: list[str]
        :param files: The file that will be associated with the file model object.
        :type files: IO
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: FileResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.FileResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.FileResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "multipart/form-data")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_file.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        # Construct form data
        _form_content = {
            'Type': type,
            'DisplayName': display_name,
            'ParentFolderId': parent_folder_id,
            'Description': description,
            'LocationId': location_id,
            'CorporationId': corporation_id,
            'GroupIds': group_ids,
            'files': files,
        }
        request = self._client.post(url, query_parameters, header_parameters, form_content=_form_content)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404, 422]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('FileResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 422:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_file.metadata = {'url': '/api/v3.0/Files'}  # type: ignore

    def move_files(
        self,
        body=None,  # type: Optional["_models.MoveFilesRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.MoveFilesResponse", "_models.ProblemDetails"]
        """Moves files to a folder.

        Moves files to a folder.

        :param body: Move Request.
        :type body: ~smartdiagnostics_sdk.models.MoveFilesRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: MoveFilesResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.MoveFilesResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.MoveFilesResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.move_files.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'MoveFilesRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 403, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('MoveFilesResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    move_files.metadata = {'url': '/api/v3.0/Files/move'}  # type: ignore

    def get_indicator_filter(
        self,
        indicator_filter_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.IndicatorFilterResponse", "_models.ProblemDetails"]
        """Gets a single indicator filter.

        Gets a single indicator filter.

        :param indicator_filter_id: Id of indicator filter.
        :type indicator_filter_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IndicatorFilterResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.IndicatorFilterResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.IndicatorFilterResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_indicator_filter.metadata['url']  # type: ignore
        path_format_arguments = {
            'indicatorFilterId': self._serialize.url("indicator_filter_id", indicator_filter_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorFilterResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_indicator_filter.metadata = {'url': '/api/v3.0/Filters/Indicators/{indicatorFilterId}'}  # type: ignore

    def update_indicator_filter(
        self,
        indicator_filter_id,  # type: str
        body=None,  # type: Optional["_models.IndicatorFilterUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.IndicatorFilterResponse", "_models.ProblemDetails"]
        """Updates an indicator filter.

        Updates an indicator filter.

        :param indicator_filter_id: The id of the indicator filter.
        :type indicator_filter_id: str
        :param body: Indicator filter update request.
        :type body: ~smartdiagnostics_sdk.models.IndicatorFilterUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IndicatorFilterResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.IndicatorFilterResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.IndicatorFilterResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_indicator_filter.metadata['url']  # type: ignore
        path_format_arguments = {
            'indicatorFilterId': self._serialize.url("indicator_filter_id", indicator_filter_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'IndicatorFilterUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 403, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorFilterResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_indicator_filter.metadata = {'url': '/api/v3.0/Filters/Indicators/{indicatorFilterId}'}  # type: ignore

    def delete_indicator_filter(
        self,
        indicator_filter_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Deletes an indicator filter.

        Deletes an indicator filter.

        :param indicator_filter_id: The id of the indicator filter.
        :type indicator_filter_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.delete_indicator_filter.metadata['url']  # type: ignore
        path_format_arguments = {
            'indicatorFilterId': self._serialize.url("indicator_filter_id", indicator_filter_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204, 401, 403, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_indicator_filter.metadata = {'url': '/api/v3.0/Filters/Indicators/{indicatorFilterId}'}  # type: ignore

    def get_indicator_filters(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelIndicatorFilterResponse", "_models.ProblemDetails"]
        """Gets many indicator filters.

        Gets many indicator filters.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``IsGlobal`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |
         | ``SystemId`` | Guid | ``eq, neq, in`` |
         | ``SystemName`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``LocationName`` | String |
         | ``Name`` | String |
         | ``SortOrder`` | Int32 |
         | ``SystemName`` | String |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelIndicatorFilterResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelIndicatorFilterResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelIndicatorFilterResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_indicator_filters.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorFilterResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_indicator_filters.metadata = {'url': '/api/v3.0/Filters/Indicators'}  # type: ignore

    def create_indicator_filter(
        self,
        body=None,  # type: Optional["_models.IndicatorFilterCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.IndicatorFilterResponse", "_models.ProblemDetails"]
        """Creates an indicator filter.

        Creates an indicator filter.

        :param body: Indicator filter create request.
        :type body: ~smartdiagnostics_sdk.models.IndicatorFilterCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IndicatorFilterResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.IndicatorFilterResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.IndicatorFilterResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_indicator_filter.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'IndicatorFilterCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 403, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorFilterResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_indicator_filter.metadata = {'url': '/api/v3.0/Filters/Indicators'}  # type: ignore

    def get_group_alerts(
        self,
        group_id,  # type: str
        filter_ids=None,  # type: Optional[List[str]]
        sensor_role_type=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelGroupAlertsResponse", "_models.ProblemDetails"]
        """Gets the alerts for the given group.

        Gets the alerts for the given group.

        :param group_id: The group to get the alerts for.
        :type group_id: str
        :param filter_ids:
        :type filter_ids: list[str]
        :param sensor_role_type: SensorRoleType is an additional filtering component for limiting to X
         or Y.
        :type sensor_role_type: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelGroupAlertsResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelGroupAlertsResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelGroupAlertsResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_group_alerts.metadata['url']  # type: ignore
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter_ids is not None:
            query_parameters['FilterIds'] = self._serialize.query("filter_ids", filter_ids, '[str]', div=',')
        if sensor_role_type is not None:
            query_parameters['SensorRoleType'] = self._serialize.query("sensor_role_type", sensor_role_type, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelGroupAlertsResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_group_alerts.metadata = {'url': '/api/v3.0/Groups/{groupId}/alerts'}  # type: ignore

    def create_spectrum_chart_settings(
        self,
        group_id,  # type: str
        body=None,  # type: Optional["_models.SpectrumChartSettingsCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.SpectrumChartSettingsResponse", "_models.ProblemDetails"]
        """Creates the Spectrum Chart settings for a group.

        Creates the Spectrum Chart settings for a group.

        :param group_id:
        :type group_id: str
        :param body: Contains chart setting info for the Frequency and Time Domains.
        :type body: ~smartdiagnostics_sdk.models.SpectrumChartSettingsCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SpectrumChartSettingsResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.SpectrumChartSettingsResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.SpectrumChartSettingsResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_spectrum_chart_settings.metadata['url']  # type: ignore
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'SpectrumChartSettingsCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('SpectrumChartSettingsResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_spectrum_chart_settings.metadata = {'url': '/api/v3.0/Groups/{groupId}/spectrumChartSettings'}  # type: ignore

    def get_spectrum_chart_settings(
        self,
        group_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.SpectrumChartSettingsResponse", "_models.ProblemDetails"]
        """Gets the Spectrum Chart Settings for a given group.

        Gets the Spectrum Chart Settings for a given group.

        :param group_id: The group to retrieve the spectrum chart settings for.
        :type group_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SpectrumChartSettingsResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.SpectrumChartSettingsResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.SpectrumChartSettingsResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_spectrum_chart_settings.metadata['url']  # type: ignore
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('SpectrumChartSettingsResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_spectrum_chart_settings.metadata = {'url': '/api/v3.0/Groups/{groupId}/spectrumChartSettings'}  # type: ignore

    def get_bearings_for_group(
        self,
        group_id,  # type: str
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelBearingResponse", "_models.ProblemDetails"]
        """Gets all bearings for a group.

        Gets all bearings for a group.

        :param group_id:
        :type group_id: str
        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Manufacturer`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |
         | ``RollerCount`` | Int64 | ``eq, neq, in, lt, gt, leq, geq`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Bpfi`` | Double |
         | ``Bpfo`` | Double |
         | ``Bsf`` | Double |
         | ``Ftf`` | Double |
         | ``Manufacturer`` | String |
         | ``Name`` | String |
         | ``RollerCount`` | Int64 |.
        :type order_by: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelBearingResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelBearingResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelBearingResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_bearings_for_group.metadata['url']  # type: ignore
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelBearingResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_bearings_for_group.metadata = {'url': '/api/v3.0/Groups/{groupId}/bearings'}  # type: ignore

    def update_bearings_for_group(
        self,
        group_id,  # type: str
        body=None,  # type: Optional["_models.UpdateBearingsForGroupRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union[List["_models.BearingResponse"], "_models.ProblemDetails"]
        """Updates bearings for a group.

        Updates bearings for a group.

        :param group_id:
        :type group_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.UpdateBearingsForGroupRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of BearingResponse or ProblemDetails, or the result of cls(response)
        :rtype: list[~smartdiagnostics_sdk.models.BearingResponse] or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union[List["_models.BearingResponse"], "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_bearings_for_group.metadata['url']  # type: ignore
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'UpdateBearingsForGroupRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('[BearingResponse]', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_bearings_for_group.metadata = {'url': '/api/v3.0/Groups/{groupId}/bearings'}  # type: ignore

    def get_hardware_events_for_account(
        self,
        location_id,  # type: str
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelHardwareEventModelV3", "_models.ProblemDetails"]
        """Gets a listing of hardware event logs for a location.

        Gets a listing of hardware event logs for a location.

        :param location_id:
        :type location_id: str
        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``EventType`` | String | ``eq, neq, in, like`` |
         | ``HardwareType`` | String | ``eq, neq, in, like`` |
         | ``TimeAcked`` | DateTime? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``TimeEntered`` | DateTime | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``TimeExited`` | DateTime? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``TimeNotified`` | DateTime | ``eq, neq, in, lt, gt, leq, geq`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``EventType`` | String |
         | ``HardwareType`` | String |
         | ``TimeAcked`` | DateTime? |
         | ``TimeEntered`` | DateTime |
         | ``TimeExited`` | DateTime? |
         | ``TimeNotified`` | DateTime |.
        :type order_by: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelHardwareEventModelV3 or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelHardwareEventModelV3 or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelHardwareEventModelV3", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_hardware_events_for_account.metadata['url']  # type: ignore
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelHardwareEventModelV3', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_hardware_events_for_account.metadata = {'url': '/api/v3.0/HardwareEvents/location/{locationId}'}  # type: ignore

    def get_collectors_status(
        self,
        filter=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.HardwareStatusResponse", "_models.ProblemDetails"]
        """Gets the online status for the desired base stations.

        Gets the online status for the desired base stations.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HardwareStatusResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.HardwareStatusResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.HardwareStatusResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_collectors_status.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('HardwareStatusResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_collectors_status.metadata = {'url': '/api/v3.0/HardwareStatus/baseStations'}  # type: ignore

    def get_repeaters_status(
        self,
        filter=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.HardwareStatusResponse", "_models.ProblemDetails"]
        """Gets the online status for repeaters, grouped by location.

        Gets the online status for repeaters, grouped by location.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HardwareStatusResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.HardwareStatusResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.HardwareStatusResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_repeaters_status.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('HardwareStatusResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_repeaters_status.metadata = {'url': '/api/v3.0/HardwareStatus/repeaters'}  # type: ignore

    def get_nodes_status(
        self,
        filter=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.HardwareStatusResponse", "_models.ProblemDetails"]
        """Gets all status for nodes.

        Gets all status for nodes.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HardwareStatusResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.HardwareStatusResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.HardwareStatusResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_nodes_status.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('HardwareStatusResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_nodes_status.metadata = {'url': '/api/v3.0/HardwareStatus/nodes'}  # type: ignore

    def get_hubs_status(
        self,
        filter=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.HardwareStatusResponse", "_models.ProblemDetails"]
        """Gets all status for hubs.

        Gets all status for hubs.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HardwareStatusResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.HardwareStatusResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.HardwareStatusResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_hubs_status.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('HardwareStatusResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_hubs_status.metadata = {'url': '/api/v3.0/HardwareStatus/hubs'}  # type: ignore

    def get_hubs(
        self,
        include_online_status=False,  # type: Optional[bool]
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelHubResponse", "_models.ProblemDetails"]
        """Gets all hubs a user has access to.

        Gets all hubs a user has access to.

        :param include_online_status:
        :type include_online_status: bool
        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelHubResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelHubResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelHubResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_hubs.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if include_online_status is not None:
            query_parameters['includeOnlineStatus'] = self._serialize.query("include_online_status", include_online_status, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelHubResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_hubs.metadata = {'url': '/api/v3.0/Hubs'}  # type: ignore

    def get_hub(
        self,
        hub_id,  # type: int
        include_online_status=False,  # type: Optional[bool]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.HubResponse", "_models.ProblemDetails"]
        """Returns a single Hub with the supplied Id.

        Returns a single Hub with the supplied Id.

        :param hub_id: The Id of the Hub.
        :type hub_id: long
        :param include_online_status:
        :type include_online_status: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HubResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.HubResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.HubResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_hub.metadata['url']  # type: ignore
        path_format_arguments = {
            'hubId': self._serialize.url("hub_id", hub_id, 'long'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if include_online_status is not None:
            query_parameters['includeOnlineStatus'] = self._serialize.query("include_online_status", include_online_status, 'bool')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('HubResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_hub.metadata = {'url': '/api/v3.0/Hubs/{hubId}'}  # type: ignore

    def get_indicator_group(
        self,
        indicator_group_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.IndicatorGroupResponse", "_models.ProblemDetails"]
        """Gets a indicatorGroup.

        Gets a indicatorGroup.

        :param indicator_group_id:
        :type indicator_group_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IndicatorGroupResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.IndicatorGroupResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.IndicatorGroupResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_indicator_group.metadata['url']  # type: ignore
        path_format_arguments = {
            'indicatorGroupId': self._serialize.url("indicator_group_id", indicator_group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorGroupResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups/{indicatorGroupId}'}  # type: ignore

    def update_indicator_group(
        self,
        indicator_group_id,  # type: str
        body=None,  # type: Optional["_models.IndicatorGroupUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.IndicatorGroupResponse", "_models.ProblemDetails"]
        """Updates a indicatorGroup.

        Updates a indicatorGroup.

        :param indicator_group_id:
        :type indicator_group_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.IndicatorGroupUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IndicatorGroupResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.IndicatorGroupResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.IndicatorGroupResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_indicator_group.metadata['url']  # type: ignore
        path_format_arguments = {
            'indicatorGroupId': self._serialize.url("indicator_group_id", indicator_group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'IndicatorGroupUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorGroupResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups/{indicatorGroupId}'}  # type: ignore

    def delete_indicator_group(
        self,
        indicator_group_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Deletes a indicatorGroup.

        Deletes a indicatorGroup.

        :param indicator_group_id:
        :type indicator_group_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.delete_indicator_group.metadata['url']  # type: ignore
        path_format_arguments = {
            'indicatorGroupId': self._serialize.url("indicator_group_id", indicator_group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups/{indicatorGroupId}'}  # type: ignore

    def get_indicator_groups(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelIndicatorGroupResponse", "_models.ProblemDetails"]
        """Gets indicatorGroups.

        Gets indicatorGroups.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Abbreviation`` | String | ``eq, neq, in, like`` |
         | ``Active`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``CorporationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``CorporationName`` | String | ``eq, neq, in, like`` |
         | ``Created`` | DateTime | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsPaused`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Abbreviation`` | String |
         | ``CorporationName`` | String |
         | ``Created`` | DateTime |
         | ``LocationName`` | String |
         | ``Name`` | String |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelIndicatorGroupResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelIndicatorGroupResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelIndicatorGroupResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_indicator_groups.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorGroupResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_indicator_groups.metadata = {'url': '/api/v3.0/IndicatorGroups'}  # type: ignore

    def create_indicator_group(
        self,
        body=None,  # type: Optional["_models.IndicatorGroupCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.IndicatorGroupResponse", "_models.ProblemDetails"]
        """Creates a indicatorGroup.

        Creates a indicatorGroup.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.IndicatorGroupCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IndicatorGroupResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.IndicatorGroupResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.IndicatorGroupResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_indicator_group.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'IndicatorGroupCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorGroupResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups'}  # type: ignore

    def move_indicator_group(
        self,
        indicator_group_id,  # type: str
        body=None,  # type: Optional["_models.GroupMoveRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.IndicatorGroupResponse", "_models.ProblemDetails"]
        """Moves a indicatorGroup.

        Moves a indicatorGroup.

        :param indicator_group_id:
        :type indicator_group_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.GroupMoveRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IndicatorGroupResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.IndicatorGroupResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.IndicatorGroupResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.move_indicator_group.metadata['url']  # type: ignore
        path_format_arguments = {
            'indicatorGroupId': self._serialize.url("indicator_group_id", indicator_group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'GroupMoveRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorGroupResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    move_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups/{indicatorGroupId}/Move'}  # type: ignore

    def get_burst_data_audio(
        self,
        indicator_id,  # type: str
        utc_timestamp,  # type: int
        **kwargs  # type: Any
    ):
        # type: (...) -> Union[object, "_models.ProblemDetails"]
        """Generates audio from Indicator burst data.  Only vibration Indicators are supported.

        Generates audio from Indicator burst data.  Only vibration Indicators are supported.

        :param indicator_id: The indicator to generate audio for.
        :type indicator_id: str
        :param utc_timestamp: The UTC timestamp used to locate the burst data used to generate the
         audio.
        :type utc_timestamp: long
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: object or ProblemDetails, or the result of cls(response)
        :rtype: object or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union[object, "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_burst_data_audio.metadata['url']  # type: ignore
        path_format_arguments = {
            'indicatorId': self._serialize.url("indicator_id", indicator_id, 'str'),
            'utcTimestamp': self._serialize.url("utc_timestamp", utc_timestamp, 'long'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('object', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_burst_data_audio.metadata = {'url': '/api/v3.0/Indicators/{indicatorId}/burstDataAudio/{utcTimestamp}'}  # type: ignore

    def get_indicators(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelIndicatorResponse", "_models.ProblemDetails"]
        """Gets indicator responses.

        Gets indicator responses.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``FilterId`` | Guid | ``eq, neq, in`` |
         | ``GroupId`` | Guid | ``eq, neq, in`` |
         | ``IndicatorType`` | MetricTypeCodes | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``SensorRoleType`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``CorporationId`` | Guid |
         | ``Id`` | Guid |
         | ``LocationId`` | Guid |
         | ``SensorRoleType`` | String |
         | ``SystemSortOrder`` | Int32 |.
        :type order_by: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelIndicatorResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelIndicatorResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelIndicatorResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_indicators.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_indicators.metadata = {'url': '/api/v3.0/Indicators'}  # type: ignore

    def get_indicator_alarm_state(
        self,
        indicator_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.IndicatorAlarmStateResponse", "_models.ProblemDetails"]
        """Get the alarm state for a specific indicator.

        Get the alarm state for a specific indicator.

        :param indicator_id: Id of specific indicator.
        :type indicator_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IndicatorAlarmStateResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.IndicatorAlarmStateResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.IndicatorAlarmStateResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_indicator_alarm_state.metadata['url']  # type: ignore
        path_format_arguments = {
            'indicatorId': self._serialize.url("indicator_id", indicator_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorAlarmStateResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_indicator_alarm_state.metadata = {'url': '/api/v3.0/Indicators/{indicatorId}/alarmState'}  # type: ignore

    def get_indicators_alarm_state(
        self,
        filter=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union[List["_models.IndicatorAlarmStateResponse"], "_models.ProblemDetails"]
        """Get the alarm state for a list of indicators.

        Get the alarm state for a list of indicators.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Id`` | Guid | ``eq, neq, in`` |.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of IndicatorAlarmStateResponse or ProblemDetails, or the result of cls(response)
        :rtype: list[~smartdiagnostics_sdk.models.IndicatorAlarmStateResponse] or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union[List["_models.IndicatorAlarmStateResponse"], "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_indicators_alarm_state.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('[IndicatorAlarmStateResponse]', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_indicators_alarm_state.metadata = {'url': '/api/v3.0/Indicators/alarmState'}  # type: ignore

    def get_indicator_types(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelIndicatorTypesResponse", "_models.ProblemDetails"]
        """Gets indicator types.

        Gets indicator types.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Name`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Id`` | Int32 |
         | ``Name`` | String |.
        :type order_by: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelIndicatorTypesResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelIndicatorTypesResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelIndicatorTypesResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_indicator_types.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorTypesResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_indicator_types.metadata = {'url': '/api/v3.0/Indicators/Types'}  # type: ignore

    def get_installs(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelInstallResponse", "_models.ProblemDetails"]
        """Gets a list of installs for the current user.

        Gets a list of installs for the current user.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Active`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``CorporationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``CorporationName`` | String | ``eq, neq, in, like`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |
         | ``UserEmail`` | String | ``eq, neq, in, like`` |
         | ``UserFirstName`` | String | ``eq, neq, in, like`` |
         | ``UserLastName`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Active`` | Boolean |
         | ``EndDate`` | DateTime? |
         | ``Name`` | String |
         | ``StartDate`` | DateTime |
         | ``UserEmail`` | String |
         | ``UserFirstName`` | String |
         | ``UserLastName`` | String |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelInstallResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelInstallResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelInstallResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_installs.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelInstallResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_installs.metadata = {'url': '/api/v3.0/Installs'}  # type: ignore

    def get_install(
        self,
        id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.InstallResponse", "_models.ProblemDetails"]
        """Gets a single Install.

        Gets a single Install.

        :param id: Id of install.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: InstallResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.InstallResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.InstallResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_install.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('InstallResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_install.metadata = {'url': '/api/v3.0/Installs/{id}'}  # type: ignore

    def update_install(
        self,
        id,  # type: str
        body=None,  # type: Optional["_models.InstallUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.InstallResponse", "_models.ProblemDetails"]
        """Updates properties related to an install.

        Updates properties related to an install.

        :param id: the Guid for the install.
        :type id: str
        :param body: the model containing the properties to update.
        :type body: ~smartdiagnostics_sdk.models.InstallUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: InstallResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.InstallResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.InstallResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_install.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'InstallUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('InstallResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_install.metadata = {'url': '/api/v3.0/Installs/{id}'}  # type: ignore

    def add_users_to_install(
        self,
        id,  # type: str
        body=None,  # type: Optional["_models.InstallModifyUsersRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.InstallAddUserResponse", "_models.ProblemDetails"]
        """Adds one or more users to an install.

        Adds one or more users to an install.

        :param id: Id of an install.
        :type id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.InstallModifyUsersRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: InstallAddUserResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.InstallAddUserResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.InstallAddUserResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.add_users_to_install.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'InstallModifyUsersRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('InstallAddUserResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    add_users_to_install.metadata = {'url': '/api/v3.0/Installs/{id}/users'}  # type: ignore

    def remove_users_from_install(
        self,
        id,  # type: str
        body=None,  # type: Optional["_models.InstallModifyUsersRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.InstallResponse", "_models.ProblemDetails"]
        """Removes one or more users from an install.

        Removes one or more users from an install.

        :param id: Id of an install.
        :type id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.InstallModifyUsersRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: InstallResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.InstallResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.InstallResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.remove_users_from_install.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'InstallModifyUsersRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.delete(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('InstallResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    remove_users_from_install.metadata = {'url': '/api/v3.0/Installs/{id}/users'}  # type: ignore

    def get_node_install_status(
        self,
        install_id,  # type: str
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelInstallNodeResponse", "_models.ProblemDetails"]
        """Gets a list of nodes per install.

        Gets a list of nodes per install.

        :param install_id: Id of an install.
        :type install_id: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelInstallNodeResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelInstallNodeResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelInstallNodeResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_node_install_status.metadata['url']  # type: ignore
        path_format_arguments = {
            'installId': self._serialize.url("install_id", install_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelInstallNodeResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_node_install_status.metadata = {'url': '/api/v3.0/Installs/{installId}/nodes'}  # type: ignore

    def update_node_install_status(
        self,
        install_id,  # type: str
        node_id,  # type: int
        body=None,  # type: Optional["_models.InstallNodeUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.InstallNodeResponse", "_models.ProblemDetails"]
        """Updates a node's status for the install.

        Updates a node's status for the install.

        :param install_id: Id of install.
        :type install_id: str
        :param node_id: Id of node.
        :type node_id: long
        :param body: Status to change node to and accompanying note.
        :type body: ~smartdiagnostics_sdk.models.InstallNodeUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: InstallNodeResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.InstallNodeResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.InstallNodeResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_node_install_status.metadata['url']  # type: ignore
        path_format_arguments = {
            'installId': self._serialize.url("install_id", install_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'long'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'InstallNodeUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('InstallNodeResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_node_install_status.metadata = {'url': '/api/v3.0/Installs/{installId}/nodes/{nodeId}'}  # type: ignore

    def export_install_report(
        self,
        install_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Triggers a Hangfire job that will email an install's status report to the user.

        Triggers a Hangfire job that will email an install's status report to the user.

        :param install_id:
        :type install_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.export_install_report.metadata['url']  # type: ignore
        path_format_arguments = {
            'installId': self._serialize.url("install_id", install_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    export_install_report.metadata = {'url': '/api/v3.0/Installs/{installId}/exportReport'}  # type: ignore

    def get_locations(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelLocationResponse", "_models.ProblemDetails"]
        """Returns a paged list of all locations that the user has access to.

        Returns a paged list of all locations that the user has access to.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Abbreviation`` | String | ``eq, neq, in, like`` |
         | ``Active`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``CorporationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``CorporationName`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Abbreviation`` | String |
         | ``Active`` | Boolean |
         | ``CorporationName`` | String |
         | ``Name`` | String |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelLocationResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelLocationResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelLocationResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_locations.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelLocationResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_locations.metadata = {'url': '/api/v3.0/Locations'}  # type: ignore

    def create_location(
        self,
        body=None,  # type: Optional["_models.LocationCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.LocationResponse", "_models.ProblemDetails"]
        """Creates a new location.

        Creates a new location.

        :param body: Model for new location.
        :type body: ~smartdiagnostics_sdk.models.LocationCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LocationResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.LocationResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.LocationResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_location.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'LocationCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('LocationResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_location.metadata = {'url': '/api/v3.0/Locations'}  # type: ignore

    def get_location(
        self,
        location_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.LocationResponse", "_models.ProblemDetails"]
        """Gets a specific location.

        Gets a specific location.

        :param location_id: Id of location.
        :type location_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LocationResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.LocationResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.LocationResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_location.metadata['url']  # type: ignore
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('LocationResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_location.metadata = {'url': '/api/v3.0/Locations/{locationId}'}  # type: ignore

    def get_location_roi(
        self,
        location_id,  # type: str
        start_date=None,  # type: Optional[datetime.datetime]
        end_date=None,  # type: Optional[datetime.datetime]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.RoiResponse", "_models.ProblemDetails"]
        """Gets ROI information for a location.

        Gets ROI information for a location.

        :param location_id:
        :type location_id: str
        :param start_date:
        :type start_date: ~datetime.datetime
        :param end_date:
        :type end_date: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RoiResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.RoiResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.RoiResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_location_roi.metadata['url']  # type: ignore
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if start_date is not None:
            query_parameters['StartDate'] = self._serialize.query("start_date", start_date, 'iso-8601')
        if end_date is not None:
            query_parameters['EndDate'] = self._serialize.query("end_date", end_date, 'iso-8601')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('RoiResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_location_roi.metadata = {'url': '/api/v3.0/Locations/{locationId}/roi'}  # type: ignore

    def get_monitoring_point(
        self,
        id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.MonitoringPointResponse", "_models.ProblemDetails"]
        """Gets a Monitoring Point.

        Gets a Monitoring Point.

        :param id:
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: MonitoringPointResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.MonitoringPointResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.MonitoringPointResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_monitoring_point.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('MonitoringPointResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_monitoring_point.metadata = {'url': '/api/v3.0/MonitoringPoints/{id}'}  # type: ignore

    def get_monitoring_points(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelMonitoringPointResponse", "_models.ProblemDetails"]
        """Gets Monitoring Points.

        Gets Monitoring Points.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Abbreviation`` | String | ``eq, neq, in, like`` |
         | ``Active`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``BearingId`` | Guid | ``eq, neq, in`` |
         | ``CorporationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``CorporationName`` | String | ``eq, neq, in, like`` |
         | ``Created`` | DateTime | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsPaused`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``MonitoringPointType`` | MonitoringPointTypeCodesForApi | ``eq, neq, in, lt, gt, leq, geq``
         |
         | ``Name`` | String | ``eq, neq, in, like`` |
         | ``NodeId`` | Int64 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``NodeSerialNumber`` | String | ``eq, neq, in, like`` |
         | ``ParentId`` | Guid | ``eq, neq, in`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Abbreviation`` | String |
         | ``CorporationName`` | String |
         | ``Created`` | DateTime |
         | ``LocationName`` | String |
         | ``Name`` | String |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelMonitoringPointResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelMonitoringPointResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelMonitoringPointResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_monitoring_points.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelMonitoringPointResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_monitoring_points.metadata = {'url': '/api/v3.0/MonitoringPoints'}  # type: ignore

    def get_monitoring_point_type_codes(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Union[List["_models.MonitoringPointTypeCodeModel"], "_models.ProblemDetails"]
        """get_monitoring_point_type_codes.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of MonitoringPointTypeCodeModel or ProblemDetails, or the result of cls(response)
        :rtype: list[~smartdiagnostics_sdk.models.MonitoringPointTypeCodeModel] or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union[List["_models.MonitoringPointTypeCodeModel"], "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_monitoring_point_type_codes.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('[MonitoringPointTypeCodeModel]', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_monitoring_point_type_codes.metadata = {'url': '/api/v3.0/MonitoringPointTypeCodes'}  # type: ignore

    def get_nodes(
        self,
        include_state=False,  # type: Optional[bool]
        is_slim=False,  # type: Optional[bool]
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelNodeResponse", "_models.ProblemDetails"]
        """Gets a paginated list of the nodes to which a user has access.

        Gets a paginated list of the nodes to which a user has access.

        :param include_state:
        :type include_state: bool
        :param is_slim:
        :type is_slim: bool
        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelNodeResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelNodeResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelNodeResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_nodes.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')
        if is_slim is not None:
            query_parameters['isSlim'] = self._serialize.query("is_slim", is_slim, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelNodeResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_nodes.metadata = {'url': '/api/v3.0/Nodes'}  # type: ignore

    def get_node(
        self,
        node_id,  # type: int
        include_state=False,  # type: Optional[bool]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.NodeResponse", "_models.ProblemDetails"]
        """Gets the requested node.

        Gets the requested node.

        :param node_id: The ID of the node.
        :type node_id: long
        :param include_state: Query parameter used to specify if the returned NodeResponse
                    should include certain properties.
        :type include_state: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: NodeResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.NodeResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.NodeResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_node.metadata['url']  # type: ignore
        path_format_arguments = {
            'nodeId': self._serialize.url("node_id", node_id, 'long'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('NodeResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_node.metadata = {'url': '/api/v3.0/Nodes/{nodeId}'}  # type: ignore

    def export_long_burst(
        self,
        long_burst_id,  # type: int
        node_id,  # type: int
        **kwargs  # type: Any
    ):
        # type: (...) -> Union[object, "_models.ProblemDetails"]
        """export_long_burst.

        :param long_burst_id:
        :type long_burst_id: long
        :param node_id:
        :type node_id: long
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: object or ProblemDetails, or the result of cls(response)
        :rtype: object or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union[object, "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.export_long_burst.metadata['url']  # type: ignore
        path_format_arguments = {
            'longBurstId': self._serialize.url("long_burst_id", long_burst_id, 'long'),
            'nodeId': self._serialize.url("node_id", node_id, 'long'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('object', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    export_long_burst.metadata = {'url': '/api/v3.0/Nodes/{nodeId}/longBurst/{longBurstId}/export'}  # type: ignore

    def get_picture(
        self,
        id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PicturesModelV3", "_models.ProblemDetails"]
        """Returns a single picture.

        Returns a single picture.

        :param id: Picture Id.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PicturesModelV3 or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PicturesModelV3 or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PicturesModelV3", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_picture.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PicturesModelV3', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_picture.metadata = {'url': '/api/v3.0/Pictures/{id}'}  # type: ignore

    def get_pictures(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelPicturesModelV3", "_models.ProblemDetails"]
        """Returns a paged list of all pictures.

        Returns a paged list of all pictures.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelPicturesModelV3 or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelPicturesModelV3 or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelPicturesModelV3", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_pictures.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPicturesModelV3', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_pictures.metadata = {'url': '/api/v3.0/Pictures'}  # type: ignore

    def get_pictures_for_group(
        self,
        group_id,  # type: str
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelPicturesModelV3", "_models.ProblemDetails"]
        """Get a paged list of pictures associated with a group.

        Get a paged list of pictures associated with a group.

        :param group_id: The GUID of the group.
        :type group_id: str
        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |.
        :type order_by: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelPicturesModelV3 or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelPicturesModelV3 or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelPicturesModelV3", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_pictures_for_group.metadata['url']  # type: ignore
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPicturesModelV3', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_pictures_for_group.metadata = {'url': '/api/v3.0/Pictures/group/{groupId}'}  # type: ignore

    def assign_pictures_to_group(
        self,
        group_id,  # type: str
        body=None,  # type: Optional[List[str]]
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Associate an ordered list of pictures to a group.

        Associate an ordered list of pictures to a group.

        :param group_id: The GUID of the group to assign pictures to.
        :type group_id: str
        :param body: An ordered list of picture GUIDs to associate with the group.
        :type body: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.assign_pictures_to_group.metadata['url']  # type: ignore
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, '[str]')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    assign_pictures_to_group.metadata = {'url': '/api/v3.0/Pictures/group/{groupId}'}  # type: ignore

    def get_pictures_for_location(
        self,
        location_id,  # type: str
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelPicturesModelV3", "_models.ProblemDetails"]
        """Returns a paged list of pictures associated with an account.

        Returns a paged list of pictures associated with an account.

        :param location_id: The GUID of the account/location.
        :type location_id: str
        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelPicturesModelV3 or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelPicturesModelV3 or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelPicturesModelV3", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_pictures_for_location.metadata['url']  # type: ignore
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPicturesModelV3', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_pictures_for_location.metadata = {'url': '/api/v3.0/Pictures/location/{locationId}'}  # type: ignore

    def get_property(
        self,
        property_id,  # type: int
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PropertyResponse", "_models.ProblemDetails"]
        """Gets an Property.

        Gets an Property.

        :param property_id:
        :type property_id: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PropertyResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PropertyResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PropertyResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_property.metadata['url']  # type: ignore
        path_format_arguments = {
            'propertyId': self._serialize.url("property_id", property_id, 'int'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PropertyResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_property.metadata = {'url': '/api/v3.0/Properties/{propertyId}'}  # type: ignore

    def get_properties(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelPropertyResponse", "_models.ProblemDetails"]
        """Gets Properties.

        Gets Properties.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Name`` | String | ``eq, neq, in, like`` |
         | ``ValueType`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Name`` | String |
         | ``ValueType`` | String |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelPropertyResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelPropertyResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelPropertyResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_properties.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPropertyResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_properties.metadata = {'url': '/api/v3.0/Properties'}  # type: ignore

    def get_receivers(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelReceiverResponse", "_models.ProblemDetails"]
        """Gets receivers.

        Gets receivers.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``CorporationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``CorporationName`` | String | ``eq, neq, in, like`` |
         | ``FirmwareVersion`` | String | ``eq, neq, in, like`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``MacAddress`` | String | ``eq, neq, in, like`` |
         | ``NetworkId`` | String | ``eq, neq, in, like`` |
         | ``Nickname`` | String | ``eq, neq, in, like`` |
         | ``PendingRfChannel`` | Int32? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``RadioMacAddress`` | String | ``eq, neq, in, like`` |
         | ``ReceiverType`` | ReceiverType | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``RfChannel`` | Int32? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``SerialNumber`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``CorporationName`` | String |
         | ``FirmwareVersion`` | String |
         | ``LocationName`` | String |
         | ``MacAddress`` | String |
         | ``NetworkId`` | String |
         | ``Nickname`` | String |
         | ``PendingRfChannel`` | Int32? |
         | ``RadioMacAddress`` | String |
         | ``ReceiverType`` | ReceiverType |
         | ``RfChannel`` | Int32? |
         | ``SerialNumber`` | String |.
        :type order_by: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelReceiverResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelReceiverResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelReceiverResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_receivers.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelReceiverResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_receivers.metadata = {'url': '/api/v3.0/Receivers'}  # type: ignore

    def get_receiver(
        self,
        receiver_id,  # type: int
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.ReceiverResponse", "_models.ProblemDetails"]
        """Gets a receiver.

        Gets a receiver.

        :param receiver_id:
        :type receiver_id: long
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ReceiverResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ReceiverResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.ReceiverResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_receiver.metadata['url']  # type: ignore
        path_format_arguments = {
            'receiverId': self._serialize.url("receiver_id", receiver_id, 'long'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('ReceiverResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_receiver.metadata = {'url': '/api/v3.0/Receivers/{receiverId}'}  # type: ignore

    def get_repeater(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelRepeaterModelV3", "_models.ProblemDetails"]
        """Get receivers subject to query options.

        Get receivers subject to query options.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelRepeaterModelV3 or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelRepeaterModelV3 or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelRepeaterModelV3", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_repeater.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelRepeaterModelV3', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_repeater.metadata = {'url': '/api/v3.0/Repeaters'}  # type: ignore

    def request_base_station_report(
        self,
        ids=None,  # type: Optional[List[str]]
        file_name=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """This will download a base station and repeater hardware report for the locations provided in the details model.

        This will download a base station and repeater hardware report for the locations provided in
        the details model.

        :param ids: A list of Locations Guids whose hardware should appear in the report.
        :type ids: list[str]
        :param file_name: The Name of the File.
        :type file_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.request_base_station_report.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if ids is not None:
            query_parameters['Ids'] = self._serialize.query("ids", ids, '[str]', div=',')
        if file_name is not None:
            query_parameters['FileName'] = self._serialize.query("file_name", file_name, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    request_base_station_report.metadata = {'url': '/api/v3.0/Reports/hardware/basestation'}  # type: ignore

    def request_low_battery_report(
        self,
        location_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """This will download a low battery report for the location provided in the details model.

        This will download a low battery report for the location provided in the details model.

        :param location_id: Id of the location whose nodes will appear in the report.
        :type location_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.request_low_battery_report.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['LocationId'] = self._serialize.query("location_id", location_id, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    request_low_battery_report.metadata = {'url': '/api/v3.0/Reports/hardware/lowBattery'}  # type: ignore

    def request_statistics_report(
        self,
        group_id,  # type: str
        body=None,  # type: Optional["_models.StatisticsReportRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Emails a statistics report for the group provided using the options provided.

        Emails a statistics report for the group provided using the options provided.

        :param group_id: Id of the group to run the report on.
        :type group_id: str
        :param body: Contains the options for the report.
        :type body: ~smartdiagnostics_sdk.models.StatisticsReportRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.request_statistics_report.metadata['url']  # type: ignore
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'StatisticsReportRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    request_statistics_report.metadata = {'url': '/api/v3.0/Reports/statistics/group/{groupId}'}  # type: ignore

    def request_heatmap_report(
        self,
        group_id,  # type: str
        body=None,  # type: Optional["_models.HeatmapReportRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Enqueues a job to run and later email a heatmap report for the group provided using the options provided.

        Enqueues a job to run and later email a heatmap report for the group provided using the options
        provided.

        :param group_id: Id of the group to run the report on.
        :type group_id: str
        :param body: Contains the options for the report.
        :type body: ~smartdiagnostics_sdk.models.HeatmapReportRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.request_heatmap_report.metadata['url']  # type: ignore
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'HeatmapReportRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    request_heatmap_report.metadata = {'url': '/api/v3.0/Reports/heatmap/group/{groupId}'}  # type: ignore

    def run_setup_tool_job(
        self,
        job_type,  # type: str
        location_id=None,  # type: Optional[str]
        file=None,  # type: Optional[IO]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.JobModelV3", "_models.ProblemDetails"]
        """Enqueues a job of the given type to be run.

        Enqueues a job of the given type to be run.

        :param job_type: The type of job to run.
        :type job_type: str
        :param location_id: The location to run the job for.
        :type location_id: str
        :param file: The file to be processed.
        :type file: IO
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobModelV3 or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.JobModelV3 or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.JobModelV3", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "multipart/form-data")
        accept = "application/json, text/json"

        # Construct URL
        url = self.run_setup_tool_job.metadata['url']  # type: ignore
        path_format_arguments = {
            'jobType': self._serialize.url("job_type", job_type, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        # Construct form data
        _form_content = {
            'locationId': location_id,
            'file': file,
        }
        request = self._client.post(url, query_parameters, header_parameters, form_content=_form_content)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202, 400, 401, 404, 415]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 202:
            deserialized = self._deserialize('JobModelV3', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 415:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    run_setup_tool_job.metadata = {'url': '/api/v3.0/SetupTools/{jobType}'}  # type: ignore

    def get_spreadsheet(
        self,
        job_type,  # type: str
        location_id=None,  # type: Optional[str]
        filter_id=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union[object, "_models.ProblemDetails"]
        """Gets the template spreadsheet for the given job type.

        Gets the template spreadsheet for the given job type.

        :param job_type: The job type to get the template for.
        :type job_type: str
        :param location_id: The location to get the template for.
        :type location_id: str
        :param filter_id:
        :type filter_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: object or ProblemDetails, or the result of cls(response)
        :rtype: object or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union[object, "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_spreadsheet.metadata['url']  # type: ignore
        path_format_arguments = {
            'jobType': self._serialize.url("job_type", job_type, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if location_id is not None:
            query_parameters['locationId'] = self._serialize.query("location_id", location_id, 'str')
        if filter_id is not None:
            query_parameters['filterId'] = self._serialize.query("filter_id", filter_id, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('object', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_spreadsheet.metadata = {'url': '/api/v3.0/SetupTools/{jobType}'}  # type: ignore

    def get_sub_system(
        self,
        sub_system_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.SubSystemResponse", "_models.ProblemDetails"]
        """Gets a subSystem.

        Gets a subSystem.

        :param sub_system_id:
        :type sub_system_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SubSystemResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.SubSystemResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.SubSystemResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_sub_system.metadata['url']  # type: ignore
        path_format_arguments = {
            'subSystemId': self._serialize.url("sub_system_id", sub_system_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('SubSystemResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_sub_system.metadata = {'url': '/api/v3.0/SubSystems/{subSystemId}'}  # type: ignore

    def update_sub_system(
        self,
        sub_system_id,  # type: str
        body=None,  # type: Optional["_models.SubSystemUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.SubSystemResponse", "_models.ProblemDetails"]
        """Updates a subSystem.

        Updates a subSystem.

        :param sub_system_id:
        :type sub_system_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.SubSystemUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SubSystemResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.SubSystemResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.SubSystemResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_sub_system.metadata['url']  # type: ignore
        path_format_arguments = {
            'subSystemId': self._serialize.url("sub_system_id", sub_system_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'SubSystemUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('SubSystemResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_sub_system.metadata = {'url': '/api/v3.0/SubSystems/{subSystemId}'}  # type: ignore

    def delete_sub_system(
        self,
        sub_system_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Deletes a subSystem.

        Deletes a subSystem.

        :param sub_system_id:
        :type sub_system_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.delete_sub_system.metadata['url']  # type: ignore
        path_format_arguments = {
            'subSystemId': self._serialize.url("sub_system_id", sub_system_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_sub_system.metadata = {'url': '/api/v3.0/SubSystems/{subSystemId}'}  # type: ignore

    def get_sub_systems(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelSubSystemResponse", "_models.ProblemDetails"]
        """Gets subSystems.

        Gets subSystems.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Abbreviation`` | String | ``eq, neq, in, like`` |
         | ``Active`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``CorporationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``CorporationName`` | String | ``eq, neq, in, like`` |
         | ``Created`` | DateTime | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsPaused`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Abbreviation`` | String |
         | ``CorporationName`` | String |
         | ``Created`` | DateTime |
         | ``LocationName`` | String |
         | ``Name`` | String |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelSubSystemResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelSubSystemResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelSubSystemResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_sub_systems.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelSubSystemResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_sub_systems.metadata = {'url': '/api/v3.0/SubSystems'}  # type: ignore

    def create_sub_system(
        self,
        body=None,  # type: Optional["_models.SubSystemCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.SubSystemResponse", "_models.ProblemDetails"]
        """Creates a subSystem.

        Creates a subSystem.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.SubSystemCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SubSystemResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.SubSystemResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.SubSystemResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_sub_system.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'SubSystemCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('SubSystemResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_sub_system.metadata = {'url': '/api/v3.0/SubSystems'}  # type: ignore

    def move_sub_system(
        self,
        sub_system_id,  # type: str
        body=None,  # type: Optional["_models.GroupMoveRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.SubSystemResponse", "_models.ProblemDetails"]
        """Moves a subSystem.

        Moves a subSystem.

        :param sub_system_id:
        :type sub_system_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.GroupMoveRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SubSystemResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.SubSystemResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.SubSystemResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.move_sub_system.metadata['url']  # type: ignore
        path_format_arguments = {
            'subSystemId': self._serialize.url("sub_system_id", sub_system_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'GroupMoveRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('SubSystemResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    move_sub_system.metadata = {'url': '/api/v3.0/SubSystems/{subSystemId}/Move'}  # type: ignore

    def create_system(
        self,
        body=None,  # type: Optional["_models.SystemCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.SystemResponse", "_models.ProblemDetails"]
        """Creates a system.

        Creates a system.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.SystemCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SystemResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.SystemResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.SystemResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_system.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'SystemCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('SystemResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_system.metadata = {'url': '/api/v3.0/Systems'}  # type: ignore

    def get_systems(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelSystemResponse", "_models.ProblemDetails"]
        """Gets systems.

        Gets systems.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Abbreviation`` | String | ``eq, neq, in, like`` |
         | ``Active`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``CorporationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``CorporationName`` | String | ``eq, neq, in, like`` |
         | ``Created`` | DateTime | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsCollectorDependentSystem`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsPaused`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Abbreviation`` | String |
         | ``CorporationName`` | String |
         | ``Created`` | DateTime |
         | ``LocationName`` | String |
         | ``Name`` | String |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelSystemResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelSystemResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelSystemResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_systems.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelSystemResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_systems.metadata = {'url': '/api/v3.0/Systems'}  # type: ignore

    def get_system(
        self,
        system_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.SystemResponse", "_models.ProblemDetails"]
        """Gets a system.

        Gets a system.

        :param system_id:
        :type system_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SystemResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.SystemResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.SystemResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_system.metadata['url']  # type: ignore
        path_format_arguments = {
            'systemId': self._serialize.url("system_id", system_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('SystemResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_system.metadata = {'url': '/api/v3.0/Systems/{systemId}'}  # type: ignore

    def update_system(
        self,
        system_id,  # type: str
        body=None,  # type: Optional["_models.SystemUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.SystemResponse", "_models.ProblemDetails"]
        """Updates a system.

        Updates a system.

        :param system_id:
        :type system_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.SystemUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SystemResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.SystemResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.SystemResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_system.metadata['url']  # type: ignore
        path_format_arguments = {
            'systemId': self._serialize.url("system_id", system_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'SystemUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('SystemResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_system.metadata = {'url': '/api/v3.0/Systems/{systemId}'}  # type: ignore

    def get_asset_status_summaries_for_system(
        self,
        system_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.SystemAssetsStatusSummaryResponse", "_models.ProblemDetails"]
        """Gets asset status summary for a system.

        Gets asset status summary for a system.

        :param system_id:
        :type system_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SystemAssetsStatusSummaryResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.SystemAssetsStatusSummaryResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.SystemAssetsStatusSummaryResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_asset_status_summaries_for_system.metadata['url']  # type: ignore
        path_format_arguments = {
            'systemId': self._serialize.url("system_id", system_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('SystemAssetsStatusSummaryResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_asset_status_summaries_for_system.metadata = {'url': '/api/v3.0/Systems/{systemId}/Assets/Summary/Status'}  # type: ignore

    def get_asset_status_summaries_for_systems(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelSystemAssetsStatusSummaryResponse", "_models.ProblemDetails"]
        """Gets asset status summary for systems.

        Gets asset status summary for systems.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``LocationId`` | Guid | ``eq, neq, in`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelSystemAssetsStatusSummaryResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelSystemAssetsStatusSummaryResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelSystemAssetsStatusSummaryResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_asset_status_summaries_for_systems.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelSystemAssetsStatusSummaryResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_asset_status_summaries_for_systems.metadata = {'url': '/api/v3.0/Systems/Assets/Summary/Status'}  # type: ignore

    def get_tags(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelTagResponse", "_models.ProblemDetails"]
        """Gets tags.

        Gets tags.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Active`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``Created`` | DateTime | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsGlobal`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |
         | ``Type`` | TagCategories | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``Updated`` | DateTime | ``eq, neq, in, lt, gt, leq, geq`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Created`` | DateTime |
         | ``LocationName`` | String |
         | ``Name`` | String |
         | ``Type`` | TagCategories |
         | ``Updated`` | DateTime |.
        :type order_by: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelTagResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelTagResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelTagResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_tags.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelTagResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_tags.metadata = {'url': '/api/v3.0/Tags'}  # type: ignore

    def create_tag(
        self,
        body=None,  # type: Optional["_models.TagCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.TagResponse", "_models.ProblemDetails"]
        """Creates a tag.

        Creates a tag.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.TagCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TagResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.TagResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.TagResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.create_tag.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'TagCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('TagResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_tag.metadata = {'url': '/api/v3.0/Tags'}  # type: ignore

    def get_tag(
        self,
        tag_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.TagResponse", "_models.ProblemDetails"]
        """Gets a tag.

        Gets a tag.

        :param tag_id:
        :type tag_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TagResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.TagResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.TagResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_tag.metadata['url']  # type: ignore
        path_format_arguments = {
            'tagId': self._serialize.url("tag_id", tag_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('TagResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_tag.metadata = {'url': '/api/v3.0/Tags/{tagId}'}  # type: ignore

    def update_tag(
        self,
        tag_id,  # type: str
        body=None,  # type: Optional["_models.TagUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.TagResponse", "_models.ProblemDetails"]
        """Updates a tag.

        Updates a tag.

        :param tag_id:
        :type tag_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.TagUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TagResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.TagResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.TagResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_tag.metadata['url']  # type: ignore
        path_format_arguments = {
            'tagId': self._serialize.url("tag_id", tag_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'TagUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('TagResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_tag.metadata = {'url': '/api/v3.0/Tags/{tagId}'}  # type: ignore

    def exchange_token(
        self,
        body=None,  # type: Optional["_models.TokenExchangeRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.TokenExchangeResponse"
        """exchange_token.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.TokenExchangeRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TokenExchangeResponse, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.TokenExchangeResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.TokenExchangeResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.exchange_token.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'TokenExchangeRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('TokenExchangeResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    exchange_token.metadata = {'url': '/api/v3.0/Tokens/exchange'}  # type: ignore

    def get_tree_item(
        self,
        tree_item_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.TreeItemResponse", "_models.ProblemDetails"]
        """Gets a treeItem.

        Gets a treeItem.

        :param tree_item_id:
        :type tree_item_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TreeItemResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.TreeItemResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.TreeItemResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_tree_item.metadata['url']  # type: ignore
        path_format_arguments = {
            'treeItemId': self._serialize.url("tree_item_id", tree_item_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('TreeItemResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_tree_item.metadata = {'url': '/api/v3.0/TreeItems/{treeItemId}'}  # type: ignore

    def delete_tree_item(
        self,
        tree_item_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Deletes a treeItem.

        Deletes a treeItem.

        :param tree_item_id:
        :type tree_item_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.delete_tree_item.metadata['url']  # type: ignore
        path_format_arguments = {
            'treeItemId': self._serialize.url("tree_item_id", tree_item_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_tree_item.metadata = {'url': '/api/v3.0/TreeItems/{treeItemId}'}  # type: ignore

    def get_tree_items(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelTreeItemResponse", "_models.ProblemDetails"]
        """Gets treeItems.

        Gets treeItems.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Abbreviation`` | String | ``eq, neq, in, like`` |
         | ``Active`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``AssetClassCode`` | String | ``eq, neq, in, like`` |
         | ``CategoryCode`` | String | ``eq, neq, in, like`` |
         | ``CategoryId`` | Int32? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``CategoryName`` | String | ``eq, neq, in, like`` |
         | ``ChildId`` | Guid | ``eq, neq, in`` |
         | ``ChildName`` | String | ``eq, neq, in, like`` |
         | ``ChildType`` | GroupTypeCodes | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``CorporationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``CorporationId`` | Guid | ``eq, neq, in`` |
         | ``CorporationName`` | String | ``eq, neq, in, like`` |
         | ``Created`` | DateTime | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsCollectorDependentSystem`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``IsPaused`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``LocationAbbreviation`` | String | ``eq, neq, in, like`` |
         | ``LocationId`` | Guid | ``eq, neq, in`` |
         | ``LocationName`` | String | ``eq, neq, in, like`` |
         | ``Name`` | String | ``eq, neq, in, like`` |
         | ``SizeCode`` | String | ``eq, neq, in, like`` |
         | ``SizeId`` | Int32? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``SizeName`` | String | ``eq, neq, in, like`` |
         | ``TreeItemType`` | GroupTypeCodes | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``TypeCode`` | String | ``eq, neq, in, like`` |
         | ``TypeId`` | Int32 | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``TypeName`` | String | ``eq, neq, in, like`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Abbreviation`` | String |
         | ``CategoryCode`` | String |
         | ``CategoryName`` | String |
         | ``CorporationName`` | String |
         | ``Created`` | DateTime |
         | ``LocationName`` | String |
         | ``Name`` | String |
         | ``SizeCode`` | String |
         | ``SizeName`` | String |
         | ``TypeCode`` | String |
         | ``TypeName`` | String |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelTreeItemResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelTreeItemResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelTreeItemResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_tree_items.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelTreeItemResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_tree_items.metadata = {'url': '/api/v3.0/TreeItems'}  # type: ignore

    def move_tree_item(
        self,
        tree_item_id,  # type: str
        body=None,  # type: Optional["_models.GroupMoveRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.TreeItemResponse", "_models.ProblemDetails"]
        """Moves a treeItem.

        Moves a treeItem.

        :param tree_item_id:
        :type tree_item_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.GroupMoveRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TreeItemResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.TreeItemResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.TreeItemResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.move_tree_item.metadata['url']  # type: ignore
        path_format_arguments = {
            'treeItemId': self._serialize.url("tree_item_id", tree_item_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'GroupMoveRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('TreeItemResponse', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    move_tree_item.metadata = {'url': '/api/v3.0/TreeItems/{treeItemId}/Move'}  # type: ignore

    def get_tree_item_available_asset_classes(
        self,
        tree_item_id,  # type: str
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelTreeItemAvailableAssetClassResponse", "_models.ProblemDetails"]
        """Gets available asset classes in the subtree rooted at treeItemId.

        Gets available asset classes in the subtree rooted at treeItemId.

        :param tree_item_id:
        :type tree_item_id: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelTreeItemAvailableAssetClassResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelTreeItemAvailableAssetClassResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelTreeItemAvailableAssetClassResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_tree_item_available_asset_classes.metadata['url']  # type: ignore
        path_format_arguments = {
            'treeItemId': self._serialize.url("tree_item_id", tree_item_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelTreeItemAvailableAssetClassResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_tree_item_available_asset_classes.metadata = {'url': '/api/v3.0/TreeItems/{treeItemId}/AvailableAssetClasses'}  # type: ignore

    def get_current_user(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.CurrentUserResponse", "_models.ProblemDetails"]
        """Gets the Current user.

        Gets the Current user.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CurrentUserResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.CurrentUserResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.CurrentUserResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_current_user.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('CurrentUserResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_current_user.metadata = {'url': '/api/v3.0/Users/currentUser'}  # type: ignore

    def get_personal_access_tokens(
        self,
        filter=None,  # type: Optional[str]
        page=None,  # type: Optional[int]
        page_limit=None,  # type: Optional[int]
        order_by=None,  # type: Optional[str]
        name_search=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PagedResultsModelPersonalAccessTokenResponse", "_models.ProblemDetails"]
        """Lists the current user's access tokens.

        Lists the current user's access tokens.

        :param filter: Filter statements to narrow results by properties. Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | ``Active`` | Boolean | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``Created`` | DateTime | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``Description`` | String | ``eq, neq, in, like`` |
         | ``LastUsed`` | DateTime? | ``eq, neq, in, lt, gt, leq, geq`` |
         | ``Updated`` | DateTime? | ``eq, neq, in, lt, gt, leq, geq`` |.
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields. Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | ``Active`` | Boolean |
         | ``Created`` | DateTime |
         | ``Description`` | String |
         | ``LastUsed`` | DateTime? |
         | ``Updated`` | DateTime? |.
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js.
        :type name_search: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PagedResultsModelPersonalAccessTokenResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PagedResultsModelPersonalAccessTokenResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PagedResultsModelPersonalAccessTokenResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_personal_access_tokens.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPersonalAccessTokenResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_personal_access_tokens.metadata = {'url': '/api/v3.0/Users/currentUser/tokens'}  # type: ignore

    def generate_personal_access_tokens(
        self,
        body=None,  # type: Optional["_models.PersonalAccessTokenCreateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PersonalAccessTokenCreateResponse", "_models.ProblemDetails"]
        """Generate a new access token for the current user.

        Generate a new access token for the current user.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.PersonalAccessTokenCreateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PersonalAccessTokenCreateResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PersonalAccessTokenCreateResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PersonalAccessTokenCreateResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.generate_personal_access_tokens.metadata['url']  # type: ignore

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'PersonalAccessTokenCreateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 201:
            deserialized = self._deserialize('PersonalAccessTokenCreateResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    generate_personal_access_tokens.metadata = {'url': '/api/v3.0/Users/currentUser/tokens'}  # type: ignore

    def get_personal_access_token(
        self,
        token_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PersonalAccessTokenResponse", "_models.ProblemDetails"]
        """Get one of the current user's access tokens.

        Get one of the current user's access tokens.

        :param token_id:
        :type token_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PersonalAccessTokenResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PersonalAccessTokenResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PersonalAccessTokenResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.get_personal_access_token.metadata['url']  # type: ignore
        path_format_arguments = {
            'tokenId': self._serialize.url("token_id", token_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PersonalAccessTokenResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_personal_access_token.metadata = {'url': '/api/v3.0/Users/currentUser/tokens/{tokenId}'}  # type: ignore

    def update_personal_access_token(
        self,
        token_id,  # type: str
        body=None,  # type: Optional["_models.PersonalAccessTokenUpdateRequest"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.PersonalAccessTokenResponse", "_models.ProblemDetails"]
        """Update one of the current user's access tokens.

        Update one of the current user's access tokens.

        :param token_id:
        :type token_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.PersonalAccessTokenUpdateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PersonalAccessTokenResponse or ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.PersonalAccessTokenResponse or ~smartdiagnostics_sdk.models.ProblemDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Union["_models.PersonalAccessTokenResponse", "_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        content_type = kwargs.pop("content_type", "application/json-patch+json")
        accept = "application/json, text/json"

        # Construct URL
        url = self.update_personal_access_token.metadata['url']  # type: ignore
        path_format_arguments = {
            'tokenId': self._serialize.url("token_id", token_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'PersonalAccessTokenUpdateRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            deserialized = self._deserialize('PersonalAccessTokenResponse', pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_personal_access_token.metadata = {'url': '/api/v3.0/Users/currentUser/tokens/{tokenId}'}  # type: ignore

    def delete_personal_access_token(
        self,
        token_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.ProblemDetails"]
        """Revokes one of the current user's access tokens.

        Revokes one of the current user's access tokens.

        :param token_id:
        :type token_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProblemDetails, or the result of cls(response)
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ProblemDetails"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json, text/json"

        # Construct URL
        url = self.delete_personal_access_token.metadata['url']  # type: ignore
        path_format_arguments = {
            'tokenId': self._serialize.url("token_id", token_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_personal_access_token.metadata = {'url': '/api/v3.0/Users/currentUser/tokens/{tokenId}'}  # type: ignore
