import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LetsEncryptCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple/r/lets_encrypt_certificate#auto_renew LetsEncryptCertificate#auto_renew}
    */
    readonly autoRenew: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple/r/lets_encrypt_certificate#contact_id LetsEncryptCertificate#contact_id}
    */
    readonly contactId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple/r/lets_encrypt_certificate#domain_id LetsEncryptCertificate#domain_id}
    */
    readonly domainId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple/r/lets_encrypt_certificate#name LetsEncryptCertificate#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple/r/lets_encrypt_certificate#timeouts LetsEncryptCertificate#timeouts}
    */
    readonly timeouts?: LetsEncryptCertificateTimeouts;
}
export interface LetsEncryptCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/dnsimple/r/lets_encrypt_certificate#read LetsEncryptCertificate#read}
    */
    readonly read?: string;
}
export declare function letsEncryptCertificateTimeoutsToTerraform(struct?: LetsEncryptCertificateTimeoutsOutputReference | LetsEncryptCertificateTimeouts | cdktf.IResolvable): any;
export declare class LetsEncryptCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LetsEncryptCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LetsEncryptCertificateTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/dnsimple/r/lets_encrypt_certificate dnsimple_lets_encrypt_certificate}
*/
export declare class LetsEncryptCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "dnsimple_lets_encrypt_certificate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/dnsimple/r/lets_encrypt_certificate dnsimple_lets_encrypt_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LetsEncryptCertificateConfig
    */
    constructor(scope: Construct, id: string, config: LetsEncryptCertificateConfig);
    get authorityIdentifier(): string;
    private _autoRenew?;
    get autoRenew(): boolean | cdktf.IResolvable;
    set autoRenew(value: boolean | cdktf.IResolvable);
    get autoRenewInput(): boolean | cdktf.IResolvable | undefined;
    private _contactId?;
    get contactId(): number;
    set contactId(value: number);
    get contactIdInput(): number | undefined;
    get createdAt(): string;
    get csr(): string;
    private _domainId?;
    get domainId(): string;
    set domainId(value: string);
    resetDomainId(): void;
    get domainIdInput(): string | undefined;
    get expiresOn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get state(): string;
    get updatedAt(): string;
    get years(): number;
    private _timeouts;
    get timeouts(): LetsEncryptCertificateTimeoutsOutputReference;
    putTimeouts(value: LetsEncryptCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LetsEncryptCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
