/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import smetana.core.Bucket;
import smetana.core.CType;
import smetana.core.JUtils;

public class StructureDefinition {
    private static final Map<Class, StructureDefinition> all = new HashMap<Class, StructureDefinition>();
    private final Class cl;
    private Map<String, Bucket> buckets;

    public static StructureDefinition from(Class cl) {
        if (cl == null) {
            throw new IllegalArgumentException();
        }
        StructureDefinition result = all.get(cl);
        if (result == null) {
            result = new StructureDefinition(cl);
            all.put(cl, result);
        }
        return result;
    }

    private StructureDefinition(Class cl) {
        this.cl = cl;
    }

    public String toString() {
        return (this.cl == null ? "NO_CLASS" : this.cl.getName()) + " " + this.buckets;
    }

    private Map<String, Bucket> buckets() {
        if (this.buckets == null) {
            List<String> definition = CType.getDefinition(this.cl);
            JUtils.LOG("StructureDefinition::run for " + this.cl);
            JUtils.LOG("def=" + definition);
            JUtils.LOG("first=" + definition.get(0));
            this.buckets = new LinkedHashMap<String, Bucket>();
            if (definition.get(0).equals("typedef enum")) {
                String last = definition.get(definition.size() - 1);
                if (!last.matches("\\w+")) {
                    throw new UnsupportedOperationException();
                }
                this.buckets.put(last, Bucket.buildEnum(last, definition));
                return this.buckets;
            }
            if (!(definition.get(0).equals("typedef struct gvplugin_active_textlayout_s") || definition.get(0).equals("typedef struct color_s") || definition.get(0).equals("typedef struct") || definition.get(0).equals("typedef struct pointf_s") || definition.get(0).equals("typedef struct gvplugin_active_layout_s") || definition.get(0).equals("typedef struct GVCOMMON_s") || definition.get(0).equals("struct " + this.cl.getSimpleName()) || definition.get(0).equals("typedef struct " + this.cl.getSimpleName()) || definition.get(0).equals("typedef struct " + this.cl.getSimpleName().replaceFirst("_t", "_s")) || definition.get(0).equals("typedef union " + this.cl.getSimpleName()))) {
                throw new IllegalStateException("<struct " + this.cl.getSimpleName() + "> VERSUS <" + definition.get(0) + ">");
            }
            if (!definition.get(1).equals("{")) {
                throw new IllegalStateException();
            }
            int last = definition.size() - 1;
            if (definition.get(definition.size() - 2).equals("}") && definition.get(definition.size() - 1).equals(this.cl.getSimpleName())) {
                --last;
            }
            if (!definition.get(last).equals("}")) {
                throw new IllegalStateException();
            }
            Iterator<String> it = definition.subList(2, last).iterator();
            while (it.hasNext()) {
                this.buckets.putAll(Bucket.buildSome(it));
            }
        }
        return this.buckets;
    }

    public Set<String> getFields() {
        return this.buckets().keySet();
    }

    public Collection<Bucket> getBuckets() {
        return this.buckets().values();
    }

    public Map<String, Bucket> getBucketsMap() {
        return this.buckets();
    }

    public Bucket getBucket(String field) {
        Bucket result = this.buckets().get(field);
        if (result == null) {
            throw new IllegalArgumentException(field);
        }
        return result;
    }

    public Class getTheClass() {
        return this.cl;
    }

    public boolean containsFieldName(String fieldName) {
        return this.buckets().keySet().contains(fieldName);
    }
}

