/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class CircleAndArrow
implements UDrawable {
    private final AffineTransform at;
    private final AffineTransform at2;
    private int radius;
    private final Point2D center;
    private final Point2D p1;
    private final Point2D p2;
    private Point2D p3;
    private Point2D p4;

    public CircleAndArrow(Point2D p1, Point2D p2) {
        this.center = new Point2D.Double((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0);
        this.at = AffineTransform.getTranslateInstance(-this.center.getX(), -this.center.getY());
        this.at2 = AffineTransform.getTranslateInstance(this.center.getX(), this.center.getY());
        this.radius = (int)(p1.distance(p2) / 2.0);
        if (this.radius % 2 == 0) {
            --this.radius;
        }
        this.p1 = this.putOnCircle(p1);
        this.p2 = this.putOnCircle(p2);
        this.p3 = this.at.transform(this.p1, null);
        this.p3 = new Point2D.Double(this.p3.getY(), -this.p3.getX());
        this.p3 = this.at2.transform(this.p3, null);
        this.p4 = this.at.transform(this.p2, null);
        this.p4 = new Point2D.Double(this.p4.getY(), -this.p4.getX());
        this.p4 = this.at2.transform(this.p4, null);
    }

    private Point2D putOnCircle(Point2D p) {
        p = this.at.transform(p, null);
        double coef = p.distance(new Point2D.Double()) / (double)this.radius;
        p = new Point2D.Double(p.getX() / coef, p.getY() / coef);
        return this.at2.transform(p, null);
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(this.radius * 2, this.radius * 2);
        ug.apply(new UTranslate(this.center.getX() - (double)this.radius, this.center.getY() - (double)this.radius)).draw(circle);
    }

    private static void drawLine(UGraphic ug, double x, double y, Point2D p1, Point2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(x + p1.getX(), y + p1.getY())).draw(new ULine(dx, dy));
    }
}

