/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public class CommandAddData
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    public CommandAddData() {
        super(CommandAddData.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandAddData.class.getName(), RegexLeaf.start(), new RegexLeaf("NAME", "([\\p{L}0-9_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DATA", "(.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractClassOrObjectDiagram diagram, LineLocation location, RegexResult arg) {
        IEntity entity = diagram.getOrCreateLeaf(Code.of(arg.get("NAME", 0)), null, null);
        String field = arg.get("DATA", 0);
        if (field.length() > 0 && VisibilityModifier.isVisibilityCharacter(field)) {
            diagram.setVisibilityModifierPresent(true);
        }
        entity.getBodier().addFieldOrMethod(field, entity);
        return CommandExecutionResult.ok();
    }
}

