/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.style.StyleBuilder;

class Idea {
    private final Display label;
    private final int level;
    private final Idea parent;
    private final List<Idea> children = new ArrayList<Idea>();
    private final IdeaShape shape;
    private final HtmlColor backColor;
    private final StyleBuilder styleBuilder;
    private final String stereotype;

    public Idea(StyleBuilder styleBuilder, Display label, IdeaShape shape, String stereotype) {
        this(styleBuilder, null, 0, null, label, shape, stereotype);
    }

    public Idea createIdea(StyleBuilder styleBuilder, HtmlColor backColor, int newLevel, Display newDisplay, IdeaShape newShape, String stereotype) {
        Idea result = new Idea(styleBuilder, backColor, newLevel, this, newDisplay, newShape, stereotype);
        this.children.add(result);
        return result;
    }

    private Idea(StyleBuilder styleBuilder, HtmlColor backColor, int level, Idea parent, Display label, IdeaShape shape, String stereotype) {
        this.backColor = backColor;
        this.styleBuilder = styleBuilder;
        this.label = label;
        this.level = level;
        this.parent = parent;
        this.shape = shape;
        this.stereotype = stereotype;
    }

    public String toString() {
        return this.label.toString();
    }

    public final int getLevel() {
        return this.level;
    }

    public final Display getLabel() {
        return this.label;
    }

    public Collection<Idea> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public Idea getParent() {
        return this.parent;
    }

    public final IdeaShape getShape() {
        return this.shape;
    }

    public final HtmlColor getBackColor() {
        return this.backColor;
    }

    public final StyleBuilder getStyleBuilder() {
        return this.styleBuilder;
    }

    public final String getStereotype() {
        return this.stereotype;
    }
}

