/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.StringCompressorNone;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends AbstractPSystem {
    private static final int COLS = 6;
    private static final int FREE_LINES = 6;
    public static final String DONORS = "6uq902mFw6aNBnoRoJQNUtErFonYo206_-9C-IFeunriW0n1BL5IhOvS7xq622gWQ-ZeCRVlzBZVI7yHNUdUDys8jcnDSPvH50k27c-JQuPjxkqnSsBnGt1dZe133yW3iacsZHfPkfVj92sddof3IY7pywS6s9OAihYRQXukK7S6TknnUzX_ePwbHp_sKxhZEw0nZHBhiAEQb5SFVAsgP8B2sM_7DwrYLapW42cEjd043jcOYNnrMiUu85NxZte3BJPcM2foJoYssYMf-UVP-hQ1xXCOJ2AmYG4RC7Eew32UO2vGRyGGM4MYYUpiZCQ6QsvveeC95zInXd-KHKsFLEOSZau4Dg-40Ww_XXE0hIYlmcVxDWCAHNgBkYN9EZMUX9N6XoKfhXyqt006R2ne7QY2a3T19_nfCVjJatjT3GLUzEpClTaPo4Ms0y3nPaRVPDsPAF_t3yuqiMsfbaXrBlrvhlTn3iZTKgj6_37QM6LBtDQJ5nLQUN81_4FGIxsZOdxETMCX6UAvT7iYpdFgojSe0cR5OMJXJx4bDUxIBazZVLcUeIp1Z_RhL2EPq89N8bu6_QfMA0zqlb2oBArSFlHeMBqCV4t8JBmjkcV7NCh_lrAymupI5RJVnPogQo1Adh5pLUjigWXC8texv2QGAr3jhbknU_-G_vmFIBqbaO78RCvnlrIig3LT334RrdIwn0nWyfHe9mAxaqGYfaReNR2oZ4mhnQw7g-VqYJ5nxVJ2uxwfCOWFTBBo9EpfHR1cXY79chaDxGUSWt06NvnNN_VXFLO1hBjvZxr9pHzd85tfXP4aRKQKszRzgR1c1QLdKPPyM96_U_4p5mzT2bvdikW8Cwysno5ZeNZPf9N-PFJ3aY5ldygo_aeLUGFkbug5G9XdV0nuF3XPKCKb15RJMGuJ6u1mweDNx3SlSJEekgNav18snAp3LkU1IkU7UGT6bN7WcOCTtRt4pz0IHSx7vxso-cbbhIfsBA1uLWYMKaVPQweeqkTKCcICGSzXQ-3jDmjT42xrsXkc1GflW-Y-V0EjKyYq4kC7JPybqeLyHRxaiJ02_iwltsGlEDP1nhyPtOV7cUUA8AKgEi0vSRRKQbjQ1-ij-lpvifoy1t_-xpLjvrI8vtoM0Bg0WlQlfS2SQDRLF7liJwEF3kmsiW9Y7PpqbLUcNWWm40oQPQcNrcb6uSuONcwg1dt6yQ52No4L9uZZ3SikbYcA6bFEykLanQYys9VU22SvU5x_55M6KbnbkPeOeLNi_2ZEqtWVjHjkTUa24j0T5mJAVlExtIntZJvVW7qO7b3avoDvwB25QK4Lfx4yDJ15OtrlnjjJPwP-4m00";

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        UDrawable result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private UDrawable getGraphicStrings() throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 6, 6);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(new UTranslate(0.0, header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(new UTranslate(x, 0.0)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(PSystemVersion.getPlantumlImage());
                ug.apply(new UTranslate(lastX, y - (double)logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        TranscoderImpl t = new TranscoderImpl(new AsciiEncoder(), new StringCompressorNone(), new CompressionBrotli());
        String s = t.decode(DONORS).replace('*', '.');
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            lines.add(st.nextToken());
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

