/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.EmbeddedDiagram;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.graphic.TextBlockSprited;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class Display
implements Iterable<CharSequence> {
    private final List<CharSequence> displayData;
    private final HorizontalAlignment naturalHorizontalAlignment;
    private final boolean isNull;
    private final CreoleMode defaultCreoleMode;
    public static final Display NULL = new Display(null, null, true, CreoleMode.FULL);

    public Display withoutStereotype(Style usedStyle) {
        ArrayList<CharSequence> copy = new ArrayList<CharSequence>(this.displayData);
        Display result = new Display(this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            CharSequence cs = (CharSequence)it.next();
            if (!(cs instanceof Stereotype) || !usedStyle.getSignature().match((Stereotype)cs)) continue;
            it.remove();
        }
        result.displayData.addAll(copy);
        return result;
    }

    public Display replaceBackslashT() {
        Display result = new Display(this, this.defaultCreoleMode);
        for (int i = 0; i < result.displayData.size(); ++i) {
            CharSequence s = this.displayData.get(i);
            if (!s.toString().contains("\\t")) continue;
            result.displayData.set(i, s.toString().replace("\\t", "\t"));
        }
        return result;
    }

    public Display replace(String src, String dest) {
        ArrayList<CharSequence> newDisplay = new ArrayList<CharSequence>();
        for (CharSequence cs : this.displayData) {
            if (cs.toString().contains(src)) {
                cs = cs.toString().replace(src, dest);
            }
            newDisplay.add(cs);
        }
        return new Display(newDisplay, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public boolean isWhite() {
        return this.displayData == null || this.displayData.size() == 0 || this.displayData.size() == 1 && this.displayData.get(0).toString().matches("\\s*");
    }

    public static Display empty() {
        return new Display(null, false, CreoleMode.FULL);
    }

    public static Display create(CharSequence ... s) {
        return Display.create(Arrays.asList(s));
    }

    public static Display createFoo(List<StringLocated> data) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (StringLocated s : data) {
            tmp.add(s.getString());
        }
        return Display.create(tmp);
    }

    public static Display create(Collection<? extends CharSequence> other) {
        return new Display(other, null, false, CreoleMode.FULL);
    }

    public static Display getWithNewlines(Code s) {
        return Display.getWithNewlines(s.getFullName());
    }

    public static Display getWithNewlines(String s) {
        if (s == null) {
            return NULL;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        HorizontalAlignment naturalHorizontalAlignment = null;
        boolean rawMode = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String sub = s.substring(i);
            if (sub.startsWith("<math>") || sub.startsWith("<latex>") || sub.startsWith("[[")) {
                rawMode = true;
            } else if (sub.startsWith("</math>") || sub.startsWith("</latex>") || sub.startsWith("]]")) {
                rawMode = false;
            }
            if (!rawMode && c == '\\' && i < s.length() - 1) {
                char c2 = s.charAt(i + 1);
                ++i;
                if (c2 == 'n' || c2 == 'r' || c2 == 'l') {
                    if (c2 == 'r') {
                        naturalHorizontalAlignment = HorizontalAlignment.RIGHT;
                    } else if (c2 == 'l') {
                        naturalHorizontalAlignment = HorizontalAlignment.LEFT;
                    }
                    result.add(current.toString());
                    current.setLength(0);
                    continue;
                }
                if (c2 == 't') {
                    current.append('\t');
                    continue;
                }
                if (c2 == '\\') {
                    current.append(c2);
                    continue;
                }
                current.append(c);
                current.append(c2);
                continue;
            }
            if (c == BackSlash.hiddenNewLine()) {
                result.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        result.add(current.toString());
        return new Display(result, naturalHorizontalAlignment, false, CreoleMode.FULL);
    }

    private Display(Display other, CreoleMode mode) {
        this(other.naturalHorizontalAlignment, other.isNull, mode);
        this.displayData.addAll(other.displayData);
    }

    private Display(HorizontalAlignment naturalHorizontalAlignment, boolean isNull, CreoleMode defaultCreoleMode) {
        this.defaultCreoleMode = defaultCreoleMode;
        this.isNull = isNull;
        this.displayData = isNull ? null : new ArrayList();
        this.naturalHorizontalAlignment = isNull ? null : naturalHorizontalAlignment;
    }

    private Display(Collection<? extends CharSequence> other, HorizontalAlignment naturalHorizontalAlignment, boolean isNull, CreoleMode defaultCreoleMode) {
        this(naturalHorizontalAlignment, isNull, defaultCreoleMode);
        if (!isNull) {
            this.displayData.addAll(Display.manageEmbeddedDiagrams(other));
        }
    }

    private static List<CharSequence> manageEmbeddedDiagrams(Collection<? extends CharSequence> strings) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        Iterator<? extends CharSequence> it = strings.iterator();
        while (it.hasNext()) {
            CharSequence s = it.next();
            if (s != null && StringUtils.trin(s.toString()).equals("{{")) {
                CharSequence s2;
                ArrayList<CharSequence> other = new ArrayList<CharSequence>();
                other.add("@startuml");
                while (it.hasNext() && ((s2 = it.next()) == null || !StringUtils.trin(s2.toString()).equals("}}"))) {
                    other.add(s2);
                }
                other.add("@enduml");
                s = new EmbeddedDiagram(Display.create(other));
            }
            result.add(s);
        }
        return result;
    }

    public Display manageGuillemet() {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        boolean first = true;
        for (CharSequence line : this.displayData) {
            if (line instanceof EmbeddedDiagram) {
                result.add(line);
            } else {
                String lineString = line.toString();
                if (first && VisibilityModifier.isVisibilityCharacter(line)) {
                    lineString = lineString.substring(1).trim();
                }
                String withGuillement = Guillemet.GUILLEMET.manageGuillemet(lineString);
                result.add(withGuillement);
            }
            first = false;
        }
        return new Display(result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display withPage(int page, int lastpage) {
        if (this.displayData == null) {
            return this;
        }
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (CharSequence line : this.displayData) {
            line = line.toString().replace("%page%", "" + page);
            line = line.toString().replace("%lastpage%", "" + lastpage);
            result.add(line);
        }
        return new Display(result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display underlined() {
        ArrayList<String> result = new ArrayList<String>();
        for (CharSequence line : this.displayData) {
            result.add("<u>" + line);
        }
        return new Display(result, this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public Display withCreoleMode(CreoleMode mode) {
        if (this.isNull) {
            throw new IllegalArgumentException();
        }
        return new Display(this, mode);
    }

    public String toString() {
        if (this.isNull) {
            return "NULL";
        }
        return this.displayData.toString();
    }

    public int hashCode() {
        return this.displayData.hashCode();
    }

    public boolean equals(Object other) {
        return this.displayData.equals(((Display)other).displayData);
    }

    public Display addAll(Display other) {
        Display result = new Display(this, this.defaultCreoleMode);
        result.displayData.addAll(other.displayData);
        return result;
    }

    public Display addFirst(CharSequence s) {
        Display result = new Display(this, this.defaultCreoleMode);
        result.displayData.add(0, s);
        return result;
    }

    public Display add(CharSequence s) {
        Display result = new Display(this, this.defaultCreoleMode);
        result.displayData.add(s);
        return result;
    }

    public Display addGeneric(CharSequence s) {
        Display result = new Display(this, this.defaultCreoleMode);
        int size = this.displayData.size();
        if (size == 0) {
            result.displayData.add("<" + s + ">");
        } else {
            result.displayData.set(size - 1, this.displayData.get(size - 1) + "<" + s + ">");
        }
        return result;
    }

    public int size() {
        if (this.isNull) {
            return 0;
        }
        return this.displayData.size();
    }

    public CharSequence get(int i) {
        return this.displayData.get(i);
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return Collections.unmodifiableList(this.displayData).iterator();
    }

    public Display subList(int i, int size) {
        return new Display(this.displayData.subList(i, size), this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
    }

    public List<? extends CharSequence> as() {
        return Collections.unmodifiableList(this.displayData);
    }

    public List<StringLocated> as2() {
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        LineLocationImpl location = new LineLocationImpl("inner", null);
        for (CharSequence cs : this.displayData) {
            location = location.oneLineRead();
            result.add(new StringLocated(cs.toString(), location));
        }
        return Collections.unmodifiableList(result);
    }

    public boolean hasUrl() {
        UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.ANYWHERE);
        for (CharSequence s : this) {
            if (urlBuilder.getUrl(s.toString()) == null) continue;
            return true;
        }
        return false;
    }

    public HorizontalAlignment getNaturalHorizontalAlignment() {
        return this.naturalHorizontalAlignment;
    }

    public List<Display> splitMultiline(Pattern2 separator) {
        ArrayList<Display> result = new ArrayList<Display>();
        Display pending = new Display(this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
        result.add(pending);
        for (CharSequence line : this.displayData) {
            Matcher2 m = separator.matcher(line);
            if (m.find()) {
                CharSequence s1 = line.subSequence(0, m.start());
                pending.displayData.add(s1);
                CharSequence s2 = line.subSequence(m.end(), line.length());
                pending = new Display(this.naturalHorizontalAlignment, this.isNull, this.defaultCreoleMode);
                result.add(pending);
                pending.displayData.add(s2);
                continue;
            }
            pending.displayData.add(line);
        }
        return Collections.unmodifiableList(result);
    }

    public static boolean isNull(Display display) {
        return display == null || display.isNull;
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer) {
        return this.create(fontConfiguration, horizontalAlignment, spriteContainer, CreoleMode.FULL);
    }

    public TextBlock createWithNiceCreoleMode(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer) {
        return this.create(fontConfiguration, horizontalAlignment, spriteContainer, this.defaultCreoleMode);
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, CreoleMode creoleMode) {
        return this.create(fontConfiguration, horizontalAlignment, spriteContainer, LineBreakStrategy.NONE, creoleMode, null, null);
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, CreoleMode modeSimpleLine, LineBreakStrategy maxMessageSize) {
        return this.create(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, modeSimpleLine, null, null);
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize) {
        return this.create(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, this.defaultCreoleMode, null, null);
    }

    public TextBlock create(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, CreoleMode creoleMode, UFont fontForStereotype, HtmlColor htmlColorForStereotype) {
        if (maxMessageSize == null) {
            throw new IllegalArgumentException();
        }
        if (this.getNaturalHorizontalAlignment() != null) {
            horizontalAlignment = this.getNaturalHorizontalAlignment();
        }
        if (this.size() > 0) {
            if (this.get(0) instanceof Stereotype) {
                return this.createStereotype(fontConfiguration, horizontalAlignment, spriteContainer, 0, fontForStereotype, htmlColorForStereotype);
            }
            if (this.get(this.size() - 1) instanceof Stereotype) {
                return this.createStereotype(fontConfiguration, horizontalAlignment, spriteContainer, this.size() - 1, fontForStereotype, htmlColorForStereotype);
            }
            if (this.get(0) instanceof MessageNumber) {
                return this.createMessageNumber(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize);
            }
        }
        return this.getCreole(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, creoleMode);
    }

    private TextBlock getCreole(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, CreoleMode creoleMode) {
        Sheet sheet = new CreoleParser(fontConfiguration, horizontalAlignment, spriteContainer, creoleMode).createSheet(this);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, maxMessageSize, spriteContainer == null ? 0.0 : spriteContainer.getPadding());
        return new SheetBlock2(sheetBlock1, sheetBlock1, new UStroke(1.5));
    }

    private TextBlock createMessageNumber(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize) {
        TextBlock tb1 = this.subList(0, 1).getCreole(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, CreoleMode.FULL);
        tb1 = TextBlockUtils.withMargin(tb1, 0.0, 4.0, 0.0, 0.0);
        TextBlock tb2 = this.subList(1, this.size()).getCreole(fontConfiguration, horizontalAlignment, spriteContainer, maxMessageSize, CreoleMode.FULL);
        return TextBlockUtils.mergeLR(tb1, tb2, VerticalAlignment.CENTER);
    }

    private TextBlock createStereotype(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer, int position, UFont fontForStereotype, HtmlColor htmlColorForStereotype) {
        Stereotype stereotype = (Stereotype)this.get(position);
        TextBlock circledCharacter = null;
        circledCharacter = stereotype.isSpotted() ? new CircledCharacter(stereotype.getCharacter(), stereotype.getRadius(), stereotype.getCircledFont(), stereotype.getHtmlColor(), null, fontConfiguration.getColor()) : stereotype.getSprite(spriteContainer);
        if (circledCharacter != null) {
            if (stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null) {
                return new TextBlockSprited(circledCharacter, this.subList(1, this.size()), fontConfiguration, horizontalAlignment, spriteContainer);
            }
            return new TextBlockSprited(circledCharacter, this, fontConfiguration, horizontalAlignment, spriteContainer);
        }
        return new TextBlockSimple(this, fontConfiguration, horizontalAlignment, spriteContainer, 0.0, fontForStereotype, htmlColorForStereotype);
    }
}

