/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilinesBracket;
import net.sourceforge.plantuml.command.SkinLoader;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;

public class CommandSkinParamMultilines
extends CommandMultilinesBracket<UmlDiagram> {
    public CommandSkinParamMultilines() {
        super("(?i)^skinparam[%s]*(?:[%s]+([\\w.]*(?:\\<\\<.*\\>\\>)?[\\w.]*))?[%s]*\\{$");
    }

    @Override
    protected boolean isLineConsistent(String line, int level) {
        if (this.hasStartingQuote(line = StringUtils.trin(line))) {
            return true;
        }
        return SkinLoader.p1.matcher(line).matches();
    }

    private boolean hasStartingQuote(CharSequence line) {
        return MyPattern.mtches(line, "(?i)^[%s]*([%q].*||/[%q].*[%q]/[%s]*)$");
    }

    @Override
    public CommandExecutionResult execute(UmlDiagram diagram, BlocLines lines) {
        SkinLoader skinLoader = new SkinLoader(diagram);
        Matcher2 mStart = this.getStartingPattern().matcher(lines.getFirst499().getTrimmed().getString());
        if (!mStart.find()) {
            throw new IllegalStateException();
        }
        String group1 = mStart.group(1);
        return skinLoader.execute(lines, group1);
    }
}

