#!/user/bin/env python3
# -*- coding: utf-8 -*-
"""
--------------------------------------
    Author:     JiChao_Song
    Date  :     2021/12/14 11:00
    Desc  :
--------------------------------------
"""
import os
import re

from setuptools import setup, find_packages


def read(f):
    return open(f, 'r', encoding = 'utf-8').read()


def get_version(package):
    """
    Return package version as listed in `__version__` in `init.py`.
    """
    init_py = open(os.path.join(package, '__init__.py')).read()
    return re.search("__version__ = ['\"]([^'\"]+)['\"]", init_py).group(1)


version = get_version('apiview_doc')

setup(
    name = 'djangoapiviewdoc',
    version = version,
    url = 'https://gitee.com/zhsjch/djangoapiviewdoc.git',
    license = 'BSD',
    description = 'Django APIView decorator create Api Doc',
    long_description = read('README.md'),
    long_description_content_type = 'text/markdown',
    author = 'JiChao Song',
    author_email = 'jichaosong@outlook.com',  # SEE NOTE BELOW (*)
    packages = find_packages(exclude = ['tests*']),
    include_package_data = True,
    install_requires = [
        "django-http-log>=0.1.0"
    ],
    python_requires = ">=3.6",
)
