import Ajv from 'ajv';
/**
 * Initialize JSON schema validation with ajv
 */
const ajv = new Ajv({ allErrors: true, useDefaults: true });
/**
 * Create a validator function for JSON schema in uniform
 *
 * @param schema JSON schema to validate
 */
export function createValidator(schema) {
    const validator = ajv.compile(schema);
    return (model) => {
        validator(model);
        if (validator.errors && validator.errors.length) {
            throw { details: validator.errors };
        }
    };
}
//# sourceMappingURL=validator.js.map