import { getProjectInfo } from './project';
/**
 * Namespace of foreign command IDs used
 */
export var ForeignCommandIDs;
(function (ForeignCommandIDs) {
    ForeignCommandIDs.closeAll = 'application:close-all';
    ForeignCommandIDs.documentOpen = 'docmanager:open';
    ForeignCommandIDs.gitInit = 'git:init';
    ForeignCommandIDs.goTo = 'filebrowser:go-to-path';
    ForeignCommandIDs.openPath = 'filebrowser:open-path';
    ForeignCommandIDs.saveAll = 'docmanager:save-all';
})(ForeignCommandIDs || (ForeignCommandIDs = {}));
/**
 * Rendered a templated string with project info
 *
 * The template key must be {{ jproject.property }}. And
 * the properties available are those of Project.IInfo
 *
 * @param template Templated string
 * @param project Project information
 * @returns The rendered string
 */
export function renderStringTemplate(template, project) {
    if (!project) {
        return template; // Bail early
    }
    const values = getProjectInfo(project);
    for (const key in values) {
        const regex = new RegExp(`{{\\s*jproject\\.${key}\\s*}}`, 'gi');
        const value = values[key];
        template = template.replace(regex, value);
    }
    return template;
}
//# sourceMappingURL=utils.js.map