from .circuits import InsEncryptPBDKF2_AESGCM, InsDecryptPBDKF2_AESGCM

get_example_data_constructor = {
    "encryption": {
        "pbdkf2": {
            "aesgcm": lambda: InsEncryptPBDKF2_AESGCM(
                pbdkf2_passphrase="test password".encode("ascii"),
                aesgcm_plaintext=b"1d5d2f4382130e73bc5434c47b32a76a86fb0765a6d578afcf4a57ce3427e868",
                aesgcm_nonce=b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
                pbdkf2_salt=b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
            ).dict()
        }
    },
    "decryption": {
        "pbdkf2": {
            "aesgcm": lambda: InsDecryptPBDKF2_AESGCM(
                pbdkf2_passphrase="test password".encode("ascii"),
                aesgcm_cyphertext=b'-\xd8\x85I=@{\x97\xf7\xad+\x1e\xae\xda\x14@b}\xba\xab\x80s\xed\xab\x1f\x94M\xd1\xf3\x8d&\xa4,\x17\xdc\xe0\x1a\x10Y+\xaf\x00\x99e"\xdf\x98\x8a\xb7\n\x7f\x89\x9a\xac\x17\x8eF \x12\x9a\xd8\xf5g#`i\xae\xcfoB7\x075\xcd\xd5D\xcf\xe39e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00',
            ).dict()
        }
    },
}
