"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsStateMachineAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The action to put the record from an MQTT message to the Step Functions State Machine.
 */
class StepFunctionsStateMachineAction {
    /**
     * @param stateMachine The Step Functions Start Machine which should be executed.
     * @param props Optional properties to not use default
     */
    constructor(stateMachine, props) {
        this.stateMachine = stateMachine;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_StepFunctionsStateMachineActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StepFunctionsStateMachineAction);
            }
            throw error;
        }
        this.executionNamePrefix = props?.executionNamePrefix;
        this.role = props?.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        const stateMachineName = aws_cdk_lib_1.Stack.of(this.stateMachine).splitArn(this.stateMachine.stateMachineArn, aws_cdk_lib_1.ArnFormat.COLON_RESOURCE_NAME).resourceName;
        if (!stateMachineName) {
            throw new Error(`No state machine name found in ARN: '${this.stateMachine.stateMachineArn}'`);
        }
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['states:StartExecution'],
            resources: [this.stateMachine.stateMachineArn],
        }));
        return {
            configuration: {
                stepFunctions: {
                    stateMachineName,
                    executionNamePrefix: this.executionNamePrefix,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.StepFunctionsStateMachineAction = StepFunctionsStateMachineAction;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsStateMachineAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.StepFunctionsStateMachineAction", version: "2.214.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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