"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.singletonActionRole = singletonActionRole;
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
/**
 * Obtain the Role for the TopicRule
 *
 * If a role already exists, it will be returned. This ensures that if a rule have multiple
 * actions, they will share a role.
 * @internal
 */
function singletonActionRole(scope) {
    const id = 'TopicRuleActionRole';
    const existing = scope.node.tryFindChild(id);
    if (existing) {
        return existing;
    }
    const role = new iam.Role(scope, id, {
        roleName: core_1.PhysicalName.GENERATE_IF_NEEDED,
        assumedBy: new iam.ServicePrincipal('iot.amazonaws.com'),
    });
    return role;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm9sZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJvbGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFXQSxrREFZQztBQXZCRCwyQ0FBMkM7QUFDM0MsMkNBQWdEO0FBR2hEOzs7Ozs7R0FNRztBQUNILFNBQWdCLG1CQUFtQixDQUFDLEtBQWlCO0lBQ25ELE1BQU0sRUFBRSxHQUFHLHFCQUFxQixDQUFDO0lBQ2pDLE1BQU0sUUFBUSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLEVBQUUsQ0FBYyxDQUFDO0lBQzFELElBQUksUUFBUSxFQUFFLENBQUM7UUFDYixPQUFPLFFBQVEsQ0FBQztJQUNsQixDQUFDO0lBRUQsTUFBTSxJQUFJLEdBQUcsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLEtBQWtCLEVBQUUsRUFBRSxFQUFFO1FBQ2hELFFBQVEsRUFBRSxtQkFBWSxDQUFDLGtCQUFrQjtRQUN6QyxTQUFTLEVBQUUsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsbUJBQW1CLENBQUM7S0FDekQsQ0FBQyxDQUFDO0lBQ0gsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgaWFtIGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgUGh5c2ljYWxOYW1lIH0gZnJvbSAnYXdzLWNkay1saWIvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QsIElDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuLyoqXG4gKiBPYnRhaW4gdGhlIFJvbGUgZm9yIHRoZSBUb3BpY1J1bGVcbiAqXG4gKiBJZiBhIHJvbGUgYWxyZWFkeSBleGlzdHMsIGl0IHdpbGwgYmUgcmV0dXJuZWQuIFRoaXMgZW5zdXJlcyB0aGF0IGlmIGEgcnVsZSBoYXZlIG11bHRpcGxlXG4gKiBhY3Rpb25zLCB0aGV5IHdpbGwgc2hhcmUgYSByb2xlLlxuICogQGludGVybmFsXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBzaW5nbGV0b25BY3Rpb25Sb2xlKHNjb3BlOiBJQ29uc3RydWN0KTogaWFtLklSb2xlIHtcbiAgY29uc3QgaWQgPSAnVG9waWNSdWxlQWN0aW9uUm9sZSc7XG4gIGNvbnN0IGV4aXN0aW5nID0gc2NvcGUubm9kZS50cnlGaW5kQ2hpbGQoaWQpIGFzIGlhbS5JUm9sZTtcbiAgaWYgKGV4aXN0aW5nKSB7XG4gICAgcmV0dXJuIGV4aXN0aW5nO1xuICB9XG5cbiAgY29uc3Qgcm9sZSA9IG5ldyBpYW0uUm9sZShzY29wZSBhcyBDb25zdHJ1Y3QsIGlkLCB7XG4gICAgcm9sZU5hbWU6IFBoeXNpY2FsTmFtZS5HRU5FUkFURV9JRl9ORUVERUQsXG4gICAgYXNzdW1lZEJ5OiBuZXcgaWFtLlNlcnZpY2VQcmluY2lwYWwoJ2lvdC5hbWF6b25hd3MuY29tJyksXG4gIH0pO1xuICByZXR1cm4gcm9sZTtcbn1cbiJdfQ==