"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
/**
 * The action to invoke an AWS Lambda function, passing in an MQTT message.
 */
class LambdaFunctionAction {
    /**
     * @param func The lambda function to be invoked by this action
     */
    constructor(func) {
        this.func = func;
    }
    /**
     * @internal
     */
    _bind(topicRule) {
        this.func.addPermission(`${core_1.Names.nodeUniqueId(topicRule.node)}:IotLambdaFunctionAction`, {
            action: 'lambda:InvokeFunction',
            principal: new iam.ServicePrincipal('iot.amazonaws.com'),
            sourceAccount: topicRule.env.account,
            sourceArn: topicRule.topicRuleArn,
        });
        return {
            configuration: {
                lambda: {
                    functionArn: this.func.functionArn,
                },
            },
        };
    }
}
exports.LambdaFunctionAction = LambdaFunctionAction;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.LambdaFunctionAction", version: "2.214.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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