"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchSetAlarmStateAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to change the state of an Amazon CloudWatch alarm.
 */
class CloudWatchSetAlarmStateAction {
    constructor(alarm, props) {
        this.alarm = alarm;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_CloudWatchSetAlarmStateActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchSetAlarmStateAction);
            }
            throw error;
        }
    }
    /**
     * @internal
     */
    _bind(topicRule) {
        const role = this.props.role ?? (0, role_1.singletonActionRole)(topicRule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['cloudwatch:SetAlarmState'],
            resources: [this.alarm.alarmArn],
        }));
        return {
            configuration: {
                cloudwatchAlarm: {
                    alarmName: this.alarm.alarmName,
                    roleArn: role.roleArn,
                    stateReason: this.props.reason ?? `Set state of '${this.alarm.alarmName}' to '${this.props.alarmStateToSet}'`,
                    stateValue: this.props.alarmStateToSet,
                },
            },
        };
    }
}
exports.CloudWatchSetAlarmStateAction = CloudWatchSetAlarmStateAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchSetAlarmStateAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.CloudWatchSetAlarmStateAction", version: "2.214.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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