"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchLogsAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * The action to send data to Amazon CloudWatch Logs
 */
class CloudWatchLogsAction {
    /**
     * @param logGroup The CloudWatch log group to which the action sends data
     * @param props Optional properties to not use default
     */
    constructor(logGroup, props = {}) {
        this.logGroup = logGroup;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_CloudWatchLogsActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchLogsAction);
            }
            throw error;
        }
        this.role = props.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        this.logGroup.grantWrite(role);
        this.logGroup.grant(role, 'logs:DescribeLogStreams');
        return {
            configuration: {
                cloudwatchLogs: {
                    logGroupName: this.logGroup.logGroupName,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.CloudWatchLogsAction = CloudWatchLogsAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchLogsAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.CloudWatchLogsAction", version: "2.214.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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