"""
List eletronic distribution for all
chemical elements
"""
from enum import Enum, unique


@unique
class ElectronicDistribution(Enum):
    """
    Enum type for orbital type. Indices are basically the azimuthal quantum
    number, l.
    """

    H = [
        '    0    4\n',
        '    1    0     1.000     0.000    \n',
        '    2    1     0.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    He = [
        '    0    4\n',
        '    1    0     2.000     0.000    \n',
        '    2    1     0.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Li = [
        '    1    4\n',
        '    2    0     1.000     0.000    \n',
        '    2    1     0.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Be = [
        '    1    4\n',
        '    2    0     2.000     0.000    \n',
        '    2    1     0.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    B = [
        '    1    4\n',
        '    2    0     2.000     0.000    \n',
        '    2    1     1.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    C = [
        '    1    4\n',
        '    2    0     2.000     0.000    \n',
        '    2    1     2.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    N = [
        '    1    4\n',
        '    2    0     2.000     0.000    \n',
        '    2    1     3.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    O = [
        '    1    4\n',
        '    2    0     2.000     0.000    \n',
        '    2    1     4.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    F = [
        '    1    4\n',
        '    2    0     2.000     0.000    \n',
        '    2    1     5.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Ne = [
        '    1    4\n',
        '    2    0     2.000     0.000    \n',
        '    2    1     6.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Na = [
        '    3    4\n',
        '    3    0     1.000     0.000    \n',
        '    3    1     0.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Mg = [
        '    3    4\n',
        '    3    0     2.000     0.000    \n',
        '    3    1     0.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Al = [
        '    3    4\n',
        '    3    0     2.000     0.000    \n',
        '    3    1     1.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Si = [
        '    3    4\n',
        '    3    0     2.000     0.000    \n',
        '    3    1     2.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    P = [
        '    3    4\n',
        '    3    0     2.000     0.000    \n',
        '    3    1     3.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    S = [
        '    3    4\n',
        '    3    0     2.000     0.000    \n',
        '    3    1     4.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Cl = [
        '    3    4\n',
        '    3    0     2.000     0.000    \n',
        '    3    1     5.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Ar = [
        '    3    4\n',
        '    3    0     2.000     0.000    \n',
        '    3    1     6.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    K = [
        '    5    4\n',
        '    4    0     1.000     0.000    \n',
        '    4    1     0.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Ca = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     0.000     0.000    \n',
        '    3    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Sc = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     0.000     0.000    \n',
        '    3    2     1.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Ti = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     0.000     0.000    \n',
        '    3    2     2.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    V = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     0.000     0.000    \n',
        '    3    2     3.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Cr = [
        '    5    4\n',
        '    4    0     1.000     0.000    \n',
        '    4    1     0.000     0.000    \n',
        '    3    2     5.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Mn = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     0.000     0.000    \n',
        '    3    2     5.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Fe = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     0.000     0.000    \n',
        '    3    2     6.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Co = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     0.000     0.000    \n',
        '    3    2     7.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Ni = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     0.000     0.000    \n',
        '    3    2     8.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Cu = [
        '    5    4\n',
        '    4    0     1.000     0.000    \n',
        '    4    1     0.000     0.000    \n',
        '    3    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Zn = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     0.000     0.000    \n',
        '    3    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Ga = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     1.000     0.000    \n',
        '    3    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Ge = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     2.000     0.000    \n',
        '    3    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    As = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     3.000     0.000    \n',
        '    3    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Se = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     4.000     0.000    \n',
        '    3    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Br = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     5.000     0.000    \n',
        '    3    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Kr = [
        '    5    4\n',
        '    4    0     2.000     0.000    \n',
        '    4    1     6.000     0.000    \n',
        '    3    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Rb = [
        '    8    4\n',
        '    5    0     1.000     0.000    \n',
        '    5    1     0.000     0.000    \n',
        '    4    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Sr = [
        '    8    4\n',
        '    5    0     2.000     0.000    \n',
        '    5    1     0.000     0.000    \n',
        '    4    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Y = [
        '    8    4\n',
        '    5    0     2.000     0.000    \n',
        '    5    1     0.000     0.000    \n',
        '    4    2     1.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Zr = [
        '    8    4\n',
        '    5    0     2.000     0.000    \n',
        '    5    1     0.000     0.000    \n',
        '    4    2     2.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Nb = [
        '    8    4\n',
        '    5    0     1.000     0.000    \n',
        '    5    1     0.000     0.000    \n',
        '    4    2     4.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Mo = [
        '    8    4\n',
        '    5    0     1.000     0.000    \n',
        '    5    1     0.000     0.000    \n',
        '    4    2     5.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Tc = [
        '    8    4\n',
        '    5    0     2.000     0.000    \n',
        '    5    1     0.000     0.000    \n',
        '    4    2     5.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Ru = [
        '    8    4\n',
        '    5    0     1.000     0.000    \n',
        '    5    1     0.000     0.000    \n',
        '    4    2     7.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Rh = [
        '    8    4\n',
        '    5    0     1.000     0.000    \n',
        '    5    1     0.000     0.000    \n',
        '    4    2     8.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Pd = [
        '    8    4\n',
        '    5    0     0.000     0.000    \n',
        '    5    1     0.000     0.000    \n',
        '    4    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Ag = [
        '    8    4\n',
        '    5    0     1.000     0.000    \n',
        '    5    1     0.000     0.000    \n',
        '    4    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Cd = [
        '    8    4\n',
        '    5    0     2.000     0.000    \n',
        '    5    1     0.000     0.000    \n',
        '    4    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    In = [
        '    8    4\n',
        '    5    0     2.000     0.000    \n',
        '    5    1     1.000     0.000    \n',
        '    4    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Sn = [
        '    8    4\n',
        '    5    0     2.000     0.000    \n',
        '    5    1     2.000     0.000    \n',
        '    4    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Sb = [
        '    8    4\n',
        '    5    0     2.000     0.000    \n',
        '    5    1     3.000     0.000    \n',
        '    4    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    I = [
        '    8    4\n',
        '    5    0     2.000     0.000    \n',
        '    5    1     5.000     0.000    \n',
        '    4    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Xe = [
        '    8    4\n',
        '    5    0     2.000     0.000    \n',
        '    5    1     6.000     0.000    \n',
        '    4    2    10.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Cs = [
        '   11    4\n',
        '    6    0     1.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Ba = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    La = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     1.000     0.000    \n',
        '    4    3     0.000     0.000    \n',
    ]

    Ce = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     1.000     0.000    \n',
        '    4    3     1.000     0.000    \n',
    ]

    Pr = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3     3.000     0.000    \n',
    ]

    Nd = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3     4.000     0.000    \n',
    ]

    Pm = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3     5.000     0.000    \n',
    ]

    Sm = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3     6.000     0.000    \n',
    ]

    Eu = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3     7.000     0.000    \n',
    ]

    Gd = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     1.000     0.000    \n',
        '    4    3     7.000     0.000    \n',
    ]

    Tb = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3     9.000     0.000    \n',
    ]

    Dy = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3    10.000     0.000    \n',
    ]

    Ho = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3    11.000     0.000    \n',
    ]

    Er = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3    12.000     0.000    \n',
    ]

    Tm = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3    13.000     0.000    \n',
    ]

    Yb = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     0.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Lu = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     1.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Hf = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     2.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Ta = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     3.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    W = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     4.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Re = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     5.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Os = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     6.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Ir = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     7.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Pt = [
        '   11    4\n',
        '    6    0     1.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2     9.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Au = [
        '   11    4\n',
        '    6    0     1.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2    10.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Hg = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     0.000     0.000    \n',
        '    5    2    10.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Tl = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     1.000     0.000    \n',
        '    5    2    10.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Pb = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     2.000     0.000    \n',
        '    5    2    10.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Bi = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     3.000     0.000    \n',
        '    5    2    10.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Po = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     4.000     0.000    \n',
        '    5    2    10.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    At = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     5.000     0.000    \n',
        '    5    2    10.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Rn = [
        '   11    4\n',
        '    6    0     2.000     0.000    \n',
        '    6    1     6.000     0.000    \n',
        '    5    2    10.000     0.000    \n',
        '    4    3    14.000     0.000    \n',
    ]

    Fr = [
        '   15    4\n',
        '    7    0     1.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     0.000     0.000    \n',
        '    5    3     0.000     0.000    \n',
    ]

    Ra = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     0.000     0.000    \n',
        '    5    3     0.000     0.000    \n',
    ]

    Ac = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     1.000     0.000    \n',
        '    5    3     0.000     0.000    \n',
    ]

    Th = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     2.000     0.000    \n',
        '    5    3     0.000     0.000    \n',
    ]

    Pa = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     1.000     0.000    \n',
        '    5    3     2.000     0.000    \n',
    ]

    U = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     1.000     0.000    \n',
        '    5    3     3.000     0.000    \n',
    ]

    Np = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     1.000     0.000    \n',
        '    5    3     4.000     0.000    \n',
    ]

    Pu = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     0.000     0.000    \n',
        '    5    3     6.000     0.000    \n',
    ]

    Am = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     0.000     0.000    \n',
        '    5    3     7.000     0.000    \n',
    ]

    Cm = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     1.000     0.000    \n',
        '    5    3     7.000     0.000    \n',
    ]

    Bk = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     0.000     0.000    \n',
        '    5    3     9.000     0.000    \n',
    ]

    Cf = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     0.000     0.000    \n',
        '    5    3    10.000     0.000    \n',
    ]

    Es = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     0.000     0.000    \n',
        '    5    3    11.000     0.000    \n',
    ]

    Fm = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     0.000     0.000    \n',
        '    5    3    12.000     0.000    \n',
    ]

    Md = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     0.000     0.000    \n',
        '    5    3    13.000     0.000    \n',
    ]

    No = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     0.000     0.000    \n',
        '    6    2     0.000     0.000    \n',
        '    5    3    14.000     0.000    \n',
    ]

    Lr = [
        '   15    4\n',
        '    7    0     2.000     0.000    \n',
        '    7    1     1.000     0.000    \n',
        '    6    2     0.000     0.000    \n',
        '    5    3    14.000     0.000    \n',
    ]

    def __str__(self):
        return str(self.name)
