/* File: atomic_programmodule.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Fri Feb 12 21:21:06 2021
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include <stdarg.h>
#include "Python.h"
#include "fortranobject.h"
#include <string.h>
#include <setjmp.h>
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *atomic_program_error;
static PyObject *atomic_program_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef char * string;
typedef signed char signed_char;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
typedef void(*cb_derivs_in_rk4__user__routines_typedef)(double *,double *,double *);
typedef void(*cb_derivs_in_rkqc__user__routines_typedef)(double *,double *,double *);
typedef void(*cb_rkqc_in_odeint__user__routines_typedef)(double *,double *,int *,double *,double *,double *,double *,double *,double *);
typedef void(*cb_derivs_in_odeint__user__routines_typedef)(double *,double *,double *);
typedef double(*cb_func_in_brent__user__routines_typedef)(double *);
typedef double(*cb_func_in_brac__user__routines_typedef)(double *);
typedef double(*cb_func_in_rtbis__user__routines_typedef)(double *);
typedef double(*cb_func_in_zbrent__user__routines_typedef)(double *);
typedef double(*cb_fx_in_zbrak__user__routines_typedef)(double *);
typedef double(*cb_func_in_zbrac__user__routines_typedef)(double *);
typedef void(*cb_ps_generator_in_pseudo__user__routines_typedef)(int *,double *,double *);

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#define PRINTPYOBJERR(obj)\
    fprintf(stderr,"atomic_program.error is related to ");\
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");

\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
    if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
        PyErr_SetString(PyExc_MemoryError, "out of memory");\
        goto capi_fail;\
    } else {\
        (str)[len] = '\0';\
    }

#define pyobj_from_int1(v) (PyInt_FromLong(v))
#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#define GETSCALARFROMPYTUPLE(tuple,index,var,ctype,mess) {\
        if ((capi_tmp = PyTuple_GetItem((tuple),(index)))==NULL) goto capi_fail;\
        if (!(ctype ## _from_pyobj((var),capi_tmp,mess)))\
            goto capi_fail;\
    }

#define pyobj_from_double1(v) (PyFloat_FromDouble(v))
#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) _F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) _f2pywrap##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_WRAPPEDFUNC(f,F) F2PYWRAP##F##_
#else
#define F_WRAPPEDFUNC(f,F) f2pywrap##f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f##_,F##_)
#else
#define F_WRAPPEDFUNC_US(f,F) F_WRAPPEDFUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#define SWAP(a,b,t) {\
    t *c;\
    c = a;\
    a = b;\
    b = c;}

#define CHECKSCALAR(check,tcheck,name,show,var)\
    if (!(check)) {\
        char errstring[256];\
        sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
        PyErr_SetString(atomic_program_error,errstring);\
        /*goto capi_fail;*/\
    } else 
#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
#ifdef __sgi
        *v = PyFloat_AsDouble(obj);
#else
        *v = PyFloat_AS_DOUBLE(obj);
#endif
        return 1;
    }
    tmp = PyNumber_Float(obj);
    if (tmp) {
#ifdef __sgi
        *v = PyFloat_AsDouble(tmp);
#else
        *v = PyFloat_AS_DOUBLE(tmp);
#endif
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = atomic_program_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess) {
    PyArrayObject *arr = NULL;
    PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
    if (obj == Py_None) {
        if (*len == -1)
            *len = strlen(inistr); /* Will this cause problems? */
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,inistr,*len+1);
        return 1;
    }
    if (PyArray_Check(obj)) {
        if ((arr = (PyArrayObject *)obj) == NULL)
            goto capi_fail;
        if (!ISCONTIGUOUS(arr)) {
            PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
            goto capi_fail;
        }
        if (*len == -1)
            *len = (PyArray_ITEMSIZE(arr))*PyArray_SIZE(arr);
        STRINGMALLOC(*str,*len);
        STRINGCOPYN(*str,PyArray_DATA(arr),*len+1);
        return 1;
    }
    if (PyString_Check(obj)) {
        tmp = obj;
        Py_INCREF(tmp);
    }
    else if (PyUnicode_Check(obj)) {
        tmp = PyUnicode_AsASCIIString(obj);
    }
    else {
        PyObject *tmp2;
        tmp2 = PyObject_Str(obj);
        if (tmp2) {
            tmp = PyUnicode_AsASCIIString(tmp2);
            Py_DECREF(tmp2);
        }
        else {
            tmp = NULL;
        }
    }
    if (tmp == NULL) goto capi_fail;
    if (*len == -1)
        *len = PyString_GET_SIZE(tmp);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,PyString_AS_STRING(tmp),*len+1);
    Py_DECREF(tmp);
    return 1;
capi_fail:
    Py_XDECREF(tmp);
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = atomic_program_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyInt_Check(obj)) {
        *v = (int)PyInt_AS_LONG(obj);
        return 1;
    }
    tmp = PyNumber_Int(obj);
    if (tmp) {
        *v = PyInt_AS_LONG(tmp);
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = atomic_program_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int create_cb_arglist(PyObject* fun,PyTupleObject* xa,const int maxnofargs,const int nofoptargs,int *nofargs,PyTupleObject **args,const char *errmess) {
    PyObject *tmp = NULL;
    PyObject *tmp_fun = NULL;
    int tot,opt,ext,siz,i,di=0;
    CFUNCSMESS("create_cb_arglist\n");
    tot=opt=ext=siz=0;
    /* Get the total number of arguments */
    if (PyFunction_Check(fun)) {
        tmp_fun = fun;
        Py_INCREF(tmp_fun);
    }
    else {
        di = 1;
        if (PyObject_HasAttrString(fun,"im_func")) {
            tmp_fun = PyObject_GetAttrString(fun,"im_func");
        }
        else if (PyObject_HasAttrString(fun,"__call__")) {
            tmp = PyObject_GetAttrString(fun,"__call__");
            if (PyObject_HasAttrString(tmp,"im_func"))
                tmp_fun = PyObject_GetAttrString(tmp,"im_func");
            else {
                tmp_fun = fun; /* built-in function */
                Py_INCREF(tmp_fun);
                tot = maxnofargs;
                if (PyCFunction_Check(fun)) {
                    /* In case the function has a co_argcount (like on PyPy) */
                    di = 0;
                }
                if (xa != NULL)
                    tot += PyTuple_Size((PyObject *)xa);
            }
            Py_XDECREF(tmp);
        }
        else if (PyFortran_Check(fun) || PyFortran_Check1(fun)) {
            tot = maxnofargs;
            if (xa != NULL)
                tot += PyTuple_Size((PyObject *)xa);
            tmp_fun = fun;
            Py_INCREF(tmp_fun);
        }
        else if (F2PyCapsule_Check(fun)) {
            tot = maxnofargs;
            if (xa != NULL)
                ext = PyTuple_Size((PyObject *)xa);
            if(ext>0) {
                fprintf(stderr,"extra arguments tuple cannot be used with CObject call-back\n");
                goto capi_fail;
            }
            tmp_fun = fun;
            Py_INCREF(tmp_fun);
        }
    }
if (tmp_fun==NULL) {
fprintf(stderr,"Call-back argument must be function|instance|instance.__call__|f2py-function but got %s.\n",(fun==NULL?"NULL":Py_TYPE(fun)->tp_name));
goto capi_fail;
}
    if (PyObject_HasAttrString(tmp_fun,"__code__")) {
        if (PyObject_HasAttrString(tmp = PyObject_GetAttrString(tmp_fun,"__code__"),"co_argcount")) {
            PyObject *tmp_argcount = PyObject_GetAttrString(tmp,"co_argcount");
            Py_DECREF(tmp);
            if (tmp_argcount == NULL) {
                goto capi_fail;
            }
            tot = PyInt_AsLong(tmp_argcount) - di;
            Py_DECREF(tmp_argcount);
        }
    }
    /* Get the number of optional arguments */
    if (PyObject_HasAttrString(tmp_fun,"__defaults__")) {
        if (PyTuple_Check(tmp = PyObject_GetAttrString(tmp_fun,"__defaults__")))
            opt = PyTuple_Size(tmp);
        Py_XDECREF(tmp);
    }
    /* Get the number of extra arguments */
    if (xa != NULL)
        ext = PyTuple_Size((PyObject *)xa);
    /* Calculate the size of call-backs argument list */
    siz = MIN(maxnofargs+ext,tot);
    *nofargs = MAX(0,siz-ext);
#ifdef DEBUGCFUNCS
    fprintf(stderr,"debug-capi:create_cb_arglist:maxnofargs(-nofoptargs),tot,opt,ext,siz,nofargs=%d(-%d),%d,%d,%d,%d,%d\n",maxnofargs,nofoptargs,tot,opt,ext,siz,*nofargs);
#endif
    if (siz<tot-opt) {
        fprintf(stderr,"create_cb_arglist: Failed to build argument list (siz) with enough arguments (tot-opt) required by user-supplied function (siz,tot,opt=%d,%d,%d).\n",siz,tot,opt);
        goto capi_fail;
    }
    /* Initialize argument list */
    *args = (PyTupleObject *)PyTuple_New(siz);
    for (i=0;i<*nofargs;i++) {
        Py_INCREF(Py_None);
        PyTuple_SET_ITEM((PyObject *)(*args),i,Py_None);
    }
    if (xa != NULL)
        for (i=(*nofargs);i<siz;i++) {
            tmp = PyTuple_GetItem((PyObject *)xa,i-(*nofargs));
            Py_INCREF(tmp);
            PyTuple_SET_ITEM(*args,i,tmp);
        }
    CFUNCSMESS("create_cb_arglist-end\n");
    Py_DECREF(tmp_fun);
    return 1;
capi_fail:
    if ((PyErr_Occurred())==NULL)
        PyErr_SetString(atomic_program_error,errmess);
    Py_XDECREF(tmp_fun);
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(run,RUN)(void);
extern void F_WRAPPEDFUNC_US(nucl_z,NUCL_Z)(double*,string,size_t);
extern void F_FUNC(difnrl,DIFNRL)(int*,int*,double*,double*,double*,int*,int*,double*,double*,int*);
extern void F_FUNC(difrel,DIFREL)(int*,int*,double*,double*,double*,int*,int*,double*,double*);
extern void F_FUNC(dmixp,DMIXP)(double*,double*,double*,int*,int*,int*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC(dsolv1,DSOLV1)(int*,int*,int*);
extern void F_FUNC(pseudo,PSEUDO)(string,string,cb_ps_generator_in_pseudo__user__routines_typedef,size_t,size_t);
extern void F_FUNC(wf,WF)(int*,double*,double*);
extern void F_FUNC(hsc,HSC)(int*,double*,double*);
extern void F_FUNC(excorr,EXCORR)(string,double*,double*,double*,double*,double*,double*,double*,double*,double*,size_t);
extern void F_FUNC(tm2,TM2)(int*,double*,double*);
extern void F_FUNC(ker,KER)(int*,double*,double*);
extern void F_FUNC(wrapup,WRAPUP)(string,size_t);
extern void F_WRAPPEDFUNC_US(cutoff_function,CUTOFF_FUNCTION)(double*,double*);
extern void F_FUNC(splift,SPLIFT)(double*,double*,double*,double*,int*,double*,int*,int*,double*,double*,double*,double*);
extern void F_FUNC(spliq,SPLIQ)(double*,double*,double*,double*,int*,double*,double*,int*,double*,int*);
extern void F_FUNC(velect,VELECT)(int*,int*,string,double*,size_t);
extern void F_FUNC(vionic,VIONIC)(void);
extern void F_FUNC(wtrans,WTRANS)(double*,double*,int*,int*,int*);
extern void F_WRAPPEDFUNC(v0pp,V0PP)(double*,double*);
extern void F_WRAPPEDFUNC_US(chg_mism,CHG_MISM)(double*,double*);
extern void F_FUNC(dsolv2,DSOLV2)(int*,int*,string,int*,int*,int*,int*,size_t);
extern void F_FUNC(etotal,ETOTAL)(int*,int*);
extern void F_FUNC(ext,EXT)(int*);
extern void F_FUNC(input,INPUT)(int*);
extern void F_FUNC(header,HEADER)(void);
extern void F_FUNC(orban,ORBAN)(int*,string,double*,double*,int*,int*,double*,double*,double*,double*,double*,size_t);
extern void F_FUNC(potran,POTRAN)(int*,double*,double*,int*,double*,double*);
extern void F_FUNC(potrv,POTRV)(double*,double*,int*,int*,double*);
extern void F_FUNC(potrvs,POTRVS)(double*,double*,int*,int*);
extern void F_FUNC(totalw,TOTALW)(int*);
extern void F_FUNC(potrw,POTRW)(double*,double*,int*,int*,int*,int*,double*);
extern void F_FUNC(prdiff,PRDIFF)(int*,double*,int*);
extern void F_FUNC(chrlen,CHRLEN)(string,int*,int*,size_t);
extern void F_FUNC(chrcap,CHRCAP)(string,int*,size_t);
extern void F_WRAPPEDFUNC(leqi,LEQI)(int*,string,string,size_t,size_t);
extern void F_FUNC_US(loc_des,LOC_DES)(string,size_t);
extern void F_FUNC(zbrac,ZBRAC)(cb_func_in_zbrac__user__routines_typedef,double*,double*,int*);
extern void F_FUNC(zbrak,ZBRAK)(cb_fx_in_zbrak__user__routines_typedef,double*,double*,int*,double*,double*,int*);
extern void F_WRAPPEDFUNC(zbrent,ZBRENT)(double*,cb_func_in_zbrent__user__routines_typedef,double*,double*,double*);
extern void F_WRAPPEDFUNC(rtbis,RTBIS)(double*,cb_func_in_rtbis__user__routines_typedef,double*,double*,double*);
extern void F_FUNC(brac,BRAC)(cb_func_in_brac__user__routines_typedef,double*,double*,int*);
extern void F_WRAPPEDFUNC(brent,BRENT)(double*,cb_func_in_brent__user__routines_typedef,double*,double*,double*);
extern void F_FUNC(genrhs,GENRHS)(double*,double*,double*);
extern void F_FUNC(logder,LOGDER)(int*,int*,string,size_t);
extern void F_FUNC(ode,ODE)(double*,double*,double*);
extern void F_FUNC(denplot,DENPLOT)(void);
extern void F_FUNC(saxpy,SAXPY)(int*,double*,double*,int*,double*,int*);
extern void F_WRAPPEDFUNC(sdot,SDOT)(double*,int*,double*,int*,double*,int*);
extern void F_FUNC(scopy,SCOPY)(int*,double*,int*,double*,int*);
extern void F_FUNC(sscal,SSCAL)(int*,double*,double*,int*);
extern void F_FUNC(tridib,TRIDIB)(int*,double*,double*,double*,double*,double*,double*,int*,int*,double*,int*,int*,double*,double*);
extern void F_FUNC(tinvit,TINVIT)(int*,int*,double*,double*,double*,int*,double*,int*,double*,int*,double*,double*,double*,double*,double*);
extern void F_FUNC(sgeco,SGECO)(double*,int*,int*,int*,double*,double*);
extern void F_WRAPPEDFUNC(epslon,EPSLON)(double*,double*);
extern void F_WRAPPEDFUNC(pythag,PYTHAG)(double*,double*,double*);
extern void F_WRAPPEDFUNC(sasum,SASUM)(double*,int*,double*,int*);
extern void F_FUNC(sgefa,SGEFA)(double*,int*,int*,int*,int*);
extern void F_WRAPPEDFUNC(isamax,ISAMAX)(int*,int*,double*,int*);
extern void F_FUNC(sgesl,SGESL)(double*,int*,int*,int*,double*,int*);
extern void F_WRAPPEDFUNC(isrchfgt,ISRCHFGT)(int*,int*,double*,int*,double*);
extern void F_FUNC(hunt,HUNT)(double*,int*,double*,int*);
extern void F_FUNC(locate,LOCATE)(double*,int*,double*,int*);
extern void F_FUNC(odeint,ODEINT)(double*,int*,double*,double*,double*,double*,double*,int*,int*,cb_derivs_in_odeint__user__routines_typedef,cb_rkqc_in_odeint__user__routines_typedef);
extern void F_FUNC(polint,POLINT)(double*,double*,int*,double*,double*,double*);
extern void F_FUNC(rkqc,RKQC)(double*,double*,int*,double*,double*,double*,double*,double*,double*,cb_derivs_in_rkqc__user__routines_typedef);
extern void F_FUNC(rk4,RK4)(double*,double*,int*,double*,double*,double*,cb_derivs_in_rk4__user__routines_typedef);
extern void F_FUNC_US(compat_params,COMPAT_PARAMS)(string,size_t);
extern void F_FUNC_US(pcc_exp,PCC_EXP)(int*,int*,double*,double*,double*,double*,double*);
extern void F_FUNC_US(change_valence,CHANGE_VALENCE)(void);
extern void F_FUNC(coreq,COREQ)(void);
extern void F_FUNC_US(get_unit,GET_UNIT)(int*);
extern void F_FUNC(gauleg,GAULEG)(double*,double*,double*,double*,int*);
extern void F_WRAPPEDFUNC(divdif,DIVDIF)(double*,double*,double*,int*,double*,int*);
extern void F_FUNC_US(check_directives,CHECK_DIRECTIVES)(int*);
extern void F_FUNC(getline,GETLINE)(int*,string,size_t);
extern void F_FUNC(directive,DIRECTIVE)(string,size_t);
extern void F_WRAPPEDFUNC(defined,DEFINED)(int*,string,size_t);
extern void F_FUNC(insert,INSERT)(string,string,size_t,size_t);
extern void F_WRAPPEDFUNC_US(put_pair,PUT_PAIR)(int*,string,string,size_t,size_t);
extern void F_WRAPPEDFUNC_US(set_value,SET_VALUE)(double*,string,string,size_t,size_t);
extern void F_FUNC_US(get_real,GET_REAL)(string,double*,size_t);
extern void F_FUNC_US(print_pairs,PRINT_PAIRS)(void);
extern void F_FUNC(prversion,PRVERSION)(void);
extern void F_FUNC(atomxc,ATOMXC)(string,string,int*,int*,int*,double*,int*,double*,double*,double*,double*,double*,double*,size_t,size_t);
extern void F_FUNC(exchng,EXCHNG)(int*,int*,double*,double*,double*);
extern void F_FUNC(ggaxc,GGAXC)(string,int*,int*,double*,double*,double*,double*,double*,double*,double*,double*,size_t);
extern void F_FUNC(ldaxc,LDAXC)(string,int*,int*,double*,double*,double*,double*,double*,double*,double*,size_t);
extern void F_FUNC(pbexc,PBEXC)(int*,int*,double*,double*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC(pw91xc,PW91XC)(int*,int*,double*,double*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC(pw92c,PW92C)(int*,double*,double*,double*);
extern void F_FUNC(pw92xc,PW92XC)(int*,int*,double*,double*,double*,double*,double*);
extern void F_FUNC(pzxc,PZXC)(int*,int*,double*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC(blypxc,BLYPXC)(int*,double*,double*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC(rpbexc,RPBEXC)(int*,int*,double*,double*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC(revpbexc,REVPBEXC)(int*,int*,double*,double*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC_US(cal_date,CAL_DATE)(string,size_t);
extern void F_WRAPPEDFUNC(second,SECOND)(double*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/

/***************** cb_ps_generator_in_pseudo__user__routines *****************/
PyObject *cb_ps_generator_in_pseudo__user__routines_capi = NULL;/*was Py_None*/
PyTupleObject *cb_ps_generator_in_pseudo__user__routines_args_capi = NULL;
int cb_ps_generator_in_pseudo__user__routines_nofargs = 0;
jmp_buf cb_ps_generator_in_pseudo__user__routines_jmpbuf;
/*typedef void(*cb_ps_generator_in_pseudo__user__routines_typedef)(int *,double *,double *);*/
static void cb_ps_generator_in_pseudo__user__routines (int *i_cb_capi,double *ar,double *br) {
  PyTupleObject *capi_arglist = cb_ps_generator_in_pseudo__user__routines_args_capi;
  PyObject *capi_return = NULL;
  PyObject *capi_tmp = NULL;
  PyObject *capi_arglist_list = NULL;
  int capi_j,capi_i = 0;
  int capi_longjmp_ok = 1;
/*decl*/
  int i=(*i_cb_capi);
  npy_intp ar_Dims[1] = {-1};
  npy_intp br_Dims[1] = {-1};
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
  CFUNCSMESS("cb:Call-back function cb_ps_generator_in_pseudo__user__routines (maxnofargs=3(-0))\n");
  CFUNCSMESSPY("cb:cb_ps_generator_in_pseudo__user__routines_capi=",cb_ps_generator_in_pseudo__user__routines_capi);
  if (cb_ps_generator_in_pseudo__user__routines_capi==NULL) {
    capi_longjmp_ok = 0;
    cb_ps_generator_in_pseudo__user__routines_capi = PyObject_GetAttrString(atomic_program_module,"ps_generator");
  }
  if (cb_ps_generator_in_pseudo__user__routines_capi==NULL) {
    PyErr_SetString(atomic_program_error,"cb: Callback ps_generator not defined (as an argument or module atomic_program attribute).\n");
    goto capi_fail;
  }
  if (F2PyCapsule_Check(cb_ps_generator_in_pseudo__user__routines_capi)) {
  cb_ps_generator_in_pseudo__user__routines_typedef cb_ps_generator_in_pseudo__user__routines_cptr;
  cb_ps_generator_in_pseudo__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb_ps_generator_in_pseudo__user__routines_capi);
  (*cb_ps_generator_in_pseudo__user__routines_cptr)(i_cb_capi,ar,br);
  return;
  }
  if (capi_arglist==NULL) {
    capi_longjmp_ok = 0;
    capi_tmp = PyObject_GetAttrString(atomic_program_module,"ps_generator_extra_args");
    if (capi_tmp) {
      capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
      if (capi_arglist==NULL) {
        PyErr_SetString(atomic_program_error,"Failed to convert atomic_program.ps_generator_extra_args to tuple.\n");
        goto capi_fail;
      }
    } else {
      PyErr_Clear();
      capi_arglist = (PyTupleObject *)Py_BuildValue("()");
    }
  }
  if (capi_arglist == NULL) {
    PyErr_SetString(atomic_program_error,"Callback ps_generator argument list is not set.\n");
    goto capi_fail;
  }
/*setdims*/
  ar_Dims[0]=1500;
  br_Dims[0]=1500;
#ifdef PYPY_VERSION
#define CAPI_ARGLIST_SETITEM(idx, value) PyList_SetItem((PyObject *)capi_arglist_list, idx, value)
  capi_arglist_list = PySequence_List(capi_arglist);
  if (capi_arglist_list == NULL) goto capi_fail;
#else
#define CAPI_ARGLIST_SETITEM(idx, value) PyTuple_SetItem((PyObject *)capi_arglist, idx, value)
#endif
/*pyobjfrom*/
  if (cb_ps_generator_in_pseudo__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_int1(i)))
      goto capi_fail;
  if (cb_ps_generator_in_pseudo__user__routines_nofargs>capi_i) {
    int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
    /*XXX: Hmm, what will destroy this array??? */
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,ar_Dims,NPY_DOUBLE,NULL,(char*)ar,itemsize_,NPY_ARRAY_FARRAY,NULL);


    if (tmp_arr==NULL)
      goto capi_fail;
    if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
  if (cb_ps_generator_in_pseudo__user__routines_nofargs>capi_i) {
    int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
    /*XXX: Hmm, what will destroy this array??? */
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,br_Dims,NPY_DOUBLE,NULL,(char*)br,itemsize_,NPY_ARRAY_FARRAY,NULL);


    if (tmp_arr==NULL)
      goto capi_fail;
    if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
#undef CAPI_ARGLIST_SETITEM
#ifdef PYPY_VERSION
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist_list);
#else
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
#endif
  CFUNCSMESS("cb:Call-back calling Python function ps_generator.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
#ifdef PYPY_VERSION
  capi_return = PyObject_CallObject(cb_ps_generator_in_pseudo__user__routines_capi,(PyObject *)capi_arglist_list);
  Py_DECREF(capi_arglist_list);
  capi_arglist_list = NULL;
#else
  capi_return = PyObject_CallObject(cb_ps_generator_in_pseudo__user__routines_capi,(PyObject *)capi_arglist);
#endif
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
  CFUNCSMESSPY("cb:capi_return=",capi_return);
  if (capi_return == NULL) {
    fprintf(stderr,"capi_return is NULL\n");
    goto capi_fail;
  }
  if (capi_return == Py_None) {
    Py_DECREF(capi_return);
    capi_return = Py_BuildValue("()");
  }
  else if (!PyTuple_Check(capi_return)) {
    capi_return = Py_BuildValue("(N)",capi_return);
  }
  capi_j = PyTuple_Size(capi_return);
  capi_i = 0;
/*frompyobj*/
  CFUNCSMESS("cb:cb_ps_generator_in_pseudo__user__routines:successful\n");
  Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
  goto capi_return_pt;
capi_fail:
  fprintf(stderr,"Call-back cb_ps_generator_in_pseudo__user__routines failed.\n");
  Py_XDECREF(capi_return);
  Py_XDECREF(capi_arglist_list);
  if (capi_longjmp_ok)
    longjmp(cb_ps_generator_in_pseudo__user__routines_jmpbuf,-1);
capi_return_pt:
  ;
return;
}
/************** end of cb_ps_generator_in_pseudo__user__routines **************/


/********************** cb_func_in_zbrac__user__routines **********************/
PyObject *cb_func_in_zbrac__user__routines_capi = NULL;/*was Py_None*/
PyTupleObject *cb_func_in_zbrac__user__routines_args_capi = NULL;
int cb_func_in_zbrac__user__routines_nofargs = 0;
jmp_buf cb_func_in_zbrac__user__routines_jmpbuf;
/*typedef double(*cb_func_in_zbrac__user__routines_typedef)(double *);*/
static double cb_func_in_zbrac__user__routines (double *x1_cb_capi) {
  PyTupleObject *capi_arglist = cb_func_in_zbrac__user__routines_args_capi;
  PyObject *capi_return = NULL;
  PyObject *capi_tmp = NULL;
  PyObject *capi_arglist_list = NULL;
  int capi_j,capi_i = 0;
  int capi_longjmp_ok = 1;
/*decl*/
  double return_value;
  double x1=(*x1_cb_capi);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
  CFUNCSMESS("cb:Call-back function cb_func_in_zbrac__user__routines (maxnofargs=1(-0))\n");
  CFUNCSMESSPY("cb:cb_func_in_zbrac__user__routines_capi=",cb_func_in_zbrac__user__routines_capi);
  if (cb_func_in_zbrac__user__routines_capi==NULL) {
    capi_longjmp_ok = 0;
    cb_func_in_zbrac__user__routines_capi = PyObject_GetAttrString(atomic_program_module,"func");
  }
  if (cb_func_in_zbrac__user__routines_capi==NULL) {
    PyErr_SetString(atomic_program_error,"cb: Callback func not defined (as an argument or module atomic_program attribute).\n");
    goto capi_fail;
  }
  if (F2PyCapsule_Check(cb_func_in_zbrac__user__routines_capi)) {
  cb_func_in_zbrac__user__routines_typedef cb_func_in_zbrac__user__routines_cptr;
  cb_func_in_zbrac__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb_func_in_zbrac__user__routines_capi);
  return_value=(*cb_func_in_zbrac__user__routines_cptr)(x1_cb_capi);
    return return_value;
  }
  if (capi_arglist==NULL) {
    capi_longjmp_ok = 0;
    capi_tmp = PyObject_GetAttrString(atomic_program_module,"func_extra_args");
    if (capi_tmp) {
      capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
      if (capi_arglist==NULL) {
        PyErr_SetString(atomic_program_error,"Failed to convert atomic_program.func_extra_args to tuple.\n");
        goto capi_fail;
      }
    } else {
      PyErr_Clear();
      capi_arglist = (PyTupleObject *)Py_BuildValue("()");
    }
  }
  if (capi_arglist == NULL) {
    PyErr_SetString(atomic_program_error,"Callback func argument list is not set.\n");
    goto capi_fail;
  }
/*setdims*/
#ifdef PYPY_VERSION
#define CAPI_ARGLIST_SETITEM(idx, value) PyList_SetItem((PyObject *)capi_arglist_list, idx, value)
  capi_arglist_list = PySequence_List(capi_arglist);
  if (capi_arglist_list == NULL) goto capi_fail;
#else
#define CAPI_ARGLIST_SETITEM(idx, value) PyTuple_SetItem((PyObject *)capi_arglist, idx, value)
#endif
/*pyobjfrom*/
  if (cb_func_in_zbrac__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(x1)))
      goto capi_fail;
#undef CAPI_ARGLIST_SETITEM
#ifdef PYPY_VERSION
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist_list);
#else
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
#endif
  CFUNCSMESS("cb:Call-back calling Python function func.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
#ifdef PYPY_VERSION
  capi_return = PyObject_CallObject(cb_func_in_zbrac__user__routines_capi,(PyObject *)capi_arglist_list);
  Py_DECREF(capi_arglist_list);
  capi_arglist_list = NULL;
#else
  capi_return = PyObject_CallObject(cb_func_in_zbrac__user__routines_capi,(PyObject *)capi_arglist);
#endif
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
  CFUNCSMESSPY("cb:capi_return=",capi_return);
  if (capi_return == NULL) {
    fprintf(stderr,"capi_return is NULL\n");
    goto capi_fail;
  }
  if (capi_return == Py_None) {
    Py_DECREF(capi_return);
    capi_return = Py_BuildValue("()");
  }
  else if (!PyTuple_Check(capi_return)) {
    capi_return = Py_BuildValue("(N)",capi_return);
  }
  capi_j = PyTuple_Size(capi_return);
  capi_i = 0;
/*frompyobj*/
  if (capi_j>capi_i)
    GETSCALARFROMPYTUPLE(capi_return,capi_i++,&return_value,double,"double_from_pyobj failed in converting return_value of call-back function cb_func_in_zbrac__user__routines to C double\n");
  CFUNCSMESS("cb:cb_func_in_zbrac__user__routines:successful\n");
  Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
  goto capi_return_pt;
capi_fail:
  fprintf(stderr,"Call-back cb_func_in_zbrac__user__routines failed.\n");
  Py_XDECREF(capi_return);
  Py_XDECREF(capi_arglist_list);
  if (capi_longjmp_ok)
    longjmp(cb_func_in_zbrac__user__routines_jmpbuf,-1);
capi_return_pt:
  ;
  return return_value;
}
/****************** end of cb_func_in_zbrac__user__routines ******************/


/*********************** cb_fx_in_zbrak__user__routines ***********************/
PyObject *cb_fx_in_zbrak__user__routines_capi = NULL;/*was Py_None*/
PyTupleObject *cb_fx_in_zbrak__user__routines_args_capi = NULL;
int cb_fx_in_zbrak__user__routines_nofargs = 0;
jmp_buf cb_fx_in_zbrak__user__routines_jmpbuf;
/*typedef double(*cb_fx_in_zbrak__user__routines_typedef)(double *);*/
static double cb_fx_in_zbrak__user__routines (double *x_cb_capi) {
  PyTupleObject *capi_arglist = cb_fx_in_zbrak__user__routines_args_capi;
  PyObject *capi_return = NULL;
  PyObject *capi_tmp = NULL;
  PyObject *capi_arglist_list = NULL;
  int capi_j,capi_i = 0;
  int capi_longjmp_ok = 1;
/*decl*/
  double return_value;
  double x=(*x_cb_capi);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
  CFUNCSMESS("cb:Call-back function cb_fx_in_zbrak__user__routines (maxnofargs=1(-0))\n");
  CFUNCSMESSPY("cb:cb_fx_in_zbrak__user__routines_capi=",cb_fx_in_zbrak__user__routines_capi);
  if (cb_fx_in_zbrak__user__routines_capi==NULL) {
    capi_longjmp_ok = 0;
    cb_fx_in_zbrak__user__routines_capi = PyObject_GetAttrString(atomic_program_module,"fx");
  }
  if (cb_fx_in_zbrak__user__routines_capi==NULL) {
    PyErr_SetString(atomic_program_error,"cb: Callback fx not defined (as an argument or module atomic_program attribute).\n");
    goto capi_fail;
  }
  if (F2PyCapsule_Check(cb_fx_in_zbrak__user__routines_capi)) {
  cb_fx_in_zbrak__user__routines_typedef cb_fx_in_zbrak__user__routines_cptr;
  cb_fx_in_zbrak__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb_fx_in_zbrak__user__routines_capi);
  return_value=(*cb_fx_in_zbrak__user__routines_cptr)(x_cb_capi);
    return return_value;
  }
  if (capi_arglist==NULL) {
    capi_longjmp_ok = 0;
    capi_tmp = PyObject_GetAttrString(atomic_program_module,"fx_extra_args");
    if (capi_tmp) {
      capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
      if (capi_arglist==NULL) {
        PyErr_SetString(atomic_program_error,"Failed to convert atomic_program.fx_extra_args to tuple.\n");
        goto capi_fail;
      }
    } else {
      PyErr_Clear();
      capi_arglist = (PyTupleObject *)Py_BuildValue("()");
    }
  }
  if (capi_arglist == NULL) {
    PyErr_SetString(atomic_program_error,"Callback fx argument list is not set.\n");
    goto capi_fail;
  }
/*setdims*/
#ifdef PYPY_VERSION
#define CAPI_ARGLIST_SETITEM(idx, value) PyList_SetItem((PyObject *)capi_arglist_list, idx, value)
  capi_arglist_list = PySequence_List(capi_arglist);
  if (capi_arglist_list == NULL) goto capi_fail;
#else
#define CAPI_ARGLIST_SETITEM(idx, value) PyTuple_SetItem((PyObject *)capi_arglist, idx, value)
#endif
/*pyobjfrom*/
  if (cb_fx_in_zbrak__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(x)))
      goto capi_fail;
#undef CAPI_ARGLIST_SETITEM
#ifdef PYPY_VERSION
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist_list);
#else
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
#endif
  CFUNCSMESS("cb:Call-back calling Python function fx.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
#ifdef PYPY_VERSION
  capi_return = PyObject_CallObject(cb_fx_in_zbrak__user__routines_capi,(PyObject *)capi_arglist_list);
  Py_DECREF(capi_arglist_list);
  capi_arglist_list = NULL;
#else
  capi_return = PyObject_CallObject(cb_fx_in_zbrak__user__routines_capi,(PyObject *)capi_arglist);
#endif
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
  CFUNCSMESSPY("cb:capi_return=",capi_return);
  if (capi_return == NULL) {
    fprintf(stderr,"capi_return is NULL\n");
    goto capi_fail;
  }
  if (capi_return == Py_None) {
    Py_DECREF(capi_return);
    capi_return = Py_BuildValue("()");
  }
  else if (!PyTuple_Check(capi_return)) {
    capi_return = Py_BuildValue("(N)",capi_return);
  }
  capi_j = PyTuple_Size(capi_return);
  capi_i = 0;
/*frompyobj*/
  if (capi_j>capi_i)
    GETSCALARFROMPYTUPLE(capi_return,capi_i++,&return_value,double,"double_from_pyobj failed in converting return_value of call-back function cb_fx_in_zbrak__user__routines to C double\n");
  CFUNCSMESS("cb:cb_fx_in_zbrak__user__routines:successful\n");
  Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
  goto capi_return_pt;
capi_fail:
  fprintf(stderr,"Call-back cb_fx_in_zbrak__user__routines failed.\n");
  Py_XDECREF(capi_return);
  Py_XDECREF(capi_arglist_list);
  if (capi_longjmp_ok)
    longjmp(cb_fx_in_zbrak__user__routines_jmpbuf,-1);
capi_return_pt:
  ;
  return return_value;
}
/******************* end of cb_fx_in_zbrak__user__routines *******************/


/********************* cb_func_in_zbrent__user__routines *********************/
PyObject *cb_func_in_zbrent__user__routines_capi = NULL;/*was Py_None*/
PyTupleObject *cb_func_in_zbrent__user__routines_args_capi = NULL;
int cb_func_in_zbrent__user__routines_nofargs = 0;
jmp_buf cb_func_in_zbrent__user__routines_jmpbuf;
/*typedef double(*cb_func_in_zbrent__user__routines_typedef)(double *);*/
static double cb_func_in_zbrent__user__routines (double *a_cb_capi) {
  PyTupleObject *capi_arglist = cb_func_in_zbrent__user__routines_args_capi;
  PyObject *capi_return = NULL;
  PyObject *capi_tmp = NULL;
  PyObject *capi_arglist_list = NULL;
  int capi_j,capi_i = 0;
  int capi_longjmp_ok = 1;
/*decl*/
  double return_value;
  double a=(*a_cb_capi);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
  CFUNCSMESS("cb:Call-back function cb_func_in_zbrent__user__routines (maxnofargs=1(-0))\n");
  CFUNCSMESSPY("cb:cb_func_in_zbrent__user__routines_capi=",cb_func_in_zbrent__user__routines_capi);
  if (cb_func_in_zbrent__user__routines_capi==NULL) {
    capi_longjmp_ok = 0;
    cb_func_in_zbrent__user__routines_capi = PyObject_GetAttrString(atomic_program_module,"func");
  }
  if (cb_func_in_zbrent__user__routines_capi==NULL) {
    PyErr_SetString(atomic_program_error,"cb: Callback func not defined (as an argument or module atomic_program attribute).\n");
    goto capi_fail;
  }
  if (F2PyCapsule_Check(cb_func_in_zbrent__user__routines_capi)) {
  cb_func_in_zbrent__user__routines_typedef cb_func_in_zbrent__user__routines_cptr;
  cb_func_in_zbrent__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb_func_in_zbrent__user__routines_capi);
  return_value=(*cb_func_in_zbrent__user__routines_cptr)(a_cb_capi);
    return return_value;
  }
  if (capi_arglist==NULL) {
    capi_longjmp_ok = 0;
    capi_tmp = PyObject_GetAttrString(atomic_program_module,"func_extra_args");
    if (capi_tmp) {
      capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
      if (capi_arglist==NULL) {
        PyErr_SetString(atomic_program_error,"Failed to convert atomic_program.func_extra_args to tuple.\n");
        goto capi_fail;
      }
    } else {
      PyErr_Clear();
      capi_arglist = (PyTupleObject *)Py_BuildValue("()");
    }
  }
  if (capi_arglist == NULL) {
    PyErr_SetString(atomic_program_error,"Callback func argument list is not set.\n");
    goto capi_fail;
  }
/*setdims*/
#ifdef PYPY_VERSION
#define CAPI_ARGLIST_SETITEM(idx, value) PyList_SetItem((PyObject *)capi_arglist_list, idx, value)
  capi_arglist_list = PySequence_List(capi_arglist);
  if (capi_arglist_list == NULL) goto capi_fail;
#else
#define CAPI_ARGLIST_SETITEM(idx, value) PyTuple_SetItem((PyObject *)capi_arglist, idx, value)
#endif
/*pyobjfrom*/
  if (cb_func_in_zbrent__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(a)))
      goto capi_fail;
#undef CAPI_ARGLIST_SETITEM
#ifdef PYPY_VERSION
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist_list);
#else
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
#endif
  CFUNCSMESS("cb:Call-back calling Python function func.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
#ifdef PYPY_VERSION
  capi_return = PyObject_CallObject(cb_func_in_zbrent__user__routines_capi,(PyObject *)capi_arglist_list);
  Py_DECREF(capi_arglist_list);
  capi_arglist_list = NULL;
#else
  capi_return = PyObject_CallObject(cb_func_in_zbrent__user__routines_capi,(PyObject *)capi_arglist);
#endif
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
  CFUNCSMESSPY("cb:capi_return=",capi_return);
  if (capi_return == NULL) {
    fprintf(stderr,"capi_return is NULL\n");
    goto capi_fail;
  }
  if (capi_return == Py_None) {
    Py_DECREF(capi_return);
    capi_return = Py_BuildValue("()");
  }
  else if (!PyTuple_Check(capi_return)) {
    capi_return = Py_BuildValue("(N)",capi_return);
  }
  capi_j = PyTuple_Size(capi_return);
  capi_i = 0;
/*frompyobj*/
  if (capi_j>capi_i)
    GETSCALARFROMPYTUPLE(capi_return,capi_i++,&return_value,double,"double_from_pyobj failed in converting return_value of call-back function cb_func_in_zbrent__user__routines to C double\n");
  CFUNCSMESS("cb:cb_func_in_zbrent__user__routines:successful\n");
  Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
  goto capi_return_pt;
capi_fail:
  fprintf(stderr,"Call-back cb_func_in_zbrent__user__routines failed.\n");
  Py_XDECREF(capi_return);
  Py_XDECREF(capi_arglist_list);
  if (capi_longjmp_ok)
    longjmp(cb_func_in_zbrent__user__routines_jmpbuf,-1);
capi_return_pt:
  ;
  return return_value;
}
/****************** end of cb_func_in_zbrent__user__routines ******************/


/********************** cb_func_in_rtbis__user__routines **********************/
PyObject *cb_func_in_rtbis__user__routines_capi = NULL;/*was Py_None*/
PyTupleObject *cb_func_in_rtbis__user__routines_args_capi = NULL;
int cb_func_in_rtbis__user__routines_nofargs = 0;
jmp_buf cb_func_in_rtbis__user__routines_jmpbuf;
/*typedef double(*cb_func_in_rtbis__user__routines_typedef)(double *);*/
static double cb_func_in_rtbis__user__routines (double *x2_cb_capi) {
  PyTupleObject *capi_arglist = cb_func_in_rtbis__user__routines_args_capi;
  PyObject *capi_return = NULL;
  PyObject *capi_tmp = NULL;
  PyObject *capi_arglist_list = NULL;
  int capi_j,capi_i = 0;
  int capi_longjmp_ok = 1;
/*decl*/
  double return_value;
  double x2=(*x2_cb_capi);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
  CFUNCSMESS("cb:Call-back function cb_func_in_rtbis__user__routines (maxnofargs=1(-0))\n");
  CFUNCSMESSPY("cb:cb_func_in_rtbis__user__routines_capi=",cb_func_in_rtbis__user__routines_capi);
  if (cb_func_in_rtbis__user__routines_capi==NULL) {
    capi_longjmp_ok = 0;
    cb_func_in_rtbis__user__routines_capi = PyObject_GetAttrString(atomic_program_module,"func");
  }
  if (cb_func_in_rtbis__user__routines_capi==NULL) {
    PyErr_SetString(atomic_program_error,"cb: Callback func not defined (as an argument or module atomic_program attribute).\n");
    goto capi_fail;
  }
  if (F2PyCapsule_Check(cb_func_in_rtbis__user__routines_capi)) {
  cb_func_in_rtbis__user__routines_typedef cb_func_in_rtbis__user__routines_cptr;
  cb_func_in_rtbis__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb_func_in_rtbis__user__routines_capi);
  return_value=(*cb_func_in_rtbis__user__routines_cptr)(x2_cb_capi);
    return return_value;
  }
  if (capi_arglist==NULL) {
    capi_longjmp_ok = 0;
    capi_tmp = PyObject_GetAttrString(atomic_program_module,"func_extra_args");
    if (capi_tmp) {
      capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
      if (capi_arglist==NULL) {
        PyErr_SetString(atomic_program_error,"Failed to convert atomic_program.func_extra_args to tuple.\n");
        goto capi_fail;
      }
    } else {
      PyErr_Clear();
      capi_arglist = (PyTupleObject *)Py_BuildValue("()");
    }
  }
  if (capi_arglist == NULL) {
    PyErr_SetString(atomic_program_error,"Callback func argument list is not set.\n");
    goto capi_fail;
  }
/*setdims*/
#ifdef PYPY_VERSION
#define CAPI_ARGLIST_SETITEM(idx, value) PyList_SetItem((PyObject *)capi_arglist_list, idx, value)
  capi_arglist_list = PySequence_List(capi_arglist);
  if (capi_arglist_list == NULL) goto capi_fail;
#else
#define CAPI_ARGLIST_SETITEM(idx, value) PyTuple_SetItem((PyObject *)capi_arglist, idx, value)
#endif
/*pyobjfrom*/
  if (cb_func_in_rtbis__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(x2)))
      goto capi_fail;
#undef CAPI_ARGLIST_SETITEM
#ifdef PYPY_VERSION
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist_list);
#else
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
#endif
  CFUNCSMESS("cb:Call-back calling Python function func.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
#ifdef PYPY_VERSION
  capi_return = PyObject_CallObject(cb_func_in_rtbis__user__routines_capi,(PyObject *)capi_arglist_list);
  Py_DECREF(capi_arglist_list);
  capi_arglist_list = NULL;
#else
  capi_return = PyObject_CallObject(cb_func_in_rtbis__user__routines_capi,(PyObject *)capi_arglist);
#endif
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
  CFUNCSMESSPY("cb:capi_return=",capi_return);
  if (capi_return == NULL) {
    fprintf(stderr,"capi_return is NULL\n");
    goto capi_fail;
  }
  if (capi_return == Py_None) {
    Py_DECREF(capi_return);
    capi_return = Py_BuildValue("()");
  }
  else if (!PyTuple_Check(capi_return)) {
    capi_return = Py_BuildValue("(N)",capi_return);
  }
  capi_j = PyTuple_Size(capi_return);
  capi_i = 0;
/*frompyobj*/
  if (capi_j>capi_i)
    GETSCALARFROMPYTUPLE(capi_return,capi_i++,&return_value,double,"double_from_pyobj failed in converting return_value of call-back function cb_func_in_rtbis__user__routines to C double\n");
  CFUNCSMESS("cb:cb_func_in_rtbis__user__routines:successful\n");
  Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
  goto capi_return_pt;
capi_fail:
  fprintf(stderr,"Call-back cb_func_in_rtbis__user__routines failed.\n");
  Py_XDECREF(capi_return);
  Py_XDECREF(capi_arglist_list);
  if (capi_longjmp_ok)
    longjmp(cb_func_in_rtbis__user__routines_jmpbuf,-1);
capi_return_pt:
  ;
  return return_value;
}
/****************** end of cb_func_in_rtbis__user__routines ******************/


/********************** cb_func_in_brac__user__routines **********************/
PyObject *cb_func_in_brac__user__routines_capi = NULL;/*was Py_None*/
PyTupleObject *cb_func_in_brac__user__routines_args_capi = NULL;
int cb_func_in_brac__user__routines_nofargs = 0;
jmp_buf cb_func_in_brac__user__routines_jmpbuf;
/*typedef double(*cb_func_in_brac__user__routines_typedef)(double *);*/
static double cb_func_in_brac__user__routines (double *x1_cb_capi) {
  PyTupleObject *capi_arglist = cb_func_in_brac__user__routines_args_capi;
  PyObject *capi_return = NULL;
  PyObject *capi_tmp = NULL;
  PyObject *capi_arglist_list = NULL;
  int capi_j,capi_i = 0;
  int capi_longjmp_ok = 1;
/*decl*/
  double return_value;
  double x1=(*x1_cb_capi);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
  CFUNCSMESS("cb:Call-back function cb_func_in_brac__user__routines (maxnofargs=1(-0))\n");
  CFUNCSMESSPY("cb:cb_func_in_brac__user__routines_capi=",cb_func_in_brac__user__routines_capi);
  if (cb_func_in_brac__user__routines_capi==NULL) {
    capi_longjmp_ok = 0;
    cb_func_in_brac__user__routines_capi = PyObject_GetAttrString(atomic_program_module,"func");
  }
  if (cb_func_in_brac__user__routines_capi==NULL) {
    PyErr_SetString(atomic_program_error,"cb: Callback func not defined (as an argument or module atomic_program attribute).\n");
    goto capi_fail;
  }
  if (F2PyCapsule_Check(cb_func_in_brac__user__routines_capi)) {
  cb_func_in_brac__user__routines_typedef cb_func_in_brac__user__routines_cptr;
  cb_func_in_brac__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb_func_in_brac__user__routines_capi);
  return_value=(*cb_func_in_brac__user__routines_cptr)(x1_cb_capi);
    return return_value;
  }
  if (capi_arglist==NULL) {
    capi_longjmp_ok = 0;
    capi_tmp = PyObject_GetAttrString(atomic_program_module,"func_extra_args");
    if (capi_tmp) {
      capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
      if (capi_arglist==NULL) {
        PyErr_SetString(atomic_program_error,"Failed to convert atomic_program.func_extra_args to tuple.\n");
        goto capi_fail;
      }
    } else {
      PyErr_Clear();
      capi_arglist = (PyTupleObject *)Py_BuildValue("()");
    }
  }
  if (capi_arglist == NULL) {
    PyErr_SetString(atomic_program_error,"Callback func argument list is not set.\n");
    goto capi_fail;
  }
/*setdims*/
#ifdef PYPY_VERSION
#define CAPI_ARGLIST_SETITEM(idx, value) PyList_SetItem((PyObject *)capi_arglist_list, idx, value)
  capi_arglist_list = PySequence_List(capi_arglist);
  if (capi_arglist_list == NULL) goto capi_fail;
#else
#define CAPI_ARGLIST_SETITEM(idx, value) PyTuple_SetItem((PyObject *)capi_arglist, idx, value)
#endif
/*pyobjfrom*/
  if (cb_func_in_brac__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(x1)))
      goto capi_fail;
#undef CAPI_ARGLIST_SETITEM
#ifdef PYPY_VERSION
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist_list);
#else
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
#endif
  CFUNCSMESS("cb:Call-back calling Python function func.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
#ifdef PYPY_VERSION
  capi_return = PyObject_CallObject(cb_func_in_brac__user__routines_capi,(PyObject *)capi_arglist_list);
  Py_DECREF(capi_arglist_list);
  capi_arglist_list = NULL;
#else
  capi_return = PyObject_CallObject(cb_func_in_brac__user__routines_capi,(PyObject *)capi_arglist);
#endif
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
  CFUNCSMESSPY("cb:capi_return=",capi_return);
  if (capi_return == NULL) {
    fprintf(stderr,"capi_return is NULL\n");
    goto capi_fail;
  }
  if (capi_return == Py_None) {
    Py_DECREF(capi_return);
    capi_return = Py_BuildValue("()");
  }
  else if (!PyTuple_Check(capi_return)) {
    capi_return = Py_BuildValue("(N)",capi_return);
  }
  capi_j = PyTuple_Size(capi_return);
  capi_i = 0;
/*frompyobj*/
  if (capi_j>capi_i)
    GETSCALARFROMPYTUPLE(capi_return,capi_i++,&return_value,double,"double_from_pyobj failed in converting return_value of call-back function cb_func_in_brac__user__routines to C double\n");
  CFUNCSMESS("cb:cb_func_in_brac__user__routines:successful\n");
  Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
  goto capi_return_pt;
capi_fail:
  fprintf(stderr,"Call-back cb_func_in_brac__user__routines failed.\n");
  Py_XDECREF(capi_return);
  Py_XDECREF(capi_arglist_list);
  if (capi_longjmp_ok)
    longjmp(cb_func_in_brac__user__routines_jmpbuf,-1);
capi_return_pt:
  ;
  return return_value;
}
/******************* end of cb_func_in_brac__user__routines *******************/


/********************** cb_func_in_brent__user__routines **********************/
PyObject *cb_func_in_brent__user__routines_capi = NULL;/*was Py_None*/
PyTupleObject *cb_func_in_brent__user__routines_args_capi = NULL;
int cb_func_in_brent__user__routines_nofargs = 0;
jmp_buf cb_func_in_brent__user__routines_jmpbuf;
/*typedef double(*cb_func_in_brent__user__routines_typedef)(double *);*/
static double cb_func_in_brent__user__routines (double *a_cb_capi) {
  PyTupleObject *capi_arglist = cb_func_in_brent__user__routines_args_capi;
  PyObject *capi_return = NULL;
  PyObject *capi_tmp = NULL;
  PyObject *capi_arglist_list = NULL;
  int capi_j,capi_i = 0;
  int capi_longjmp_ok = 1;
/*decl*/
  double return_value;
  double a=(*a_cb_capi);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
  CFUNCSMESS("cb:Call-back function cb_func_in_brent__user__routines (maxnofargs=1(-0))\n");
  CFUNCSMESSPY("cb:cb_func_in_brent__user__routines_capi=",cb_func_in_brent__user__routines_capi);
  if (cb_func_in_brent__user__routines_capi==NULL) {
    capi_longjmp_ok = 0;
    cb_func_in_brent__user__routines_capi = PyObject_GetAttrString(atomic_program_module,"func");
  }
  if (cb_func_in_brent__user__routines_capi==NULL) {
    PyErr_SetString(atomic_program_error,"cb: Callback func not defined (as an argument or module atomic_program attribute).\n");
    goto capi_fail;
  }
  if (F2PyCapsule_Check(cb_func_in_brent__user__routines_capi)) {
  cb_func_in_brent__user__routines_typedef cb_func_in_brent__user__routines_cptr;
  cb_func_in_brent__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb_func_in_brent__user__routines_capi);
  return_value=(*cb_func_in_brent__user__routines_cptr)(a_cb_capi);
    return return_value;
  }
  if (capi_arglist==NULL) {
    capi_longjmp_ok = 0;
    capi_tmp = PyObject_GetAttrString(atomic_program_module,"func_extra_args");
    if (capi_tmp) {
      capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
      if (capi_arglist==NULL) {
        PyErr_SetString(atomic_program_error,"Failed to convert atomic_program.func_extra_args to tuple.\n");
        goto capi_fail;
      }
    } else {
      PyErr_Clear();
      capi_arglist = (PyTupleObject *)Py_BuildValue("()");
    }
  }
  if (capi_arglist == NULL) {
    PyErr_SetString(atomic_program_error,"Callback func argument list is not set.\n");
    goto capi_fail;
  }
/*setdims*/
#ifdef PYPY_VERSION
#define CAPI_ARGLIST_SETITEM(idx, value) PyList_SetItem((PyObject *)capi_arglist_list, idx, value)
  capi_arglist_list = PySequence_List(capi_arglist);
  if (capi_arglist_list == NULL) goto capi_fail;
#else
#define CAPI_ARGLIST_SETITEM(idx, value) PyTuple_SetItem((PyObject *)capi_arglist, idx, value)
#endif
/*pyobjfrom*/
  if (cb_func_in_brent__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(a)))
      goto capi_fail;
#undef CAPI_ARGLIST_SETITEM
#ifdef PYPY_VERSION
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist_list);
#else
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
#endif
  CFUNCSMESS("cb:Call-back calling Python function func.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
#ifdef PYPY_VERSION
  capi_return = PyObject_CallObject(cb_func_in_brent__user__routines_capi,(PyObject *)capi_arglist_list);
  Py_DECREF(capi_arglist_list);
  capi_arglist_list = NULL;
#else
  capi_return = PyObject_CallObject(cb_func_in_brent__user__routines_capi,(PyObject *)capi_arglist);
#endif
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
  CFUNCSMESSPY("cb:capi_return=",capi_return);
  if (capi_return == NULL) {
    fprintf(stderr,"capi_return is NULL\n");
    goto capi_fail;
  }
  if (capi_return == Py_None) {
    Py_DECREF(capi_return);
    capi_return = Py_BuildValue("()");
  }
  else if (!PyTuple_Check(capi_return)) {
    capi_return = Py_BuildValue("(N)",capi_return);
  }
  capi_j = PyTuple_Size(capi_return);
  capi_i = 0;
/*frompyobj*/
  if (capi_j>capi_i)
    GETSCALARFROMPYTUPLE(capi_return,capi_i++,&return_value,double,"double_from_pyobj failed in converting return_value of call-back function cb_func_in_brent__user__routines to C double\n");
  CFUNCSMESS("cb:cb_func_in_brent__user__routines:successful\n");
  Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
  goto capi_return_pt;
capi_fail:
  fprintf(stderr,"Call-back cb_func_in_brent__user__routines failed.\n");
  Py_XDECREF(capi_return);
  Py_XDECREF(capi_arglist_list);
  if (capi_longjmp_ok)
    longjmp(cb_func_in_brent__user__routines_jmpbuf,-1);
capi_return_pt:
  ;
  return return_value;
}
/****************** end of cb_func_in_brent__user__routines ******************/


/******************** cb_derivs_in_odeint__user__routines ********************/
PyObject *cb_derivs_in_odeint__user__routines_capi = NULL;/*was Py_None*/
PyTupleObject *cb_derivs_in_odeint__user__routines_args_capi = NULL;
int cb_derivs_in_odeint__user__routines_nofargs = 0;
jmp_buf cb_derivs_in_odeint__user__routines_jmpbuf;
/*typedef void(*cb_derivs_in_odeint__user__routines_typedef)(double *,double *,double *);*/
static void cb_derivs_in_odeint__user__routines (double *x_cb_capi,double *y,double *dydx) {
  PyTupleObject *capi_arglist = cb_derivs_in_odeint__user__routines_args_capi;
  PyObject *capi_return = NULL;
  PyObject *capi_tmp = NULL;
  PyObject *capi_arglist_list = NULL;
  int capi_j,capi_i = 0;
  int capi_longjmp_ok = 1;
/*decl*/
  double x=(*x_cb_capi);
  npy_intp y_Dims[1] = {-1};
  npy_intp dydx_Dims[1] = {-1};
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
  CFUNCSMESS("cb:Call-back function cb_derivs_in_odeint__user__routines (maxnofargs=3(-0))\n");
  CFUNCSMESSPY("cb:cb_derivs_in_odeint__user__routines_capi=",cb_derivs_in_odeint__user__routines_capi);
  if (cb_derivs_in_odeint__user__routines_capi==NULL) {
    capi_longjmp_ok = 0;
    cb_derivs_in_odeint__user__routines_capi = PyObject_GetAttrString(atomic_program_module,"derivs");
  }
  if (cb_derivs_in_odeint__user__routines_capi==NULL) {
    PyErr_SetString(atomic_program_error,"cb: Callback derivs not defined (as an argument or module atomic_program attribute).\n");
    goto capi_fail;
  }
  if (F2PyCapsule_Check(cb_derivs_in_odeint__user__routines_capi)) {
  cb_derivs_in_odeint__user__routines_typedef cb_derivs_in_odeint__user__routines_cptr;
  cb_derivs_in_odeint__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb_derivs_in_odeint__user__routines_capi);
  (*cb_derivs_in_odeint__user__routines_cptr)(x_cb_capi,y,dydx);
  return;
  }
  if (capi_arglist==NULL) {
    capi_longjmp_ok = 0;
    capi_tmp = PyObject_GetAttrString(atomic_program_module,"derivs_extra_args");
    if (capi_tmp) {
      capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
      if (capi_arglist==NULL) {
        PyErr_SetString(atomic_program_error,"Failed to convert atomic_program.derivs_extra_args to tuple.\n");
        goto capi_fail;
      }
    } else {
      PyErr_Clear();
      capi_arglist = (PyTupleObject *)Py_BuildValue("()");
    }
  }
  if (capi_arglist == NULL) {
    PyErr_SetString(atomic_program_error,"Callback derivs argument list is not set.\n");
    goto capi_fail;
  }
/*setdims*/
  y_Dims[0]=10;
  dydx_Dims[0]=10;
#ifdef PYPY_VERSION
#define CAPI_ARGLIST_SETITEM(idx, value) PyList_SetItem((PyObject *)capi_arglist_list, idx, value)
  capi_arglist_list = PySequence_List(capi_arglist);
  if (capi_arglist_list == NULL) goto capi_fail;
#else
#define CAPI_ARGLIST_SETITEM(idx, value) PyTuple_SetItem((PyObject *)capi_arglist, idx, value)
#endif
/*pyobjfrom*/
  if (cb_derivs_in_odeint__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(x)))
      goto capi_fail;
  if (cb_derivs_in_odeint__user__routines_nofargs>capi_i) {
    int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
    /*XXX: Hmm, what will destroy this array??? */
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,y_Dims,NPY_DOUBLE,NULL,(char*)y,itemsize_,NPY_ARRAY_FARRAY,NULL);


    if (tmp_arr==NULL)
      goto capi_fail;
    if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
  if (cb_derivs_in_odeint__user__routines_nofargs>capi_i) {
    int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
    /*XXX: Hmm, what will destroy this array??? */
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,dydx_Dims,NPY_DOUBLE,NULL,(char*)dydx,itemsize_,NPY_ARRAY_FARRAY,NULL);


    if (tmp_arr==NULL)
      goto capi_fail;
    if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
#undef CAPI_ARGLIST_SETITEM
#ifdef PYPY_VERSION
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist_list);
#else
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
#endif
  CFUNCSMESS("cb:Call-back calling Python function derivs.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
#ifdef PYPY_VERSION
  capi_return = PyObject_CallObject(cb_derivs_in_odeint__user__routines_capi,(PyObject *)capi_arglist_list);
  Py_DECREF(capi_arglist_list);
  capi_arglist_list = NULL;
#else
  capi_return = PyObject_CallObject(cb_derivs_in_odeint__user__routines_capi,(PyObject *)capi_arglist);
#endif
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
  CFUNCSMESSPY("cb:capi_return=",capi_return);
  if (capi_return == NULL) {
    fprintf(stderr,"capi_return is NULL\n");
    goto capi_fail;
  }
  if (capi_return == Py_None) {
    Py_DECREF(capi_return);
    capi_return = Py_BuildValue("()");
  }
  else if (!PyTuple_Check(capi_return)) {
    capi_return = Py_BuildValue("(N)",capi_return);
  }
  capi_j = PyTuple_Size(capi_return);
  capi_i = 0;
/*frompyobj*/
  CFUNCSMESS("cb:cb_derivs_in_odeint__user__routines:successful\n");
  Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
  goto capi_return_pt;
capi_fail:
  fprintf(stderr,"Call-back cb_derivs_in_odeint__user__routines failed.\n");
  Py_XDECREF(capi_return);
  Py_XDECREF(capi_arglist_list);
  if (capi_longjmp_ok)
    longjmp(cb_derivs_in_odeint__user__routines_jmpbuf,-1);
capi_return_pt:
  ;
return;
}
/***************** end of cb_derivs_in_odeint__user__routines *****************/


/********************* cb_rkqc_in_odeint__user__routines *********************/
PyObject *cb_rkqc_in_odeint__user__routines_capi = NULL;/*was Py_None*/
PyTupleObject *cb_rkqc_in_odeint__user__routines_args_capi = NULL;
int cb_rkqc_in_odeint__user__routines_nofargs = 0;
jmp_buf cb_rkqc_in_odeint__user__routines_jmpbuf;
/*typedef void(*cb_rkqc_in_odeint__user__routines_typedef)(double *,double *,int *,double *,double *,double *,double *,double *,double *);*/
static void cb_rkqc_in_odeint__user__routines (double *y,double *dydx,int *nvar_cb_capi,double *x_cb_capi,double *h_cb_capi,double *eps_cb_capi,double *yscal,double *hdid_cb_capi,double *hnext_cb_capi) {
  PyTupleObject *capi_arglist = cb_rkqc_in_odeint__user__routines_args_capi;
  PyObject *capi_return = NULL;
  PyObject *capi_tmp = NULL;
  PyObject *capi_arglist_list = NULL;
  int capi_j,capi_i = 0;
  int capi_longjmp_ok = 1;
/*decl*/
  int nvar=(*nvar_cb_capi);
  double x=(*x_cb_capi);
  double h=(*h_cb_capi);
  double eps=(*eps_cb_capi);
  double hdid=(*hdid_cb_capi);
  double hnext=(*hnext_cb_capi);
  npy_intp y_Dims[1] = {-1};
  npy_intp dydx_Dims[1] = {-1};
  npy_intp yscal_Dims[1] = {-1};
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
  CFUNCSMESS("cb:Call-back function cb_rkqc_in_odeint__user__routines (maxnofargs=10(-0))\n");
  CFUNCSMESSPY("cb:cb_rkqc_in_odeint__user__routines_capi=",cb_rkqc_in_odeint__user__routines_capi);
  if (cb_rkqc_in_odeint__user__routines_capi==NULL) {
    capi_longjmp_ok = 0;
    cb_rkqc_in_odeint__user__routines_capi = PyObject_GetAttrString(atomic_program_module,"rkqc");
  }
  if (cb_rkqc_in_odeint__user__routines_capi==NULL) {
    PyErr_SetString(atomic_program_error,"cb: Callback rkqc not defined (as an argument or module atomic_program attribute).\n");
    goto capi_fail;
  }
  if (F2PyCapsule_Check(cb_rkqc_in_odeint__user__routines_capi)) {
  cb_rkqc_in_odeint__user__routines_typedef cb_rkqc_in_odeint__user__routines_cptr;
  cb_rkqc_in_odeint__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb_rkqc_in_odeint__user__routines_capi);
  (*cb_rkqc_in_odeint__user__routines_cptr)(y,dydx,nvar_cb_capi,x_cb_capi,h_cb_capi,eps_cb_capi,yscal,hdid_cb_capi,hnext_cb_capi);
  return;
  }
  if (capi_arglist==NULL) {
    capi_longjmp_ok = 0;
    capi_tmp = PyObject_GetAttrString(atomic_program_module,"rkqc_extra_args");
    if (capi_tmp) {
      capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
      if (capi_arglist==NULL) {
        PyErr_SetString(atomic_program_error,"Failed to convert atomic_program.rkqc_extra_args to tuple.\n");
        goto capi_fail;
      }
    } else {
      PyErr_Clear();
      capi_arglist = (PyTupleObject *)Py_BuildValue("()");
    }
  }
  if (capi_arglist == NULL) {
    PyErr_SetString(atomic_program_error,"Callback rkqc argument list is not set.\n");
    goto capi_fail;
  }
/*setdims*/
  y_Dims[0]=10;
  dydx_Dims[0]=10;
  yscal_Dims[0]=10;
#ifdef PYPY_VERSION
#define CAPI_ARGLIST_SETITEM(idx, value) PyList_SetItem((PyObject *)capi_arglist_list, idx, value)
  capi_arglist_list = PySequence_List(capi_arglist);
  if (capi_arglist_list == NULL) goto capi_fail;
#else
#define CAPI_ARGLIST_SETITEM(idx, value) PyTuple_SetItem((PyObject *)capi_arglist, idx, value)
#endif
/*pyobjfrom*/
  if (cb_rkqc_in_odeint__user__routines_nofargs>capi_i) {
    int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
    /*XXX: Hmm, what will destroy this array??? */
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,y_Dims,NPY_DOUBLE,NULL,(char*)y,itemsize_,NPY_ARRAY_FARRAY,NULL);


    if (tmp_arr==NULL)
      goto capi_fail;
    if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
  if (cb_rkqc_in_odeint__user__routines_nofargs>capi_i) {
    int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
    /*XXX: Hmm, what will destroy this array??? */
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,dydx_Dims,NPY_DOUBLE,NULL,(char*)dydx,itemsize_,NPY_ARRAY_FARRAY,NULL);


    if (tmp_arr==NULL)
      goto capi_fail;
    if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
  if (cb_rkqc_in_odeint__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_int1(nvar)))
      goto capi_fail;
  if (cb_rkqc_in_odeint__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(x)))
      goto capi_fail;
  if (cb_rkqc_in_odeint__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(h)))
      goto capi_fail;
  if (cb_rkqc_in_odeint__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(eps)))
      goto capi_fail;
  if (cb_rkqc_in_odeint__user__routines_nofargs>capi_i) {
    int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
    /*XXX: Hmm, what will destroy this array??? */
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,yscal_Dims,NPY_DOUBLE,NULL,(char*)yscal,itemsize_,NPY_ARRAY_FARRAY,NULL);


    if (tmp_arr==NULL)
      goto capi_fail;
    if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
  if (cb_rkqc_in_odeint__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(hdid)))
      goto capi_fail;
  if (cb_rkqc_in_odeint__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(hnext)))
      goto capi_fail;
#undef CAPI_ARGLIST_SETITEM
#ifdef PYPY_VERSION
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist_list);
#else
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
#endif
  CFUNCSMESS("cb:Call-back calling Python function rkqc.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
#ifdef PYPY_VERSION
  capi_return = PyObject_CallObject(cb_rkqc_in_odeint__user__routines_capi,(PyObject *)capi_arglist_list);
  Py_DECREF(capi_arglist_list);
  capi_arglist_list = NULL;
#else
  capi_return = PyObject_CallObject(cb_rkqc_in_odeint__user__routines_capi,(PyObject *)capi_arglist);
#endif
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
  CFUNCSMESSPY("cb:capi_return=",capi_return);
  if (capi_return == NULL) {
    fprintf(stderr,"capi_return is NULL\n");
    goto capi_fail;
  }
  if (capi_return == Py_None) {
    Py_DECREF(capi_return);
    capi_return = Py_BuildValue("()");
  }
  else if (!PyTuple_Check(capi_return)) {
    capi_return = Py_BuildValue("(N)",capi_return);
  }
  capi_j = PyTuple_Size(capi_return);
  capi_i = 0;
/*frompyobj*/
  CFUNCSMESS("cb:cb_rkqc_in_odeint__user__routines:successful\n");
  Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
  goto capi_return_pt;
capi_fail:
  fprintf(stderr,"Call-back cb_rkqc_in_odeint__user__routines failed.\n");
  Py_XDECREF(capi_return);
  Py_XDECREF(capi_arglist_list);
  if (capi_longjmp_ok)
    longjmp(cb_rkqc_in_odeint__user__routines_jmpbuf,-1);
capi_return_pt:
  ;
return;
}
/****************** end of cb_rkqc_in_odeint__user__routines ******************/


/********************* cb_derivs_in_rkqc__user__routines *********************/
PyObject *cb_derivs_in_rkqc__user__routines_capi = NULL;/*was Py_None*/
PyTupleObject *cb_derivs_in_rkqc__user__routines_args_capi = NULL;
int cb_derivs_in_rkqc__user__routines_nofargs = 0;
jmp_buf cb_derivs_in_rkqc__user__routines_jmpbuf;
/*typedef void(*cb_derivs_in_rkqc__user__routines_typedef)(double *,double *,double *);*/
static void cb_derivs_in_rkqc__user__routines (double *x_cb_capi,double *ytemp,double *dydx) {
  PyTupleObject *capi_arglist = cb_derivs_in_rkqc__user__routines_args_capi;
  PyObject *capi_return = NULL;
  PyObject *capi_tmp = NULL;
  PyObject *capi_arglist_list = NULL;
  int capi_j,capi_i = 0;
  int capi_longjmp_ok = 1;
/*decl*/
  double x=(*x_cb_capi);
  npy_intp ytemp_Dims[1] = {-1};
  npy_intp dydx_Dims[1] = {-1};
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
  CFUNCSMESS("cb:Call-back function cb_derivs_in_rkqc__user__routines (maxnofargs=3(-0))\n");
  CFUNCSMESSPY("cb:cb_derivs_in_rkqc__user__routines_capi=",cb_derivs_in_rkqc__user__routines_capi);
  if (cb_derivs_in_rkqc__user__routines_capi==NULL) {
    capi_longjmp_ok = 0;
    cb_derivs_in_rkqc__user__routines_capi = PyObject_GetAttrString(atomic_program_module,"derivs");
  }
  if (cb_derivs_in_rkqc__user__routines_capi==NULL) {
    PyErr_SetString(atomic_program_error,"cb: Callback derivs not defined (as an argument or module atomic_program attribute).\n");
    goto capi_fail;
  }
  if (F2PyCapsule_Check(cb_derivs_in_rkqc__user__routines_capi)) {
  cb_derivs_in_rkqc__user__routines_typedef cb_derivs_in_rkqc__user__routines_cptr;
  cb_derivs_in_rkqc__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb_derivs_in_rkqc__user__routines_capi);
  (*cb_derivs_in_rkqc__user__routines_cptr)(x_cb_capi,ytemp,dydx);
  return;
  }
  if (capi_arglist==NULL) {
    capi_longjmp_ok = 0;
    capi_tmp = PyObject_GetAttrString(atomic_program_module,"derivs_extra_args");
    if (capi_tmp) {
      capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
      if (capi_arglist==NULL) {
        PyErr_SetString(atomic_program_error,"Failed to convert atomic_program.derivs_extra_args to tuple.\n");
        goto capi_fail;
      }
    } else {
      PyErr_Clear();
      capi_arglist = (PyTupleObject *)Py_BuildValue("()");
    }
  }
  if (capi_arglist == NULL) {
    PyErr_SetString(atomic_program_error,"Callback derivs argument list is not set.\n");
    goto capi_fail;
  }
/*setdims*/
  ytemp_Dims[0]=10;
  dydx_Dims[0]=10;
#ifdef PYPY_VERSION
#define CAPI_ARGLIST_SETITEM(idx, value) PyList_SetItem((PyObject *)capi_arglist_list, idx, value)
  capi_arglist_list = PySequence_List(capi_arglist);
  if (capi_arglist_list == NULL) goto capi_fail;
#else
#define CAPI_ARGLIST_SETITEM(idx, value) PyTuple_SetItem((PyObject *)capi_arglist, idx, value)
#endif
/*pyobjfrom*/
  if (cb_derivs_in_rkqc__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(x)))
      goto capi_fail;
  if (cb_derivs_in_rkqc__user__routines_nofargs>capi_i) {
    int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
    /*XXX: Hmm, what will destroy this array??? */
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,ytemp_Dims,NPY_DOUBLE,NULL,(char*)ytemp,itemsize_,NPY_ARRAY_FARRAY,NULL);


    if (tmp_arr==NULL)
      goto capi_fail;
    if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
  if (cb_derivs_in_rkqc__user__routines_nofargs>capi_i) {
    int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
    /*XXX: Hmm, what will destroy this array??? */
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,dydx_Dims,NPY_DOUBLE,NULL,(char*)dydx,itemsize_,NPY_ARRAY_FARRAY,NULL);


    if (tmp_arr==NULL)
      goto capi_fail;
    if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
#undef CAPI_ARGLIST_SETITEM
#ifdef PYPY_VERSION
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist_list);
#else
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
#endif
  CFUNCSMESS("cb:Call-back calling Python function derivs.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
#ifdef PYPY_VERSION
  capi_return = PyObject_CallObject(cb_derivs_in_rkqc__user__routines_capi,(PyObject *)capi_arglist_list);
  Py_DECREF(capi_arglist_list);
  capi_arglist_list = NULL;
#else
  capi_return = PyObject_CallObject(cb_derivs_in_rkqc__user__routines_capi,(PyObject *)capi_arglist);
#endif
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
  CFUNCSMESSPY("cb:capi_return=",capi_return);
  if (capi_return == NULL) {
    fprintf(stderr,"capi_return is NULL\n");
    goto capi_fail;
  }
  if (capi_return == Py_None) {
    Py_DECREF(capi_return);
    capi_return = Py_BuildValue("()");
  }
  else if (!PyTuple_Check(capi_return)) {
    capi_return = Py_BuildValue("(N)",capi_return);
  }
  capi_j = PyTuple_Size(capi_return);
  capi_i = 0;
/*frompyobj*/
  CFUNCSMESS("cb:cb_derivs_in_rkqc__user__routines:successful\n");
  Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
  goto capi_return_pt;
capi_fail:
  fprintf(stderr,"Call-back cb_derivs_in_rkqc__user__routines failed.\n");
  Py_XDECREF(capi_return);
  Py_XDECREF(capi_arglist_list);
  if (capi_longjmp_ok)
    longjmp(cb_derivs_in_rkqc__user__routines_jmpbuf,-1);
capi_return_pt:
  ;
return;
}
/****************** end of cb_derivs_in_rkqc__user__routines ******************/


/********************** cb_derivs_in_rk4__user__routines **********************/
PyObject *cb_derivs_in_rk4__user__routines_capi = NULL;/*was Py_None*/
PyTupleObject *cb_derivs_in_rk4__user__routines_args_capi = NULL;
int cb_derivs_in_rk4__user__routines_nofargs = 0;
jmp_buf cb_derivs_in_rk4__user__routines_jmpbuf;
/*typedef void(*cb_derivs_in_rk4__user__routines_typedef)(double *,double *,double *);*/
static void cb_derivs_in_rk4__user__routines (double *xh_cb_capi,double *yt,double *dyt) {
  PyTupleObject *capi_arglist = cb_derivs_in_rk4__user__routines_args_capi;
  PyObject *capi_return = NULL;
  PyObject *capi_tmp = NULL;
  PyObject *capi_arglist_list = NULL;
  int capi_j,capi_i = 0;
  int capi_longjmp_ok = 1;
/*decl*/
  double xh=(*xh_cb_capi);
  npy_intp yt_Dims[1] = {-1};
  npy_intp dyt_Dims[1] = {-1};
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_clock();
#endif
  CFUNCSMESS("cb:Call-back function cb_derivs_in_rk4__user__routines (maxnofargs=3(-0))\n");
  CFUNCSMESSPY("cb:cb_derivs_in_rk4__user__routines_capi=",cb_derivs_in_rk4__user__routines_capi);
  if (cb_derivs_in_rk4__user__routines_capi==NULL) {
    capi_longjmp_ok = 0;
    cb_derivs_in_rk4__user__routines_capi = PyObject_GetAttrString(atomic_program_module,"derivs");
  }
  if (cb_derivs_in_rk4__user__routines_capi==NULL) {
    PyErr_SetString(atomic_program_error,"cb: Callback derivs not defined (as an argument or module atomic_program attribute).\n");
    goto capi_fail;
  }
  if (F2PyCapsule_Check(cb_derivs_in_rk4__user__routines_capi)) {
  cb_derivs_in_rk4__user__routines_typedef cb_derivs_in_rk4__user__routines_cptr;
  cb_derivs_in_rk4__user__routines_cptr = F2PyCapsule_AsVoidPtr(cb_derivs_in_rk4__user__routines_capi);
  (*cb_derivs_in_rk4__user__routines_cptr)(xh_cb_capi,yt,dyt);
  return;
  }
  if (capi_arglist==NULL) {
    capi_longjmp_ok = 0;
    capi_tmp = PyObject_GetAttrString(atomic_program_module,"derivs_extra_args");
    if (capi_tmp) {
      capi_arglist = (PyTupleObject *)PySequence_Tuple(capi_tmp);
      if (capi_arglist==NULL) {
        PyErr_SetString(atomic_program_error,"Failed to convert atomic_program.derivs_extra_args to tuple.\n");
        goto capi_fail;
      }
    } else {
      PyErr_Clear();
      capi_arglist = (PyTupleObject *)Py_BuildValue("()");
    }
  }
  if (capi_arglist == NULL) {
    PyErr_SetString(atomic_program_error,"Callback derivs argument list is not set.\n");
    goto capi_fail;
  }
/*setdims*/
  yt_Dims[0]=10;
  dyt_Dims[0]=10;
#ifdef PYPY_VERSION
#define CAPI_ARGLIST_SETITEM(idx, value) PyList_SetItem((PyObject *)capi_arglist_list, idx, value)
  capi_arglist_list = PySequence_List(capi_arglist);
  if (capi_arglist_list == NULL) goto capi_fail;
#else
#define CAPI_ARGLIST_SETITEM(idx, value) PyTuple_SetItem((PyObject *)capi_arglist, idx, value)
#endif
/*pyobjfrom*/
  if (cb_derivs_in_rk4__user__routines_nofargs>capi_i)
    if (CAPI_ARGLIST_SETITEM(capi_i++,pyobj_from_double1(xh)))
      goto capi_fail;
  if (cb_derivs_in_rk4__user__routines_nofargs>capi_i) {
    int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
    /*XXX: Hmm, what will destroy this array??? */
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,yt_Dims,NPY_DOUBLE,NULL,(char*)yt,itemsize_,NPY_ARRAY_FARRAY,NULL);


    if (tmp_arr==NULL)
      goto capi_fail;
    if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
  if (cb_derivs_in_rk4__user__routines_nofargs>capi_i) {
    int itemsize_ = NPY_DOUBLE == NPY_STRING ? 1 : 0;
    /*XXX: Hmm, what will destroy this array??? */
    PyArrayObject *tmp_arr = (PyArrayObject *)PyArray_New(&PyArray_Type,1,dyt_Dims,NPY_DOUBLE,NULL,(char*)dyt,itemsize_,NPY_ARRAY_FARRAY,NULL);


    if (tmp_arr==NULL)
      goto capi_fail;
    if (CAPI_ARGLIST_SETITEM(capi_i++,(PyObject *)tmp_arr))
      goto capi_fail;
}
#undef CAPI_ARGLIST_SETITEM
#ifdef PYPY_VERSION
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist_list);
#else
  CFUNCSMESSPY("cb:capi_arglist=",capi_arglist);
#endif
  CFUNCSMESS("cb:Call-back calling Python function derivs.\n");
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_start_call_clock();
#endif
#ifdef PYPY_VERSION
  capi_return = PyObject_CallObject(cb_derivs_in_rk4__user__routines_capi,(PyObject *)capi_arglist_list);
  Py_DECREF(capi_arglist_list);
  capi_arglist_list = NULL;
#else
  capi_return = PyObject_CallObject(cb_derivs_in_rk4__user__routines_capi,(PyObject *)capi_arglist);
#endif
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_call_clock();
#endif
  CFUNCSMESSPY("cb:capi_return=",capi_return);
  if (capi_return == NULL) {
    fprintf(stderr,"capi_return is NULL\n");
    goto capi_fail;
  }
  if (capi_return == Py_None) {
    Py_DECREF(capi_return);
    capi_return = Py_BuildValue("()");
  }
  else if (!PyTuple_Check(capi_return)) {
    capi_return = Py_BuildValue("(N)",capi_return);
  }
  capi_j = PyTuple_Size(capi_return);
  capi_i = 0;
/*frompyobj*/
  CFUNCSMESS("cb:cb_derivs_in_rk4__user__routines:successful\n");
  Py_DECREF(capi_return);
#ifdef F2PY_REPORT_ATEXIT
f2py_cb_stop_clock();
#endif
  goto capi_return_pt;
capi_fail:
  fprintf(stderr,"Call-back cb_derivs_in_rk4__user__routines failed.\n");
  Py_XDECREF(capi_return);
  Py_XDECREF(capi_arglist_list);
  if (capi_longjmp_ok)
    longjmp(cb_derivs_in_rk4__user__routines_jmpbuf,-1);
capi_return_pt:
  ;
return;
}
/****************** end of cb_derivs_in_rk4__user__routines ******************/


/*********************** See f2py2e/rules.py: buildapi ***********************/

/************************************ run ************************************/
static char doc_f2py_rout_atomic_program_run[] = "\
run()\n\nWrapper for ``run``.\
\n";
/* extern void F_FUNC(run,RUN)(void); */
static PyObject *f2py_rout_atomic_program_run(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:atomic_program.run",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of run *********************************/

/*********************************** nucl_z ***********************************/
static char doc_f2py_rout_atomic_program_nucl_z[] = "\
nucl_z = nucl_z(name)\n\nWrapper for ``nucl_z``.\
\n\nParameters\n----------\n"
"name : input string(len=2)\n"
"\nReturns\n-------\n"
"nucl_z : float";
/* extern void F_WRAPPEDFUNC_US(nucl_z,NUCL_Z)(double*,string,size_t); */
static PyObject *f2py_rout_atomic_program_nucl_z(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double nucl_z = 0;
  string name = NULL;
  int slen(name);
  PyObject *name_capi = Py_None;
  static char *capi_kwlist[] = {"name",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.nucl_z",\
    capi_kwlist,&name_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable name */
  slen(name) = 2;
  f2py_success = string_from_pyobj(&name,&slen(name),"",name_capi,"string_from_pyobj failed in converting 1st argument `name' of atomic_program.nucl_z to C string");
  if (f2py_success) {
  /* Processing variable nucl_z */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&nucl_z,name,slen(name));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",nucl_z);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable nucl_z */
    STRINGFREE(name);
  }  /*if (f2py_success) of name*/
  /* End of cleaning variable name */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of nucl_z *******************************/

/*********************************** difnrl ***********************************/
static char doc_f2py_rout_atomic_program_difnrl[] = "\
difnrl(iter,iorb,v,ar,br,n,l,spin,eigv,iflag)\n\nWrapper for ``difnrl``.\
\n\nParameters\n----------\n"
"iter : input int\n"
"iorb : input int\n"
"v : input rank-1 array('d') with bounds (*)\n"
"ar : input rank-1 array('d') with bounds (*)\n"
"br : input rank-1 array('d') with bounds (*)\n"
"n : input int\n"
"l : input int\n"
"spin : input float\n"
"eigv : input float\n"
"iflag : input int";
/* extern void F_FUNC(difnrl,DIFNRL)(int*,int*,double*,double*,double*,int*,int*,double*,double*,int*); */
static PyObject *f2py_rout_atomic_program_difnrl(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,int*,int*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int iter = 0;
  PyObject *iter_capi = Py_None;
  int iorb = 0;
  PyObject *iorb_capi = Py_None;
  double *v = NULL;
  npy_intp v_Dims[1] = {-1};
  const int v_Rank = 1;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  PyObject *v_capi = Py_None;
  double *ar = NULL;
  npy_intp ar_Dims[1] = {-1};
  const int ar_Rank = 1;
  PyArrayObject *capi_ar_tmp = NULL;
  int capi_ar_intent = 0;
  PyObject *ar_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  double spin = 0;
  PyObject *spin_capi = Py_None;
  double eigv = 0;
  PyObject *eigv_capi = Py_None;
  int iflag = 0;
  PyObject *iflag_capi = Py_None;
  static char *capi_kwlist[] = {"iter","iorb","v","ar","br","n","l","spin","eigv","iflag",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOO|:atomic_program.difnrl",\
    capi_kwlist,&iter_capi,&iorb_capi,&v_capi,&ar_capi,&br_capi,&n_capi,&l_capi,&spin_capi,&eigv_capi,&iflag_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable iter */
    f2py_success = int_from_pyobj(&iter,iter_capi,"atomic_program.difnrl() 1st argument (iter) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iorb */
    f2py_success = int_from_pyobj(&iorb,iorb_capi,"atomic_program.difnrl() 2nd argument (iorb) can't be converted to int");
  if (f2py_success) {
  /* Processing variable v */
  ;
  capi_v_intent |= F2PY_INTENT_IN;
  capi_v_tmp = array_from_pyobj(NPY_DOUBLE,v_Dims,v_Rank,capi_v_intent,v_capi);
  if (capi_v_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `v' of atomic_program.difnrl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    v = (double *)(PyArray_DATA(capi_v_tmp));

  /* Processing variable ar */
  ;
  capi_ar_intent |= F2PY_INTENT_IN;
  capi_ar_tmp = array_from_pyobj(NPY_DOUBLE,ar_Dims,ar_Rank,capi_ar_intent,ar_capi);
  if (capi_ar_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `ar' of atomic_program.difnrl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ar = (double *)(PyArray_DATA(capi_ar_tmp));

  /* Processing variable br */
  ;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `br' of atomic_program.difnrl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.difnrl() 6th argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"atomic_program.difnrl() 7th argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable spin */
    f2py_success = double_from_pyobj(&spin,spin_capi,"atomic_program.difnrl() 8th argument (spin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable eigv */
    f2py_success = double_from_pyobj(&eigv,eigv_capi,"atomic_program.difnrl() 9th argument (eigv) can't be converted to double");
  if (f2py_success) {
  /* Processing variable iflag */
    f2py_success = int_from_pyobj(&iflag,iflag_capi,"atomic_program.difnrl() 10th argument (iflag) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iter,&iorb,v,ar,br,&n,&l,&spin,&eigv,&iflag);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of iflag*/
  /* End of cleaning variable iflag */
  } /*if (f2py_success) of eigv*/
  /* End of cleaning variable eigv */
  } /*if (f2py_success) of spin*/
  /* End of cleaning variable spin */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_ar_tmp!=ar_capi) {
    Py_XDECREF(capi_ar_tmp); }
  }  /*if (capi_ar_tmp == NULL) ... else of ar*/
  /* End of cleaning variable ar */
  if((PyObject *)capi_v_tmp!=v_capi) {
    Py_XDECREF(capi_v_tmp); }
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  } /*if (f2py_success) of iorb*/
  /* End of cleaning variable iorb */
  } /*if (f2py_success) of iter*/
  /* End of cleaning variable iter */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of difnrl *******************************/

/*********************************** difrel ***********************************/
static char doc_f2py_rout_atomic_program_difrel[] = "\
difrel(iter,iorb,v,ar,br,n,l,spin,eigv)\n\nWrapper for ``difrel``.\
\n\nParameters\n----------\n"
"iter : input int\n"
"iorb : input int\n"
"v : input rank-1 array('d') with bounds (*)\n"
"ar : input rank-1 array('d') with bounds (*)\n"
"br : input rank-1 array('d') with bounds (*)\n"
"n : input int\n"
"l : input int\n"
"spin : input float\n"
"eigv : input float";
/* extern void F_FUNC(difrel,DIFREL)(int*,int*,double*,double*,double*,int*,int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_difrel(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,int*,int*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int iter = 0;
  PyObject *iter_capi = Py_None;
  int iorb = 0;
  PyObject *iorb_capi = Py_None;
  double *v = NULL;
  npy_intp v_Dims[1] = {-1};
  const int v_Rank = 1;
  PyArrayObject *capi_v_tmp = NULL;
  int capi_v_intent = 0;
  PyObject *v_capi = Py_None;
  double *ar = NULL;
  npy_intp ar_Dims[1] = {-1};
  const int ar_Rank = 1;
  PyArrayObject *capi_ar_tmp = NULL;
  int capi_ar_intent = 0;
  PyObject *ar_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  double spin = 0;
  PyObject *spin_capi = Py_None;
  double eigv = 0;
  PyObject *eigv_capi = Py_None;
  static char *capi_kwlist[] = {"iter","iorb","v","ar","br","n","l","spin","eigv",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOO|:atomic_program.difrel",\
    capi_kwlist,&iter_capi,&iorb_capi,&v_capi,&ar_capi,&br_capi,&n_capi,&l_capi,&spin_capi,&eigv_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable iter */
    f2py_success = int_from_pyobj(&iter,iter_capi,"atomic_program.difrel() 1st argument (iter) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iorb */
    f2py_success = int_from_pyobj(&iorb,iorb_capi,"atomic_program.difrel() 2nd argument (iorb) can't be converted to int");
  if (f2py_success) {
  /* Processing variable v */
  ;
  capi_v_intent |= F2PY_INTENT_IN;
  capi_v_tmp = array_from_pyobj(NPY_DOUBLE,v_Dims,v_Rank,capi_v_intent,v_capi);
  if (capi_v_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `v' of atomic_program.difrel to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    v = (double *)(PyArray_DATA(capi_v_tmp));

  /* Processing variable ar */
  ;
  capi_ar_intent |= F2PY_INTENT_IN;
  capi_ar_tmp = array_from_pyobj(NPY_DOUBLE,ar_Dims,ar_Rank,capi_ar_intent,ar_capi);
  if (capi_ar_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `ar' of atomic_program.difrel to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ar = (double *)(PyArray_DATA(capi_ar_tmp));

  /* Processing variable br */
  ;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `br' of atomic_program.difrel to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.difrel() 6th argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"atomic_program.difrel() 7th argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable spin */
    f2py_success = double_from_pyobj(&spin,spin_capi,"atomic_program.difrel() 8th argument (spin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable eigv */
    f2py_success = double_from_pyobj(&eigv,eigv_capi,"atomic_program.difrel() 9th argument (eigv) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iter,&iorb,v,ar,br,&n,&l,&spin,&eigv);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of eigv*/
  /* End of cleaning variable eigv */
  } /*if (f2py_success) of spin*/
  /* End of cleaning variable spin */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_ar_tmp!=ar_capi) {
    Py_XDECREF(capi_ar_tmp); }
  }  /*if (capi_ar_tmp == NULL) ... else of ar*/
  /* End of cleaning variable ar */
  if((PyObject *)capi_v_tmp!=v_capi) {
    Py_XDECREF(capi_v_tmp); }
  }  /*if (capi_v_tmp == NULL) ... else of v*/
  /* End of cleaning variable v */
  } /*if (f2py_success) of iorb*/
  /* End of cleaning variable iorb */
  } /*if (f2py_success) of iter*/
  /* End of cleaning variable iter */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of difrel *******************************/

/*********************************** dmixp ***********************************/
static char doc_f2py_rout_atomic_program_dmixp[] = "\
dmixp(a,b,beta,icy,id,nmsh,c,d,vn1,vn12,vn2,vn22)\n\nWrapper for ``dmixp``.\
\n\nParameters\n----------\n"
"a : input rank-1 array('d') with bounds (*)\n"
"b : input rank-1 array('d') with bounds (*)\n"
"beta : input float\n"
"icy : input int\n"
"id : input int\n"
"nmsh : input int\n"
"c : input rank-1 array('d') with bounds (*)\n"
"d : input rank-1 array('d') with bounds (*)\n"
"vn1 : input rank-1 array('d') with bounds (*)\n"
"vn12 : input rank-1 array('d') with bounds (*)\n"
"vn2 : input rank-1 array('d') with bounds (*)\n"
"vn22 : input rank-1 array('d') with bounds (*)";
/* extern void F_FUNC(dmixp,DMIXP)(double*,double*,double*,int*,int*,int*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_dmixp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,int*,int*,int*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *a = NULL;
  npy_intp a_Dims[1] = {-1};
  const int a_Rank = 1;
  PyArrayObject *capi_a_tmp = NULL;
  int capi_a_intent = 0;
  PyObject *a_capi = Py_None;
  double *b = NULL;
  npy_intp b_Dims[1] = {-1};
  const int b_Rank = 1;
  PyArrayObject *capi_b_tmp = NULL;
  int capi_b_intent = 0;
  PyObject *b_capi = Py_None;
  double beta = 0;
  PyObject *beta_capi = Py_None;
  int icy = 0;
  PyObject *icy_capi = Py_None;
  int id = 0;
  PyObject *id_capi = Py_None;
  int nmsh = 0;
  PyObject *nmsh_capi = Py_None;
  double *c = NULL;
  npy_intp c_Dims[1] = {-1};
  const int c_Rank = 1;
  PyArrayObject *capi_c_tmp = NULL;
  int capi_c_intent = 0;
  PyObject *c_capi = Py_None;
  double *d = NULL;
  npy_intp d_Dims[1] = {-1};
  const int d_Rank = 1;
  PyArrayObject *capi_d_tmp = NULL;
  int capi_d_intent = 0;
  PyObject *d_capi = Py_None;
  double *vn1 = NULL;
  npy_intp vn1_Dims[1] = {-1};
  const int vn1_Rank = 1;
  PyArrayObject *capi_vn1_tmp = NULL;
  int capi_vn1_intent = 0;
  PyObject *vn1_capi = Py_None;
  double *vn12 = NULL;
  npy_intp vn12_Dims[1] = {-1};
  const int vn12_Rank = 1;
  PyArrayObject *capi_vn12_tmp = NULL;
  int capi_vn12_intent = 0;
  PyObject *vn12_capi = Py_None;
  double *vn2 = NULL;
  npy_intp vn2_Dims[1] = {-1};
  const int vn2_Rank = 1;
  PyArrayObject *capi_vn2_tmp = NULL;
  int capi_vn2_intent = 0;
  PyObject *vn2_capi = Py_None;
  double *vn22 = NULL;
  npy_intp vn22_Dims[1] = {-1};
  const int vn22_Rank = 1;
  PyArrayObject *capi_vn22_tmp = NULL;
  int capi_vn22_intent = 0;
  PyObject *vn22_capi = Py_None;
  static char *capi_kwlist[] = {"a","b","beta","icy","id","nmsh","c","d","vn1","vn12","vn2","vn22",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOO|:atomic_program.dmixp",\
    capi_kwlist,&a_capi,&b_capi,&beta_capi,&icy_capi,&id_capi,&nmsh_capi,&c_capi,&d_capi,&vn1_capi,&vn12_capi,&vn2_capi,&vn22_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable a */
  ;
  capi_a_intent |= F2PY_INTENT_IN;
  capi_a_tmp = array_from_pyobj(NPY_DOUBLE,a_Dims,a_Rank,capi_a_intent,a_capi);
  if (capi_a_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `a' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    a = (double *)(PyArray_DATA(capi_a_tmp));

  /* Processing variable b */
  ;
  capi_b_intent |= F2PY_INTENT_IN;
  capi_b_tmp = array_from_pyobj(NPY_DOUBLE,b_Dims,b_Rank,capi_b_intent,b_capi);
  if (capi_b_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `b' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    b = (double *)(PyArray_DATA(capi_b_tmp));

  /* Processing variable beta */
    f2py_success = double_from_pyobj(&beta,beta_capi,"atomic_program.dmixp() 3rd argument (beta) can't be converted to double");
  if (f2py_success) {
  /* Processing variable icy */
    f2py_success = int_from_pyobj(&icy,icy_capi,"atomic_program.dmixp() 4th argument (icy) can't be converted to int");
  if (f2py_success) {
  /* Processing variable id */
    f2py_success = int_from_pyobj(&id,id_capi,"atomic_program.dmixp() 5th argument (id) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nmsh */
    f2py_success = int_from_pyobj(&nmsh,nmsh_capi,"atomic_program.dmixp() 6th argument (nmsh) can't be converted to int");
  if (f2py_success) {
  /* Processing variable c */
  ;
  capi_c_intent |= F2PY_INTENT_IN;
  capi_c_tmp = array_from_pyobj(NPY_DOUBLE,c_Dims,c_Rank,capi_c_intent,c_capi);
  if (capi_c_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `c' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    c = (double *)(PyArray_DATA(capi_c_tmp));

  /* Processing variable d */
  ;
  capi_d_intent |= F2PY_INTENT_IN;
  capi_d_tmp = array_from_pyobj(NPY_DOUBLE,d_Dims,d_Rank,capi_d_intent,d_capi);
  if (capi_d_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 8th argument `d' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    d = (double *)(PyArray_DATA(capi_d_tmp));

  /* Processing variable vn1 */
  ;
  capi_vn1_intent |= F2PY_INTENT_IN;
  capi_vn1_tmp = array_from_pyobj(NPY_DOUBLE,vn1_Dims,vn1_Rank,capi_vn1_intent,vn1_capi);
  if (capi_vn1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 9th argument `vn1' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vn1 = (double *)(PyArray_DATA(capi_vn1_tmp));

  /* Processing variable vn12 */
  ;
  capi_vn12_intent |= F2PY_INTENT_IN;
  capi_vn12_tmp = array_from_pyobj(NPY_DOUBLE,vn12_Dims,vn12_Rank,capi_vn12_intent,vn12_capi);
  if (capi_vn12_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 10th argument `vn12' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vn12 = (double *)(PyArray_DATA(capi_vn12_tmp));

  /* Processing variable vn2 */
  ;
  capi_vn2_intent |= F2PY_INTENT_IN;
  capi_vn2_tmp = array_from_pyobj(NPY_DOUBLE,vn2_Dims,vn2_Rank,capi_vn2_intent,vn2_capi);
  if (capi_vn2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 11st argument `vn2' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vn2 = (double *)(PyArray_DATA(capi_vn2_tmp));

  /* Processing variable vn22 */
  ;
  capi_vn22_intent |= F2PY_INTENT_IN;
  capi_vn22_tmp = array_from_pyobj(NPY_DOUBLE,vn22_Dims,vn22_Rank,capi_vn22_intent,vn22_capi);
  if (capi_vn22_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 12nd argument `vn22' of atomic_program.dmixp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vn22 = (double *)(PyArray_DATA(capi_vn22_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(a,b,&beta,&icy,&id,&nmsh,c,d,vn1,vn12,vn2,vn22);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_vn22_tmp!=vn22_capi) {
    Py_XDECREF(capi_vn22_tmp); }
  }  /*if (capi_vn22_tmp == NULL) ... else of vn22*/
  /* End of cleaning variable vn22 */
  if((PyObject *)capi_vn2_tmp!=vn2_capi) {
    Py_XDECREF(capi_vn2_tmp); }
  }  /*if (capi_vn2_tmp == NULL) ... else of vn2*/
  /* End of cleaning variable vn2 */
  if((PyObject *)capi_vn12_tmp!=vn12_capi) {
    Py_XDECREF(capi_vn12_tmp); }
  }  /*if (capi_vn12_tmp == NULL) ... else of vn12*/
  /* End of cleaning variable vn12 */
  if((PyObject *)capi_vn1_tmp!=vn1_capi) {
    Py_XDECREF(capi_vn1_tmp); }
  }  /*if (capi_vn1_tmp == NULL) ... else of vn1*/
  /* End of cleaning variable vn1 */
  if((PyObject *)capi_d_tmp!=d_capi) {
    Py_XDECREF(capi_d_tmp); }
  }  /*if (capi_d_tmp == NULL) ... else of d*/
  /* End of cleaning variable d */
  if((PyObject *)capi_c_tmp!=c_capi) {
    Py_XDECREF(capi_c_tmp); }
  }  /*if (capi_c_tmp == NULL) ... else of c*/
  /* End of cleaning variable c */
  } /*if (f2py_success) of nmsh*/
  /* End of cleaning variable nmsh */
  } /*if (f2py_success) of id*/
  /* End of cleaning variable id */
  } /*if (f2py_success) of icy*/
  /* End of cleaning variable icy */
  } /*if (f2py_success) of beta*/
  /* End of cleaning variable beta */
  if((PyObject *)capi_b_tmp!=b_capi) {
    Py_XDECREF(capi_b_tmp); }
  }  /*if (capi_b_tmp == NULL) ... else of b*/
  /* End of cleaning variable b */
  if((PyObject *)capi_a_tmp!=a_capi) {
    Py_XDECREF(capi_a_tmp); }
  }  /*if (capi_a_tmp == NULL) ... else of a*/
  /* End of cleaning variable a */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of dmixp ********************************/

/*********************************** dsolv1 ***********************************/
static char doc_f2py_rout_atomic_program_dsolv1[] = "\
dsolv1(nfirst,nlast,nn)\n\nWrapper for ``dsolv1``.\
\n\nParameters\n----------\n"
"nfirst : input int\n"
"nlast : input int\n"
"nn : input rank-1 array('i') with bounds (*)";
/* extern void F_FUNC(dsolv1,DSOLV1)(int*,int*,int*); */
static PyObject *f2py_rout_atomic_program_dsolv1(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nfirst = 0;
  PyObject *nfirst_capi = Py_None;
  int nlast = 0;
  PyObject *nlast_capi = Py_None;
  int *nn = NULL;
  npy_intp nn_Dims[1] = {-1};
  const int nn_Rank = 1;
  PyArrayObject *capi_nn_tmp = NULL;
  int capi_nn_intent = 0;
  PyObject *nn_capi = Py_None;
  static char *capi_kwlist[] = {"nfirst","nlast","nn",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:atomic_program.dsolv1",\
    capi_kwlist,&nfirst_capi,&nlast_capi,&nn_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nfirst */
    f2py_success = int_from_pyobj(&nfirst,nfirst_capi,"atomic_program.dsolv1() 1st argument (nfirst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nlast */
    f2py_success = int_from_pyobj(&nlast,nlast_capi,"atomic_program.dsolv1() 2nd argument (nlast) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nn */
  ;
  capi_nn_intent |= F2PY_INTENT_IN;
  capi_nn_tmp = array_from_pyobj(NPY_INT,nn_Dims,nn_Rank,capi_nn_intent,nn_capi);
  if (capi_nn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `nn' of atomic_program.dsolv1 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nn = (int *)(PyArray_DATA(capi_nn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nfirst,&nlast,nn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_nn_tmp!=nn_capi) {
    Py_XDECREF(capi_nn_tmp); }
  }  /*if (capi_nn_tmp == NULL) ... else of nn*/
  /* End of cleaning variable nn */
  } /*if (f2py_success) of nlast*/
  /* End of cleaning variable nlast */
  } /*if (f2py_success) of nfirst*/
  /* End of cleaning variable nfirst */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of dsolv1 *******************************/

/*********************************** pseudo ***********************************/
static char doc_f2py_rout_atomic_program_pseudo[] = "\
pseudo(pot_id,headline,ps_generator,[ps_generator_extra_args])\n\nWrapper for ``pseudo``.\
\n\nParameters\n----------\n"
"pot_id : input string(len=40)\n"
"headline : input string(len=79)\n"
"ps_generator : call-back function\n"
"\nOther Parameters\n----------------\n"
"ps_generator_extra_args : input tuple, optional\n    Default: ()\n"
"\nNotes\n-----\nCall-back functions::\n\n"
"  def ps_generator(i,ar,br): return \n\
  Required arguments:\n"
"    i : input int\n"
"    ar : input rank-1 array('d') with bounds (1500)\n"
"    br : input rank-1 array('d') with bounds (1500)";
/* extern void F_FUNC(pseudo,PSEUDO)(string,string,cb_ps_generator_in_pseudo__user__routines_typedef,size_t,size_t); */
static PyObject *f2py_rout_atomic_program_pseudo(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,cb_ps_generator_in_pseudo__user__routines_typedef,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string pot_id = NULL;
  int slen(pot_id);
  PyObject *pot_id_capi = Py_None;
  string headline = NULL;
  int slen(headline);
  PyObject *headline_capi = Py_None;
  PyObject *ps_generator_capi = Py_None;
  PyTupleObject *ps_generator_xa_capi = NULL;
  PyTupleObject *ps_generator_args_capi = NULL;
  int ps_generator_nofargs_capi = 0;
  cb_ps_generator_in_pseudo__user__routines_typedef ps_generator_cptr;
  static char *capi_kwlist[] = {"pot_id","headline","ps_generator","ps_generator_extra_args",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|O!:atomic_program.pseudo",\
    capi_kwlist,&pot_id_capi,&headline_capi,&ps_generator_capi,&PyTuple_Type,&ps_generator_xa_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable pot_id */
  slen(pot_id) = 40;
  f2py_success = string_from_pyobj(&pot_id,&slen(pot_id),"",pot_id_capi,"string_from_pyobj failed in converting 1st argument `pot_id' of atomic_program.pseudo to C string");
  if (f2py_success) {
  /* Processing variable headline */
  slen(headline) = 79;
  f2py_success = string_from_pyobj(&headline,&slen(headline),"",headline_capi,"string_from_pyobj failed in converting 2nd argument `headline' of atomic_program.pseudo to C string");
  if (f2py_success) {
  /* Processing variable ps_generator */
if(F2PyCapsule_Check(ps_generator_capi)) {
  ps_generator_cptr = F2PyCapsule_AsVoidPtr(ps_generator_capi);
} else {
  ps_generator_cptr = cb_ps_generator_in_pseudo__user__routines;
}

  ps_generator_nofargs_capi = cb_ps_generator_in_pseudo__user__routines_nofargs;
  if (create_cb_arglist(ps_generator_capi,ps_generator_xa_capi,3,0,&cb_ps_generator_in_pseudo__user__routines_nofargs,&ps_generator_args_capi,"failed in processing argument list for call-back ps_generator.")) {
    jmp_buf ps_generator_jmpbuf;
    CFUNCSMESS("Saving jmpbuf for `ps_generator`.\n");
    SWAP(ps_generator_capi,cb_ps_generator_in_pseudo__user__routines_capi,PyObject);
    SWAP(ps_generator_args_capi,cb_ps_generator_in_pseudo__user__routines_args_capi,PyTupleObject);
    memcpy(&ps_generator_jmpbuf,&cb_ps_generator_in_pseudo__user__routines_jmpbuf,sizeof(jmp_buf));
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
    if ((setjmp(cb_ps_generator_in_pseudo__user__routines_jmpbuf))) {
      f2py_success = 0;
    } else {
        (*f2py_func)(pot_id,headline,ps_generator_cptr,slen(pot_id),slen(headline));
    }
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    CFUNCSMESS("Restoring jmpbuf for `ps_generator`.\n");
    cb_ps_generator_in_pseudo__user__routines_capi = ps_generator_capi;
    Py_DECREF(cb_ps_generator_in_pseudo__user__routines_args_capi);
    cb_ps_generator_in_pseudo__user__routines_args_capi = ps_generator_args_capi;
    cb_ps_generator_in_pseudo__user__routines_nofargs = ps_generator_nofargs_capi;
    memcpy(&cb_ps_generator_in_pseudo__user__routines_jmpbuf,&ps_generator_jmpbuf,sizeof(jmp_buf));
  }
  /* End of cleaning variable ps_generator */
    STRINGFREE(headline);
  }  /*if (f2py_success) of headline*/
  /* End of cleaning variable headline */
    STRINGFREE(pot_id);
  }  /*if (f2py_success) of pot_id*/
  /* End of cleaning variable pot_id */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pseudo *******************************/

/************************************* wf *************************************/
static char doc_f2py_rout_atomic_program_wf[] = "\
wf(i,ar,br)\n\nWrapper for ``wf``.\
\n\nParameters\n----------\n"
"i : input int\n"
"ar : input rank-1 array('d') with bounds (*)\n"
"br : input rank-1 array('d') with bounds (*)";
/* extern void F_FUNC(wf,WF)(int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_wf(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double *ar = NULL;
  npy_intp ar_Dims[1] = {-1};
  const int ar_Rank = 1;
  PyArrayObject *capi_ar_tmp = NULL;
  int capi_ar_intent = 0;
  PyObject *ar_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
  static char *capi_kwlist[] = {"i","ar","br",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:atomic_program.wf",\
    capi_kwlist,&i_capi,&ar_capi,&br_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.wf() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ar */
  ;
  capi_ar_intent |= F2PY_INTENT_IN;
  capi_ar_tmp = array_from_pyobj(NPY_DOUBLE,ar_Dims,ar_Rank,capi_ar_intent,ar_capi);
  if (capi_ar_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `ar' of atomic_program.wf to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ar = (double *)(PyArray_DATA(capi_ar_tmp));

  /* Processing variable br */
  ;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `br' of atomic_program.wf to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,ar,br);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_ar_tmp!=ar_capi) {
    Py_XDECREF(capi_ar_tmp); }
  }  /*if (capi_ar_tmp == NULL) ... else of ar*/
  /* End of cleaning variable ar */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of wf *********************************/

/************************************ hsc ************************************/
static char doc_f2py_rout_atomic_program_hsc[] = "\
hsc(i,ar,br)\n\nWrapper for ``hsc``.\
\n\nParameters\n----------\n"
"i : input int\n"
"ar : input rank-1 array('d') with bounds (*)\n"
"br : input rank-1 array('d') with bounds (*)";
/* extern void F_FUNC(hsc,HSC)(int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_hsc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double *ar = NULL;
  npy_intp ar_Dims[1] = {-1};
  const int ar_Rank = 1;
  PyArrayObject *capi_ar_tmp = NULL;
  int capi_ar_intent = 0;
  PyObject *ar_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
  static char *capi_kwlist[] = {"i","ar","br",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:atomic_program.hsc",\
    capi_kwlist,&i_capi,&ar_capi,&br_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.hsc() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ar */
  ;
  capi_ar_intent |= F2PY_INTENT_IN;
  capi_ar_tmp = array_from_pyobj(NPY_DOUBLE,ar_Dims,ar_Rank,capi_ar_intent,ar_capi);
  if (capi_ar_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `ar' of atomic_program.hsc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ar = (double *)(PyArray_DATA(capi_ar_tmp));

  /* Processing variable br */
  ;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `br' of atomic_program.hsc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,ar,br);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_ar_tmp!=ar_capi) {
    Py_XDECREF(capi_ar_tmp); }
  }  /*if (capi_ar_tmp == NULL) ... else of ar*/
  /* End of cleaning variable ar */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of hsc *********************************/

/*********************************** excorr ***********************************/
static char doc_f2py_rout_atomic_program_excorr[] = "\
excorr(id,cdd,cdu,cdc,vod,vou,vxc,vc,exc,ec)\n\nWrapper for ``excorr``.\
\n\nParameters\n----------\n"
"id : input string(len=1)\n"
"cdd : input rank-1 array('d') with bounds (1500)\n"
"cdu : input rank-1 array('d') with bounds (1500)\n"
"cdc : input rank-1 array('d') with bounds (1500)\n"
"vod : input rank-1 array('d') with bounds (1500)\n"
"vou : input rank-1 array('d') with bounds (1500)\n"
"vxc : input float\n"
"vc : input float\n"
"exc : input float\n"
"ec : input float";
/* extern void F_FUNC(excorr,EXCORR)(string,double*,double*,double*,double*,double*,double*,double*,double*,double*,size_t); */
static PyObject *f2py_rout_atomic_program_excorr(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,double*,double*,double*,double*,double*,double*,double*,double*,double*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string id = NULL;
  int slen(id);
  PyObject *id_capi = Py_None;
  double *cdd = NULL;
  npy_intp cdd_Dims[1] = {-1};
  const int cdd_Rank = 1;
  PyArrayObject *capi_cdd_tmp = NULL;
  int capi_cdd_intent = 0;
  PyObject *cdd_capi = Py_None;
  double *cdu = NULL;
  npy_intp cdu_Dims[1] = {-1};
  const int cdu_Rank = 1;
  PyArrayObject *capi_cdu_tmp = NULL;
  int capi_cdu_intent = 0;
  PyObject *cdu_capi = Py_None;
  double *cdc = NULL;
  npy_intp cdc_Dims[1] = {-1};
  const int cdc_Rank = 1;
  PyArrayObject *capi_cdc_tmp = NULL;
  int capi_cdc_intent = 0;
  PyObject *cdc_capi = Py_None;
  double *vod = NULL;
  npy_intp vod_Dims[1] = {-1};
  const int vod_Rank = 1;
  PyArrayObject *capi_vod_tmp = NULL;
  int capi_vod_intent = 0;
  PyObject *vod_capi = Py_None;
  double *vou = NULL;
  npy_intp vou_Dims[1] = {-1};
  const int vou_Rank = 1;
  PyArrayObject *capi_vou_tmp = NULL;
  int capi_vou_intent = 0;
  PyObject *vou_capi = Py_None;
  double vxc = 0;
  PyObject *vxc_capi = Py_None;
  double vc = 0;
  PyObject *vc_capi = Py_None;
  double exc = 0;
  PyObject *exc_capi = Py_None;
  double ec = 0;
  PyObject *ec_capi = Py_None;
  static char *capi_kwlist[] = {"id","cdd","cdu","cdc","vod","vou","vxc","vc","exc","ec",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOO|:atomic_program.excorr",\
    capi_kwlist,&id_capi,&cdd_capi,&cdu_capi,&cdc_capi,&vod_capi,&vou_capi,&vxc_capi,&vc_capi,&exc_capi,&ec_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable id */
  slen(id) = 1;
  f2py_success = string_from_pyobj(&id,&slen(id),"",id_capi,"string_from_pyobj failed in converting 1st argument `id' of atomic_program.excorr to C string");
  if (f2py_success) {
  /* Processing variable cdd */
  cdd_Dims[0]=1500;
  capi_cdd_intent |= F2PY_INTENT_IN;
  capi_cdd_tmp = array_from_pyobj(NPY_DOUBLE,cdd_Dims,cdd_Rank,capi_cdd_intent,cdd_capi);
  if (capi_cdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `cdd' of atomic_program.excorr to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    cdd = (double *)(PyArray_DATA(capi_cdd_tmp));

  /* Processing variable cdu */
  cdu_Dims[0]=1500;
  capi_cdu_intent |= F2PY_INTENT_IN;
  capi_cdu_tmp = array_from_pyobj(NPY_DOUBLE,cdu_Dims,cdu_Rank,capi_cdu_intent,cdu_capi);
  if (capi_cdu_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `cdu' of atomic_program.excorr to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    cdu = (double *)(PyArray_DATA(capi_cdu_tmp));

  /* Processing variable cdc */
  cdc_Dims[0]=1500;
  capi_cdc_intent |= F2PY_INTENT_IN;
  capi_cdc_tmp = array_from_pyobj(NPY_DOUBLE,cdc_Dims,cdc_Rank,capi_cdc_intent,cdc_capi);
  if (capi_cdc_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `cdc' of atomic_program.excorr to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    cdc = (double *)(PyArray_DATA(capi_cdc_tmp));

  /* Processing variable vod */
  vod_Dims[0]=1500;
  capi_vod_intent |= F2PY_INTENT_IN;
  capi_vod_tmp = array_from_pyobj(NPY_DOUBLE,vod_Dims,vod_Rank,capi_vod_intent,vod_capi);
  if (capi_vod_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `vod' of atomic_program.excorr to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vod = (double *)(PyArray_DATA(capi_vod_tmp));

  /* Processing variable vou */
  vou_Dims[0]=1500;
  capi_vou_intent |= F2PY_INTENT_IN;
  capi_vou_tmp = array_from_pyobj(NPY_DOUBLE,vou_Dims,vou_Rank,capi_vou_intent,vou_capi);
  if (capi_vou_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `vou' of atomic_program.excorr to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vou = (double *)(PyArray_DATA(capi_vou_tmp));

  /* Processing variable vxc */
    f2py_success = double_from_pyobj(&vxc,vxc_capi,"atomic_program.excorr() 7th argument (vxc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable vc */
    f2py_success = double_from_pyobj(&vc,vc_capi,"atomic_program.excorr() 8th argument (vc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable exc */
    f2py_success = double_from_pyobj(&exc,exc_capi,"atomic_program.excorr() 9th argument (exc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ec */
    f2py_success = double_from_pyobj(&ec,ec_capi,"atomic_program.excorr() 10th argument (ec) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(id,cdd,cdu,cdc,vod,vou,&vxc,&vc,&exc,&ec,slen(id));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of ec*/
  /* End of cleaning variable ec */
  } /*if (f2py_success) of exc*/
  /* End of cleaning variable exc */
  } /*if (f2py_success) of vc*/
  /* End of cleaning variable vc */
  } /*if (f2py_success) of vxc*/
  /* End of cleaning variable vxc */
  if((PyObject *)capi_vou_tmp!=vou_capi) {
    Py_XDECREF(capi_vou_tmp); }
  }  /*if (capi_vou_tmp == NULL) ... else of vou*/
  /* End of cleaning variable vou */
  if((PyObject *)capi_vod_tmp!=vod_capi) {
    Py_XDECREF(capi_vod_tmp); }
  }  /*if (capi_vod_tmp == NULL) ... else of vod*/
  /* End of cleaning variable vod */
  if((PyObject *)capi_cdc_tmp!=cdc_capi) {
    Py_XDECREF(capi_cdc_tmp); }
  }  /*if (capi_cdc_tmp == NULL) ... else of cdc*/
  /* End of cleaning variable cdc */
  if((PyObject *)capi_cdu_tmp!=cdu_capi) {
    Py_XDECREF(capi_cdu_tmp); }
  }  /*if (capi_cdu_tmp == NULL) ... else of cdu*/
  /* End of cleaning variable cdu */
  if((PyObject *)capi_cdd_tmp!=cdd_capi) {
    Py_XDECREF(capi_cdd_tmp); }
  }  /*if (capi_cdd_tmp == NULL) ... else of cdd*/
  /* End of cleaning variable cdd */
    STRINGFREE(id);
  }  /*if (f2py_success) of id*/
  /* End of cleaning variable id */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of excorr *******************************/

/************************************ tm2 ************************************/
static char doc_f2py_rout_atomic_program_tm2[] = "\
tm2(i,wfr,br)\n\nWrapper for ``tm2``.\
\n\nParameters\n----------\n"
"i : input int\n"
"wfr : input rank-1 array('d') with bounds (1500)\n"
"br : input rank-1 array('d') with bounds (1500)";
/* extern void F_FUNC(tm2,TM2)(int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_tm2(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double *wfr = NULL;
  npy_intp wfr_Dims[1] = {-1};
  const int wfr_Rank = 1;
  PyArrayObject *capi_wfr_tmp = NULL;
  int capi_wfr_intent = 0;
  PyObject *wfr_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
  static char *capi_kwlist[] = {"i","wfr","br",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:atomic_program.tm2",\
    capi_kwlist,&i_capi,&wfr_capi,&br_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.tm2() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable wfr */
  wfr_Dims[0]=1500;
  capi_wfr_intent |= F2PY_INTENT_IN;
  capi_wfr_tmp = array_from_pyobj(NPY_DOUBLE,wfr_Dims,wfr_Rank,capi_wfr_intent,wfr_capi);
  if (capi_wfr_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `wfr' of atomic_program.tm2 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    wfr = (double *)(PyArray_DATA(capi_wfr_tmp));

  /* Processing variable br */
  br_Dims[0]=1500;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `br' of atomic_program.tm2 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,wfr,br);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_wfr_tmp!=wfr_capi) {
    Py_XDECREF(capi_wfr_tmp); }
  }  /*if (capi_wfr_tmp == NULL) ... else of wfr*/
  /* End of cleaning variable wfr */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of tm2 *********************************/

/************************************ ker ************************************/
static char doc_f2py_rout_atomic_program_ker[] = "\
ker(i,ar,br)\n\nWrapper for ``ker``.\
\n\nParameters\n----------\n"
"i : input int\n"
"ar : input rank-1 array('d') with bounds (1500)\n"
"br : input rank-1 array('d') with bounds (1500)";
/* extern void F_FUNC(ker,KER)(int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_ker(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double *ar = NULL;
  npy_intp ar_Dims[1] = {-1};
  const int ar_Rank = 1;
  PyArrayObject *capi_ar_tmp = NULL;
  int capi_ar_intent = 0;
  PyObject *ar_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
  static char *capi_kwlist[] = {"i","ar","br",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:atomic_program.ker",\
    capi_kwlist,&i_capi,&ar_capi,&br_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.ker() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ar */
  ar_Dims[0]=1500;
  capi_ar_intent |= F2PY_INTENT_IN;
  capi_ar_tmp = array_from_pyobj(NPY_DOUBLE,ar_Dims,ar_Rank,capi_ar_intent,ar_capi);
  if (capi_ar_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `ar' of atomic_program.ker to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ar = (double *)(PyArray_DATA(capi_ar_tmp));

  /* Processing variable br */
  br_Dims[0]=1500;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `br' of atomic_program.ker to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,ar,br);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_ar_tmp!=ar_capi) {
    Py_XDECREF(capi_ar_tmp); }
  }  /*if (capi_ar_tmp == NULL) ... else of ar*/
  /* End of cleaning variable ar */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of ker *********************************/

/*********************************** wrapup ***********************************/
static char doc_f2py_rout_atomic_program_wrapup[] = "\
wrapup(pot_id)\n\nWrapper for ``wrapup``.\
\n\nParameters\n----------\n"
"pot_id : input string(len=40)";
/* extern void F_FUNC(wrapup,WRAPUP)(string,size_t); */
static PyObject *f2py_rout_atomic_program_wrapup(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string pot_id = NULL;
  int slen(pot_id);
  PyObject *pot_id_capi = Py_None;
  static char *capi_kwlist[] = {"pot_id",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.wrapup",\
    capi_kwlist,&pot_id_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable pot_id */
  slen(pot_id) = 40;
  f2py_success = string_from_pyobj(&pot_id,&slen(pot_id),"",pot_id_capi,"string_from_pyobj failed in converting 1st argument `pot_id' of atomic_program.wrapup to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(pot_id,slen(pot_id));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(pot_id);
  }  /*if (f2py_success) of pot_id*/
  /* End of cleaning variable pot_id */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of wrapup *******************************/

/****************************** cutoff_function ******************************/
static char doc_f2py_rout_atomic_program_cutoff_function[] = "\
cutoff_function = cutoff_function(r)\n\nWrapper for ``cutoff_function``.\
\n\nParameters\n----------\n"
"r : input float\n"
"\nReturns\n-------\n"
"cutoff_function : float";
/* extern void F_WRAPPEDFUNC_US(cutoff_function,CUTOFF_FUNCTION)(double*,double*); */
static PyObject *f2py_rout_atomic_program_cutoff_function(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double cutoff_function = 0;
  double r = 0;
  PyObject *r_capi = Py_None;
  static char *capi_kwlist[] = {"r",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.cutoff_function",\
    capi_kwlist,&r_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable r */
    f2py_success = double_from_pyobj(&r,r_capi,"atomic_program.cutoff_function() 1st argument (r) can't be converted to double");
  if (f2py_success) {
  /* Processing variable cutoff_function */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&cutoff_function,&r);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",cutoff_function);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable cutoff_function */
  } /*if (f2py_success) of r*/
  /* End of cleaning variable r */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*************************** end of cutoff_function ***************************/

/*********************************** splift ***********************************/
static char doc_f2py_rout_atomic_program_splift[] = "\
splift(x,y,yp,ypp,w,ierr,isx,a1,b1,an,bn,[n])\n\nWrapper for ``splift``.\
\n\nParameters\n----------\n"
"x : input rank-1 array('d') with bounds (n)\n"
"y : input rank-1 array('d') with bounds (n)\n"
"yp : input rank-1 array('d') with bounds (n)\n"
"ypp : input rank-1 array('d') with bounds (n)\n"
"w : input rank-2 array('d') with bounds (n,3)\n"
"ierr : input int\n"
"isx : input int\n"
"a1 : input float\n"
"b1 : input float\n"
"an : input float\n"
"bn : input float\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: len(x)";
/* extern void F_FUNC(splift,SPLIFT)(double*,double*,double*,double*,int*,double*,int*,int*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_splift(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,double*,int*,double*,int*,int*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *x = NULL;
  npy_intp x_Dims[1] = {-1};
  const int x_Rank = 1;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
  PyObject *x_capi = Py_None;
  double *y = NULL;
  npy_intp y_Dims[1] = {-1};
  const int y_Rank = 1;
  PyArrayObject *capi_y_tmp = NULL;
  int capi_y_intent = 0;
  PyObject *y_capi = Py_None;
  double *yp = NULL;
  npy_intp yp_Dims[1] = {-1};
  const int yp_Rank = 1;
  PyArrayObject *capi_yp_tmp = NULL;
  int capi_yp_intent = 0;
  PyObject *yp_capi = Py_None;
  double *ypp = NULL;
  npy_intp ypp_Dims[1] = {-1};
  const int ypp_Rank = 1;
  PyArrayObject *capi_ypp_tmp = NULL;
  int capi_ypp_intent = 0;
  PyObject *ypp_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double *w = NULL;
  npy_intp w_Dims[2] = {-1, -1};
  const int w_Rank = 2;
  PyArrayObject *capi_w_tmp = NULL;
  int capi_w_intent = 0;
  PyObject *w_capi = Py_None;
  int ierr = 0;
  PyObject *ierr_capi = Py_None;
  int isx = 0;
  PyObject *isx_capi = Py_None;
  double a1 = 0;
  PyObject *a1_capi = Py_None;
  double b1 = 0;
  PyObject *b1_capi = Py_None;
  double an = 0;
  PyObject *an_capi = Py_None;
  double bn = 0;
  PyObject *bn_capi = Py_None;
  static char *capi_kwlist[] = {"x","y","yp","ypp","w","ierr","isx","a1","b1","an","bn","n",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOO|O:atomic_program.splift",\
    capi_kwlist,&x_capi,&y_capi,&yp_capi,&ypp_capi,&w_capi,&ierr_capi,&isx_capi,&a1_capi,&b1_capi,&an_capi,&bn_capi,&n_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable x */
  ;
  capi_x_intent |= F2PY_INTENT_IN;
  capi_x_tmp = array_from_pyobj(NPY_DOUBLE,x_Dims,x_Rank,capi_x_intent,x_capi);
  if (capi_x_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `x' of atomic_program.splift to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    x = (double *)(PyArray_DATA(capi_x_tmp));

  /* Processing variable ierr */
    f2py_success = int_from_pyobj(&ierr,ierr_capi,"atomic_program.splift() 6th argument (ierr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable isx */
    f2py_success = int_from_pyobj(&isx,isx_capi,"atomic_program.splift() 7th argument (isx) can't be converted to int");
  if (f2py_success) {
  /* Processing variable a1 */
    f2py_success = double_from_pyobj(&a1,a1_capi,"atomic_program.splift() 8th argument (a1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable b1 */
    f2py_success = double_from_pyobj(&b1,b1_capi,"atomic_program.splift() 9th argument (b1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable an */
    f2py_success = double_from_pyobj(&an,an_capi,"atomic_program.splift() 10th argument (an) can't be converted to double");
  if (f2py_success) {
  /* Processing variable bn */
    f2py_success = double_from_pyobj(&bn,bn_capi,"atomic_program.splift() 11st argument (bn) can't be converted to double");
  if (f2py_success) {
  /* Processing variable n */
  if (n_capi == Py_None) n = len(x); else
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.splift() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(x)>=n,"len(x)>=n","1st keyword n","splift:n=%d",n) {
  /* Processing variable w */
  w_Dims[0]=n,w_Dims[1]=3;
  capi_w_intent |= F2PY_INTENT_IN;
  capi_w_tmp = array_from_pyobj(NPY_DOUBLE,w_Dims,w_Rank,capi_w_intent,w_capi);
  if (capi_w_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `w' of atomic_program.splift to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    w = (double *)(PyArray_DATA(capi_w_tmp));

  /* Processing variable y */
  y_Dims[0]=n;
  capi_y_intent |= F2PY_INTENT_IN;
  capi_y_tmp = array_from_pyobj(NPY_DOUBLE,y_Dims,y_Rank,capi_y_intent,y_capi);
  if (capi_y_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `y' of atomic_program.splift to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    y = (double *)(PyArray_DATA(capi_y_tmp));

  /* Processing variable yp */
  yp_Dims[0]=n;
  capi_yp_intent |= F2PY_INTENT_IN;
  capi_yp_tmp = array_from_pyobj(NPY_DOUBLE,yp_Dims,yp_Rank,capi_yp_intent,yp_capi);
  if (capi_yp_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `yp' of atomic_program.splift to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    yp = (double *)(PyArray_DATA(capi_yp_tmp));

  /* Processing variable ypp */
  ypp_Dims[0]=n;
  capi_ypp_intent |= F2PY_INTENT_IN;
  capi_ypp_tmp = array_from_pyobj(NPY_DOUBLE,ypp_Dims,ypp_Rank,capi_ypp_intent,ypp_capi);
  if (capi_ypp_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `ypp' of atomic_program.splift to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ypp = (double *)(PyArray_DATA(capi_ypp_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(x,y,yp,ypp,&n,w,&ierr,&isx,&a1,&b1,&an,&bn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_ypp_tmp!=ypp_capi) {
    Py_XDECREF(capi_ypp_tmp); }
  }  /*if (capi_ypp_tmp == NULL) ... else of ypp*/
  /* End of cleaning variable ypp */
  if((PyObject *)capi_yp_tmp!=yp_capi) {
    Py_XDECREF(capi_yp_tmp); }
  }  /*if (capi_yp_tmp == NULL) ... else of yp*/
  /* End of cleaning variable yp */
  if((PyObject *)capi_y_tmp!=y_capi) {
    Py_XDECREF(capi_y_tmp); }
  }  /*if (capi_y_tmp == NULL) ... else of y*/
  /* End of cleaning variable y */
  if((PyObject *)capi_w_tmp!=w_capi) {
    Py_XDECREF(capi_w_tmp); }
  }  /*if (capi_w_tmp == NULL) ... else of w*/
  /* End of cleaning variable w */
  } /*CHECKSCALAR(len(x)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of bn*/
  /* End of cleaning variable bn */
  } /*if (f2py_success) of an*/
  /* End of cleaning variable an */
  } /*if (f2py_success) of b1*/
  /* End of cleaning variable b1 */
  } /*if (f2py_success) of a1*/
  /* End of cleaning variable a1 */
  } /*if (f2py_success) of isx*/
  /* End of cleaning variable isx */
  } /*if (f2py_success) of ierr*/
  /* End of cleaning variable ierr */
  if((PyObject *)capi_x_tmp!=x_capi) {
    Py_XDECREF(capi_x_tmp); }
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of splift *******************************/

/*********************************** spliq ***********************************/
static char doc_f2py_rout_atomic_program_spliq[] = "\
spliq(x,y,yp,ypp,xlo,xup,ans,ierr,[n,nup])\n\nWrapper for ``spliq``.\
\n\nParameters\n----------\n"
"x : input rank-1 array('d') with bounds (n)\n"
"y : input rank-1 array('d') with bounds (n)\n"
"yp : input rank-1 array('d') with bounds (n)\n"
"ypp : input rank-1 array('d') with bounds (n)\n"
"xlo : input float\n"
"xup : input rank-1 array('d') with bounds (nup)\n"
"ans : input rank-1 array('d') with bounds (nup)\n"
"ierr : input int\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: len(x)\n"
"nup : input int, optional\n    Default: len(xup)";
/* extern void F_FUNC(spliq,SPLIQ)(double*,double*,double*,double*,int*,double*,double*,int*,double*,int*); */
static PyObject *f2py_rout_atomic_program_spliq(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,double*,int*,double*,double*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *x = NULL;
  npy_intp x_Dims[1] = {-1};
  const int x_Rank = 1;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
  PyObject *x_capi = Py_None;
  double *y = NULL;
  npy_intp y_Dims[1] = {-1};
  const int y_Rank = 1;
  PyArrayObject *capi_y_tmp = NULL;
  int capi_y_intent = 0;
  PyObject *y_capi = Py_None;
  double *yp = NULL;
  npy_intp yp_Dims[1] = {-1};
  const int yp_Rank = 1;
  PyArrayObject *capi_yp_tmp = NULL;
  int capi_yp_intent = 0;
  PyObject *yp_capi = Py_None;
  double *ypp = NULL;
  npy_intp ypp_Dims[1] = {-1};
  const int ypp_Rank = 1;
  PyArrayObject *capi_ypp_tmp = NULL;
  int capi_ypp_intent = 0;
  PyObject *ypp_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double xlo = 0;
  PyObject *xlo_capi = Py_None;
  double *xup = NULL;
  npy_intp xup_Dims[1] = {-1};
  const int xup_Rank = 1;
  PyArrayObject *capi_xup_tmp = NULL;
  int capi_xup_intent = 0;
  PyObject *xup_capi = Py_None;
  int nup = 0;
  PyObject *nup_capi = Py_None;
  double *ans = NULL;
  npy_intp ans_Dims[1] = {-1};
  const int ans_Rank = 1;
  PyArrayObject *capi_ans_tmp = NULL;
  int capi_ans_intent = 0;
  PyObject *ans_capi = Py_None;
  int ierr = 0;
  PyObject *ierr_capi = Py_None;
  static char *capi_kwlist[] = {"x","y","yp","ypp","xlo","xup","ans","ierr","n","nup",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOO|OO:atomic_program.spliq",\
    capi_kwlist,&x_capi,&y_capi,&yp_capi,&ypp_capi,&xlo_capi,&xup_capi,&ans_capi,&ierr_capi,&n_capi,&nup_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable x */
  ;
  capi_x_intent |= F2PY_INTENT_IN;
  capi_x_tmp = array_from_pyobj(NPY_DOUBLE,x_Dims,x_Rank,capi_x_intent,x_capi);
  if (capi_x_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `x' of atomic_program.spliq to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    x = (double *)(PyArray_DATA(capi_x_tmp));

  /* Processing variable xlo */
    f2py_success = double_from_pyobj(&xlo,xlo_capi,"atomic_program.spliq() 5th argument (xlo) can't be converted to double");
  if (f2py_success) {
  /* Processing variable xup */
  ;
  capi_xup_intent |= F2PY_INTENT_IN;
  capi_xup_tmp = array_from_pyobj(NPY_DOUBLE,xup_Dims,xup_Rank,capi_xup_intent,xup_capi);
  if (capi_xup_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `xup' of atomic_program.spliq to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    xup = (double *)(PyArray_DATA(capi_xup_tmp));

  /* Processing variable ierr */
    f2py_success = int_from_pyobj(&ierr,ierr_capi,"atomic_program.spliq() 8th argument (ierr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n */
  if (n_capi == Py_None) n = len(x); else
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.spliq() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(x)>=n,"len(x)>=n","1st keyword n","spliq:n=%d",n) {
  /* Processing variable nup */
  if (nup_capi == Py_None) nup = len(xup); else
    f2py_success = int_from_pyobj(&nup,nup_capi,"atomic_program.spliq() 2nd keyword (nup) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(xup)>=nup,"len(xup)>=nup","2nd keyword nup","spliq:nup=%d",nup) {
  /* Processing variable ans */
  ans_Dims[0]=nup;
  capi_ans_intent |= F2PY_INTENT_IN;
  capi_ans_tmp = array_from_pyobj(NPY_DOUBLE,ans_Dims,ans_Rank,capi_ans_intent,ans_capi);
  if (capi_ans_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `ans' of atomic_program.spliq to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ans = (double *)(PyArray_DATA(capi_ans_tmp));

  /* Processing variable y */
  y_Dims[0]=n;
  capi_y_intent |= F2PY_INTENT_IN;
  capi_y_tmp = array_from_pyobj(NPY_DOUBLE,y_Dims,y_Rank,capi_y_intent,y_capi);
  if (capi_y_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `y' of atomic_program.spliq to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    y = (double *)(PyArray_DATA(capi_y_tmp));

  /* Processing variable yp */
  yp_Dims[0]=n;
  capi_yp_intent |= F2PY_INTENT_IN;
  capi_yp_tmp = array_from_pyobj(NPY_DOUBLE,yp_Dims,yp_Rank,capi_yp_intent,yp_capi);
  if (capi_yp_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `yp' of atomic_program.spliq to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    yp = (double *)(PyArray_DATA(capi_yp_tmp));

  /* Processing variable ypp */
  ypp_Dims[0]=n;
  capi_ypp_intent |= F2PY_INTENT_IN;
  capi_ypp_tmp = array_from_pyobj(NPY_DOUBLE,ypp_Dims,ypp_Rank,capi_ypp_intent,ypp_capi);
  if (capi_ypp_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `ypp' of atomic_program.spliq to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ypp = (double *)(PyArray_DATA(capi_ypp_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(x,y,yp,ypp,&n,&xlo,xup,&nup,ans,&ierr);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_ypp_tmp!=ypp_capi) {
    Py_XDECREF(capi_ypp_tmp); }
  }  /*if (capi_ypp_tmp == NULL) ... else of ypp*/
  /* End of cleaning variable ypp */
  if((PyObject *)capi_yp_tmp!=yp_capi) {
    Py_XDECREF(capi_yp_tmp); }
  }  /*if (capi_yp_tmp == NULL) ... else of yp*/
  /* End of cleaning variable yp */
  if((PyObject *)capi_y_tmp!=y_capi) {
    Py_XDECREF(capi_y_tmp); }
  }  /*if (capi_y_tmp == NULL) ... else of y*/
  /* End of cleaning variable y */
  if((PyObject *)capi_ans_tmp!=ans_capi) {
    Py_XDECREF(capi_ans_tmp); }
  }  /*if (capi_ans_tmp == NULL) ... else of ans*/
  /* End of cleaning variable ans */
  } /*CHECKSCALAR(len(xup)>=nup)*/
  } /*if (f2py_success) of nup*/
  /* End of cleaning variable nup */
  } /*CHECKSCALAR(len(x)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of ierr*/
  /* End of cleaning variable ierr */
  if((PyObject *)capi_xup_tmp!=xup_capi) {
    Py_XDECREF(capi_xup_tmp); }
  }  /*if (capi_xup_tmp == NULL) ... else of xup*/
  /* End of cleaning variable xup */
  } /*if (f2py_success) of xlo*/
  /* End of cleaning variable xlo */
  if((PyObject *)capi_x_tmp!=x_capi) {
    Py_XDECREF(capi_x_tmp); }
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of spliq ********************************/

/*********************************** velect ***********************************/
static char doc_f2py_rout_atomic_program_velect[] = "\
velect(iter,iconv,id,zelec)\n\nWrapper for ``velect``.\
\n\nParameters\n----------\n"
"iter : input int\n"
"iconv : input int\n"
"id : input string(len=1)\n"
"zelec : input float";
/* extern void F_FUNC(velect,VELECT)(int*,int*,string,double*,size_t); */
static PyObject *f2py_rout_atomic_program_velect(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,string,double*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int iter = 0;
  PyObject *iter_capi = Py_None;
  int iconv = 0;
  PyObject *iconv_capi = Py_None;
  string id = NULL;
  int slen(id);
  PyObject *id_capi = Py_None;
  double zelec = 0;
  PyObject *zelec_capi = Py_None;
  static char *capi_kwlist[] = {"iter","iconv","id","zelec",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|:atomic_program.velect",\
    capi_kwlist,&iter_capi,&iconv_capi,&id_capi,&zelec_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable iter */
    f2py_success = int_from_pyobj(&iter,iter_capi,"atomic_program.velect() 1st argument (iter) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iconv */
    f2py_success = int_from_pyobj(&iconv,iconv_capi,"atomic_program.velect() 2nd argument (iconv) can't be converted to int");
  if (f2py_success) {
  /* Processing variable id */
  slen(id) = 1;
  f2py_success = string_from_pyobj(&id,&slen(id),"",id_capi,"string_from_pyobj failed in converting 3rd argument `id' of atomic_program.velect to C string");
  if (f2py_success) {
  /* Processing variable zelec */
    f2py_success = double_from_pyobj(&zelec,zelec_capi,"atomic_program.velect() 4th argument (zelec) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iter,&iconv,id,&zelec,slen(id));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of zelec*/
  /* End of cleaning variable zelec */
    STRINGFREE(id);
  }  /*if (f2py_success) of id*/
  /* End of cleaning variable id */
  } /*if (f2py_success) of iconv*/
  /* End of cleaning variable iconv */
  } /*if (f2py_success) of iter*/
  /* End of cleaning variable iter */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of velect *******************************/

/*********************************** vionic ***********************************/
static char doc_f2py_rout_atomic_program_vionic[] = "\
vionic()\n\nWrapper for ``vionic``.\
\n";
/* extern void F_FUNC(vionic,VIONIC)(void); */
static PyObject *f2py_rout_atomic_program_vionic(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:atomic_program.vionic",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of vionic *******************************/

/*********************************** wtrans ***********************************/
static char doc_f2py_rout_atomic_program_wtrans[] = "\
wtrans(vd,r,i,ist,[nr])\n\nWrapper for ``wtrans``.\
\n\nParameters\n----------\n"
"vd : input rank-1 array('d') with bounds (nr)\n"
"r : input rank-1 array('d') with bounds (nr)\n"
"i : input int\n"
"ist : input int\n"
"\nOther Parameters\n----------------\n"
"nr : input int, optional\n    Default: len(vd)";
/* extern void F_FUNC(wtrans,WTRANS)(double*,double*,int*,int*,int*); */
static PyObject *f2py_rout_atomic_program_wtrans(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *vd = NULL;
  npy_intp vd_Dims[1] = {-1};
  const int vd_Rank = 1;
  PyArrayObject *capi_vd_tmp = NULL;
  int capi_vd_intent = 0;
  PyObject *vd_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  int i = 0;
  PyObject *i_capi = Py_None;
  int ist = 0;
  PyObject *ist_capi = Py_None;
  static char *capi_kwlist[] = {"vd","r","i","ist","nr",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O:atomic_program.wtrans",\
    capi_kwlist,&vd_capi,&r_capi,&i_capi,&ist_capi,&nr_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable vd */
  ;
  capi_vd_intent |= F2PY_INTENT_IN;
  capi_vd_tmp = array_from_pyobj(NPY_DOUBLE,vd_Dims,vd_Rank,capi_vd_intent,vd_capi);
  if (capi_vd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `vd' of atomic_program.wtrans to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vd = (double *)(PyArray_DATA(capi_vd_tmp));

  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.wtrans() 3rd argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ist */
    f2py_success = int_from_pyobj(&ist,ist_capi,"atomic_program.wtrans() 4th argument (ist) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nr */
  if (nr_capi == Py_None) nr = len(vd); else
    f2py_success = int_from_pyobj(&nr,nr_capi,"atomic_program.wtrans() 1st keyword (nr) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(vd)>=nr,"len(vd)>=nr","1st keyword nr","wtrans:nr=%d",nr) {
  /* Processing variable r */
  r_Dims[0]=nr;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `r' of atomic_program.wtrans to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    r = (double *)(PyArray_DATA(capi_r_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(vd,r,&nr,&i,&ist);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*CHECKSCALAR(len(vd)>=nr)*/
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of ist*/
  /* End of cleaning variable ist */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
  if((PyObject *)capi_vd_tmp!=vd_capi) {
    Py_XDECREF(capi_vd_tmp); }
  }  /*if (capi_vd_tmp == NULL) ... else of vd*/
  /* End of cleaning variable vd */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of wtrans *******************************/

/************************************ v0pp ************************************/
static char doc_f2py_rout_atomic_program_v0pp[] = "\
v0pp = v0pp(gamma)\n\nWrapper for ``v0pp``.\
\n\nParameters\n----------\n"
"gamma : input float\n"
"\nReturns\n-------\n"
"v0pp : float";
/* extern void F_WRAPPEDFUNC(v0pp,V0PP)(double*,double*); */
static PyObject *f2py_rout_atomic_program_v0pp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double v0pp = 0;
  double gamma = 0;
  PyObject *gamma_capi = Py_None;
  static char *capi_kwlist[] = {"gamma",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.v0pp",\
    capi_kwlist,&gamma_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable gamma */
    f2py_success = double_from_pyobj(&gamma,gamma_capi,"atomic_program.v0pp() 1st argument (gamma) can't be converted to double");
  if (f2py_success) {
  /* Processing variable v0pp */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&v0pp,&gamma);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",v0pp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable v0pp */
  } /*if (f2py_success) of gamma*/
  /* End of cleaning variable gamma */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of v0pp ********************************/

/********************************** chg_mism **********************************/
static char doc_f2py_rout_atomic_program_chg_mism[] = "\
chg_mism = chg_mism(xdelta)\n\nWrapper for ``chg_mism``.\
\n\nParameters\n----------\n"
"xdelta : input float\n"
"\nReturns\n-------\n"
"chg_mism : float";
/* extern void F_WRAPPEDFUNC_US(chg_mism,CHG_MISM)(double*,double*); */
static PyObject *f2py_rout_atomic_program_chg_mism(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double chg_mism = 0;
  double xdelta = 0;
  PyObject *xdelta_capi = Py_None;
  static char *capi_kwlist[] = {"xdelta",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.chg_mism",\
    capi_kwlist,&xdelta_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable xdelta */
    f2py_success = double_from_pyobj(&xdelta,xdelta_capi,"atomic_program.chg_mism() 1st argument (xdelta) can't be converted to double");
  if (f2py_success) {
  /* Processing variable chg_mism */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&chg_mism,&xdelta);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",chg_mism);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable chg_mism */
  } /*if (f2py_success) of xdelta*/
  /* End of cleaning variable xdelta */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of chg_mism ******************************/

/*********************************** dsolv2 ***********************************/
static char doc_f2py_rout_atomic_program_dsolv2[] = "\
dsolv2(iter,iconv,id,nfirst,nlast,n_of_core_orbs,nn)\n\nWrapper for ``dsolv2``.\
\n\nParameters\n----------\n"
"iter : input int\n"
"iconv : input int\n"
"id : input string(len=1)\n"
"nfirst : input int\n"
"nlast : input int\n"
"n_of_core_orbs : input int\n"
"nn : input rank-1 array('i') with bounds (*)";
/* extern void F_FUNC(dsolv2,DSOLV2)(int*,int*,string,int*,int*,int*,int*,size_t); */
static PyObject *f2py_rout_atomic_program_dsolv2(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,string,int*,int*,int*,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int iter = 0;
  PyObject *iter_capi = Py_None;
  int iconv = 0;
  PyObject *iconv_capi = Py_None;
  string id = NULL;
  int slen(id);
  PyObject *id_capi = Py_None;
  int nfirst = 0;
  PyObject *nfirst_capi = Py_None;
  int nlast = 0;
  PyObject *nlast_capi = Py_None;
  int n_of_core_orbs = 0;
  PyObject *n_of_core_orbs_capi = Py_None;
  int *nn = NULL;
  npy_intp nn_Dims[1] = {-1};
  const int nn_Rank = 1;
  PyArrayObject *capi_nn_tmp = NULL;
  int capi_nn_intent = 0;
  PyObject *nn_capi = Py_None;
  static char *capi_kwlist[] = {"iter","iconv","id","nfirst","nlast","n_of_core_orbs","nn",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOO|:atomic_program.dsolv2",\
    capi_kwlist,&iter_capi,&iconv_capi,&id_capi,&nfirst_capi,&nlast_capi,&n_of_core_orbs_capi,&nn_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable iter */
    f2py_success = int_from_pyobj(&iter,iter_capi,"atomic_program.dsolv2() 1st argument (iter) can't be converted to int");
  if (f2py_success) {
  /* Processing variable iconv */
    f2py_success = int_from_pyobj(&iconv,iconv_capi,"atomic_program.dsolv2() 2nd argument (iconv) can't be converted to int");
  if (f2py_success) {
  /* Processing variable id */
  slen(id) = 1;
  f2py_success = string_from_pyobj(&id,&slen(id),"",id_capi,"string_from_pyobj failed in converting 3rd argument `id' of atomic_program.dsolv2 to C string");
  if (f2py_success) {
  /* Processing variable nfirst */
    f2py_success = int_from_pyobj(&nfirst,nfirst_capi,"atomic_program.dsolv2() 4th argument (nfirst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nlast */
    f2py_success = int_from_pyobj(&nlast,nlast_capi,"atomic_program.dsolv2() 5th argument (nlast) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n_of_core_orbs */
    f2py_success = int_from_pyobj(&n_of_core_orbs,n_of_core_orbs_capi,"atomic_program.dsolv2() 6th argument (n_of_core_orbs) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nn */
  ;
  capi_nn_intent |= F2PY_INTENT_IN;
  capi_nn_tmp = array_from_pyobj(NPY_INT,nn_Dims,nn_Rank,capi_nn_intent,nn_capi);
  if (capi_nn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `nn' of atomic_program.dsolv2 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    nn = (int *)(PyArray_DATA(capi_nn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iter,&iconv,id,&nfirst,&nlast,&n_of_core_orbs,nn,slen(id));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_nn_tmp!=nn_capi) {
    Py_XDECREF(capi_nn_tmp); }
  }  /*if (capi_nn_tmp == NULL) ... else of nn*/
  /* End of cleaning variable nn */
  } /*if (f2py_success) of n_of_core_orbs*/
  /* End of cleaning variable n_of_core_orbs */
  } /*if (f2py_success) of nlast*/
  /* End of cleaning variable nlast */
  } /*if (f2py_success) of nfirst*/
  /* End of cleaning variable nfirst */
    STRINGFREE(id);
  }  /*if (f2py_success) of id*/
  /* End of cleaning variable id */
  } /*if (f2py_success) of iconv*/
  /* End of cleaning variable iconv */
  } /*if (f2py_success) of iter*/
  /* End of cleaning variable iter */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of dsolv2 *******************************/

/*********************************** etotal ***********************************/
static char doc_f2py_rout_atomic_program_etotal[] = "\
etotal(nfirst,nlast)\n\nWrapper for ``etotal``.\
\n\nParameters\n----------\n"
"nfirst : input int\n"
"nlast : input int";
/* extern void F_FUNC(etotal,ETOTAL)(int*,int*); */
static PyObject *f2py_rout_atomic_program_etotal(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nfirst = 0;
  PyObject *nfirst_capi = Py_None;
  int nlast = 0;
  PyObject *nlast_capi = Py_None;
  static char *capi_kwlist[] = {"nfirst","nlast",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:atomic_program.etotal",\
    capi_kwlist,&nfirst_capi,&nlast_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nfirst */
    f2py_success = int_from_pyobj(&nfirst,nfirst_capi,"atomic_program.etotal() 1st argument (nfirst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nlast */
    f2py_success = int_from_pyobj(&nlast,nlast_capi,"atomic_program.etotal() 2nd argument (nlast) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nfirst,&nlast);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of nlast*/
  /* End of cleaning variable nlast */
  } /*if (f2py_success) of nfirst*/
  /* End of cleaning variable nfirst */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of etotal *******************************/

/************************************ ext ************************************/
static char doc_f2py_rout_atomic_program_ext[] = "\
ext(i)\n\nWrapper for ``ext``.\
\n\nParameters\n----------\n"
"i : input int";
/* extern void F_FUNC(ext,EXT)(int*); */
static PyObject *f2py_rout_atomic_program_ext(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  static char *capi_kwlist[] = {"i",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.ext",\
    capi_kwlist,&i_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.ext() 1st argument (i) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of ext *********************************/

/*********************************** input ***********************************/
static char doc_f2py_rout_atomic_program_input[] = "\
input(maxit)\n\nWrapper for ``input``.\
\n\nParameters\n----------\n"
"maxit : input int";
/* extern void F_FUNC(input,INPUT)(int*); */
static PyObject *f2py_rout_atomic_program_input(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int maxit = 0;
  PyObject *maxit_capi = Py_None;
  static char *capi_kwlist[] = {"maxit",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.input",\
    capi_kwlist,&maxit_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable maxit */
    f2py_success = int_from_pyobj(&maxit,maxit_capi,"atomic_program.input() 1st argument (maxit) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&maxit);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of maxit*/
  /* End of cleaning variable maxit */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of input ********************************/

/*********************************** header ***********************************/
static char doc_f2py_rout_atomic_program_header[] = "\
header()\n\nWrapper for ``header``.\
\n";
/* extern void F_FUNC(header,HEADER)(void); */
static PyObject *f2py_rout_atomic_program_header(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:atomic_program.header",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of header *******************************/

/*********************************** orban ***********************************/
static char doc_f2py_rout_atomic_program_orban[] = "\
orban(iorb,id,ar,br,n,l,occup,spin,eigv,ekin,epot)\n\nWrapper for ``orban``.\
\n\nParameters\n----------\n"
"iorb : input int\n"
"id : input string(len=1)\n"
"ar : input rank-1 array('d') with bounds (*)\n"
"br : input rank-1 array('d') with bounds (*)\n"
"n : input int\n"
"l : input int\n"
"occup : input float\n"
"spin : input float\n"
"eigv : input float\n"
"ekin : input float\n"
"epot : input float";
/* extern void F_FUNC(orban,ORBAN)(int*,string,double*,double*,int*,int*,double*,double*,double*,double*,double*,size_t); */
static PyObject *f2py_rout_atomic_program_orban(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,string,double*,double*,int*,int*,double*,double*,double*,double*,double*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int iorb = 0;
  PyObject *iorb_capi = Py_None;
  string id = NULL;
  int slen(id);
  PyObject *id_capi = Py_None;
  double *ar = NULL;
  npy_intp ar_Dims[1] = {-1};
  const int ar_Rank = 1;
  PyArrayObject *capi_ar_tmp = NULL;
  int capi_ar_intent = 0;
  PyObject *ar_capi = Py_None;
  double *br = NULL;
  npy_intp br_Dims[1] = {-1};
  const int br_Rank = 1;
  PyArrayObject *capi_br_tmp = NULL;
  int capi_br_intent = 0;
  PyObject *br_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  double occup = 0;
  PyObject *occup_capi = Py_None;
  double spin = 0;
  PyObject *spin_capi = Py_None;
  double eigv = 0;
  PyObject *eigv_capi = Py_None;
  double ekin = 0;
  PyObject *ekin_capi = Py_None;
  double epot = 0;
  PyObject *epot_capi = Py_None;
  static char *capi_kwlist[] = {"iorb","id","ar","br","n","l","occup","spin","eigv","ekin","epot",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOO|:atomic_program.orban",\
    capi_kwlist,&iorb_capi,&id_capi,&ar_capi,&br_capi,&n_capi,&l_capi,&occup_capi,&spin_capi,&eigv_capi,&ekin_capi,&epot_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable iorb */
    f2py_success = int_from_pyobj(&iorb,iorb_capi,"atomic_program.orban() 1st argument (iorb) can't be converted to int");
  if (f2py_success) {
  /* Processing variable id */
  slen(id) = 1;
  f2py_success = string_from_pyobj(&id,&slen(id),"",id_capi,"string_from_pyobj failed in converting 2nd argument `id' of atomic_program.orban to C string");
  if (f2py_success) {
  /* Processing variable ar */
  ;
  capi_ar_intent |= F2PY_INTENT_IN;
  capi_ar_tmp = array_from_pyobj(NPY_DOUBLE,ar_Dims,ar_Rank,capi_ar_intent,ar_capi);
  if (capi_ar_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `ar' of atomic_program.orban to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ar = (double *)(PyArray_DATA(capi_ar_tmp));

  /* Processing variable br */
  ;
  capi_br_intent |= F2PY_INTENT_IN;
  capi_br_tmp = array_from_pyobj(NPY_DOUBLE,br_Dims,br_Rank,capi_br_intent,br_capi);
  if (capi_br_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `br' of atomic_program.orban to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    br = (double *)(PyArray_DATA(capi_br_tmp));

  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.orban() 5th argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable l */
    f2py_success = int_from_pyobj(&l,l_capi,"atomic_program.orban() 6th argument (l) can't be converted to int");
  if (f2py_success) {
  /* Processing variable occup */
    f2py_success = double_from_pyobj(&occup,occup_capi,"atomic_program.orban() 7th argument (occup) can't be converted to double");
  if (f2py_success) {
  /* Processing variable spin */
    f2py_success = double_from_pyobj(&spin,spin_capi,"atomic_program.orban() 8th argument (spin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable eigv */
    f2py_success = double_from_pyobj(&eigv,eigv_capi,"atomic_program.orban() 9th argument (eigv) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ekin */
    f2py_success = double_from_pyobj(&ekin,ekin_capi,"atomic_program.orban() 10th argument (ekin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable epot */
    f2py_success = double_from_pyobj(&epot,epot_capi,"atomic_program.orban() 11st argument (epot) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&iorb,id,ar,br,&n,&l,&occup,&spin,&eigv,&ekin,&epot,slen(id));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of epot*/
  /* End of cleaning variable epot */
  } /*if (f2py_success) of ekin*/
  /* End of cleaning variable ekin */
  } /*if (f2py_success) of eigv*/
  /* End of cleaning variable eigv */
  } /*if (f2py_success) of spin*/
  /* End of cleaning variable spin */
  } /*if (f2py_success) of occup*/
  /* End of cleaning variable occup */
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_br_tmp!=br_capi) {
    Py_XDECREF(capi_br_tmp); }
  }  /*if (capi_br_tmp == NULL) ... else of br*/
  /* End of cleaning variable br */
  if((PyObject *)capi_ar_tmp!=ar_capi) {
    Py_XDECREF(capi_ar_tmp); }
  }  /*if (capi_ar_tmp == NULL) ... else of ar*/
  /* End of cleaning variable ar */
    STRINGFREE(id);
  }  /*if (f2py_success) of id*/
  /* End of cleaning variable id */
  } /*if (f2py_success) of iorb*/
  /* End of cleaning variable iorb */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of orban ********************************/

/*********************************** potran ***********************************/
static char doc_f2py_rout_atomic_program_potran[] = "\
potran(i,vd,r,zion,fourier_area,[nr])\n\nWrapper for ``potran``.\
\n\nParameters\n----------\n"
"i : input int\n"
"vd : input rank-1 array('d') with bounds (nr)\n"
"r : input rank-1 array('d') with bounds (nr)\n"
"zion : input float\n"
"fourier_area : input float\n"
"\nOther Parameters\n----------------\n"
"nr : input int, optional\n    Default: len(vd)";
/* extern void F_FUNC(potran,POTRAN)(int*,double*,double*,int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_potran(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,int*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  double *vd = NULL;
  npy_intp vd_Dims[1] = {-1};
  const int vd_Rank = 1;
  PyArrayObject *capi_vd_tmp = NULL;
  int capi_vd_intent = 0;
  PyObject *vd_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  double zion = 0;
  PyObject *zion_capi = Py_None;
  double fourier_area = 0;
  PyObject *fourier_area_capi = Py_None;
  static char *capi_kwlist[] = {"i","vd","r","zion","fourier_area","nr",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO|O:atomic_program.potran",\
    capi_kwlist,&i_capi,&vd_capi,&r_capi,&zion_capi,&fourier_area_capi,&nr_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.potran() 1st argument (i) can't be converted to int");
  if (f2py_success) {
  /* Processing variable vd */
  ;
  capi_vd_intent |= F2PY_INTENT_IN;
  capi_vd_tmp = array_from_pyobj(NPY_DOUBLE,vd_Dims,vd_Rank,capi_vd_intent,vd_capi);
  if (capi_vd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `vd' of atomic_program.potran to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vd = (double *)(PyArray_DATA(capi_vd_tmp));

  /* Processing variable zion */
    f2py_success = double_from_pyobj(&zion,zion_capi,"atomic_program.potran() 4th argument (zion) can't be converted to double");
  if (f2py_success) {
  /* Processing variable fourier_area */
    f2py_success = double_from_pyobj(&fourier_area,fourier_area_capi,"atomic_program.potran() 5th argument (fourier_area) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
  if (nr_capi == Py_None) nr = len(vd); else
    f2py_success = int_from_pyobj(&nr,nr_capi,"atomic_program.potran() 1st keyword (nr) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(vd)>=nr,"len(vd)>=nr","1st keyword nr","potran:nr=%d",nr) {
  /* Processing variable r */
  r_Dims[0]=nr;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `r' of atomic_program.potran to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    r = (double *)(PyArray_DATA(capi_r_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i,vd,r,&nr,&zion,&fourier_area);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*CHECKSCALAR(len(vd)>=nr)*/
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of fourier_area*/
  /* End of cleaning variable fourier_area */
  } /*if (f2py_success) of zion*/
  /* End of cleaning variable zion */
  if((PyObject *)capi_vd_tmp!=vd_capi) {
    Py_XDECREF(capi_vd_tmp); }
  }  /*if (capi_vd_tmp == NULL) ... else of vd*/
  /* End of cleaning variable vd */
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of potran *******************************/

/*********************************** potrv ***********************************/
static char doc_f2py_rout_atomic_program_potrv[] = "\
potrv(vd,r,k,zion,[nr])\n\nWrapper for ``potrv``.\
\n\nParameters\n----------\n"
"vd : input rank-1 array('d') with bounds (nr)\n"
"r : input rank-1 array('d') with bounds (nr)\n"
"k : input int\n"
"zion : input float\n"
"\nOther Parameters\n----------------\n"
"nr : input int, optional\n    Default: len(vd)";
/* extern void F_FUNC(potrv,POTRV)(double*,double*,int*,int*,double*); */
static PyObject *f2py_rout_atomic_program_potrv(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,int*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *vd = NULL;
  npy_intp vd_Dims[1] = {-1};
  const int vd_Rank = 1;
  PyArrayObject *capi_vd_tmp = NULL;
  int capi_vd_intent = 0;
  PyObject *vd_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  int k = 0;
  PyObject *k_capi = Py_None;
  double zion = 0;
  PyObject *zion_capi = Py_None;
  static char *capi_kwlist[] = {"vd","r","k","zion","nr",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O:atomic_program.potrv",\
    capi_kwlist,&vd_capi,&r_capi,&k_capi,&zion_capi,&nr_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable vd */
  ;
  capi_vd_intent |= F2PY_INTENT_IN;
  capi_vd_tmp = array_from_pyobj(NPY_DOUBLE,vd_Dims,vd_Rank,capi_vd_intent,vd_capi);
  if (capi_vd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `vd' of atomic_program.potrv to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vd = (double *)(PyArray_DATA(capi_vd_tmp));

  /* Processing variable k */
    f2py_success = int_from_pyobj(&k,k_capi,"atomic_program.potrv() 3rd argument (k) can't be converted to int");
  if (f2py_success) {
  /* Processing variable zion */
    f2py_success = double_from_pyobj(&zion,zion_capi,"atomic_program.potrv() 4th argument (zion) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
  if (nr_capi == Py_None) nr = len(vd); else
    f2py_success = int_from_pyobj(&nr,nr_capi,"atomic_program.potrv() 1st keyword (nr) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(vd)>=nr,"len(vd)>=nr","1st keyword nr","potrv:nr=%d",nr) {
  /* Processing variable r */
  r_Dims[0]=nr;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `r' of atomic_program.potrv to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    r = (double *)(PyArray_DATA(capi_r_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(vd,r,&nr,&k,&zion);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*CHECKSCALAR(len(vd)>=nr)*/
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of zion*/
  /* End of cleaning variable zion */
  } /*if (f2py_success) of k*/
  /* End of cleaning variable k */
  if((PyObject *)capi_vd_tmp!=vd_capi) {
    Py_XDECREF(capi_vd_tmp); }
  }  /*if (capi_vd_tmp == NULL) ... else of vd*/
  /* End of cleaning variable vd */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of potrv ********************************/

/*********************************** potrvs ***********************************/
static char doc_f2py_rout_atomic_program_potrvs[] = "\
potrvs(vd,r,k,[nr])\n\nWrapper for ``potrvs``.\
\n\nParameters\n----------\n"
"vd : input rank-1 array('d') with bounds (nr)\n"
"r : input rank-1 array('d') with bounds (nr)\n"
"k : input int\n"
"\nOther Parameters\n----------------\n"
"nr : input int, optional\n    Default: len(vd)";
/* extern void F_FUNC(potrvs,POTRVS)(double*,double*,int*,int*); */
static PyObject *f2py_rout_atomic_program_potrvs(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *vd = NULL;
  npy_intp vd_Dims[1] = {-1};
  const int vd_Rank = 1;
  PyArrayObject *capi_vd_tmp = NULL;
  int capi_vd_intent = 0;
  PyObject *vd_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  int k = 0;
  PyObject *k_capi = Py_None;
  static char *capi_kwlist[] = {"vd","r","k","nr",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|O:atomic_program.potrvs",\
    capi_kwlist,&vd_capi,&r_capi,&k_capi,&nr_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable vd */
  ;
  capi_vd_intent |= F2PY_INTENT_IN;
  capi_vd_tmp = array_from_pyobj(NPY_DOUBLE,vd_Dims,vd_Rank,capi_vd_intent,vd_capi);
  if (capi_vd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `vd' of atomic_program.potrvs to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vd = (double *)(PyArray_DATA(capi_vd_tmp));

  /* Processing variable k */
    f2py_success = int_from_pyobj(&k,k_capi,"atomic_program.potrvs() 3rd argument (k) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nr */
  if (nr_capi == Py_None) nr = len(vd); else
    f2py_success = int_from_pyobj(&nr,nr_capi,"atomic_program.potrvs() 1st keyword (nr) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(vd)>=nr,"len(vd)>=nr","1st keyword nr","potrvs:nr=%d",nr) {
  /* Processing variable r */
  r_Dims[0]=nr;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `r' of atomic_program.potrvs to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    r = (double *)(PyArray_DATA(capi_r_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(vd,r,&nr,&k);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*CHECKSCALAR(len(vd)>=nr)*/
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of k*/
  /* End of cleaning variable k */
  if((PyObject *)capi_vd_tmp!=vd_capi) {
    Py_XDECREF(capi_vd_tmp); }
  }  /*if (capi_vd_tmp == NULL) ... else of vd*/
  /* End of cleaning variable vd */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of potrvs *******************************/

/*********************************** totalw ***********************************/
static char doc_f2py_rout_atomic_program_totalw[] = "\
totalw(i)\n\nWrapper for ``totalw``.\
\n\nParameters\n----------\n"
"i : input int";
/* extern void F_FUNC(totalw,TOTALW)(int*); */
static PyObject *f2py_rout_atomic_program_totalw(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int i = 0;
  PyObject *i_capi = Py_None;
  static char *capi_kwlist[] = {"i",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.totalw",\
    capi_kwlist,&i_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable i */
    f2py_success = int_from_pyobj(&i,i_capi,"atomic_program.totalw() 1st argument (i) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&i);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of i*/
  /* End of cleaning variable i */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of totalw *******************************/

/*********************************** potrw ***********************************/
static char doc_f2py_rout_atomic_program_potrw[] = "\
potrw(vd,r,k,kj,ist,rc,[nr])\n\nWrapper for ``potrw``.\
\n\nParameters\n----------\n"
"vd : input rank-1 array('d') with bounds (nr)\n"
"r : input rank-1 array('d') with bounds (nr)\n"
"k : input int\n"
"kj : input int\n"
"ist : input int\n"
"rc : input float\n"
"\nOther Parameters\n----------------\n"
"nr : input int, optional\n    Default: len(vd)";
/* extern void F_FUNC(potrw,POTRW)(double*,double*,int*,int*,int*,int*,double*); */
static PyObject *f2py_rout_atomic_program_potrw(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,int*,int*,int*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *vd = NULL;
  npy_intp vd_Dims[1] = {-1};
  const int vd_Rank = 1;
  PyArrayObject *capi_vd_tmp = NULL;
  int capi_vd_intent = 0;
  PyObject *vd_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  int k = 0;
  PyObject *k_capi = Py_None;
  int kj = 0;
  PyObject *kj_capi = Py_None;
  int ist = 0;
  PyObject *ist_capi = Py_None;
  double rc = 0;
  PyObject *rc_capi = Py_None;
  static char *capi_kwlist[] = {"vd","r","k","kj","ist","rc","nr",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOO|O:atomic_program.potrw",\
    capi_kwlist,&vd_capi,&r_capi,&k_capi,&kj_capi,&ist_capi,&rc_capi,&nr_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable vd */
  ;
  capi_vd_intent |= F2PY_INTENT_IN;
  capi_vd_tmp = array_from_pyobj(NPY_DOUBLE,vd_Dims,vd_Rank,capi_vd_intent,vd_capi);
  if (capi_vd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `vd' of atomic_program.potrw to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vd = (double *)(PyArray_DATA(capi_vd_tmp));

  /* Processing variable k */
    f2py_success = int_from_pyobj(&k,k_capi,"atomic_program.potrw() 3rd argument (k) can't be converted to int");
  if (f2py_success) {
  /* Processing variable kj */
    f2py_success = int_from_pyobj(&kj,kj_capi,"atomic_program.potrw() 4th argument (kj) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ist */
    f2py_success = int_from_pyobj(&ist,ist_capi,"atomic_program.potrw() 5th argument (ist) can't be converted to int");
  if (f2py_success) {
  /* Processing variable rc */
    f2py_success = double_from_pyobj(&rc,rc_capi,"atomic_program.potrw() 6th argument (rc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nr */
  if (nr_capi == Py_None) nr = len(vd); else
    f2py_success = int_from_pyobj(&nr,nr_capi,"atomic_program.potrw() 1st keyword (nr) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(vd)>=nr,"len(vd)>=nr","1st keyword nr","potrw:nr=%d",nr) {
  /* Processing variable r */
  r_Dims[0]=nr;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `r' of atomic_program.potrw to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    r = (double *)(PyArray_DATA(capi_r_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(vd,r,&nr,&k,&kj,&ist,&rc);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*CHECKSCALAR(len(vd)>=nr)*/
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of rc*/
  /* End of cleaning variable rc */
  } /*if (f2py_success) of ist*/
  /* End of cleaning variable ist */
  } /*if (f2py_success) of kj*/
  /* End of cleaning variable kj */
  } /*if (f2py_success) of k*/
  /* End of cleaning variable k */
  if((PyObject *)capi_vd_tmp!=vd_capi) {
    Py_XDECREF(capi_vd_tmp); }
  }  /*if (capi_vd_tmp == NULL) ... else of vd*/
  /* End of cleaning variable vd */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of potrw ********************************/

/*********************************** prdiff ***********************************/
static char doc_f2py_rout_atomic_program_prdiff[] = "\
prdiff(nconf,econf,jobold)\n\nWrapper for ``prdiff``.\
\n\nParameters\n----------\n"
"nconf : input int\n"
"econf : input rank-1 array('d') with bounds (100)\n"
"jobold : input int";
/* extern void F_FUNC(prdiff,PRDIFF)(int*,double*,int*); */
static PyObject *f2py_rout_atomic_program_prdiff(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nconf = 0;
  PyObject *nconf_capi = Py_None;
  double *econf = NULL;
  npy_intp econf_Dims[1] = {-1};
  const int econf_Rank = 1;
  PyArrayObject *capi_econf_tmp = NULL;
  int capi_econf_intent = 0;
  PyObject *econf_capi = Py_None;
  int jobold = 0;
  PyObject *jobold_capi = Py_None;
  static char *capi_kwlist[] = {"nconf","econf","jobold",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:atomic_program.prdiff",\
    capi_kwlist,&nconf_capi,&econf_capi,&jobold_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nconf */
    f2py_success = int_from_pyobj(&nconf,nconf_capi,"atomic_program.prdiff() 1st argument (nconf) can't be converted to int");
  if (f2py_success) {
  /* Processing variable econf */
  econf_Dims[0]=100;
  capi_econf_intent |= F2PY_INTENT_IN;
  capi_econf_tmp = array_from_pyobj(NPY_DOUBLE,econf_Dims,econf_Rank,capi_econf_intent,econf_capi);
  if (capi_econf_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `econf' of atomic_program.prdiff to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    econf = (double *)(PyArray_DATA(capi_econf_tmp));

  /* Processing variable jobold */
    f2py_success = int_from_pyobj(&jobold,jobold_capi,"atomic_program.prdiff() 3rd argument (jobold) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nconf,econf,&jobold);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of jobold*/
  /* End of cleaning variable jobold */
  if((PyObject *)capi_econf_tmp!=econf_capi) {
    Py_XDECREF(capi_econf_tmp); }
  }  /*if (capi_econf_tmp == NULL) ... else of econf*/
  /* End of cleaning variable econf */
  } /*if (f2py_success) of nconf*/
  /* End of cleaning variable nconf */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of prdiff *******************************/

/*********************************** chrlen ***********************************/
static char doc_f2py_rout_atomic_program_chrlen[] = "\
chrlen(string_bn,nchar,lchar)\n\nWrapper for ``chrlen``.\
\n\nParameters\n----------\n"
"string_bn : input string(len=-1)\n"
"nchar : input int\n"
"lchar : input int";
/* extern void F_FUNC(chrlen,CHRLEN)(string,int*,int*,size_t); */
static PyObject *f2py_rout_atomic_program_chrlen(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string string_bn = NULL;
  int slen(string_bn);
  PyObject *string_bn_capi = Py_None;
  int nchar = 0;
  PyObject *nchar_capi = Py_None;
  int lchar = 0;
  PyObject *lchar_capi = Py_None;
  static char *capi_kwlist[] = {"string_bn","nchar","lchar",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:atomic_program.chrlen",\
    capi_kwlist,&string_bn_capi,&nchar_capi,&lchar_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable string_bn */
  slen(string_bn) = -1;
  f2py_success = string_from_pyobj(&string_bn,&slen(string_bn),"",string_bn_capi,"string_from_pyobj failed in converting 1st argument `string_bn' of atomic_program.chrlen to C string");
  if (f2py_success) {
  /* Processing variable nchar */
    f2py_success = int_from_pyobj(&nchar,nchar_capi,"atomic_program.chrlen() 2nd argument (nchar) can't be converted to int");
  if (f2py_success) {
  /* Processing variable lchar */
    f2py_success = int_from_pyobj(&lchar,lchar_capi,"atomic_program.chrlen() 3rd argument (lchar) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(string_bn,&nchar,&lchar,slen(string_bn));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of lchar*/
  /* End of cleaning variable lchar */
  } /*if (f2py_success) of nchar*/
  /* End of cleaning variable nchar */
    STRINGFREE(string_bn);
  }  /*if (f2py_success) of string_bn*/
  /* End of cleaning variable string_bn */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of chrlen *******************************/

/*********************************** chrcap ***********************************/
static char doc_f2py_rout_atomic_program_chrcap[] = "\
chrcap(string_bn,nchar)\n\nWrapper for ``chrcap``.\
\n\nParameters\n----------\n"
"string_bn : input string(len=-1)\n"
"nchar : input int";
/* extern void F_FUNC(chrcap,CHRCAP)(string,int*,size_t); */
static PyObject *f2py_rout_atomic_program_chrcap(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string string_bn = NULL;
  int slen(string_bn);
  PyObject *string_bn_capi = Py_None;
  int nchar = 0;
  PyObject *nchar_capi = Py_None;
  static char *capi_kwlist[] = {"string_bn","nchar",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:atomic_program.chrcap",\
    capi_kwlist,&string_bn_capi,&nchar_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable string_bn */
  slen(string_bn) = -1;
  f2py_success = string_from_pyobj(&string_bn,&slen(string_bn),"",string_bn_capi,"string_from_pyobj failed in converting 1st argument `string_bn' of atomic_program.chrcap to C string");
  if (f2py_success) {
  /* Processing variable nchar */
    f2py_success = int_from_pyobj(&nchar,nchar_capi,"atomic_program.chrcap() 2nd argument (nchar) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(string_bn,&nchar,slen(string_bn));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of nchar*/
  /* End of cleaning variable nchar */
    STRINGFREE(string_bn);
  }  /*if (f2py_success) of string_bn*/
  /* End of cleaning variable string_bn */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of chrcap *******************************/

/************************************ leqi ************************************/
static char doc_f2py_rout_atomic_program_leqi[] = "\
leqi = leqi(strng1,strng2)\n\nWrapper for ``leqi``.\
\n\nParameters\n----------\n"
"strng1 : input string(len=-1)\n"
"strng2 : input string(len=-1)\n"
"\nReturns\n-------\n"
"leqi : int";
/* extern void F_WRAPPEDFUNC(leqi,LEQI)(int*,string,string,size_t,size_t); */
static PyObject *f2py_rout_atomic_program_leqi(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,string,string,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int leqi = 0;
  string strng1 = NULL;
  int slen(strng1);
  PyObject *strng1_capi = Py_None;
  string strng2 = NULL;
  int slen(strng2);
  PyObject *strng2_capi = Py_None;
  static char *capi_kwlist[] = {"strng1","strng2",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:atomic_program.leqi",\
    capi_kwlist,&strng1_capi,&strng2_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable strng1 */
  slen(strng1) = -1;
  f2py_success = string_from_pyobj(&strng1,&slen(strng1),"",strng1_capi,"string_from_pyobj failed in converting 1st argument `strng1' of atomic_program.leqi to C string");
  if (f2py_success) {
  /* Processing variable strng2 */
  slen(strng2) = -1;
  f2py_success = string_from_pyobj(&strng2,&slen(strng2),"",strng2_capi,"string_from_pyobj failed in converting 2nd argument `strng2' of atomic_program.leqi to C string");
  if (f2py_success) {
  /* Processing variable leqi */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&leqi,strng1,strng2,slen(strng1),slen(strng2));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",leqi);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable leqi */
    STRINGFREE(strng2);
  }  /*if (f2py_success) of strng2*/
  /* End of cleaning variable strng2 */
    STRINGFREE(strng1);
  }  /*if (f2py_success) of strng1*/
  /* End of cleaning variable strng1 */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of leqi ********************************/

/********************************** loc_des **********************************/
static char doc_f2py_rout_atomic_program_loc_des[] = "\
loc_des(message)\n\nWrapper for ``loc_des``.\
\n\nParameters\n----------\n"
"message : input string(len=-1)";
/* extern void F_FUNC_US(loc_des,LOC_DES)(string,size_t); */
static PyObject *f2py_rout_atomic_program_loc_des(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string message = NULL;
  int slen(message);
  PyObject *message_capi = Py_None;
  static char *capi_kwlist[] = {"message",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.loc_des",\
    capi_kwlist,&message_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable message */
  slen(message) = -1;
  f2py_success = string_from_pyobj(&message,&slen(message),"",message_capi,"string_from_pyobj failed in converting 1st argument `message' of atomic_program.loc_des to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(message,slen(message));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(message);
  }  /*if (f2py_success) of message*/
  /* End of cleaning variable message */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of loc_des *******************************/

/*********************************** zbrac ***********************************/
static char doc_f2py_rout_atomic_program_zbrac[] = "\
zbrac(func,x1,x2,succes,[func_extra_args])\n\nWrapper for ``zbrac``.\
\n\nParameters\n----------\n"
"func : call-back function\n"
"x1 : input float\n"
"x2 : input float\n"
"succes : input int\n"
"\nOther Parameters\n----------------\n"
"func_extra_args : input tuple, optional\n    Default: ()\n"
"\nNotes\n-----\nCall-back functions::\n\n"
"  def func(x1): return f1\n\
  Required arguments:\n"
"    x1 : input float\n"
"  Return objects:\n"
"    f1 : float";
/* extern void F_FUNC(zbrac,ZBRAC)(cb_func_in_zbrac__user__routines_typedef,double*,double*,int*); */
static PyObject *f2py_rout_atomic_program_zbrac(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(cb_func_in_zbrac__user__routines_typedef,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  PyObject *func_capi = Py_None;
  PyTupleObject *func_xa_capi = NULL;
  PyTupleObject *func_args_capi = NULL;
  int func_nofargs_capi = 0;
  cb_func_in_zbrac__user__routines_typedef func_cptr;
  double x1 = 0;
  PyObject *x1_capi = Py_None;
  double x2 = 0;
  PyObject *x2_capi = Py_None;
  int succes = 0;
  PyObject *succes_capi = Py_None;
  static char *capi_kwlist[] = {"func","x1","x2","succes","func_extra_args",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O!:atomic_program.zbrac",\
    capi_kwlist,&func_capi,&x1_capi,&x2_capi,&succes_capi,&PyTuple_Type,&func_xa_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable func */
if(F2PyCapsule_Check(func_capi)) {
  func_cptr = F2PyCapsule_AsVoidPtr(func_capi);
} else {
  func_cptr = cb_func_in_zbrac__user__routines;
}

  func_nofargs_capi = cb_func_in_zbrac__user__routines_nofargs;
  if (create_cb_arglist(func_capi,func_xa_capi,1,0,&cb_func_in_zbrac__user__routines_nofargs,&func_args_capi,"failed in processing argument list for call-back func.")) {
    jmp_buf func_jmpbuf;
    CFUNCSMESS("Saving jmpbuf for `func`.\n");
    SWAP(func_capi,cb_func_in_zbrac__user__routines_capi,PyObject);
    SWAP(func_args_capi,cb_func_in_zbrac__user__routines_args_capi,PyTupleObject);
    memcpy(&func_jmpbuf,&cb_func_in_zbrac__user__routines_jmpbuf,sizeof(jmp_buf));
  /* Processing variable x1 */
    f2py_success = double_from_pyobj(&x1,x1_capi,"atomic_program.zbrac() 2nd argument (x1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable x2 */
    f2py_success = double_from_pyobj(&x2,x2_capi,"atomic_program.zbrac() 3rd argument (x2) can't be converted to double");
  if (f2py_success) {
  /* Processing variable succes */
    succes = (int)PyObject_IsTrue(succes_capi);
    f2py_success = 1;
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
    if ((setjmp(cb_func_in_zbrac__user__routines_jmpbuf))) {
      f2py_success = 0;
    } else {
        (*f2py_func)(func_cptr,&x1,&x2,&succes);
    }
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of succes*/
  /* End of cleaning variable succes */
  } /*if (f2py_success) of x2*/
  /* End of cleaning variable x2 */
  } /*if (f2py_success) of x1*/
  /* End of cleaning variable x1 */
    CFUNCSMESS("Restoring jmpbuf for `func`.\n");
    cb_func_in_zbrac__user__routines_capi = func_capi;
    Py_DECREF(cb_func_in_zbrac__user__routines_args_capi);
    cb_func_in_zbrac__user__routines_args_capi = func_args_capi;
    cb_func_in_zbrac__user__routines_nofargs = func_nofargs_capi;
    memcpy(&cb_func_in_zbrac__user__routines_jmpbuf,&func_jmpbuf,sizeof(jmp_buf));
  }
  /* End of cleaning variable func */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of zbrac ********************************/

/*********************************** zbrak ***********************************/
static char doc_f2py_rout_atomic_program_zbrak[] = "\
zbrak(fx,x1,x2,n,xb1,xb2,nb,[fx_extra_args])\n\nWrapper for ``zbrak``.\
\n\nParameters\n----------\n"
"fx : call-back function\n"
"x1 : input float\n"
"x2 : input float\n"
"n : input int\n"
"xb1 : input rank-1 array('d') with bounds (1)\n"
"xb2 : input rank-1 array('d') with bounds (1)\n"
"nb : input int\n"
"\nOther Parameters\n----------------\n"
"fx_extra_args : input tuple, optional\n    Default: ()\n"
"\nNotes\n-----\nCall-back functions::\n\n"
"  def fx(x): return fp\n\
  Required arguments:\n"
"    x : input float\n"
"  Return objects:\n"
"    fp : float";
/* extern void F_FUNC(zbrak,ZBRAK)(cb_fx_in_zbrak__user__routines_typedef,double*,double*,int*,double*,double*,int*); */
static PyObject *f2py_rout_atomic_program_zbrak(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(cb_fx_in_zbrak__user__routines_typedef,double*,double*,int*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  PyObject *fx_capi = Py_None;
  PyTupleObject *fx_xa_capi = NULL;
  PyTupleObject *fx_args_capi = NULL;
  int fx_nofargs_capi = 0;
  cb_fx_in_zbrak__user__routines_typedef fx_cptr;
  double x1 = 0;
  PyObject *x1_capi = Py_None;
  double x2 = 0;
  PyObject *x2_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double *xb1 = NULL;
  npy_intp xb1_Dims[1] = {-1};
  const int xb1_Rank = 1;
  PyArrayObject *capi_xb1_tmp = NULL;
  int capi_xb1_intent = 0;
  PyObject *xb1_capi = Py_None;
  double *xb2 = NULL;
  npy_intp xb2_Dims[1] = {-1};
  const int xb2_Rank = 1;
  PyArrayObject *capi_xb2_tmp = NULL;
  int capi_xb2_intent = 0;
  PyObject *xb2_capi = Py_None;
  int nb = 0;
  PyObject *nb_capi = Py_None;
  static char *capi_kwlist[] = {"fx","x1","x2","n","xb1","xb2","nb","fx_extra_args",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOO|O!:atomic_program.zbrak",\
    capi_kwlist,&fx_capi,&x1_capi,&x2_capi,&n_capi,&xb1_capi,&xb2_capi,&nb_capi,&PyTuple_Type,&fx_xa_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable fx */
if(F2PyCapsule_Check(fx_capi)) {
  fx_cptr = F2PyCapsule_AsVoidPtr(fx_capi);
} else {
  fx_cptr = cb_fx_in_zbrak__user__routines;
}

  fx_nofargs_capi = cb_fx_in_zbrak__user__routines_nofargs;
  if (create_cb_arglist(fx_capi,fx_xa_capi,1,0,&cb_fx_in_zbrak__user__routines_nofargs,&fx_args_capi,"failed in processing argument list for call-back fx.")) {
    jmp_buf fx_jmpbuf;
    CFUNCSMESS("Saving jmpbuf for `fx`.\n");
    SWAP(fx_capi,cb_fx_in_zbrak__user__routines_capi,PyObject);
    SWAP(fx_args_capi,cb_fx_in_zbrak__user__routines_args_capi,PyTupleObject);
    memcpy(&fx_jmpbuf,&cb_fx_in_zbrak__user__routines_jmpbuf,sizeof(jmp_buf));
  /* Processing variable x1 */
    f2py_success = double_from_pyobj(&x1,x1_capi,"atomic_program.zbrak() 2nd argument (x1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable x2 */
    f2py_success = double_from_pyobj(&x2,x2_capi,"atomic_program.zbrak() 3rd argument (x2) can't be converted to double");
  if (f2py_success) {
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.zbrak() 4th argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable xb1 */
  xb1_Dims[0]=1;
  capi_xb1_intent |= F2PY_INTENT_IN;
  capi_xb1_tmp = array_from_pyobj(NPY_DOUBLE,xb1_Dims,xb1_Rank,capi_xb1_intent,xb1_capi);
  if (capi_xb1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `xb1' of atomic_program.zbrak to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    xb1 = (double *)(PyArray_DATA(capi_xb1_tmp));

  /* Processing variable xb2 */
  xb2_Dims[0]=1;
  capi_xb2_intent |= F2PY_INTENT_IN;
  capi_xb2_tmp = array_from_pyobj(NPY_DOUBLE,xb2_Dims,xb2_Rank,capi_xb2_intent,xb2_capi);
  if (capi_xb2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `xb2' of atomic_program.zbrak to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    xb2 = (double *)(PyArray_DATA(capi_xb2_tmp));

  /* Processing variable nb */
    f2py_success = int_from_pyobj(&nb,nb_capi,"atomic_program.zbrak() 7th argument (nb) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
    if ((setjmp(cb_fx_in_zbrak__user__routines_jmpbuf))) {
      f2py_success = 0;
    } else {
        (*f2py_func)(fx_cptr,&x1,&x2,&n,xb1,xb2,&nb);
    }
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of nb*/
  /* End of cleaning variable nb */
  if((PyObject *)capi_xb2_tmp!=xb2_capi) {
    Py_XDECREF(capi_xb2_tmp); }
  }  /*if (capi_xb2_tmp == NULL) ... else of xb2*/
  /* End of cleaning variable xb2 */
  if((PyObject *)capi_xb1_tmp!=xb1_capi) {
    Py_XDECREF(capi_xb1_tmp); }
  }  /*if (capi_xb1_tmp == NULL) ... else of xb1*/
  /* End of cleaning variable xb1 */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of x2*/
  /* End of cleaning variable x2 */
  } /*if (f2py_success) of x1*/
  /* End of cleaning variable x1 */
    CFUNCSMESS("Restoring jmpbuf for `fx`.\n");
    cb_fx_in_zbrak__user__routines_capi = fx_capi;
    Py_DECREF(cb_fx_in_zbrak__user__routines_args_capi);
    cb_fx_in_zbrak__user__routines_args_capi = fx_args_capi;
    cb_fx_in_zbrak__user__routines_nofargs = fx_nofargs_capi;
    memcpy(&cb_fx_in_zbrak__user__routines_jmpbuf,&fx_jmpbuf,sizeof(jmp_buf));
  }
  /* End of cleaning variable fx */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of zbrak ********************************/

/*********************************** zbrent ***********************************/
static char doc_f2py_rout_atomic_program_zbrent[] = "\
zbrent = zbrent(func,x1,x2,tol,[func_extra_args])\n\nWrapper for ``zbrent``.\
\n\nParameters\n----------\n"
"func : call-back function\n"
"x1 : input float\n"
"x2 : input float\n"
"tol : input float\n"
"\nOther Parameters\n----------------\n"
"func_extra_args : input tuple, optional\n    Default: ()\n"
"\nReturns\n-------\n"
"zbrent : float\n"
"\nNotes\n-----\nCall-back functions::\n\n"
"  def func(a): return fa\n\
  Required arguments:\n"
"    a : input float\n"
"  Return objects:\n"
"    fa : float";
/* extern void F_WRAPPEDFUNC(zbrent,ZBRENT)(double*,cb_func_in_zbrent__user__routines_typedef,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_zbrent(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,cb_func_in_zbrent__user__routines_typedef,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double zbrent = 0;
  PyObject *func_capi = Py_None;
  PyTupleObject *func_xa_capi = NULL;
  PyTupleObject *func_args_capi = NULL;
  int func_nofargs_capi = 0;
  cb_func_in_zbrent__user__routines_typedef func_cptr;
  double x1 = 0;
  PyObject *x1_capi = Py_None;
  double x2 = 0;
  PyObject *x2_capi = Py_None;
  double tol = 0;
  PyObject *tol_capi = Py_None;
  static char *capi_kwlist[] = {"func","x1","x2","tol","func_extra_args",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O!:atomic_program.zbrent",\
    capi_kwlist,&func_capi,&x1_capi,&x2_capi,&tol_capi,&PyTuple_Type,&func_xa_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable func */
if(F2PyCapsule_Check(func_capi)) {
  func_cptr = F2PyCapsule_AsVoidPtr(func_capi);
} else {
  func_cptr = cb_func_in_zbrent__user__routines;
}

  func_nofargs_capi = cb_func_in_zbrent__user__routines_nofargs;
  if (create_cb_arglist(func_capi,func_xa_capi,1,0,&cb_func_in_zbrent__user__routines_nofargs,&func_args_capi,"failed in processing argument list for call-back func.")) {
    jmp_buf func_jmpbuf;
    CFUNCSMESS("Saving jmpbuf for `func`.\n");
    SWAP(func_capi,cb_func_in_zbrent__user__routines_capi,PyObject);
    SWAP(func_args_capi,cb_func_in_zbrent__user__routines_args_capi,PyTupleObject);
    memcpy(&func_jmpbuf,&cb_func_in_zbrent__user__routines_jmpbuf,sizeof(jmp_buf));
  /* Processing variable x1 */
    f2py_success = double_from_pyobj(&x1,x1_capi,"atomic_program.zbrent() 2nd argument (x1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable x2 */
    f2py_success = double_from_pyobj(&x2,x2_capi,"atomic_program.zbrent() 3rd argument (x2) can't be converted to double");
  if (f2py_success) {
  /* Processing variable tol */
    f2py_success = double_from_pyobj(&tol,tol_capi,"atomic_program.zbrent() 4th argument (tol) can't be converted to double");
  if (f2py_success) {
  /* Processing variable zbrent */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  if ((setjmp(cb_func_in_zbrent__user__routines_jmpbuf))) {
    f2py_success = 0;
  } else {
  (*f2py_func)(&zbrent,func_cptr,&x1,&x2,&tol);
  }
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",zbrent);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable zbrent */
  } /*if (f2py_success) of tol*/
  /* End of cleaning variable tol */
  } /*if (f2py_success) of x2*/
  /* End of cleaning variable x2 */
  } /*if (f2py_success) of x1*/
  /* End of cleaning variable x1 */
    CFUNCSMESS("Restoring jmpbuf for `func`.\n");
    cb_func_in_zbrent__user__routines_capi = func_capi;
    Py_DECREF(cb_func_in_zbrent__user__routines_args_capi);
    cb_func_in_zbrent__user__routines_args_capi = func_args_capi;
    cb_func_in_zbrent__user__routines_nofargs = func_nofargs_capi;
    memcpy(&cb_func_in_zbrent__user__routines_jmpbuf,&func_jmpbuf,sizeof(jmp_buf));
  }
  /* End of cleaning variable func */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of zbrent *******************************/

/*********************************** rtbis ***********************************/
static char doc_f2py_rout_atomic_program_rtbis[] = "\
rtbis = rtbis(func,x1,x2,xacc,[func_extra_args])\n\nWrapper for ``rtbis``.\
\n\nParameters\n----------\n"
"func : call-back function\n"
"x1 : input float\n"
"x2 : input float\n"
"xacc : input float\n"
"\nOther Parameters\n----------------\n"
"func_extra_args : input tuple, optional\n    Default: ()\n"
"\nReturns\n-------\n"
"rtbis : float\n"
"\nNotes\n-----\nCall-back functions::\n\n"
"  def func(x2): return fmid\n\
  Required arguments:\n"
"    x2 : input float\n"
"  Return objects:\n"
"    fmid : float";
/* extern void F_WRAPPEDFUNC(rtbis,RTBIS)(double*,cb_func_in_rtbis__user__routines_typedef,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_rtbis(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,cb_func_in_rtbis__user__routines_typedef,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double rtbis = 0;
  PyObject *func_capi = Py_None;
  PyTupleObject *func_xa_capi = NULL;
  PyTupleObject *func_args_capi = NULL;
  int func_nofargs_capi = 0;
  cb_func_in_rtbis__user__routines_typedef func_cptr;
  double x1 = 0;
  PyObject *x1_capi = Py_None;
  double x2 = 0;
  PyObject *x2_capi = Py_None;
  double xacc = 0;
  PyObject *xacc_capi = Py_None;
  static char *capi_kwlist[] = {"func","x1","x2","xacc","func_extra_args",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O!:atomic_program.rtbis",\
    capi_kwlist,&func_capi,&x1_capi,&x2_capi,&xacc_capi,&PyTuple_Type,&func_xa_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable func */
if(F2PyCapsule_Check(func_capi)) {
  func_cptr = F2PyCapsule_AsVoidPtr(func_capi);
} else {
  func_cptr = cb_func_in_rtbis__user__routines;
}

  func_nofargs_capi = cb_func_in_rtbis__user__routines_nofargs;
  if (create_cb_arglist(func_capi,func_xa_capi,1,0,&cb_func_in_rtbis__user__routines_nofargs,&func_args_capi,"failed in processing argument list for call-back func.")) {
    jmp_buf func_jmpbuf;
    CFUNCSMESS("Saving jmpbuf for `func`.\n");
    SWAP(func_capi,cb_func_in_rtbis__user__routines_capi,PyObject);
    SWAP(func_args_capi,cb_func_in_rtbis__user__routines_args_capi,PyTupleObject);
    memcpy(&func_jmpbuf,&cb_func_in_rtbis__user__routines_jmpbuf,sizeof(jmp_buf));
  /* Processing variable x1 */
    f2py_success = double_from_pyobj(&x1,x1_capi,"atomic_program.rtbis() 2nd argument (x1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable x2 */
    f2py_success = double_from_pyobj(&x2,x2_capi,"atomic_program.rtbis() 3rd argument (x2) can't be converted to double");
  if (f2py_success) {
  /* Processing variable xacc */
    f2py_success = double_from_pyobj(&xacc,xacc_capi,"atomic_program.rtbis() 4th argument (xacc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable rtbis */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  if ((setjmp(cb_func_in_rtbis__user__routines_jmpbuf))) {
    f2py_success = 0;
  } else {
  (*f2py_func)(&rtbis,func_cptr,&x1,&x2,&xacc);
  }
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",rtbis);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable rtbis */
  } /*if (f2py_success) of xacc*/
  /* End of cleaning variable xacc */
  } /*if (f2py_success) of x2*/
  /* End of cleaning variable x2 */
  } /*if (f2py_success) of x1*/
  /* End of cleaning variable x1 */
    CFUNCSMESS("Restoring jmpbuf for `func`.\n");
    cb_func_in_rtbis__user__routines_capi = func_capi;
    Py_DECREF(cb_func_in_rtbis__user__routines_args_capi);
    cb_func_in_rtbis__user__routines_args_capi = func_args_capi;
    cb_func_in_rtbis__user__routines_nofargs = func_nofargs_capi;
    memcpy(&cb_func_in_rtbis__user__routines_jmpbuf,&func_jmpbuf,sizeof(jmp_buf));
  }
  /* End of cleaning variable func */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of rtbis ********************************/

/************************************ brac ************************************/
static char doc_f2py_rout_atomic_program_brac[] = "\
brac(func,x1,x2,succes,[func_extra_args])\n\nWrapper for ``brac``.\
\n\nParameters\n----------\n"
"func : call-back function\n"
"x1 : input float\n"
"x2 : input float\n"
"succes : input int\n"
"\nOther Parameters\n----------------\n"
"func_extra_args : input tuple, optional\n    Default: ()\n"
"\nNotes\n-----\nCall-back functions::\n\n"
"  def func(x1): return f1\n\
  Required arguments:\n"
"    x1 : input float\n"
"  Return objects:\n"
"    f1 : float";
/* extern void F_FUNC(brac,BRAC)(cb_func_in_brac__user__routines_typedef,double*,double*,int*); */
static PyObject *f2py_rout_atomic_program_brac(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(cb_func_in_brac__user__routines_typedef,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  PyObject *func_capi = Py_None;
  PyTupleObject *func_xa_capi = NULL;
  PyTupleObject *func_args_capi = NULL;
  int func_nofargs_capi = 0;
  cb_func_in_brac__user__routines_typedef func_cptr;
  double x1 = 0;
  PyObject *x1_capi = Py_None;
  double x2 = 0;
  PyObject *x2_capi = Py_None;
  int succes = 0;
  PyObject *succes_capi = Py_None;
  static char *capi_kwlist[] = {"func","x1","x2","succes","func_extra_args",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O!:atomic_program.brac",\
    capi_kwlist,&func_capi,&x1_capi,&x2_capi,&succes_capi,&PyTuple_Type,&func_xa_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable func */
if(F2PyCapsule_Check(func_capi)) {
  func_cptr = F2PyCapsule_AsVoidPtr(func_capi);
} else {
  func_cptr = cb_func_in_brac__user__routines;
}

  func_nofargs_capi = cb_func_in_brac__user__routines_nofargs;
  if (create_cb_arglist(func_capi,func_xa_capi,1,0,&cb_func_in_brac__user__routines_nofargs,&func_args_capi,"failed in processing argument list for call-back func.")) {
    jmp_buf func_jmpbuf;
    CFUNCSMESS("Saving jmpbuf for `func`.\n");
    SWAP(func_capi,cb_func_in_brac__user__routines_capi,PyObject);
    SWAP(func_args_capi,cb_func_in_brac__user__routines_args_capi,PyTupleObject);
    memcpy(&func_jmpbuf,&cb_func_in_brac__user__routines_jmpbuf,sizeof(jmp_buf));
  /* Processing variable x1 */
    f2py_success = double_from_pyobj(&x1,x1_capi,"atomic_program.brac() 2nd argument (x1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable x2 */
    f2py_success = double_from_pyobj(&x2,x2_capi,"atomic_program.brac() 3rd argument (x2) can't be converted to double");
  if (f2py_success) {
  /* Processing variable succes */
    succes = (int)PyObject_IsTrue(succes_capi);
    f2py_success = 1;
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
    if ((setjmp(cb_func_in_brac__user__routines_jmpbuf))) {
      f2py_success = 0;
    } else {
        (*f2py_func)(func_cptr,&x1,&x2,&succes);
    }
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of succes*/
  /* End of cleaning variable succes */
  } /*if (f2py_success) of x2*/
  /* End of cleaning variable x2 */
  } /*if (f2py_success) of x1*/
  /* End of cleaning variable x1 */
    CFUNCSMESS("Restoring jmpbuf for `func`.\n");
    cb_func_in_brac__user__routines_capi = func_capi;
    Py_DECREF(cb_func_in_brac__user__routines_args_capi);
    cb_func_in_brac__user__routines_args_capi = func_args_capi;
    cb_func_in_brac__user__routines_nofargs = func_nofargs_capi;
    memcpy(&cb_func_in_brac__user__routines_jmpbuf,&func_jmpbuf,sizeof(jmp_buf));
  }
  /* End of cleaning variable func */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of brac ********************************/

/*********************************** brent ***********************************/
static char doc_f2py_rout_atomic_program_brent[] = "\
brent = brent(func,x1,x2,tol,[func_extra_args])\n\nWrapper for ``brent``.\
\n\nParameters\n----------\n"
"func : call-back function\n"
"x1 : input float\n"
"x2 : input float\n"
"tol : input float\n"
"\nOther Parameters\n----------------\n"
"func_extra_args : input tuple, optional\n    Default: ()\n"
"\nReturns\n-------\n"
"brent : float\n"
"\nNotes\n-----\nCall-back functions::\n\n"
"  def func(a): return fa\n\
  Required arguments:\n"
"    a : input float\n"
"  Return objects:\n"
"    fa : float";
/* extern void F_WRAPPEDFUNC(brent,BRENT)(double*,cb_func_in_brent__user__routines_typedef,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_brent(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,cb_func_in_brent__user__routines_typedef,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double brent = 0;
  PyObject *func_capi = Py_None;
  PyTupleObject *func_xa_capi = NULL;
  PyTupleObject *func_args_capi = NULL;
  int func_nofargs_capi = 0;
  cb_func_in_brent__user__routines_typedef func_cptr;
  double x1 = 0;
  PyObject *x1_capi = Py_None;
  double x2 = 0;
  PyObject *x2_capi = Py_None;
  double tol = 0;
  PyObject *tol_capi = Py_None;
  static char *capi_kwlist[] = {"func","x1","x2","tol","func_extra_args",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O!:atomic_program.brent",\
    capi_kwlist,&func_capi,&x1_capi,&x2_capi,&tol_capi,&PyTuple_Type,&func_xa_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable func */
if(F2PyCapsule_Check(func_capi)) {
  func_cptr = F2PyCapsule_AsVoidPtr(func_capi);
} else {
  func_cptr = cb_func_in_brent__user__routines;
}

  func_nofargs_capi = cb_func_in_brent__user__routines_nofargs;
  if (create_cb_arglist(func_capi,func_xa_capi,1,0,&cb_func_in_brent__user__routines_nofargs,&func_args_capi,"failed in processing argument list for call-back func.")) {
    jmp_buf func_jmpbuf;
    CFUNCSMESS("Saving jmpbuf for `func`.\n");
    SWAP(func_capi,cb_func_in_brent__user__routines_capi,PyObject);
    SWAP(func_args_capi,cb_func_in_brent__user__routines_args_capi,PyTupleObject);
    memcpy(&func_jmpbuf,&cb_func_in_brent__user__routines_jmpbuf,sizeof(jmp_buf));
  /* Processing variable x1 */
    f2py_success = double_from_pyobj(&x1,x1_capi,"atomic_program.brent() 2nd argument (x1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable x2 */
    f2py_success = double_from_pyobj(&x2,x2_capi,"atomic_program.brent() 3rd argument (x2) can't be converted to double");
  if (f2py_success) {
  /* Processing variable tol */
    f2py_success = double_from_pyobj(&tol,tol_capi,"atomic_program.brent() 4th argument (tol) can't be converted to double");
  if (f2py_success) {
  /* Processing variable brent */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  if ((setjmp(cb_func_in_brent__user__routines_jmpbuf))) {
    f2py_success = 0;
  } else {
  (*f2py_func)(&brent,func_cptr,&x1,&x2,&tol);
  }
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",brent);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable brent */
  } /*if (f2py_success) of tol*/
  /* End of cleaning variable tol */
  } /*if (f2py_success) of x2*/
  /* End of cleaning variable x2 */
  } /*if (f2py_success) of x1*/
  /* End of cleaning variable x1 */
    CFUNCSMESS("Restoring jmpbuf for `func`.\n");
    cb_func_in_brent__user__routines_capi = func_capi;
    Py_DECREF(cb_func_in_brent__user__routines_args_capi);
    cb_func_in_brent__user__routines_args_capi = func_args_capi;
    cb_func_in_brent__user__routines_nofargs = func_nofargs_capi;
    memcpy(&cb_func_in_brent__user__routines_jmpbuf,&func_jmpbuf,sizeof(jmp_buf));
  }
  /* End of cleaning variable func */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of brent ********************************/

/*********************************** genrhs ***********************************/
static char doc_f2py_rout_atomic_program_genrhs[] = "\
genrhs(gamma,delta,y)\n\nWrapper for ``genrhs``.\
\n\nParameters\n----------\n"
"gamma : input float\n"
"delta : input float\n"
"y : input rank-1 array('d') with bounds (5)";
/* extern void F_FUNC(genrhs,GENRHS)(double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_genrhs(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double gamma = 0;
  PyObject *gamma_capi = Py_None;
  double delta = 0;
  PyObject *delta_capi = Py_None;
  double *y = NULL;
  npy_intp y_Dims[1] = {-1};
  const int y_Rank = 1;
  PyArrayObject *capi_y_tmp = NULL;
  int capi_y_intent = 0;
  PyObject *y_capi = Py_None;
  static char *capi_kwlist[] = {"gamma","delta","y",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:atomic_program.genrhs",\
    capi_kwlist,&gamma_capi,&delta_capi,&y_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable gamma */
    f2py_success = double_from_pyobj(&gamma,gamma_capi,"atomic_program.genrhs() 1st argument (gamma) can't be converted to double");
  if (f2py_success) {
  /* Processing variable delta */
    f2py_success = double_from_pyobj(&delta,delta_capi,"atomic_program.genrhs() 2nd argument (delta) can't be converted to double");
  if (f2py_success) {
  /* Processing variable y */
  y_Dims[0]=5;
  capi_y_intent |= F2PY_INTENT_IN;
  capi_y_tmp = array_from_pyobj(NPY_DOUBLE,y_Dims,y_Rank,capi_y_intent,y_capi);
  if (capi_y_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `y' of atomic_program.genrhs to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    y = (double *)(PyArray_DATA(capi_y_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&gamma,&delta,y);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_y_tmp!=y_capi) {
    Py_XDECREF(capi_y_tmp); }
  }  /*if (capi_y_tmp == NULL) ... else of y*/
  /* End of cleaning variable y */
  } /*if (f2py_success) of delta*/
  /* End of cleaning variable delta */
  } /*if (f2py_success) of gamma*/
  /* End of cleaning variable gamma */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of genrhs *******************************/

/*********************************** logder ***********************************/
static char doc_f2py_rout_atomic_program_logder[] = "\
logder(nfirst,nlast,flag)\n\nWrapper for ``logder``.\
\n\nParameters\n----------\n"
"nfirst : input int\n"
"nlast : input int\n"
"flag : input string(len=2)";
/* extern void F_FUNC(logder,LOGDER)(int*,int*,string,size_t); */
static PyObject *f2py_rout_atomic_program_logder(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nfirst = 0;
  PyObject *nfirst_capi = Py_None;
  int nlast = 0;
  PyObject *nlast_capi = Py_None;
  string flag = NULL;
  int slen(flag);
  PyObject *flag_capi = Py_None;
  static char *capi_kwlist[] = {"nfirst","nlast","flag",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:atomic_program.logder",\
    capi_kwlist,&nfirst_capi,&nlast_capi,&flag_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nfirst */
    f2py_success = int_from_pyobj(&nfirst,nfirst_capi,"atomic_program.logder() 1st argument (nfirst) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nlast */
    f2py_success = int_from_pyobj(&nlast,nlast_capi,"atomic_program.logder() 2nd argument (nlast) can't be converted to int");
  if (f2py_success) {
  /* Processing variable flag */
  slen(flag) = 2;
  f2py_success = string_from_pyobj(&flag,&slen(flag),"",flag_capi,"string_from_pyobj failed in converting 3rd argument `flag' of atomic_program.logder to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nfirst,&nlast,flag,slen(flag));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(flag);
  }  /*if (f2py_success) of flag*/
  /* End of cleaning variable flag */
  } /*if (f2py_success) of nlast*/
  /* End of cleaning variable nlast */
  } /*if (f2py_success) of nfirst*/
  /* End of cleaning variable nfirst */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of logder *******************************/

/************************************ ode ************************************/
static char doc_f2py_rout_atomic_program_ode[] = "\
ode(x,y,dxdy)\n\nWrapper for ``ode``.\
\n\nParameters\n----------\n"
"x : input float\n"
"y : input rank-1 array('d') with bounds (2)\n"
"dxdy : input rank-1 array('d') with bounds (2)";
/* extern void F_FUNC(ode,ODE)(double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_ode(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double x = 0;
  PyObject *x_capi = Py_None;
  double *y = NULL;
  npy_intp y_Dims[1] = {-1};
  const int y_Rank = 1;
  PyArrayObject *capi_y_tmp = NULL;
  int capi_y_intent = 0;
  PyObject *y_capi = Py_None;
  double *dxdy = NULL;
  npy_intp dxdy_Dims[1] = {-1};
  const int dxdy_Rank = 1;
  PyArrayObject *capi_dxdy_tmp = NULL;
  int capi_dxdy_intent = 0;
  PyObject *dxdy_capi = Py_None;
  static char *capi_kwlist[] = {"x","y","dxdy",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:atomic_program.ode",\
    capi_kwlist,&x_capi,&y_capi,&dxdy_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable x */
    f2py_success = double_from_pyobj(&x,x_capi,"atomic_program.ode() 1st argument (x) can't be converted to double");
  if (f2py_success) {
  /* Processing variable y */
  y_Dims[0]=2;
  capi_y_intent |= F2PY_INTENT_IN;
  capi_y_tmp = array_from_pyobj(NPY_DOUBLE,y_Dims,y_Rank,capi_y_intent,y_capi);
  if (capi_y_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `y' of atomic_program.ode to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    y = (double *)(PyArray_DATA(capi_y_tmp));

  /* Processing variable dxdy */
  dxdy_Dims[0]=2;
  capi_dxdy_intent |= F2PY_INTENT_IN;
  capi_dxdy_tmp = array_from_pyobj(NPY_DOUBLE,dxdy_Dims,dxdy_Rank,capi_dxdy_intent,dxdy_capi);
  if (capi_dxdy_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `dxdy' of atomic_program.ode to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dxdy = (double *)(PyArray_DATA(capi_dxdy_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&x,y,dxdy);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dxdy_tmp!=dxdy_capi) {
    Py_XDECREF(capi_dxdy_tmp); }
  }  /*if (capi_dxdy_tmp == NULL) ... else of dxdy*/
  /* End of cleaning variable dxdy */
  if((PyObject *)capi_y_tmp!=y_capi) {
    Py_XDECREF(capi_y_tmp); }
  }  /*if (capi_y_tmp == NULL) ... else of y*/
  /* End of cleaning variable y */
  } /*if (f2py_success) of x*/
  /* End of cleaning variable x */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of ode *********************************/

/********************************** denplot **********************************/
static char doc_f2py_rout_atomic_program_denplot[] = "\
denplot()\n\nWrapper for ``denplot``.\
\n";
/* extern void F_FUNC(denplot,DENPLOT)(void); */
static PyObject *f2py_rout_atomic_program_denplot(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:atomic_program.denplot",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of denplot *******************************/

/*********************************** saxpy ***********************************/
static char doc_f2py_rout_atomic_program_saxpy[] = "\
saxpy(n,sa,sx,incx,sy,incy)\n\nWrapper for ``saxpy``.\
\n\nParameters\n----------\n"
"n : input int\n"
"sa : input float\n"
"sx : input rank-1 array('d') with bounds (*)\n"
"incx : input int\n"
"sy : input rank-1 array('d') with bounds (*)\n"
"incy : input int";
/* extern void F_FUNC(saxpy,SAXPY)(int*,double*,double*,int*,double*,int*); */
static PyObject *f2py_rout_atomic_program_saxpy(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int n = 0;
  PyObject *n_capi = Py_None;
  double sa = 0;
  PyObject *sa_capi = Py_None;
  double *sx = NULL;
  npy_intp sx_Dims[1] = {-1};
  const int sx_Rank = 1;
  PyArrayObject *capi_sx_tmp = NULL;
  int capi_sx_intent = 0;
  PyObject *sx_capi = Py_None;
  int incx = 0;
  PyObject *incx_capi = Py_None;
  double *sy = NULL;
  npy_intp sy_Dims[1] = {-1};
  const int sy_Rank = 1;
  PyArrayObject *capi_sy_tmp = NULL;
  int capi_sy_intent = 0;
  PyObject *sy_capi = Py_None;
  int incy = 0;
  PyObject *incy_capi = Py_None;
  static char *capi_kwlist[] = {"n","sa","sx","incx","sy","incy",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOO|:atomic_program.saxpy",\
    capi_kwlist,&n_capi,&sa_capi,&sx_capi,&incx_capi,&sy_capi,&incy_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.saxpy() 1st argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sa */
    f2py_success = double_from_pyobj(&sa,sa_capi,"atomic_program.saxpy() 2nd argument (sa) can't be converted to double");
  if (f2py_success) {
  /* Processing variable sx */
  ;
  capi_sx_intent |= F2PY_INTENT_IN;
  capi_sx_tmp = array_from_pyobj(NPY_DOUBLE,sx_Dims,sx_Rank,capi_sx_intent,sx_capi);
  if (capi_sx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `sx' of atomic_program.saxpy to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sx = (double *)(PyArray_DATA(capi_sx_tmp));

  /* Processing variable incx */
    f2py_success = int_from_pyobj(&incx,incx_capi,"atomic_program.saxpy() 4th argument (incx) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sy */
  ;
  capi_sy_intent |= F2PY_INTENT_IN;
  capi_sy_tmp = array_from_pyobj(NPY_DOUBLE,sy_Dims,sy_Rank,capi_sy_intent,sy_capi);
  if (capi_sy_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `sy' of atomic_program.saxpy to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sy = (double *)(PyArray_DATA(capi_sy_tmp));

  /* Processing variable incy */
    f2py_success = int_from_pyobj(&incy,incy_capi,"atomic_program.saxpy() 6th argument (incy) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&n,&sa,sx,&incx,sy,&incy);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of incy*/
  /* End of cleaning variable incy */
  if((PyObject *)capi_sy_tmp!=sy_capi) {
    Py_XDECREF(capi_sy_tmp); }
  }  /*if (capi_sy_tmp == NULL) ... else of sy*/
  /* End of cleaning variable sy */
  } /*if (f2py_success) of incx*/
  /* End of cleaning variable incx */
  if((PyObject *)capi_sx_tmp!=sx_capi) {
    Py_XDECREF(capi_sx_tmp); }
  }  /*if (capi_sx_tmp == NULL) ... else of sx*/
  /* End of cleaning variable sx */
  } /*if (f2py_success) of sa*/
  /* End of cleaning variable sa */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of saxpy ********************************/

/************************************ sdot ************************************/
static char doc_f2py_rout_atomic_program_sdot[] = "\
sdot = sdot(n,sx,incx,sy,incy)\n\nWrapper for ``sdot``.\
\n\nParameters\n----------\n"
"n : input int\n"
"sx : input rank-1 array('d') with bounds (*)\n"
"incx : input int\n"
"sy : input rank-1 array('d') with bounds (*)\n"
"incy : input int\n"
"\nReturns\n-------\n"
"sdot : float";
/* extern void F_WRAPPEDFUNC(sdot,SDOT)(double*,int*,double*,int*,double*,int*); */
static PyObject *f2py_rout_atomic_program_sdot(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double sdot = 0;
  int n = 0;
  PyObject *n_capi = Py_None;
  double *sx = NULL;
  npy_intp sx_Dims[1] = {-1};
  const int sx_Rank = 1;
  PyArrayObject *capi_sx_tmp = NULL;
  int capi_sx_intent = 0;
  PyObject *sx_capi = Py_None;
  int incx = 0;
  PyObject *incx_capi = Py_None;
  double *sy = NULL;
  npy_intp sy_Dims[1] = {-1};
  const int sy_Rank = 1;
  PyArrayObject *capi_sy_tmp = NULL;
  int capi_sy_intent = 0;
  PyObject *sy_capi = Py_None;
  int incy = 0;
  PyObject *incy_capi = Py_None;
  static char *capi_kwlist[] = {"n","sx","incx","sy","incy",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO|:atomic_program.sdot",\
    capi_kwlist,&n_capi,&sx_capi,&incx_capi,&sy_capi,&incy_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.sdot() 1st argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sx */
  ;
  capi_sx_intent |= F2PY_INTENT_IN;
  capi_sx_tmp = array_from_pyobj(NPY_DOUBLE,sx_Dims,sx_Rank,capi_sx_intent,sx_capi);
  if (capi_sx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `sx' of atomic_program.sdot to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sx = (double *)(PyArray_DATA(capi_sx_tmp));

  /* Processing variable incx */
    f2py_success = int_from_pyobj(&incx,incx_capi,"atomic_program.sdot() 3rd argument (incx) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sy */
  ;
  capi_sy_intent |= F2PY_INTENT_IN;
  capi_sy_tmp = array_from_pyobj(NPY_DOUBLE,sy_Dims,sy_Rank,capi_sy_intent,sy_capi);
  if (capi_sy_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `sy' of atomic_program.sdot to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sy = (double *)(PyArray_DATA(capi_sy_tmp));

  /* Processing variable incy */
    f2py_success = int_from_pyobj(&incy,incy_capi,"atomic_program.sdot() 5th argument (incy) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sdot */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&sdot,&n,sx,&incx,sy,&incy);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",sdot);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable sdot */
  } /*if (f2py_success) of incy*/
  /* End of cleaning variable incy */
  if((PyObject *)capi_sy_tmp!=sy_capi) {
    Py_XDECREF(capi_sy_tmp); }
  }  /*if (capi_sy_tmp == NULL) ... else of sy*/
  /* End of cleaning variable sy */
  } /*if (f2py_success) of incx*/
  /* End of cleaning variable incx */
  if((PyObject *)capi_sx_tmp!=sx_capi) {
    Py_XDECREF(capi_sx_tmp); }
  }  /*if (capi_sx_tmp == NULL) ... else of sx*/
  /* End of cleaning variable sx */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of sdot ********************************/

/*********************************** scopy ***********************************/
static char doc_f2py_rout_atomic_program_scopy[] = "\
scopy(n,sx,incx,sy,incy)\n\nWrapper for ``scopy``.\
\n\nParameters\n----------\n"
"n : input int\n"
"sx : input rank-1 array('d') with bounds (*)\n"
"incx : input int\n"
"sy : input rank-1 array('d') with bounds (*)\n"
"incy : input int";
/* extern void F_FUNC(scopy,SCOPY)(int*,double*,int*,double*,int*); */
static PyObject *f2py_rout_atomic_program_scopy(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int n = 0;
  PyObject *n_capi = Py_None;
  double *sx = NULL;
  npy_intp sx_Dims[1] = {-1};
  const int sx_Rank = 1;
  PyArrayObject *capi_sx_tmp = NULL;
  int capi_sx_intent = 0;
  PyObject *sx_capi = Py_None;
  int incx = 0;
  PyObject *incx_capi = Py_None;
  double *sy = NULL;
  npy_intp sy_Dims[1] = {-1};
  const int sy_Rank = 1;
  PyArrayObject *capi_sy_tmp = NULL;
  int capi_sy_intent = 0;
  PyObject *sy_capi = Py_None;
  int incy = 0;
  PyObject *incy_capi = Py_None;
  static char *capi_kwlist[] = {"n","sx","incx","sy","incy",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO|:atomic_program.scopy",\
    capi_kwlist,&n_capi,&sx_capi,&incx_capi,&sy_capi,&incy_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.scopy() 1st argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sx */
  ;
  capi_sx_intent |= F2PY_INTENT_IN;
  capi_sx_tmp = array_from_pyobj(NPY_DOUBLE,sx_Dims,sx_Rank,capi_sx_intent,sx_capi);
  if (capi_sx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `sx' of atomic_program.scopy to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sx = (double *)(PyArray_DATA(capi_sx_tmp));

  /* Processing variable incx */
    f2py_success = int_from_pyobj(&incx,incx_capi,"atomic_program.scopy() 3rd argument (incx) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sy */
  ;
  capi_sy_intent |= F2PY_INTENT_IN;
  capi_sy_tmp = array_from_pyobj(NPY_DOUBLE,sy_Dims,sy_Rank,capi_sy_intent,sy_capi);
  if (capi_sy_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `sy' of atomic_program.scopy to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sy = (double *)(PyArray_DATA(capi_sy_tmp));

  /* Processing variable incy */
    f2py_success = int_from_pyobj(&incy,incy_capi,"atomic_program.scopy() 5th argument (incy) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&n,sx,&incx,sy,&incy);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of incy*/
  /* End of cleaning variable incy */
  if((PyObject *)capi_sy_tmp!=sy_capi) {
    Py_XDECREF(capi_sy_tmp); }
  }  /*if (capi_sy_tmp == NULL) ... else of sy*/
  /* End of cleaning variable sy */
  } /*if (f2py_success) of incx*/
  /* End of cleaning variable incx */
  if((PyObject *)capi_sx_tmp!=sx_capi) {
    Py_XDECREF(capi_sx_tmp); }
  }  /*if (capi_sx_tmp == NULL) ... else of sx*/
  /* End of cleaning variable sx */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of scopy ********************************/

/*********************************** sscal ***********************************/
static char doc_f2py_rout_atomic_program_sscal[] = "\
sscal(n,sa,sx,incx)\n\nWrapper for ``sscal``.\
\n\nParameters\n----------\n"
"n : input int\n"
"sa : input float\n"
"sx : input rank-1 array('d') with bounds (*)\n"
"incx : input int";
/* extern void F_FUNC(sscal,SSCAL)(int*,double*,double*,int*); */
static PyObject *f2py_rout_atomic_program_sscal(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int n = 0;
  PyObject *n_capi = Py_None;
  double sa = 0;
  PyObject *sa_capi = Py_None;
  double *sx = NULL;
  npy_intp sx_Dims[1] = {-1};
  const int sx_Rank = 1;
  PyArrayObject *capi_sx_tmp = NULL;
  int capi_sx_intent = 0;
  PyObject *sx_capi = Py_None;
  int incx = 0;
  PyObject *incx_capi = Py_None;
  static char *capi_kwlist[] = {"n","sa","sx","incx",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|:atomic_program.sscal",\
    capi_kwlist,&n_capi,&sa_capi,&sx_capi,&incx_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.sscal() 1st argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sa */
    f2py_success = double_from_pyobj(&sa,sa_capi,"atomic_program.sscal() 2nd argument (sa) can't be converted to double");
  if (f2py_success) {
  /* Processing variable sx */
  ;
  capi_sx_intent |= F2PY_INTENT_IN;
  capi_sx_tmp = array_from_pyobj(NPY_DOUBLE,sx_Dims,sx_Rank,capi_sx_intent,sx_capi);
  if (capi_sx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `sx' of atomic_program.sscal to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sx = (double *)(PyArray_DATA(capi_sx_tmp));

  /* Processing variable incx */
    f2py_success = int_from_pyobj(&incx,incx_capi,"atomic_program.sscal() 4th argument (incx) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&n,&sa,sx,&incx);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of incx*/
  /* End of cleaning variable incx */
  if((PyObject *)capi_sx_tmp!=sx_capi) {
    Py_XDECREF(capi_sx_tmp); }
  }  /*if (capi_sx_tmp == NULL) ... else of sx*/
  /* End of cleaning variable sx */
  } /*if (f2py_success) of sa*/
  /* End of cleaning variable sa */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of sscal ********************************/

/*********************************** tridib ***********************************/
static char doc_f2py_rout_atomic_program_tridib[] = "\
tridib(eps1,d,e,e2,lb,ub,m11,w,ind,ierr,rv4,rv5,[n,m])\n\nWrapper for ``tridib``.\
\n\nParameters\n----------\n"
"eps1 : input float\n"
"d : input rank-1 array('d') with bounds (n)\n"
"e : input rank-1 array('d') with bounds (n)\n"
"e2 : input rank-1 array('d') with bounds (n)\n"
"lb : input float\n"
"ub : input float\n"
"m11 : input int\n"
"w : input rank-1 array('d') with bounds (m)\n"
"ind : input rank-1 array('i') with bounds (m)\n"
"ierr : input int\n"
"rv4 : input rank-1 array('d') with bounds (n)\n"
"rv5 : input rank-1 array('d') with bounds (n)\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: len(d)\n"
"m : input int, optional\n    Default: len(w)";
/* extern void F_FUNC(tridib,TRIDIB)(int*,double*,double*,double*,double*,double*,double*,int*,int*,double*,int*,int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_tridib(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,double*,double*,double*,double*,int*,int*,double*,int*,int*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int n = 0;
  PyObject *n_capi = Py_None;
  double eps1 = 0;
  PyObject *eps1_capi = Py_None;
  double *d = NULL;
  npy_intp d_Dims[1] = {-1};
  const int d_Rank = 1;
  PyArrayObject *capi_d_tmp = NULL;
  int capi_d_intent = 0;
  PyObject *d_capi = Py_None;
  double *e = NULL;
  npy_intp e_Dims[1] = {-1};
  const int e_Rank = 1;
  PyArrayObject *capi_e_tmp = NULL;
  int capi_e_intent = 0;
  PyObject *e_capi = Py_None;
  double *e2 = NULL;
  npy_intp e2_Dims[1] = {-1};
  const int e2_Rank = 1;
  PyArrayObject *capi_e2_tmp = NULL;
  int capi_e2_intent = 0;
  PyObject *e2_capi = Py_None;
  double lb = 0;
  PyObject *lb_capi = Py_None;
  double ub = 0;
  PyObject *ub_capi = Py_None;
  int m11 = 0;
  PyObject *m11_capi = Py_None;
  int m = 0;
  PyObject *m_capi = Py_None;
  double *w = NULL;
  npy_intp w_Dims[1] = {-1};
  const int w_Rank = 1;
  PyArrayObject *capi_w_tmp = NULL;
  int capi_w_intent = 0;
  PyObject *w_capi = Py_None;
  int *ind = NULL;
  npy_intp ind_Dims[1] = {-1};
  const int ind_Rank = 1;
  PyArrayObject *capi_ind_tmp = NULL;
  int capi_ind_intent = 0;
  PyObject *ind_capi = Py_None;
  int ierr = 0;
  PyObject *ierr_capi = Py_None;
  double *rv4 = NULL;
  npy_intp rv4_Dims[1] = {-1};
  const int rv4_Rank = 1;
  PyArrayObject *capi_rv4_tmp = NULL;
  int capi_rv4_intent = 0;
  PyObject *rv4_capi = Py_None;
  double *rv5 = NULL;
  npy_intp rv5_Dims[1] = {-1};
  const int rv5_Rank = 1;
  PyArrayObject *capi_rv5_tmp = NULL;
  int capi_rv5_intent = 0;
  PyObject *rv5_capi = Py_None;
  static char *capi_kwlist[] = {"eps1","d","e","e2","lb","ub","m11","w","ind","ierr","rv4","rv5","n","m",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOO|OO:atomic_program.tridib",\
    capi_kwlist,&eps1_capi,&d_capi,&e_capi,&e2_capi,&lb_capi,&ub_capi,&m11_capi,&w_capi,&ind_capi,&ierr_capi,&rv4_capi,&rv5_capi,&n_capi,&m_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable eps1 */
    f2py_success = double_from_pyobj(&eps1,eps1_capi,"atomic_program.tridib() 1st argument (eps1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable d */
  ;
  capi_d_intent |= F2PY_INTENT_IN;
  capi_d_tmp = array_from_pyobj(NPY_DOUBLE,d_Dims,d_Rank,capi_d_intent,d_capi);
  if (capi_d_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `d' of atomic_program.tridib to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    d = (double *)(PyArray_DATA(capi_d_tmp));

  /* Processing variable lb */
    f2py_success = double_from_pyobj(&lb,lb_capi,"atomic_program.tridib() 5th argument (lb) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ub */
    f2py_success = double_from_pyobj(&ub,ub_capi,"atomic_program.tridib() 6th argument (ub) can't be converted to double");
  if (f2py_success) {
  /* Processing variable m11 */
    f2py_success = int_from_pyobj(&m11,m11_capi,"atomic_program.tridib() 7th argument (m11) can't be converted to int");
  if (f2py_success) {
  /* Processing variable w */
  ;
  capi_w_intent |= F2PY_INTENT_IN;
  capi_w_tmp = array_from_pyobj(NPY_DOUBLE,w_Dims,w_Rank,capi_w_intent,w_capi);
  if (capi_w_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 8th argument `w' of atomic_program.tridib to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    w = (double *)(PyArray_DATA(capi_w_tmp));

  /* Processing variable ierr */
    f2py_success = int_from_pyobj(&ierr,ierr_capi,"atomic_program.tridib() 10th argument (ierr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n */
  if (n_capi == Py_None) n = len(d); else
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.tridib() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(d)>=n,"len(d)>=n","1st keyword n","tridib:n=%d",n) {
  /* Processing variable e */
  e_Dims[0]=n;
  capi_e_intent |= F2PY_INTENT_IN;
  capi_e_tmp = array_from_pyobj(NPY_DOUBLE,e_Dims,e_Rank,capi_e_intent,e_capi);
  if (capi_e_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `e' of atomic_program.tridib to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    e = (double *)(PyArray_DATA(capi_e_tmp));

  /* Processing variable e2 */
  e2_Dims[0]=n;
  capi_e2_intent |= F2PY_INTENT_IN;
  capi_e2_tmp = array_from_pyobj(NPY_DOUBLE,e2_Dims,e2_Rank,capi_e2_intent,e2_capi);
  if (capi_e2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `e2' of atomic_program.tridib to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    e2 = (double *)(PyArray_DATA(capi_e2_tmp));

  /* Processing variable m */
  if (m_capi == Py_None) m = len(w); else
    f2py_success = int_from_pyobj(&m,m_capi,"atomic_program.tridib() 2nd keyword (m) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(w)>=m,"len(w)>=m","2nd keyword m","tridib:m=%d",m) {
  /* Processing variable ind */
  ind_Dims[0]=m;
  capi_ind_intent |= F2PY_INTENT_IN;
  capi_ind_tmp = array_from_pyobj(NPY_INT,ind_Dims,ind_Rank,capi_ind_intent,ind_capi);
  if (capi_ind_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 9th argument `ind' of atomic_program.tridib to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ind = (int *)(PyArray_DATA(capi_ind_tmp));

  /* Processing variable rv4 */
  rv4_Dims[0]=n;
  capi_rv4_intent |= F2PY_INTENT_IN;
  capi_rv4_tmp = array_from_pyobj(NPY_DOUBLE,rv4_Dims,rv4_Rank,capi_rv4_intent,rv4_capi);
  if (capi_rv4_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 11st argument `rv4' of atomic_program.tridib to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rv4 = (double *)(PyArray_DATA(capi_rv4_tmp));

  /* Processing variable rv5 */
  rv5_Dims[0]=n;
  capi_rv5_intent |= F2PY_INTENT_IN;
  capi_rv5_tmp = array_from_pyobj(NPY_DOUBLE,rv5_Dims,rv5_Rank,capi_rv5_intent,rv5_capi);
  if (capi_rv5_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 12nd argument `rv5' of atomic_program.tridib to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rv5 = (double *)(PyArray_DATA(capi_rv5_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&n,&eps1,d,e,e2,&lb,&ub,&m11,&m,w,ind,&ierr,rv4,rv5);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_rv5_tmp!=rv5_capi) {
    Py_XDECREF(capi_rv5_tmp); }
  }  /*if (capi_rv5_tmp == NULL) ... else of rv5*/
  /* End of cleaning variable rv5 */
  if((PyObject *)capi_rv4_tmp!=rv4_capi) {
    Py_XDECREF(capi_rv4_tmp); }
  }  /*if (capi_rv4_tmp == NULL) ... else of rv4*/
  /* End of cleaning variable rv4 */
  if((PyObject *)capi_ind_tmp!=ind_capi) {
    Py_XDECREF(capi_ind_tmp); }
  }  /*if (capi_ind_tmp == NULL) ... else of ind*/
  /* End of cleaning variable ind */
  } /*CHECKSCALAR(len(w)>=m)*/
  } /*if (f2py_success) of m*/
  /* End of cleaning variable m */
  if((PyObject *)capi_e2_tmp!=e2_capi) {
    Py_XDECREF(capi_e2_tmp); }
  }  /*if (capi_e2_tmp == NULL) ... else of e2*/
  /* End of cleaning variable e2 */
  if((PyObject *)capi_e_tmp!=e_capi) {
    Py_XDECREF(capi_e_tmp); }
  }  /*if (capi_e_tmp == NULL) ... else of e*/
  /* End of cleaning variable e */
  } /*CHECKSCALAR(len(d)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of ierr*/
  /* End of cleaning variable ierr */
  if((PyObject *)capi_w_tmp!=w_capi) {
    Py_XDECREF(capi_w_tmp); }
  }  /*if (capi_w_tmp == NULL) ... else of w*/
  /* End of cleaning variable w */
  } /*if (f2py_success) of m11*/
  /* End of cleaning variable m11 */
  } /*if (f2py_success) of ub*/
  /* End of cleaning variable ub */
  } /*if (f2py_success) of lb*/
  /* End of cleaning variable lb */
  if((PyObject *)capi_d_tmp!=d_capi) {
    Py_XDECREF(capi_d_tmp); }
  }  /*if (capi_d_tmp == NULL) ... else of d*/
  /* End of cleaning variable d */
  } /*if (f2py_success) of eps1*/
  /* End of cleaning variable eps1 */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of tridib *******************************/

/*********************************** tinvit ***********************************/
static char doc_f2py_rout_atomic_program_tinvit[] = "\
tinvit(d,e,e2,w,ind,z,ierr,rv1,rv2,rv3,rv4,rv6,[nm,n,m])\n\nWrapper for ``tinvit``.\
\n\nParameters\n----------\n"
"d : input rank-1 array('d') with bounds (n)\n"
"e : input rank-1 array('d') with bounds (n)\n"
"e2 : input rank-1 array('d') with bounds (n)\n"
"w : input rank-1 array('d') with bounds (m)\n"
"ind : input rank-1 array('i') with bounds (m)\n"
"z : input rank-2 array('d') with bounds (nm,m)\n"
"ierr : input int\n"
"rv1 : input rank-1 array('d') with bounds (n)\n"
"rv2 : input rank-1 array('d') with bounds (n)\n"
"rv3 : input rank-1 array('d') with bounds (n)\n"
"rv4 : input rank-1 array('d') with bounds (n)\n"
"rv6 : input rank-1 array('d') with bounds (n)\n"
"\nOther Parameters\n----------------\n"
"nm : input int, optional\n    Default: shape(z,0)\n"
"n : input int, optional\n    Default: len(d)\n"
"m : input int, optional\n    Default: len(w)";
/* extern void F_FUNC(tinvit,TINVIT)(int*,int*,double*,double*,double*,int*,double*,int*,double*,int*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_tinvit(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,int*,double*,int*,double*,int*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nm = 0;
  PyObject *nm_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double *d = NULL;
  npy_intp d_Dims[1] = {-1};
  const int d_Rank = 1;
  PyArrayObject *capi_d_tmp = NULL;
  int capi_d_intent = 0;
  PyObject *d_capi = Py_None;
  double *e = NULL;
  npy_intp e_Dims[1] = {-1};
  const int e_Rank = 1;
  PyArrayObject *capi_e_tmp = NULL;
  int capi_e_intent = 0;
  PyObject *e_capi = Py_None;
  double *e2 = NULL;
  npy_intp e2_Dims[1] = {-1};
  const int e2_Rank = 1;
  PyArrayObject *capi_e2_tmp = NULL;
  int capi_e2_intent = 0;
  PyObject *e2_capi = Py_None;
  int m = 0;
  PyObject *m_capi = Py_None;
  double *w = NULL;
  npy_intp w_Dims[1] = {-1};
  const int w_Rank = 1;
  PyArrayObject *capi_w_tmp = NULL;
  int capi_w_intent = 0;
  PyObject *w_capi = Py_None;
  int *ind = NULL;
  npy_intp ind_Dims[1] = {-1};
  const int ind_Rank = 1;
  PyArrayObject *capi_ind_tmp = NULL;
  int capi_ind_intent = 0;
  PyObject *ind_capi = Py_None;
  double *z = NULL;
  npy_intp z_Dims[2] = {-1, -1};
  const int z_Rank = 2;
  PyArrayObject *capi_z_tmp = NULL;
  int capi_z_intent = 0;
  PyObject *z_capi = Py_None;
  int ierr = 0;
  PyObject *ierr_capi = Py_None;
  double *rv1 = NULL;
  npy_intp rv1_Dims[1] = {-1};
  const int rv1_Rank = 1;
  PyArrayObject *capi_rv1_tmp = NULL;
  int capi_rv1_intent = 0;
  PyObject *rv1_capi = Py_None;
  double *rv2 = NULL;
  npy_intp rv2_Dims[1] = {-1};
  const int rv2_Rank = 1;
  PyArrayObject *capi_rv2_tmp = NULL;
  int capi_rv2_intent = 0;
  PyObject *rv2_capi = Py_None;
  double *rv3 = NULL;
  npy_intp rv3_Dims[1] = {-1};
  const int rv3_Rank = 1;
  PyArrayObject *capi_rv3_tmp = NULL;
  int capi_rv3_intent = 0;
  PyObject *rv3_capi = Py_None;
  double *rv4 = NULL;
  npy_intp rv4_Dims[1] = {-1};
  const int rv4_Rank = 1;
  PyArrayObject *capi_rv4_tmp = NULL;
  int capi_rv4_intent = 0;
  PyObject *rv4_capi = Py_None;
  double *rv6 = NULL;
  npy_intp rv6_Dims[1] = {-1};
  const int rv6_Rank = 1;
  PyArrayObject *capi_rv6_tmp = NULL;
  int capi_rv6_intent = 0;
  PyObject *rv6_capi = Py_None;
  static char *capi_kwlist[] = {"d","e","e2","w","ind","z","ierr","rv1","rv2","rv3","rv4","rv6","nm","n","m",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOO|OOO:atomic_program.tinvit",\
    capi_kwlist,&d_capi,&e_capi,&e2_capi,&w_capi,&ind_capi,&z_capi,&ierr_capi,&rv1_capi,&rv2_capi,&rv3_capi,&rv4_capi,&rv6_capi,&nm_capi,&n_capi,&m_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable d */
  ;
  capi_d_intent |= F2PY_INTENT_IN;
  capi_d_tmp = array_from_pyobj(NPY_DOUBLE,d_Dims,d_Rank,capi_d_intent,d_capi);
  if (capi_d_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `d' of atomic_program.tinvit to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    d = (double *)(PyArray_DATA(capi_d_tmp));

  /* Processing variable w */
  ;
  capi_w_intent |= F2PY_INTENT_IN;
  capi_w_tmp = array_from_pyobj(NPY_DOUBLE,w_Dims,w_Rank,capi_w_intent,w_capi);
  if (capi_w_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `w' of atomic_program.tinvit to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    w = (double *)(PyArray_DATA(capi_w_tmp));

  /* Processing variable ierr */
    f2py_success = int_from_pyobj(&ierr,ierr_capi,"atomic_program.tinvit() 7th argument (ierr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n */
  if (n_capi == Py_None) n = len(d); else
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.tinvit() 2nd keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(d)>=n,"len(d)>=n","2nd keyword n","tinvit:n=%d",n) {
  /* Processing variable e */
  e_Dims[0]=n;
  capi_e_intent |= F2PY_INTENT_IN;
  capi_e_tmp = array_from_pyobj(NPY_DOUBLE,e_Dims,e_Rank,capi_e_intent,e_capi);
  if (capi_e_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `e' of atomic_program.tinvit to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    e = (double *)(PyArray_DATA(capi_e_tmp));

  /* Processing variable e2 */
  e2_Dims[0]=n;
  capi_e2_intent |= F2PY_INTENT_IN;
  capi_e2_tmp = array_from_pyobj(NPY_DOUBLE,e2_Dims,e2_Rank,capi_e2_intent,e2_capi);
  if (capi_e2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `e2' of atomic_program.tinvit to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    e2 = (double *)(PyArray_DATA(capi_e2_tmp));

  /* Processing variable m */
  if (m_capi == Py_None) m = len(w); else
    f2py_success = int_from_pyobj(&m,m_capi,"atomic_program.tinvit() 3rd keyword (m) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(w)>=m,"len(w)>=m","3rd keyword m","tinvit:m=%d",m) {
  /* Processing variable ind */
  ind_Dims[0]=m;
  capi_ind_intent |= F2PY_INTENT_IN;
  capi_ind_tmp = array_from_pyobj(NPY_INT,ind_Dims,ind_Rank,capi_ind_intent,ind_capi);
  if (capi_ind_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `ind' of atomic_program.tinvit to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ind = (int *)(PyArray_DATA(capi_ind_tmp));

  /* Processing variable z */
  z_Dims[1]=m;
  capi_z_intent |= F2PY_INTENT_IN;
  capi_z_tmp = array_from_pyobj(NPY_DOUBLE,z_Dims,z_Rank,capi_z_intent,z_capi);
  if (capi_z_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `z' of atomic_program.tinvit to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    z = (double *)(PyArray_DATA(capi_z_tmp));

  /* Processing variable rv1 */
  rv1_Dims[0]=n;
  capi_rv1_intent |= F2PY_INTENT_IN;
  capi_rv1_tmp = array_from_pyobj(NPY_DOUBLE,rv1_Dims,rv1_Rank,capi_rv1_intent,rv1_capi);
  if (capi_rv1_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 8th argument `rv1' of atomic_program.tinvit to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rv1 = (double *)(PyArray_DATA(capi_rv1_tmp));

  /* Processing variable rv2 */
  rv2_Dims[0]=n;
  capi_rv2_intent |= F2PY_INTENT_IN;
  capi_rv2_tmp = array_from_pyobj(NPY_DOUBLE,rv2_Dims,rv2_Rank,capi_rv2_intent,rv2_capi);
  if (capi_rv2_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 9th argument `rv2' of atomic_program.tinvit to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rv2 = (double *)(PyArray_DATA(capi_rv2_tmp));

  /* Processing variable rv3 */
  rv3_Dims[0]=n;
  capi_rv3_intent |= F2PY_INTENT_IN;
  capi_rv3_tmp = array_from_pyobj(NPY_DOUBLE,rv3_Dims,rv3_Rank,capi_rv3_intent,rv3_capi);
  if (capi_rv3_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 10th argument `rv3' of atomic_program.tinvit to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rv3 = (double *)(PyArray_DATA(capi_rv3_tmp));

  /* Processing variable rv4 */
  rv4_Dims[0]=n;
  capi_rv4_intent |= F2PY_INTENT_IN;
  capi_rv4_tmp = array_from_pyobj(NPY_DOUBLE,rv4_Dims,rv4_Rank,capi_rv4_intent,rv4_capi);
  if (capi_rv4_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 11st argument `rv4' of atomic_program.tinvit to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rv4 = (double *)(PyArray_DATA(capi_rv4_tmp));

  /* Processing variable rv6 */
  rv6_Dims[0]=n;
  capi_rv6_intent |= F2PY_INTENT_IN;
  capi_rv6_tmp = array_from_pyobj(NPY_DOUBLE,rv6_Dims,rv6_Rank,capi_rv6_intent,rv6_capi);
  if (capi_rv6_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 12nd argument `rv6' of atomic_program.tinvit to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rv6 = (double *)(PyArray_DATA(capi_rv6_tmp));

  /* Processing variable nm */
  if (nm_capi == Py_None) nm = shape(z,0); else
    f2py_success = int_from_pyobj(&nm,nm_capi,"atomic_program.tinvit() 1st keyword (nm) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(z,0)==nm,"shape(z,0)==nm","1st keyword nm","tinvit:nm=%d",nm) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nm,&n,d,e,e2,&m,w,ind,z,&ierr,rv1,rv2,rv3,rv4,rv6);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR(shape(z,0)==nm)*/
  } /*if (f2py_success) of nm*/
  /* End of cleaning variable nm */
  if((PyObject *)capi_rv6_tmp!=rv6_capi) {
    Py_XDECREF(capi_rv6_tmp); }
  }  /*if (capi_rv6_tmp == NULL) ... else of rv6*/
  /* End of cleaning variable rv6 */
  if((PyObject *)capi_rv4_tmp!=rv4_capi) {
    Py_XDECREF(capi_rv4_tmp); }
  }  /*if (capi_rv4_tmp == NULL) ... else of rv4*/
  /* End of cleaning variable rv4 */
  if((PyObject *)capi_rv3_tmp!=rv3_capi) {
    Py_XDECREF(capi_rv3_tmp); }
  }  /*if (capi_rv3_tmp == NULL) ... else of rv3*/
  /* End of cleaning variable rv3 */
  if((PyObject *)capi_rv2_tmp!=rv2_capi) {
    Py_XDECREF(capi_rv2_tmp); }
  }  /*if (capi_rv2_tmp == NULL) ... else of rv2*/
  /* End of cleaning variable rv2 */
  if((PyObject *)capi_rv1_tmp!=rv1_capi) {
    Py_XDECREF(capi_rv1_tmp); }
  }  /*if (capi_rv1_tmp == NULL) ... else of rv1*/
  /* End of cleaning variable rv1 */
  if((PyObject *)capi_z_tmp!=z_capi) {
    Py_XDECREF(capi_z_tmp); }
  }  /*if (capi_z_tmp == NULL) ... else of z*/
  /* End of cleaning variable z */
  if((PyObject *)capi_ind_tmp!=ind_capi) {
    Py_XDECREF(capi_ind_tmp); }
  }  /*if (capi_ind_tmp == NULL) ... else of ind*/
  /* End of cleaning variable ind */
  } /*CHECKSCALAR(len(w)>=m)*/
  } /*if (f2py_success) of m*/
  /* End of cleaning variable m */
  if((PyObject *)capi_e2_tmp!=e2_capi) {
    Py_XDECREF(capi_e2_tmp); }
  }  /*if (capi_e2_tmp == NULL) ... else of e2*/
  /* End of cleaning variable e2 */
  if((PyObject *)capi_e_tmp!=e_capi) {
    Py_XDECREF(capi_e_tmp); }
  }  /*if (capi_e_tmp == NULL) ... else of e*/
  /* End of cleaning variable e */
  } /*CHECKSCALAR(len(d)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of ierr*/
  /* End of cleaning variable ierr */
  if((PyObject *)capi_w_tmp!=w_capi) {
    Py_XDECREF(capi_w_tmp); }
  }  /*if (capi_w_tmp == NULL) ... else of w*/
  /* End of cleaning variable w */
  if((PyObject *)capi_d_tmp!=d_capi) {
    Py_XDECREF(capi_d_tmp); }
  }  /*if (capi_d_tmp == NULL) ... else of d*/
  /* End of cleaning variable d */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of tinvit *******************************/

/*********************************** sgeco ***********************************/
static char doc_f2py_rout_atomic_program_sgeco[] = "\
sgeco(a,n,ipvt,rcond,z,[lda])\n\nWrapper for ``sgeco``.\
\n\nParameters\n----------\n"
"a : input rank-2 array('d') with bounds (lda,*)\n"
"n : input int\n"
"ipvt : input rank-1 array('i') with bounds (*)\n"
"rcond : input float\n"
"z : input rank-1 array('d') with bounds (*)\n"
"\nOther Parameters\n----------------\n"
"lda : input int, optional\n    Default: shape(a,0)";
/* extern void F_FUNC(sgeco,SGECO)(double*,int*,int*,int*,double*,double*); */
static PyObject *f2py_rout_atomic_program_sgeco(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,int*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *a = NULL;
  npy_intp a_Dims[2] = {-1, -1};
  const int a_Rank = 2;
  PyArrayObject *capi_a_tmp = NULL;
  int capi_a_intent = 0;
  PyObject *a_capi = Py_None;
  int lda = 0;
  PyObject *lda_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int *ipvt = NULL;
  npy_intp ipvt_Dims[1] = {-1};
  const int ipvt_Rank = 1;
  PyArrayObject *capi_ipvt_tmp = NULL;
  int capi_ipvt_intent = 0;
  PyObject *ipvt_capi = Py_None;
  double rcond = 0;
  PyObject *rcond_capi = Py_None;
  double *z = NULL;
  npy_intp z_Dims[1] = {-1};
  const int z_Rank = 1;
  PyArrayObject *capi_z_tmp = NULL;
  int capi_z_intent = 0;
  PyObject *z_capi = Py_None;
  static char *capi_kwlist[] = {"a","n","ipvt","rcond","z","lda",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO|O:atomic_program.sgeco",\
    capi_kwlist,&a_capi,&n_capi,&ipvt_capi,&rcond_capi,&z_capi,&lda_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable a */
  ;
  capi_a_intent |= F2PY_INTENT_IN;
  capi_a_tmp = array_from_pyobj(NPY_DOUBLE,a_Dims,a_Rank,capi_a_intent,a_capi);
  if (capi_a_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `a' of atomic_program.sgeco to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    a = (double *)(PyArray_DATA(capi_a_tmp));

  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.sgeco() 2nd argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ipvt */
  ;
  capi_ipvt_intent |= F2PY_INTENT_IN;
  capi_ipvt_tmp = array_from_pyobj(NPY_INT,ipvt_Dims,ipvt_Rank,capi_ipvt_intent,ipvt_capi);
  if (capi_ipvt_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `ipvt' of atomic_program.sgeco to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ipvt = (int *)(PyArray_DATA(capi_ipvt_tmp));

  /* Processing variable rcond */
    f2py_success = double_from_pyobj(&rcond,rcond_capi,"atomic_program.sgeco() 4th argument (rcond) can't be converted to double");
  if (f2py_success) {
  /* Processing variable z */
  ;
  capi_z_intent |= F2PY_INTENT_IN;
  capi_z_tmp = array_from_pyobj(NPY_DOUBLE,z_Dims,z_Rank,capi_z_intent,z_capi);
  if (capi_z_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `z' of atomic_program.sgeco to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    z = (double *)(PyArray_DATA(capi_z_tmp));

  /* Processing variable lda */
  if (lda_capi == Py_None) lda = shape(a,0); else
    f2py_success = int_from_pyobj(&lda,lda_capi,"atomic_program.sgeco() 1st keyword (lda) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(a,0)==lda,"shape(a,0)==lda","1st keyword lda","sgeco:lda=%d",lda) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(a,&lda,&n,ipvt,&rcond,z);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR(shape(a,0)==lda)*/
  } /*if (f2py_success) of lda*/
  /* End of cleaning variable lda */
  if((PyObject *)capi_z_tmp!=z_capi) {
    Py_XDECREF(capi_z_tmp); }
  }  /*if (capi_z_tmp == NULL) ... else of z*/
  /* End of cleaning variable z */
  } /*if (f2py_success) of rcond*/
  /* End of cleaning variable rcond */
  if((PyObject *)capi_ipvt_tmp!=ipvt_capi) {
    Py_XDECREF(capi_ipvt_tmp); }
  }  /*if (capi_ipvt_tmp == NULL) ... else of ipvt*/
  /* End of cleaning variable ipvt */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_a_tmp!=a_capi) {
    Py_XDECREF(capi_a_tmp); }
  }  /*if (capi_a_tmp == NULL) ... else of a*/
  /* End of cleaning variable a */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of sgeco ********************************/

/*********************************** epslon ***********************************/
static char doc_f2py_rout_atomic_program_epslon[] = "\
epslon = epslon(x)\n\nWrapper for ``epslon``.\
\n\nParameters\n----------\n"
"x : input float\n"
"\nReturns\n-------\n"
"epslon : float";
/* extern void F_WRAPPEDFUNC(epslon,EPSLON)(double*,double*); */
static PyObject *f2py_rout_atomic_program_epslon(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double epslon = 0;
  double x = 0;
  PyObject *x_capi = Py_None;
  static char *capi_kwlist[] = {"x",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.epslon",\
    capi_kwlist,&x_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable x */
    f2py_success = double_from_pyobj(&x,x_capi,"atomic_program.epslon() 1st argument (x) can't be converted to double");
  if (f2py_success) {
  /* Processing variable epslon */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&epslon,&x);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",epslon);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable epslon */
  } /*if (f2py_success) of x*/
  /* End of cleaning variable x */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of epslon *******************************/

/*********************************** pythag ***********************************/
static char doc_f2py_rout_atomic_program_pythag[] = "\
pythag = pythag(a,b)\n\nWrapper for ``pythag``.\
\n\nParameters\n----------\n"
"a : input float\n"
"b : input float\n"
"\nReturns\n-------\n"
"pythag : float";
/* extern void F_WRAPPEDFUNC(pythag,PYTHAG)(double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_pythag(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double pythag = 0;
  double a = 0;
  PyObject *a_capi = Py_None;
  double b = 0;
  PyObject *b_capi = Py_None;
  static char *capi_kwlist[] = {"a","b",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:atomic_program.pythag",\
    capi_kwlist,&a_capi,&b_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable a */
    f2py_success = double_from_pyobj(&a,a_capi,"atomic_program.pythag() 1st argument (a) can't be converted to double");
  if (f2py_success) {
  /* Processing variable b */
    f2py_success = double_from_pyobj(&b,b_capi,"atomic_program.pythag() 2nd argument (b) can't be converted to double");
  if (f2py_success) {
  /* Processing variable pythag */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&pythag,&a,&b);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",pythag);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable pythag */
  } /*if (f2py_success) of b*/
  /* End of cleaning variable b */
  } /*if (f2py_success) of a*/
  /* End of cleaning variable a */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pythag *******************************/

/*********************************** sasum ***********************************/
static char doc_f2py_rout_atomic_program_sasum[] = "\
sasum = sasum(n,sx,incx)\n\nWrapper for ``sasum``.\
\n\nParameters\n----------\n"
"n : input int\n"
"sx : input rank-1 array('d') with bounds (*)\n"
"incx : input int\n"
"\nReturns\n-------\n"
"sasum : float";
/* extern void F_WRAPPEDFUNC(sasum,SASUM)(double*,int*,double*,int*); */
static PyObject *f2py_rout_atomic_program_sasum(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double sasum = 0;
  int n = 0;
  PyObject *n_capi = Py_None;
  double *sx = NULL;
  npy_intp sx_Dims[1] = {-1};
  const int sx_Rank = 1;
  PyArrayObject *capi_sx_tmp = NULL;
  int capi_sx_intent = 0;
  PyObject *sx_capi = Py_None;
  int incx = 0;
  PyObject *incx_capi = Py_None;
  static char *capi_kwlist[] = {"n","sx","incx",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:atomic_program.sasum",\
    capi_kwlist,&n_capi,&sx_capi,&incx_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.sasum() 1st argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sx */
  ;
  capi_sx_intent |= F2PY_INTENT_IN;
  capi_sx_tmp = array_from_pyobj(NPY_DOUBLE,sx_Dims,sx_Rank,capi_sx_intent,sx_capi);
  if (capi_sx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `sx' of atomic_program.sasum to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sx = (double *)(PyArray_DATA(capi_sx_tmp));

  /* Processing variable incx */
    f2py_success = int_from_pyobj(&incx,incx_capi,"atomic_program.sasum() 3rd argument (incx) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sasum */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&sasum,&n,sx,&incx);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",sasum);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable sasum */
  } /*if (f2py_success) of incx*/
  /* End of cleaning variable incx */
  if((PyObject *)capi_sx_tmp!=sx_capi) {
    Py_XDECREF(capi_sx_tmp); }
  }  /*if (capi_sx_tmp == NULL) ... else of sx*/
  /* End of cleaning variable sx */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of sasum ********************************/

/*********************************** sgefa ***********************************/
static char doc_f2py_rout_atomic_program_sgefa[] = "\
sgefa(a,n,ipvt,info,[lda])\n\nWrapper for ``sgefa``.\
\n\nParameters\n----------\n"
"a : input rank-2 array('d') with bounds (lda,*)\n"
"n : input int\n"
"ipvt : input rank-1 array('i') with bounds (*)\n"
"info : input int\n"
"\nOther Parameters\n----------------\n"
"lda : input int, optional\n    Default: shape(a,0)";
/* extern void F_FUNC(sgefa,SGEFA)(double*,int*,int*,int*,int*); */
static PyObject *f2py_rout_atomic_program_sgefa(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *a = NULL;
  npy_intp a_Dims[2] = {-1, -1};
  const int a_Rank = 2;
  PyArrayObject *capi_a_tmp = NULL;
  int capi_a_intent = 0;
  PyObject *a_capi = Py_None;
  int lda = 0;
  PyObject *lda_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int *ipvt = NULL;
  npy_intp ipvt_Dims[1] = {-1};
  const int ipvt_Rank = 1;
  PyArrayObject *capi_ipvt_tmp = NULL;
  int capi_ipvt_intent = 0;
  PyObject *ipvt_capi = Py_None;
  int info = 0;
  PyObject *info_capi = Py_None;
  static char *capi_kwlist[] = {"a","n","ipvt","info","lda",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O:atomic_program.sgefa",\
    capi_kwlist,&a_capi,&n_capi,&ipvt_capi,&info_capi,&lda_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable a */
  ;
  capi_a_intent |= F2PY_INTENT_IN;
  capi_a_tmp = array_from_pyobj(NPY_DOUBLE,a_Dims,a_Rank,capi_a_intent,a_capi);
  if (capi_a_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `a' of atomic_program.sgefa to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    a = (double *)(PyArray_DATA(capi_a_tmp));

  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.sgefa() 2nd argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ipvt */
  ;
  capi_ipvt_intent |= F2PY_INTENT_IN;
  capi_ipvt_tmp = array_from_pyobj(NPY_INT,ipvt_Dims,ipvt_Rank,capi_ipvt_intent,ipvt_capi);
  if (capi_ipvt_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `ipvt' of atomic_program.sgefa to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ipvt = (int *)(PyArray_DATA(capi_ipvt_tmp));

  /* Processing variable info */
    f2py_success = int_from_pyobj(&info,info_capi,"atomic_program.sgefa() 4th argument (info) can't be converted to int");
  if (f2py_success) {
  /* Processing variable lda */
  if (lda_capi == Py_None) lda = shape(a,0); else
    f2py_success = int_from_pyobj(&lda,lda_capi,"atomic_program.sgefa() 1st keyword (lda) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(a,0)==lda,"shape(a,0)==lda","1st keyword lda","sgefa:lda=%d",lda) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(a,&lda,&n,ipvt,&info);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR(shape(a,0)==lda)*/
  } /*if (f2py_success) of lda*/
  /* End of cleaning variable lda */
  } /*if (f2py_success) of info*/
  /* End of cleaning variable info */
  if((PyObject *)capi_ipvt_tmp!=ipvt_capi) {
    Py_XDECREF(capi_ipvt_tmp); }
  }  /*if (capi_ipvt_tmp == NULL) ... else of ipvt*/
  /* End of cleaning variable ipvt */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_a_tmp!=a_capi) {
    Py_XDECREF(capi_a_tmp); }
  }  /*if (capi_a_tmp == NULL) ... else of a*/
  /* End of cleaning variable a */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of sgefa ********************************/

/*********************************** isamax ***********************************/
static char doc_f2py_rout_atomic_program_isamax[] = "\
isamax = isamax(n,sx,incx)\n\nWrapper for ``isamax``.\
\n\nParameters\n----------\n"
"n : input int\n"
"sx : input rank-1 array('d') with bounds (*)\n"
"incx : input int\n"
"\nReturns\n-------\n"
"isamax : int";
/* extern void F_WRAPPEDFUNC(isamax,ISAMAX)(int*,int*,double*,int*); */
static PyObject *f2py_rout_atomic_program_isamax(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int isamax = 0;
  int n = 0;
  PyObject *n_capi = Py_None;
  double *sx = NULL;
  npy_intp sx_Dims[1] = {-1};
  const int sx_Rank = 1;
  PyArrayObject *capi_sx_tmp = NULL;
  int capi_sx_intent = 0;
  PyObject *sx_capi = Py_None;
  int incx = 0;
  PyObject *incx_capi = Py_None;
  static char *capi_kwlist[] = {"n","sx","incx",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|:atomic_program.isamax",\
    capi_kwlist,&n_capi,&sx_capi,&incx_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.isamax() 1st argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable sx */
  ;
  capi_sx_intent |= F2PY_INTENT_IN;
  capi_sx_tmp = array_from_pyobj(NPY_DOUBLE,sx_Dims,sx_Rank,capi_sx_intent,sx_capi);
  if (capi_sx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `sx' of atomic_program.isamax to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    sx = (double *)(PyArray_DATA(capi_sx_tmp));

  /* Processing variable incx */
    f2py_success = int_from_pyobj(&incx,incx_capi,"atomic_program.isamax() 3rd argument (incx) can't be converted to int");
  if (f2py_success) {
  /* Processing variable isamax */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&isamax,&n,sx,&incx);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",isamax);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable isamax */
  } /*if (f2py_success) of incx*/
  /* End of cleaning variable incx */
  if((PyObject *)capi_sx_tmp!=sx_capi) {
    Py_XDECREF(capi_sx_tmp); }
  }  /*if (capi_sx_tmp == NULL) ... else of sx*/
  /* End of cleaning variable sx */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of isamax *******************************/

/*********************************** sgesl ***********************************/
static char doc_f2py_rout_atomic_program_sgesl[] = "\
sgesl(a,n,ipvt,b,job,[lda])\n\nWrapper for ``sgesl``.\
\n\nParameters\n----------\n"
"a : input rank-2 array('d') with bounds (lda,*)\n"
"n : input int\n"
"ipvt : input rank-1 array('i') with bounds (*)\n"
"b : input rank-1 array('d') with bounds (*)\n"
"job : input int\n"
"\nOther Parameters\n----------------\n"
"lda : input int, optional\n    Default: shape(a,0)";
/* extern void F_FUNC(sgesl,SGESL)(double*,int*,int*,int*,double*,int*); */
static PyObject *f2py_rout_atomic_program_sgesl(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *a = NULL;
  npy_intp a_Dims[2] = {-1, -1};
  const int a_Rank = 2;
  PyArrayObject *capi_a_tmp = NULL;
  int capi_a_intent = 0;
  PyObject *a_capi = Py_None;
  int lda = 0;
  PyObject *lda_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  int *ipvt = NULL;
  npy_intp ipvt_Dims[1] = {-1};
  const int ipvt_Rank = 1;
  PyArrayObject *capi_ipvt_tmp = NULL;
  int capi_ipvt_intent = 0;
  PyObject *ipvt_capi = Py_None;
  double *b = NULL;
  npy_intp b_Dims[1] = {-1};
  const int b_Rank = 1;
  PyArrayObject *capi_b_tmp = NULL;
  int capi_b_intent = 0;
  PyObject *b_capi = Py_None;
  int job = 0;
  PyObject *job_capi = Py_None;
  static char *capi_kwlist[] = {"a","n","ipvt","b","job","lda",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO|O:atomic_program.sgesl",\
    capi_kwlist,&a_capi,&n_capi,&ipvt_capi,&b_capi,&job_capi,&lda_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable a */
  ;
  capi_a_intent |= F2PY_INTENT_IN;
  capi_a_tmp = array_from_pyobj(NPY_DOUBLE,a_Dims,a_Rank,capi_a_intent,a_capi);
  if (capi_a_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `a' of atomic_program.sgesl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    a = (double *)(PyArray_DATA(capi_a_tmp));

  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.sgesl() 2nd argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ipvt */
  ;
  capi_ipvt_intent |= F2PY_INTENT_IN;
  capi_ipvt_tmp = array_from_pyobj(NPY_INT,ipvt_Dims,ipvt_Rank,capi_ipvt_intent,ipvt_capi);
  if (capi_ipvt_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `ipvt' of atomic_program.sgesl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ipvt = (int *)(PyArray_DATA(capi_ipvt_tmp));

  /* Processing variable b */
  ;
  capi_b_intent |= F2PY_INTENT_IN;
  capi_b_tmp = array_from_pyobj(NPY_DOUBLE,b_Dims,b_Rank,capi_b_intent,b_capi);
  if (capi_b_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `b' of atomic_program.sgesl to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    b = (double *)(PyArray_DATA(capi_b_tmp));

  /* Processing variable job */
    f2py_success = int_from_pyobj(&job,job_capi,"atomic_program.sgesl() 5th argument (job) can't be converted to int");
  if (f2py_success) {
  /* Processing variable lda */
  if (lda_capi == Py_None) lda = shape(a,0); else
    f2py_success = int_from_pyobj(&lda,lda_capi,"atomic_program.sgesl() 1st keyword (lda) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(a,0)==lda,"shape(a,0)==lda","1st keyword lda","sgesl:lda=%d",lda) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(a,&lda,&n,ipvt,b,&job);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR(shape(a,0)==lda)*/
  } /*if (f2py_success) of lda*/
  /* End of cleaning variable lda */
  } /*if (f2py_success) of job*/
  /* End of cleaning variable job */
  if((PyObject *)capi_b_tmp!=b_capi) {
    Py_XDECREF(capi_b_tmp); }
  }  /*if (capi_b_tmp == NULL) ... else of b*/
  /* End of cleaning variable b */
  if((PyObject *)capi_ipvt_tmp!=ipvt_capi) {
    Py_XDECREF(capi_ipvt_tmp); }
  }  /*if (capi_ipvt_tmp == NULL) ... else of ipvt*/
  /* End of cleaning variable ipvt */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_a_tmp!=a_capi) {
    Py_XDECREF(capi_a_tmp); }
  }  /*if (capi_a_tmp == NULL) ... else of a*/
  /* End of cleaning variable a */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of sgesl ********************************/

/********************************** isrchfgt **********************************/
static char doc_f2py_rout_atomic_program_isrchfgt[] = "\
isrchfgt = isrchfgt(n,array,inc,target)\n\nWrapper for ``isrchfgt``.\
\n\nParameters\n----------\n"
"n : input int\n"
"array : input rank-1 array('d') with bounds (*)\n"
"inc : input int\n"
"target : input float\n"
"\nReturns\n-------\n"
"isrchfgt : int";
/* extern void F_WRAPPEDFUNC(isrchfgt,ISRCHFGT)(int*,int*,double*,int*,double*); */
static PyObject *f2py_rout_atomic_program_isrchfgt(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,int*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int isrchfgt = 0;
  int n = 0;
  PyObject *n_capi = Py_None;
  double *array = NULL;
  npy_intp array_Dims[1] = {-1};
  const int array_Rank = 1;
  PyArrayObject *capi_array_tmp = NULL;
  int capi_array_intent = 0;
  PyObject *array_capi = Py_None;
  int inc = 0;
  PyObject *inc_capi = Py_None;
  double target = 0;
  PyObject *target_capi = Py_None;
  static char *capi_kwlist[] = {"n","array","inc","target",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|:atomic_program.isrchfgt",\
    capi_kwlist,&n_capi,&array_capi,&inc_capi,&target_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.isrchfgt() 1st argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable array */
  ;
  capi_array_intent |= F2PY_INTENT_IN;
  capi_array_tmp = array_from_pyobj(NPY_DOUBLE,array_Dims,array_Rank,capi_array_intent,array_capi);
  if (capi_array_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `array' of atomic_program.isrchfgt to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    array = (double *)(PyArray_DATA(capi_array_tmp));

  /* Processing variable inc */
    f2py_success = int_from_pyobj(&inc,inc_capi,"atomic_program.isrchfgt() 3rd argument (inc) can't be converted to int");
  if (f2py_success) {
  /* Processing variable target */
    f2py_success = double_from_pyobj(&target,target_capi,"atomic_program.isrchfgt() 4th argument (target) can't be converted to double");
  if (f2py_success) {
  /* Processing variable isrchfgt */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&isrchfgt,&n,array,&inc,&target);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",isrchfgt);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable isrchfgt */
  } /*if (f2py_success) of target*/
  /* End of cleaning variable target */
  } /*if (f2py_success) of inc*/
  /* End of cleaning variable inc */
  if((PyObject *)capi_array_tmp!=array_capi) {
    Py_XDECREF(capi_array_tmp); }
  }  /*if (capi_array_tmp == NULL) ... else of array*/
  /* End of cleaning variable array */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of isrchfgt ******************************/

/************************************ hunt ************************************/
static char doc_f2py_rout_atomic_program_hunt[] = "\
hunt(xx,x,jlo,[n])\n\nWrapper for ``hunt``.\
\n\nParameters\n----------\n"
"xx : input rank-1 array('d') with bounds (n)\n"
"x : input float\n"
"jlo : input int\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: len(xx)";
/* extern void F_FUNC(hunt,HUNT)(double*,int*,double*,int*); */
static PyObject *f2py_rout_atomic_program_hunt(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *xx = NULL;
  npy_intp xx_Dims[1] = {-1};
  const int xx_Rank = 1;
  PyArrayObject *capi_xx_tmp = NULL;
  int capi_xx_intent = 0;
  PyObject *xx_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double x = 0;
  PyObject *x_capi = Py_None;
  int jlo = 0;
  PyObject *jlo_capi = Py_None;
  static char *capi_kwlist[] = {"xx","x","jlo","n",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|O:atomic_program.hunt",\
    capi_kwlist,&xx_capi,&x_capi,&jlo_capi,&n_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable xx */
  ;
  capi_xx_intent |= F2PY_INTENT_IN;
  capi_xx_tmp = array_from_pyobj(NPY_DOUBLE,xx_Dims,xx_Rank,capi_xx_intent,xx_capi);
  if (capi_xx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `xx' of atomic_program.hunt to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    xx = (double *)(PyArray_DATA(capi_xx_tmp));

  /* Processing variable x */
    f2py_success = double_from_pyobj(&x,x_capi,"atomic_program.hunt() 2nd argument (x) can't be converted to double");
  if (f2py_success) {
  /* Processing variable jlo */
    f2py_success = int_from_pyobj(&jlo,jlo_capi,"atomic_program.hunt() 3rd argument (jlo) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n */
  if (n_capi == Py_None) n = len(xx); else
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.hunt() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(xx)>=n,"len(xx)>=n","1st keyword n","hunt:n=%d",n) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(xx,&n,&x,&jlo);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR(len(xx)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of jlo*/
  /* End of cleaning variable jlo */
  } /*if (f2py_success) of x*/
  /* End of cleaning variable x */
  if((PyObject *)capi_xx_tmp!=xx_capi) {
    Py_XDECREF(capi_xx_tmp); }
  }  /*if (capi_xx_tmp == NULL) ... else of xx*/
  /* End of cleaning variable xx */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of hunt ********************************/

/*********************************** locate ***********************************/
static char doc_f2py_rout_atomic_program_locate[] = "\
locate(xx,x,j,[n])\n\nWrapper for ``locate``.\
\n\nParameters\n----------\n"
"xx : input rank-1 array('d') with bounds (n)\n"
"x : input float\n"
"j : input int\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: len(xx)";
/* extern void F_FUNC(locate,LOCATE)(double*,int*,double*,int*); */
static PyObject *f2py_rout_atomic_program_locate(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *xx = NULL;
  npy_intp xx_Dims[1] = {-1};
  const int xx_Rank = 1;
  PyArrayObject *capi_xx_tmp = NULL;
  int capi_xx_intent = 0;
  PyObject *xx_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double x = 0;
  PyObject *x_capi = Py_None;
  int j = 0;
  PyObject *j_capi = Py_None;
  static char *capi_kwlist[] = {"xx","x","j","n",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|O:atomic_program.locate",\
    capi_kwlist,&xx_capi,&x_capi,&j_capi,&n_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable xx */
  ;
  capi_xx_intent |= F2PY_INTENT_IN;
  capi_xx_tmp = array_from_pyobj(NPY_DOUBLE,xx_Dims,xx_Rank,capi_xx_intent,xx_capi);
  if (capi_xx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `xx' of atomic_program.locate to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    xx = (double *)(PyArray_DATA(capi_xx_tmp));

  /* Processing variable x */
    f2py_success = double_from_pyobj(&x,x_capi,"atomic_program.locate() 2nd argument (x) can't be converted to double");
  if (f2py_success) {
  /* Processing variable j */
    f2py_success = int_from_pyobj(&j,j_capi,"atomic_program.locate() 3rd argument (j) can't be converted to int");
  if (f2py_success) {
  /* Processing variable n */
  if (n_capi == Py_None) n = len(xx); else
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.locate() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(xx)>=n,"len(xx)>=n","1st keyword n","locate:n=%d",n) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(xx,&n,&x,&j);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR(len(xx)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of j*/
  /* End of cleaning variable j */
  } /*if (f2py_success) of x*/
  /* End of cleaning variable x */
  if((PyObject *)capi_xx_tmp!=xx_capi) {
    Py_XDECREF(capi_xx_tmp); }
  }  /*if (capi_xx_tmp == NULL) ... else of xx*/
  /* End of cleaning variable xx */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of locate *******************************/

/*********************************** odeint ***********************************/
static char doc_f2py_rout_atomic_program_odeint[] = "\
odeint(ystart,x1,x2,eps,h1,hmin,nok,nbad,derivs,rkqc,[nvar,derivs_extra_args,rkqc_extra_args])\n\nWrapper for ``odeint``.\
\n\nParameters\n----------\n"
"ystart : input rank-1 array('d') with bounds (nvar)\n"
"x1 : input float\n"
"x2 : input float\n"
"eps : input float\n"
"h1 : input float\n"
"hmin : input float\n"
"nok : input int\n"
"nbad : input int\n"
"derivs : call-back function\n"
"rkqc : call-back function\n"
"\nOther Parameters\n----------------\n"
"nvar : input int, optional\n    Default: len(ystart)\n"
"derivs_extra_args : input tuple, optional\n    Default: ()\n"
"rkqc_extra_args : input tuple, optional\n    Default: ()\n"
"\nNotes\n-----\nCall-back functions::\n\n"
"  def derivs(x,y,dydx): return \n\
  Required arguments:\n"
"    x : input float\n"
"    y : input rank-1 array('d') with bounds (10)\n"
"    dydx : input rank-1 array('d') with bounds (10)\n"
"  def rkqc(y,dydx,nvar,x,h,eps,yscal,hdid,hnext,derivs): return \n\
  Required arguments:\n"
"    y : input rank-1 array('d') with bounds (10)\n"
"    dydx : input rank-1 array('d') with bounds (10)\n"
"    nvar : input int\n"
"    x : input float\n"
"    h : input float\n"
"    eps : input float\n"
"    yscal : input rank-1 array('d') with bounds (10)\n"
"    hdid : input float\n"
"    hnext : input float\n"
"    derivs : call-back function";
/* extern void F_FUNC(odeint,ODEINT)(double*,int*,double*,double*,double*,double*,double*,int*,int*,cb_derivs_in_odeint__user__routines_typedef,cb_rkqc_in_odeint__user__routines_typedef); */
static PyObject *f2py_rout_atomic_program_odeint(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,double*,double*,double*,double*,int*,int*,cb_derivs_in_odeint__user__routines_typedef,cb_rkqc_in_odeint__user__routines_typedef)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *ystart = NULL;
  npy_intp ystart_Dims[1] = {-1};
  const int ystart_Rank = 1;
  PyArrayObject *capi_ystart_tmp = NULL;
  int capi_ystart_intent = 0;
  PyObject *ystart_capi = Py_None;
  int nvar = 0;
  PyObject *nvar_capi = Py_None;
  double x1 = 0;
  PyObject *x1_capi = Py_None;
  double x2 = 0;
  PyObject *x2_capi = Py_None;
  double eps = 0;
  PyObject *eps_capi = Py_None;
  double h1 = 0;
  PyObject *h1_capi = Py_None;
  double hmin = 0;
  PyObject *hmin_capi = Py_None;
  int nok = 0;
  PyObject *nok_capi = Py_None;
  int nbad = 0;
  PyObject *nbad_capi = Py_None;
  PyObject *derivs_capi = Py_None;
  PyTupleObject *derivs_xa_capi = NULL;
  PyTupleObject *derivs_args_capi = NULL;
  int derivs_nofargs_capi = 0;
  cb_derivs_in_odeint__user__routines_typedef derivs_cptr;
  PyObject *rkqc_capi = Py_None;
  PyTupleObject *rkqc_xa_capi = NULL;
  PyTupleObject *rkqc_args_capi = NULL;
  int rkqc_nofargs_capi = 0;
  cb_rkqc_in_odeint__user__routines_typedef rkqc_cptr;
  static char *capi_kwlist[] = {"ystart","x1","x2","eps","h1","hmin","nok","nbad","derivs","rkqc","nvar","derivs_extra_args","rkqc_extra_args",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOO|OO!O!:atomic_program.odeint",\
    capi_kwlist,&ystart_capi,&x1_capi,&x2_capi,&eps_capi,&h1_capi,&hmin_capi,&nok_capi,&nbad_capi,&derivs_capi,&rkqc_capi,&nvar_capi,&PyTuple_Type,&derivs_xa_capi,&PyTuple_Type,&rkqc_xa_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable ystart */
  ;
  capi_ystart_intent |= F2PY_INTENT_IN;
  capi_ystart_tmp = array_from_pyobj(NPY_DOUBLE,ystart_Dims,ystart_Rank,capi_ystart_intent,ystart_capi);
  if (capi_ystart_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `ystart' of atomic_program.odeint to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ystart = (double *)(PyArray_DATA(capi_ystart_tmp));

  /* Processing variable x1 */
    f2py_success = double_from_pyobj(&x1,x1_capi,"atomic_program.odeint() 2nd argument (x1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable x2 */
    f2py_success = double_from_pyobj(&x2,x2_capi,"atomic_program.odeint() 3rd argument (x2) can't be converted to double");
  if (f2py_success) {
  /* Processing variable eps */
    f2py_success = double_from_pyobj(&eps,eps_capi,"atomic_program.odeint() 4th argument (eps) can't be converted to double");
  if (f2py_success) {
  /* Processing variable h1 */
    f2py_success = double_from_pyobj(&h1,h1_capi,"atomic_program.odeint() 5th argument (h1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable hmin */
    f2py_success = double_from_pyobj(&hmin,hmin_capi,"atomic_program.odeint() 6th argument (hmin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nok */
    f2py_success = int_from_pyobj(&nok,nok_capi,"atomic_program.odeint() 7th argument (nok) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nbad */
    f2py_success = int_from_pyobj(&nbad,nbad_capi,"atomic_program.odeint() 8th argument (nbad) can't be converted to int");
  if (f2py_success) {
  /* Processing variable derivs */
if(F2PyCapsule_Check(derivs_capi)) {
  derivs_cptr = F2PyCapsule_AsVoidPtr(derivs_capi);
} else {
  derivs_cptr = cb_derivs_in_odeint__user__routines;
}

  derivs_nofargs_capi = cb_derivs_in_odeint__user__routines_nofargs;
  if (create_cb_arglist(derivs_capi,derivs_xa_capi,3,0,&cb_derivs_in_odeint__user__routines_nofargs,&derivs_args_capi,"failed in processing argument list for call-back derivs.")) {
    jmp_buf derivs_jmpbuf;
    CFUNCSMESS("Saving jmpbuf for `derivs`.\n");
    SWAP(derivs_capi,cb_derivs_in_odeint__user__routines_capi,PyObject);
    SWAP(derivs_args_capi,cb_derivs_in_odeint__user__routines_args_capi,PyTupleObject);
    memcpy(&derivs_jmpbuf,&cb_derivs_in_odeint__user__routines_jmpbuf,sizeof(jmp_buf));
  /* Processing variable rkqc */
if(F2PyCapsule_Check(rkqc_capi)) {
  rkqc_cptr = F2PyCapsule_AsVoidPtr(rkqc_capi);
} else {
  rkqc_cptr = cb_rkqc_in_odeint__user__routines;
}

  rkqc_nofargs_capi = cb_rkqc_in_odeint__user__routines_nofargs;
  if (create_cb_arglist(rkqc_capi,rkqc_xa_capi,10,0,&cb_rkqc_in_odeint__user__routines_nofargs,&rkqc_args_capi,"failed in processing argument list for call-back rkqc.")) {
    jmp_buf rkqc_jmpbuf;
    CFUNCSMESS("Saving jmpbuf for `rkqc`.\n");
    SWAP(rkqc_capi,cb_rkqc_in_odeint__user__routines_capi,PyObject);
    SWAP(rkqc_args_capi,cb_rkqc_in_odeint__user__routines_args_capi,PyTupleObject);
    memcpy(&rkqc_jmpbuf,&cb_rkqc_in_odeint__user__routines_jmpbuf,sizeof(jmp_buf));
  /* Processing variable nvar */
  if (nvar_capi == Py_None) nvar = len(ystart); else
    f2py_success = int_from_pyobj(&nvar,nvar_capi,"atomic_program.odeint() 1st keyword (nvar) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(ystart)>=nvar,"len(ystart)>=nvar","1st keyword nvar","odeint:nvar=%d",nvar) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
    if ((setjmp(cb_derivs_in_odeint__user__routines_jmpbuf)) || (setjmp(cb_rkqc_in_odeint__user__routines_jmpbuf))) {
      f2py_success = 0;
    } else {
        (*f2py_func)(ystart,&nvar,&x1,&x2,&eps,&h1,&hmin,&nok,&nbad,derivs_cptr,rkqc_cptr);
    }
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*CHECKSCALAR(len(ystart)>=nvar)*/
  } /*if (f2py_success) of nvar*/
  /* End of cleaning variable nvar */
    CFUNCSMESS("Restoring jmpbuf for `rkqc`.\n");
    cb_rkqc_in_odeint__user__routines_capi = rkqc_capi;
    Py_DECREF(cb_rkqc_in_odeint__user__routines_args_capi);
    cb_rkqc_in_odeint__user__routines_args_capi = rkqc_args_capi;
    cb_rkqc_in_odeint__user__routines_nofargs = rkqc_nofargs_capi;
    memcpy(&cb_rkqc_in_odeint__user__routines_jmpbuf,&rkqc_jmpbuf,sizeof(jmp_buf));
  }
  /* End of cleaning variable rkqc */
    CFUNCSMESS("Restoring jmpbuf for `derivs`.\n");
    cb_derivs_in_odeint__user__routines_capi = derivs_capi;
    Py_DECREF(cb_derivs_in_odeint__user__routines_args_capi);
    cb_derivs_in_odeint__user__routines_args_capi = derivs_args_capi;
    cb_derivs_in_odeint__user__routines_nofargs = derivs_nofargs_capi;
    memcpy(&cb_derivs_in_odeint__user__routines_jmpbuf,&derivs_jmpbuf,sizeof(jmp_buf));
  }
  /* End of cleaning variable derivs */
  } /*if (f2py_success) of nbad*/
  /* End of cleaning variable nbad */
  } /*if (f2py_success) of nok*/
  /* End of cleaning variable nok */
  } /*if (f2py_success) of hmin*/
  /* End of cleaning variable hmin */
  } /*if (f2py_success) of h1*/
  /* End of cleaning variable h1 */
  } /*if (f2py_success) of eps*/
  /* End of cleaning variable eps */
  } /*if (f2py_success) of x2*/
  /* End of cleaning variable x2 */
  } /*if (f2py_success) of x1*/
  /* End of cleaning variable x1 */
  if((PyObject *)capi_ystart_tmp!=ystart_capi) {
    Py_XDECREF(capi_ystart_tmp); }
  }  /*if (capi_ystart_tmp == NULL) ... else of ystart*/
  /* End of cleaning variable ystart */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of odeint *******************************/

/*********************************** polint ***********************************/
static char doc_f2py_rout_atomic_program_polint[] = "\
polint(xa,ya,x,y,dy,[n])\n\nWrapper for ``polint``.\
\n\nParameters\n----------\n"
"xa : input rank-1 array('d') with bounds (n)\n"
"ya : input rank-1 array('d') with bounds (n)\n"
"x : input float\n"
"y : input float\n"
"dy : input float\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: len(xa)";
/* extern void F_FUNC(polint,POLINT)(double*,double*,int*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_polint(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *xa = NULL;
  npy_intp xa_Dims[1] = {-1};
  const int xa_Rank = 1;
  PyArrayObject *capi_xa_tmp = NULL;
  int capi_xa_intent = 0;
  PyObject *xa_capi = Py_None;
  double *ya = NULL;
  npy_intp ya_Dims[1] = {-1};
  const int ya_Rank = 1;
  PyArrayObject *capi_ya_tmp = NULL;
  int capi_ya_intent = 0;
  PyObject *ya_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double x = 0;
  PyObject *x_capi = Py_None;
  double y = 0;
  PyObject *y_capi = Py_None;
  double dy = 0;
  PyObject *dy_capi = Py_None;
  static char *capi_kwlist[] = {"xa","ya","x","y","dy","n",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO|O:atomic_program.polint",\
    capi_kwlist,&xa_capi,&ya_capi,&x_capi,&y_capi,&dy_capi,&n_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable xa */
  ;
  capi_xa_intent |= F2PY_INTENT_IN;
  capi_xa_tmp = array_from_pyobj(NPY_DOUBLE,xa_Dims,xa_Rank,capi_xa_intent,xa_capi);
  if (capi_xa_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `xa' of atomic_program.polint to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    xa = (double *)(PyArray_DATA(capi_xa_tmp));

  /* Processing variable x */
    f2py_success = double_from_pyobj(&x,x_capi,"atomic_program.polint() 3rd argument (x) can't be converted to double");
  if (f2py_success) {
  /* Processing variable y */
    f2py_success = double_from_pyobj(&y,y_capi,"atomic_program.polint() 4th argument (y) can't be converted to double");
  if (f2py_success) {
  /* Processing variable dy */
    f2py_success = double_from_pyobj(&dy,dy_capi,"atomic_program.polint() 5th argument (dy) can't be converted to double");
  if (f2py_success) {
  /* Processing variable n */
  if (n_capi == Py_None) n = len(xa); else
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.polint() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(xa)>=n,"len(xa)>=n","1st keyword n","polint:n=%d",n) {
  /* Processing variable ya */
  ya_Dims[0]=n;
  capi_ya_intent |= F2PY_INTENT_IN;
  capi_ya_tmp = array_from_pyobj(NPY_DOUBLE,ya_Dims,ya_Rank,capi_ya_intent,ya_capi);
  if (capi_ya_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `ya' of atomic_program.polint to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ya = (double *)(PyArray_DATA(capi_ya_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(xa,ya,&n,&x,&y,&dy);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_ya_tmp!=ya_capi) {
    Py_XDECREF(capi_ya_tmp); }
  }  /*if (capi_ya_tmp == NULL) ... else of ya*/
  /* End of cleaning variable ya */
  } /*CHECKSCALAR(len(xa)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  } /*if (f2py_success) of dy*/
  /* End of cleaning variable dy */
  } /*if (f2py_success) of y*/
  /* End of cleaning variable y */
  } /*if (f2py_success) of x*/
  /* End of cleaning variable x */
  if((PyObject *)capi_xa_tmp!=xa_capi) {
    Py_XDECREF(capi_xa_tmp); }
  }  /*if (capi_xa_tmp == NULL) ... else of xa*/
  /* End of cleaning variable xa */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of polint *******************************/

/************************************ rkqc ************************************/
static char doc_f2py_rout_atomic_program_rkqc[] = "\
rkqc(y,dydx,n,x,htry,eps,yscal,hdid,hnext,derivs,[derivs_extra_args])\n\nWrapper for ``rkqc``.\
\n\nParameters\n----------\n"
"y : input rank-1 array('d') with bounds (10)\n"
"dydx : input rank-1 array('d') with bounds (10)\n"
"n : input int\n"
"x : input float\n"
"htry : input float\n"
"eps : input float\n"
"yscal : input rank-1 array('d') with bounds (10)\n"
"hdid : input float\n"
"hnext : input float\n"
"derivs : call-back function\n"
"\nOther Parameters\n----------------\n"
"derivs_extra_args : input tuple, optional\n    Default: ()\n"
"\nNotes\n-----\nCall-back functions::\n\n"
"  def derivs(x,ytemp,dydx): return \n\
  Required arguments:\n"
"    x : input float\n"
"    ytemp : input rank-1 array('d') with bounds (10)\n"
"    dydx : input rank-1 array('d') with bounds (10)";
/* extern void F_FUNC(rkqc,RKQC)(double*,double*,int*,double*,double*,double*,double*,double*,double*,cb_derivs_in_rkqc__user__routines_typedef); */
static PyObject *f2py_rout_atomic_program_rkqc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,double*,double*,double*,double*,double*,double*,cb_derivs_in_rkqc__user__routines_typedef)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *y = NULL;
  npy_intp y_Dims[1] = {-1};
  const int y_Rank = 1;
  PyArrayObject *capi_y_tmp = NULL;
  int capi_y_intent = 0;
  PyObject *y_capi = Py_None;
  double *dydx = NULL;
  npy_intp dydx_Dims[1] = {-1};
  const int dydx_Rank = 1;
  PyArrayObject *capi_dydx_tmp = NULL;
  int capi_dydx_intent = 0;
  PyObject *dydx_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double x = 0;
  PyObject *x_capi = Py_None;
  double htry = 0;
  PyObject *htry_capi = Py_None;
  double eps = 0;
  PyObject *eps_capi = Py_None;
  double *yscal = NULL;
  npy_intp yscal_Dims[1] = {-1};
  const int yscal_Rank = 1;
  PyArrayObject *capi_yscal_tmp = NULL;
  int capi_yscal_intent = 0;
  PyObject *yscal_capi = Py_None;
  double hdid = 0;
  PyObject *hdid_capi = Py_None;
  double hnext = 0;
  PyObject *hnext_capi = Py_None;
  PyObject *derivs_capi = Py_None;
  PyTupleObject *derivs_xa_capi = NULL;
  PyTupleObject *derivs_args_capi = NULL;
  int derivs_nofargs_capi = 0;
  cb_derivs_in_rkqc__user__routines_typedef derivs_cptr;
  static char *capi_kwlist[] = {"y","dydx","n","x","htry","eps","yscal","hdid","hnext","derivs","derivs_extra_args",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOO|O!:atomic_program.rkqc",\
    capi_kwlist,&y_capi,&dydx_capi,&n_capi,&x_capi,&htry_capi,&eps_capi,&yscal_capi,&hdid_capi,&hnext_capi,&derivs_capi,&PyTuple_Type,&derivs_xa_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable y */
  y_Dims[0]=10;
  capi_y_intent |= F2PY_INTENT_IN;
  capi_y_tmp = array_from_pyobj(NPY_DOUBLE,y_Dims,y_Rank,capi_y_intent,y_capi);
  if (capi_y_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `y' of atomic_program.rkqc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    y = (double *)(PyArray_DATA(capi_y_tmp));

  /* Processing variable dydx */
  dydx_Dims[0]=10;
  capi_dydx_intent |= F2PY_INTENT_IN;
  capi_dydx_tmp = array_from_pyobj(NPY_DOUBLE,dydx_Dims,dydx_Rank,capi_dydx_intent,dydx_capi);
  if (capi_dydx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `dydx' of atomic_program.rkqc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dydx = (double *)(PyArray_DATA(capi_dydx_tmp));

  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.rkqc() 3rd argument (n) can't be converted to int");
  if (f2py_success) {
  /* Processing variable x */
    f2py_success = double_from_pyobj(&x,x_capi,"atomic_program.rkqc() 4th argument (x) can't be converted to double");
  if (f2py_success) {
  /* Processing variable htry */
    f2py_success = double_from_pyobj(&htry,htry_capi,"atomic_program.rkqc() 5th argument (htry) can't be converted to double");
  if (f2py_success) {
  /* Processing variable eps */
    f2py_success = double_from_pyobj(&eps,eps_capi,"atomic_program.rkqc() 6th argument (eps) can't be converted to double");
  if (f2py_success) {
  /* Processing variable yscal */
  yscal_Dims[0]=10;
  capi_yscal_intent |= F2PY_INTENT_IN;
  capi_yscal_tmp = array_from_pyobj(NPY_DOUBLE,yscal_Dims,yscal_Rank,capi_yscal_intent,yscal_capi);
  if (capi_yscal_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `yscal' of atomic_program.rkqc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    yscal = (double *)(PyArray_DATA(capi_yscal_tmp));

  /* Processing variable hdid */
    f2py_success = double_from_pyobj(&hdid,hdid_capi,"atomic_program.rkqc() 8th argument (hdid) can't be converted to double");
  if (f2py_success) {
  /* Processing variable hnext */
    f2py_success = double_from_pyobj(&hnext,hnext_capi,"atomic_program.rkqc() 9th argument (hnext) can't be converted to double");
  if (f2py_success) {
  /* Processing variable derivs */
if(F2PyCapsule_Check(derivs_capi)) {
  derivs_cptr = F2PyCapsule_AsVoidPtr(derivs_capi);
} else {
  derivs_cptr = cb_derivs_in_rkqc__user__routines;
}

  derivs_nofargs_capi = cb_derivs_in_rkqc__user__routines_nofargs;
  if (create_cb_arglist(derivs_capi,derivs_xa_capi,3,0,&cb_derivs_in_rkqc__user__routines_nofargs,&derivs_args_capi,"failed in processing argument list for call-back derivs.")) {
    jmp_buf derivs_jmpbuf;
    CFUNCSMESS("Saving jmpbuf for `derivs`.\n");
    SWAP(derivs_capi,cb_derivs_in_rkqc__user__routines_capi,PyObject);
    SWAP(derivs_args_capi,cb_derivs_in_rkqc__user__routines_args_capi,PyTupleObject);
    memcpy(&derivs_jmpbuf,&cb_derivs_in_rkqc__user__routines_jmpbuf,sizeof(jmp_buf));
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
    if ((setjmp(cb_derivs_in_rkqc__user__routines_jmpbuf))) {
      f2py_success = 0;
    } else {
        (*f2py_func)(y,dydx,&n,&x,&htry,&eps,yscal,&hdid,&hnext,derivs_cptr);
    }
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    CFUNCSMESS("Restoring jmpbuf for `derivs`.\n");
    cb_derivs_in_rkqc__user__routines_capi = derivs_capi;
    Py_DECREF(cb_derivs_in_rkqc__user__routines_args_capi);
    cb_derivs_in_rkqc__user__routines_args_capi = derivs_args_capi;
    cb_derivs_in_rkqc__user__routines_nofargs = derivs_nofargs_capi;
    memcpy(&cb_derivs_in_rkqc__user__routines_jmpbuf,&derivs_jmpbuf,sizeof(jmp_buf));
  }
  /* End of cleaning variable derivs */
  } /*if (f2py_success) of hnext*/
  /* End of cleaning variable hnext */
  } /*if (f2py_success) of hdid*/
  /* End of cleaning variable hdid */
  if((PyObject *)capi_yscal_tmp!=yscal_capi) {
    Py_XDECREF(capi_yscal_tmp); }
  }  /*if (capi_yscal_tmp == NULL) ... else of yscal*/
  /* End of cleaning variable yscal */
  } /*if (f2py_success) of eps*/
  /* End of cleaning variable eps */
  } /*if (f2py_success) of htry*/
  /* End of cleaning variable htry */
  } /*if (f2py_success) of x*/
  /* End of cleaning variable x */
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_dydx_tmp!=dydx_capi) {
    Py_XDECREF(capi_dydx_tmp); }
  }  /*if (capi_dydx_tmp == NULL) ... else of dydx*/
  /* End of cleaning variable dydx */
  if((PyObject *)capi_y_tmp!=y_capi) {
    Py_XDECREF(capi_y_tmp); }
  }  /*if (capi_y_tmp == NULL) ... else of y*/
  /* End of cleaning variable y */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of rkqc ********************************/

/************************************ rk4 ************************************/
static char doc_f2py_rout_atomic_program_rk4[] = "\
rk4(y,dydx,x,h,yout,derivs,[n,derivs_extra_args])\n\nWrapper for ``rk4``.\
\n\nParameters\n----------\n"
"y : input rank-1 array('d') with bounds (n)\n"
"dydx : input rank-1 array('d') with bounds (n)\n"
"x : input float\n"
"h : input float\n"
"yout : input rank-1 array('d') with bounds (n)\n"
"derivs : call-back function\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: len(y)\n"
"derivs_extra_args : input tuple, optional\n    Default: ()\n"
"\nNotes\n-----\nCall-back functions::\n\n"
"  def derivs(xh,yt,dyt): return \n\
  Required arguments:\n"
"    xh : input float\n"
"    yt : input rank-1 array('d') with bounds (10)\n"
"    dyt : input rank-1 array('d') with bounds (10)";
/* extern void F_FUNC(rk4,RK4)(double*,double*,int*,double*,double*,double*,cb_derivs_in_rk4__user__routines_typedef); */
static PyObject *f2py_rout_atomic_program_rk4(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,int*,double*,double*,double*,cb_derivs_in_rk4__user__routines_typedef)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *y = NULL;
  npy_intp y_Dims[1] = {-1};
  const int y_Rank = 1;
  PyArrayObject *capi_y_tmp = NULL;
  int capi_y_intent = 0;
  PyObject *y_capi = Py_None;
  double *dydx = NULL;
  npy_intp dydx_Dims[1] = {-1};
  const int dydx_Rank = 1;
  PyArrayObject *capi_dydx_tmp = NULL;
  int capi_dydx_intent = 0;
  PyObject *dydx_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double x = 0;
  PyObject *x_capi = Py_None;
  double h = 0;
  PyObject *h_capi = Py_None;
  double *yout = NULL;
  npy_intp yout_Dims[1] = {-1};
  const int yout_Rank = 1;
  PyArrayObject *capi_yout_tmp = NULL;
  int capi_yout_intent = 0;
  PyObject *yout_capi = Py_None;
  PyObject *derivs_capi = Py_None;
  PyTupleObject *derivs_xa_capi = NULL;
  PyTupleObject *derivs_args_capi = NULL;
  int derivs_nofargs_capi = 0;
  cb_derivs_in_rk4__user__routines_typedef derivs_cptr;
  static char *capi_kwlist[] = {"y","dydx","x","h","yout","derivs","n","derivs_extra_args",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOO|OO!:atomic_program.rk4",\
    capi_kwlist,&y_capi,&dydx_capi,&x_capi,&h_capi,&yout_capi,&derivs_capi,&n_capi,&PyTuple_Type,&derivs_xa_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable y */
  ;
  capi_y_intent |= F2PY_INTENT_IN;
  capi_y_tmp = array_from_pyobj(NPY_DOUBLE,y_Dims,y_Rank,capi_y_intent,y_capi);
  if (capi_y_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `y' of atomic_program.rk4 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    y = (double *)(PyArray_DATA(capi_y_tmp));

  /* Processing variable x */
    f2py_success = double_from_pyobj(&x,x_capi,"atomic_program.rk4() 3rd argument (x) can't be converted to double");
  if (f2py_success) {
  /* Processing variable h */
    f2py_success = double_from_pyobj(&h,h_capi,"atomic_program.rk4() 4th argument (h) can't be converted to double");
  if (f2py_success) {
  /* Processing variable derivs */
if(F2PyCapsule_Check(derivs_capi)) {
  derivs_cptr = F2PyCapsule_AsVoidPtr(derivs_capi);
} else {
  derivs_cptr = cb_derivs_in_rk4__user__routines;
}

  derivs_nofargs_capi = cb_derivs_in_rk4__user__routines_nofargs;
  if (create_cb_arglist(derivs_capi,derivs_xa_capi,3,0,&cb_derivs_in_rk4__user__routines_nofargs,&derivs_args_capi,"failed in processing argument list for call-back derivs.")) {
    jmp_buf derivs_jmpbuf;
    CFUNCSMESS("Saving jmpbuf for `derivs`.\n");
    SWAP(derivs_capi,cb_derivs_in_rk4__user__routines_capi,PyObject);
    SWAP(derivs_args_capi,cb_derivs_in_rk4__user__routines_args_capi,PyTupleObject);
    memcpy(&derivs_jmpbuf,&cb_derivs_in_rk4__user__routines_jmpbuf,sizeof(jmp_buf));
  /* Processing variable n */
  if (n_capi == Py_None) n = len(y); else
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.rk4() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(y)>=n,"len(y)>=n","1st keyword n","rk4:n=%d",n) {
  /* Processing variable yout */
  yout_Dims[0]=n;
  capi_yout_intent |= F2PY_INTENT_IN;
  capi_yout_tmp = array_from_pyobj(NPY_DOUBLE,yout_Dims,yout_Rank,capi_yout_intent,yout_capi);
  if (capi_yout_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `yout' of atomic_program.rk4 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    yout = (double *)(PyArray_DATA(capi_yout_tmp));

  /* Processing variable dydx */
  dydx_Dims[0]=n;
  capi_dydx_intent |= F2PY_INTENT_IN;
  capi_dydx_tmp = array_from_pyobj(NPY_DOUBLE,dydx_Dims,dydx_Rank,capi_dydx_intent,dydx_capi);
  if (capi_dydx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `dydx' of atomic_program.rk4 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dydx = (double *)(PyArray_DATA(capi_dydx_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
    if ((setjmp(cb_derivs_in_rk4__user__routines_jmpbuf))) {
      f2py_success = 0;
    } else {
        (*f2py_func)(y,dydx,&n,&x,&h,yout,derivs_cptr);
    }
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dydx_tmp!=dydx_capi) {
    Py_XDECREF(capi_dydx_tmp); }
  }  /*if (capi_dydx_tmp == NULL) ... else of dydx*/
  /* End of cleaning variable dydx */
  if((PyObject *)capi_yout_tmp!=yout_capi) {
    Py_XDECREF(capi_yout_tmp); }
  }  /*if (capi_yout_tmp == NULL) ... else of yout*/
  /* End of cleaning variable yout */
  } /*CHECKSCALAR(len(y)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
    CFUNCSMESS("Restoring jmpbuf for `derivs`.\n");
    cb_derivs_in_rk4__user__routines_capi = derivs_capi;
    Py_DECREF(cb_derivs_in_rk4__user__routines_args_capi);
    cb_derivs_in_rk4__user__routines_args_capi = derivs_args_capi;
    cb_derivs_in_rk4__user__routines_nofargs = derivs_nofargs_capi;
    memcpy(&cb_derivs_in_rk4__user__routines_jmpbuf,&derivs_jmpbuf,sizeof(jmp_buf));
  }
  /* End of cleaning variable derivs */
  } /*if (f2py_success) of h*/
  /* End of cleaning variable h */
  } /*if (f2py_success) of x*/
  /* End of cleaning variable x */
  if((PyObject *)capi_y_tmp!=y_capi) {
    Py_XDECREF(capi_y_tmp); }
  }  /*if (capi_y_tmp == NULL) ... else of y*/
  /* End of cleaning variable y */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************************* end of rk4 *********************************/

/******************************* compat_params *******************************/
static char doc_f2py_rout_atomic_program_compat_params[] = "\
compat_params(str)\n\nWrapper for ``compat_params``.\
\n\nParameters\n----------\n"
"str : input string(len=-1)";
/* extern void F_FUNC_US(compat_params,COMPAT_PARAMS)(string,size_t); */
static PyObject *f2py_rout_atomic_program_compat_params(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string str = NULL;
  int slen(str);
  PyObject *str_capi = Py_None;
  static char *capi_kwlist[] = {"str",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.compat_params",\
    capi_kwlist,&str_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable str */
  slen(str) = -1;
  f2py_success = string_from_pyobj(&str,&slen(str),"",str_capi,"string_from_pyobj failed in converting 1st argument `str' of atomic_program.compat_params to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(str,slen(str));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(str);
  }  /*if (f2py_success) of str*/
  /* End of cleaning variable str */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of compat_params ****************************/

/********************************** pcc_exp **********************************/
static char doc_f2py_rout_atomic_program_pcc_exp[] = "\
pcc_exp(icore,ac,bc,cc,r,cdc,[nr])\n\nWrapper for ``pcc_exp``.\
\n\nParameters\n----------\n"
"icore : input int\n"
"ac : input float\n"
"bc : input float\n"
"cc : input float\n"
"r : input rank-1 array('d') with bounds (nr)\n"
"cdc : input rank-1 array('d') with bounds (nr)\n"
"\nOther Parameters\n----------------\n"
"nr : input int, optional\n    Default: len(r)";
/* extern void F_FUNC_US(pcc_exp,PCC_EXP)(int*,int*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_pcc_exp(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nr = 0;
  PyObject *nr_capi = Py_None;
  int icore = 0;
  PyObject *icore_capi = Py_None;
  double ac = 0;
  PyObject *ac_capi = Py_None;
  double bc = 0;
  PyObject *bc_capi = Py_None;
  double cc = 0;
  PyObject *cc_capi = Py_None;
  double *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  double *cdc = NULL;
  npy_intp cdc_Dims[1] = {-1};
  const int cdc_Rank = 1;
  PyArrayObject *capi_cdc_tmp = NULL;
  int capi_cdc_intent = 0;
  PyObject *cdc_capi = Py_None;
  static char *capi_kwlist[] = {"icore","ac","bc","cc","r","cdc","nr",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOO|O:atomic_program.pcc_exp",\
    capi_kwlist,&icore_capi,&ac_capi,&bc_capi,&cc_capi,&r_capi,&cdc_capi,&nr_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable icore */
    f2py_success = int_from_pyobj(&icore,icore_capi,"atomic_program.pcc_exp() 1st argument (icore) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ac */
    f2py_success = double_from_pyobj(&ac,ac_capi,"atomic_program.pcc_exp() 2nd argument (ac) can't be converted to double");
  if (f2py_success) {
  /* Processing variable bc */
    f2py_success = double_from_pyobj(&bc,bc_capi,"atomic_program.pcc_exp() 3rd argument (bc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable cc */
    f2py_success = double_from_pyobj(&cc,cc_capi,"atomic_program.pcc_exp() 4th argument (cc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable r */
  ;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_DOUBLE,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `r' of atomic_program.pcc_exp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    r = (double *)(PyArray_DATA(capi_r_tmp));

  /* Processing variable nr */
  if (nr_capi == Py_None) nr = len(r); else
    f2py_success = int_from_pyobj(&nr,nr_capi,"atomic_program.pcc_exp() 1st keyword (nr) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(r)>=nr,"len(r)>=nr","1st keyword nr","pcc_exp:nr=%d",nr) {
  /* Processing variable cdc */
  cdc_Dims[0]=nr;
  capi_cdc_intent |= F2PY_INTENT_IN;
  capi_cdc_tmp = array_from_pyobj(NPY_DOUBLE,cdc_Dims,cdc_Rank,capi_cdc_intent,cdc_capi);
  if (capi_cdc_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `cdc' of atomic_program.pcc_exp to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    cdc = (double *)(PyArray_DATA(capi_cdc_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nr,&icore,&ac,&bc,&cc,r,cdc);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_cdc_tmp!=cdc_capi) {
    Py_XDECREF(capi_cdc_tmp); }
  }  /*if (capi_cdc_tmp == NULL) ... else of cdc*/
  /* End of cleaning variable cdc */
  } /*CHECKSCALAR(len(r)>=nr)*/
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*if (f2py_success) of cc*/
  /* End of cleaning variable cc */
  } /*if (f2py_success) of bc*/
  /* End of cleaning variable bc */
  } /*if (f2py_success) of ac*/
  /* End of cleaning variable ac */
  } /*if (f2py_success) of icore*/
  /* End of cleaning variable icore */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pcc_exp *******************************/

/******************************* change_valence *******************************/
static char doc_f2py_rout_atomic_program_change_valence[] = "\
change_valence()\n\nWrapper for ``change_valence``.\
\n";
/* extern void F_FUNC_US(change_valence,CHANGE_VALENCE)(void); */
static PyObject *f2py_rout_atomic_program_change_valence(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:atomic_program.change_valence",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*************************** end of change_valence ***************************/

/*********************************** coreq ***********************************/
static char doc_f2py_rout_atomic_program_coreq[] = "\
coreq()\n\nWrapper for ``coreq``.\
\n";
/* extern void F_FUNC(coreq,COREQ)(void); */
static PyObject *f2py_rout_atomic_program_coreq(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:atomic_program.coreq",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of coreq ********************************/

/********************************** get_unit **********************************/
static char doc_f2py_rout_atomic_program_get_unit[] = "\
get_unit(lun)\n\nWrapper for ``get_unit``.\
\n\nParameters\n----------\n"
"lun : input int";
/* extern void F_FUNC_US(get_unit,GET_UNIT)(int*); */
static PyObject *f2py_rout_atomic_program_get_unit(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int lun = 0;
  PyObject *lun_capi = Py_None;
  static char *capi_kwlist[] = {"lun",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.get_unit",\
    capi_kwlist,&lun_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable lun */
    f2py_success = int_from_pyobj(&lun,lun_capi,"atomic_program.get_unit() 1st argument (lun) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&lun);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of lun*/
  /* End of cleaning variable lun */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of get_unit ******************************/

/*********************************** gauleg ***********************************/
static char doc_f2py_rout_atomic_program_gauleg[] = "\
gauleg(x1,x2,x,w,[n])\n\nWrapper for ``gauleg``.\
\n\nParameters\n----------\n"
"x1 : input float\n"
"x2 : input float\n"
"x : input rank-1 array('d') with bounds (n)\n"
"w : input rank-1 array('d') with bounds (n)\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: len(x)";
/* extern void F_FUNC(gauleg,GAULEG)(double*,double*,double*,double*,int*); */
static PyObject *f2py_rout_atomic_program_gauleg(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double x1 = 0;
  PyObject *x1_capi = Py_None;
  double x2 = 0;
  PyObject *x2_capi = Py_None;
  double *x = NULL;
  npy_intp x_Dims[1] = {-1};
  const int x_Rank = 1;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
  PyObject *x_capi = Py_None;
  double *w = NULL;
  npy_intp w_Dims[1] = {-1};
  const int w_Rank = 1;
  PyArrayObject *capi_w_tmp = NULL;
  int capi_w_intent = 0;
  PyObject *w_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  static char *capi_kwlist[] = {"x1","x2","x","w","n",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O:atomic_program.gauleg",\
    capi_kwlist,&x1_capi,&x2_capi,&x_capi,&w_capi,&n_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable x1 */
    f2py_success = double_from_pyobj(&x1,x1_capi,"atomic_program.gauleg() 1st argument (x1) can't be converted to double");
  if (f2py_success) {
  /* Processing variable x2 */
    f2py_success = double_from_pyobj(&x2,x2_capi,"atomic_program.gauleg() 2nd argument (x2) can't be converted to double");
  if (f2py_success) {
  /* Processing variable x */
  ;
  capi_x_intent |= F2PY_INTENT_IN;
  capi_x_tmp = array_from_pyobj(NPY_DOUBLE,x_Dims,x_Rank,capi_x_intent,x_capi);
  if (capi_x_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `x' of atomic_program.gauleg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    x = (double *)(PyArray_DATA(capi_x_tmp));

  /* Processing variable n */
  if (n_capi == Py_None) n = len(x); else
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.gauleg() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(x)>=n,"len(x)>=n","1st keyword n","gauleg:n=%d",n) {
  /* Processing variable w */
  w_Dims[0]=n;
  capi_w_intent |= F2PY_INTENT_IN;
  capi_w_tmp = array_from_pyobj(NPY_DOUBLE,w_Dims,w_Rank,capi_w_intent,w_capi);
  if (capi_w_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `w' of atomic_program.gauleg to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    w = (double *)(PyArray_DATA(capi_w_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&x1,&x2,x,w,&n);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_w_tmp!=w_capi) {
    Py_XDECREF(capi_w_tmp); }
  }  /*if (capi_w_tmp == NULL) ... else of w*/
  /* End of cleaning variable w */
  } /*CHECKSCALAR(len(x)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  if((PyObject *)capi_x_tmp!=x_capi) {
    Py_XDECREF(capi_x_tmp); }
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
  } /*if (f2py_success) of x2*/
  /* End of cleaning variable x2 */
  } /*if (f2py_success) of x1*/
  /* End of cleaning variable x1 */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of gauleg *******************************/

/*********************************** divdif ***********************************/
static char doc_f2py_rout_atomic_program_divdif[] = "\
divdif = divdif(f,x,z,m,[n])\n\nWrapper for ``divdif``.\
\n\nParameters\n----------\n"
"f : input rank-1 array('d') with bounds (n)\n"
"x : input rank-1 array('d') with bounds (n)\n"
"z : input float\n"
"m : input int\n"
"\nOther Parameters\n----------------\n"
"n : input int, optional\n    Default: len(f)\n"
"\nReturns\n-------\n"
"divdif : float";
/* extern void F_WRAPPEDFUNC(divdif,DIVDIF)(double*,double*,double*,int*,double*,int*); */
static PyObject *f2py_rout_atomic_program_divdif(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*,int*,double*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double divdif = 0;
  double *f = NULL;
  npy_intp f_Dims[1] = {-1};
  const int f_Rank = 1;
  PyArrayObject *capi_f_tmp = NULL;
  int capi_f_intent = 0;
  PyObject *f_capi = Py_None;
  double *x = NULL;
  npy_intp x_Dims[1] = {-1};
  const int x_Rank = 1;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
  PyObject *x_capi = Py_None;
  int n = 0;
  PyObject *n_capi = Py_None;
  double z = 0;
  PyObject *z_capi = Py_None;
  int m = 0;
  PyObject *m_capi = Py_None;
  static char *capi_kwlist[] = {"f","x","z","m","n",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O:atomic_program.divdif",\
    capi_kwlist,&f_capi,&x_capi,&z_capi,&m_capi,&n_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable f */
  ;
  capi_f_intent |= F2PY_INTENT_IN;
  capi_f_tmp = array_from_pyobj(NPY_DOUBLE,f_Dims,f_Rank,capi_f_intent,f_capi);
  if (capi_f_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `f' of atomic_program.divdif to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    f = (double *)(PyArray_DATA(capi_f_tmp));

  /* Processing variable z */
    f2py_success = double_from_pyobj(&z,z_capi,"atomic_program.divdif() 3rd argument (z) can't be converted to double");
  if (f2py_success) {
  /* Processing variable m */
    f2py_success = int_from_pyobj(&m,m_capi,"atomic_program.divdif() 4th argument (m) can't be converted to int");
  if (f2py_success) {
  /* Processing variable divdif */
  /* Processing variable n */
  if (n_capi == Py_None) n = len(f); else
    f2py_success = int_from_pyobj(&n,n_capi,"atomic_program.divdif() 1st keyword (n) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(f)>=n,"len(f)>=n","1st keyword n","divdif:n=%d",n) {
  /* Processing variable x */
  x_Dims[0]=n;
  capi_x_intent |= F2PY_INTENT_IN;
  capi_x_tmp = array_from_pyobj(NPY_DOUBLE,x_Dims,x_Rank,capi_x_intent,x_capi);
  if (capi_x_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `x' of atomic_program.divdif to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    x = (double *)(PyArray_DATA(capi_x_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&divdif,f,x,&n,&z,&m);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",divdif);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_x_tmp!=x_capi) {
    Py_XDECREF(capi_x_tmp); }
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
  } /*CHECKSCALAR(len(f)>=n)*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
  /* End of cleaning variable divdif */
  } /*if (f2py_success) of m*/
  /* End of cleaning variable m */
  } /*if (f2py_success) of z*/
  /* End of cleaning variable z */
  if((PyObject *)capi_f_tmp!=f_capi) {
    Py_XDECREF(capi_f_tmp); }
  }  /*if (capi_f_tmp == NULL) ... else of f*/
  /* End of cleaning variable f */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of divdif *******************************/

/****************************** check_directives ******************************/
static char doc_f2py_rout_atomic_program_check_directives[] = "\
check_directives(unit_no)\n\nWrapper for ``check_directives``.\
\n\nParameters\n----------\n"
"unit_no : input int";
/* extern void F_FUNC_US(check_directives,CHECK_DIRECTIVES)(int*); */
static PyObject *f2py_rout_atomic_program_check_directives(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int unit_no = 0;
  PyObject *unit_no_capi = Py_None;
  static char *capi_kwlist[] = {"unit_no",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.check_directives",\
    capi_kwlist,&unit_no_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable unit_no */
    f2py_success = int_from_pyobj(&unit_no,unit_no_capi,"atomic_program.check_directives() 1st argument (unit_no) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&unit_no);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of unit_no*/
  /* End of cleaning variable unit_no */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of check_directives **************************/

/********************************** getline **********************************/
static char doc_f2py_rout_atomic_program_getline[] = "\
getline(unit_no,string_bn)\n\nWrapper for ``getline``.\
\n\nParameters\n----------\n"
"unit_no : input int\n"
"string_bn : input string(len=-1)";
/* extern void F_FUNC(getline,GETLINE)(int*,string,size_t); */
static PyObject *f2py_rout_atomic_program_getline(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int unit_no = 0;
  PyObject *unit_no_capi = Py_None;
  string string_bn = NULL;
  int slen(string_bn);
  PyObject *string_bn_capi = Py_None;
  static char *capi_kwlist[] = {"unit_no","string_bn",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:atomic_program.getline",\
    capi_kwlist,&unit_no_capi,&string_bn_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable unit_no */
    f2py_success = int_from_pyobj(&unit_no,unit_no_capi,"atomic_program.getline() 1st argument (unit_no) can't be converted to int");
  if (f2py_success) {
  /* Processing variable string_bn */
  slen(string_bn) = -1;
  f2py_success = string_from_pyobj(&string_bn,&slen(string_bn),"",string_bn_capi,"string_from_pyobj failed in converting 2nd argument `string_bn' of atomic_program.getline to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&unit_no,string_bn,slen(string_bn));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(string_bn);
  }  /*if (f2py_success) of string_bn*/
  /* End of cleaning variable string_bn */
  } /*if (f2py_success) of unit_no*/
  /* End of cleaning variable unit_no */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of getline *******************************/

/********************************* directive *********************************/
static char doc_f2py_rout_atomic_program_directive[] = "\
directive(str)\n\nWrapper for ``directive``.\
\n\nParameters\n----------\n"
"str : input string(len=-1)";
/* extern void F_FUNC(directive,DIRECTIVE)(string,size_t); */
static PyObject *f2py_rout_atomic_program_directive(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string str = NULL;
  int slen(str);
  PyObject *str_capi = Py_None;
  static char *capi_kwlist[] = {"str",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.directive",\
    capi_kwlist,&str_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable str */
  slen(str) = -1;
  f2py_success = string_from_pyobj(&str,&slen(str),"",str_capi,"string_from_pyobj failed in converting 1st argument `str' of atomic_program.directive to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(str,slen(str));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(str);
  }  /*if (f2py_success) of str*/
  /* End of cleaning variable str */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of directive ******************************/

/********************************** defined **********************************/
static char doc_f2py_rout_atomic_program_defined[] = "\
defined = defined(name)\n\nWrapper for ``defined``.\
\n\nParameters\n----------\n"
"name : input string(len=-1)\n"
"\nReturns\n-------\n"
"defined : int";
/* extern void F_WRAPPEDFUNC(defined,DEFINED)(int*,string,size_t); */
static PyObject *f2py_rout_atomic_program_defined(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int defined = 0;
  string name = NULL;
  int slen(name);
  PyObject *name_capi = Py_None;
  static char *capi_kwlist[] = {"name",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.defined",\
    capi_kwlist,&name_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable name */
  slen(name) = -1;
  f2py_success = string_from_pyobj(&name,&slen(name),"",name_capi,"string_from_pyobj failed in converting 1st argument `name' of atomic_program.defined to C string");
  if (f2py_success) {
  /* Processing variable defined */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&defined,name,slen(name));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",defined);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable defined */
    STRINGFREE(name);
  }  /*if (f2py_success) of name*/
  /* End of cleaning variable name */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of defined *******************************/

/*********************************** insert ***********************************/
static char doc_f2py_rout_atomic_program_insert[] = "\
insert(module,name)\n\nWrapper for ``insert``.\
\n\nParameters\n----------\n"
"module : input string(len=-1)\n"
"name : input string(len=-1)";
/* extern void F_FUNC(insert,INSERT)(string,string,size_t,size_t); */
static PyObject *f2py_rout_atomic_program_insert(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string module = NULL;
  int slen(module);
  PyObject *module_capi = Py_None;
  string name = NULL;
  int slen(name);
  PyObject *name_capi = Py_None;
  static char *capi_kwlist[] = {"module","name",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:atomic_program.insert",\
    capi_kwlist,&module_capi,&name_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable module */
  slen(module) = -1;
  f2py_success = string_from_pyobj(&module,&slen(module),"",module_capi,"string_from_pyobj failed in converting 1st argument `module' of atomic_program.insert to C string");
  if (f2py_success) {
  /* Processing variable name */
  slen(name) = -1;
  f2py_success = string_from_pyobj(&name,&slen(name),"",name_capi,"string_from_pyobj failed in converting 2nd argument `name' of atomic_program.insert to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(module,name,slen(module),slen(name));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(name);
  }  /*if (f2py_success) of name*/
  /* End of cleaning variable name */
    STRINGFREE(module);
  }  /*if (f2py_success) of module*/
  /* End of cleaning variable module */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of insert *******************************/

/********************************** put_pair **********************************/
static char doc_f2py_rout_atomic_program_put_pair[] = "\
put_pair = put_pair(name,num_str)\n\nWrapper for ``put_pair``.\
\n\nParameters\n----------\n"
"name : input string(len=-1)\n"
"num_str : input string(len=-1)\n"
"\nReturns\n-------\n"
"put_pair : int";
/* extern void F_WRAPPEDFUNC_US(put_pair,PUT_PAIR)(int*,string,string,size_t,size_t); */
static PyObject *f2py_rout_atomic_program_put_pair(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,string,string,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int put_pair = 0;
  string name = NULL;
  int slen(name);
  PyObject *name_capi = Py_None;
  string num_str = NULL;
  int slen(num_str);
  PyObject *num_str_capi = Py_None;
  static char *capi_kwlist[] = {"name","num_str",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:atomic_program.put_pair",\
    capi_kwlist,&name_capi,&num_str_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable name */
  slen(name) = -1;
  f2py_success = string_from_pyobj(&name,&slen(name),"",name_capi,"string_from_pyobj failed in converting 1st argument `name' of atomic_program.put_pair to C string");
  if (f2py_success) {
  /* Processing variable num_str */
  slen(num_str) = -1;
  f2py_success = string_from_pyobj(&num_str,&slen(num_str),"",num_str_capi,"string_from_pyobj failed in converting 2nd argument `num_str' of atomic_program.put_pair to C string");
  if (f2py_success) {
  /* Processing variable put_pair */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&put_pair,name,num_str,slen(name),slen(num_str));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",put_pair);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable put_pair */
    STRINGFREE(num_str);
  }  /*if (f2py_success) of num_str*/
  /* End of cleaning variable num_str */
    STRINGFREE(name);
  }  /*if (f2py_success) of name*/
  /* End of cleaning variable name */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of put_pair ******************************/

/********************************* set_value *********************************/
static char doc_f2py_rout_atomic_program_set_value[] = "\
set_value = set_value(name,default_str)\n\nWrapper for ``set_value``.\
\n\nParameters\n----------\n"
"name : input string(len=-1)\n"
"default_str : input string(len=-1)\n"
"\nReturns\n-------\n"
"set_value : float";
/* extern void F_WRAPPEDFUNC_US(set_value,SET_VALUE)(double*,string,string,size_t,size_t); */
static PyObject *f2py_rout_atomic_program_set_value(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,string,string,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double set_value = 0;
  string name = NULL;
  int slen(name);
  PyObject *name_capi = Py_None;
  string default_str = NULL;
  int slen(default_str);
  PyObject *default_str_capi = Py_None;
  static char *capi_kwlist[] = {"name","default_str",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:atomic_program.set_value",\
    capi_kwlist,&name_capi,&default_str_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable name */
  slen(name) = -1;
  f2py_success = string_from_pyobj(&name,&slen(name),"",name_capi,"string_from_pyobj failed in converting 1st argument `name' of atomic_program.set_value to C string");
  if (f2py_success) {
  /* Processing variable default_str */
  slen(default_str) = -1;
  f2py_success = string_from_pyobj(&default_str,&slen(default_str),"",default_str_capi,"string_from_pyobj failed in converting 2nd argument `default_str' of atomic_program.set_value to C string");
  if (f2py_success) {
  /* Processing variable set_value */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&set_value,name,default_str,slen(name),slen(default_str));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",set_value);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable set_value */
    STRINGFREE(default_str);
  }  /*if (f2py_success) of default_str*/
  /* End of cleaning variable default_str */
    STRINGFREE(name);
  }  /*if (f2py_success) of name*/
  /* End of cleaning variable name */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of set_value ******************************/

/********************************** get_real **********************************/
static char doc_f2py_rout_atomic_program_get_real[] = "\
get_real(string_bn,value)\n\nWrapper for ``get_real``.\
\n\nParameters\n----------\n"
"string_bn : input string(len=-1)\n"
"value : input float";
/* extern void F_FUNC_US(get_real,GET_REAL)(string,double*,size_t); */
static PyObject *f2py_rout_atomic_program_get_real(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,double*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string string_bn = NULL;
  int slen(string_bn);
  PyObject *string_bn_capi = Py_None;
  double value = 0;
  PyObject *value_capi = Py_None;
  static char *capi_kwlist[] = {"string_bn","value",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OO|:atomic_program.get_real",\
    capi_kwlist,&string_bn_capi,&value_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable string_bn */
  slen(string_bn) = -1;
  f2py_success = string_from_pyobj(&string_bn,&slen(string_bn),"",string_bn_capi,"string_from_pyobj failed in converting 1st argument `string_bn' of atomic_program.get_real to C string");
  if (f2py_success) {
  /* Processing variable value */
    f2py_success = double_from_pyobj(&value,value_capi,"atomic_program.get_real() 2nd argument (value) can't be converted to double");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(string_bn,&value,slen(string_bn));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of value*/
  /* End of cleaning variable value */
    STRINGFREE(string_bn);
  }  /*if (f2py_success) of string_bn*/
  /* End of cleaning variable string_bn */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of get_real ******************************/

/******************************** print_pairs ********************************/
static char doc_f2py_rout_atomic_program_print_pairs[] = "\
print_pairs()\n\nWrapper for ``print_pairs``.\
\n";
/* extern void F_FUNC_US(print_pairs,PRINT_PAIRS)(void); */
static PyObject *f2py_rout_atomic_program_print_pairs(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:atomic_program.print_pairs",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of print_pairs *****************************/

/********************************* prversion *********************************/
static char doc_f2py_rout_atomic_program_prversion[] = "\
prversion()\n\nWrapper for ``prversion``.\
\n";
/* extern void F_FUNC(prversion,PRVERSION)(void); */
static PyObject *f2py_rout_atomic_program_prversion(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(void)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:atomic_program.prversion",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)();
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of prversion ******************************/

/*********************************** atomxc ***********************************/
static char doc_f2py_rout_atomic_program_atomxc[] = "\
atomxc(functl,author,irel,nr,rmesh,dens,ex,ec,dx,dc,vxc,[maxr,nspin])\n\nWrapper for ``atomxc``.\
\n\nParameters\n----------\n"
"functl : input string(len=-1)\n"
"author : input string(len=-1)\n"
"irel : input int\n"
"nr : input int\n"
"rmesh : input rank-1 array('d') with bounds (maxr)\n"
"dens : input rank-2 array('d') with bounds (maxr,nspin)\n"
"ex : input float\n"
"ec : input float\n"
"dx : input float\n"
"dc : input float\n"
"vxc : input rank-2 array('d') with bounds (maxr,nspin)\n"
"\nOther Parameters\n----------------\n"
"maxr : input int, optional\n    Default: len(rmesh)\n"
"nspin : input int, optional\n    Default: shape(dens,1)";
/* extern void F_FUNC(atomxc,ATOMXC)(string,string,int*,int*,int*,double*,int*,double*,double*,double*,double*,double*,double*,size_t,size_t); */
static PyObject *f2py_rout_atomic_program_atomxc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,int*,int*,int*,double*,int*,double*,double*,double*,double*,double*,double*,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string functl = NULL;
  int slen(functl);
  PyObject *functl_capi = Py_None;
  string author = NULL;
  int slen(author);
  PyObject *author_capi = Py_None;
  int irel = 0;
  PyObject *irel_capi = Py_None;
  int nr = 0;
  PyObject *nr_capi = Py_None;
  int maxr = 0;
  PyObject *maxr_capi = Py_None;
  double *rmesh = NULL;
  npy_intp rmesh_Dims[1] = {-1};
  const int rmesh_Rank = 1;
  PyArrayObject *capi_rmesh_tmp = NULL;
  int capi_rmesh_intent = 0;
  PyObject *rmesh_capi = Py_None;
  int nspin = 0;
  PyObject *nspin_capi = Py_None;
  double *dens = NULL;
  npy_intp dens_Dims[2] = {-1, -1};
  const int dens_Rank = 2;
  PyArrayObject *capi_dens_tmp = NULL;
  int capi_dens_intent = 0;
  PyObject *dens_capi = Py_None;
  double ex = 0;
  PyObject *ex_capi = Py_None;
  double ec = 0;
  PyObject *ec_capi = Py_None;
  double dx = 0;
  PyObject *dx_capi = Py_None;
  double dc = 0;
  PyObject *dc_capi = Py_None;
  double *vxc = NULL;
  npy_intp vxc_Dims[2] = {-1, -1};
  const int vxc_Rank = 2;
  PyArrayObject *capi_vxc_tmp = NULL;
  int capi_vxc_intent = 0;
  PyObject *vxc_capi = Py_None;
  static char *capi_kwlist[] = {"functl","author","irel","nr","rmesh","dens","ex","ec","dx","dc","vxc","maxr","nspin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOO|OO:atomic_program.atomxc",\
    capi_kwlist,&functl_capi,&author_capi,&irel_capi,&nr_capi,&rmesh_capi,&dens_capi,&ex_capi,&ec_capi,&dx_capi,&dc_capi,&vxc_capi,&maxr_capi,&nspin_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable functl */
  slen(functl) = -1;
  f2py_success = string_from_pyobj(&functl,&slen(functl),"",functl_capi,"string_from_pyobj failed in converting 1st argument `functl' of atomic_program.atomxc to C string");
  if (f2py_success) {
  /* Processing variable author */
  slen(author) = -1;
  f2py_success = string_from_pyobj(&author,&slen(author),"",author_capi,"string_from_pyobj failed in converting 2nd argument `author' of atomic_program.atomxc to C string");
  if (f2py_success) {
  /* Processing variable irel */
    f2py_success = int_from_pyobj(&irel,irel_capi,"atomic_program.atomxc() 3rd argument (irel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nr */
    f2py_success = int_from_pyobj(&nr,nr_capi,"atomic_program.atomxc() 4th argument (nr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable rmesh */
  ;
  capi_rmesh_intent |= F2PY_INTENT_IN;
  capi_rmesh_tmp = array_from_pyobj(NPY_DOUBLE,rmesh_Dims,rmesh_Rank,capi_rmesh_intent,rmesh_capi);
  if (capi_rmesh_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `rmesh' of atomic_program.atomxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    rmesh = (double *)(PyArray_DATA(capi_rmesh_tmp));

  /* Processing variable ex */
    f2py_success = double_from_pyobj(&ex,ex_capi,"atomic_program.atomxc() 7th argument (ex) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ec */
    f2py_success = double_from_pyobj(&ec,ec_capi,"atomic_program.atomxc() 8th argument (ec) can't be converted to double");
  if (f2py_success) {
  /* Processing variable dx */
    f2py_success = double_from_pyobj(&dx,dx_capi,"atomic_program.atomxc() 9th argument (dx) can't be converted to double");
  if (f2py_success) {
  /* Processing variable dc */
    f2py_success = double_from_pyobj(&dc,dc_capi,"atomic_program.atomxc() 10th argument (dc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable maxr */
  if (maxr_capi == Py_None) maxr = len(rmesh); else
    f2py_success = int_from_pyobj(&maxr,maxr_capi,"atomic_program.atomxc() 1st keyword (maxr) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(rmesh)>=maxr,"len(rmesh)>=maxr","1st keyword maxr","atomxc:maxr=%d",maxr) {
  /* Processing variable dens */
  dens_Dims[0]=maxr;
  capi_dens_intent |= F2PY_INTENT_IN;
  capi_dens_tmp = array_from_pyobj(NPY_DOUBLE,dens_Dims,dens_Rank,capi_dens_intent,dens_capi);
  if (capi_dens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `dens' of atomic_program.atomxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dens = (double *)(PyArray_DATA(capi_dens_tmp));

  /* Processing variable nspin */
  if (nspin_capi == Py_None) nspin = shape(dens,1); else
    f2py_success = int_from_pyobj(&nspin,nspin_capi,"atomic_program.atomxc() 2nd keyword (nspin) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(dens,1)==nspin,"shape(dens,1)==nspin","2nd keyword nspin","atomxc:nspin=%d",nspin) {
  /* Processing variable vxc */
  vxc_Dims[0]=maxr,vxc_Dims[1]=nspin;
  capi_vxc_intent |= F2PY_INTENT_IN;
  capi_vxc_tmp = array_from_pyobj(NPY_DOUBLE,vxc_Dims,vxc_Rank,capi_vxc_intent,vxc_capi);
  if (capi_vxc_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 11st argument `vxc' of atomic_program.atomxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vxc = (double *)(PyArray_DATA(capi_vxc_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(functl,author,&irel,&nr,&maxr,rmesh,&nspin,dens,&ex,&ec,&dx,&dc,vxc,slen(functl),slen(author));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_vxc_tmp!=vxc_capi) {
    Py_XDECREF(capi_vxc_tmp); }
  }  /*if (capi_vxc_tmp == NULL) ... else of vxc*/
  /* End of cleaning variable vxc */
  } /*CHECKSCALAR(shape(dens,1)==nspin)*/
  } /*if (f2py_success) of nspin*/
  /* End of cleaning variable nspin */
  if((PyObject *)capi_dens_tmp!=dens_capi) {
    Py_XDECREF(capi_dens_tmp); }
  }  /*if (capi_dens_tmp == NULL) ... else of dens*/
  /* End of cleaning variable dens */
  } /*CHECKSCALAR(len(rmesh)>=maxr)*/
  } /*if (f2py_success) of maxr*/
  /* End of cleaning variable maxr */
  } /*if (f2py_success) of dc*/
  /* End of cleaning variable dc */
  } /*if (f2py_success) of dx*/
  /* End of cleaning variable dx */
  } /*if (f2py_success) of ec*/
  /* End of cleaning variable ec */
  } /*if (f2py_success) of ex*/
  /* End of cleaning variable ex */
  if((PyObject *)capi_rmesh_tmp!=rmesh_capi) {
    Py_XDECREF(capi_rmesh_tmp); }
  }  /*if (capi_rmesh_tmp == NULL) ... else of rmesh*/
  /* End of cleaning variable rmesh */
  } /*if (f2py_success) of nr*/
  /* End of cleaning variable nr */
  } /*if (f2py_success) of irel*/
  /* End of cleaning variable irel */
    STRINGFREE(author);
  }  /*if (f2py_success) of author*/
  /* End of cleaning variable author */
    STRINGFREE(functl);
  }  /*if (f2py_success) of functl*/
  /* End of cleaning variable functl */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of atomxc *******************************/

/*********************************** exchng ***********************************/
static char doc_f2py_rout_atomic_program_exchng[] = "\
exchng(irel,ds,ex,vx,[nsp])\n\nWrapper for ``exchng``.\
\n\nParameters\n----------\n"
"irel : input int\n"
"ds : input rank-1 array('d') with bounds (nsp)\n"
"ex : input float\n"
"vx : input rank-1 array('d') with bounds (nsp)\n"
"\nOther Parameters\n----------------\n"
"nsp : input int, optional\n    Default: len(ds)";
/* extern void F_FUNC(exchng,EXCHNG)(int*,int*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_exchng(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int irel = 0;
  PyObject *irel_capi = Py_None;
  int nsp = 0;
  PyObject *nsp_capi = Py_None;
  double *ds = NULL;
  npy_intp ds_Dims[1] = {-1};
  const int ds_Rank = 1;
  PyArrayObject *capi_ds_tmp = NULL;
  int capi_ds_intent = 0;
  PyObject *ds_capi = Py_None;
  double ex = 0;
  PyObject *ex_capi = Py_None;
  double *vx = NULL;
  npy_intp vx_Dims[1] = {-1};
  const int vx_Rank = 1;
  PyArrayObject *capi_vx_tmp = NULL;
  int capi_vx_intent = 0;
  PyObject *vx_capi = Py_None;
  static char *capi_kwlist[] = {"irel","ds","ex","vx","nsp",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|O:atomic_program.exchng",\
    capi_kwlist,&irel_capi,&ds_capi,&ex_capi,&vx_capi,&nsp_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable irel */
    f2py_success = int_from_pyobj(&irel,irel_capi,"atomic_program.exchng() 1st argument (irel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ds */
  ;
  capi_ds_intent |= F2PY_INTENT_IN;
  capi_ds_tmp = array_from_pyobj(NPY_DOUBLE,ds_Dims,ds_Rank,capi_ds_intent,ds_capi);
  if (capi_ds_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `ds' of atomic_program.exchng to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ds = (double *)(PyArray_DATA(capi_ds_tmp));

  /* Processing variable ex */
    f2py_success = double_from_pyobj(&ex,ex_capi,"atomic_program.exchng() 3rd argument (ex) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nsp */
  if (nsp_capi == Py_None) nsp = len(ds); else
    f2py_success = int_from_pyobj(&nsp,nsp_capi,"atomic_program.exchng() 1st keyword (nsp) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(ds)>=nsp,"len(ds)>=nsp","1st keyword nsp","exchng:nsp=%d",nsp) {
  /* Processing variable vx */
  vx_Dims[0]=nsp;
  capi_vx_intent |= F2PY_INTENT_IN;
  capi_vx_tmp = array_from_pyobj(NPY_DOUBLE,vx_Dims,vx_Rank,capi_vx_intent,vx_capi);
  if (capi_vx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `vx' of atomic_program.exchng to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vx = (double *)(PyArray_DATA(capi_vx_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&irel,&nsp,ds,&ex,vx);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_vx_tmp!=vx_capi) {
    Py_XDECREF(capi_vx_tmp); }
  }  /*if (capi_vx_tmp == NULL) ... else of vx*/
  /* End of cleaning variable vx */
  } /*CHECKSCALAR(len(ds)>=nsp)*/
  } /*if (f2py_success) of nsp*/
  /* End of cleaning variable nsp */
  } /*if (f2py_success) of ex*/
  /* End of cleaning variable ex */
  if((PyObject *)capi_ds_tmp!=ds_capi) {
    Py_XDECREF(capi_ds_tmp); }
  }  /*if (capi_ds_tmp == NULL) ... else of ds*/
  /* End of cleaning variable ds */
  } /*if (f2py_success) of irel*/
  /* End of cleaning variable irel */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of exchng *******************************/

/*********************************** ggaxc ***********************************/
static char doc_f2py_rout_atomic_program_ggaxc[] = "\
ggaxc(author,irel,d,gd,epsx,epsc,dexdd,decdd,dexdgd,decdgd,[nspin])\n\nWrapper for ``ggaxc``.\
\n\nParameters\n----------\n"
"author : input string(len=-1)\n"
"irel : input int\n"
"d : input rank-1 array('d') with bounds (nspin)\n"
"gd : input rank-2 array('d') with bounds (3,nspin)\n"
"epsx : input float\n"
"epsc : input float\n"
"dexdd : input rank-1 array('d') with bounds (nspin)\n"
"decdd : input rank-1 array('d') with bounds (nspin)\n"
"dexdgd : input rank-2 array('d') with bounds (3,nspin)\n"
"decdgd : input rank-2 array('d') with bounds (3,nspin)\n"
"\nOther Parameters\n----------------\n"
"nspin : input int, optional\n    Default: len(d)";
/* extern void F_FUNC(ggaxc,GGAXC)(string,int*,int*,double*,double*,double*,double*,double*,double*,double*,double*,size_t); */
static PyObject *f2py_rout_atomic_program_ggaxc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,int*,double*,double*,double*,double*,double*,double*,double*,double*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string author = NULL;
  int slen(author);
  PyObject *author_capi = Py_None;
  int irel = 0;
  PyObject *irel_capi = Py_None;
  int nspin = 0;
  PyObject *nspin_capi = Py_None;
  double *d = NULL;
  npy_intp d_Dims[1] = {-1};
  const int d_Rank = 1;
  PyArrayObject *capi_d_tmp = NULL;
  int capi_d_intent = 0;
  PyObject *d_capi = Py_None;
  double *gd = NULL;
  npy_intp gd_Dims[2] = {-1, -1};
  const int gd_Rank = 2;
  PyArrayObject *capi_gd_tmp = NULL;
  int capi_gd_intent = 0;
  PyObject *gd_capi = Py_None;
  double epsx = 0;
  PyObject *epsx_capi = Py_None;
  double epsc = 0;
  PyObject *epsc_capi = Py_None;
  double *dexdd = NULL;
  npy_intp dexdd_Dims[1] = {-1};
  const int dexdd_Rank = 1;
  PyArrayObject *capi_dexdd_tmp = NULL;
  int capi_dexdd_intent = 0;
  PyObject *dexdd_capi = Py_None;
  double *decdd = NULL;
  npy_intp decdd_Dims[1] = {-1};
  const int decdd_Rank = 1;
  PyArrayObject *capi_decdd_tmp = NULL;
  int capi_decdd_intent = 0;
  PyObject *decdd_capi = Py_None;
  double *dexdgd = NULL;
  npy_intp dexdgd_Dims[2] = {-1, -1};
  const int dexdgd_Rank = 2;
  PyArrayObject *capi_dexdgd_tmp = NULL;
  int capi_dexdgd_intent = 0;
  PyObject *dexdgd_capi = Py_None;
  double *decdgd = NULL;
  npy_intp decdgd_Dims[2] = {-1, -1};
  const int decdgd_Rank = 2;
  PyArrayObject *capi_decdgd_tmp = NULL;
  int capi_decdgd_intent = 0;
  PyObject *decdgd_capi = Py_None;
  static char *capi_kwlist[] = {"author","irel","d","gd","epsx","epsc","dexdd","decdd","dexdgd","decdgd","nspin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOO|O:atomic_program.ggaxc",\
    capi_kwlist,&author_capi,&irel_capi,&d_capi,&gd_capi,&epsx_capi,&epsc_capi,&dexdd_capi,&decdd_capi,&dexdgd_capi,&decdgd_capi,&nspin_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable author */
  slen(author) = -1;
  f2py_success = string_from_pyobj(&author,&slen(author),"",author_capi,"string_from_pyobj failed in converting 1st argument `author' of atomic_program.ggaxc to C string");
  if (f2py_success) {
  /* Processing variable irel */
    f2py_success = int_from_pyobj(&irel,irel_capi,"atomic_program.ggaxc() 2nd argument (irel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable d */
  ;
  capi_d_intent |= F2PY_INTENT_IN;
  capi_d_tmp = array_from_pyobj(NPY_DOUBLE,d_Dims,d_Rank,capi_d_intent,d_capi);
  if (capi_d_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `d' of atomic_program.ggaxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    d = (double *)(PyArray_DATA(capi_d_tmp));

  /* Processing variable epsx */
    f2py_success = double_from_pyobj(&epsx,epsx_capi,"atomic_program.ggaxc() 5th argument (epsx) can't be converted to double");
  if (f2py_success) {
  /* Processing variable epsc */
    f2py_success = double_from_pyobj(&epsc,epsc_capi,"atomic_program.ggaxc() 6th argument (epsc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nspin */
  if (nspin_capi == Py_None) nspin = len(d); else
    f2py_success = int_from_pyobj(&nspin,nspin_capi,"atomic_program.ggaxc() 1st keyword (nspin) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(d)>=nspin,"len(d)>=nspin","1st keyword nspin","ggaxc:nspin=%d",nspin) {
  /* Processing variable gd */
  gd_Dims[0]=3,gd_Dims[1]=nspin;
  capi_gd_intent |= F2PY_INTENT_IN;
  capi_gd_tmp = array_from_pyobj(NPY_DOUBLE,gd_Dims,gd_Rank,capi_gd_intent,gd_capi);
  if (capi_gd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 4th argument `gd' of atomic_program.ggaxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    gd = (double *)(PyArray_DATA(capi_gd_tmp));

  /* Processing variable dexdd */
  dexdd_Dims[0]=nspin;
  capi_dexdd_intent |= F2PY_INTENT_IN;
  capi_dexdd_tmp = array_from_pyobj(NPY_DOUBLE,dexdd_Dims,dexdd_Rank,capi_dexdd_intent,dexdd_capi);
  if (capi_dexdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `dexdd' of atomic_program.ggaxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dexdd = (double *)(PyArray_DATA(capi_dexdd_tmp));

  /* Processing variable decdd */
  decdd_Dims[0]=nspin;
  capi_decdd_intent |= F2PY_INTENT_IN;
  capi_decdd_tmp = array_from_pyobj(NPY_DOUBLE,decdd_Dims,decdd_Rank,capi_decdd_intent,decdd_capi);
  if (capi_decdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 8th argument `decdd' of atomic_program.ggaxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    decdd = (double *)(PyArray_DATA(capi_decdd_tmp));

  /* Processing variable dexdgd */
  dexdgd_Dims[0]=3,dexdgd_Dims[1]=nspin;
  capi_dexdgd_intent |= F2PY_INTENT_IN;
  capi_dexdgd_tmp = array_from_pyobj(NPY_DOUBLE,dexdgd_Dims,dexdgd_Rank,capi_dexdgd_intent,dexdgd_capi);
  if (capi_dexdgd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 9th argument `dexdgd' of atomic_program.ggaxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dexdgd = (double *)(PyArray_DATA(capi_dexdgd_tmp));

  /* Processing variable decdgd */
  decdgd_Dims[0]=3,decdgd_Dims[1]=nspin;
  capi_decdgd_intent |= F2PY_INTENT_IN;
  capi_decdgd_tmp = array_from_pyobj(NPY_DOUBLE,decdgd_Dims,decdgd_Rank,capi_decdgd_intent,decdgd_capi);
  if (capi_decdgd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 10th argument `decdgd' of atomic_program.ggaxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    decdgd = (double *)(PyArray_DATA(capi_decdgd_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(author,&irel,&nspin,d,gd,&epsx,&epsc,dexdd,decdd,dexdgd,decdgd,slen(author));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_decdgd_tmp!=decdgd_capi) {
    Py_XDECREF(capi_decdgd_tmp); }
  }  /*if (capi_decdgd_tmp == NULL) ... else of decdgd*/
  /* End of cleaning variable decdgd */
  if((PyObject *)capi_dexdgd_tmp!=dexdgd_capi) {
    Py_XDECREF(capi_dexdgd_tmp); }
  }  /*if (capi_dexdgd_tmp == NULL) ... else of dexdgd*/
  /* End of cleaning variable dexdgd */
  if((PyObject *)capi_decdd_tmp!=decdd_capi) {
    Py_XDECREF(capi_decdd_tmp); }
  }  /*if (capi_decdd_tmp == NULL) ... else of decdd*/
  /* End of cleaning variable decdd */
  if((PyObject *)capi_dexdd_tmp!=dexdd_capi) {
    Py_XDECREF(capi_dexdd_tmp); }
  }  /*if (capi_dexdd_tmp == NULL) ... else of dexdd*/
  /* End of cleaning variable dexdd */
  if((PyObject *)capi_gd_tmp!=gd_capi) {
    Py_XDECREF(capi_gd_tmp); }
  }  /*if (capi_gd_tmp == NULL) ... else of gd*/
  /* End of cleaning variable gd */
  } /*CHECKSCALAR(len(d)>=nspin)*/
  } /*if (f2py_success) of nspin*/
  /* End of cleaning variable nspin */
  } /*if (f2py_success) of epsc*/
  /* End of cleaning variable epsc */
  } /*if (f2py_success) of epsx*/
  /* End of cleaning variable epsx */
  if((PyObject *)capi_d_tmp!=d_capi) {
    Py_XDECREF(capi_d_tmp); }
  }  /*if (capi_d_tmp == NULL) ... else of d*/
  /* End of cleaning variable d */
  } /*if (f2py_success) of irel*/
  /* End of cleaning variable irel */
    STRINGFREE(author);
  }  /*if (f2py_success) of author*/
  /* End of cleaning variable author */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of ggaxc ********************************/

/*********************************** ldaxc ***********************************/
static char doc_f2py_rout_atomic_program_ldaxc[] = "\
ldaxc(author,irel,d,epsx,epsc,vx,vc,dvxdn,dvcdn,[nspin])\n\nWrapper for ``ldaxc``.\
\n\nParameters\n----------\n"
"author : input string(len=-1)\n"
"irel : input int\n"
"d : input rank-1 array('d') with bounds (nspin)\n"
"epsx : input float\n"
"epsc : input float\n"
"vx : input rank-1 array('d') with bounds (nspin)\n"
"vc : input rank-1 array('d') with bounds (nspin)\n"
"dvxdn : input rank-2 array('d') with bounds (nspin,nspin)\n"
"dvcdn : input rank-2 array('d') with bounds (nspin,nspin)\n"
"\nOther Parameters\n----------------\n"
"nspin : input int, optional\n    Default: len(d)";
/* extern void F_FUNC(ldaxc,LDAXC)(string,int*,int*,double*,double*,double*,double*,double*,double*,double*,size_t); */
static PyObject *f2py_rout_atomic_program_ldaxc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,int*,int*,double*,double*,double*,double*,double*,double*,double*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string author = NULL;
  int slen(author);
  PyObject *author_capi = Py_None;
  int irel = 0;
  PyObject *irel_capi = Py_None;
  int nspin = 0;
  PyObject *nspin_capi = Py_None;
  double *d = NULL;
  npy_intp d_Dims[1] = {-1};
  const int d_Rank = 1;
  PyArrayObject *capi_d_tmp = NULL;
  int capi_d_intent = 0;
  PyObject *d_capi = Py_None;
  double epsx = 0;
  PyObject *epsx_capi = Py_None;
  double epsc = 0;
  PyObject *epsc_capi = Py_None;
  double *vx = NULL;
  npy_intp vx_Dims[1] = {-1};
  const int vx_Rank = 1;
  PyArrayObject *capi_vx_tmp = NULL;
  int capi_vx_intent = 0;
  PyObject *vx_capi = Py_None;
  double *vc = NULL;
  npy_intp vc_Dims[1] = {-1};
  const int vc_Rank = 1;
  PyArrayObject *capi_vc_tmp = NULL;
  int capi_vc_intent = 0;
  PyObject *vc_capi = Py_None;
  double *dvxdn = NULL;
  npy_intp dvxdn_Dims[2] = {-1, -1};
  const int dvxdn_Rank = 2;
  PyArrayObject *capi_dvxdn_tmp = NULL;
  int capi_dvxdn_intent = 0;
  PyObject *dvxdn_capi = Py_None;
  double *dvcdn = NULL;
  npy_intp dvcdn_Dims[2] = {-1, -1};
  const int dvcdn_Rank = 2;
  PyArrayObject *capi_dvcdn_tmp = NULL;
  int capi_dvcdn_intent = 0;
  PyObject *dvcdn_capi = Py_None;
  static char *capi_kwlist[] = {"author","irel","d","epsx","epsc","vx","vc","dvxdn","dvcdn","nspin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOO|O:atomic_program.ldaxc",\
    capi_kwlist,&author_capi,&irel_capi,&d_capi,&epsx_capi,&epsc_capi,&vx_capi,&vc_capi,&dvxdn_capi,&dvcdn_capi,&nspin_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable author */
  slen(author) = -1;
  f2py_success = string_from_pyobj(&author,&slen(author),"",author_capi,"string_from_pyobj failed in converting 1st argument `author' of atomic_program.ldaxc to C string");
  if (f2py_success) {
  /* Processing variable irel */
    f2py_success = int_from_pyobj(&irel,irel_capi,"atomic_program.ldaxc() 2nd argument (irel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable d */
  ;
  capi_d_intent |= F2PY_INTENT_IN;
  capi_d_tmp = array_from_pyobj(NPY_DOUBLE,d_Dims,d_Rank,capi_d_intent,d_capi);
  if (capi_d_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `d' of atomic_program.ldaxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    d = (double *)(PyArray_DATA(capi_d_tmp));

  /* Processing variable epsx */
    f2py_success = double_from_pyobj(&epsx,epsx_capi,"atomic_program.ldaxc() 4th argument (epsx) can't be converted to double");
  if (f2py_success) {
  /* Processing variable epsc */
    f2py_success = double_from_pyobj(&epsc,epsc_capi,"atomic_program.ldaxc() 5th argument (epsc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nspin */
  if (nspin_capi == Py_None) nspin = len(d); else
    f2py_success = int_from_pyobj(&nspin,nspin_capi,"atomic_program.ldaxc() 1st keyword (nspin) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(d)>=nspin,"len(d)>=nspin","1st keyword nspin","ldaxc:nspin=%d",nspin) {
  /* Processing variable vx */
  vx_Dims[0]=nspin;
  capi_vx_intent |= F2PY_INTENT_IN;
  capi_vx_tmp = array_from_pyobj(NPY_DOUBLE,vx_Dims,vx_Rank,capi_vx_intent,vx_capi);
  if (capi_vx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `vx' of atomic_program.ldaxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vx = (double *)(PyArray_DATA(capi_vx_tmp));

  /* Processing variable vc */
  vc_Dims[0]=nspin;
  capi_vc_intent |= F2PY_INTENT_IN;
  capi_vc_tmp = array_from_pyobj(NPY_DOUBLE,vc_Dims,vc_Rank,capi_vc_intent,vc_capi);
  if (capi_vc_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `vc' of atomic_program.ldaxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vc = (double *)(PyArray_DATA(capi_vc_tmp));

  /* Processing variable dvxdn */
  dvxdn_Dims[0]=nspin,dvxdn_Dims[1]=nspin;
  capi_dvxdn_intent |= F2PY_INTENT_IN;
  capi_dvxdn_tmp = array_from_pyobj(NPY_DOUBLE,dvxdn_Dims,dvxdn_Rank,capi_dvxdn_intent,dvxdn_capi);
  if (capi_dvxdn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 8th argument `dvxdn' of atomic_program.ldaxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dvxdn = (double *)(PyArray_DATA(capi_dvxdn_tmp));

  /* Processing variable dvcdn */
  dvcdn_Dims[0]=nspin,dvcdn_Dims[1]=nspin;
  capi_dvcdn_intent |= F2PY_INTENT_IN;
  capi_dvcdn_tmp = array_from_pyobj(NPY_DOUBLE,dvcdn_Dims,dvcdn_Rank,capi_dvcdn_intent,dvcdn_capi);
  if (capi_dvcdn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 9th argument `dvcdn' of atomic_program.ldaxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dvcdn = (double *)(PyArray_DATA(capi_dvcdn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(author,&irel,&nspin,d,&epsx,&epsc,vx,vc,dvxdn,dvcdn,slen(author));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dvcdn_tmp!=dvcdn_capi) {
    Py_XDECREF(capi_dvcdn_tmp); }
  }  /*if (capi_dvcdn_tmp == NULL) ... else of dvcdn*/
  /* End of cleaning variable dvcdn */
  if((PyObject *)capi_dvxdn_tmp!=dvxdn_capi) {
    Py_XDECREF(capi_dvxdn_tmp); }
  }  /*if (capi_dvxdn_tmp == NULL) ... else of dvxdn*/
  /* End of cleaning variable dvxdn */
  if((PyObject *)capi_vc_tmp!=vc_capi) {
    Py_XDECREF(capi_vc_tmp); }
  }  /*if (capi_vc_tmp == NULL) ... else of vc*/
  /* End of cleaning variable vc */
  if((PyObject *)capi_vx_tmp!=vx_capi) {
    Py_XDECREF(capi_vx_tmp); }
  }  /*if (capi_vx_tmp == NULL) ... else of vx*/
  /* End of cleaning variable vx */
  } /*CHECKSCALAR(len(d)>=nspin)*/
  } /*if (f2py_success) of nspin*/
  /* End of cleaning variable nspin */
  } /*if (f2py_success) of epsc*/
  /* End of cleaning variable epsc */
  } /*if (f2py_success) of epsx*/
  /* End of cleaning variable epsx */
  if((PyObject *)capi_d_tmp!=d_capi) {
    Py_XDECREF(capi_d_tmp); }
  }  /*if (capi_d_tmp == NULL) ... else of d*/
  /* End of cleaning variable d */
  } /*if (f2py_success) of irel*/
  /* End of cleaning variable irel */
    STRINGFREE(author);
  }  /*if (f2py_success) of author*/
  /* End of cleaning variable author */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of ldaxc ********************************/

/*********************************** pbexc ***********************************/
static char doc_f2py_rout_atomic_program_pbexc[] = "\
pbexc(irel,dens,gdens,ex,ec,dexdd,decdd,dexdgd,decdgd,[nspin])\n\nWrapper for ``pbexc``.\
\n\nParameters\n----------\n"
"irel : input int\n"
"dens : input rank-1 array('d') with bounds (nspin)\n"
"gdens : input rank-2 array('d') with bounds (3,nspin)\n"
"ex : input float\n"
"ec : input float\n"
"dexdd : input rank-1 array('d') with bounds (nspin)\n"
"decdd : input rank-1 array('d') with bounds (nspin)\n"
"dexdgd : input rank-2 array('d') with bounds (3,nspin)\n"
"decdgd : input rank-2 array('d') with bounds (3,nspin)\n"
"\nOther Parameters\n----------------\n"
"nspin : input int, optional\n    Default: len(dens)";
/* extern void F_FUNC(pbexc,PBEXC)(int*,int*,double*,double*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_pbexc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int irel = 0;
  PyObject *irel_capi = Py_None;
  int nspin = 0;
  PyObject *nspin_capi = Py_None;
  double *dens = NULL;
  npy_intp dens_Dims[1] = {-1};
  const int dens_Rank = 1;
  PyArrayObject *capi_dens_tmp = NULL;
  int capi_dens_intent = 0;
  PyObject *dens_capi = Py_None;
  double *gdens = NULL;
  npy_intp gdens_Dims[2] = {-1, -1};
  const int gdens_Rank = 2;
  PyArrayObject *capi_gdens_tmp = NULL;
  int capi_gdens_intent = 0;
  PyObject *gdens_capi = Py_None;
  double ex = 0;
  PyObject *ex_capi = Py_None;
  double ec = 0;
  PyObject *ec_capi = Py_None;
  double *dexdd = NULL;
  npy_intp dexdd_Dims[1] = {-1};
  const int dexdd_Rank = 1;
  PyArrayObject *capi_dexdd_tmp = NULL;
  int capi_dexdd_intent = 0;
  PyObject *dexdd_capi = Py_None;
  double *decdd = NULL;
  npy_intp decdd_Dims[1] = {-1};
  const int decdd_Rank = 1;
  PyArrayObject *capi_decdd_tmp = NULL;
  int capi_decdd_intent = 0;
  PyObject *decdd_capi = Py_None;
  double *dexdgd = NULL;
  npy_intp dexdgd_Dims[2] = {-1, -1};
  const int dexdgd_Rank = 2;
  PyArrayObject *capi_dexdgd_tmp = NULL;
  int capi_dexdgd_intent = 0;
  PyObject *dexdgd_capi = Py_None;
  double *decdgd = NULL;
  npy_intp decdgd_Dims[2] = {-1, -1};
  const int decdgd_Rank = 2;
  PyArrayObject *capi_decdgd_tmp = NULL;
  int capi_decdgd_intent = 0;
  PyObject *decdgd_capi = Py_None;
  static char *capi_kwlist[] = {"irel","dens","gdens","ex","ec","dexdd","decdd","dexdgd","decdgd","nspin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOO|O:atomic_program.pbexc",\
    capi_kwlist,&irel_capi,&dens_capi,&gdens_capi,&ex_capi,&ec_capi,&dexdd_capi,&decdd_capi,&dexdgd_capi,&decdgd_capi,&nspin_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable irel */
    f2py_success = int_from_pyobj(&irel,irel_capi,"atomic_program.pbexc() 1st argument (irel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable dens */
  ;
  capi_dens_intent |= F2PY_INTENT_IN;
  capi_dens_tmp = array_from_pyobj(NPY_DOUBLE,dens_Dims,dens_Rank,capi_dens_intent,dens_capi);
  if (capi_dens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `dens' of atomic_program.pbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dens = (double *)(PyArray_DATA(capi_dens_tmp));

  /* Processing variable ex */
    f2py_success = double_from_pyobj(&ex,ex_capi,"atomic_program.pbexc() 4th argument (ex) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ec */
    f2py_success = double_from_pyobj(&ec,ec_capi,"atomic_program.pbexc() 5th argument (ec) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nspin */
  if (nspin_capi == Py_None) nspin = len(dens); else
    f2py_success = int_from_pyobj(&nspin,nspin_capi,"atomic_program.pbexc() 1st keyword (nspin) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(dens)>=nspin,"len(dens)>=nspin","1st keyword nspin","pbexc:nspin=%d",nspin) {
  /* Processing variable gdens */
  gdens_Dims[0]=3,gdens_Dims[1]=nspin;
  capi_gdens_intent |= F2PY_INTENT_IN;
  capi_gdens_tmp = array_from_pyobj(NPY_DOUBLE,gdens_Dims,gdens_Rank,capi_gdens_intent,gdens_capi);
  if (capi_gdens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `gdens' of atomic_program.pbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    gdens = (double *)(PyArray_DATA(capi_gdens_tmp));

  /* Processing variable dexdd */
  dexdd_Dims[0]=nspin;
  capi_dexdd_intent |= F2PY_INTENT_IN;
  capi_dexdd_tmp = array_from_pyobj(NPY_DOUBLE,dexdd_Dims,dexdd_Rank,capi_dexdd_intent,dexdd_capi);
  if (capi_dexdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `dexdd' of atomic_program.pbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dexdd = (double *)(PyArray_DATA(capi_dexdd_tmp));

  /* Processing variable decdd */
  decdd_Dims[0]=nspin;
  capi_decdd_intent |= F2PY_INTENT_IN;
  capi_decdd_tmp = array_from_pyobj(NPY_DOUBLE,decdd_Dims,decdd_Rank,capi_decdd_intent,decdd_capi);
  if (capi_decdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `decdd' of atomic_program.pbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    decdd = (double *)(PyArray_DATA(capi_decdd_tmp));

  /* Processing variable dexdgd */
  dexdgd_Dims[0]=3,dexdgd_Dims[1]=nspin;
  capi_dexdgd_intent |= F2PY_INTENT_IN;
  capi_dexdgd_tmp = array_from_pyobj(NPY_DOUBLE,dexdgd_Dims,dexdgd_Rank,capi_dexdgd_intent,dexdgd_capi);
  if (capi_dexdgd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 8th argument `dexdgd' of atomic_program.pbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dexdgd = (double *)(PyArray_DATA(capi_dexdgd_tmp));

  /* Processing variable decdgd */
  decdgd_Dims[0]=3,decdgd_Dims[1]=nspin;
  capi_decdgd_intent |= F2PY_INTENT_IN;
  capi_decdgd_tmp = array_from_pyobj(NPY_DOUBLE,decdgd_Dims,decdgd_Rank,capi_decdgd_intent,decdgd_capi);
  if (capi_decdgd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 9th argument `decdgd' of atomic_program.pbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    decdgd = (double *)(PyArray_DATA(capi_decdgd_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&irel,&nspin,dens,gdens,&ex,&ec,dexdd,decdd,dexdgd,decdgd);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_decdgd_tmp!=decdgd_capi) {
    Py_XDECREF(capi_decdgd_tmp); }
  }  /*if (capi_decdgd_tmp == NULL) ... else of decdgd*/
  /* End of cleaning variable decdgd */
  if((PyObject *)capi_dexdgd_tmp!=dexdgd_capi) {
    Py_XDECREF(capi_dexdgd_tmp); }
  }  /*if (capi_dexdgd_tmp == NULL) ... else of dexdgd*/
  /* End of cleaning variable dexdgd */
  if((PyObject *)capi_decdd_tmp!=decdd_capi) {
    Py_XDECREF(capi_decdd_tmp); }
  }  /*if (capi_decdd_tmp == NULL) ... else of decdd*/
  /* End of cleaning variable decdd */
  if((PyObject *)capi_dexdd_tmp!=dexdd_capi) {
    Py_XDECREF(capi_dexdd_tmp); }
  }  /*if (capi_dexdd_tmp == NULL) ... else of dexdd*/
  /* End of cleaning variable dexdd */
  if((PyObject *)capi_gdens_tmp!=gdens_capi) {
    Py_XDECREF(capi_gdens_tmp); }
  }  /*if (capi_gdens_tmp == NULL) ... else of gdens*/
  /* End of cleaning variable gdens */
  } /*CHECKSCALAR(len(dens)>=nspin)*/
  } /*if (f2py_success) of nspin*/
  /* End of cleaning variable nspin */
  } /*if (f2py_success) of ec*/
  /* End of cleaning variable ec */
  } /*if (f2py_success) of ex*/
  /* End of cleaning variable ex */
  if((PyObject *)capi_dens_tmp!=dens_capi) {
    Py_XDECREF(capi_dens_tmp); }
  }  /*if (capi_dens_tmp == NULL) ... else of dens*/
  /* End of cleaning variable dens */
  } /*if (f2py_success) of irel*/
  /* End of cleaning variable irel */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of pbexc ********************************/

/*********************************** pw91xc ***********************************/
static char doc_f2py_rout_atomic_program_pw91xc[] = "\
pw91xc(irel,dens,gdens,ex,ec,dexdd,decdd,dexdgd,decdgd,[nspin])\n\nWrapper for ``pw91xc``.\
\n\nParameters\n----------\n"
"irel : input int\n"
"dens : input rank-1 array('d') with bounds (nspin)\n"
"gdens : input rank-2 array('d') with bounds (3,nspin)\n"
"ex : input float\n"
"ec : input float\n"
"dexdd : input rank-1 array('d') with bounds (nspin)\n"
"decdd : input rank-1 array('d') with bounds (nspin)\n"
"dexdgd : input rank-2 array('d') with bounds (3,nspin)\n"
"decdgd : input rank-2 array('d') with bounds (3,nspin)\n"
"\nOther Parameters\n----------------\n"
"nspin : input int, optional\n    Default: len(dens)";
/* extern void F_FUNC(pw91xc,PW91XC)(int*,int*,double*,double*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_pw91xc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int irel = 0;
  PyObject *irel_capi = Py_None;
  int nspin = 0;
  PyObject *nspin_capi = Py_None;
  double *dens = NULL;
  npy_intp dens_Dims[1] = {-1};
  const int dens_Rank = 1;
  PyArrayObject *capi_dens_tmp = NULL;
  int capi_dens_intent = 0;
  PyObject *dens_capi = Py_None;
  double *gdens = NULL;
  npy_intp gdens_Dims[2] = {-1, -1};
  const int gdens_Rank = 2;
  PyArrayObject *capi_gdens_tmp = NULL;
  int capi_gdens_intent = 0;
  PyObject *gdens_capi = Py_None;
  double ex = 0;
  PyObject *ex_capi = Py_None;
  double ec = 0;
  PyObject *ec_capi = Py_None;
  double *dexdd = NULL;
  npy_intp dexdd_Dims[1] = {-1};
  const int dexdd_Rank = 1;
  PyArrayObject *capi_dexdd_tmp = NULL;
  int capi_dexdd_intent = 0;
  PyObject *dexdd_capi = Py_None;
  double *decdd = NULL;
  npy_intp decdd_Dims[1] = {-1};
  const int decdd_Rank = 1;
  PyArrayObject *capi_decdd_tmp = NULL;
  int capi_decdd_intent = 0;
  PyObject *decdd_capi = Py_None;
  double *dexdgd = NULL;
  npy_intp dexdgd_Dims[2] = {-1, -1};
  const int dexdgd_Rank = 2;
  PyArrayObject *capi_dexdgd_tmp = NULL;
  int capi_dexdgd_intent = 0;
  PyObject *dexdgd_capi = Py_None;
  double *decdgd = NULL;
  npy_intp decdgd_Dims[2] = {-1, -1};
  const int decdgd_Rank = 2;
  PyArrayObject *capi_decdgd_tmp = NULL;
  int capi_decdgd_intent = 0;
  PyObject *decdgd_capi = Py_None;
  static char *capi_kwlist[] = {"irel","dens","gdens","ex","ec","dexdd","decdd","dexdgd","decdgd","nspin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOO|O:atomic_program.pw91xc",\
    capi_kwlist,&irel_capi,&dens_capi,&gdens_capi,&ex_capi,&ec_capi,&dexdd_capi,&decdd_capi,&dexdgd_capi,&decdgd_capi,&nspin_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable irel */
    f2py_success = int_from_pyobj(&irel,irel_capi,"atomic_program.pw91xc() 1st argument (irel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable dens */
  ;
  capi_dens_intent |= F2PY_INTENT_IN;
  capi_dens_tmp = array_from_pyobj(NPY_DOUBLE,dens_Dims,dens_Rank,capi_dens_intent,dens_capi);
  if (capi_dens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `dens' of atomic_program.pw91xc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dens = (double *)(PyArray_DATA(capi_dens_tmp));

  /* Processing variable ex */
    f2py_success = double_from_pyobj(&ex,ex_capi,"atomic_program.pw91xc() 4th argument (ex) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ec */
    f2py_success = double_from_pyobj(&ec,ec_capi,"atomic_program.pw91xc() 5th argument (ec) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nspin */
  if (nspin_capi == Py_None) nspin = len(dens); else
    f2py_success = int_from_pyobj(&nspin,nspin_capi,"atomic_program.pw91xc() 1st keyword (nspin) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(dens)>=nspin,"len(dens)>=nspin","1st keyword nspin","pw91xc:nspin=%d",nspin) {
  /* Processing variable gdens */
  gdens_Dims[0]=3,gdens_Dims[1]=nspin;
  capi_gdens_intent |= F2PY_INTENT_IN;
  capi_gdens_tmp = array_from_pyobj(NPY_DOUBLE,gdens_Dims,gdens_Rank,capi_gdens_intent,gdens_capi);
  if (capi_gdens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `gdens' of atomic_program.pw91xc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    gdens = (double *)(PyArray_DATA(capi_gdens_tmp));

  /* Processing variable dexdd */
  dexdd_Dims[0]=nspin;
  capi_dexdd_intent |= F2PY_INTENT_IN;
  capi_dexdd_tmp = array_from_pyobj(NPY_DOUBLE,dexdd_Dims,dexdd_Rank,capi_dexdd_intent,dexdd_capi);
  if (capi_dexdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `dexdd' of atomic_program.pw91xc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dexdd = (double *)(PyArray_DATA(capi_dexdd_tmp));

  /* Processing variable decdd */
  decdd_Dims[0]=nspin;
  capi_decdd_intent |= F2PY_INTENT_IN;
  capi_decdd_tmp = array_from_pyobj(NPY_DOUBLE,decdd_Dims,decdd_Rank,capi_decdd_intent,decdd_capi);
  if (capi_decdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `decdd' of atomic_program.pw91xc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    decdd = (double *)(PyArray_DATA(capi_decdd_tmp));

  /* Processing variable dexdgd */
  dexdgd_Dims[0]=3,dexdgd_Dims[1]=nspin;
  capi_dexdgd_intent |= F2PY_INTENT_IN;
  capi_dexdgd_tmp = array_from_pyobj(NPY_DOUBLE,dexdgd_Dims,dexdgd_Rank,capi_dexdgd_intent,dexdgd_capi);
  if (capi_dexdgd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 8th argument `dexdgd' of atomic_program.pw91xc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dexdgd = (double *)(PyArray_DATA(capi_dexdgd_tmp));

  /* Processing variable decdgd */
  decdgd_Dims[0]=3,decdgd_Dims[1]=nspin;
  capi_decdgd_intent |= F2PY_INTENT_IN;
  capi_decdgd_tmp = array_from_pyobj(NPY_DOUBLE,decdgd_Dims,decdgd_Rank,capi_decdgd_intent,decdgd_capi);
  if (capi_decdgd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 9th argument `decdgd' of atomic_program.pw91xc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    decdgd = (double *)(PyArray_DATA(capi_decdgd_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&irel,&nspin,dens,gdens,&ex,&ec,dexdd,decdd,dexdgd,decdgd);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_decdgd_tmp!=decdgd_capi) {
    Py_XDECREF(capi_decdgd_tmp); }
  }  /*if (capi_decdgd_tmp == NULL) ... else of decdgd*/
  /* End of cleaning variable decdgd */
  if((PyObject *)capi_dexdgd_tmp!=dexdgd_capi) {
    Py_XDECREF(capi_dexdgd_tmp); }
  }  /*if (capi_dexdgd_tmp == NULL) ... else of dexdgd*/
  /* End of cleaning variable dexdgd */
  if((PyObject *)capi_decdd_tmp!=decdd_capi) {
    Py_XDECREF(capi_decdd_tmp); }
  }  /*if (capi_decdd_tmp == NULL) ... else of decdd*/
  /* End of cleaning variable decdd */
  if((PyObject *)capi_dexdd_tmp!=dexdd_capi) {
    Py_XDECREF(capi_dexdd_tmp); }
  }  /*if (capi_dexdd_tmp == NULL) ... else of dexdd*/
  /* End of cleaning variable dexdd */
  if((PyObject *)capi_gdens_tmp!=gdens_capi) {
    Py_XDECREF(capi_gdens_tmp); }
  }  /*if (capi_gdens_tmp == NULL) ... else of gdens*/
  /* End of cleaning variable gdens */
  } /*CHECKSCALAR(len(dens)>=nspin)*/
  } /*if (f2py_success) of nspin*/
  /* End of cleaning variable nspin */
  } /*if (f2py_success) of ec*/
  /* End of cleaning variable ec */
  } /*if (f2py_success) of ex*/
  /* End of cleaning variable ex */
  if((PyObject *)capi_dens_tmp!=dens_capi) {
    Py_XDECREF(capi_dens_tmp); }
  }  /*if (capi_dens_tmp == NULL) ... else of dens*/
  /* End of cleaning variable dens */
  } /*if (f2py_success) of irel*/
  /* End of cleaning variable irel */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pw91xc *******************************/

/*********************************** pw92c ***********************************/
static char doc_f2py_rout_atomic_program_pw92c[] = "\
pw92c(dens,ec,vc,[nspin])\n\nWrapper for ``pw92c``.\
\n\nParameters\n----------\n"
"dens : input rank-1 array('d') with bounds (nspin)\n"
"ec : input float\n"
"vc : input rank-1 array('d') with bounds (nspin)\n"
"\nOther Parameters\n----------------\n"
"nspin : input int, optional\n    Default: len(dens)";
/* extern void F_FUNC(pw92c,PW92C)(int*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_pw92c(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nspin = 0;
  PyObject *nspin_capi = Py_None;
  double *dens = NULL;
  npy_intp dens_Dims[1] = {-1};
  const int dens_Rank = 1;
  PyArrayObject *capi_dens_tmp = NULL;
  int capi_dens_intent = 0;
  PyObject *dens_capi = Py_None;
  double ec = 0;
  PyObject *ec_capi = Py_None;
  double *vc = NULL;
  npy_intp vc_Dims[1] = {-1};
  const int vc_Rank = 1;
  PyArrayObject *capi_vc_tmp = NULL;
  int capi_vc_intent = 0;
  PyObject *vc_capi = Py_None;
  static char *capi_kwlist[] = {"dens","ec","vc","nspin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|O:atomic_program.pw92c",\
    capi_kwlist,&dens_capi,&ec_capi,&vc_capi,&nspin_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable dens */
  ;
  capi_dens_intent |= F2PY_INTENT_IN;
  capi_dens_tmp = array_from_pyobj(NPY_DOUBLE,dens_Dims,dens_Rank,capi_dens_intent,dens_capi);
  if (capi_dens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `dens' of atomic_program.pw92c to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dens = (double *)(PyArray_DATA(capi_dens_tmp));

  /* Processing variable ec */
    f2py_success = double_from_pyobj(&ec,ec_capi,"atomic_program.pw92c() 2nd argument (ec) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nspin */
  if (nspin_capi == Py_None) nspin = len(dens); else
    f2py_success = int_from_pyobj(&nspin,nspin_capi,"atomic_program.pw92c() 1st keyword (nspin) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(dens)>=nspin,"len(dens)>=nspin","1st keyword nspin","pw92c:nspin=%d",nspin) {
  /* Processing variable vc */
  vc_Dims[0]=nspin;
  capi_vc_intent |= F2PY_INTENT_IN;
  capi_vc_tmp = array_from_pyobj(NPY_DOUBLE,vc_Dims,vc_Rank,capi_vc_intent,vc_capi);
  if (capi_vc_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `vc' of atomic_program.pw92c to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vc = (double *)(PyArray_DATA(capi_vc_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nspin,dens,&ec,vc);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_vc_tmp!=vc_capi) {
    Py_XDECREF(capi_vc_tmp); }
  }  /*if (capi_vc_tmp == NULL) ... else of vc*/
  /* End of cleaning variable vc */
  } /*CHECKSCALAR(len(dens)>=nspin)*/
  } /*if (f2py_success) of nspin*/
  /* End of cleaning variable nspin */
  } /*if (f2py_success) of ec*/
  /* End of cleaning variable ec */
  if((PyObject *)capi_dens_tmp!=dens_capi) {
    Py_XDECREF(capi_dens_tmp); }
  }  /*if (capi_dens_tmp == NULL) ... else of dens*/
  /* End of cleaning variable dens */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of pw92c ********************************/

/*********************************** pw92xc ***********************************/
static char doc_f2py_rout_atomic_program_pw92xc[] = "\
pw92xc(irel,dens,epsx,epsc,vx,vc,[nspin])\n\nWrapper for ``pw92xc``.\
\n\nParameters\n----------\n"
"irel : input int\n"
"dens : input rank-1 array('d') with bounds (nspin)\n"
"epsx : input float\n"
"epsc : input float\n"
"vx : input rank-1 array('d') with bounds (nspin)\n"
"vc : input rank-1 array('d') with bounds (nspin)\n"
"\nOther Parameters\n----------------\n"
"nspin : input int, optional\n    Default: len(dens)";
/* extern void F_FUNC(pw92xc,PW92XC)(int*,int*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_pw92xc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int irel = 0;
  PyObject *irel_capi = Py_None;
  int nspin = 0;
  PyObject *nspin_capi = Py_None;
  double *dens = NULL;
  npy_intp dens_Dims[1] = {-1};
  const int dens_Rank = 1;
  PyArrayObject *capi_dens_tmp = NULL;
  int capi_dens_intent = 0;
  PyObject *dens_capi = Py_None;
  double epsx = 0;
  PyObject *epsx_capi = Py_None;
  double epsc = 0;
  PyObject *epsc_capi = Py_None;
  double *vx = NULL;
  npy_intp vx_Dims[1] = {-1};
  const int vx_Rank = 1;
  PyArrayObject *capi_vx_tmp = NULL;
  int capi_vx_intent = 0;
  PyObject *vx_capi = Py_None;
  double *vc = NULL;
  npy_intp vc_Dims[1] = {-1};
  const int vc_Rank = 1;
  PyArrayObject *capi_vc_tmp = NULL;
  int capi_vc_intent = 0;
  PyObject *vc_capi = Py_None;
  static char *capi_kwlist[] = {"irel","dens","epsx","epsc","vx","vc","nspin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOO|O:atomic_program.pw92xc",\
    capi_kwlist,&irel_capi,&dens_capi,&epsx_capi,&epsc_capi,&vx_capi,&vc_capi,&nspin_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable irel */
    f2py_success = int_from_pyobj(&irel,irel_capi,"atomic_program.pw92xc() 1st argument (irel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable dens */
  ;
  capi_dens_intent |= F2PY_INTENT_IN;
  capi_dens_tmp = array_from_pyobj(NPY_DOUBLE,dens_Dims,dens_Rank,capi_dens_intent,dens_capi);
  if (capi_dens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `dens' of atomic_program.pw92xc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dens = (double *)(PyArray_DATA(capi_dens_tmp));

  /* Processing variable epsx */
    f2py_success = double_from_pyobj(&epsx,epsx_capi,"atomic_program.pw92xc() 3rd argument (epsx) can't be converted to double");
  if (f2py_success) {
  /* Processing variable epsc */
    f2py_success = double_from_pyobj(&epsc,epsc_capi,"atomic_program.pw92xc() 4th argument (epsc) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nspin */
  if (nspin_capi == Py_None) nspin = len(dens); else
    f2py_success = int_from_pyobj(&nspin,nspin_capi,"atomic_program.pw92xc() 1st keyword (nspin) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(dens)>=nspin,"len(dens)>=nspin","1st keyword nspin","pw92xc:nspin=%d",nspin) {
  /* Processing variable vx */
  vx_Dims[0]=nspin;
  capi_vx_intent |= F2PY_INTENT_IN;
  capi_vx_tmp = array_from_pyobj(NPY_DOUBLE,vx_Dims,vx_Rank,capi_vx_intent,vx_capi);
  if (capi_vx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `vx' of atomic_program.pw92xc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vx = (double *)(PyArray_DATA(capi_vx_tmp));

  /* Processing variable vc */
  vc_Dims[0]=nspin;
  capi_vc_intent |= F2PY_INTENT_IN;
  capi_vc_tmp = array_from_pyobj(NPY_DOUBLE,vc_Dims,vc_Rank,capi_vc_intent,vc_capi);
  if (capi_vc_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `vc' of atomic_program.pw92xc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vc = (double *)(PyArray_DATA(capi_vc_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&irel,&nspin,dens,&epsx,&epsc,vx,vc);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_vc_tmp!=vc_capi) {
    Py_XDECREF(capi_vc_tmp); }
  }  /*if (capi_vc_tmp == NULL) ... else of vc*/
  /* End of cleaning variable vc */
  if((PyObject *)capi_vx_tmp!=vx_capi) {
    Py_XDECREF(capi_vx_tmp); }
  }  /*if (capi_vx_tmp == NULL) ... else of vx*/
  /* End of cleaning variable vx */
  } /*CHECKSCALAR(len(dens)>=nspin)*/
  } /*if (f2py_success) of nspin*/
  /* End of cleaning variable nspin */
  } /*if (f2py_success) of epsc*/
  /* End of cleaning variable epsc */
  } /*if (f2py_success) of epsx*/
  /* End of cleaning variable epsx */
  if((PyObject *)capi_dens_tmp!=dens_capi) {
    Py_XDECREF(capi_dens_tmp); }
  }  /*if (capi_dens_tmp == NULL) ... else of dens*/
  /* End of cleaning variable dens */
  } /*if (f2py_success) of irel*/
  /* End of cleaning variable irel */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of pw92xc *******************************/

/************************************ pzxc ************************************/
static char doc_f2py_rout_atomic_program_pzxc[] = "\
pzxc(irel,ds,ex,ec,vx,vc,dvxdn,dvcdn,[nsp])\n\nWrapper for ``pzxc``.\
\n\nParameters\n----------\n"
"irel : input int\n"
"ds : input rank-1 array('d') with bounds (nsp)\n"
"ex : input float\n"
"ec : input float\n"
"vx : input rank-1 array('d') with bounds (nsp)\n"
"vc : input rank-1 array('d') with bounds (nsp)\n"
"dvxdn : input rank-2 array('d') with bounds (nsp,nsp)\n"
"dvcdn : input rank-2 array('d') with bounds (nsp,nsp)\n"
"\nOther Parameters\n----------------\n"
"nsp : input int, optional\n    Default: len(ds)";
/* extern void F_FUNC(pzxc,PZXC)(int*,int*,double*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_pzxc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int irel = 0;
  PyObject *irel_capi = Py_None;
  int nsp = 0;
  PyObject *nsp_capi = Py_None;
  double *ds = NULL;
  npy_intp ds_Dims[1] = {-1};
  const int ds_Rank = 1;
  PyArrayObject *capi_ds_tmp = NULL;
  int capi_ds_intent = 0;
  PyObject *ds_capi = Py_None;
  double ex = 0;
  PyObject *ex_capi = Py_None;
  double ec = 0;
  PyObject *ec_capi = Py_None;
  double *vx = NULL;
  npy_intp vx_Dims[1] = {-1};
  const int vx_Rank = 1;
  PyArrayObject *capi_vx_tmp = NULL;
  int capi_vx_intent = 0;
  PyObject *vx_capi = Py_None;
  double *vc = NULL;
  npy_intp vc_Dims[1] = {-1};
  const int vc_Rank = 1;
  PyArrayObject *capi_vc_tmp = NULL;
  int capi_vc_intent = 0;
  PyObject *vc_capi = Py_None;
  double *dvxdn = NULL;
  npy_intp dvxdn_Dims[2] = {-1, -1};
  const int dvxdn_Rank = 2;
  PyArrayObject *capi_dvxdn_tmp = NULL;
  int capi_dvxdn_intent = 0;
  PyObject *dvxdn_capi = Py_None;
  double *dvcdn = NULL;
  npy_intp dvcdn_Dims[2] = {-1, -1};
  const int dvcdn_Rank = 2;
  PyArrayObject *capi_dvcdn_tmp = NULL;
  int capi_dvcdn_intent = 0;
  PyObject *dvcdn_capi = Py_None;
  static char *capi_kwlist[] = {"irel","ds","ex","ec","vx","vc","dvxdn","dvcdn","nsp",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOO|O:atomic_program.pzxc",\
    capi_kwlist,&irel_capi,&ds_capi,&ex_capi,&ec_capi,&vx_capi,&vc_capi,&dvxdn_capi,&dvcdn_capi,&nsp_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable irel */
    f2py_success = int_from_pyobj(&irel,irel_capi,"atomic_program.pzxc() 1st argument (irel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ds */
  ;
  capi_ds_intent |= F2PY_INTENT_IN;
  capi_ds_tmp = array_from_pyobj(NPY_DOUBLE,ds_Dims,ds_Rank,capi_ds_intent,ds_capi);
  if (capi_ds_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `ds' of atomic_program.pzxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ds = (double *)(PyArray_DATA(capi_ds_tmp));

  /* Processing variable ex */
    f2py_success = double_from_pyobj(&ex,ex_capi,"atomic_program.pzxc() 3rd argument (ex) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ec */
    f2py_success = double_from_pyobj(&ec,ec_capi,"atomic_program.pzxc() 4th argument (ec) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nsp */
  if (nsp_capi == Py_None) nsp = len(ds); else
    f2py_success = int_from_pyobj(&nsp,nsp_capi,"atomic_program.pzxc() 1st keyword (nsp) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(ds)>=nsp,"len(ds)>=nsp","1st keyword nsp","pzxc:nsp=%d",nsp) {
  /* Processing variable vx */
  vx_Dims[0]=nsp;
  capi_vx_intent |= F2PY_INTENT_IN;
  capi_vx_tmp = array_from_pyobj(NPY_DOUBLE,vx_Dims,vx_Rank,capi_vx_intent,vx_capi);
  if (capi_vx_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `vx' of atomic_program.pzxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vx = (double *)(PyArray_DATA(capi_vx_tmp));

  /* Processing variable vc */
  vc_Dims[0]=nsp;
  capi_vc_intent |= F2PY_INTENT_IN;
  capi_vc_tmp = array_from_pyobj(NPY_DOUBLE,vc_Dims,vc_Rank,capi_vc_intent,vc_capi);
  if (capi_vc_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `vc' of atomic_program.pzxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    vc = (double *)(PyArray_DATA(capi_vc_tmp));

  /* Processing variable dvxdn */
  dvxdn_Dims[0]=nsp,dvxdn_Dims[1]=nsp;
  capi_dvxdn_intent |= F2PY_INTENT_IN;
  capi_dvxdn_tmp = array_from_pyobj(NPY_DOUBLE,dvxdn_Dims,dvxdn_Rank,capi_dvxdn_intent,dvxdn_capi);
  if (capi_dvxdn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `dvxdn' of atomic_program.pzxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dvxdn = (double *)(PyArray_DATA(capi_dvxdn_tmp));

  /* Processing variable dvcdn */
  dvcdn_Dims[0]=nsp,dvcdn_Dims[1]=nsp;
  capi_dvcdn_intent |= F2PY_INTENT_IN;
  capi_dvcdn_tmp = array_from_pyobj(NPY_DOUBLE,dvcdn_Dims,dvcdn_Rank,capi_dvcdn_intent,dvcdn_capi);
  if (capi_dvcdn_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 8th argument `dvcdn' of atomic_program.pzxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dvcdn = (double *)(PyArray_DATA(capi_dvcdn_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&irel,&nsp,ds,&ex,&ec,vx,vc,dvxdn,dvcdn);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_dvcdn_tmp!=dvcdn_capi) {
    Py_XDECREF(capi_dvcdn_tmp); }
  }  /*if (capi_dvcdn_tmp == NULL) ... else of dvcdn*/
  /* End of cleaning variable dvcdn */
  if((PyObject *)capi_dvxdn_tmp!=dvxdn_capi) {
    Py_XDECREF(capi_dvxdn_tmp); }
  }  /*if (capi_dvxdn_tmp == NULL) ... else of dvxdn*/
  /* End of cleaning variable dvxdn */
  if((PyObject *)capi_vc_tmp!=vc_capi) {
    Py_XDECREF(capi_vc_tmp); }
  }  /*if (capi_vc_tmp == NULL) ... else of vc*/
  /* End of cleaning variable vc */
  if((PyObject *)capi_vx_tmp!=vx_capi) {
    Py_XDECREF(capi_vx_tmp); }
  }  /*if (capi_vx_tmp == NULL) ... else of vx*/
  /* End of cleaning variable vx */
  } /*CHECKSCALAR(len(ds)>=nsp)*/
  } /*if (f2py_success) of nsp*/
  /* End of cleaning variable nsp */
  } /*if (f2py_success) of ec*/
  /* End of cleaning variable ec */
  } /*if (f2py_success) of ex*/
  /* End of cleaning variable ex */
  if((PyObject *)capi_ds_tmp!=ds_capi) {
    Py_XDECREF(capi_ds_tmp); }
  }  /*if (capi_ds_tmp == NULL) ... else of ds*/
  /* End of cleaning variable ds */
  } /*if (f2py_success) of irel*/
  /* End of cleaning variable irel */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************** end of pzxc ********************************/

/*********************************** blypxc ***********************************/
static char doc_f2py_rout_atomic_program_blypxc[] = "\
blypxc(dens,gdens,ex,ec,dexdd,decdd,dexdgd,decdgd,[nspin])\n\nWrapper for ``blypxc``.\
\n\nParameters\n----------\n"
"dens : input rank-1 array('d') with bounds (nspin)\n"
"gdens : input rank-2 array('d') with bounds (3,nspin)\n"
"ex : input float\n"
"ec : input float\n"
"dexdd : input rank-1 array('d') with bounds (nspin)\n"
"decdd : input rank-1 array('d') with bounds (nspin)\n"
"dexdgd : input rank-2 array('d') with bounds (3,nspin)\n"
"decdgd : input rank-2 array('d') with bounds (3,nspin)\n"
"\nOther Parameters\n----------------\n"
"nspin : input int, optional\n    Default: len(dens)";
/* extern void F_FUNC(blypxc,BLYPXC)(int*,double*,double*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_blypxc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,double*,double*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int nspin = 0;
  PyObject *nspin_capi = Py_None;
  double *dens = NULL;
  npy_intp dens_Dims[1] = {-1};
  const int dens_Rank = 1;
  PyArrayObject *capi_dens_tmp = NULL;
  int capi_dens_intent = 0;
  PyObject *dens_capi = Py_None;
  double *gdens = NULL;
  npy_intp gdens_Dims[2] = {-1, -1};
  const int gdens_Rank = 2;
  PyArrayObject *capi_gdens_tmp = NULL;
  int capi_gdens_intent = 0;
  PyObject *gdens_capi = Py_None;
  double ex = 0;
  PyObject *ex_capi = Py_None;
  double ec = 0;
  PyObject *ec_capi = Py_None;
  double *dexdd = NULL;
  npy_intp dexdd_Dims[1] = {-1};
  const int dexdd_Rank = 1;
  PyArrayObject *capi_dexdd_tmp = NULL;
  int capi_dexdd_intent = 0;
  PyObject *dexdd_capi = Py_None;
  double *decdd = NULL;
  npy_intp decdd_Dims[1] = {-1};
  const int decdd_Rank = 1;
  PyArrayObject *capi_decdd_tmp = NULL;
  int capi_decdd_intent = 0;
  PyObject *decdd_capi = Py_None;
  double *dexdgd = NULL;
  npy_intp dexdgd_Dims[2] = {-1, -1};
  const int dexdgd_Rank = 2;
  PyArrayObject *capi_dexdgd_tmp = NULL;
  int capi_dexdgd_intent = 0;
  PyObject *dexdgd_capi = Py_None;
  double *decdgd = NULL;
  npy_intp decdgd_Dims[2] = {-1, -1};
  const int decdgd_Rank = 2;
  PyArrayObject *capi_decdgd_tmp = NULL;
  int capi_decdgd_intent = 0;
  PyObject *decdgd_capi = Py_None;
  static char *capi_kwlist[] = {"dens","gdens","ex","ec","dexdd","decdd","dexdgd","decdgd","nspin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOO|O:atomic_program.blypxc",\
    capi_kwlist,&dens_capi,&gdens_capi,&ex_capi,&ec_capi,&dexdd_capi,&decdd_capi,&dexdgd_capi,&decdgd_capi,&nspin_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable dens */
  ;
  capi_dens_intent |= F2PY_INTENT_IN;
  capi_dens_tmp = array_from_pyobj(NPY_DOUBLE,dens_Dims,dens_Rank,capi_dens_intent,dens_capi);
  if (capi_dens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 1st argument `dens' of atomic_program.blypxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dens = (double *)(PyArray_DATA(capi_dens_tmp));

  /* Processing variable ex */
    f2py_success = double_from_pyobj(&ex,ex_capi,"atomic_program.blypxc() 3rd argument (ex) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ec */
    f2py_success = double_from_pyobj(&ec,ec_capi,"atomic_program.blypxc() 4th argument (ec) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nspin */
  if (nspin_capi == Py_None) nspin = len(dens); else
    f2py_success = int_from_pyobj(&nspin,nspin_capi,"atomic_program.blypxc() 1st keyword (nspin) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(dens)>=nspin,"len(dens)>=nspin","1st keyword nspin","blypxc:nspin=%d",nspin) {
  /* Processing variable gdens */
  gdens_Dims[0]=3,gdens_Dims[1]=nspin;
  capi_gdens_intent |= F2PY_INTENT_IN;
  capi_gdens_tmp = array_from_pyobj(NPY_DOUBLE,gdens_Dims,gdens_Rank,capi_gdens_intent,gdens_capi);
  if (capi_gdens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `gdens' of atomic_program.blypxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    gdens = (double *)(PyArray_DATA(capi_gdens_tmp));

  /* Processing variable dexdd */
  dexdd_Dims[0]=nspin;
  capi_dexdd_intent |= F2PY_INTENT_IN;
  capi_dexdd_tmp = array_from_pyobj(NPY_DOUBLE,dexdd_Dims,dexdd_Rank,capi_dexdd_intent,dexdd_capi);
  if (capi_dexdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 5th argument `dexdd' of atomic_program.blypxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dexdd = (double *)(PyArray_DATA(capi_dexdd_tmp));

  /* Processing variable decdd */
  decdd_Dims[0]=nspin;
  capi_decdd_intent |= F2PY_INTENT_IN;
  capi_decdd_tmp = array_from_pyobj(NPY_DOUBLE,decdd_Dims,decdd_Rank,capi_decdd_intent,decdd_capi);
  if (capi_decdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `decdd' of atomic_program.blypxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    decdd = (double *)(PyArray_DATA(capi_decdd_tmp));

  /* Processing variable dexdgd */
  dexdgd_Dims[0]=3,dexdgd_Dims[1]=nspin;
  capi_dexdgd_intent |= F2PY_INTENT_IN;
  capi_dexdgd_tmp = array_from_pyobj(NPY_DOUBLE,dexdgd_Dims,dexdgd_Rank,capi_dexdgd_intent,dexdgd_capi);
  if (capi_dexdgd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `dexdgd' of atomic_program.blypxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dexdgd = (double *)(PyArray_DATA(capi_dexdgd_tmp));

  /* Processing variable decdgd */
  decdgd_Dims[0]=3,decdgd_Dims[1]=nspin;
  capi_decdgd_intent |= F2PY_INTENT_IN;
  capi_decdgd_tmp = array_from_pyobj(NPY_DOUBLE,decdgd_Dims,decdgd_Rank,capi_decdgd_intent,decdgd_capi);
  if (capi_decdgd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 8th argument `decdgd' of atomic_program.blypxc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    decdgd = (double *)(PyArray_DATA(capi_decdgd_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&nspin,dens,gdens,&ex,&ec,dexdd,decdd,dexdgd,decdgd);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_decdgd_tmp!=decdgd_capi) {
    Py_XDECREF(capi_decdgd_tmp); }
  }  /*if (capi_decdgd_tmp == NULL) ... else of decdgd*/
  /* End of cleaning variable decdgd */
  if((PyObject *)capi_dexdgd_tmp!=dexdgd_capi) {
    Py_XDECREF(capi_dexdgd_tmp); }
  }  /*if (capi_dexdgd_tmp == NULL) ... else of dexdgd*/
  /* End of cleaning variable dexdgd */
  if((PyObject *)capi_decdd_tmp!=decdd_capi) {
    Py_XDECREF(capi_decdd_tmp); }
  }  /*if (capi_decdd_tmp == NULL) ... else of decdd*/
  /* End of cleaning variable decdd */
  if((PyObject *)capi_dexdd_tmp!=dexdd_capi) {
    Py_XDECREF(capi_dexdd_tmp); }
  }  /*if (capi_dexdd_tmp == NULL) ... else of dexdd*/
  /* End of cleaning variable dexdd */
  if((PyObject *)capi_gdens_tmp!=gdens_capi) {
    Py_XDECREF(capi_gdens_tmp); }
  }  /*if (capi_gdens_tmp == NULL) ... else of gdens*/
  /* End of cleaning variable gdens */
  } /*CHECKSCALAR(len(dens)>=nspin)*/
  } /*if (f2py_success) of nspin*/
  /* End of cleaning variable nspin */
  } /*if (f2py_success) of ec*/
  /* End of cleaning variable ec */
  } /*if (f2py_success) of ex*/
  /* End of cleaning variable ex */
  if((PyObject *)capi_dens_tmp!=dens_capi) {
    Py_XDECREF(capi_dens_tmp); }
  }  /*if (capi_dens_tmp == NULL) ... else of dens*/
  /* End of cleaning variable dens */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of blypxc *******************************/

/*********************************** rpbexc ***********************************/
static char doc_f2py_rout_atomic_program_rpbexc[] = "\
rpbexc(irel,dens,gdens,ex,ec,dexdd,decdd,dexdgd,decdgd,[nspin])\n\nWrapper for ``rpbexc``.\
\n\nParameters\n----------\n"
"irel : input int\n"
"dens : input rank-1 array('d') with bounds (nspin)\n"
"gdens : input rank-2 array('d') with bounds (3,nspin)\n"
"ex : input float\n"
"ec : input float\n"
"dexdd : input rank-1 array('d') with bounds (nspin)\n"
"decdd : input rank-1 array('d') with bounds (nspin)\n"
"dexdgd : input rank-2 array('d') with bounds (3,nspin)\n"
"decdgd : input rank-2 array('d') with bounds (3,nspin)\n"
"\nOther Parameters\n----------------\n"
"nspin : input int, optional\n    Default: len(dens)";
/* extern void F_FUNC(rpbexc,RPBEXC)(int*,int*,double*,double*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_rpbexc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int irel = 0;
  PyObject *irel_capi = Py_None;
  int nspin = 0;
  PyObject *nspin_capi = Py_None;
  double *dens = NULL;
  npy_intp dens_Dims[1] = {-1};
  const int dens_Rank = 1;
  PyArrayObject *capi_dens_tmp = NULL;
  int capi_dens_intent = 0;
  PyObject *dens_capi = Py_None;
  double *gdens = NULL;
  npy_intp gdens_Dims[2] = {-1, -1};
  const int gdens_Rank = 2;
  PyArrayObject *capi_gdens_tmp = NULL;
  int capi_gdens_intent = 0;
  PyObject *gdens_capi = Py_None;
  double ex = 0;
  PyObject *ex_capi = Py_None;
  double ec = 0;
  PyObject *ec_capi = Py_None;
  double *dexdd = NULL;
  npy_intp dexdd_Dims[1] = {-1};
  const int dexdd_Rank = 1;
  PyArrayObject *capi_dexdd_tmp = NULL;
  int capi_dexdd_intent = 0;
  PyObject *dexdd_capi = Py_None;
  double *decdd = NULL;
  npy_intp decdd_Dims[1] = {-1};
  const int decdd_Rank = 1;
  PyArrayObject *capi_decdd_tmp = NULL;
  int capi_decdd_intent = 0;
  PyObject *decdd_capi = Py_None;
  double *dexdgd = NULL;
  npy_intp dexdgd_Dims[2] = {-1, -1};
  const int dexdgd_Rank = 2;
  PyArrayObject *capi_dexdgd_tmp = NULL;
  int capi_dexdgd_intent = 0;
  PyObject *dexdgd_capi = Py_None;
  double *decdgd = NULL;
  npy_intp decdgd_Dims[2] = {-1, -1};
  const int decdgd_Rank = 2;
  PyArrayObject *capi_decdgd_tmp = NULL;
  int capi_decdgd_intent = 0;
  PyObject *decdgd_capi = Py_None;
  static char *capi_kwlist[] = {"irel","dens","gdens","ex","ec","dexdd","decdd","dexdgd","decdgd","nspin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOO|O:atomic_program.rpbexc",\
    capi_kwlist,&irel_capi,&dens_capi,&gdens_capi,&ex_capi,&ec_capi,&dexdd_capi,&decdd_capi,&dexdgd_capi,&decdgd_capi,&nspin_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable irel */
    f2py_success = int_from_pyobj(&irel,irel_capi,"atomic_program.rpbexc() 1st argument (irel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable dens */
  ;
  capi_dens_intent |= F2PY_INTENT_IN;
  capi_dens_tmp = array_from_pyobj(NPY_DOUBLE,dens_Dims,dens_Rank,capi_dens_intent,dens_capi);
  if (capi_dens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `dens' of atomic_program.rpbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dens = (double *)(PyArray_DATA(capi_dens_tmp));

  /* Processing variable ex */
    f2py_success = double_from_pyobj(&ex,ex_capi,"atomic_program.rpbexc() 4th argument (ex) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ec */
    f2py_success = double_from_pyobj(&ec,ec_capi,"atomic_program.rpbexc() 5th argument (ec) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nspin */
  if (nspin_capi == Py_None) nspin = len(dens); else
    f2py_success = int_from_pyobj(&nspin,nspin_capi,"atomic_program.rpbexc() 1st keyword (nspin) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(dens)>=nspin,"len(dens)>=nspin","1st keyword nspin","rpbexc:nspin=%d",nspin) {
  /* Processing variable gdens */
  gdens_Dims[0]=3,gdens_Dims[1]=nspin;
  capi_gdens_intent |= F2PY_INTENT_IN;
  capi_gdens_tmp = array_from_pyobj(NPY_DOUBLE,gdens_Dims,gdens_Rank,capi_gdens_intent,gdens_capi);
  if (capi_gdens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `gdens' of atomic_program.rpbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    gdens = (double *)(PyArray_DATA(capi_gdens_tmp));

  /* Processing variable dexdd */
  dexdd_Dims[0]=nspin;
  capi_dexdd_intent |= F2PY_INTENT_IN;
  capi_dexdd_tmp = array_from_pyobj(NPY_DOUBLE,dexdd_Dims,dexdd_Rank,capi_dexdd_intent,dexdd_capi);
  if (capi_dexdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `dexdd' of atomic_program.rpbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dexdd = (double *)(PyArray_DATA(capi_dexdd_tmp));

  /* Processing variable decdd */
  decdd_Dims[0]=nspin;
  capi_decdd_intent |= F2PY_INTENT_IN;
  capi_decdd_tmp = array_from_pyobj(NPY_DOUBLE,decdd_Dims,decdd_Rank,capi_decdd_intent,decdd_capi);
  if (capi_decdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `decdd' of atomic_program.rpbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    decdd = (double *)(PyArray_DATA(capi_decdd_tmp));

  /* Processing variable dexdgd */
  dexdgd_Dims[0]=3,dexdgd_Dims[1]=nspin;
  capi_dexdgd_intent |= F2PY_INTENT_IN;
  capi_dexdgd_tmp = array_from_pyobj(NPY_DOUBLE,dexdgd_Dims,dexdgd_Rank,capi_dexdgd_intent,dexdgd_capi);
  if (capi_dexdgd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 8th argument `dexdgd' of atomic_program.rpbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dexdgd = (double *)(PyArray_DATA(capi_dexdgd_tmp));

  /* Processing variable decdgd */
  decdgd_Dims[0]=3,decdgd_Dims[1]=nspin;
  capi_decdgd_intent |= F2PY_INTENT_IN;
  capi_decdgd_tmp = array_from_pyobj(NPY_DOUBLE,decdgd_Dims,decdgd_Rank,capi_decdgd_intent,decdgd_capi);
  if (capi_decdgd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 9th argument `decdgd' of atomic_program.rpbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    decdgd = (double *)(PyArray_DATA(capi_decdgd_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&irel,&nspin,dens,gdens,&ex,&ec,dexdd,decdd,dexdgd,decdgd);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_decdgd_tmp!=decdgd_capi) {
    Py_XDECREF(capi_decdgd_tmp); }
  }  /*if (capi_decdgd_tmp == NULL) ... else of decdgd*/
  /* End of cleaning variable decdgd */
  if((PyObject *)capi_dexdgd_tmp!=dexdgd_capi) {
    Py_XDECREF(capi_dexdgd_tmp); }
  }  /*if (capi_dexdgd_tmp == NULL) ... else of dexdgd*/
  /* End of cleaning variable dexdgd */
  if((PyObject *)capi_decdd_tmp!=decdd_capi) {
    Py_XDECREF(capi_decdd_tmp); }
  }  /*if (capi_decdd_tmp == NULL) ... else of decdd*/
  /* End of cleaning variable decdd */
  if((PyObject *)capi_dexdd_tmp!=dexdd_capi) {
    Py_XDECREF(capi_dexdd_tmp); }
  }  /*if (capi_dexdd_tmp == NULL) ... else of dexdd*/
  /* End of cleaning variable dexdd */
  if((PyObject *)capi_gdens_tmp!=gdens_capi) {
    Py_XDECREF(capi_gdens_tmp); }
  }  /*if (capi_gdens_tmp == NULL) ... else of gdens*/
  /* End of cleaning variable gdens */
  } /*CHECKSCALAR(len(dens)>=nspin)*/
  } /*if (f2py_success) of nspin*/
  /* End of cleaning variable nspin */
  } /*if (f2py_success) of ec*/
  /* End of cleaning variable ec */
  } /*if (f2py_success) of ex*/
  /* End of cleaning variable ex */
  if((PyObject *)capi_dens_tmp!=dens_capi) {
    Py_XDECREF(capi_dens_tmp); }
  }  /*if (capi_dens_tmp == NULL) ... else of dens*/
  /* End of cleaning variable dens */
  } /*if (f2py_success) of irel*/
  /* End of cleaning variable irel */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of rpbexc *******************************/

/********************************** revpbexc **********************************/
static char doc_f2py_rout_atomic_program_revpbexc[] = "\
revpbexc(irel,dens,gdens,ex,ec,dexdd,decdd,dexdgd,decdgd,[nspin])\n\nWrapper for ``revpbexc``.\
\n\nParameters\n----------\n"
"irel : input int\n"
"dens : input rank-1 array('d') with bounds (nspin)\n"
"gdens : input rank-2 array('d') with bounds (3,nspin)\n"
"ex : input float\n"
"ec : input float\n"
"dexdd : input rank-1 array('d') with bounds (nspin)\n"
"decdd : input rank-1 array('d') with bounds (nspin)\n"
"dexdgd : input rank-2 array('d') with bounds (3,nspin)\n"
"decdgd : input rank-2 array('d') with bounds (3,nspin)\n"
"\nOther Parameters\n----------------\n"
"nspin : input int, optional\n    Default: len(dens)";
/* extern void F_FUNC(revpbexc,REVPBEXC)(int*,int*,double*,double*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_atomic_program_revpbexc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,double*,double*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int irel = 0;
  PyObject *irel_capi = Py_None;
  int nspin = 0;
  PyObject *nspin_capi = Py_None;
  double *dens = NULL;
  npy_intp dens_Dims[1] = {-1};
  const int dens_Rank = 1;
  PyArrayObject *capi_dens_tmp = NULL;
  int capi_dens_intent = 0;
  PyObject *dens_capi = Py_None;
  double *gdens = NULL;
  npy_intp gdens_Dims[2] = {-1, -1};
  const int gdens_Rank = 2;
  PyArrayObject *capi_gdens_tmp = NULL;
  int capi_gdens_intent = 0;
  PyObject *gdens_capi = Py_None;
  double ex = 0;
  PyObject *ex_capi = Py_None;
  double ec = 0;
  PyObject *ec_capi = Py_None;
  double *dexdd = NULL;
  npy_intp dexdd_Dims[1] = {-1};
  const int dexdd_Rank = 1;
  PyArrayObject *capi_dexdd_tmp = NULL;
  int capi_dexdd_intent = 0;
  PyObject *dexdd_capi = Py_None;
  double *decdd = NULL;
  npy_intp decdd_Dims[1] = {-1};
  const int decdd_Rank = 1;
  PyArrayObject *capi_decdd_tmp = NULL;
  int capi_decdd_intent = 0;
  PyObject *decdd_capi = Py_None;
  double *dexdgd = NULL;
  npy_intp dexdgd_Dims[2] = {-1, -1};
  const int dexdgd_Rank = 2;
  PyArrayObject *capi_dexdgd_tmp = NULL;
  int capi_dexdgd_intent = 0;
  PyObject *dexdgd_capi = Py_None;
  double *decdgd = NULL;
  npy_intp decdgd_Dims[2] = {-1, -1};
  const int decdgd_Rank = 2;
  PyArrayObject *capi_decdgd_tmp = NULL;
  int capi_decdgd_intent = 0;
  PyObject *decdgd_capi = Py_None;
  static char *capi_kwlist[] = {"irel","dens","gdens","ex","ec","dexdd","decdd","dexdgd","decdgd","nspin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOO|O:atomic_program.revpbexc",\
    capi_kwlist,&irel_capi,&dens_capi,&gdens_capi,&ex_capi,&ec_capi,&dexdd_capi,&decdd_capi,&dexdgd_capi,&decdgd_capi,&nspin_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable irel */
    f2py_success = int_from_pyobj(&irel,irel_capi,"atomic_program.revpbexc() 1st argument (irel) can't be converted to int");
  if (f2py_success) {
  /* Processing variable dens */
  ;
  capi_dens_intent |= F2PY_INTENT_IN;
  capi_dens_tmp = array_from_pyobj(NPY_DOUBLE,dens_Dims,dens_Rank,capi_dens_intent,dens_capi);
  if (capi_dens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 2nd argument `dens' of atomic_program.revpbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dens = (double *)(PyArray_DATA(capi_dens_tmp));

  /* Processing variable ex */
    f2py_success = double_from_pyobj(&ex,ex_capi,"atomic_program.revpbexc() 4th argument (ex) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ec */
    f2py_success = double_from_pyobj(&ec,ec_capi,"atomic_program.revpbexc() 5th argument (ec) can't be converted to double");
  if (f2py_success) {
  /* Processing variable nspin */
  if (nspin_capi == Py_None) nspin = len(dens); else
    f2py_success = int_from_pyobj(&nspin,nspin_capi,"atomic_program.revpbexc() 1st keyword (nspin) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(dens)>=nspin,"len(dens)>=nspin","1st keyword nspin","revpbexc:nspin=%d",nspin) {
  /* Processing variable gdens */
  gdens_Dims[0]=3,gdens_Dims[1]=nspin;
  capi_gdens_intent |= F2PY_INTENT_IN;
  capi_gdens_tmp = array_from_pyobj(NPY_DOUBLE,gdens_Dims,gdens_Rank,capi_gdens_intent,gdens_capi);
  if (capi_gdens_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 3rd argument `gdens' of atomic_program.revpbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    gdens = (double *)(PyArray_DATA(capi_gdens_tmp));

  /* Processing variable dexdd */
  dexdd_Dims[0]=nspin;
  capi_dexdd_intent |= F2PY_INTENT_IN;
  capi_dexdd_tmp = array_from_pyobj(NPY_DOUBLE,dexdd_Dims,dexdd_Rank,capi_dexdd_intent,dexdd_capi);
  if (capi_dexdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 6th argument `dexdd' of atomic_program.revpbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dexdd = (double *)(PyArray_DATA(capi_dexdd_tmp));

  /* Processing variable decdd */
  decdd_Dims[0]=nspin;
  capi_decdd_intent |= F2PY_INTENT_IN;
  capi_decdd_tmp = array_from_pyobj(NPY_DOUBLE,decdd_Dims,decdd_Rank,capi_decdd_intent,decdd_capi);
  if (capi_decdd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 7th argument `decdd' of atomic_program.revpbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    decdd = (double *)(PyArray_DATA(capi_decdd_tmp));

  /* Processing variable dexdgd */
  dexdgd_Dims[0]=3,dexdgd_Dims[1]=nspin;
  capi_dexdgd_intent |= F2PY_INTENT_IN;
  capi_dexdgd_tmp = array_from_pyobj(NPY_DOUBLE,dexdgd_Dims,dexdgd_Rank,capi_dexdgd_intent,dexdgd_capi);
  if (capi_dexdgd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 8th argument `dexdgd' of atomic_program.revpbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    dexdgd = (double *)(PyArray_DATA(capi_dexdgd_tmp));

  /* Processing variable decdgd */
  decdgd_Dims[0]=3,decdgd_Dims[1]=nspin;
  capi_decdgd_intent |= F2PY_INTENT_IN;
  capi_decdgd_tmp = array_from_pyobj(NPY_DOUBLE,decdgd_Dims,decdgd_Rank,capi_decdgd_intent,decdgd_capi);
  if (capi_decdgd_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : atomic_program_error,"failed in converting 9th argument `decdgd' of atomic_program.revpbexc to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    decdgd = (double *)(PyArray_DATA(capi_decdgd_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&irel,&nspin,dens,gdens,&ex,&ec,dexdd,decdd,dexdgd,decdgd);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_decdgd_tmp!=decdgd_capi) {
    Py_XDECREF(capi_decdgd_tmp); }
  }  /*if (capi_decdgd_tmp == NULL) ... else of decdgd*/
  /* End of cleaning variable decdgd */
  if((PyObject *)capi_dexdgd_tmp!=dexdgd_capi) {
    Py_XDECREF(capi_dexdgd_tmp); }
  }  /*if (capi_dexdgd_tmp == NULL) ... else of dexdgd*/
  /* End of cleaning variable dexdgd */
  if((PyObject *)capi_decdd_tmp!=decdd_capi) {
    Py_XDECREF(capi_decdd_tmp); }
  }  /*if (capi_decdd_tmp == NULL) ... else of decdd*/
  /* End of cleaning variable decdd */
  if((PyObject *)capi_dexdd_tmp!=dexdd_capi) {
    Py_XDECREF(capi_dexdd_tmp); }
  }  /*if (capi_dexdd_tmp == NULL) ... else of dexdd*/
  /* End of cleaning variable dexdd */
  if((PyObject *)capi_gdens_tmp!=gdens_capi) {
    Py_XDECREF(capi_gdens_tmp); }
  }  /*if (capi_gdens_tmp == NULL) ... else of gdens*/
  /* End of cleaning variable gdens */
  } /*CHECKSCALAR(len(dens)>=nspin)*/
  } /*if (f2py_success) of nspin*/
  /* End of cleaning variable nspin */
  } /*if (f2py_success) of ec*/
  /* End of cleaning variable ec */
  } /*if (f2py_success) of ex*/
  /* End of cleaning variable ex */
  if((PyObject *)capi_dens_tmp!=dens_capi) {
    Py_XDECREF(capi_dens_tmp); }
  }  /*if (capi_dens_tmp == NULL) ... else of dens*/
  /* End of cleaning variable dens */
  } /*if (f2py_success) of irel*/
  /* End of cleaning variable irel */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of revpbexc ******************************/

/********************************** cal_date **********************************/
static char doc_f2py_rout_atomic_program_cal_date[] = "\
cal_date(bdate)\n\nWrapper for ``cal_date``.\
\n\nParameters\n----------\n"
"bdate : input string(len=10)";
/* extern void F_FUNC_US(cal_date,CAL_DATE)(string,size_t); */
static PyObject *f2py_rout_atomic_program_cal_date(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string bdate = NULL;
  int slen(bdate);
  PyObject *bdate_capi = Py_None;
  static char *capi_kwlist[] = {"bdate",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O|:atomic_program.cal_date",\
    capi_kwlist,&bdate_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable bdate */
  slen(bdate) = 10;
  f2py_success = string_from_pyobj(&bdate,&slen(bdate),"",bdate_capi,"string_from_pyobj failed in converting 1st argument `bdate' of atomic_program.cal_date to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(bdate,slen(bdate));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(bdate);
  }  /*if (f2py_success) of bdate*/
  /* End of cleaning variable bdate */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of cal_date ******************************/

/*********************************** second ***********************************/
static char doc_f2py_rout_atomic_program_second[] = "\
second = second()\n\nWrapper for ``second``.\
\n\nReturns\n-------\n"
"second : float";
/* extern void F_WRAPPEDFUNC(second,SECOND)(double*); */
static PyObject *f2py_rout_atomic_program_second(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double second = 0;
  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "|:atomic_program.second",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
  /* Processing variable second */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&second);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("d",second);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable second */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of second *******************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

static FortranDataDef f2py_radial_def[] = {
  {"a",0,{{-1}},NPY_DOUBLE},
  {"b",0,{{-1}},NPY_DOUBLE},
  {"r",1,{{1500}},NPY_DOUBLE},
  {"rab",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_radial(char *a,char *b,char *r,char *rab) {
  int i_f2py=0;
  f2py_radial_def[i_f2py++].data = a;
  f2py_radial_def[i_f2py++].data = b;
  f2py_radial_def[i_f2py++].data = r;
  f2py_radial_def[i_f2py++].data = rab;
}
extern void F_FUNC(f2pyinitradial,F2PYINITRADIAL)(void(*)(char*,char*,char*,char*));
static void f2py_init_radial(void) {
  F_FUNC(f2pyinitradial,F2PYINITRADIAL)(f2py_setup_radial);
}

static FortranDataDef f2py_rad_int_def[] = {
  {"nr",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_rad_int(char *nr) {
  int i_f2py=0;
  f2py_rad_int_def[i_f2py++].data = nr;
}
extern void F_FUNC_US(f2pyinitrad_int,F2PYINITRAD_INT)(void(*)(char*));
static void f2py_init_rad_int(void) {
  F_FUNC_US(f2pyinitrad_int,F2PYINITRAD_INT)(f2py_setup_rad_int);
}

static FortranDataDef f2py_orbital_def[] = {
  {"so",1,{{40}},NPY_DOUBLE},
  {"zo",1,{{40}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_orbital(char *so,char *zo) {
  int i_f2py=0;
  f2py_orbital_def[i_f2py++].data = so;
  f2py_orbital_def[i_f2py++].data = zo;
}
extern void F_FUNC(f2pyinitorbital,F2PYINITORBITAL)(void(*)(char*,char*));
static void f2py_init_orbital(void) {
  F_FUNC(f2pyinitorbital,F2PYINITORBITAL)(f2py_setup_orbital);
}

static FortranDataDef f2py_orb_int_def[] = {
  {"norb",0,{{-1}},NPY_INT},
  {"ncp",0,{{-1}},NPY_INT},
  {"no",1,{{40}},NPY_INT},
  {"lo",1,{{40}},NPY_INT},
  {NULL}
};
static void f2py_setup_orb_int(char *norb,char *ncp,char *no,char *lo) {
  int i_f2py=0;
  f2py_orb_int_def[i_f2py++].data = norb;
  f2py_orb_int_def[i_f2py++].data = ncp;
  f2py_orb_int_def[i_f2py++].data = no;
  f2py_orb_int_def[i_f2py++].data = lo;
}
extern void F_FUNC_US(f2pyinitorb_int,F2PYINITORB_INT)(void(*)(char*,char*,char*,char*));
static void f2py_init_orb_int(void) {
  F_FUNC_US(f2pyinitorb_int,F2PYINITORB_INT)(f2py_setup_orb_int);
}

static FortranDataDef f2py_orb_char_def[] = {
  {"il",2,{{5,1}},NPY_STRING},
  {NULL}
};
static void f2py_setup_orb_char(char *il) {
  int i_f2py=0;
  f2py_orb_char_def[i_f2py++].data = il;
}
extern void F_FUNC_US(f2pyinitorb_char,F2PYINITORB_CHAR)(void(*)(char*));
static void f2py_init_orb_char(void) {
  F_FUNC_US(f2pyinitorb_char,F2PYINITORB_CHAR)(f2py_setup_orb_char);
}

static FortranDataDef f2py_orb_log_def[] = {
  {"down",1,{{40}},NPY_INT},
  {NULL}
};
static void f2py_setup_orb_log(char *down) {
  int i_f2py=0;
  f2py_orb_log_def[i_f2py++].data = down;
}
extern void F_FUNC_US(f2pyinitorb_log,F2PYINITORB_LOG)(void(*)(char*));
static void f2py_init_orb_log(void) {
  F_FUNC_US(f2pyinitorb_log,F2PYINITORB_LOG)(f2py_setup_orb_log);
}

static FortranDataDef f2py_param_def[] = {
  {"scheme",0,{{-1}},NPY_INT},
  {"job",0,{{-1}},NPY_INT},
  {"ifcore",0,{{-1}},NPY_INT},
  {"ncore",0,{{-1}},NPY_INT},
  {"rsh",0,{{-1}},NPY_DOUBLE},
  {"zel",0,{{-1}},NPY_DOUBLE},
  {"znuc",0,{{-1}},NPY_DOUBLE},
  {"zsh",0,{{-1}},NPY_DOUBLE},
  {"rc",1,{{5}},NPY_DOUBLE},
  {"rc_input",1,{{5}},NPY_DOUBLE},
  {"cfac",0,{{-1}},NPY_DOUBLE},
  {"rcfac",0,{{-1}},NPY_DOUBLE},
  {"logder_radius",0,{{-1}},NPY_DOUBLE},
  {"indu",1,{{5}},NPY_INT},
  {"indd",1,{{5}},NPY_INT},
  {NULL}
};
static void f2py_setup_param(char *scheme,char *job,char *ifcore,char *ncore,char *rsh,char *zel,char *znuc,char *zsh,char *rc,char *rc_input,char *cfac,char *rcfac,char *logder_radius,char *indu,char *indd) {
  int i_f2py=0;
  f2py_param_def[i_f2py++].data = scheme;
  f2py_param_def[i_f2py++].data = job;
  f2py_param_def[i_f2py++].data = ifcore;
  f2py_param_def[i_f2py++].data = ncore;
  f2py_param_def[i_f2py++].data = rsh;
  f2py_param_def[i_f2py++].data = zel;
  f2py_param_def[i_f2py++].data = znuc;
  f2py_param_def[i_f2py++].data = zsh;
  f2py_param_def[i_f2py++].data = rc;
  f2py_param_def[i_f2py++].data = rc_input;
  f2py_param_def[i_f2py++].data = cfac;
  f2py_param_def[i_f2py++].data = rcfac;
  f2py_param_def[i_f2py++].data = logder_radius;
  f2py_param_def[i_f2py++].data = indu;
  f2py_param_def[i_f2py++].data = indd;
}
extern void F_FUNC(f2pyinitparam,F2PYINITPARAM)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_param(void) {
  F_FUNC(f2pyinitparam,F2PYINITPARAM)(f2py_setup_param);
}

static FortranDataDef f2py_par_char_def[] = {
  {"nameat",1,{{2}},NPY_STRING},
  {"ispp",1,{{1}},NPY_STRING},
  {"icorr",1,{{2}},NPY_STRING},
  {"irel",1,{{3}},NPY_STRING},
  {"nicore",1,{{4}},NPY_STRING},
  {NULL}
};
static void f2py_setup_par_char(char *nameat,char *ispp,char *icorr,char *irel,char *nicore) {
  int i_f2py=0;
  f2py_par_char_def[i_f2py++].data = nameat;
  f2py_par_char_def[i_f2py++].data = ispp;
  f2py_par_char_def[i_f2py++].data = icorr;
  f2py_par_char_def[i_f2py++].data = irel;
  f2py_par_char_def[i_f2py++].data = nicore;
}
extern void F_FUNC_US(f2pyinitpar_char,F2PYINITPAR_CHAR)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_par_char(void) {
  F_FUNC_US(f2pyinitpar_char,F2PYINITPAR_CHAR)(f2py_setup_par_char);
}

static FortranDataDef f2py_par_log_def[] = {
  {"normal",0,{{-1}},NPY_INT},
  {"polarized",0,{{-1}},NPY_INT},
  {"relativistic",0,{{-1}},NPY_INT},
  {"is_gga",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_par_log(char *normal,char *polarized,char *relativistic,char *is_gga) {
  int i_f2py=0;
  f2py_par_log_def[i_f2py++].data = normal;
  f2py_par_log_def[i_f2py++].data = polarized;
  f2py_par_log_def[i_f2py++].data = relativistic;
  f2py_par_log_def[i_f2py++].data = is_gga;
}
extern void F_FUNC_US(f2pyinitpar_log,F2PYINITPAR_LOG)(void(*)(char*,char*,char*,char*));
static void f2py_init_par_log(void) {
  F_FUNC_US(f2pyinitpar_log,F2PYINITPAR_LOG)(f2py_setup_par_log);
}

static FortranDataDef f2py_charge_def[] = {
  {"cdd",1,{{1500}},NPY_DOUBLE},
  {"cdu",1,{{1500}},NPY_DOUBLE},
  {"cdc",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_charge(char *cdd,char *cdu,char *cdc) {
  int i_f2py=0;
  f2py_charge_def[i_f2py++].data = cdd;
  f2py_charge_def[i_f2py++].data = cdu;
  f2py_charge_def[i_f2py++].data = cdc;
}
extern void F_FUNC(f2pyinitcharge,F2PYINITCHARGE)(void(*)(char*,char*,char*));
static void f2py_init_charge(void) {
  F_FUNC(f2pyinitcharge,F2PYINITCHARGE)(f2py_setup_charge);
}

static FortranDataDef f2py_elecpot_def[] = {
  {"vid",1,{{1500}},NPY_DOUBLE},
  {"viu",1,{{1500}},NPY_DOUBLE},
  {"vod",1,{{1500}},NPY_DOUBLE},
  {"vou",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_elecpot(char *vid,char *viu,char *vod,char *vou) {
  int i_f2py=0;
  f2py_elecpot_def[i_f2py++].data = vid;
  f2py_elecpot_def[i_f2py++].data = viu;
  f2py_elecpot_def[i_f2py++].data = vod;
  f2py_elecpot_def[i_f2py++].data = vou;
}
extern void F_FUNC(f2pyinitelecpot,F2PYINITELECPOT)(void(*)(char*,char*,char*,char*));
static void f2py_init_elecpot(void) {
  F_FUNC(f2pyinitelecpot,F2PYINITELECPOT)(f2py_setup_elecpot);
}

static FortranDataDef f2py_energy_def[] = {
  {"ev",1,{{40}},NPY_DOUBLE},
  {"ep",1,{{40}},NPY_DOUBLE},
  {"ek",1,{{40}},NPY_DOUBLE},
  {"etot",1,{{10}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_energy(char *ev,char *ep,char *ek,char *etot) {
  int i_f2py=0;
  f2py_energy_def[i_f2py++].data = ev;
  f2py_energy_def[i_f2py++].data = ep;
  f2py_energy_def[i_f2py++].data = ek;
  f2py_energy_def[i_f2py++].data = etot;
}
extern void F_FUNC(f2pyinitenergy,F2PYINITENERGY)(void(*)(char*,char*,char*,char*));
static void f2py_init_energy(void) {
  F_FUNC(f2pyinitenergy,F2PYINITENERGY)(f2py_setup_energy);
}

static FortranDataDef f2py_mixer_def[] = {
  {"vn1d",1,{{1500}},NPY_DOUBLE},
  {"vn11d",1,{{1500}},NPY_DOUBLE},
  {"vn2d",1,{{1500}},NPY_DOUBLE},
  {"vn22d",1,{{1500}},NPY_DOUBLE},
  {"vn1u",1,{{1500}},NPY_DOUBLE},
  {"vn11u",1,{{1500}},NPY_DOUBLE},
  {"vn2u",1,{{1500}},NPY_DOUBLE},
  {"vn22u",1,{{1500}},NPY_DOUBLE},
  {"wk1",1,{{1500}},NPY_DOUBLE},
  {"wk2",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_mixer(char *vn1d,char *vn11d,char *vn2d,char *vn22d,char *vn1u,char *vn11u,char *vn2u,char *vn22u,char *wk1,char *wk2) {
  int i_f2py=0;
  f2py_mixer_def[i_f2py++].data = vn1d;
  f2py_mixer_def[i_f2py++].data = vn11d;
  f2py_mixer_def[i_f2py++].data = vn2d;
  f2py_mixer_def[i_f2py++].data = vn22d;
  f2py_mixer_def[i_f2py++].data = vn1u;
  f2py_mixer_def[i_f2py++].data = vn11u;
  f2py_mixer_def[i_f2py++].data = vn2u;
  f2py_mixer_def[i_f2py++].data = vn22u;
  f2py_mixer_def[i_f2py++].data = wk1;
  f2py_mixer_def[i_f2py++].data = wk2;
}
extern void F_FUNC(f2pyinitmixer,F2PYINITMIXER)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_mixer(void) {
  F_FUNC(f2pyinitmixer,F2PYINITMIXER)(f2py_setup_mixer);
}

static FortranDataDef f2py_ion_def[] = {
  {"viod",2,{{4,1500}},NPY_DOUBLE},
  {"viou",2,{{4,1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_ion(char *viod,char *viou) {
  int i_f2py=0;
  f2py_ion_def[i_f2py++].data = viod;
  f2py_ion_def[i_f2py++].data = viou;
}
extern void F_FUNC(f2pyinition,F2PYINITION)(void(*)(char*,char*));
static void f2py_init_ion(void) {
  F_FUNC(f2pyinition,F2PYINITION)(f2py_setup_ion);
}

static FortranDataDef f2py__BLNK__def[] = {
  {"rab2",1,{{1500}},NPY_DOUBLE},
  {"fa",1,{{1500}},NPY_DOUBLE},
  {"fb",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup__BLNK_(char *rab2,char *fa,char *fb) {
  int i_f2py=0;
  f2py__BLNK__def[i_f2py++].data = rab2;
  f2py__BLNK__def[i_f2py++].data = fa;
  f2py__BLNK__def[i_f2py++].data = fb;
}
extern void F_FUNC_US(f2pyinit_blnk_,F2PYINIT_BLNK_)(void(*)(char*,char*,char*));
static void f2py_init__BLNK_(void) {
  F_FUNC_US(f2pyinit_blnk_,F2PYINIT_BLNK_)(f2py_setup__BLNK_);
}

static FortranDataDef f2py_tm2_blk_def[] = {
  {"alpha",0,{{-1}},NPY_DOUBLE},
  {"alpha1",0,{{-1}},NPY_DOUBLE},
  {"alpha2",0,{{-1}},NPY_DOUBLE},
  {"alpha3",0,{{-1}},NPY_DOUBLE},
  {"alpha4",0,{{-1}},NPY_DOUBLE},
  {"arc",0,{{-1}},NPY_DOUBLE},
  {"brc",0,{{-1}},NPY_DOUBLE},
  {"cdrc",0,{{-1}},NPY_DOUBLE},
  {"delta",0,{{-1}},NPY_DOUBLE},
  {"eigv",0,{{-1}},NPY_DOUBLE},
  {"rc1",0,{{-1}},NPY_DOUBLE},
  {"rc2",0,{{-1}},NPY_DOUBLE},
  {"rc3",0,{{-1}},NPY_DOUBLE},
  {"rc4",0,{{-1}},NPY_DOUBLE},
  {"rc5",0,{{-1}},NPY_DOUBLE},
  {"rc6",0,{{-1}},NPY_DOUBLE},
  {"rc7",0,{{-1}},NPY_DOUBLE},
  {"rc8",0,{{-1}},NPY_DOUBLE},
  {"vap",0,{{-1}},NPY_DOUBLE},
  {"vapp",0,{{-1}},NPY_DOUBLE},
  {"vrc",0,{{-1}},NPY_DOUBLE},
  {"jrc",0,{{-1}},NPY_INT},
  {"lp",0,{{-1}},NPY_INT},
  {"ar",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_tm2_blk(char *alpha,char *alpha1,char *alpha2,char *alpha3,char *alpha4,char *arc,char *brc,char *cdrc,char *delta,char *eigv,char *rc1,char *rc2,char *rc3,char *rc4,char *rc5,char *rc6,char *rc7,char *rc8,char *vap,char *vapp,char *vrc,char *jrc,char *lp,char *ar) {
  int i_f2py=0;
  f2py_tm2_blk_def[i_f2py++].data = alpha;
  f2py_tm2_blk_def[i_f2py++].data = alpha1;
  f2py_tm2_blk_def[i_f2py++].data = alpha2;
  f2py_tm2_blk_def[i_f2py++].data = alpha3;
  f2py_tm2_blk_def[i_f2py++].data = alpha4;
  f2py_tm2_blk_def[i_f2py++].data = arc;
  f2py_tm2_blk_def[i_f2py++].data = brc;
  f2py_tm2_blk_def[i_f2py++].data = cdrc;
  f2py_tm2_blk_def[i_f2py++].data = delta;
  f2py_tm2_blk_def[i_f2py++].data = eigv;
  f2py_tm2_blk_def[i_f2py++].data = rc1;
  f2py_tm2_blk_def[i_f2py++].data = rc2;
  f2py_tm2_blk_def[i_f2py++].data = rc3;
  f2py_tm2_blk_def[i_f2py++].data = rc4;
  f2py_tm2_blk_def[i_f2py++].data = rc5;
  f2py_tm2_blk_def[i_f2py++].data = rc6;
  f2py_tm2_blk_def[i_f2py++].data = rc7;
  f2py_tm2_blk_def[i_f2py++].data = rc8;
  f2py_tm2_blk_def[i_f2py++].data = vap;
  f2py_tm2_blk_def[i_f2py++].data = vapp;
  f2py_tm2_blk_def[i_f2py++].data = vrc;
  f2py_tm2_blk_def[i_f2py++].data = jrc;
  f2py_tm2_blk_def[i_f2py++].data = lp;
  f2py_tm2_blk_def[i_f2py++].data = ar;
}
extern void F_FUNC_US(f2pyinittm2_blk,F2PYINITTM2_BLK)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_tm2_blk(void) {
  F_FUNC_US(f2pyinittm2_blk,F2PYINITTM2_BLK)(f2py_setup_tm2_blk);
}

static FortranDataDef f2py_rcompat_def[] = {
  {"aa_def",0,{{-1}},NPY_DOUBLE},
  {"bb_def",0,{{-1}},NPY_DOUBLE},
  {"rmax_def",0,{{-1}},NPY_DOUBLE},
  {"ecuts",0,{{-1}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_rcompat(char *aa_def,char *bb_def,char *rmax_def,char *ecuts) {
  int i_f2py=0;
  f2py_rcompat_def[i_f2py++].data = aa_def;
  f2py_rcompat_def[i_f2py++].data = bb_def;
  f2py_rcompat_def[i_f2py++].data = rmax_def;
  f2py_rcompat_def[i_f2py++].data = ecuts;
}
extern void F_FUNC(f2pyinitrcompat,F2PYINITRCOMPAT)(void(*)(char*,char*,char*,char*));
static void f2py_init_rcompat(void) {
  F_FUNC(f2pyinitrcompat,F2PYINITRCOMPAT)(f2py_setup_rcompat);
}

static FortranDataDef f2py_lcompat_def[] = {
  {"use_excorr",0,{{-1}},NPY_INT},
  {"use_old_cc",0,{{-1}},NPY_INT},
  {"use_new_cc",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_lcompat(char *use_excorr,char *use_old_cc,char *use_new_cc) {
  int i_f2py=0;
  f2py_lcompat_def[i_f2py++].data = use_excorr;
  f2py_lcompat_def[i_f2py++].data = use_old_cc;
  f2py_lcompat_def[i_f2py++].data = use_new_cc;
}
extern void F_FUNC(f2pyinitlcompat,F2PYINITLCOMPAT)(void(*)(char*,char*,char*));
static void f2py_init_lcompat(void) {
  F_FUNC(f2pyinitlcompat,F2PYINITLCOMPAT)(f2py_setup_lcompat);
}

static FortranDataDef f2py_plot_def[] = {
  {"a",1,{{1500}},NPY_DOUBLE},
  {"b",1,{{1500}},NPY_DOUBLE},
  {"c",1,{{1500}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_plot(char *a,char *b,char *c) {
  int i_f2py=0;
  f2py_plot_def[i_f2py++].data = a;
  f2py_plot_def[i_f2py++].data = b;
  f2py_plot_def[i_f2py++].data = c;
}
extern void F_FUNC(f2pyinitplot,F2PYINITPLOT)(void(*)(char*,char*,char*));
static void f2py_init_plot(void) {
  F_FUNC(f2pyinitplot,F2PYINITPLOT)(f2py_setup_plot);
}

static FortranDataDef f2py_nonlinear_def[] = {
  {"arc",0,{{-1}},NPY_DOUBLE},
  {"brc",0,{{-1}},NPY_DOUBLE},
  {"eigv",0,{{-1}},NPY_DOUBLE},
  {"cdrc",0,{{-1}},NPY_DOUBLE},
  {"vrc",0,{{-1}},NPY_DOUBLE},
  {"vap",0,{{-1}},NPY_DOUBLE},
  {"vapp",0,{{-1}},NPY_DOUBLE},
  {"rc1",0,{{-1}},NPY_DOUBLE},
  {"rc2",0,{{-1}},NPY_DOUBLE},
  {"rc3",0,{{-1}},NPY_DOUBLE},
  {"lp",0,{{-1}},NPY_INT},
  {"jrc",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_nonlinear(char *arc,char *brc,char *eigv,char *cdrc,char *vrc,char *vap,char *vapp,char *rc1,char *rc2,char *rc3,char *lp,char *jrc) {
  int i_f2py=0;
  f2py_nonlinear_def[i_f2py++].data = arc;
  f2py_nonlinear_def[i_f2py++].data = brc;
  f2py_nonlinear_def[i_f2py++].data = eigv;
  f2py_nonlinear_def[i_f2py++].data = cdrc;
  f2py_nonlinear_def[i_f2py++].data = vrc;
  f2py_nonlinear_def[i_f2py++].data = vap;
  f2py_nonlinear_def[i_f2py++].data = vapp;
  f2py_nonlinear_def[i_f2py++].data = rc1;
  f2py_nonlinear_def[i_f2py++].data = rc2;
  f2py_nonlinear_def[i_f2py++].data = rc3;
  f2py_nonlinear_def[i_f2py++].data = lp;
  f2py_nonlinear_def[i_f2py++].data = jrc;
}
extern void F_FUNC(f2pyinitnonlinear,F2PYINITNONLINEAR)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_nonlinear(void) {
  F_FUNC(f2pyinitnonlinear,F2PYINITNONLINEAR)(f2py_setup_nonlinear);
}

static FortranDataDef f2py_coeffs_def[] = {
  {"alpha",0,{{-1}},NPY_DOUBLE},
  {"alpha1",0,{{-1}},NPY_DOUBLE},
  {"alpha2",0,{{-1}},NPY_DOUBLE},
  {"alpha3",0,{{-1}},NPY_DOUBLE},
  {"alpha4",0,{{-1}},NPY_DOUBLE},
  {"delta",0,{{-1}},NPY_DOUBLE},
  {"gamma",0,{{-1}},NPY_DOUBLE},
  {"ang_moment",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_coeffs(char *alpha,char *alpha1,char *alpha2,char *alpha3,char *alpha4,char *delta,char *gamma,char *ang_moment) {
  int i_f2py=0;
  f2py_coeffs_def[i_f2py++].data = alpha;
  f2py_coeffs_def[i_f2py++].data = alpha1;
  f2py_coeffs_def[i_f2py++].data = alpha2;
  f2py_coeffs_def[i_f2py++].data = alpha3;
  f2py_coeffs_def[i_f2py++].data = alpha4;
  f2py_coeffs_def[i_f2py++].data = delta;
  f2py_coeffs_def[i_f2py++].data = gamma;
  f2py_coeffs_def[i_f2py++].data = ang_moment;
}
extern void F_FUNC(f2pyinitcoeffs,F2PYINITCOEFFS)(void(*)(char*,char*,char*,char*,char*,char*,char*,char*));
static void f2py_init_coeffs(void) {
  F_FUNC(f2pyinitcoeffs,F2PYINITCOEFFS)(f2py_setup_coeffs);
}

static FortranDataDef f2py_linear_def[] = {
  {"alin",2,{{5,5}},NPY_DOUBLE},
  {"parity",0,{{-1}},NPY_DOUBLE},
  {"indx",1,{{5}},NPY_INT},
  {NULL}
};
static void f2py_setup_linear(char *alin,char *parity,char *indx) {
  int i_f2py=0;
  f2py_linear_def[i_f2py++].data = alin;
  f2py_linear_def[i_f2py++].data = parity;
  f2py_linear_def[i_f2py++].data = indx;
}
extern void F_FUNC(f2pyinitlinear,F2PYINITLINEAR)(void(*)(char*,char*,char*));
static void f2py_init_linear(void) {
  F_FUNC(f2pyinitlinear,F2PYINITLINEAR)(f2py_setup_linear);
}

static FortranDataDef f2py_input_s_def[] = {
  {"aa",0,{{-1}},NPY_DOUBLE},
  {"bb",0,{{-1}},NPY_DOUBLE},
  {"zion",0,{{-1}},NPY_DOUBLE},
  {"nval",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_input_s(char *aa,char *bb,char *zion,char *nval) {
  int i_f2py=0;
  f2py_input_s_def[i_f2py++].data = aa;
  f2py_input_s_def[i_f2py++].data = bb;
  f2py_input_s_def[i_f2py++].data = zion;
  f2py_input_s_def[i_f2py++].data = nval;
}
extern void F_FUNC_US(f2pyinitinput_s,F2PYINITINPUT_S)(void(*)(char*,char*,char*,char*));
static void f2py_init_input_s(void) {
  F_FUNC_US(f2pyinitinput_s,F2PYINITINPUT_S)(f2py_setup_input_s);
}

static FortranDataDef f2py_input_chr_def[] = {
  {"ray",2,{{5,10}},NPY_STRING},
  {"title",2,{{5,10}},NPY_STRING},
  {NULL}
};
static void f2py_setup_input_chr(char *ray,char *title) {
  int i_f2py=0;
  f2py_input_chr_def[i_f2py++].data = ray;
  f2py_input_chr_def[i_f2py++].data = title;
}
extern void F_FUNC_US(f2pyinitinput_chr,F2PYINITINPUT_CHR)(void(*)(char*,char*));
static void f2py_init_input_chr(void) {
  F_FUNC_US(f2pyinitinput_chr,F2PYINITINPUT_CHR)(f2py_setup_input_chr);
}

static FortranDataDef f2py_fordes_def[] = {
  {"form_spec",1,{{200}},NPY_STRING},
  {"form_length",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_fordes(char *form_spec,char *form_length) {
  int i_f2py=0;
  f2py_fordes_def[i_f2py++].data = form_spec;
  f2py_fordes_def[i_f2py++].data = form_length;
}
extern void F_FUNC(f2pyinitfordes,F2PYINITFORDES)(void(*)(char*,char*));
static void f2py_init_fordes(void) {
  F_FUNC(f2pyinitfordes,F2PYINITFORDES)(f2py_setup_fordes);
}

static FortranDataDef f2py_ode_blk_def[] = {
  {"energ",0,{{-1}},NPY_DOUBLE},
  {"v",1,{{1500}},NPY_DOUBLE},
  {"jint",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_ode_blk(char *energ,char *v,char *jint) {
  int i_f2py=0;
  f2py_ode_blk_def[i_f2py++].data = energ;
  f2py_ode_blk_def[i_f2py++].data = v;
  f2py_ode_blk_def[i_f2py++].data = jint;
}
extern void F_FUNC_US(f2pyinitode_blk,F2PYINITODE_BLK)(void(*)(char*,char*,char*));
static void f2py_init_ode_blk(void) {
  F_FUNC_US(f2pyinitode_blk,F2PYINITODE_BLK)(f2py_setup_ode_blk);
}

static FortranDataDef f2py_path_def[] = {
  {"kmax",0,{{-1}},NPY_INT},
  {"kount",0,{{-1}},NPY_INT},
  {"dxsav",0,{{-1}},NPY_DOUBLE},
  {"xp",1,{{200}},NPY_DOUBLE},
  {"yp",2,{{10,200}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_path(char *kmax,char *kount,char *dxsav,char *xp,char *yp) {
  int i_f2py=0;
  f2py_path_def[i_f2py++].data = kmax;
  f2py_path_def[i_f2py++].data = kount;
  f2py_path_def[i_f2py++].data = dxsav;
  f2py_path_def[i_f2py++].data = xp;
  f2py_path_def[i_f2py++].data = yp;
}
extern void F_FUNC(f2pyinitpath,F2PYINITPATH)(void(*)(char*,char*,char*,char*,char*));
static void f2py_init_path(void) {
  F_FUNC(f2pyinitpath,F2PYINITPATH)(f2py_setup_path);
}

static FortranDataDef f2py_divcof_def[] = {
  {"arg",1,{{11}},NPY_DOUBLE},
  {"val",1,{{11}},NPY_DOUBLE},
  {"cof",1,{{11}},NPY_DOUBLE},
  {NULL}
};
static void f2py_setup_divcof(char *arg,char *val,char *cof) {
  int i_f2py=0;
  f2py_divcof_def[i_f2py++].data = arg;
  f2py_divcof_def[i_f2py++].data = val;
  f2py_divcof_def[i_f2py++].data = cof;
}
extern void F_FUNC(f2pyinitdivcof,F2PYINITDIVCOF)(void(*)(char*,char*,char*));
static void f2py_init_divcof(void) {
  F_FUNC(f2pyinitdivcof,F2PYINITDIVCOF)(f2py_setup_divcof);
}

static FortranDataDef f2py_divint_def[] = {
  {"mm",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_divint(char *mm) {
  int i_f2py=0;
  f2py_divint_def[i_f2py++].data = mm;
}
extern void F_FUNC(f2pyinitdivint,F2PYINITDIVINT)(void(*)(char*));
static void f2py_init_divint(void) {
  F_FUNC(f2pyinitdivint,F2PYINITDIVINT)(f2py_setup_divint);
}

static FortranDataDef f2py_set_num_def[] = {
  {"el_val",1,{{50}},NPY_DOUBLE},
  {"nels",0,{{-1}},NPY_INT},
  {NULL}
};
static void f2py_setup_set_num(char *el_val,char *nels) {
  int i_f2py=0;
  f2py_set_num_def[i_f2py++].data = el_val;
  f2py_set_num_def[i_f2py++].data = nels;
}
extern void F_FUNC_US(f2pyinitset_num,F2PYINITSET_NUM)(void(*)(char*,char*));
static void f2py_init_set_num(void) {
  F_FUNC_US(f2pyinitset_num,F2PYINITSET_NUM)(f2py_setup_set_num);
}

static FortranDataDef f2py_set_chr_def[] = {
  {"el_name",2,{{50,30}},NPY_STRING},
  {NULL}
};
static void f2py_setup_set_chr(char *el_name) {
  int i_f2py=0;
  f2py_set_chr_def[i_f2py++].data = el_name;
}
extern void F_FUNC_US(f2pyinitset_chr,F2PYINITSET_CHR)(void(*)(char*));
static void f2py_init_set_chr(void) {
  F_FUNC_US(f2pyinitset_chr,F2PYINITSET_CHR)(f2py_setup_set_chr);
}

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"run",-1,{{-1}},0,(char *)F_FUNC(run,RUN),(f2py_init_func)f2py_rout_atomic_program_run,doc_f2py_rout_atomic_program_run},
  {"nucl_z",-1,{{-1}},0,(char *)F_WRAPPEDFUNC_US(nucl_z,NUCL_Z),(f2py_init_func)f2py_rout_atomic_program_nucl_z,doc_f2py_rout_atomic_program_nucl_z},
  {"difnrl",-1,{{-1}},0,(char *)F_FUNC(difnrl,DIFNRL),(f2py_init_func)f2py_rout_atomic_program_difnrl,doc_f2py_rout_atomic_program_difnrl},
  {"difrel",-1,{{-1}},0,(char *)F_FUNC(difrel,DIFREL),(f2py_init_func)f2py_rout_atomic_program_difrel,doc_f2py_rout_atomic_program_difrel},
  {"dmixp",-1,{{-1}},0,(char *)F_FUNC(dmixp,DMIXP),(f2py_init_func)f2py_rout_atomic_program_dmixp,doc_f2py_rout_atomic_program_dmixp},
  {"dsolv1",-1,{{-1}},0,(char *)F_FUNC(dsolv1,DSOLV1),(f2py_init_func)f2py_rout_atomic_program_dsolv1,doc_f2py_rout_atomic_program_dsolv1},
  {"pseudo",-1,{{-1}},0,(char *)F_FUNC(pseudo,PSEUDO),(f2py_init_func)f2py_rout_atomic_program_pseudo,doc_f2py_rout_atomic_program_pseudo},
  {"wf",-1,{{-1}},0,(char *)F_FUNC(wf,WF),(f2py_init_func)f2py_rout_atomic_program_wf,doc_f2py_rout_atomic_program_wf},
  {"hsc",-1,{{-1}},0,(char *)F_FUNC(hsc,HSC),(f2py_init_func)f2py_rout_atomic_program_hsc,doc_f2py_rout_atomic_program_hsc},
  {"excorr",-1,{{-1}},0,(char *)F_FUNC(excorr,EXCORR),(f2py_init_func)f2py_rout_atomic_program_excorr,doc_f2py_rout_atomic_program_excorr},
  {"tm2",-1,{{-1}},0,(char *)F_FUNC(tm2,TM2),(f2py_init_func)f2py_rout_atomic_program_tm2,doc_f2py_rout_atomic_program_tm2},
  {"ker",-1,{{-1}},0,(char *)F_FUNC(ker,KER),(f2py_init_func)f2py_rout_atomic_program_ker,doc_f2py_rout_atomic_program_ker},
  {"wrapup",-1,{{-1}},0,(char *)F_FUNC(wrapup,WRAPUP),(f2py_init_func)f2py_rout_atomic_program_wrapup,doc_f2py_rout_atomic_program_wrapup},
  {"cutoff_function",-1,{{-1}},0,(char *)F_WRAPPEDFUNC_US(cutoff_function,CUTOFF_FUNCTION),(f2py_init_func)f2py_rout_atomic_program_cutoff_function,doc_f2py_rout_atomic_program_cutoff_function},
  {"splift",-1,{{-1}},0,(char *)F_FUNC(splift,SPLIFT),(f2py_init_func)f2py_rout_atomic_program_splift,doc_f2py_rout_atomic_program_splift},
  {"spliq",-1,{{-1}},0,(char *)F_FUNC(spliq,SPLIQ),(f2py_init_func)f2py_rout_atomic_program_spliq,doc_f2py_rout_atomic_program_spliq},
  {"velect",-1,{{-1}},0,(char *)F_FUNC(velect,VELECT),(f2py_init_func)f2py_rout_atomic_program_velect,doc_f2py_rout_atomic_program_velect},
  {"vionic",-1,{{-1}},0,(char *)F_FUNC(vionic,VIONIC),(f2py_init_func)f2py_rout_atomic_program_vionic,doc_f2py_rout_atomic_program_vionic},
  {"wtrans",-1,{{-1}},0,(char *)F_FUNC(wtrans,WTRANS),(f2py_init_func)f2py_rout_atomic_program_wtrans,doc_f2py_rout_atomic_program_wtrans},
  {"v0pp",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(v0pp,V0PP),(f2py_init_func)f2py_rout_atomic_program_v0pp,doc_f2py_rout_atomic_program_v0pp},
  {"chg_mism",-1,{{-1}},0,(char *)F_WRAPPEDFUNC_US(chg_mism,CHG_MISM),(f2py_init_func)f2py_rout_atomic_program_chg_mism,doc_f2py_rout_atomic_program_chg_mism},
  {"dsolv2",-1,{{-1}},0,(char *)F_FUNC(dsolv2,DSOLV2),(f2py_init_func)f2py_rout_atomic_program_dsolv2,doc_f2py_rout_atomic_program_dsolv2},
  {"etotal",-1,{{-1}},0,(char *)F_FUNC(etotal,ETOTAL),(f2py_init_func)f2py_rout_atomic_program_etotal,doc_f2py_rout_atomic_program_etotal},
  {"ext",-1,{{-1}},0,(char *)F_FUNC(ext,EXT),(f2py_init_func)f2py_rout_atomic_program_ext,doc_f2py_rout_atomic_program_ext},
  {"input",-1,{{-1}},0,(char *)F_FUNC(input,INPUT),(f2py_init_func)f2py_rout_atomic_program_input,doc_f2py_rout_atomic_program_input},
  {"header",-1,{{-1}},0,(char *)F_FUNC(header,HEADER),(f2py_init_func)f2py_rout_atomic_program_header,doc_f2py_rout_atomic_program_header},
  {"orban",-1,{{-1}},0,(char *)F_FUNC(orban,ORBAN),(f2py_init_func)f2py_rout_atomic_program_orban,doc_f2py_rout_atomic_program_orban},
  {"potran",-1,{{-1}},0,(char *)F_FUNC(potran,POTRAN),(f2py_init_func)f2py_rout_atomic_program_potran,doc_f2py_rout_atomic_program_potran},
  {"potrv",-1,{{-1}},0,(char *)F_FUNC(potrv,POTRV),(f2py_init_func)f2py_rout_atomic_program_potrv,doc_f2py_rout_atomic_program_potrv},
  {"potrvs",-1,{{-1}},0,(char *)F_FUNC(potrvs,POTRVS),(f2py_init_func)f2py_rout_atomic_program_potrvs,doc_f2py_rout_atomic_program_potrvs},
  {"totalw",-1,{{-1}},0,(char *)F_FUNC(totalw,TOTALW),(f2py_init_func)f2py_rout_atomic_program_totalw,doc_f2py_rout_atomic_program_totalw},
  {"potrw",-1,{{-1}},0,(char *)F_FUNC(potrw,POTRW),(f2py_init_func)f2py_rout_atomic_program_potrw,doc_f2py_rout_atomic_program_potrw},
  {"prdiff",-1,{{-1}},0,(char *)F_FUNC(prdiff,PRDIFF),(f2py_init_func)f2py_rout_atomic_program_prdiff,doc_f2py_rout_atomic_program_prdiff},
  {"chrlen",-1,{{-1}},0,(char *)F_FUNC(chrlen,CHRLEN),(f2py_init_func)f2py_rout_atomic_program_chrlen,doc_f2py_rout_atomic_program_chrlen},
  {"chrcap",-1,{{-1}},0,(char *)F_FUNC(chrcap,CHRCAP),(f2py_init_func)f2py_rout_atomic_program_chrcap,doc_f2py_rout_atomic_program_chrcap},
  {"leqi",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(leqi,LEQI),(f2py_init_func)f2py_rout_atomic_program_leqi,doc_f2py_rout_atomic_program_leqi},
  {"loc_des",-1,{{-1}},0,(char *)F_FUNC_US(loc_des,LOC_DES),(f2py_init_func)f2py_rout_atomic_program_loc_des,doc_f2py_rout_atomic_program_loc_des},
  {"zbrac",-1,{{-1}},0,(char *)F_FUNC(zbrac,ZBRAC),(f2py_init_func)f2py_rout_atomic_program_zbrac,doc_f2py_rout_atomic_program_zbrac},
  {"zbrak",-1,{{-1}},0,(char *)F_FUNC(zbrak,ZBRAK),(f2py_init_func)f2py_rout_atomic_program_zbrak,doc_f2py_rout_atomic_program_zbrak},
  {"zbrent",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(zbrent,ZBRENT),(f2py_init_func)f2py_rout_atomic_program_zbrent,doc_f2py_rout_atomic_program_zbrent},
  {"rtbis",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(rtbis,RTBIS),(f2py_init_func)f2py_rout_atomic_program_rtbis,doc_f2py_rout_atomic_program_rtbis},
  {"brac",-1,{{-1}},0,(char *)F_FUNC(brac,BRAC),(f2py_init_func)f2py_rout_atomic_program_brac,doc_f2py_rout_atomic_program_brac},
  {"brent",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(brent,BRENT),(f2py_init_func)f2py_rout_atomic_program_brent,doc_f2py_rout_atomic_program_brent},
  {"genrhs",-1,{{-1}},0,(char *)F_FUNC(genrhs,GENRHS),(f2py_init_func)f2py_rout_atomic_program_genrhs,doc_f2py_rout_atomic_program_genrhs},
  {"logder",-1,{{-1}},0,(char *)F_FUNC(logder,LOGDER),(f2py_init_func)f2py_rout_atomic_program_logder,doc_f2py_rout_atomic_program_logder},
  {"ode",-1,{{-1}},0,(char *)F_FUNC(ode,ODE),(f2py_init_func)f2py_rout_atomic_program_ode,doc_f2py_rout_atomic_program_ode},
  {"denplot",-1,{{-1}},0,(char *)F_FUNC(denplot,DENPLOT),(f2py_init_func)f2py_rout_atomic_program_denplot,doc_f2py_rout_atomic_program_denplot},
  {"saxpy",-1,{{-1}},0,(char *)F_FUNC(saxpy,SAXPY),(f2py_init_func)f2py_rout_atomic_program_saxpy,doc_f2py_rout_atomic_program_saxpy},
  {"sdot",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(sdot,SDOT),(f2py_init_func)f2py_rout_atomic_program_sdot,doc_f2py_rout_atomic_program_sdot},
  {"scopy",-1,{{-1}},0,(char *)F_FUNC(scopy,SCOPY),(f2py_init_func)f2py_rout_atomic_program_scopy,doc_f2py_rout_atomic_program_scopy},
  {"sscal",-1,{{-1}},0,(char *)F_FUNC(sscal,SSCAL),(f2py_init_func)f2py_rout_atomic_program_sscal,doc_f2py_rout_atomic_program_sscal},
  {"tridib",-1,{{-1}},0,(char *)F_FUNC(tridib,TRIDIB),(f2py_init_func)f2py_rout_atomic_program_tridib,doc_f2py_rout_atomic_program_tridib},
  {"tinvit",-1,{{-1}},0,(char *)F_FUNC(tinvit,TINVIT),(f2py_init_func)f2py_rout_atomic_program_tinvit,doc_f2py_rout_atomic_program_tinvit},
  {"sgeco",-1,{{-1}},0,(char *)F_FUNC(sgeco,SGECO),(f2py_init_func)f2py_rout_atomic_program_sgeco,doc_f2py_rout_atomic_program_sgeco},
  {"epslon",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(epslon,EPSLON),(f2py_init_func)f2py_rout_atomic_program_epslon,doc_f2py_rout_atomic_program_epslon},
  {"pythag",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(pythag,PYTHAG),(f2py_init_func)f2py_rout_atomic_program_pythag,doc_f2py_rout_atomic_program_pythag},
  {"sasum",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(sasum,SASUM),(f2py_init_func)f2py_rout_atomic_program_sasum,doc_f2py_rout_atomic_program_sasum},
  {"sgefa",-1,{{-1}},0,(char *)F_FUNC(sgefa,SGEFA),(f2py_init_func)f2py_rout_atomic_program_sgefa,doc_f2py_rout_atomic_program_sgefa},
  {"isamax",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(isamax,ISAMAX),(f2py_init_func)f2py_rout_atomic_program_isamax,doc_f2py_rout_atomic_program_isamax},
  {"sgesl",-1,{{-1}},0,(char *)F_FUNC(sgesl,SGESL),(f2py_init_func)f2py_rout_atomic_program_sgesl,doc_f2py_rout_atomic_program_sgesl},
  {"isrchfgt",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(isrchfgt,ISRCHFGT),(f2py_init_func)f2py_rout_atomic_program_isrchfgt,doc_f2py_rout_atomic_program_isrchfgt},
  {"hunt",-1,{{-1}},0,(char *)F_FUNC(hunt,HUNT),(f2py_init_func)f2py_rout_atomic_program_hunt,doc_f2py_rout_atomic_program_hunt},
  {"locate",-1,{{-1}},0,(char *)F_FUNC(locate,LOCATE),(f2py_init_func)f2py_rout_atomic_program_locate,doc_f2py_rout_atomic_program_locate},
  {"odeint",-1,{{-1}},0,(char *)F_FUNC(odeint,ODEINT),(f2py_init_func)f2py_rout_atomic_program_odeint,doc_f2py_rout_atomic_program_odeint},
  {"polint",-1,{{-1}},0,(char *)F_FUNC(polint,POLINT),(f2py_init_func)f2py_rout_atomic_program_polint,doc_f2py_rout_atomic_program_polint},
  {"rkqc",-1,{{-1}},0,(char *)F_FUNC(rkqc,RKQC),(f2py_init_func)f2py_rout_atomic_program_rkqc,doc_f2py_rout_atomic_program_rkqc},
  {"rk4",-1,{{-1}},0,(char *)F_FUNC(rk4,RK4),(f2py_init_func)f2py_rout_atomic_program_rk4,doc_f2py_rout_atomic_program_rk4},
  {"compat_params",-1,{{-1}},0,(char *)F_FUNC_US(compat_params,COMPAT_PARAMS),(f2py_init_func)f2py_rout_atomic_program_compat_params,doc_f2py_rout_atomic_program_compat_params},
  {"pcc_exp",-1,{{-1}},0,(char *)F_FUNC_US(pcc_exp,PCC_EXP),(f2py_init_func)f2py_rout_atomic_program_pcc_exp,doc_f2py_rout_atomic_program_pcc_exp},
  {"change_valence",-1,{{-1}},0,(char *)F_FUNC_US(change_valence,CHANGE_VALENCE),(f2py_init_func)f2py_rout_atomic_program_change_valence,doc_f2py_rout_atomic_program_change_valence},
  {"coreq",-1,{{-1}},0,(char *)F_FUNC(coreq,COREQ),(f2py_init_func)f2py_rout_atomic_program_coreq,doc_f2py_rout_atomic_program_coreq},
  {"get_unit",-1,{{-1}},0,(char *)F_FUNC_US(get_unit,GET_UNIT),(f2py_init_func)f2py_rout_atomic_program_get_unit,doc_f2py_rout_atomic_program_get_unit},
  {"gauleg",-1,{{-1}},0,(char *)F_FUNC(gauleg,GAULEG),(f2py_init_func)f2py_rout_atomic_program_gauleg,doc_f2py_rout_atomic_program_gauleg},
  {"divdif",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(divdif,DIVDIF),(f2py_init_func)f2py_rout_atomic_program_divdif,doc_f2py_rout_atomic_program_divdif},
  {"check_directives",-1,{{-1}},0,(char *)F_FUNC_US(check_directives,CHECK_DIRECTIVES),(f2py_init_func)f2py_rout_atomic_program_check_directives,doc_f2py_rout_atomic_program_check_directives},
  {"getline",-1,{{-1}},0,(char *)F_FUNC(getline,GETLINE),(f2py_init_func)f2py_rout_atomic_program_getline,doc_f2py_rout_atomic_program_getline},
  {"directive",-1,{{-1}},0,(char *)F_FUNC(directive,DIRECTIVE),(f2py_init_func)f2py_rout_atomic_program_directive,doc_f2py_rout_atomic_program_directive},
  {"defined",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(defined,DEFINED),(f2py_init_func)f2py_rout_atomic_program_defined,doc_f2py_rout_atomic_program_defined},
  {"insert",-1,{{-1}},0,(char *)F_FUNC(insert,INSERT),(f2py_init_func)f2py_rout_atomic_program_insert,doc_f2py_rout_atomic_program_insert},
  {"put_pair",-1,{{-1}},0,(char *)F_WRAPPEDFUNC_US(put_pair,PUT_PAIR),(f2py_init_func)f2py_rout_atomic_program_put_pair,doc_f2py_rout_atomic_program_put_pair},
  {"set_value",-1,{{-1}},0,(char *)F_WRAPPEDFUNC_US(set_value,SET_VALUE),(f2py_init_func)f2py_rout_atomic_program_set_value,doc_f2py_rout_atomic_program_set_value},
  {"get_real",-1,{{-1}},0,(char *)F_FUNC_US(get_real,GET_REAL),(f2py_init_func)f2py_rout_atomic_program_get_real,doc_f2py_rout_atomic_program_get_real},
  {"print_pairs",-1,{{-1}},0,(char *)F_FUNC_US(print_pairs,PRINT_PAIRS),(f2py_init_func)f2py_rout_atomic_program_print_pairs,doc_f2py_rout_atomic_program_print_pairs},
  {"prversion",-1,{{-1}},0,(char *)F_FUNC(prversion,PRVERSION),(f2py_init_func)f2py_rout_atomic_program_prversion,doc_f2py_rout_atomic_program_prversion},
  {"atomxc",-1,{{-1}},0,(char *)F_FUNC(atomxc,ATOMXC),(f2py_init_func)f2py_rout_atomic_program_atomxc,doc_f2py_rout_atomic_program_atomxc},
  {"exchng",-1,{{-1}},0,(char *)F_FUNC(exchng,EXCHNG),(f2py_init_func)f2py_rout_atomic_program_exchng,doc_f2py_rout_atomic_program_exchng},
  {"ggaxc",-1,{{-1}},0,(char *)F_FUNC(ggaxc,GGAXC),(f2py_init_func)f2py_rout_atomic_program_ggaxc,doc_f2py_rout_atomic_program_ggaxc},
  {"ldaxc",-1,{{-1}},0,(char *)F_FUNC(ldaxc,LDAXC),(f2py_init_func)f2py_rout_atomic_program_ldaxc,doc_f2py_rout_atomic_program_ldaxc},
  {"pbexc",-1,{{-1}},0,(char *)F_FUNC(pbexc,PBEXC),(f2py_init_func)f2py_rout_atomic_program_pbexc,doc_f2py_rout_atomic_program_pbexc},
  {"pw91xc",-1,{{-1}},0,(char *)F_FUNC(pw91xc,PW91XC),(f2py_init_func)f2py_rout_atomic_program_pw91xc,doc_f2py_rout_atomic_program_pw91xc},
  {"pw92c",-1,{{-1}},0,(char *)F_FUNC(pw92c,PW92C),(f2py_init_func)f2py_rout_atomic_program_pw92c,doc_f2py_rout_atomic_program_pw92c},
  {"pw92xc",-1,{{-1}},0,(char *)F_FUNC(pw92xc,PW92XC),(f2py_init_func)f2py_rout_atomic_program_pw92xc,doc_f2py_rout_atomic_program_pw92xc},
  {"pzxc",-1,{{-1}},0,(char *)F_FUNC(pzxc,PZXC),(f2py_init_func)f2py_rout_atomic_program_pzxc,doc_f2py_rout_atomic_program_pzxc},
  {"blypxc",-1,{{-1}},0,(char *)F_FUNC(blypxc,BLYPXC),(f2py_init_func)f2py_rout_atomic_program_blypxc,doc_f2py_rout_atomic_program_blypxc},
  {"rpbexc",-1,{{-1}},0,(char *)F_FUNC(rpbexc,RPBEXC),(f2py_init_func)f2py_rout_atomic_program_rpbexc,doc_f2py_rout_atomic_program_rpbexc},
  {"revpbexc",-1,{{-1}},0,(char *)F_FUNC(revpbexc,REVPBEXC),(f2py_init_func)f2py_rout_atomic_program_revpbexc,doc_f2py_rout_atomic_program_revpbexc},
  {"cal_date",-1,{{-1}},0,(char *)F_FUNC_US(cal_date,CAL_DATE),(f2py_init_func)f2py_rout_atomic_program_cal_date,doc_f2py_rout_atomic_program_cal_date},
  {"second",-1,{{-1}},0,(char *)F_WRAPPEDFUNC(second,SECOND),(f2py_init_func)f2py_rout_atomic_program_second,doc_f2py_rout_atomic_program_second},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "atomic_program",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit_atomic_program(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = atomic_program_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module atomic_program (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module 'atomic_program' is auto-generated with f2py (version:2).\nFunctions:\n"
"  run()\n"
"  nucl_z = nucl_z(name)\n"
"  difnrl(iter,iorb,v,ar,br,n,l,spin,eigv,iflag)\n"
"  difrel(iter,iorb,v,ar,br,n,l,spin,eigv)\n"
"  dmixp(a,b,beta,icy,id,nmsh,c,d,vn1,vn12,vn2,vn22)\n"
"  dsolv1(nfirst,nlast,nn)\n"
"  pseudo(pot_id,headline,ps_generator,ps_generator_extra_args=())\n"
"  wf(i,ar,br)\n"
"  hsc(i,ar,br)\n"
"  excorr(id,cdd,cdu,cdc,vod,vou,vxc,vc,exc,ec)\n"
"  tm2(i,wfr,br)\n"
"  ker(i,ar,br)\n"
"  wrapup(pot_id)\n"
"  cutoff_function = cutoff_function(r)\n"
"  splift(x,y,yp,ypp,w,ierr,isx,a1,b1,an,bn,n=len(x))\n"
"  spliq(x,y,yp,ypp,xlo,xup,ans,ierr,n=len(x),nup=len(xup))\n"
"  velect(iter,iconv,id,zelec)\n"
"  vionic()\n"
"  wtrans(vd,r,i,ist,nr=len(vd))\n"
"  v0pp = v0pp(gamma)\n"
"  chg_mism = chg_mism(xdelta)\n"
"  dsolv2(iter,iconv,id,nfirst,nlast,n_of_core_orbs,nn)\n"
"  etotal(nfirst,nlast)\n"
"  ext(i)\n"
"  input(maxit)\n"
"  header()\n"
"  orban(iorb,id,ar,br,n,l,occup,spin,eigv,ekin,epot)\n"
"  potran(i,vd,r,zion,fourier_area,nr=len(vd))\n"
"  potrv(vd,r,k,zion,nr=len(vd))\n"
"  potrvs(vd,r,k,nr=len(vd))\n"
"  totalw(i)\n"
"  potrw(vd,r,k,kj,ist,rc,nr=len(vd))\n"
"  prdiff(nconf,econf,jobold)\n"
"  chrlen(string_bn,nchar,lchar)\n"
"  chrcap(string_bn,nchar)\n"
"  leqi = leqi(strng1,strng2)\n"
"  loc_des(message)\n"
"  zbrac(func,x1,x2,succes,func_extra_args=())\n"
"  zbrak(fx,x1,x2,n,xb1,xb2,nb,fx_extra_args=())\n"
"  zbrent = zbrent(func,x1,x2,tol,func_extra_args=())\n"
"  rtbis = rtbis(func,x1,x2,xacc,func_extra_args=())\n"
"  brac(func,x1,x2,succes,func_extra_args=())\n"
"  brent = brent(func,x1,x2,tol,func_extra_args=())\n"
"  genrhs(gamma,delta,y)\n"
"  logder(nfirst,nlast,flag)\n"
"  ode(x,y,dxdy)\n"
"  denplot()\n"
"  saxpy(n,sa,sx,incx,sy,incy)\n"
"  sdot = sdot(n,sx,incx,sy,incy)\n"
"  scopy(n,sx,incx,sy,incy)\n"
"  sscal(n,sa,sx,incx)\n"
"  tridib(eps1,d,e,e2,lb,ub,m11,w,ind,ierr,rv4,rv5,n=len(d),m=len(w))\n"
"  tinvit(d,e,e2,w,ind,z,ierr,rv1,rv2,rv3,rv4,rv6,nm=shape(z,0),n=len(d),m=len(w))\n"
"  sgeco(a,n,ipvt,rcond,z,lda=shape(a,0))\n"
"  epslon = epslon(x)\n"
"  pythag = pythag(a,b)\n"
"  sasum = sasum(n,sx,incx)\n"
"  sgefa(a,n,ipvt,info,lda=shape(a,0))\n"
"  isamax = isamax(n,sx,incx)\n"
"  sgesl(a,n,ipvt,b,job,lda=shape(a,0))\n"
"  isrchfgt = isrchfgt(n,array,inc,target)\n"
"  hunt(xx,x,jlo,n=len(xx))\n"
"  locate(xx,x,j,n=len(xx))\n"
"  odeint(ystart,x1,x2,eps,h1,hmin,nok,nbad,derivs,rkqc,nvar=len(ystart),derivs_extra_args=(),rkqc_extra_args=())\n"
"  polint(xa,ya,x,y,dy,n=len(xa))\n"
"  rkqc(y,dydx,n,x,htry,eps,yscal,hdid,hnext,derivs,derivs_extra_args=())\n"
"  rk4(y,dydx,x,h,yout,derivs,n=len(y),derivs_extra_args=())\n"
"  compat_params(str)\n"
"  pcc_exp(icore,ac,bc,cc,r,cdc,nr=len(r))\n"
"  change_valence()\n"
"  coreq()\n"
"  get_unit(lun)\n"
"  gauleg(x1,x2,x,w,n=len(x))\n"
"  divdif = divdif(f,x,z,m,n=len(f))\n"
"  check_directives(unit_no)\n"
"  getline(unit_no,string_bn)\n"
"  directive(str)\n"
"  defined = defined(name)\n"
"  insert(module,name)\n"
"  put_pair = put_pair(name,num_str)\n"
"  set_value = set_value(name,default_str)\n"
"  get_real(string_bn,value)\n"
"  print_pairs()\n"
"  prversion()\n"
"  atomxc(functl,author,irel,nr,rmesh,dens,ex,ec,dx,dc,vxc,maxr=len(rmesh),nspin=shape(dens,1))\n"
"  exchng(irel,ds,ex,vx,nsp=len(ds))\n"
"  ggaxc(author,irel,d,gd,epsx,epsc,dexdd,decdd,dexdgd,decdgd,nspin=len(d))\n"
"  ldaxc(author,irel,d,epsx,epsc,vx,vc,dvxdn,dvcdn,nspin=len(d))\n"
"  pbexc(irel,dens,gdens,ex,ec,dexdd,decdd,dexdgd,decdgd,nspin=len(dens))\n"
"  pw91xc(irel,dens,gdens,ex,ec,dexdd,decdd,dexdgd,decdgd,nspin=len(dens))\n"
"  pw92c(dens,ec,vc,nspin=len(dens))\n"
"  pw92xc(irel,dens,epsx,epsc,vx,vc,nspin=len(dens))\n"
"  pzxc(irel,ds,ex,ec,vx,vc,dvxdn,dvcdn,nsp=len(ds))\n"
"  blypxc(dens,gdens,ex,ec,dexdd,decdd,dexdgd,decdgd,nspin=len(dens))\n"
"  rpbexc(irel,dens,gdens,ex,ec,dexdd,decdd,dexdgd,decdgd,nspin=len(dens))\n"
"  revpbexc(irel,dens,gdens,ex,ec,dexdd,decdd,dexdgd,decdgd,nspin=len(dens))\n"
"  cal_date(bdate)\n"
"  second = second()\n"
"COMMON blocks:\n""  /radial/ a,b,r(1500),rab(1500)\n""  /rad_int/ nr\n""  /orbital/ so(40),zo(40)\n""  /orb_int/ norb,ncp,no(40),lo(40)\n""  /orb_char/ il(5,1)\n""  /orb_log/ down(40)\n""  /param/ scheme,job,ifcore,ncore,rsh,zel,znuc,zsh,rc(5),rc_input(5),cfac,rcfac,logder_radius,indu(5),indd(5)\n""  /par_char/ nameat(2),ispp(1),icorr(2),irel(3),nicore(4)\n""  /par_log/ normal,polarized,relativistic,is_gga\n""  /charge/ cdd(1500),cdu(1500),cdc(1500)\n""  /elecpot/ vid(1500),viu(1500),vod(1500),vou(1500)\n""  /energy/ ev(40),ep(40),ek(40),etot(10)\n""  /mixer/ vn1d(1500),vn11d(1500),vn2d(1500),vn22d(1500),vn1u(1500),vn11u(1500),vn2u(1500),vn22u(1500),wk1(1500),wk2(1500)\n""  /ion/ viod(4,1500),viou(4,1500)\n""  /_BLNK_/ rab2(1500),fa(1500),fb(1500)\n""  /tm2_blk/ alpha,alpha1,alpha2,alpha3,alpha4,arc,brc,cdrc,delta,eigv,rc1,rc2,rc3,rc4,rc5,rc6,rc7,rc8,vap,vapp,vrc,jrc,lp,ar(1500)\n""  /rcompat/ aa_def,bb_def,rmax_def,ecuts\n""  /lcompat/ use_excorr,use_old_cc,use_new_cc\n""  /plot/ a(1500),b(1500),c(1500)\n""  /nonlinear/ arc,brc,eigv,cdrc,vrc,vap,vapp,rc1,rc2,rc3,lp,jrc\n""  /coeffs/ alpha,alpha1,alpha2,alpha3,alpha4,delta,gamma,ang_moment\n""  /linear/ alin(5,5),parity,indx(5)\n""  /input_s/ aa,bb,zion,nval\n""  /input_chr/ ray(5,10),title(5,10)\n""  /fordes/ form_spec(200),form_length\n""  /ode_blk/ energ,v(1500),jint\n""  /path/ kmax,kount,dxsav,xp(200),yp(10,200)\n""  /divcof/ arg(11),val(11),cof(11)\n""  /divint/ mm\n""  /set_num/ el_val(50),nels\n""  /set_chr/ el_name(50,30)\n"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  atomic_program_error = PyErr_NewException ("atomic_program.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "_atomic_program_error", atomic_program_error);
  Py_DECREF(atomic_program_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }


    {
      extern double F_FUNC_US(nucl_z,NUCL_Z)(void);
      PyObject* o = PyDict_GetItemString(d,"nucl_z");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC_US(nucl_z,NUCL_Z),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("nucl_z");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    












    {
      extern double F_FUNC_US(cutoff_function,CUTOFF_FUNCTION)(void);
      PyObject* o = PyDict_GetItemString(d,"cutoff_function");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC_US(cutoff_function,CUTOFF_FUNCTION),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("cutoff_function");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    






    {
      extern double F_FUNC(v0pp,V0PP)(void);
      PyObject* o = PyDict_GetItemString(d,"v0pp");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(v0pp,V0PP),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("v0pp");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    

    {
      extern double F_FUNC_US(chg_mism,CHG_MISM)(void);
      PyObject* o = PyDict_GetItemString(d,"chg_mism");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC_US(chg_mism,CHG_MISM),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("chg_mism");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    















    {
      extern int F_FUNC(leqi,LEQI)(void);
      PyObject* o = PyDict_GetItemString(d,"leqi");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(leqi,LEQI),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("leqi");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    




    {
      extern double F_FUNC(zbrent,ZBRENT)(void);
      PyObject* o = PyDict_GetItemString(d,"zbrent");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(zbrent,ZBRENT),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("zbrent");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    

    {
      extern double F_FUNC(rtbis,RTBIS)(void);
      PyObject* o = PyDict_GetItemString(d,"rtbis");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(rtbis,RTBIS),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("rtbis");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    


    {
      extern double F_FUNC(brent,BRENT)(void);
      PyObject* o = PyDict_GetItemString(d,"brent");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(brent,BRENT),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("brent");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    






    {
      extern double F_FUNC(sdot,SDOT)(void);
      PyObject* o = PyDict_GetItemString(d,"sdot");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(sdot,SDOT),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("sdot");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    






    {
      extern double F_FUNC(epslon,EPSLON)(void);
      PyObject* o = PyDict_GetItemString(d,"epslon");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(epslon,EPSLON),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("epslon");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    

    {
      extern double F_FUNC(pythag,PYTHAG)(void);
      PyObject* o = PyDict_GetItemString(d,"pythag");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(pythag,PYTHAG),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("pythag");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    

    {
      extern double F_FUNC(sasum,SASUM)(void);
      PyObject* o = PyDict_GetItemString(d,"sasum");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(sasum,SASUM),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("sasum");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    


    {
      extern int F_FUNC(isamax,ISAMAX)(void);
      PyObject* o = PyDict_GetItemString(d,"isamax");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(isamax,ISAMAX),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("isamax");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    


    {
      extern int F_FUNC(isrchfgt,ISRCHFGT)(void);
      PyObject* o = PyDict_GetItemString(d,"isrchfgt");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(isrchfgt,ISRCHFGT),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("isrchfgt");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    













    {
      extern double F_FUNC(divdif,DIVDIF)(void);
      PyObject* o = PyDict_GetItemString(d,"divdif");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(divdif,DIVDIF),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("divdif");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    




    {
      extern int F_FUNC(defined,DEFINED)(void);
      PyObject* o = PyDict_GetItemString(d,"defined");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(defined,DEFINED),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("defined");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    


    {
      extern int F_FUNC_US(put_pair,PUT_PAIR)(void);
      PyObject* o = PyDict_GetItemString(d,"put_pair");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC_US(put_pair,PUT_PAIR),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("put_pair");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    

    {
      extern double F_FUNC_US(set_value,SET_VALUE)(void);
      PyObject* o = PyDict_GetItemString(d,"set_value");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC_US(set_value,SET_VALUE),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("set_value");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    

















    {
      extern double F_FUNC(second,SECOND)(void);
      PyObject* o = PyDict_GetItemString(d,"second");
      tmp = F2PyCapsule_FromVoidPtr((void*)F_FUNC(second,SECOND),NULL);
      PyObject_SetAttrString(o,"_cpointer", tmp);
      Py_DECREF(tmp);
      s = PyUnicode_FromString("second");
      PyObject_SetAttrString(o,"__name__", s);
      Py_DECREF(s);
    }
    
/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

  tmp = PyFortranObject_New(f2py_radial_def,f2py_init_radial);
  F2PyDict_SetItemString(d, "radial", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_rad_int_def,f2py_init_rad_int);
  F2PyDict_SetItemString(d, "rad_int", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_orbital_def,f2py_init_orbital);
  F2PyDict_SetItemString(d, "orbital", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_orb_int_def,f2py_init_orb_int);
  F2PyDict_SetItemString(d, "orb_int", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_orb_char_def,f2py_init_orb_char);
  F2PyDict_SetItemString(d, "orb_char", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_orb_log_def,f2py_init_orb_log);
  F2PyDict_SetItemString(d, "orb_log", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_param_def,f2py_init_param);
  F2PyDict_SetItemString(d, "param", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_par_char_def,f2py_init_par_char);
  F2PyDict_SetItemString(d, "par_char", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_par_log_def,f2py_init_par_log);
  F2PyDict_SetItemString(d, "par_log", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_charge_def,f2py_init_charge);
  F2PyDict_SetItemString(d, "charge", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_elecpot_def,f2py_init_elecpot);
  F2PyDict_SetItemString(d, "elecpot", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_energy_def,f2py_init_energy);
  F2PyDict_SetItemString(d, "energy", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_mixer_def,f2py_init_mixer);
  F2PyDict_SetItemString(d, "mixer", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ion_def,f2py_init_ion);
  F2PyDict_SetItemString(d, "ion", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py__BLNK__def,f2py_init__BLNK_);
  F2PyDict_SetItemString(d, "_BLNK_", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_tm2_blk_def,f2py_init_tm2_blk);
  F2PyDict_SetItemString(d, "tm2_blk", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_rcompat_def,f2py_init_rcompat);
  F2PyDict_SetItemString(d, "rcompat", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_lcompat_def,f2py_init_lcompat);
  F2PyDict_SetItemString(d, "lcompat", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_plot_def,f2py_init_plot);
  F2PyDict_SetItemString(d, "plot", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_nonlinear_def,f2py_init_nonlinear);
  F2PyDict_SetItemString(d, "nonlinear", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_coeffs_def,f2py_init_coeffs);
  F2PyDict_SetItemString(d, "coeffs", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_linear_def,f2py_init_linear);
  F2PyDict_SetItemString(d, "linear", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_input_s_def,f2py_init_input_s);
  F2PyDict_SetItemString(d, "input_s", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_input_chr_def,f2py_init_input_chr);
  F2PyDict_SetItemString(d, "input_chr", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_fordes_def,f2py_init_fordes);
  F2PyDict_SetItemString(d, "fordes", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_ode_blk_def,f2py_init_ode_blk);
  F2PyDict_SetItemString(d, "ode_blk", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_path_def,f2py_init_path);
  F2PyDict_SetItemString(d, "path", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_divcof_def,f2py_init_divcof);
  F2PyDict_SetItemString(d, "divcof", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_divint_def,f2py_init_divint);
  F2PyDict_SetItemString(d, "divint", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_set_num_def,f2py_init_set_num);
  F2PyDict_SetItemString(d, "set_num", tmp);
  Py_DECREF(tmp);
  tmp = PyFortranObject_New(f2py_set_chr_def,f2py_init_set_chr);
  F2PyDict_SetItemString(d, "set_chr", tmp);
  Py_DECREF(tmp);
/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"atomic_program");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
