# This module auto-generated by java class uk.ac.starlink.ttools.build.JyStilts.

'''Provides access to STILTS commands.

See the manual, http://www.starlink.ac.uk/stilts/sun256/
for tutorial and full usage information.
'''

from __future__ import generators
__author__ = 'Mark Taylor'


import jarray.array
from org.python.core.util import StringUtil
import java.io.ByteArrayInputStream as _ByteArrayInputStream
import java.io.OutputStream as _OutputStream
import java.lang.Class as _Class
import java.lang.System as _System
import java.lang.reflect.Array as _Array
import java.util.ArrayList as _ArrayList
import uk.ac.starlink.table.ColumnInfo as _ColumnInfo
import uk.ac.starlink.table.MultiStarTableWriter as _MultiStarTableWriter
import uk.ac.starlink.table.StarTable as _StarTable
import uk.ac.starlink.table.StarTableFactory as _StarTableFactory
import uk.ac.starlink.table.StarTableOutput as _StarTableOutput
import uk.ac.starlink.table.TableSequence as _TableSequence
import uk.ac.starlink.table.Tables as _Tables
import uk.ac.starlink.table.WrapperStarTable as _WrapperStarTable
import uk.ac.starlink.table.WrapperRowSequence as _WrapperRowSequence
import uk.ac.starlink.task.InvokeUtils as _InvokeUtils
import uk.ac.starlink.ttools.Stilts as _Stilts
import uk.ac.starlink.ttools.filter.StepFactory as _StepFactory
import uk.ac.starlink.ttools.task.MapEnvironment as _MapEnvironment
import uk.ac.starlink.util.DataSource as _DataSource
import uk.ac.starlink.ttools.func.Arithmetic as Arithmetic
import uk.ac.starlink.ttools.func.Bits as Bits
import uk.ac.starlink.ttools.func.Arrays as Arrays
import uk.ac.starlink.ttools.func.Conversions as Conversions
import uk.ac.starlink.ttools.func.CoordsDegrees as CoordsDegrees
import uk.ac.starlink.ttools.func.CoordsRadians as CoordsRadians
import uk.ac.starlink.ttools.func.Coverage as Coverage
import uk.ac.starlink.ttools.func.Distances as Distances
import uk.ac.starlink.ttools.func.Fluxes as Fluxes
import uk.ac.starlink.ttools.func.Formats as Formats
import uk.ac.starlink.ttools.func.Gaia as Gaia
import uk.ac.starlink.ttools.func.KCorrections as KCorrections
import uk.ac.starlink.ttools.func.Lists as Lists
import uk.ac.starlink.ttools.func.Maths as Maths
import uk.ac.starlink.ttools.func.Randoms as Randoms
import uk.ac.starlink.ttools.func.Shapes as Shapes
import uk.ac.starlink.ttools.func.Sky as Sky
import uk.ac.starlink.ttools.func.Strings as Strings
import uk.ac.starlink.ttools.func.Tilings as Tilings
import uk.ac.starlink.ttools.func.Times as Times
import uk.ac.starlink.ttools.func.TrigDegrees as TrigDegrees
import uk.ac.starlink.ttools.func.URLs as URLs
import uk.ac.starlink.ttools.func.VO as VO

class JyStarTable(_WrapperStarTable):
    '''StarTable wrapper class for use within Jython.

Decorates a uk.ac.starlink.table.StarTable
java object with methods for use within jython.
These include special bound functions to make it an
iterable object (with items which are table rows),
arithmetic + and * overloads for concatenation,
a write method for table viewing or output,
and methods representing STILTS filter functionality,
namely cmd_* methods for filters and mode_* methods
for output modes.

As a general rule, any StarTable object which is
intented for use by JyStilts program code should be
wrapped in an instance of this class.
    '''
    def __init__(self, base_table):
        _WrapperStarTable.__init__(self, base_table)
    def __iter__(self):
        rowseq = self.getRowSequence()
        while rowseq.next():
            yield self._create_row(rowseq.getRow())
    def __str__(self):
        return '%s (?x%d)' % (self.getName(), self.getColumnCount())
    def __add__(self, other):
        return tcat([self, other])
    def __mul__(self, count):
        return tcat([self] * count)
    def __rmul__(self, count):
        return tcat([self] * count)
    def columns(self):
        '''Returns a tuple of ColumnInfo objects describing the columns of this table.'''
        if hasattr(self, '_columns'):
            return self._columns
        else:
            col_list = []
            for i in xrange(self.getColumnCount()):
                col_list.append(_JyColumnInfo(self.getColumnInfo(i)))
            self._columns = tuple(col_list)
            return self.columns()
    def parameters(self):
        '''
Returns a mapping of table parameter names to values.

This does not provide all the information about the parameters,
for instance units and UCDs are not included.
For more detail, use the relevant StarTable methods.
Currently, this is not a live list, in the sense that changing
the returned dictionary will not affect the table parameter values.
        '''
        if hasattr(self, '_parameters'):
            return self._parameters
        else:
            params = {}
            for p in self.getParameters():
                params[p.getInfo().getName()] = p.getValue()
            self._parameters = params
            return self.parameters()
    def coldata(self, key):
        '''Returns a sequence of all the values in a given column.'''
        icol = self._column_index(key)
        rowseq = self.getRowSequence()
        while rowseq.next():
            yield rowseq.getCell(icol)
    def count_rows(self):
        '''Returns the number of rows in this table.
        For random access tables it calls getRowCount
        which returns the value directly.
        For non-random tables it may have to iterate over the rows.
        That could be slow, though it should be much faster than iterating
        over this table as an iterable itself, since the cell data
        does not need to be made available.'''
        nrow = self.getRowCount();
        if nrow >= 0:
            return nrow
        else:
            nr = 0
            rseq = self.getRowSequence()
            while rseq.next():
                nr += 1
            return nr
    def _create_row(self, array):
        row = _JyRow(array)
        row.table = self
        return row
    def _column_index(self, key):
        if type(key) is type(1):
            if key >= 0:
                return key
            else:
                return key + self.getColumnCount()
        if hasattr(self, '_colmap'):
            return self._colmap[key]
        else:
            colmap = {}
            for ic, col in enumerate(self.columns()):
                if not col in colmap:
                    colmap[col] = ic
                colname = col.getName()
                if not colname in colmap:
                    colmap[colname] = ic
            self._colmap = colmap
            return self._column_index(key)
    def write(self, location=None, fmt='(auto)'):
        '''Writes table to a file.
    
        The location parameter may give a filename or a
        python file object open for writing.
        if it is not supplied, standard output is used.
    
        The fmt parameter specifies output format.
        Known output formats:
           (auto)
           jdbc
           fits-plus
           fits-basic
           fits-var
           fits-healpix
           colfits-plus
           colfits-basic
           votable
           ecsv
           parquet
           feather
           text
           ascii
           csv
           ipac
           tst
           html
           latex
           mirage
        '''
        sto = _StarTableOutput()
        if hasattr(location, 'write') and hasattr(location, 'flush'):
            ostrm = _JyOutputStream(location)
            name = getattr(location, 'name', None)
            handler = sto.getHandler(fmt, name)
            sto.writeStarTable(self, ostrm, handler)
        else:
            if location is None:
                location = '-'
            sto.writeStarTable(self, location, fmt)
    def cmd_addcol(self, *args):
        '''\
    Add a new column called <col-name> defined by the algebraic
    expression <expr>. By default the new column appears after the last
    column of the table, but you can position it either before or after
    a specified column using the -before or -after flags respectively.
    
    The -units, -ucd, -utype and -desc flags can be used to define
    textual metadata values for the new column.
    
    The -shape flag can also be used, but is intended only for
    array-valued columns, e.g. -shape 3,3 to declare a 3x3 array. The
    final entry only in the shape list may be a "*" character to
    indicate unknown extent. Array values with no specified shape
    effectively have a shape of "*". The -elsize flag may be used to
    specify the length of fixed length strings; use with non-string
    columns is not recommended.
    
    Syntax for the <expr> and <col-id> arguments is described in the
    manual.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-after <col-id> | -before <col-id>]
        [-units <units>] [-ucd <ucd>] [-utype <utype>] [-desc <descrip>]
        [-shape <n>[,<n>...][,*]] [-elsize <n>]
        <col-name> <expr>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("addcol")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_addpixsample(self, *args):
        '''\
    Samples pixel data from an all-sky image file in HEALPix format. The
    <healpix-file> argument must be the filename of a table containing
    HEALPix pixel data. The URL of such a file can be used instead, but
    local files are likely to be more efficient.
    
    The <expr-lon> and <expr-lat> arguments give expressions for the
    longitude and latitude in degrees for each row of the input table;
    this is usually just the column names. The long/lat must usually be
    in the same coordinate system as that used for the HEALPix data, so
    if the one is in galactic coordinates the other must be as well. If
    this is not the case, use the -systems flag to give the input
    long/lat and healpix data coordinate system names respectively. The
    available coordinate system names are:
    
     * icrs: ICRS (Right Ascension, Declination)
     * fk5: FK5 J2000.0 (Right Ascension, Declination)
     * fk4: FK4 B1950.0 (Right Ascension, Declination)
     * galactic: IAU 1958 Galactic (Longitude, Latitude)
     * supergalactic: de Vaucouleurs Supergalactic (Longitude, Latitude)
     * ecliptic: Ecliptic (Longitude, Latitude)
    
    The <expr-rad>, if present, is a constant or expression giving the
    radius in degrees over which pixels will be averaged to obtain the
    result values. Note that this averaging is somewhat approximate;
    pixels partly covered by the specified disc are weighted the same as
    those fully covered. If no radius is specified, the value of the
    pixel covering the central position will be used.
    
    The <healpix-file> file is a table with one row per HEALPix pixel
    and one or more columns representing pixel data. A new column will
    be added to the output table corresponding to each of these pixel
    columns. This type of data is available in FITS tables for a number
    of all-sky data sets, particularly from the LAMBDA archive; see for
    instance the page on foreground products (including dust emission,
    reddening etc) or WMAP 7 year data. If the filename given does not
    appear to point to a file of the appropriate format, an error will
    result. Note the LAMBDA files mostly (all?) use galactic
    coordinates, so coordinate conversion using the -systems flag may be
    appropriate, see above.
    
    Syntax for the <expr-lon> , <expr-lat> and <expr-rad> arguments is
    described in the manual.
    
    This filter is somewhat experimental, and its usage may be changed
    or replaced in a future version.
    
    Note: you may prefer to use the pixsample command instead.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-radius <expr-rad>] [-systems <in-sys> <pix-sys>]
        <expr-lon> <expr-lat> <healpix-file>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("addpixsample")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_addresolve(self, *args):
        '''\
    Performs name resolution on the string-valued column
    <col-id-objname> and appends two new columns <col-name-ra> and
    <col-name-dec> containing the resolved Right Ascension and
    Declination in degrees.
    
    Syntax for the <col-id-objname> argument is described in SUN/256.
    
    UCDs are added to the new columns in a way which tries to be
    consistent with any UCDs already existing in the table.
    
    Since this filter works by interrogating a remote service, it will
    obviously be slow. The current implementation is experimental; it
    may be replaced in a future release by some way of doing the same
    thing (perhaps a new STILTS task) which is able to work more
    efficiently by dispatching multiple concurrent requests.
    
    This is currently implemented using the Simbad service operated by
    CDS.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <col-id-objname> <col-name-ra> <col-name-dec>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("addresolve")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_addskycoords(self, *args):
        '''\
    Add new columns to the table representing position on the sky. The
    values are determined by converting a sky position whose coordinates
    are contained in existing columns. The <col-id> arguments give
    identifiers for the two input coordinate columns in the coordinate
    system named by <insys>, and the <col-name> arguments name the two
    new columns, which will be in the coordinate system named by
    <outsys>. The <insys> and <outsys> coordinate system specifiers are
    one of
    
     * icrs: ICRS (Right Ascension, Declination)
     * fk5: FK5 J2000.0 (Right Ascension, Declination)
     * fk4: FK4 B1950.0 (Right Ascension, Declination)
     * galactic: IAU 1958 Galactic (Longitude, Latitude)
     * supergalactic: de Vaucouleurs Supergalactic (Longitude, Latitude)
     * ecliptic: Ecliptic (Longitude, Latitude)
    
    The -inunit and -outunit flags may be used to indicate the units of
    the existing coordinates and the units for the new coordinates
    respectively; use one of degrees, radians or sexagesimal (may be
    abbreviated), otherwise degrees will be assumed. For sexagesimal,
    the two corresponding columns must be string-valued in forms like
    hh:mm:ss.s and dd:mm:ss.s respectively.
    
    For certain conversions, the value specified by the -epoch flag is
    of significance. Where significant its value defaults to 2000.0.
    
    Syntax for the <expr> , <col-id1> and <col-id2> arguments is
    described in the manual.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-epoch <expr>] [-inunit deg|rad|sex] [-outunit deg|rad|sex]
        <insys> <outsys> <col-id1> <col-id2> <col-name1> <col-name2>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("addskycoords")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_assert(self, *args):
        '''\
    Check that a boolean expression is true for each row. If the
    expression <test-expr> does not evaluate true for any row of the
    table, execution terminates with an error. As long as no error
    occurs, the output table is identical to the input one.
    
    If the <msg-expr> parameter is supplied, then on failure it will be
    evaluated and its value presented in the error message.
    
    The exception generated by an assertion violation is of class
    uk.ac.starlink.ttools.filter.AssertException although that is not
    usually obvious if you are running from the shell in the usual way.
    
    Syntax for the <test-expr> and <msg-expr> arguments is described in
    the manual.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <test-expr> [<msg-expr>]
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("assert")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_badval(self, *args):
        '''\
    For each column specified in <colid-list> any occurrence of the
    value <bad-val> is replaced by a blank entry.
    
    Syntax for the <colid-list> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <bad-val> <colid-list>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("badval")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_cache(self):
        '''\
    Stores in memory or on disk a temporary copy of the table at this
    point in the pipeline. This can provide improvements in efficiency
    if there is an expensive step upstream and a step which requires
    more than one read of the data downstream. If you see an error like
    "Can't re-read data from stream" then adding this step near the
    start of the filters might help.
    
    The output table contains no code-level reference to the input
    table, so this filter can also be useful when managing tables that
    have become deeply nested as the result of successively applying
    many STILTS operations.
    
    The result of this filter is guaranteed to be random-access.
    
    See also the random filter, which caches only when the input table
    is not random-access.
    
    The filtered table is returned.
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("cache")
        sargs = []
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_check(self):
        '''\
    Runs checks on the table at the indicated point in the processing
    pipeline. This is strictly a debugging measure, and may be
    time-consuming for large tables.
    
    The filtered table is returned.
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("check")
        sargs = []
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_clearparams(self, *args):
        '''\
    Clears the value of one or more named parameters. Each of the
    <pname> values supplied may be either a parameter name or a simple
    wildcard expression matching parameter names. Currently the only
    wildcarding is a "*" to match any sequence of characters.
    clearparams * will clear all the parameters in the table.
    
    It is not an error to supply <pname>s which do not exist in the
    table - these have no effect.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <pname> ...
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("clearparams")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_collapsecols(self, *args):
        '''\
    Adds a new array-valued column by using the values from a specified
    range of scalar columns as array elements. The new column is named
    <array-colname>, and produced from the sequence of <ncol> scalar
    columns starting with <col-id0>.
    
    The array type of the output column is determined by the type of the
    first input column (<col-id0>). If it is of type Double, the output
    array column will be a double[] array, and similarly for types Long
    , Integer, Float and Boolean. Other integer types are currently
    mapped to int[], and object types, e.g. String, to the corresponding
    array type. Array elements for null or mistyped input values are
    mapped to NaN for floating point types, but note that they currently
    just turn into zeros for integer array types and false for boolean.
    
    By default the scalar columns that have been used are removed from
    the output table and the new column replaces them at the same
    position. However, if you supply the -keepscalars flag they will be
    retained alongside the new array column (the new column will appear
    just after the run of scalar columns).
    
    This filter does the opposite of explodecols.
    
    Syntax for the <col-id0> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-[no]keepscalars] <array-colname> <col-id0> <ncol>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("collapsecols")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_colmeta(self, *args):
        '''\
    Modifies the metadata of one or more columns. Some or all of the
    name, units, ucd, utype, description, shape and elementsize of the
    column(s), identified by <colid-list> can be set by using some or
    all of the listed flags. Typically, <colid-list> will simply be the
    name of a single column.
    
    The -name, -units, -ucd, -utype and -desc flags just take textual
    arguments. The -shape flag can also be used, but is intended only
    for array-valued columns, e.g. -shape 3,3 to declare a 3x3 array.
    The final entry only in the shape list may be a "*" character to
    indicate unknown extent. Array values with no specified shape
    effectively have a shape of "*". The -elsize flag may be used to
    specify the length of fixed length strings; use with non-string
    columns is not recommended.
    
    Syntax for the <colid-list> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-name <name>] [-units <units>] [-ucd <ucd>] [-utype <utype>]
        [-desc <descrip>] [-shape <n>[,<n>...][,*]] [-elsize <n>]
        <colid-list>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("colmeta")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_delcols(self, *args):
        '''\
    Delete the specified columns. The same column may harmlessly be
    specified more than once.
    
    Syntax for the <colid-list> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <colid-list>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("delcols")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_every(self, *args):
        '''\
    Include only every <step>'th row in the result, starting with the
    first row. The optional -approx/-exact argument controls whether the
    selection needs to be exact; in some cases an approximate
    calculation can take advantage of parallelism where an exact one
    cannot.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-exact|-approx] <step>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("every")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_explodecols(self, *args):
        '''\
    Takes a list of specified columns which represent N-element arrays
    and replaces each one with N scalar columns. Each of the columns
    specified by <colid-list> must have a fixed-length array type,
    though not all the arrays need to have the same number of elements.
    
    This filter does the opposite of collapsecols.
    
    Syntax for the <colid-list> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <colid-list>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("explodecols")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_explodeall(self, *args):
        '''\
    Replaces any columns which is an N-element arrays with N scalar
    columns. Only columns with fixed array sizes are affected. The
    action can be restricted to only columns of a certain shape using
    the flags.
    
    If the -ifndim flag is used, then only columns of dimensionality
    <ndim> will be exploded. <ndim> may be 1, 2, ....
    
    If the -ifshape flag is used, then only columns with a specific
    shape will be exploded; <dims> is a space- or comma-separated list
    of dimension extents, with the most rapidly-varying first, e.g. '2 5
    ' to explode all 2 x 5 element array columns.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-ifndim <ndim>] [-ifshape <dims>]
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("explodeall")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_fixcolnames(self):
        '''\
    Renames all columns and parameters in the input table so that they
    have names which have convenient syntax for STILTS. For the most
    part this means replacing spaces and other non-alphanumeric
    characters with underscores. This is a convenience which lets you
    use column names in algebraic expressions and other STILTS syntax.
    
    Additionally, column names are adjusted if necessary to ensure that
    they are all unique when compared case-insensitively. If the names
    are all unique to start with then no changes are made, but if for
    instance two columns exist with names gMag and GMag, one of them
    will be altered (for instance to GMag_1).
    
    The filtered table is returned.
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("fixcolnames")
        sargs = []
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_head(self, *args):
        '''\
    Include only the first <nrows> rows of the table. If the table has
    fewer than <nrows> rows then it will be unchanged.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <nrows>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("head")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_healpixmeta(self, *args):
        '''\
    Adjusts the table metadata items that describe how HEALPix pixel
    data is encoded in the table.
    
    Zero or more of the following flags may be supplied:
    
     * -level <n>: Defines the HEALPix level; the sky is split into
          12*4^n pixels. This quantity is equal to logarithm base 2 of
          NSIDE.
     * -implicit: Declares that pixel indices are implicit, so that row
          i represents HEALPix pixel index i. The table should have
          12*4^level rows in this case. Not to be used with -column.
     * -column <col-id>: Declares that the column identified contains
          the (0-based) HEALPix pixel index. Not to be used with
          -implicit.
     * -csys C|G|E: Declares the sky coordinate system to which the
          HEALPix pixels apply: Celestial(=equatorial), Galactic or E
          cliptic. Some applications assume Galactic if this is not
          specified.
     * -nested: Declares that the NESTED ordering scheme is in use. Not
          to be used with -ring.
     * -ring: Declares that the RING ordering scheme is in use. Not to
          be used with -nested.
    
    The effect of this filter is to write, or overwrite, certain special
    table parameters (per-table metadata) that STIL uses to describe how
    HEALPix pixel information is encoded in a table, specifically the
    HEALPix level, the column containing pixel index, the ordering
    scheme, and the sky coordinate system. Adding these parameters
    doesn't do anything on its own, but some of the STIL I/O handlers
    recognise these parameters, and they affect how the table will be
    formatted for output. In particular, if you set these parameters and
    then output to FITS format, the output table will contain headers
    defined by the HEALPix-FITS serialization format which is understood
    by several other applications to describe HEALPix maps. If you write
    to VOTable format, the metadata will only be recognised by other
    STIL-based applications but it means that if you, e.g., load the
    table into TOPCAT and then write it out again as FITS, the HEALPix
    information should be preserved.
    
    When writing tables marked up like this to FITS, you have two
    options. If you write to one of the "normal" FITS formats (e.g.
    fits, fits-basic) then suitable headers will be added; in this case
    if an explicit pixel index column is used it must be the first
    column, and should be named "PIXEL". This may be enough for other
    applications to recognise the HEALPix metadata. However, if you use
    the special fits-healpix format more efforts will be made to conform
    to the HEALPix-FITS convention, for instance moving and renaming the
    explicit pixel index column if required.
    
    The table parameters affected by this filter are: STIL_HPX_LEVEL,
    STIL_HPX_ISNEST, STIL_HPX_COLNAME, STIL_HPX_CSYS. Note these are not
    defined by any standard, they are defined and used only by STILTS
    and related applications (TOPCAT).
    
    Syntax for the <col-id> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-level <n>] [-implicit|-column <col-id>] [-csys C|G|E] [-nested|-ring] 
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("healpixmeta")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_keepcols(self, *args):
        '''\
    Select the columns from the input table which will be included in
    the output table. The output table will include only those columns
    listed in <colid-list>, in that order. The same column may be listed
    more than once, in which case it will appear in the output table
    more than once.
    
    Syntax for the <colid-list> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <colid-list>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("keepcols")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_meta(self, *args):
        '''\
    Provides information about the metadata for each column. This filter
    turns the table sideways, so that each row of the output corresponds
    to a column of the input. The columns of the output table contain
    metadata items such as column name, units, UCD etc corresponding to
    each column of the input table.
    
    By default the output table contains columns for all metadata items
    for which any of the columns have non-blank values.
    
    However, the output may be customised by supplying one or more
    <item> headings, in which case exactly those columns will appear,
    regardless of whether they have entries. It is not an error to
    specify an item for which no metadata exists in any of the columns
    (such entries will result in empty columns).
    
    Some of the metadata items commonly found are:
    
     * Index: Position of column in table
     * Name: Column name
     * Class: Data type of objects in column
     * Shape: Shape of array values
     * ElSize: Size of each element in column (mostly useful for
          strings)
     * Units: Unit string
     * Description: Description of data in the column
     * UCD: Unified Content Descriptor
     * Utype: Type in data model
     * Xtype: Extended data type
     * CoosysSystem: Sky coordinate system name from COOSYS
     * CoosysEpoch: Sky epoch from COOSYS
     * CoosysEquinox: Sky equinox from COOSYS
     * TimesysTimeorigin: Time origin from TIMESYS
     * TimesysTimescale: Timescale from TIMESYS
     * TimesysRefposition: Ref position from TIMESYS
     * STIL_HPX_LEVEL: Level of HEALPix pixels contained in the table
          (nside=2^level)
     * STIL_HPX_ISNEST: True for NEST indexation scheme, False for RING
     * STIL_HPX_COLNAME: Name of the table column containing HEALPix
          index; null value or empty string indicates implicit
     * STIL_HPX_CSYS: 'C'=celestial/equatorial, 'G'=galactic,
          'E'=ecliptic
    
    Any table parameters of the input table are propagated to the output
    one.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [<item> ...]
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("meta")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_progress(self):
        '''\
    Monitors progress by displaying the number of rows processed so far
    on the terminal (standard error). This number is updated every
    second or thereabouts; if all the processing is done in under a
    second you may not see any output. If the total number of rows in
    the table is known, an ASCII-art progress bar is updated, otherwise
    just the number of rows seen so far is written.
    
    Note under some circumstances progress may appear to complete before
    the actual work of the task is done since part of the processing
    involves slurping up the whole table to provide random access on it.
    In this case, applying the cache upstream may help.
    
    The filtered table is returned.
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("progress")
        sargs = []
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_random(self):
        '''\
    Ensures that random access is available on this table. If the table
    currently has random access, it has no effect. If only sequential
    access is available, the table is cached so that downstream steps
    will see the cached, hence random-access, copy.
    
    The filtered table is returned.
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("random")
        sargs = []
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_randomview(self):
        '''\
    Ensures that steps downstream only use random access methods for
    table access. If the table is sequential only, this will result in
    an error. Only useful for debugging.
    
    The filtered table is returned.
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("randomview")
        sargs = []
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_repeat(self, *args):
        '''\
    Repeats the rows of a table multiple times to produce a longer
    table. The output table will have <count> times as many rows as the
    input table.
    
    The optional flag determines the sequence of the output rows. If
    <count>=2 and there are three rows, the output sequence will be
    112233 for -row and 123123 for -table. The default behaviour is
    currently -table.
    
    The <count> value will usually be a constant integer value, but it
    can be an expression evaluated in the context of the table.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-row|-table] <count>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("repeat")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_replacecol(self, *args):
        '''\
    Replaces the content of a column with the value of an algebraic
    expression. The old values are discarded in favour of the result of
    evaluating <expr>. You can specify the metadata for the new column
    using the -name, -units, -ucd, -utype and -desc flags; for any of
    these items which you do not specify, they will take the values from
    the column being replaced.
    
    It is legal to reference the replaced column in the expression, so
    for example "replacecol pixsize pixsize*2" just multiplies the
    values in column pixsize by 2.
    
    Syntax for the <col-id> and <expr> arguments is described in the
    manual.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-name <name>] [-units <units>] [-ucd <ucd>] [-utype <utype>]
        [-desc <descrip>]
        <col-id> <expr>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("replacecol")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_replaceval(self, *args):
        '''\
    For each column specified in <colid-list> any instance of <old-val>
    is replaced by <new-val>. The value string 'null' can be used for
    either <old-value> or <new-value> to indicate a blank value (but see
    also the badval filter).
    
    Syntax for the <colid-list> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <old-val> <new-val> <colid-list>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("replaceval")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_rowrange(self, *args):
        '''\
    Includes only rows in a given range. The range can either be
    supplied as "<first> <last>", where row indices are inclusive, or "
    <first> +<count>". In either case, the first row is numbered 1.
    
    Thus, to get the first hundred rows, use either "rowrange 1 100" or
    "rowrange 1 +100" and to get the second hundred, either "rowrange
    101 200" or "rowrange 101 +100"
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <first> <last>|+<count>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("rowrange")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_select(self, *args):
        '''\
    Include in the output table only rows for which the expression
    <expr> evaluates to true. <expr> must be an expression which
    evaluates to a boolean value (true/false).
    
    Syntax for the <expr> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <expr>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("select")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_seqview(self):
        '''\
    Ensures that steps downstream see the table as sequential access.
    Any attempts at random access will fail. Only useful for debugging.
    
    The filtered table is returned.
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("seqview")
        sargs = []
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_setparam(self, *args):
        '''\
    Sets a named parameter in the table to a given value. The parameter
    named <pname> is set to the value <pexpr>, which may be a literal
    value or an expression involving mathematical operations and other
    parameter names (using the param$<name> syntax). By default, the
    data type of the parameter is determined by the type of the supplied
    expression, but this can be overridden using the -type flag. The
    parameter description, units, UCD and Utype attributes may
    optionally be set using the other flags.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-type byte|short|int|long|float|double|boolean|string]
        [-desc <descrip>] [-unit <units>] [-ucd <ucd>] [-utype <utype>]
        <pname> <pexpr>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("setparam")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_sort(self, *args):
        '''\
    Sorts the table according to the value of one or more algebraic
    expressions. The sort key expressions appear, as separate
    (space-separated) words, in <key-list>; sorting is done on the first
    expression first, but if that results in a tie then the second one
    is used, and so on.
    
    Each expression must evaluate to a type that it makes sense to sort,
    for instance numeric. If the -down flag is used, the sort order is
    descending rather than ascending.
    
    Blank entries are by default considered to come at the end of the
    collation sequence, but if the -nullsfirst flag is given then they
    are considered to come at the start instead.
    
    By default, sorting is done sequentially for small tables and in
    parallel for large tables, but this can be controlled with the
    -parallel or -noparallel flag.
    
    Syntax for the <key-list> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-down] [-nullsfirst] [-[no]parallel] <key-list>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("sort")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_sorthead(self, *args):
        '''\
    Performs a sort on the table according to the value of one or more
    algebraic expressions, retaining only <nrows> rows at the head of
    the resulting sorted table. The sort key expressions appear, as
    separate (space-separated) words, in <key-list>; sorting is done on
    the first expression first, but if that results in a tie then the
    second one is used, and so on. Each expression must evaluate to a
    type that it makes sense to sort, for instance numeric.
    
    If the -tail flag is used, then the last <nrows> rows rather than
    the first ones are retained.
    
    If the -down flag is used the sort order is descending rather than
    ascending.
    
    Blank entries are by default considered to come at the end of the
    collation sequence, but if the -nullsfirst flag is given then they
    are considered to come at the start instead.
    
    This filter is functionally equivalent to using sort followed by
    head, but it can be done in one pass and is usually cheaper on
    memory and faster, as long as <nrows> is significantly lower than
    the size of the table.
    
    Syntax for the <key-list> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-tail] [-down] [-nullsfirst] <nrows> <key-list>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("sorthead")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_stats(self, *args):
        '''\
    Calculates statistics on the data in the table. This filter turns
    the table sideways, so that each row of the output corresponds to a
    column of the input. The columns of the output table contain
    statistical items such as mean, standard deviation etc corresponding
    to each column of the input table.
    
    By default the output table contains columns for the following
    items:
    
     * Name: Column name
     * Mean: Average
     * StDev: Population Standard deviation
     * Minimum: Numeric minimum
     * Maximum: Numeric maximum
     * NGood: Number of non-blank cells
    
    However, the output may be customised by supplying one or more
    <item> headings. These may be selected from the above as well as the
    following:
    
     * NBad: Number of blank cells
     * Variance: Population Variance
     * SampStDev: Sample Standard Deviation
     * SampVariance: Sample Variance
     * MedAbsDev: Median Absolute Deviation
     * ScMedAbsDev: Median Absolute Deviation * 1.4826
     * Skew: Gamma 1 skewness measure
     * Kurtosis: Gamma 2 peakedness measure
     * Sum: Sum of values
     * MinPos: Row index of numeric minimum
     * MaxPos: Row index of numeric maximum
     * Cardinality: Number of distinct values in column; values >100
          ignored
     * Median: Middle value in sequence
     * Quartile1: First quartile
     * Quartile2: Second quartile
     * Quartile3: Third quartile
     * ArrayNGood: Per-element non-blank counts for fixed-length array
          columns
     * ArraySum: Per-element sums for fixed-length array columns
     * ArrayMean: Per-element means for fixed-length array columns
     * ArrayStDev: Per-element population standard deviation for
          fixed-length array columns
    
    Additionally, the form "Q.nn" may be used to represent the quantile
    corresponding to the proportion 0.nn, e.g.:
    
     * Q.25: First quartile
     * Q.625: Fifth octile
    
    Any parameters of the input table are propagated to the output one.
    
    The -qapprox or -qexact flag controls how quantiles are calculated.
    With -qexact they are calculated exactly, but this requires memory
    usage scaling with the number of rows. If the -qapprox flag is
    supplied, an method is used which is typically slower and produces
    only approximate values, but which will work in fixed memory and so
    can be used for arbitrarily large tables. By default, exact
    calculation is used. These flags are ignored if neither quantiles
    nor the MAD are being calculated
    
    The -noparallel flag may be supplied to inhibit multi-threaded
    statistics accumulation. Calculation is done in parallel by default
    if multi-threaded hardware is available, and it's usually faster.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-[no]parallel] [-qapprox|-qexact] [<item> ...]
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("stats")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_tablename(self, *args):
        '''\
    Sets the table's name attribute to the given string.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <name>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("tablename")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_tail(self, *args):
        '''\
    Include only the last <nrows> rows of the table. If the table has
    fewer than <nrows> rows then it will be unchanged.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        <nrows>
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("tail")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_transpose(self, *args):
        '''\
    Transposes the input table so that columns become rows and vice
    versa. The -namecol flag can be used to specify a column in the
    input table which will provide the column names for the output
    table. The first column of the output table will contain the column
    names of the input table.
    
    Syntax for the <col-id> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-namecol <col-id>]
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("transpose")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def cmd_uniq(self, *args):
        '''\
    Eliminates adjacent rows which have the same values. If used with no
    arguments, then any row which has identical values to its
    predecessor is removed.
    
    If the <colid-list> parameter is given then only the values in the
    specified columns must be equal in order for the row to be removed.
    
    If the -count flag is given, then an additional column with the name
    DupCount will be prepended to the table giving a count of the number
    of duplicated input rows represented by each output row. A unique
    row has a DupCount value of 1.
    
    Syntax for the <colid-list> argument is described in SUN/256.
    
    The filtered table is returned.
    
    args is a list with words as elements:
        [-count] [<colid-list>]
    '''
        pfilt = _StepFactory.getInstance().getFilterFactory().createObject("uniq")
        sargs = [str(a) for a in args]
        argList = _ArrayList(sargs)
        step = pfilt.createStep(argList.iterator())
        return import_star_table(step.wrap(self))
    def mode_out(self, out='-', ofmt='(auto)'):
        '''\
    Writes a new table.
    
    Parameters:
    
       out = <out-table>       (uk.ac.starlink.ttools.TableConsumer)
          The location of the output table. This is usually a filename
          to write to. If it is equal to the special value "-" (the
          default) the output table will be written to standard output.
    
          [Default: -]
    
       ofmt = <out-format>       (String)
          Specifies the format in which the output table will be written
          (one of the ones in SUN/256 - matching is case-insensitive and
          you can use just the first few letters). If it has the special
          value "(auto)" (the default), then the output filename will be
          examined to try to guess what sort of file is required usually
          by looking at the extension. If it's not obvious from the
          filename what output format is intended, an error will result.
    
          [Default: (auto)]
    '''
        env = _JyEnvironment()
        env.setValue('out', _map_env_value(out))
        env.setValue('ofmt', _map_env_value(ofmt))
        mode = _stilts.getModeFactory().createObject('out')
        consumer = mode.createConsumer(env)
        _check_unused_args(env)
        consumer.consume(self)
    def mode_meta(self):
        '''\
    Prints the table metadata to standard output. The name and type etc
    of each column is tabulated, and table parameters are also shown.
    
    See the meta filter for more flexible output of table metadata.
    '''
        env = _JyEnvironment()
        mode = _stilts.getModeFactory().createObject('meta')
        consumer = mode.createConsumer(env)
        _check_unused_args(env)
        consumer.consume(self)
    def mode_stats(self):
        '''\
    Calculates and displays univariate statistics for each of the
    numeric columns in the table. The following entries are shown for
    each column as appropriate:
    
     * mean
     * population standard deviation
     * minimum
     * maximum
     * number of non-null entries
    
    See the stats filter for more flexible statistical calculations.
    '''
        env = _JyEnvironment()
        mode = _stilts.getModeFactory().createObject('stats')
        consumer = mode.createConsumer(env)
        _check_unused_args(env)
        consumer.consume(self)
    def mode_count(self):
        '''\
    Counts the number of rows and columns and writes the result to
    standard output.
    '''
        env = _JyEnvironment()
        mode = _stilts.getModeFactory().createObject('count')
        consumer = mode.createConsumer(env)
        _check_unused_args(env)
        consumer.consume(self)
    def mode_checksum(self):
        '''\
    Calculates a checksum from all the data in the table. The checksum
    is written to standard output in hexadecimal; row and column counts
    are also written.
    
    If two tables have the same checksum it is extremely likely that
    they contain the same cell data. If they have a different checksum,
    their cell data differs. By default, the checksum implementation
    uses Adler32, which is fast but not cryptographically secure.
    '''
        env = _JyEnvironment()
        mode = _stilts.getModeFactory().createObject('checksum')
        consumer = mode.createConsumer(env)
        _check_unused_args(env)
        consumer.consume(self)
    def mode_cgi(self, ofmt='votable'):
        '''\
    Writes a table to standard output in a way suitable for use as
    output from a CGI (Common Gateway Interface) program. This is very
    much like out mode but a short CGI header giving the MIME
    Content-Type is prepended to the output
    
    Parameters:
    
       ofmt = <out-format>       (String)
          Specifies the format in which the output table will be written
          (one of the ones in SUN/256 - matching is case-insensitive and
          you can use just the first few letters).
    
          [Default: votable]
    '''
        env = _JyEnvironment()
        env.setValue('ofmt', _map_env_value(ofmt))
        mode = _stilts.getModeFactory().createObject('cgi')
        consumer = mode.createConsumer(env)
        _check_unused_args(env)
        consumer.consume(self)
    def mode_discard(self):
        '''\
    Reads all the data in the table in sequential mode and discards it.
    May be useful in conjunction with the assert filter.
    '''
        env = _JyEnvironment()
        mode = _stilts.getModeFactory().createObject('discard')
        consumer = mode.createConsumer(env)
        _check_unused_args(env)
        consumer.consume(self)
    def mode_topcat(self):
        '''\
    Attempts to display the output table directly in TOPCAT. If a TOPCAT
    instance is already running on the local host, an attempt will be
    made to open the table in that. A variety of mechanisms are used to
    attempt communication with an existing TOPCAT instance. In order:
     * SAMP using existing hub (TOPCAT v3.4+ only, requires SAMP hub to
          be running)
     * PLASTIC using existing hub (requires PLASTIC hub to be running)
     * SOAP (requires TOPCAT to run with somewhat deprecated -soap flag,
          may be limitations on table size)
     * SAMP using internal, short-lived hub (TOPCAT v3.4+ only, running
          hub not required, but may be slow. It's better to start an
          external hub, e.g. topcat -exthub) Failing that, an attempt
    will be made to launch a new TOPCAT instance for display. This only
    works if the TOPCAT classes are on the class path.
    
    If large tables are involved, starting TOPCAT with the -disk flag is
    probably a good idea.
    '''
        env = _JyEnvironment()
        mode = _stilts.getModeFactory().createObject('topcat')
        consumer = mode.createConsumer(env)
        _check_unused_args(env)
        consumer.consume(self)
    def mode_samp(self, format='votable fits', client=None):
        '''\
    Sends the table to registered SAMP-aware applications subscribed to
    a suitable table load MType. SAMP, the Simple Application Messaging
    Protocol, is a tool interoperability protocol. A SAMP Hub must be
    running for this to work.
    
    Parameters:
    
       format = <value>       (String[])
          Gives one or more table format types for attempting the table
          transmission over SAMP. If multiple values are supplied, they
          should be separated by spaces. Each value supplied for this
          parameter corresponds to a different MType which may be used
          for the transmission. If a single value is used, a SAMP
          broadcast will be used. If multiple values are used, each
          registered client will be interrogated to see whether it
          subscribes to the corresponding MTypes in order; the first one
          to which it is subscribed will be used to send the table. The
          standard options are
    
           * votable: use MType table.load.votable
           * fits: use MType table.load.fits
    
          If any other string is used which corresponds to one of
          STILTS's known table output formats, an attempt will be made
          to use an ad-hoc MType of the form table.load.format.
    
          [Default: votable fits]
    
       client = <name-or-id>       (String)
          Identifies a registered SAMP client which is to receive the
          table. Either the client ID or the (case-insensitive)
          application name may be used. If a non-null value is given,
          then the table will be sent to only the first client with the
          given name or ID. If no value is supplied the table will be
          sent to all suitably subscribed clients.
    '''
        env = _JyEnvironment()
        env.setValue('format', _map_env_value(format))
        env.setValue('client', _map_env_value(client))
        mode = _stilts.getModeFactory().createObject('samp')
        consumer = mode.createConsumer(env)
        _check_unused_args(env)
        consumer.consume(self)
    def mode_plastic(self, transport=None, client=None):
        '''\
    Broadcasts the table to any registered Plastic-aware applications.
    PLASTIC, the PLatform for AStronomical Tool InterConnection, is a
    tool interoperability protocol. A Plastic hub must be running in
    order for this to work.
    
    Parameters:
    
       transport = string|file       (String)
          Determines the method (PLASTIC message) used to perform the
          PLASTIC communication. The choices are
    
           * string: VOTable serialized as a string and passed as a call
                parameter (ivo://votech.org/votable/load). Not suitable
                for very large files.
           * file: VOTable written to a temporary file and the filename
                passed as a call parameter (
                ivo://votech.org/votable/loadFromURL). The file ought to
                be deleted once it has been loaded. Not suitable for
                inter-machine communication.
    
          If no value is set (null) then a decision will be taken based
          on the apparent size of the table.
    
       client = <app-name>       (String)
          Gives the name of a PLASTIC listener application which is to
          receive the broadcast table. If a non-null value is given,
          then only the first registered application which reports its
          application name as that value will receive the message. If no
          value is supplied, the broadcast will be to all listening
          applications.
    '''
        env = _JyEnvironment()
        env.setValue('transport', _map_env_value(transport))
        env.setValue('client', _map_env_value(client))
        mode = _stilts.getModeFactory().createObject('plastic')
        consumer = mode.createConsumer(env)
        _check_unused_args(env)
        consumer.consume(self)
    def mode_tosql(self, protocol, db, dbtable, host='localhost', write='create', user='mbt', password=None):
        '''\
    Writes a new table to an SQL database. You need the appropriate JDBC
    drivers and -Djdbc.drivers set as usual (see SUN/256).
    
    Parameters:
    
       protocol = <jdbc-protocol>       (String)
          The driver-specific sub-protocol specifier for the JDBC
          connection. For MySQL's Connector/J driver, this is mysql, and
          for PostgreSQL's driver it is postgresql. For other drivers,
          you may have to consult the driver documentation.
    
       host = <value>       (String)
          The host which is acting as a database server.
    
          [Default: localhost]
    
       db = <db-name>       (String)
          The name of the database on the server into which the new
          table will be written.
    
          The value of this parameter forms the last part of the JDBC
          connection URL. That means that for some JDBC drivers, you can
          append parameter specifications to it to affect the way the
          connection is made to the database, e.g. "
          db=some_db?useSSL=false" for MySQL's Connector/J.
    
       dbtable = <table-name>       (String)
          The name of the table which will be written to the database.
    
       write = create|dropcreate|append       
       (uk.ac.starlink.table.jdbc.WriteMode)
          Controls how the values are written to a table in the
          database. The options are:
    
           * create: Creates a new table before writing. It is an error
                if a table of the same name already exists.
           * dropcreate: Creates a new database table before writing. If
                a table of the same name already exists, it is dropped
                first.
           * append: Appends to an existing table. An error results if
                the named table has the wrong structure (number or types
                of columns) for the data being written.
    
          [Default: create]
    
       user = <username>       (String)
          User name for the SQL connection to the database.
    
          [Default: mbt]
    
       password = <passwd>       (String)
          Password for the SQL connection to the database.
    '''
        env = _JyEnvironment()
        env.setValue('protocol', _map_env_value(protocol))
        env.setValue('db', _map_env_value(db))
        env.setValue('dbtable', _map_env_value(dbtable))
        env.setValue('host', _map_env_value(host))
        env.setValue('write', _map_env_value(write))
        env.setValue('user', _map_env_value(user))
        env.setValue('password', _map_env_value(password))
        mode = _stilts.getModeFactory().createObject('tosql')
        consumer = mode.createConsumer(env)
        _check_unused_args(env)
        consumer.consume(self)
    def mode_gui(self):
        '''\
    Displays the table in a scrollable window.
    '''
        env = _JyEnvironment()
        mode = _stilts.getModeFactory().createObject('gui')
        consumer = mode.createConsumer(env)
        _check_unused_args(env)
        consumer.consume(self)

class RandomJyStarTable(JyStarTable):
    '''Extends the JyStarTable wrapper class for random access.

    Instances of this class can be subscripted.
    '''
    def __init__(self, base_table):
        JyStarTable.__init__(self, base_table)
    def __len__(self):
        return int(self.getRowCount())
    def __getitem__(self, key):
        if type(key) is type(slice(0)):
            return [self._create_row(self.getRow(irow))
                    for irow in _slice_range(key, len(self))]
        elif key < 0:
            irow = self.getRowCount() + key
            return self._create_row(self.getRow(irow))
        else:
            return self._create_row(self.getRow(key))
    def __str__(self):
        return str(self.getName()) + '(' + str(self.getRowCount()) + 'x' + str(self.getColumnCount()) + ')'
    def coldata(self, key):
        '''Returns a sequence of all the values in a given column.'''
        icol = self._column_index(key)
        return _Coldata(self, icol)

class _Coldata(object):
    def __init__(self, table, icol):
        self.table = table
        self.icol = icol
        self.nrow = len(table)
    def __iter__(self):
        rowseq = self.table.getRowSequence()
        while rowseq.next():
            yield rowseq.getCell(self.icol)
    def __len__(self):
        return self.nrow
    def __getitem__(self, key):
        if type(key) is type(slice(0)):
            return [self.table.getCell(irow, self.icol)
                    for irow in _slice_range(key, self.nrow)]
        elif key < 0:
            irow = self.nrow + key
            return self.table.getCell(irow, self.icol)
        else:
            return self.table.getCell(key, self.icol)

class _JyColumnInfo(_ColumnInfo):
    def __init__(self, base):
        _ColumnInfo.__init__(self, base)
    def __str__(self):
        return self.getName()

class _JyRow(tuple):
    def __init__(self, array):
        tuple.__init__(self, array)
    def __getitem__(self, key):
        icol = self.table._column_index(key)
        return tuple.__getitem__(self, icol)

class _JyEnvironment(_MapEnvironment):
    def __init__(self, grab_output=False):
        _MapEnvironment.__init__(self)
        if grab_output:
            self._out = _MapEnvironment.getOutputStream(self)
        else:
            self._out = _System.out
        self._err = _System.err
        self._used = {}
    def getOutputStream(self):
        return self._out
    def getErrorStream(self):
        return self._err
    def acquireValue(self, param):
        _MapEnvironment.acquireValue(self, param)
        self._used[param.getName()] = True
    def getUnusedArgs(self):
        return filter(lambda n: n not in self._used, self.getNames())

def _check_unused_args(env):
    names = env.getUnusedArgs()
    if (names):
        raise SyntaxError('Unused STILTS parameters %s' % str(tuple([str(n) for n in names])))

def _check_multi_handler(handler):
    if not _Class.forName('uk.ac.starlink.table.MultiStarTableWriter').isInstance(handler):
        raise TypeError('Handler %s cannot write multiple tables' % handler.getFormatName())

def _slice_range(slice, leng):
    start = slice.start
    stop = slice.stop
    step = slice.step
    if start is None:
        start = 0
    elif start < 0:
        start += leng
    if stop is None:
        stop = leng
    elif stop < 0:
        stop += leng
    if step is None:
        return xrange(start, stop)
    else:
        return xrange(start, stop, step)

class _JyOutputStream(_OutputStream):
    def __init__(self, file):
        self._file = file
    def write(self, *args):
        narg = len(args)
        if narg is 1:
            arg0 = args[0]
            if type(arg0) is type(1):
                pyarg = chr(arg0)
            else:
                pyarg = arg0
        elif narg is 3:
            buf, off, leng = args
            pyarg = buf[off:off + leng].tostring()
        else:
            raise SyntaxError('%d args?' % narg)
        self._file.write(pyarg)
    def close(self):
        self._file.close()
    def flush(self):
        self._file.flush()

class _JyTableSequence(_TableSequence):
    def __init__(self, seq):
        self._iter = iter(seq)
    def nextTable(self):
        try:
            return self._iter.next()
        except StopIteration:
            return None

class _JyDataSource(_DataSource):
    def __init__(self, file):
        buf = file.read(-1)
        self._buffer = StringUtil.toBytes(buf)
        if hasattr(file, 'name'):
            self.setName(file.name)
        else:
            self.setName('unnamed')
    def getRawInputStream(self):
        return _ByteArrayInputStream(self._buffer)
def import_star_table(table):
    '''Imports a StarTable instance for use with JyStilts.

    This factory function takes an instance of the Java class
    uk.ac.starlink.table.StarTable
    and returns an instance of a wrapper subclass which has some
    decorations useful in a python environment.
    This includes stilts cmd_* and mode_* methods, as well as
    python-friendly standard methods to make it behave as an
    iterable, and where possible a container, of data rows,
    and overloaded addition and multiplication operators
    with the semantics of concatenation.
    '''
    if table.isRandom():
        return RandomJyStarTable(table)
    else:
        return JyStarTable(table)

def _map_env_value(pval):
    if pval is None:
        return None
    elif pval is True:
        return 'true'
    elif pval is False:
        return 'false'
    elif isinstance(pval, _StarTable):
        return pval
    elif _is_container(pval, _StarTable):
        return jarray.array(pval, _StarTable)
    else:
        return str(pval)

def _is_container(value, type):
    try:
        if len(value) > 0:
            for item in value:
                if not isinstance(item, type):
                    return False
            return True
        else:
            return False
    except TypeError:
        return False

_stilts = _Stilts()

_InvokeUtils.configureLogging(0, False)

_param_alias_dict = {}
_param_alias_dict['in']='in_'


_stilts_lib_version = _stilts.getVersion()
_stilts_script_version = '3.4-7'
if _stilts_lib_version != _stilts_script_version:
    print('WARNING: STILTS script/class library version mismatch (' + _stilts_script_version + '/' + _stilts_lib_version + ').')
    print('         This may or may not cause trouble.')

def tread(location, fmt='(auto)', random=False):
    '''Reads a table from a filename, URL or python file object.

    The random argument determines whether random access is required
    for the table.
    Setting it true may improve efficiency, but perhaps at the cost
    of memory usage and load time for large tables.

    The fmt argument must be supplied if the table format cannot
    be auto-detected.

    In general supplying a filename is preferred; the current implementation
    may be much more expensive on memory if a python file object is used.

    Auto-detected in-formats:
       fits-plus
       colfits-plus
       colfits-basic
       fits
       votable
       cdf
       ecsv
       pds4
       mrt
       parquet
       feather
       gbin
 
    Known in-formats:
       fits-plus
       colfits-plus
       colfits-basic
       fits
       votable
       cdf
       ecsv
       pds4
       mrt
       parquet
       feather
       gbin
       ascii
       csv
       tst
       ipac
       wdc

    The result of the function is a JyStilts table object.
    '''
    fact = _StarTableFactory(random)
    _Stilts.addStandardSchemes(fact)
    if hasattr(location, 'read'):
        datsrc = _JyDataSource(location)
        table = fact.makeStarTable(datsrc, fmt)
    else:
        table = fact.makeStarTable(location, fmt)
    return import_star_table(table)

def treads(location, fmt='(auto)', random=False):
    '''Reads multiple tables from a filename, URL or python file object.

    It only makes sense to use this function rather than tread() if the
    format is, or may be, one which can contain multiple tables.
    Generally this means VOTable or FITS or one of their variants.

    The random argument determines whether random access is required
    for the table.
    Setting it true may improve efficiency, but perhaps at the cost
    of memory usage and load time for large tables.

    The fmt argument must be supplied if the table format cannot
    be auto-detected.

    In general supplying a filename is preferred; the current implementation
    may be much more expensive on memory if a python file object is used.

    The result of the function is a list of JyStilts table objects.
    '''
    fact = _StarTableFactory(random)
    _Stilts.addStandardSchemes(fact)
    if hasattr(location, 'read'):
        datsrc = _JyDataSource(location)
    else:
        datsrc = _DataSource.makeDataSource(location)
    tseq = fact.makeStarTables(datsrc, fmt)
    tables = _Tables.tableArray(tseq)
    return map(import_star_table, tables)

def twrite(table, location=None, fmt='(auto)'):
    '''Writes table to a file.

    The location parameter may give a filename or a
    python file object open for writing.
    if it is not supplied, standard output is used.

    The fmt parameter specifies output format.
    Known output formats:
       (auto)
       jdbc
       fits-plus
       fits-basic
       fits-var
       fits-healpix
       colfits-plus
       colfits-basic
       votable
       ecsv
       parquet
       feather
       text
       ascii
       csv
       ipac
       tst
       html
       latex
       mirage
    '''
    sto = _StarTableOutput()
    if hasattr(location, 'write') and hasattr(location, 'flush'):
        ostrm = _JyOutputStream(location)
        name = getattr(location, 'name', None)
        handler = sto.getHandler(fmt, name)
        sto.writeStarTable(table, ostrm, handler)
    else:
        if location is None:
            location = '-'
        sto.writeStarTable(table, location, fmt)

def twrites(tables, location=None, fmt='(auto)'):
    '''Writes a sequence of tables to a single container file.

    The tables parameter gives an iterable over JyStilts table objects
    The location parameter may give a filename or a python file object
    open for writing.  If it is not supplied,  standard output is used.

    The fmt parameter specifies output format.
    Note that not all formats can write multiple tables;
    an error will result if an attempt is made to write
    multiple tables to a single-table only format.
    Known multi-table output formats:
       (auto)
       fits-plus
       fits-basic
       fits-var
       fits-healpix
       colfits-plus
       colfits-basic
       votable
       text
       html
    '''
    sto = _StarTableOutput()
    tseq = _JyTableSequence(tables)
    if hasattr(location, 'write') and hasattr(location, 'flush'):
        ostrm = _JyOutputStream(location)
        name = getattr(location, 'name', None)
        handler = sto.getHandler(fmt, name)
        _check_multi_handler(handler)
        handler.writeStarTables(tseq, ostrm)
    else:
        if location is None:
            location = '-'
        handler = sto.getHandler(fmt, location)
        _check_multi_handler(handler)
        handler.writeStarTables(tseq, location, sto)

def tfilter(table, cmd):
    '''Applies a filter operation to a table and returns the result.
    In most cases, it's better to use one of the cmd_* functions.
    '''
    step = _StepFactory.getInstance().createStep(cmd)
    return import_star_table(step.wrap(table))

def arrayjoin(in_, **kwargs):
    '''\
Adds table-per-row data as array-valued columns.

The return value is the resulting table.

Parameters:

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   atable = <loc-expr>       (String)
      Gives the location of the table whose rows will be turned into
      an array-valued column. This will generally be an expression
      giving a URL or filename that is different for each row of the
      input table. If table loading fails for the given location,
      for instance becase the file is not found or an HTTP 404
      response is received, the array cells in the corresponding row
      will be blank.

      The first non-blank table loaded defines the array columns to
      be added. If subsequent tables have a different structure (do
      not contain similar columns in a similar sequence) an error
      may result. If the external array tables are not all
      homogenous in this way, the acmd parameter can be used to
      filter them so that they are.

   cache = true|false       (Boolean)
      Determines whether the array data will be cached the first
      time an array table is read (true) or re-read from the array
      table every time the row is accessed (false). Since the row
      construction may be an expensive step, especially if the
      tables are downloaded, it usually makes sense to set this true
      (the default). When true it also enables the metadata to be
      adjusted to report constant array length where applicable,
      which cannot be done before all the rows have been scanned,
      and which may enable more efficient file output. However, if
      you want to stream the data you can set it false.

      [Default: true]

   fixcols = none|dups|all       
   (uk.ac.starlink.ttools.task.JoinFixActionParameter$Fixer)
      Determines how input columns are renamed before use in the
      output table. The choices are:

       * none: columns are not renamed
       * dups: columns which would otherwise have duplicate names in
            the output will be renamed to indicate which table they
            came from
       * all: all columns will be renamed to indicate which table
            they came from

      If columns are renamed, the new ones are determined by
      suffix* parameters.

      [Default: dups]

   suffixarray = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from the array tables.

      [Default: _a]
'''
    task = _stilts.getTaskFactory().createObject('arrayjoin')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def calc(expression, **kwargs):
    '''\
Evaluates expressions.

The return value is the output string.

Parameters:

   expression = <expr>       (String)
      An expression to evaluate. The functions in SUN/256 can be
      used.

   table = <table>       (uk.ac.starlink.table.StarTable)
      Input table.
'''
    task = _stilts.getTaskFactory().createObject('calc')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment(grab_output=True)
    env.setValue('expression', _map_env_value(expression))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()
    txt = env.getOutputText()
    return str(txt.strip())

def cdsskymatch(in_, **kwargs):
    '''\
Crossmatches table on sky position against VizieR/SIMBAD table.

The return value is the resulting table.

Parameters:

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   ra = <expr>       (String)
      Right ascension in degrees in the ICRS coordinate system for
      the position of each row of the input table. This may simply
      be a column name, or it may be an algebraic expression
      calculated from columns as explained in SUN/256. If left
      blank, an attempt is made to guess from UCDs, column names and
      unit annotations what expression to use.

   dec = <expr>       (String)
      Declination in degrees in the ICRS coordinate system for the
      position of each row of the input table. This may simply be a
      column name, or it may be an algebraic expression calculated
      from columns as explained in SUN/256. If left blank, an
      attempt is made to guess from UCDs, column names and unit
      annotations what expression to use.

   radius = <value/arcsec>       (Double)
      Maximum distance from the local table (ra,dec) position at
      which counterparts from the remote table will be identified.
      This is a fixed value given in arcseconds, and must be in the
      range [0,180] (this limit is currently enforced by the CDS
      Xmatch service).

   cdstable = <value>       (String)
      Identifier of the table from the CDS crossmatch service that
      is to be matched against the local table. This identifier may
      be the standard VizieR identifier (e.g. "II/246/out" for the
      2MASS Point Source Catalogue) or "simbad" to indicate SIMBAD
      data.

      See for instance the TAPVizieR table searching facility at
      http://tapvizier.u-strasbg.fr/adql/ to find VizieR catalogue
      identifiers.

   find = all|best|best-remote|each|each-dist       
   (uk.ac.starlink.ttools.task.UserFindMode)
      Determines which pair matches are included in the result.

       * all: All matches
       * best: Matched rows, best remote row for each input row
       * best-remote: Matched rows, best input row for each remote
            row
       * each: One row per input row, contains best remote match or
            blank
       * each-dist: One row per input row, column giving distance
            only for best match

      Note only the all mode is symmetric between the two tables.

      Note also that there is a bug in best-remote matching. If the
      match is done in multiple blocks, it's possible for a remote
      table row to appear matched against one local table row per
      uploaded block, rather than just once for the whole result. If
      you're worried about that, set blocksize >=rowCount. This may
      be fixed in a future release.

      [Default: all]

   blocksize = <int-value>       (Integer)
      The CDS Xmatch service operates limits on the maximum number
      of rows that can be uploaded and the maximum number of rows
      that is returned as a result from a single query. In the case
      of large input tables, they are broken down into smaller
      blocks, and one request is sent to the external service for
      each block. This parameter controls the number of rows in each
      block. For an input table with fewer rows than this value, the
      whole thing is done as a single request.

      At time of writing, the maximum upload size is 100Mb (about
      3Mrow; this does not depend on the width of your table), and
      the maximum return size is 2Mrow.

      Large blocksizes tend to be good (up to a point) for reducing
      the total amount of time a large xmatch operation takes, but
      they can make it harder to see the job progressing. There is
      also the danger (for ALL-type find modes) of exceeding the
      return size limit, which will result in truncation of the
      returned result.

      [Default: 50000]

   maxrec = <int-value>       (Integer)
      Limit to the number of rows resulting from this operation. If
      the value is negative (the default) no limit is imposed. Note
      however that there can be truncation of the result if the
      number of records returned from a single chunk exceeds the
      service hard limit (2,000,000 at time of writing).

      [Default: -1]

   compress = true|false       (Boolean)
      If true, the service is requested to provide HTTP-level
      compression for the response stream (Accept-Encoding header is
      set to "gzip", see RFC 2616). This does not guarantee that
      compression will happen but if the service honours this
      request it may result in a smaller amount of network traffic
      at the expense of more processing on the server and client.

      [Default: true]

   serviceurl = <url-value>       (java.net.URL)
      The URL at which the CDS Xmatch service can be found. Normally
      this should not be altered from the default, but if other
      implementations of the same service are known, this parameter
      can be used to access them.

      [Default: http://cdsxmatch.u-strasbg.fr/xmatch/api/v1/sync]

   usemoc = true|false       (Boolean)
      If true, first acquire a MOC coverage map from CDS, and use
      that to pre-filter rows before uploading them for matching.
      This should improve efficiency, but have no effect on the
      result.

      [Default: true]

   presort = true|false       (Boolean)
      If true, the rows are sorted by HEALPix index before they are
      uploaded to the CDS X-Match service. If the match is done in
      multiple blocks, this may improve efficiency, since when
      matching against a large remote catalogue the X-Match service
      likes to process requests in which sources are grouped into a
      small region rather than scattered all over the sky.

      Note this will have a couple of other side effects that may be
      undesirable: it will read all the input rows into the task at
      once, which may make it harder to assess progress, and it will
      affect the order of the rows in the output table.

      It is probably only worth setting true for rather large
      (multi-million-row?) multi-block matches, where both local and
      remote catalogues are spread over a significant fraction of
      the sky. But feel free to experiment.

      [Default: false]

   fixcols = none|dups|all       
   (uk.ac.starlink.ttools.task.JoinFixActionParameter$Fixer)
      Determines how input columns are renamed before use in the
      output table. The choices are:

       * none: columns are not renamed
       * dups: columns which would otherwise have duplicate names in
            the output will be renamed to indicate which table they
            came from
       * all: all columns will be renamed to indicate which table
            they came from

      If columns are renamed, the new ones are determined by
      suffix* parameters.

      [Default: dups]

   suffixin = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from the input table.

      [Default: _in]

   suffixremote = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from the CDS result table.

      [Default: _cds]
'''
    task = _stilts.getTaskFactory().createObject('cdsskymatch')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def cone(**kwargs):
    '''\
Executes a Cone Search-like query.

The return value is the resulting table.

Parameters:

   serviceurl = <url-value>       (java.net.URL)
      The base part of a URL which defines the query to be made.
      Additional parameters will be appended to this using CGI
      syntax ("name=value", separated by '&' characters). If this
      value does not end in either a '?' or a '&', one will be added
      as appropriate.

   lon = <degrees>       (Double)
      Central longitude position for cone search. By default this is
      the Right Ascension, but depending on the value of the skysys
      parameter it may be in a different sky system.

   lat = <degrees>       (Double)
      Central latitude position for cone search. By default this is
      the Declination, but depending on the value of the skysys
      parameter it may be in a different sky system.

   radius = <degrees>       (Double)
      Search radius in degrees.

   skysys = icrs|fk5|fk4|galactic|supergalactic|ecliptic       
   (uk.ac.starlink.ttools.convert.SkySystem)
      Sky coordinate system used to interpret the lon and lat
      parameters. If the value is ICRS (the default) the provided
      values are assumed to be Right Ascension and Declination and
      are sent unchanged; for other values they will be converted
      from the named system into RA and Dec first.

      [Default: icrs]

   servicetype = cone|ssa|sia1|sia2|sia       (ServiceType)
      Selects the type of data access service to contact. Most
      commonly this will be the Cone Search service itself, but
      there are one or two other possibilities:

       * cone: Cone Search protocol - returns a table of objects
            found near each location. See Cone Search standard.
       * ssa: Simple Spectral Access protocol - returns a table of
            spectra near each location. See SSA standard.
       * sia1: Simple Image Access protocol version 1 - returns a
            table of images near each location. See SIA 1.0 standard
            .
       * sia2: Simple Image Access protocol version 2 - returns a
            table of images near each location. See SIA 2.0 standard
            .
       * sia: alias for sia1

      [Default: cone]

   verb = 1|2|3       (String)
      Verbosity level of the tables returned by the query service. A
      value of 1 indicates the bare minimum and 3 indicates all
      available information.

   compress = true|false       (Boolean)
      If true, the service is requested to provide HTTP-level
      compression for the response stream (Accept-Encoding header is
      set to "gzip", see RFC 2616). This does not guarantee that
      compression will happen but if the service honours this
      request it may result in a smaller amount of network traffic
      at the expense of more processing on the server and client.

      [Default: true]

   dataformat = <value>       (String)
      Indicates the format of data objects described in the returned
      table. The meaning of this is dependent on the value of the
      servicetype parameter:

       * servicetype=cone: not used
       * servicetype=ssa: gives the MIME type of spectra referenced
            in the output table, also special values "votable", "
            fits", "compliant", "graphic", "all", and others (value
            of the SSA FORMAT parameter).
       * servicetype=sia1: gives the MIME type required for
            images/resources referenced in the output table,
            corresponding to the SIA FORMAT parameter. The special
            values "GRAPHIC" (all graphics formats) and "ALL" (no
            restriction) as defined by SIAv1 are also permissible.
            For SIA version 1 only, this defaults to"image/fits".
       * servicetype=sia2: gives the MIME type required for
            images/resources referenced in the output table,
            corresponding to the SIA FORMAT parameter. The special
            values "GRAPHIC" (all graphics formats) and "ALL" (no
            restriction) as defined by SIAv1 are also permissible.
       * servicetype=sia: gives the MIME type required for
            images/resources referenced in the output table,
            corresponding to the SIA FORMAT parameter. The special
            values "GRAPHIC" (all graphics formats) and "ALL" (no
            restriction) as defined by SIAv1 are also permissible.
            For SIA version 1 only, this defaults to"image/fits".
'''
    task = _stilts.getTaskFactory().createObject('cone')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def coneskymatch(in_, **kwargs):
    '''\
Crossmatches table on sky position against remote cone service.

The return value is the resulting table.

Parameters:

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   ra = <expr>       (String)
      Right ascension in degrees in the ICRS coordinate system for
      the position of each row of the input table. This may simply
      be a column name, or it may be an algebraic expression
      calculated from columns as explained in SUN/256. If left
      blank, an attempt is made to guess from UCDs, column names and
      unit annotations what expression to use.

   dec = <expr>       (String)
      Declination in degrees in the ICRS coordinate system for the
      position of each row of the input table. This may simply be a
      column name, or it may be an algebraic expression calculated
      from columns as explained in SUN/256. If left blank, an
      attempt is made to guess from UCDs, column names and unit
      annotations what expression to use.

   sr = <expr/deg>       (String)
      Expression which evaluates to the search radius in degrees for
      the request at each row of the input table. This will often be
      a constant numerical value, but may be the name or ID of a
      column in the input table, or a function involving one.

   find = best|all|each       (String)
      Determines which matches are retained.

       * best: Only the matching query table row closest to the
            input table row will be output. Input table rows with no
            matches will be omitted. (Note this corresponds to the
            best1 option in the pair matching commands, and best1 is
            a permitted alias).
       * all: All query table rows which match the input table row
            will be output. Input table rows with no matches will be
            omitted.
       * each: There will be one output table row for each input
            table row. If matches are found, the closest one from
            the query table will be output, and in the case of no
            matches, the query table columns will be blank.

      [Default: all]

   usefoot = true|false       (Boolean)
      Determines whether an attempt will be made to restrict
      searches in accordance with available footprint information.
      If this is set true, then before any of the per-row queries
      are performed, an attempt may be made to acquire footprint
      information about the servce. If such information can be
      obtained, then queries which fall outside the footprint, and
      hence which are known to yield no results, are skipped. This
      can speed up the search considerably.

      Currently, the only footprints available are those provided by
      the CDS MOC (Multi-Order Coverage map) service, which covers
      VizieR and a few other cone search services.

      [Default: true]

   footnside = <int-value>       (Integer)
      Determines the HEALPix Nside parameter for use with the MOC
      footprint service. This tuning parameter determines the
      resolution of the footprint if available. Larger values give
      better resolution, hence a better chance of avoiding
      unnecessary queries, but processing them takes longer and
      retrieving and storing them is more expensive.

      The value must be a power of 2, and at the time of writing,
      the MOC service will not supply footprints at resolutions
      greater than nside=512, so it should be <=512.

      Only used if usefoot=true.

   copycols = <colid-list>       (String)
      List of columns from the input table which are to be copied to
      the output table. Each column identified here will be
      prepended to the columns of the combined output table, and its
      value for each row taken from the input table row which
      provided the parameters of the query which produced it. See
      SUN/256 for list syntax. The default setting is "*", which
      means that all columns from the input table are included in
      the output.

      [Default: *]

   scorecol = <col-name>       (String)
      Gives the name of a column in the output table to contain the
      distance between the requested central position and the actual
      position of the returned row. The distance returned is an
      angular distance in degrees. If a null value is chosen, no
      distance column will appear in the output table.

      [Default: Separation]

   parallel = <n>       (Integer)
      Allows multiple cone searches to be performed concurrently. If
      set to the default value, 1, the cone query corresponding to
      the first row of the input table will be dispatched, when that
      is completed the query corresponding to the second row will be
      dispatched, and so on. If set to <n>, then queries will be
      overlapped in such a way that up to approximately <n> may be
      running at any one time.

      Whether increasing <n> is a good idea, and what might be a
      sensible maximum value, depends on the characteristics of the
      service being queried. In particular, setting it to too large
      a number may overload the service resulting in some
      combination of failed queries, ultimately slower runtimes, and
      unpopularity with server admins.

      The maximum value permitted for this parameter by default is
      5. This limit may be raised by use of the service.maxparallel
      system property but use that option with great care since you
      may overload services and make yourself unpopular with data
      centre admins. As a rule, you should only increase this value
      if you have obtained permission from the data centres whose
      services on which you will be using the increased parallelism.

      [Default: 1]

   erract = abort|ignore|retry|retry<n>       
   (uk.ac.starlink.ttools.cone.ConeErrorPolicy)
      Determines what will happen if any of the individual cone
      search requests fails. By default the task aborts. That may be
      the best thing to do, but for unreliable or poorly implemented
      services you may find that some searches fail and others
      succeed so it can be best to continue operation in the face of
      a few failures. The options are:

       * abort: Failure of any query terminates the task.
       * ignore: Failure of a query is treated the same as a query
            which returns no rows.
       * retry: Failed queries are retried until they succeed; an
            increasing delay is introduced for each failure. Use
            with care - if the failure is for some good, or at least
            reproducible reason this could prevent the task from
            ever completing.
       * retry<n>: Failed queries are retried at most a fixed number
            <n> of times; an increasing delay is introduced for each
            failure. If failures persist the task terminates.

      [Default: abort]

   ostream = true|false       (Boolean)
      If set true, this will cause the operation to stream on
      output, so that the output table is built up as the results
      are obtained from the cone search service. The disadvantage of
      this is that some output modes and formats need multiple
      passes through the data to work, so depending on the output
      destination, the operation may fail if this is set. Use with
      care (or be prepared for the operation to fail).

      [Default: false]

   fixcols = none|dups|all       
   (uk.ac.starlink.ttools.task.JoinFixActionParameter$Fixer)
      Determines how input columns are renamed before use in the
      output table. The choices are:

       * none: columns are not renamed
       * dups: columns which would otherwise have duplicate names in
            the output will be renamed to indicate which table they
            came from
       * all: all columns will be renamed to indicate which table
            they came from

      If columns are renamed, the new ones are determined by
      suffix* parameters.

      [Default: dups]

   suffix0 = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from the input table.

      [Default: _0]

   suffix1 = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from the cone result table.

      [Default: _1]

   servicetype = cone|ssa|sia1|sia2|sia       (ServiceType)
      Selects the type of data access service to contact. Most
      commonly this will be the Cone Search service itself, but
      there are one or two other possibilities:

       * cone: Cone Search protocol - returns a table of objects
            found near each location. See Cone Search standard.
       * ssa: Simple Spectral Access protocol - returns a table of
            spectra near each location. See SSA standard.
       * sia1: Simple Image Access protocol version 1 - returns a
            table of images near each location. See SIA 1.0 standard
            .
       * sia2: Simple Image Access protocol version 2 - returns a
            table of images near each location. See SIA 2.0 standard
            .
       * sia: alias for sia1

      [Default: cone]

   serviceurl = <url-value>       (java.net.URL)
      The base part of a URL which defines the queries to be made.
      Additional parameters will be appended to this using CGI
      syntax ("name=value", separated by '&' characters). If this
      value does not end in either a '?' or a '&', one will be added
      as appropriate.

      See SUN/256 for discussion of how to locate service URLs
      corresponding to given datasets.

   verb = 1|2|3       (String)
      Verbosity level of the tables returned by the query service. A
      value of 1 indicates the bare minimum and 3 indicates all
      available information.

   dataformat = <value>       (String)
      Indicates the format of data objects described in the returned
      table. The meaning of this is dependent on the value of the
      servicetype parameter:

       * servicetype=cone: not used
       * servicetype=ssa: gives the MIME type of spectra referenced
            in the output table, also special values "votable", "
            fits", "compliant", "graphic", "all", and others (value
            of the SSA FORMAT parameter).
       * servicetype=sia1: gives the MIME type required for
            images/resources referenced in the output table,
            corresponding to the SIA FORMAT parameter. The special
            values "GRAPHIC" (all graphics formats) and "ALL" (no
            restriction) as defined by SIAv1 are also permissible.
            For SIA version 1 only, this defaults to "image/fits".
       * servicetype=sia2: gives the MIME type required for
            images/resources referenced in the output table,
            corresponding to the SIA FORMAT parameter. The special
            values "GRAPHIC" (all graphics formats) and "ALL" (no
            restriction) as defined by SIAv1 are also permissible.
       * servicetype=sia: gives the MIME type required for
            images/resources referenced in the output table,
            corresponding to the SIA FORMAT parameter. The special
            values "GRAPHIC" (all graphics formats) and "ALL" (no
            restriction) as defined by SIAv1 are also permissible.
            For SIA version 1 only, this defaults to "image/fits".

   emptyok = true|false       (Boolean)
      Whether the table metadata which is returned from a search
      result with zero rows is to be believed. According to the
      spirit, though not the letter, of the cone search standard, a
      cone search service which returns no data ought nevertheless
      to return the correct column headings. Unfortunately this is
      not always the case. If this parameter is set true, it is
      assumed that the service behaves properly in this respect; if
      it does not an error may result. In that case, set this
      parameter false. A consequence of setting it false is that in
      the event of no results being returned, the task will return
      no table at all, rather than an empty one.

      [Default: true]

   compress = true|false       (Boolean)
      If true, the service is requested to provide HTTP-level
      compression for the response stream (Accept-Encoding header is
      set to "gzip", see RFC 2616). This does not guarantee that
      compression will happen but if the service honours this
      request it may result in a smaller amount of network traffic
      at the expense of more processing on the server and client.

      [Default: true]
'''
    task = _stilts.getTaskFactory().createObject('coneskymatch')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def datalinklint(votable, **kwargs):
    '''\
Validates DataLink documents.

Parameters:

   votable = <filename>|<URL>|-       (String)
      Location of the DataLink VOTable document to check. This may
      be a URL, or a filename, or the special value "-" to indicate
      standard input.

   format = text|json       
   (uk.ac.starlink.ttools.taplint.OutputReporter)
      Determines the format of the output. Possible values are text
      , json.

      Note not all of the other parameters may be applicable to all
      output formats.

      [Default: text]

   report = [EWISF]+       (String)
      Letters indicating which message types should be listed. Each
      character of the string is one of the letters E, W, I, S, F
      with the following meanings:

       * E: Error in operation or standard compliance of the
            service.
       * W: Warning that service behaviour is questionable, or
            contravenes a standard recommendation, but is not in
            actual violation of the standard.
       * I: Information about progress, for instance details of
            queries made.
       * S: Summary of previous successful/unsuccessful reports.
       * F: Failure of the validator to perform some testing. The
            cause is either some error internal to the validator, or
            some error or missing functionality in the service which
            has already been reported.

      [Default: EWISF]

   maxrepeat = <int-value>       (Integer)
      Puts a limit on the number of times that a single message will
      be repeated. By setting this to some reasonably small number,
      you can ensure that the output does not get cluttered up by
      millions of repetitions of essentially the same error.

      [Default: 9]

   truncate = <int-value>       (Integer)
      Limits the line length written to the output.

      [Default: 640]

   debug = true|false       (Boolean)
      If true, debugging output including stack traces will be
      output along with the normal validation messages.

      [Default: false]
'''
    task = _stilts.getTaskFactory().createObject('datalinklint')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('votable', _map_env_value(votable))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def funcs(**kwargs):
    '''\
Browses functions used by algebraic expression language.
'''
    task = _stilts.getTaskFactory().createObject('funcs')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def pixfoot(in_, **kwargs):
    '''\
Generates Multi-Order Coverage maps.

Parameters:

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   order = <int-value>       (Integer)
      Maximum HEALPix order for the MOC. This defines the maximum
      resolution of the output coverage map. The angular resolution
      corresponding to order k is approximately 180/sqrt(3.Pi)/2^k
      (3520*2^-k arcmin).

      [Default: 13]

   ra = <expr>       (String)
      Right ascension in degrees for the position of each row of the
      input table. This may simply be a column name, or it may be an
      algebraic expression calculated from columns as explained in
      SUN/256. If left blank, an attempt is made to guess from UCDs,
      column names and unit annotations what expression to use.

   dec = <expr>       (String)
      Declination in degrees for the position of each row of the
      input table. This may simply be a column name, or it may be an
      algebraic expression calculated from columns as explained in
      SUN/256. If left blank, an attempt is made to guess from UCDs,
      column names and unit annotations what expression to use.

   radius = <expr>       (String)
      Expression which evaluates to the radius in degrees of the
      cone at each row of the input table. The default is "0", which
      treats each position as a point rather than a cone, but a
      constant or an expression as described in SUN/256 may be used
      instead.

      [Default: 0]

   mocfmt = fits|json       (uk.ac.starlink.ttools.cone.MocFormat)
      Determines the output format for the MOC file.

      [Default: fits]

   out = <out-file>       (uk.ac.starlink.util.Destination)
      The location of the output file. This is usually a filename to
      write to. If it is equal to the special value "-" the output
      will be written to standard output.

      [Default: -]
'''
    task = _stilts.getTaskFactory().createObject('pixfoot')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def pixsample(in_, **kwargs):
    '''\
Samples from a HEALPix pixel data file.

The return value is the resulting table.

Parameters:

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   pixdata = <pix-table>       (uk.ac.starlink.table.StarTable)
      Input table.

   pixorder = nested|ring|(auto)       (HealpixScheme)
      Selects the pixel ordering scheme used by the pixel data file.
      There are two different ways of ordering pixels in a HEALPix
      file, "ring" and "nested", and the sampler needs to know which
      one is in use. If you know which is in use, choose the
      appropriate value for this parameter; if (auto) is used it
      will attempt to work it out from headers in the file (the
      ORDERING header). If no reliable ordering scheme can be
      determined, the command will fail with an error.

      [Default: (auto)]

   stat = point|mean       
   (uk.ac.starlink.ttools.task.PixSampler$StatMode)
      Determines how the pixel values will be sampled to generate an
      output value. The options are:

       * point: Uses the value at the pixel covering the supplied
            position. In this case the radius parameter is not used.
       * mean: Averages the values over all the pixels within a
            radius given by the radius parameter. This averaging is
            somewhat approximate; all pixels which are mostly within
            the radius are averaged with equal weights.

      [Default: point]

   lon = <expr>       (String)
      Expression which evaluates to the longitude coordinate in
      degrees in the input table at which positions are to be
      sampled from the pixel data table. This will usually be the
      name or ID of a column in the input table, or an expression
      involving one. If this coordinate does not match the
      coordinate system used by the pixel data table, both
      coordinate systems must be set using the insys and pixsys
      parameters.

   lat = <expr>       (String)
      Expression which evaluates to the latitude coordinate in
      degrees in the input table at which positions are to be
      sampled from the pixel data table. This will usually be the
      name or ID of a column in the input table, or an expression
      involving one. If this coordinate does not match the
      coordinate system used by the pixel data table, both
      coordinate systems must be set using the insys and pixsys
      parameters.

   insys = icrs|fk5|fk4|galactic|supergalactic|ecliptic       
   (uk.ac.starlink.ttools.convert.SkySystem)
      Specifies the sky coordinate system in which sample positions
      are provided by the lon/lat parameters. If the sample
      positions are given in the same coordinate system as that
      given by the pixel data table, both the insys and pixsys
      parameters may be set null.

      The available coordinate systems are:

       * icrs: ICRS (Right Ascension, Declination)
       * fk5: FK5 J2000.0 (Right Ascension, Declination)
       * fk4: FK4 B1950.0 (Right Ascension, Declination)
       * galactic: IAU 1958 Galactic (Longitude, Latitude)
       * supergalactic: de Vaucouleurs Supergalactic (Longitude,
            Latitude)
       * ecliptic: Ecliptic (Longitude, Latitude)

   pixsys = icrs|fk5|fk4|galactic|supergalactic|ecliptic       
   (uk.ac.starlink.ttools.convert.SkySystem)
      Specifies the sky coordinate system used for the HEALPix data
      in the pixdata file. If the sample positions are given in the
      same coordinate system as that given by the pixel data table,
      both the insys and pixsys parameters may be set null.

      The available coordinate systems are:

       * icrs: ICRS (Right Ascension, Declination)
       * fk5: FK5 J2000.0 (Right Ascension, Declination)
       * fk4: FK4 B1950.0 (Right Ascension, Declination)
       * galactic: IAU 1958 Galactic (Longitude, Latitude)
       * supergalactic: de Vaucouleurs Supergalactic (Longitude,
            Latitude)
       * ecliptic: Ecliptic (Longitude, Latitude)

   radius = <expr>       (String)
      Determines the radius in degrees over which pixels will be
      sampled to generate the output statistic in accordance with
      the value of the stat parameter. This will typically be a
      constant value, but it may be an algebraic expression based on
      columns from the input table.

      Not used if stat=point.
'''
    task = _stilts.getTaskFactory().createObject('pixsample')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def plot2d(**kwargs):
    '''\
Old-style 2D Scatter Plot.

Parameters:

   xpix = <int-value>       (Integer)
      The width of the output graphic in pixels.

      [Default: 400]

   ypix = <int-value>       (Integer)
      The height of the output graphic in pixels.

      [Default: 300]

   font = dialog|serif|...       (String)
      Determines the font that will be used for textual annotation
      of the plot, including axes etc. At least the following fonts
      will be available:

       * serif
       * sansserif
       * monospaced
       * dialog
       * dialoginput

      as well as a range of system-dependent fonts, possibly
      including

       * aakar
       * abyssinica_sil
       * ani
       * anjalioldlipi
       * bitstream_charter
       * c059
       * cantarell
       * cantarell_extra_bold
       * cantarell_light
       * cantarell_thin
       * century_schoolbook_l
       * chandas
       * chilanka
       * courier
       * courier_10_pitch
       * d050000l
       * dejavu_math_tex_gyre
       * dejavu_sans
       * dejavu_sans_condensed
       * dejavu_sans_light
       * dejavu_sans_mono
       * dejavu_serif
       * dejavu_serif_condensed
       * dingbats
       * ...

      [Default: dialog]

   fontsize = <int-value>       (Integer)
      Sets the font size used for plot annotations.

      [Default: 12]

   fontstyle = plain|bold|italic|bold-italic       (Integer)
      Gives a style in which the font is to be applied for plot
      annotations. Options are plain, bold, italic and bold-italic.

      [Default: plain]

   legend = true|false       (Boolean)
      Determines whether a legend showing which plotting style is
      used for each data set. Defaults to true if there is more than
      one set, false otherwise.

   title = <value>       (String)
      A one-line title to display at the top of the plot.

   omode = swing|out|cgi|discard|auto       
   (uk.ac.starlink.ttools.plottask.PaintMode)
      Determines how the drawn plot will be output, see SUN/256.

       * swing: Plot will be displayed in a window on the screen.
            This plot is "live"; it can be resized and (except for
            old-style plots) navigated around with mouse actions in
            the same way as plots in TOPCAT.
       * out: Plot will be written to a file given by out using the
            graphics format given by ofmt.
       * cgi: Plot will be written in a way suitable for CGI use
            direct from a web server. The output is in the graphics
            format given by ofmt, preceded by a suitable
            "Content-type" declaration.
       * discard: Plot is drawn, but discarded. There is no output.
       * auto: Behaves as swing or out mode depending on presence of
            out parameter

      [Default: auto]

   out = <out-file>       (uk.ac.starlink.util.Destination)
      The location of the output file. This is usually a filename to
      write to. If it is equal to the special value "-" the output
      will be written to standard output.

   ofmt = png|png-transp|gif|jpeg|pdf|svg|eps|eps-gzip       
   (uk.ac.starlink.ttools.plot.GraphicExporter)
      Graphics format in which the plot is written to the output
      file, see SUN/256. One of:

       * png: PNG
       * png-transp: PNG with transparent background
       * gif: GIF
       * jpeg: JPEG
       * pdf: Portable Document Format
       * svg: Scalable Vector Graphics
       * eps: Encapsulated PostScript
       * eps-gzip: Gzipped Encapsulated PostScript

      May default to a sensible value depending on the filename
      given by out.

   inN = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   xdataN = <expr>       (String)
      Gives a column name or expression for the x axis data for
      table N. The expression is a numeric algebraic expression
      based on column names as described in SUN/256

   ydataN = <expr>       (String)
      Gives a column name or expression for the y axis data for
      table N. The expression is a numeric algebraic expression
      based on column names as described in SUN/256

   auxdataN = <expr>       (String)
      Gives a column name or expression for the aux axis data for
      table N. The expression is a numeric algebraic expression
      based on column names as described in SUN/256

   xlo = <float-value>       (Double)
      The lower limit for the plotted x axis. If not set, a value
      will be chosen which is low enough to accommodate all the
      data.

   ylo = <float-value>       (Double)
      The lower limit for the plotted y axis. If not set, a value
      will be chosen which is low enough to accommodate all the
      data.

   auxlo = <float-value>       (Double)
      The lower limit for the plotted aux axis. If not set, a value
      will be chosen which is low enough to accommodate all the
      data.

   xhi = <float-value>       (Double)
      The upper limit for the plotted x axis. If not set, a value
      will be chosen which is high enough to accommodate all the
      data.

   yhi = <float-value>       (Double)
      The upper limit for the plotted y axis. If not set, a value
      will be chosen which is high enough to accommodate all the
      data.

   auxhi = <float-value>       (Double)
      The upper limit for the plotted aux axis. If not set, a value
      will be chosen which is high enough to accommodate all the
      data.

   xlog = true|false       (Boolean)
      If false (the default), the scale on the x axis is linear; if
      true it is logarithmic.

      [Default: false]

   ylog = true|false       (Boolean)
      If false (the default), the scale on the y axis is linear; if
      true it is logarithmic.

      [Default: false]

   auxlog = true|false       (Boolean)
      If false (the default), the scale on the aux axis is linear;
      if true it is logarithmic.

      [Default: false]

   xflip = true|false       (Boolean)
      If set true, the scale on the x axis will increase in the
      opposite sense from usual (e.g. right to left rather than left
      to right).

      [Default: false]

   yflip = true|false       (Boolean)
      If set true, the scale on the y axis will increase in the
      opposite sense from usual (e.g. right to left rather than left
      to right).

      [Default: false]

   auxflip = true|false       (Boolean)
      If set true, the scale on the aux axis will increase in the
      opposite sense from usual (e.g. right to left rather than left
      to right).

      [Default: false]

   xlabel = <value>       (String)
      Specifies a label to be used for annotating axis x. A default
      values based on the plotted data will be used if no value is
      supplied for this parameter.

   ylabel = <value>       (String)
      Specifies a label to be used for annotating axis y. A default
      values based on the plotted data will be used if no value is
      supplied for this parameter.

   auxlabel = <value>       (String)
      Specifies a label to be used for annotating axis aux. A
      default values based on the plotted data will be used if no
      value is supplied for this parameter.

   xerrorN = <expr>|[<lo-expr>],[<hi-expr>]       (String)
      Gives expressions for the errors on X coordinates for table N.
      The following forms are permitted:

       * <expr>: symmetric error value
       * <lo-expr>,<hi-expr>:distinct lower and upper error values
       * <lo-expr>,: lower error value only
       * ,<hi-expr>: upper error value only
       * null: no errors

      The expression in each case is a numeric algebraic expression
      based on column names as described in SUN/256.

   yerrorN = <expr>|[<lo-expr>],[<hi-expr>]       (String)
      Gives expressions for the errors on Y coordinates for table N.
      The following forms are permitted:

       * <expr>: symmetric error value
       * <lo-expr>,<hi-expr>:distinct lower and upper error values
       * <lo-expr>,: lower error value only
       * ,<hi-expr>: upper error value only
       * null: no errors

      The expression in each case is a numeric algebraic expression
      based on column names as described in SUN/256.

   auxshader = rainbow|pastel|...       
   (uk.ac.starlink.ttools.plot.Shader)
      Determines how data from auxiliary axes will be displayed.
      Generally this is some kind of colour ramp. These are the
      available colour fixing options:

       * rainbow
       * pastel
       * standard
       * heat
       * colour
       * hue
       * greyscale
       * red-blue

      and these are the available colour modifying options:

       * hsv_h
       * hsv_s
       * hsv_v
       * intensity
       * rgb_red
       * rgb_green
       * rgb_blue
       * yuv_y
       * yuv_u
       * yuv_v
       * transparency

      [Default: rainbow]

   txtlabelN = <value>       (String)
      Gives an expression which will label each plotted point. If
      given, the text (or number) resulting from evaluating the
      expression will be written near each point which is plotted.

   subsetNS = <expr>       (String)
      Gives the selection criterion for the subset labelled "NS".
      This is a boolean expression which may be the name of a
      boolean-valued column or any other boolean-valued expression.
      Rows for which the expression evaluates true will be included
      in the subset, and those for which it evaluates false will
      not.

   nameNS = <value>       (String)
      Provides a name to use for a subset with the symbolic label
      NS. This name will be used for display in the legend, if one
      is displayed.

   colourNS = <rrggbb>|red|blue|...       (java.awt.Color)
      Defines the colour of markers plotted. The value may be a
      6-digit hexadecimal number giving red, green and blue
      intensities, e.g. "ff00ff" for magenta. Alternatively it may
      be the name of one of the pre-defined colours. These are
      currently red, blue, green, grey, magenta, cyan, orange, pink,
      yellow, black and white.

      For most purposes, either the American or the British spelling
      is accepted for this parameter name.

   shapeNS = filled_circle|open_circle|...       
   (uk.ac.starlink.ttools.plot.MarkShape)
      Defines the shapes for the markers that are plotted in data
      set NS. The following shapes are available:

       * filled_circle
       * open_circle
       * cross
       * x
       * open_square
       * open_diamond
       * open_triangle_up
       * open_triangle_down
       * filled_square
       * filled_diamond
       * filled_triangle_up
       * filled_triangle_down

   sizeNS = <int-value>       (Integer)
      Defines the marker size in pixels for markers plotted in data
      set NS. If the value is negative, an attempt will be made to
      use a suitable size according to how many points there are to
      be plotted.

      [Default: -1]

   transparencyNS = <int-value>       (Integer)
      Determines the transparency of plotted markers for data set
      NS. A value of <n> means that opacity is only achieved (the
      background is only blotted out) when <n> pixels of this colour
      have been plotted on top of each other.

      The minimum value is 1, which means opaque markers.

   lineNS = DotToDot|LinearRegression       
   (uk.ac.starlink.ttools.plot.MarkStyle$Line)
      Determines what line if any will be plotted along with the
      data points. The options are:

       * null: No line is plotted.
       * DotToDot: Each point is joined to the next one in sequence
            by a straight line.
       * LinearRegression: A linear regression line is plotted based
            on all the points which are visible in the plot. Note
            that the regression coefficients take no account of
            points out of the visible range.

   linewidthNS = <int-value>       (Integer)
      Sets the line width in pixels for any lines drawn in data set
      NS.

      Only has an effect if the lineNS parameter is set to draw
      lines.

      [Default: 1]

   dashNS = dot|dash|...|<a,b,...>       (float[])
      Defines the dash style for any lines drawn in data set NS To
      generate a dashed line the value may be one of the named dash
      types:

       * dot
       * dash
       * longdash
       * dotdash

      or may be a comma-separated string of on/off length values
      such as "4,2,8,2". A null value indicates a solid line.

      Only has an effect if the lineNS parameter is set to draw
      lines.

   hideNS = true|false       (Boolean)
      Indicates whether the actual markers plotted for each point
      should be hidden. Normally this is false, but you may want to
      set it to true if the point positions are being revealed in
      some other way, for instance by error markers or lines drawn
      between them.

      [Default: false]

   errstyleNS = lines|capped_lines|...       
   (uk.ac.starlink.ttools.plot.ErrorRenderer)
      Defines the way in which error bars (or ellipses, or...) will
      be represented for data set NS if errors are being displayed.
      The following options are available:

       * none
       * lines
       * capped_lines
       * caps
       * arrows
       * ellipse
       * crosshair_ellipse
       * rectangle
       * crosshair_rectangle
       * filled_ellipse
       * filled_rectangle

      [Default: lines]

   grid = true|false       (Boolean)
      If true, grid lines are drawn on the plot. If false, they are
      absent.

      [Default: true]

   antialias = true|false       (Boolean)
      Controls whether lines are drawn using antialiasing, where
      applicable. If lines are drawn to a bitmapped-type graphics
      output format setting this parameter to true smooths the lines
      out by using gradations of colour for diagonal lines, and
      setting it false simply sets each pixel in the line to on or
      off. For vector-type graphics output formats, or for cases in
      which no diagonal lines are drawn, the setting of this
      parameter has no effect. Setting it true may slow the plot
      down slightly.

      [Default: true]

   sequence = <suffix>,<suffix>,...       (String[])
      Can be used to control the sequence in which different
      datasets and subsets are plotted. This will affect which
      symbols are plotted on top of, and so potentially obscure,
      which other ones. The value of this parameter is a
      comma-separated list of the "NS" suffixes which appear on the
      parameters which apply to subsets. The sets which are named
      will be plotted in order, so the first-named one will be at
      the bottom (most likely to be obscured). Note that if this
      parameter is supplied, then only those sets which are named
      will be plotted, so this parameter may also be used to
      restrict which plots appear (though it may not be the most
      efficient way of doing this). If no explicit value is supplied
      for this parameter, sets will be plotted in some sequence
      decided by STILTS (probably alphabetic by suffix).
'''
    task = _stilts.getTaskFactory().createObject('plot2d')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def plot3d(**kwargs):
    '''\
Old-style 3D Scatter Plot.

Parameters:

   xpix = <int-value>       (Integer)
      The width of the output graphic in pixels.

      [Default: 300]

   ypix = <int-value>       (Integer)
      The height of the output graphic in pixels.

      [Default: 300]

   font = dialog|serif|...       (String)
      Determines the font that will be used for textual annotation
      of the plot, including axes etc. At least the following fonts
      will be available:

       * serif
       * sansserif
       * monospaced
       * dialog
       * dialoginput

      as well as a range of system-dependent fonts, possibly
      including

       * aakar
       * abyssinica_sil
       * ani
       * anjalioldlipi
       * bitstream_charter
       * c059
       * cantarell
       * cantarell_extra_bold
       * cantarell_light
       * cantarell_thin
       * century_schoolbook_l
       * chandas
       * chilanka
       * courier
       * courier_10_pitch
       * d050000l
       * dejavu_math_tex_gyre
       * dejavu_sans
       * dejavu_sans_condensed
       * dejavu_sans_light
       * dejavu_sans_mono
       * dejavu_serif
       * dejavu_serif_condensed
       * dingbats
       * ...

      [Default: dialog]

   fontsize = <int-value>       (Integer)
      Sets the font size used for plot annotations.

      [Default: 12]

   fontstyle = plain|bold|italic|bold-italic       (Integer)
      Gives a style in which the font is to be applied for plot
      annotations. Options are plain, bold, italic and bold-italic.

      [Default: plain]

   legend = true|false       (Boolean)
      Determines whether a legend showing which plotting style is
      used for each data set. Defaults to true if there is more than
      one set, false otherwise.

   title = <value>       (String)
      A one-line title to display at the top of the plot.

   omode = swing|out|cgi|discard|auto       
   (uk.ac.starlink.ttools.plottask.PaintMode)
      Determines how the drawn plot will be output, see SUN/256.

       * swing: Plot will be displayed in a window on the screen.
            This plot is "live"; it can be resized and (except for
            old-style plots) navigated around with mouse actions in
            the same way as plots in TOPCAT.
       * out: Plot will be written to a file given by out using the
            graphics format given by ofmt.
       * cgi: Plot will be written in a way suitable for CGI use
            direct from a web server. The output is in the graphics
            format given by ofmt, preceded by a suitable
            "Content-type" declaration.
       * discard: Plot is drawn, but discarded. There is no output.
       * auto: Behaves as swing or out mode depending on presence of
            out parameter

      [Default: auto]

   out = <out-file>       (uk.ac.starlink.util.Destination)
      The location of the output file. This is usually a filename to
      write to. If it is equal to the special value "-" the output
      will be written to standard output.

   ofmt = png|png-transp|gif|jpeg|pdf|svg|eps|eps-gzip       
   (uk.ac.starlink.ttools.plot.GraphicExporter)
      Graphics format in which the plot is written to the output
      file, see SUN/256. One of:

       * png: PNG
       * png-transp: PNG with transparent background
       * gif: GIF
       * jpeg: JPEG
       * pdf: Portable Document Format
       * svg: Scalable Vector Graphics
       * eps: Encapsulated PostScript
       * eps-gzip: Gzipped Encapsulated PostScript

      May default to a sensible value depending on the filename
      given by out.

   inN = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   xdataN = <expr>       (String)
      Gives a column name or expression for the x axis data for
      table N. The expression is a numeric algebraic expression
      based on column names as described in SUN/256

   ydataN = <expr>       (String)
      Gives a column name or expression for the y axis data for
      table N. The expression is a numeric algebraic expression
      based on column names as described in SUN/256

   zdataN = <expr>       (String)
      Gives a column name or expression for the z axis data for
      table N. The expression is a numeric algebraic expression
      based on column names as described in SUN/256

   auxdataN = <expr>       (String)
      Gives a column name or expression for the aux axis data for
      table N. The expression is a numeric algebraic expression
      based on column names as described in SUN/256

   xlo = <float-value>       (Double)
      The lower limit for the plotted x axis. If not set, a value
      will be chosen which is low enough to accommodate all the
      data.

   ylo = <float-value>       (Double)
      The lower limit for the plotted y axis. If not set, a value
      will be chosen which is low enough to accommodate all the
      data.

   zlo = <float-value>       (Double)
      The lower limit for the plotted z axis. If not set, a value
      will be chosen which is low enough to accommodate all the
      data.

   auxlo = <float-value>       (Double)
      The lower limit for the plotted aux axis. If not set, a value
      will be chosen which is low enough to accommodate all the
      data.

   xhi = <float-value>       (Double)
      The upper limit for the plotted x axis. If not set, a value
      will be chosen which is high enough to accommodate all the
      data.

   yhi = <float-value>       (Double)
      The upper limit for the plotted y axis. If not set, a value
      will be chosen which is high enough to accommodate all the
      data.

   zhi = <float-value>       (Double)
      The upper limit for the plotted z axis. If not set, a value
      will be chosen which is high enough to accommodate all the
      data.

   auxhi = <float-value>       (Double)
      The upper limit for the plotted aux axis. If not set, a value
      will be chosen which is high enough to accommodate all the
      data.

   xlog = true|false       (Boolean)
      If false (the default), the scale on the x axis is linear; if
      true it is logarithmic.

      [Default: false]

   ylog = true|false       (Boolean)
      If false (the default), the scale on the y axis is linear; if
      true it is logarithmic.

      [Default: false]

   zlog = true|false       (Boolean)
      If false (the default), the scale on the z axis is linear; if
      true it is logarithmic.

      [Default: false]

   auxlog = true|false       (Boolean)
      If false (the default), the scale on the aux axis is linear;
      if true it is logarithmic.

      [Default: false]

   xflip = true|false       (Boolean)
      If set true, the scale on the x axis will increase in the
      opposite sense from usual (e.g. right to left rather than left
      to right).

      [Default: false]

   yflip = true|false       (Boolean)
      If set true, the scale on the y axis will increase in the
      opposite sense from usual (e.g. right to left rather than left
      to right).

      [Default: false]

   zflip = true|false       (Boolean)
      If set true, the scale on the z axis will increase in the
      opposite sense from usual (e.g. right to left rather than left
      to right).

      [Default: false]

   auxflip = true|false       (Boolean)
      If set true, the scale on the aux axis will increase in the
      opposite sense from usual (e.g. right to left rather than left
      to right).

      [Default: false]

   xlabel = <value>       (String)
      Specifies a label to be used for annotating axis x. A default
      values based on the plotted data will be used if no value is
      supplied for this parameter.

   ylabel = <value>       (String)
      Specifies a label to be used for annotating axis y. A default
      values based on the plotted data will be used if no value is
      supplied for this parameter.

   zlabel = <value>       (String)
      Specifies a label to be used for annotating axis z. A default
      values based on the plotted data will be used if no value is
      supplied for this parameter.

   auxlabel = <value>       (String)
      Specifies a label to be used for annotating axis aux. A
      default values based on the plotted data will be used if no
      value is supplied for this parameter.

   xerrorN = <expr>|[<lo-expr>],[<hi-expr>]       (String)
      Gives expressions for the errors on X coordinates for table N.
      The following forms are permitted:

       * <expr>: symmetric error value
       * <lo-expr>,<hi-expr>:distinct lower and upper error values
       * <lo-expr>,: lower error value only
       * ,<hi-expr>: upper error value only
       * null: no errors

      The expression in each case is a numeric algebraic expression
      based on column names as described in SUN/256.

   yerrorN = <expr>|[<lo-expr>],[<hi-expr>]       (String)
      Gives expressions for the errors on Y coordinates for table N.
      The following forms are permitted:

       * <expr>: symmetric error value
       * <lo-expr>,<hi-expr>:distinct lower and upper error values
       * <lo-expr>,: lower error value only
       * ,<hi-expr>: upper error value only
       * null: no errors

      The expression in each case is a numeric algebraic expression
      based on column names as described in SUN/256.

   zerrorN = <expr>|[<lo-expr>],[<hi-expr>]       (String)
      Gives expressions for the errors on Z coordinates for table N.
      The following forms are permitted:

       * <expr>: symmetric error value
       * <lo-expr>,<hi-expr>:distinct lower and upper error values
       * <lo-expr>,: lower error value only
       * ,<hi-expr>: upper error value only
       * null: no errors

      The expression in each case is a numeric algebraic expression
      based on column names as described in SUN/256.

   auxshader = rainbow|pastel|...       
   (uk.ac.starlink.ttools.plot.Shader)
      Determines how data from auxiliary axes will be displayed.
      Generally this is some kind of colour ramp. These are the
      available colour fixing options:

       * rainbow
       * pastel
       * standard
       * heat
       * colour
       * hue
       * greyscale
       * red-blue

      and these are the available colour modifying options:

       * hsv_h
       * hsv_s
       * hsv_v
       * intensity
       * rgb_red
       * rgb_green
       * rgb_blue
       * yuv_y
       * yuv_u
       * yuv_v
       * transparency

      [Default: rainbow]

   txtlabelN = <value>       (String)
      Gives an expression which will label each plotted point. If
      given, the text (or number) resulting from evaluating the
      expression will be written near each point which is plotted.

   subsetNS = <expr>       (String)
      Gives the selection criterion for the subset labelled "NS".
      This is a boolean expression which may be the name of a
      boolean-valued column or any other boolean-valued expression.
      Rows for which the expression evaluates true will be included
      in the subset, and those for which it evaluates false will
      not.

   nameNS = <value>       (String)
      Provides a name to use for a subset with the symbolic label
      NS. This name will be used for display in the legend, if one
      is displayed.

   colourNS = <rrggbb>|red|blue|...       (java.awt.Color)
      Defines the colour of markers plotted. The value may be a
      6-digit hexadecimal number giving red, green and blue
      intensities, e.g. "ff00ff" for magenta. Alternatively it may
      be the name of one of the pre-defined colours. These are
      currently red, blue, green, grey, magenta, cyan, orange, pink,
      yellow, black and white.

      For most purposes, either the American or the British spelling
      is accepted for this parameter name.

   shapeNS = filled_circle|open_circle|...       
   (uk.ac.starlink.ttools.plot.MarkShape)
      Defines the shapes for the markers that are plotted in data
      set NS. The following shapes are available:

       * filled_circle
       * open_circle
       * cross
       * x
       * open_square
       * open_diamond
       * open_triangle_up
       * open_triangle_down
       * filled_square
       * filled_diamond
       * filled_triangle_up
       * filled_triangle_down

   sizeNS = <int-value>       (Integer)
      Defines the marker size in pixels for markers plotted in data
      set NS. If the value is negative, an attempt will be made to
      use a suitable size according to how many points there are to
      be plotted.

      [Default: -1]

   transparencyNS = <int-value>       (Integer)
      Determines the transparency of plotted markers for data set
      NS. A value of <n> means that opacity is only achieved (the
      background is only blotted out) when <n> pixels of this colour
      have been plotted on top of each other.

      The minimum value is 1, which means opaque markers.

   lineNS = DotToDot|LinearRegression       
   (uk.ac.starlink.ttools.plot.MarkStyle$Line)
      Determines what line if any will be plotted along with the
      data points. The options are:

       * null: No line is plotted.
       * DotToDot: Each point is joined to the next one in sequence
            by a straight line.
       * LinearRegression: A linear regression line is plotted based
            on all the points which are visible in the plot. Note
            that the regression coefficients take no account of
            points out of the visible range.

   linewidthNS = <int-value>       (Integer)
      Sets the line width in pixels for any lines drawn in data set
      NS.

      Only has an effect if the lineNS parameter is set to draw
      lines.

      [Default: 1]

   dashNS = dot|dash|...|<a,b,...>       (float[])
      Defines the dash style for any lines drawn in data set NS To
      generate a dashed line the value may be one of the named dash
      types:

       * dot
       * dash
       * longdash
       * dotdash

      or may be a comma-separated string of on/off length values
      such as "4,2,8,2". A null value indicates a solid line.

      Only has an effect if the lineNS parameter is set to draw
      lines.

   hideNS = true|false       (Boolean)
      Indicates whether the actual markers plotted for each point
      should be hidden. Normally this is false, but you may want to
      set it to true if the point positions are being revealed in
      some other way, for instance by error markers or lines drawn
      between them.

      [Default: false]

   errstyleNS = lines|capped_lines|...       
   (uk.ac.starlink.ttools.plot.ErrorRenderer)
      Defines the way in which error bars (or ellipses, or...) will
      be represented for data set NS if errors are being displayed.
      The following options are available:

       * none
       * lines
       * capped_lines
       * caps
       * arrows
       * cuboid
       * ellipse
       * crosshair_ellipse
       * rectangle
       * crosshair_rectangle
       * filled_ellipse
       * filled_rectangle

      [Default: lines]

   grid = true|false       (Boolean)
      If true, grid lines are drawn on the plot. If false, they are
      absent.

      [Default: true]

   antialias = true|false       (Boolean)
      Controls whether lines are drawn using antialiasing, where
      applicable. If lines are drawn to a bitmapped-type graphics
      output format setting this parameter to true smooths the lines
      out by using gradations of colour for diagonal lines, and
      setting it false simply sets each pixel in the line to on or
      off. For vector-type graphics output formats, or for cases in
      which no diagonal lines are drawn, the setting of this
      parameter has no effect. Setting it true may slow the plot
      down slightly.

      [Default: true]

   sequence = <suffix>,<suffix>,...       (String[])
      Can be used to control the sequence in which different
      datasets and subsets are plotted. This will affect which
      symbols are plotted on top of, and so potentially obscure,
      which other ones. The value of this parameter is a
      comma-separated list of the "NS" suffixes which appear on the
      parameters which apply to subsets. The sets which are named
      will be plotted in order, so the first-named one will be at
      the bottom (most likely to be obscured). Note that if this
      parameter is supplied, then only those sets which are named
      will be plotted, so this parameter may also be used to
      restrict which plots appear (though it may not be the most
      efficient way of doing this). If no explicit value is supplied
      for this parameter, sets will be plotted in some sequence
      decided by STILTS (probably alphabetic by suffix).

   fog = <float-value>       (Double)
      Sets the level of fogging used to provide a visual indication
      of depth. Object plotted further away from the viewer appear
      more washed-out by a white fog. The default value gives a bit
      of fogging; increase it to make the fog thicker, or set to
      zero if no fogging is required.

      [Default: 1.0]

   phi = <float-value>       (Double)
      Angle in degrees through which the 3D plot is rotated abound
      the Z axis prior to drawing.

      [Default: 30.0]

   theta = <float-value>       (Double)
      Angle in degrees through which the 3D plot is rotated towards
      the viewer (i.e. about the horizontal axis of the viewing
      plane) prior to drawing.

      [Default: 15.0]
'''
    task = _stilts.getTaskFactory().createObject('plot3d')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def plothist(**kwargs):
    '''\
Old-style Histogram.

Parameters:

   xpix = <int-value>       (Integer)
      The width of the output graphic in pixels.

      [Default: 400]

   ypix = <int-value>       (Integer)
      The height of the output graphic in pixels.

      [Default: 300]

   font = dialog|serif|...       (String)
      Determines the font that will be used for textual annotation
      of the plot, including axes etc. At least the following fonts
      will be available:

       * serif
       * sansserif
       * monospaced
       * dialog
       * dialoginput

      as well as a range of system-dependent fonts, possibly
      including

       * aakar
       * abyssinica_sil
       * ani
       * anjalioldlipi
       * bitstream_charter
       * c059
       * cantarell
       * cantarell_extra_bold
       * cantarell_light
       * cantarell_thin
       * century_schoolbook_l
       * chandas
       * chilanka
       * courier
       * courier_10_pitch
       * d050000l
       * dejavu_math_tex_gyre
       * dejavu_sans
       * dejavu_sans_condensed
       * dejavu_sans_light
       * dejavu_sans_mono
       * dejavu_serif
       * dejavu_serif_condensed
       * dingbats
       * ...

      [Default: dialog]

   fontsize = <int-value>       (Integer)
      Sets the font size used for plot annotations.

      [Default: 12]

   fontstyle = plain|bold|italic|bold-italic       (Integer)
      Gives a style in which the font is to be applied for plot
      annotations. Options are plain, bold, italic and bold-italic.

      [Default: plain]

   legend = true|false       (Boolean)
      Determines whether a legend showing which plotting style is
      used for each data set. Defaults to true if there is more than
      one set, false otherwise.

   title = <value>       (String)
      A one-line title to display at the top of the plot.

   omode = swing|out|cgi|discard|auto       
   (uk.ac.starlink.ttools.plottask.PaintMode)
      Determines how the drawn plot will be output, see SUN/256.

       * swing: Plot will be displayed in a window on the screen.
            This plot is "live"; it can be resized and (except for
            old-style plots) navigated around with mouse actions in
            the same way as plots in TOPCAT.
       * out: Plot will be written to a file given by out using the
            graphics format given by ofmt.
       * cgi: Plot will be written in a way suitable for CGI use
            direct from a web server. The output is in the graphics
            format given by ofmt, preceded by a suitable
            "Content-type" declaration.
       * discard: Plot is drawn, but discarded. There is no output.
       * auto: Behaves as swing or out mode depending on presence of
            out parameter

      [Default: auto]

   out = <out-file>       (uk.ac.starlink.util.Destination)
      The location of the output file. This is usually a filename to
      write to. If it is equal to the special value "-" the output
      will be written to standard output.

   ofmt = png|png-transp|gif|jpeg|pdf|svg|eps|eps-gzip       
   (uk.ac.starlink.ttools.plot.GraphicExporter)
      Graphics format in which the plot is written to the output
      file, see SUN/256. One of:

       * png: PNG
       * png-transp: PNG with transparent background
       * gif: GIF
       * jpeg: JPEG
       * pdf: Portable Document Format
       * svg: Scalable Vector Graphics
       * eps: Encapsulated PostScript
       * eps-gzip: Gzipped Encapsulated PostScript

      May default to a sensible value depending on the filename
      given by out.

   inN = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   xdataN = <expr>       (String)
      Gives a column name or expression for the x axis data for
      table N. The expression is a numeric algebraic expression
      based on column names as described in SUN/256

   xlo = <float-value>       (Double)
      The lower limit for the plotted x axis. If not set, a value
      will be chosen which is low enough to accommodate all the
      data.

   xhi = <float-value>       (Double)
      The upper limit for the plotted x axis. If not set, a value
      will be chosen which is high enough to accommodate all the
      data.

   xlog = true|false       (Boolean)
      If false (the default), the scale on the x axis is linear; if
      true it is logarithmic.

      [Default: false]

   xflip = true|false       (Boolean)
      If set true, the scale on the x axis will increase in the
      opposite sense from usual (e.g. right to left rather than left
      to right).

      [Default: false]

   xlabel = <value>       (String)
      Specifies a label to be used for annotating axis x. A default
      values based on the plotted data will be used if no value is
      supplied for this parameter.

   subsetNS = <expr>       (String)
      Gives the selection criterion for the subset labelled "NS".
      This is a boolean expression which may be the name of a
      boolean-valued column or any other boolean-valued expression.
      Rows for which the expression evaluates true will be included
      in the subset, and those for which it evaluates false will
      not.

   nameNS = <value>       (String)
      Provides a name to use for a subset with the symbolic label
      NS. This name will be used for display in the legend, if one
      is displayed.

   colourNS = <rrggbb>|red|blue|...       (java.awt.Color)
      Defines the colour of bars plotted for data set NS. The value
      may be a 6-digit hexadecimal number giving red, green and blue
      intensities, e.g. "ff00ff" for magenta. Alternatively it may
      be the name of one of the pre-defined colours. These are
      currently red, blue, green, grey, magenta, cyan, orange, pink,
      yellow, black and white.

      For most purposes, either the American or the British spelling
      is accepted for this parameter name.

   barstyleNS = fill|open|...       (BarShape)
      Defines how histogram bars will be drawn for dataset NS. The
      options are:

       * fill
       * open
       * tops
       * semi
       * semitops
       * spikes
       * fillover
       * openover

      [Default: fill]

   linewidthNS = <int-value>       (Integer)
      Defines the line width for lines drawn as part of the bars for
      dataset NS. Only certain bar styles are affected by the line
      width.

      [Default: 2]

   dashNS = dot|dash|...|<a,b,...>       (float[])
      Defines the dashing pattern for lines drawn for dataset NS. To
      generate a dashed line the value may be one of the named dash
      types:

       * dot
       * dash
       * longdash
       * dotdash

      or may be a comma-separated string of on/off length values
      such as "4,2,8,2". A null value indicates a solid line. Only
      certain bar styles are affected by the dash pattern.

   grid = true|false       (Boolean)
      If true, grid lines are drawn on the plot. If false, they are
      absent.

      [Default: true]

   antialias = true|false       (Boolean)
      Controls whether lines are drawn using antialiasing, where
      applicable. If lines are drawn to a bitmapped-type graphics
      output format setting this parameter to true smooths the lines
      out by using gradations of colour for diagonal lines, and
      setting it false simply sets each pixel in the line to on or
      off. For vector-type graphics output formats, or for cases in
      which no diagonal lines are drawn, the setting of this
      parameter has no effect. Setting it true may slow the plot
      down slightly.

      [Default: true]

   sequence = <suffix>,<suffix>,...       (String[])
      Can be used to control the sequence in which different
      datasets and subsets are plotted. This will affect which
      symbols are plotted on top of, and so potentially obscure,
      which other ones. The value of this parameter is a
      comma-separated list of the "NS" suffixes which appear on the
      parameters which apply to subsets. The sets which are named
      will be plotted in order, so the first-named one will be at
      the bottom (most likely to be obscured). Note that if this
      parameter is supplied, then only those sets which are named
      will be plotted, so this parameter may also be used to
      restrict which plots appear (though it may not be the most
      efficient way of doing this). If no explicit value is supplied
      for this parameter, sets will be plotted in some sequence
      decided by STILTS (probably alphabetic by suffix).

   ylo = <float-value>       (Double)
      Lower bound for Y axis.

      [Default: 0.0]

   yhi = <float-value>       (Double)
      Upper bound for Y axis. Autogenerated from the data if not
      supplied.

   ylog = true|false       (Boolean)
      Whether to use a logarithmic scale for the Y axis.

      [Default: false]

   ylabel = <value>       (String)
      Specifies a label for annotating the vertical axis. A default
      value based on the type of histogram will be used if no value
      is supplied for this parameter.

      [Default: Count]

   weightN = <value>       (String)
      Defines a weighting for each point accumulated to determine
      the height of plotted bars. If this parameter has a value
      other than 1 (the default) then instead of simply accumulating
      the number of points per bin to determine bar height, the bar
      height will be the sum over the weighting expression for the
      points in each bin. Note that with weighting, the figure drawn
      is no longer strictly speaking a histogram.

      When weighted, bars can be of negative height. An anomaly of
      the plot as currently implemented is that the Y axis never
      descends below zero, so any such bars are currently invisible.
      This may be amended in a future release (contact the author to
      lobby for such an amendment).

      [Default: 1]

   binwidth = <float-value>       (Double)
      Defines the width on the X axis of histogram bins. If the X
      axis is logarithmic, then this is a multiplicative value.

   norm = true|false       (Boolean)
      Determines whether bin counts are normalised. If true,
      histogram bars are scaled such that summed height of all bars
      over the whole dataset is equal to one. Otherwise (the
      default), no scaling is done.

      [Default: false]

   cumulative = true|false       (Boolean)
      Determines whether historams are cumulative. When false (the
      default), the height of each bar is determined by counting the
      number of points which fall into the range on the X axis that
      it covers. When true, the height is determined by counting all
      the points between negative infinity and the upper bound of
      the range on the X axis that it covers.

      [Default: false]

   binbase = <float-value>       (Double)
      Adjusts the offset of the bins. By default zero (or one for
      logarithmic X axis) is a boundary between bins; other
      boundaries are defined by this and the bin width. If this
      value is adjusted, the lower bound of one of the bins will be
      set to this value, so all the bins move along by the
      corresponding distance.

      [Default: 0.0]
'''
    task = _stilts.getTaskFactory().createObject('plothist')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def regquery(**kwargs):
    '''\
Queries the VO registry.

The return value is the resulting table.

Parameters:

   query = <value>       (String)
      Text of an ADQL WHERE clause targeted at the VOResource 1.0
      schema defining which resource records you wish to retrieve
      from the registry. Some examples are:

       * @xsi:type like '%Organisation%'
       * capability/@standardID = 'ivo://ivoa.net/std/ConeSearch'
            and title like '%SDSS%'
       * curation/publisher like 'CDS%' and title like '%galax%'

      A full description of ADQL syntax and of the VOResource schema
      is well beyond the scope of this documentation, but in general
      you want to use <field-name> like '<value>' where '%' is a
      wildcard character. Logical operators and and or and
      parentheses can be used to group and combine expressions. To
      work out the various <field-name>s you need to look at the
      VOResource 1.0 schema.

   regurl = <url-value>       (java.net.URL)
      The URL of a SOAP endpoint which provides a VOResource1.0 IVOA
      registry service. Some known suitable registry endpoints at
      time of writing are

       *
            http://registry.astrogrid.org/astrogrid-registry/services/RegistryQueryv1_0
       * http://registry.euro-vo.org/services/RegistrySearch
       * http://vao.stsci.edu/directory/ristandardservice.asmx

      [Default:
      http://registry.astrogrid.org/astrogrid-registry/services/RegistryQueryv1_0
      ]

   soapout = <out-file>       (uk.ac.starlink.util.Destination)
      If set to a non-null value, this gives the destination for the
      text of the request and response SOAP messages. The special
      value "-" indicates standard output.
'''
    task = _stilts.getTaskFactory().createObject('regquery')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def server(**kwargs):
    '''\
Runs an HTTP server to perform STILTS commands.

Parameters:

   port = <int-value>       (Integer)
      Port number on which the server should run.

      [Default: 2112]

   basepath = <value>       (String)
      Base path on the server at which request URLs are rooted. The
      default is /stilts, which means that for instance requests to
      execute task plot2d should be directed to the URL
      http://host:portnum/stilts/task/plot2d?name=value&name=value...

      [Default: /stilts]

   tasks = <task-name> ...       (String)
      Gives a space-separated list of tasks which will be provided
      by the relevant endpoints of the running server. If the value
      is null then all tasks will be available. However, some tasks
      don't make a lot of sense to run from the server, so the
      default value is a somewhat restricted list. If the server is
      being exposed to external users, you might also want to reduce
      the list for security reasons. If you don't want any tasks
      made available, for instance if you want to run the plot
      service only, you can set this to the empty string.

      [Default: arrayjoin calc cdsskymatch cone coneskymatch
      datalinklint pixfoot pixsample plot2d plot3d plothist regquery
      sqlclient sqlskymatch sqlupdate taplint tapquery tapresume
      tapskymatch tcat tcatn tcopy tcube tgridmap tjoin tloop
      tmatch1 tmatch2 tmatchn tmulti tmultin tpipe tskymap
      tskymatch2 votcopy votlint xsdvalidate plot2plane plot2sky
      plot2cube plot2sphere plot2time]

   tablefactory = file|dirs:...|locator:...       
   (uk.ac.starlink.table.StarTableFactory)
      This parameter determines how input table names (typically the
      in parameter of table processing commands) are used to acquire
      references to actual table data. The default behaviour is for
      input table names to be treated as filenames, in conjunction
      with some file type parameter. While this is usually sensible
      for local use, in server situations it may be inappropriate,
      since you don't want external users to have read access to
      your entire filesystem.

      This parameter gives options for alternative ways of mapping
      table names to table data items. The currently available
      options are:

       * file: default behaviour - names are treated as filenames
       * dirs:<dir>:<dir>:...: following the "dirs:" prefix a list
            of directories is specified which will be searched for
            the file named. Note that the directory separator
            character differs between operating systems; it is a
            colon (":") for Unix-like OSs and a semi-colon (";") for
            MS Windows. If a given name is identical to the
            path-less filename in one of the <dir> directories, that
            file is used as the referenced table. File type
            information is ignored in this case, so the files must
            be one of the types which STILTS can autodetect,
            currently FITS or VOTable (FITS is more efficient). By
            using this option, clients can be restricted to using a
            fixed set of tables in a restricted part of the server's
            file system.
       * locator:<class-name>: the <class-name> must be the name of
            a Java class on the classpath which implements the
            interface uk.ac.starlink.ttools.task.TableLocator and
            which has a no-arg constructor. An instance of this
            class will be used to resolve names to tables.

      The usage and functionality of this parameter is experimental,
      and may change significantly in future releases.

      [Default: file]
'''
    task = _stilts.getTaskFactory().createObject('server')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def sqlclient(**kwargs):
    '''\
Executes SQL statements.

Parameters:

   db = <jdbc-url>       (java.sql.Connection)
      URL which defines a connection to a database. This has the
      form jdbc:<subprotocol>:<subname> - the details are database-
      and driver-dependent. Consult Sun's JDBC documentation and
      that for the particular JDBC driver you are using for details.
      Note that the relevant driver class will need to be on your
      classpath and referenced in the jdbc.drivers system property
      as well for the connection to be made.

   user = <value>       (String)
      User name for logging in to SQL database. Defaults to the
      current username.

      [Default: mbt]

   password = <value>       (String)
      Password for logging in to SQL database.

   sql = <sql>       (String)
      Text of an SQL statement for execution. This parameter may be
      repeated, or statements may be separated by semicolon (";")
      characters.
'''
    task = _stilts.getTaskFactory().createObject('sqlclient')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def sqlskymatch(in_, **kwargs):
    '''\
Crossmatches table on sky position against SQL table.

The return value is the resulting table.

Parameters:

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   ra = <expr>       (String)
      Right ascension in degrees in the coordinate system for the
      position of each row of the input table. This may simply be a
      column name, or it may be an algebraic expression calculated
      from columns as explained in SUN/256. If left blank, an
      attempt is made to guess from UCDs, column names and unit
      annotations what expression to use.

   dec = <expr>       (String)
      Declination in degrees in the coordinate system for the
      position of each row of the input table. This may simply be a
      column name, or it may be an algebraic expression calculated
      from columns as explained in SUN/256. If left blank, an
      attempt is made to guess from UCDs, column names and unit
      annotations what expression to use.

   sr = <expr/deg>       (String)
      Expression which evaluates to the search radius in degrees for
      the request at each row of the input table. This will often be
      a constant numerical value, but may be the name or ID of a
      column in the input table, or a function involving one.

   find = best|all|each       (String)
      Determines which matches are retained.

       * best: Only the matching query table row closest to the
            input table row will be output. Input table rows with no
            matches will be omitted. (Note this corresponds to the
            best1 option in the pair matching commands, and best1 is
            a permitted alias).
       * all: All query table rows which match the input table row
            will be output. Input table rows with no matches will be
            omitted.
       * each: There will be one output table row for each input
            table row. If matches are found, the closest one from
            the query table will be output, and in the case of no
            matches, the query table columns will be blank.

      [Default: all]

   usefoot = true|false       (Boolean)
      Determines whether an attempt will be made to restrict
      searches in accordance with available footprint information.
      If this is set true, then before any of the per-row queries
      are performed, an attempt may be made to acquire footprint
      information about the servce. If such information can be
      obtained, then queries which fall outside the footprint, and
      hence which are known to yield no results, are skipped. This
      can speed up the search considerably.

      Currently, the only footprints available are those provided by
      the CDS MOC (Multi-Order Coverage map) service, which covers
      VizieR and a few other cone search services.

      [Default: true]

   footnside = <int-value>       (Integer)
      Determines the HEALPix Nside parameter for use with the MOC
      footprint service. This tuning parameter determines the
      resolution of the footprint if available. Larger values give
      better resolution, hence a better chance of avoiding
      unnecessary queries, but processing them takes longer and
      retrieving and storing them is more expensive.

      The value must be a power of 2, and at the time of writing,
      the MOC service will not supply footprints at resolutions
      greater than nside=512, so it should be <=512.

      Only used if usefoot=true.

   copycols = <colid-list>       (String)
      List of columns from the input table which are to be copied to
      the output table. Each column identified here will be
      prepended to the columns of the combined output table, and its
      value for each row taken from the input table row which
      provided the parameters of the query which produced it. See
      SUN/256 for list syntax. The default setting is "*", which
      means that all columns from the input table are included in
      the output.

      [Default: *]

   scorecol = <col-name>       (String)
      Gives the name of a column in the output table to contain the
      distance between the requested central position and the actual
      position of the returned row. The distance returned is an
      angular distance in degrees. If a null value is chosen, no
      distance column will appear in the output table.

      [Default: Separation]

   erract = abort|ignore|retry|retry<n>       
   (uk.ac.starlink.ttools.cone.ConeErrorPolicy)
      Determines what will happen if any of the individual cone
      search requests fails. By default the task aborts. That may be
      the best thing to do, but for unreliable or poorly implemented
      services you may find that some searches fail and others
      succeed so it can be best to continue operation in the face of
      a few failures. The options are:

       * abort: Failure of any query terminates the task.
       * ignore: Failure of a query is treated the same as a query
            which returns no rows.
       * retry: Failed queries are retried until they succeed; an
            increasing delay is introduced for each failure. Use
            with care - if the failure is for some good, or at least
            reproducible reason this could prevent the task from
            ever completing.
       * retry<n>: Failed queries are retried at most a fixed number
            <n> of times; an increasing delay is introduced for each
            failure. If failures persist the task terminates.

      [Default: abort]

   ostream = true|false       (Boolean)
      If set true, this will cause the operation to stream on
      output, so that the output table is built up as the results
      are obtained from the cone search service. The disadvantage of
      this is that some output modes and formats need multiple
      passes through the data to work, so depending on the output
      destination, the operation may fail if this is set. Use with
      care (or be prepared for the operation to fail).

      [Default: false]

   fixcols = none|dups|all       
   (uk.ac.starlink.ttools.task.JoinFixActionParameter$Fixer)
      Determines how input columns are renamed before use in the
      output table. The choices are:

       * none: columns are not renamed
       * dups: columns which would otherwise have duplicate names in
            the output will be renamed to indicate which table they
            came from
       * all: all columns will be renamed to indicate which table
            they came from

      If columns are renamed, the new ones are determined by
      suffix* parameters.

      [Default: dups]

   suffix0 = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from the input table.

      [Default: _0]

   suffix1 = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from the cone result table.

      [Default: _1]

   db = <jdbc-url>       (java.sql.Connection)
      URL which defines a connection to a database. This has the
      form jdbc:<subprotocol>:<subname> - the details are database-
      and driver-dependent. Consult Sun's JDBC documentation and
      that for the particular JDBC driver you are using for details.
      Note that the relevant driver class will need to be on your
      classpath and referenced in the jdbc.drivers system property
      as well for the connection to be made.

   user = <value>       (String)
      User name for logging in to SQL database. Defaults to the
      current username.

      [Default: mbt]

   password = <value>       (String)
      Password for logging in to SQL database.

   dbtable = <table-name>       (String)
      The name of the table in the SQL database which provides the
      remote data.

   dbra = <sql-col>       (String)
      The name of a column in the SQL database table dbtable which
      gives the right ascension. Units are given by dbunit.

   dbdec = <sql-col>       (String)
      The name of a column in the SQL database table dbtable which
      gives the declination. Units are given by dbunit.

   dbunit = deg|rad       (uk.ac.starlink.ttools.cone.AngleUnits)
      Units of the right ascension and declination columns
      identified in the database table. May be either deg[rees] (the
      default) or rad[ians].

      [Default: deg]

   tiling = hpx<K>|healpixnest<K>|healpixring<K>|htm<K>       
   (uk.ac.starlink.ttools.cone.SkyTiling)
      Describes the sky tiling scheme that is in use. One of the
      following values may be used:

       * hpxK: alias for healpixnestK
       * healpixnestK: HEALPix using the Nest scheme at order K
       * healpixringK: HEALPix using the Ring scheme at order K
       * htmK: Hierarchical Triangular Mesh at level K

      So for instance hpx5 or healpixnest5 would both indicate the
      HEALPix NEST tiling scheme at order 5.

      At level K, there are 12*4^K HEALPix pixels, or 8*4^K HTM
      pixels on the sky. More information about these tiling schemes
      can be found at the HEALPix and HTM web sites.

   dbtile = <sql-col>       (String)
      The name of a column in the SQL database table dbtable which
      contains a sky tiling pixel index. The tiling scheme is given
      by the tiling parameter. Use of a tiling column is optional,
      but if present (and if the column is indexed in the database
      table) it may serve to speed up searches. Set to null if the
      database table contains no tiling column or if you do not wish
      to use one.

   selectcols = <sql-cols>       (String)
      An SQL expression for the list of columns to be selected from
      the table in the database. A value of "*" retrieves all
      columns.

      [Default: *]

   where = <sql-condition>       (String)
      An SQL expression further limiting the rows to be selected
      from the database. This will be combined with the constraints
      on position implied by the cone search centres and radii. The
      value of this parameter should just be a condition, it should
      not contain the WHERE keyword. A null value indicates no
      additional criteria.

   preparesql = true|false       (Boolean)
      If true, the JDBC connection will use PreparedStatements for
      the SQL SELECTs otherwise it will use simple Statements. This
      is a tuning parameter and affects only performance. On some
      database/driver combinations it's a lot faster set false (the
      default); on others it may be faster, who knows?

      [Default: false]
'''
    task = _stilts.getTaskFactory().createObject('sqlskymatch')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def sqlupdate(**kwargs):
    '''\
Updates values in an SQL table.

Parameters:

   db = <jdbc-url>       (java.sql.Connection)
      URL which defines a connection to a database. This has the
      form jdbc:<subprotocol>:<subname> - the details are database-
      and driver-dependent. Consult Sun's JDBC documentation and
      that for the particular JDBC driver you are using for details.
      Note that the relevant driver class will need to be on your
      classpath and referenced in the jdbc.drivers system property
      as well for the connection to be made.

   user = <value>       (String)
      User name for logging in to SQL database. Defaults to the
      current username.

      [Default: mbt]

   password = <value>       (String)
      Password for logging in to SQL database.

   select = <select-stmt>       (String)
      Gives the full text (including "SELECT") of the SELECT
      statement to identify which rows undergo updates.

   assign = <col>=<expr>       (Assignment[])
      Assigns new values for a given column. The assignment is made
      in the form <colname>=<expr> where <colname> is the name of a
      column in the SQL table and <expr> is the text of an
      expression using STILTS's expression language, as described in
      SUN/256. SQL table column names or $ID identifiers may be used
      as variables in the usual way.

      This parameter may be supplied more than once to effect
      multiple assignments, or multiple assignments may be made by
      separating them with semicolons in the value of this
      parameter.

   progress = true|false       (Boolean)
      If true, a spinner will be drawn on standard error which shows
      how many rows have been updated so far.

      [Default: true]
'''
    task = _stilts.getTaskFactory().createObject('sqlupdate')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def taplint(tapurl, **kwargs):
    '''\
Tests TAP services.

Parameters:

   tapurl = <url-value>       (java.net.URL)
      The base URL of a Table Access Protocol service. This is the
      bare URL without a trailing "/[a]sync".

      In the usual case, the default values of the various endpoints
      (sync and async query submission, tables metadata,
      service-provided examples etc) use this URL as a parent and
      append standard sub-paths.

      In some cases however, determination of the endpoints is more
      complicated, as determined by the interface parameter which
      may cause endpoints to be read from the capabilities document
      at tapurl/capabilities, and by other endpoint-specific
      parameters (syncurl, asyncurl, tablesurl, capabilitiesurl,
      availabilityurl, examplesurl) for fine tuning.

   stages = [+/-]XXX ...       (String[])
      Determines the validation stages which the validator will
      peform. Each stage is represented by a short code, as follows:

       * TMV: Validate table metadata against XML schema
       * TME: Check content of tables metadata from /tables
       * TMS: Check content of tables metadata from TAP_SCHEMA
       * TMC: Compare table metadata from /tables and TAP_SCHEMA
       * UUC: Check column units and UCDs are legal
       * CPV: Validate capabilities against XML schema
       * CAP: Check TAP and TAPRegExt content of capabilities
            document
       * AVV: Validate availability against XML schema
       * QGE: Make ADQL queries in sync GET mode
       * QPO: Make ADQL queries in sync POST mode
       * QAS: Make ADQL queries in async mode
       * UWS: Test asynchronous UWS/TAP behaviour
       * MDQ: Check table query result columns against declared
            metadata
       * OBS: Test implementation of ObsCore Data Model
       * LOC: Test implementation of ObsLocTAP Data Model
       * EPN: Test implementation of EPN-TAP tables (off)
       * UPL: Make queries with table uploads
       * EXA: Check content of examples document

      This parameter can specify what stages to run in the following
      ways:

       * if left blank, the default list of stages (which is most or
            all of them) will be run
       * if the value is a space-separated list of three-letter
            codes, it lists the stages that will be run
       * if the value is a space separated list of three-letter
            codes preceded by a "+" or "-" character, the named
            stages will be removed or added to the default list

      So "TME CAP" will run only Table Metadata and Capability
      stages, while "-EXA -UPL" will run all the default stages
      apart from Examples and Upload. The order in which stages are
      listed is not significant.

      Note that removing some stages may affect the operation of
      others; for instance table metadata is acquired from the
      metadata stages, and avoiding those will mean that later
      stages which use the table metadata to pose queries will not
      be able to do so with knowledge of the database schema.

   maxtable = <int-value>       (Integer)
      Limits the number of tables from the service that will be
      tested. Currently, this only affects stage MDQ. If the value
      is left blank (the default), or if it is larger than the
      number of tables actually present in the service, it will have
      no effect.

   tables = <value>       (String)
      If supplied, this specifies a list of tables to test. It may
      be set to a space- or comma-separated list of table names for
      consideration; any tables not covered by this list are mostly
      ignored for the purposes of reporting. Matching against table
      names is case-insensitive, and the asterisk character "*" may
      be used as a wildcard to match any sequence of characters.
      Note that matching is against the declared table name which
      may or may not include a schema name prefix depending on
      service behaviour.

      By default this parameter is not set, which means that all
      tables are considered.

   format = text|json       
   (uk.ac.starlink.ttools.taplint.OutputReporter)
      Determines the format of the output. Possible values are text
      , json.

      Note not all of the other parameters may be applicable to all
      output formats.

      [Default: text]

   report = [EWISF]+       (String)
      Letters indicating which message types should be listed. Each
      character of the string is one of the letters E, W, I, S, F
      with the following meanings:

       * E: Error in operation or standard compliance of the
            service.
       * W: Warning that service behaviour is questionable, or
            contravenes a standard recommendation, but is not in
            actual violation of the standard.
       * I: Information about progress, for instance details of
            queries made.
       * S: Summary of previous successful/unsuccessful reports.
       * F: Failure of the validator to perform some testing. The
            cause is either some error internal to the validator, or
            some error or missing functionality in the service which
            has already been reported.

      [Default: EWISF]

   maxrepeat = <int-value>       (Integer)
      Puts a limit on the number of times that a single message will
      be repeated. By setting this to some reasonably small number,
      you can ensure that the output does not get cluttered up by
      millions of repetitions of essentially the same error.

      [Default: 9]

   truncate = <int-value>       (Integer)
      Limits the line length written to the output.

      [Default: 640]

   debug = true|false       (Boolean)
      If true, debugging output including stack traces will be
      output along with the normal validation messages.

      [Default: false]

   interface = tap1.0|tap1.1|cap       (String)
      Defines how the service endpoints and the version of the TAP
      protocol to use for queries is determined. This may take one
      of the following (case-insensitive) values:

       * TAP1.0: The standard TAP endpoints are used, without
            examining the service's capabilities document. The
            service is queried using version 1.0 of the TAP
            protocol.
       * TAP1.1: The standard TAP endpoints are used, without
            examining the service's capabilities document. The
            service is queried using version 1.1 of the TAP
            protocol.
       * cap: The service's capabilities document is examined, and
            the endpoints listed there are used.

      The capabilities document, if used, is read from tapurl
      /capabilities unless the capabilitiesurl parameter is defined,
      in which case that is used.

      The baseline value of all the TAP service endpoints (sync,
      async, tables, capabilities, examples) are determined by this
      parameter, but each of those endpoint values may be overridden
      individually by other endpoint-specific parameters (syncurl,
      asyncurl, tablesurl, capabilitiesurl, availabilityurl,
      examplesurl)

      For default (unauthenticated) access, the default value is
      usually suitable.

      [Default: cap]

   syncurl = <url-value>       (java.net.URL)
      Sets the URL to use for the sync endpoint of the TAP service.
      The default value would be <tapurl>/sync, but it may be
      influenced by the chosen interface value, and it can be
      further overridden by setting this value.

   asyncurl = <url-value>       (java.net.URL)
      Sets the URL to use for the async endpoint of the TAP service.
      The default value would be <tapurl>/async, but it may be
      influenced by the chosen interface value, and it can be
      further overridden by setting this value.

   tablesurl = <url-value>       (java.net.URL)
      Sets the URL to use for the tables endpoint of the TAP
      service. The default value would be <tapurl>/tables, but it
      may be influenced by the chosen interface value, and it can be
      further overridden by setting this value.

   capabilitiesurl = <url-value>       (java.net.URL)
      Sets the URL to use for the capabilities endpoint of the TAP
      service. The default value would be <tapurl>/capabilities, but
      it may be influenced by the chosen interface value, and it can
      be further overridden by setting this value.

   availabilityurl = <url-value>       (java.net.URL)
      Sets the URL to use for the availability endpoint of the TAP
      service. The default value would be <tapurl>/availability, but
      it may be influenced by the chosen interface value, and it can
      be further overridden by setting this value.

   examplesurl = <url-value>       (java.net.URL)
      Sets the URL to use for the examples endpoint of the TAP
      service. The default value would be <tapurl>/examples, but it
      may be influenced by the chosen interface value, and it can be
      further overridden by setting this value.
'''
    task = _stilts.getTaskFactory().createObject('taplint')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('tapurl', _map_env_value(tapurl))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def tapquery(**kwargs):
    '''\
Queries a Table Access Protocol server.

The return value is the resulting table.

Parameters:

   nupload = <count>       (Integer)
      The number of upload tables for this task. For each of the
      upload tables N there will be associated parameters ufmtN,
      uploadN and ucmdN.

      [Default: 0]

   uploadN = <tableN>       (uk.ac.starlink.table.StarTable)
      Input table.

   upnameN = <adql-identifier>       (String)
      Identifier to use in server-side expressions for uploaded
      table #N. In ADQL expressions, the table should be referred to
      as "TAP_UPLOAD.<label>".

      The value must syntactically be an ADQL identifier (
      [A-Za-z][A-Za-z0-9_]*).

      [Default: upN]

   tapurl = <url-value>       (java.net.URL)
      The base URL of a Table Access Protocol service. This is the
      bare URL without a trailing "/[a]sync".

      In the usual case, the default values of the various endpoints
      (sync and async query submission, tables metadata,
      service-provided examples etc) use this URL as a parent and
      append standard sub-paths.

      In some cases however, determination of the endpoints is more
      complicated, as determined by the interface parameter which
      may cause endpoints to be read from the capabilities document
      at tapurl/capabilities, and by other endpoint-specific
      parameters (syncurl, asyncurl, tablesurl, capabilitiesurl,
      availabilityurl, examplesurl) for fine tuning.

   interface = tap1.0|tap1.1|cap       (String)
      Defines how the service endpoints and the version of the TAP
      protocol to use for queries is determined. This may take one
      of the following (case-insensitive) values:

       * TAP1.0: The standard TAP endpoints are used, without
            examining the service's capabilities document. The
            service is queried using version 1.0 of the TAP
            protocol.
       * TAP1.1: The standard TAP endpoints are used, without
            examining the service's capabilities document. The
            service is queried using version 1.1 of the TAP
            protocol.
       * cap: The service's capabilities document is examined, and
            the endpoints listed there are used.

      The capabilities document, if used, is read from tapurl
      /capabilities unless the capabilitiesurl parameter is defined,
      in which case that is used.

      The baseline value of all the TAP service endpoints (sync,
      async, tables, capabilities, examples) are determined by this
      parameter, but each of those endpoint values may be overridden
      individually by other endpoint-specific parameters (syncurl,
      asyncurl, tablesurl, capabilitiesurl, availabilityurl,
      examplesurl)

      For default (unauthenticated) access, the default value is
      usually suitable.

      [Default: tap1.0]

   adql = <query-text>       (String)
      Astronomical Data Query Language string specifying the TAP
      query to execute. ADQL/S resembles SQL, so this string will
      likely start with "SELECT".

   parse = true|false       (Boolean)
      Determines whether an attempt will be made to check the syntax
      of the ADQL prior to submitting the query. If this is set
      true, and if a syntax error is found, the task will fail with
      an error before any attempt is made to submit the query.

      [Default: false]

   sync = true|false       (Boolean)
      Determines whether the TAP query is submitted in synchronous
      or asynchronous mode. Synchronous (true) means that the result
      is retrieved over the same HTTP connection that the query is
      submitted from. This is uncomplicated, but means if the query
      takes a long time it may time out and the results will be
      lost. Asynchronous (false) means that the job is queued and
      results may be retrieved later. Normally this command does the
      necessary waiting around and recovery of the result, though
      with appropriate settings you can get tapresume to pick it up
      for you later instead. In most cases false (the default) is
      preferred.

      [Default: false]

   maxrec = <nrow>       (Long)
      Sets the requested maximum row count for the result of the
      query. The service is not obliged to respect this, but in the
      case that it has a default maximum record count, setting this
      value may raise the limit. If no value is set, the service's
      default policy will be used.

   destruction = <iso8601>       (String)
      Posts an updated value of the UWS DESTRUCTION parameter to the
      query job before it starts. This only makes sense for
      asynchronous jobs (sync=false).

      The supplied value should be an ISO-8601-like string, giving
      the new requested job destruction time. The service is not
      obliged to honour this request. See UWS v1.0, sec 2.2.3.3.

   executionduration = <seconds>       (Long)
      Posts an updated value of the UWS EXECUTIONDURATION parameter
      to the query job before it starts. This only makes sense for
      asynchronous jobs (sync=false).

      The supplied value is an integer giving the maximum number of
      wall-clock seconds for which the job is permitted to execute
      before being forcibly terminated. A value of zero indicates
      unlimited duration. The service is not obliged to honour this
      request. See UWS v1.0, sec 2.2.3.4.

   compress = true|false       (Boolean)
      If true, the service is requested to provide HTTP-level
      compression for the response stream (Accept-Encoding header is
      set to "gzip", see RFC 2616). This does not guarantee that
      compression will happen but if the service honours this
      request it may result in a smaller amount of network traffic
      at the expense of more processing on the server and client.

      [Default: true]

   upvotformat = TABLEDATA|BINARY|BINARY2       
   (uk.ac.starlink.votable.VOTableWriter)
      Determines how any uploaded tables will be serialized for
      transmission to the TAP server. The supplied string is the
      name of one of the defined VOTable serialization formats. The
      choice shouldn't affect any results, though it may affect
      required bandwidth, and some services may (though should not)
      have non-standard requirements for serialization format.

      [Default: TABLEDATA]

   language = <lang-name>       (String)
      Language to use for the ADQL-like query. This will usually be
      "ADQL" (the default), but may be set to some other value
      supported by the service, for instance a variant indicating a
      different ADQL version. Note that at present, setting it to
      "PQL" is not sufficient to submit a PQL query.

      [Default: ADQL]

   poll = <millisec>       (Integer)
      Interval to wait between polling attempts, in milliseconds.
      Asynchronous TAP queries can only find out when they are
      complete by repeatedly polling the server to find out the
      job's status. This parameter allows you to set how often that
      happens. Attempts to set it too low (<50) will be rejected on
      the assumption that you're thinking in seconds.

      [Default: 5000]

   progress = true|false       (Boolean)
      If this parameter is set true, progress of the job is reported
      to standard output as it happens.

      [Default: true]

   delete = finished|never|always|now       
   (uk.ac.starlink.ttools.task.TapResultReader$DeleteMode)
      Determines under what circumstances the UWS job is to be
      deleted from the server when its data is no longer required.
      If it is not deleted, then the job is left on the TAP server
      and it can be accessed via the normal UWS REST endpoints or
      using tapresume until it is destroyed by the server.

      Possible values:

       * finished: delete only if the job finished, successfully or
            not
       * never: do not delete
       * always: delete on command exit
       * now: delete and return immediately

      [Default: finished]
'''
    task = _stilts.getTaskFactory().createObject('tapquery')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tapresume(**kwargs):
    '''\
Resumes a previous query to a Table Access Protocol server.

The return value is the resulting table.

Parameters:

   joburl = <url-value>       (java.net.URL)
      The URL of a job created by submission of a TAP query which
      was created earlier and has not yet been deleted (by the
      client) or destroyed (by the server). This will usually be of
      the form <tap-url>/async/<job-id>. You can also find out, and
      possibly retrieve results from the job by pointing a web
      browser at this URL.

   compress = true|false       (Boolean)
      If true, the service is requested to provide HTTP-level
      compression for the response stream (Accept-Encoding header is
      set to "gzip", see RFC 2616). This does not guarantee that
      compression will happen but if the service honours this
      request it may result in a smaller amount of network traffic
      at the expense of more processing on the server and client.

      [Default: true]

   poll = <millisec>       (Integer)
      Interval to wait between polling attempts, in milliseconds.
      Asynchronous TAP queries can only find out when they are
      complete by repeatedly polling the server to find out the
      job's status. This parameter allows you to set how often that
      happens. Attempts to set it too low (<50) will be rejected on
      the assumption that you're thinking in seconds.

      [Default: 5000]

   progress = true|false       (Boolean)
      If this parameter is set true, progress of the job is reported
      to standard output as it happens.

      [Default: true]

   delete = finished|never|always|now       
   (uk.ac.starlink.ttools.task.TapResultReader$DeleteMode)
      Determines under what circumstances the UWS job is to be
      deleted from the server when its data is no longer required.
      If it is not deleted, then the job is left on the TAP server
      and it can be accessed via the normal UWS REST endpoints or
      using tapresume until it is destroyed by the server.

      Possible values:

       * finished: delete only if the job finished, successfully or
            not
       * never: do not delete
       * always: delete on command exit
       * now: delete and return immediately

      [Default: finished]
'''
    task = _stilts.getTaskFactory().createObject('tapresume')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tapskymatch(in_, **kwargs):
    '''\
Crossmatches table on sky position against TAP table.

The return value is the resulting table.

Parameters:

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   inlon = <expr/deg>       (String)
      Longitude in degrees for the position of each row in the input
      table. This may simply be a column name, or it may be an
      algebraic expression as explained in SUN/256. The coordinate
      system must match that used for the coordinates in the remote
      table.

   inlat = <expr/deg>       (String)
      Longitude in degrees for the position of each row in the input
      table. This may simply be a column name, or it may be an
      algebraic expression as explained in SUN/256. The coordinate
      system must match that used for the coordinates in the remote
      table.

   tapurl = <url-value>       (java.net.URL)
      The base URL of a Table Access Protocol service. This is the
      bare URL without a trailing "/[a]sync".

      In the usual case, the default values of the various endpoints
      (sync and async query submission, tables metadata,
      service-provided examples etc) use this URL as a parent and
      append standard sub-paths.

      In some cases however, determination of the endpoints is more
      complicated, as determined by the interface parameter which
      may cause endpoints to be read from the capabilities document
      at tapurl/capabilities, and by other endpoint-specific
      parameters (syncurl, asyncurl, tablesurl, capabilitiesurl,
      availabilityurl, examplesurl) for fine tuning.

   interface = tap1.0|tap1.1|cap       (String)
      Defines how the service endpoints and the version of the TAP
      protocol to use for queries is determined. This may take one
      of the following (case-insensitive) values:

       * TAP1.0: The standard TAP endpoints are used, without
            examining the service's capabilities document. The
            service is queried using version 1.0 of the TAP
            protocol.
       * TAP1.1: The standard TAP endpoints are used, without
            examining the service's capabilities document. The
            service is queried using version 1.1 of the TAP
            protocol.
       * cap: The service's capabilities document is examined, and
            the endpoints listed there are used.

      The capabilities document, if used, is read from tapurl
      /capabilities unless the capabilitiesurl parameter is defined,
      in which case that is used.

      The baseline value of all the TAP service endpoints (sync,
      async, tables, capabilities, examples) are determined by this
      parameter, but each of those endpoint values may be overridden
      individually by other endpoint-specific parameters (syncurl,
      asyncurl, tablesurl, capabilitiesurl, availabilityurl,
      examplesurl)

      For default (unauthenticated) access, the default value is
      usually suitable.

      [Default: tap1.0]

   taptable = <name>       (String)
      Name of the table in the given TAP service against which the
      matching will be performed.

   taplon = <column>       (String)
      Longitude in degrees for the position of each row in the
      remote table. This is an ADQL expression interpreted within
      the TAP service, typically just a column name. The coordinate
      system must match that used for the input table.

   taplat = <column>       (String)
      Latitude in degrees for the position of each row in the remote
      table. This is an ADQL expression interpreted within the TAP
      service, typically just a column name. The coordinate system
      must match that used for the input table.

   tapcols = <colname,...>       (String[])
      Comma-separated list of column names to retrieve from the
      remote table. If no value is supplied (the default), all
      columns from the remote table will be returned.

   sr = <expr/deg>       (String)
      Maximum distance in degrees from the local table (lat,lon)
      position at which counterparts from the remote table will be
      identified. This is an ADQL expression interpreted within the
      TAP service, so it may be a constant value or may involve
      columns in the remote table.

   find = all|best|each|each-dist       
   (uk.ac.starlink.ttools.task.UserFindMode)
      Determines which pair matches are included in the result.

       * all: All matches
       * best: Matched rows, best remote row for each input row
       * each: One row per input row, contains best remote match or
            blank
       * each-dist: One row per input row, column giving distance
            only for best match

      Note only the all mode is symmetric between the two tables.

      [Default: all]

   blocksize = <int-value>       (Integer)
      The number of rows uploaded in each TAP query. TAP services
      may have limits on the number of rows in a table uploaded for
      matching. This command can therefore break up input tables
      into blocks and make a number of individual TAP queries to
      generate the result. This parameter controls the maximum
      number of rows uploaded in each individual request. For an
      input table with fewer rows than this value, the whole thing
      is done as a single query.

      [Default: 5000]

   maxrec = <int-value>       (Integer)
      Limit to the number of rows resulting from this operation. If
      the value is negative (the default) no limit is imposed. Note
      however that there can be truncation of the result if the
      number of records returned from a single chunk exceeds limits
      imposed by the service.

      [Default: -1]

   sync = true|false       (Boolean)
      Determines whether the TAP queries are submitted in
      synchronous or asynchronous mode. Since this command uses
      chunking to keep requests to a reasonable size, hopefully
      requests will not take too long to execute, therefore the
      default is synchronous (true).

      [Default: true]

   blockmaxrec = <nrow>       (Long)
      Sets the MAXREC parameter passed to the TAP service for each
      uploaded block. This allows you to request that the service
      overrides its default limit for the number of rows output from
      a single query. The service may still impose some "hard" limit
      beyond which the output row count cannot be increased.

      Note this differs from the maxrec parameter, which gives the
      maximum total number of rows to be returned from this command.

   compress = true|false       (Boolean)
      If true, the service is requested to provide HTTP-level
      compression for the response stream (Accept-Encoding header is
      set to "gzip", see RFC 2616). This does not guarantee that
      compression will happen but if the service honours this
      request it may result in a smaller amount of network traffic
      at the expense of more processing on the server and client.

      [Default: true]

   fixcols = none|dups|all       
   (uk.ac.starlink.ttools.task.JoinFixActionParameter$Fixer)
      Determines how input columns are renamed before use in the
      output table. The choices are:

       * none: columns are not renamed
       * dups: columns which would otherwise have duplicate names in
            the output will be renamed to indicate which table they
            came from
       * all: all columns will be renamed to indicate which table
            they came from

      If columns are renamed, the new ones are determined by
      suffix* parameters.

      [Default: dups]

   suffixin = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from the input table.

      [Default: _in]

   suffixremote = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from the TAP result table.

      [Default: _tap]
'''
    task = _stilts.getTaskFactory().createObject('tapskymatch')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tcat(in_, **kwargs):
    '''\
Concatenates multiple similar tables.

The return value is the resulting table.

Parameters:

   in_ = <table> [<table> ...]       
   (uk.ac.starlink.ttools.task.TableProducer[])
      Array of input tables.

   multi = true|false       (Boolean)
      Determines whether all tables, or just the first one, from
      input table files will be used. If set false, then just the
      first table from each file named by in will be used. If true,
      then all tables present in those input files will be used.
      This only has an effect for file formats which are capable of
      containing more than one table, which effectively means FITS
      and VOTable and their variants.

      [Default: false]

   seqcol = <colname>       (String)
      Name of a column to be added to the output table which will
      contain the sequence number of the input table from which each
      row originated. This column will contain 1 for the rows from
      the first concatenated table, 2 for the second, and so on.

   loccol = <colname>       (String)
      Name of a column to be added to the output table which will
      contain the location (as specified in the input parameter(s))
      of the input table from which each row originated.

   uloccol = <colname>       (String)
      Name of a column to be added to the output table which will
      contain the unique part of the location (as specified in the
      input parameter(s)) of the input table from which each row
      originated. If not null, parameters will also be added to the
      output table giving the pre- and post-fix string common to all
      the locations. For example, if the input tables are
      "/data/cat_a1.fits" and "/data/cat_b2.fits" then the output
      table will contain a new column <colname> which takes the
      value "a1" for rows from the first table and "b2" for rows
      from the second, and new parameters "<colname>_prefix" and
      "<colname>_postfix" with the values "/data/cat_" and ".fits"
      respectively.

   lazy = true|false       (Boolean)
      Whether to perform table resolution lazily. If true, each
      table is only accessed when the time comes to add its rows to
      the output; if false, then all the tables are accessed up
      front. This is mostly a tuning parameter, and on the whole it
      doesn't matter much how it is set, but for joining an enormous
      number of tables setting it true may avoid running out of
      resources.

      [Default: false]

   countrows = true|false       (Boolean)
      Whether to count the rows in the table before starting the
      output. This is essentially a tuning parameter - if writing to
      an output format which requires the number of rows up front
      (such as normal FITS) it may result in skipping the number of
      passes through the input files required for processing. Unless
      you have a good understanding of the internals of the
      software, your best bet for working out whether to set this
      true or false is to try it both ways

      [Default: false]
'''
    task = _stilts.getTaskFactory().createObject('tcat')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tcatn(**kwargs):
    '''\
Concatenates multiple tables.

The return value is the resulting table.

Parameters:

   nin = <count>       (Integer)
      The number of input tables for this task. For each of the
      input tables N there will be associated parameters ifmtN, inN
      and icmdN.

   inN = <tableN>       (uk.ac.starlink.table.StarTable)
      Input table.

   seqcol = <colname>       (String)
      Name of a column to be added to the output table which will
      contain the sequence number of the input table from which each
      row originated. This column will contain 1 for the rows from
      the first concatenated table, 2 for the second, and so on.

   loccol = <colname>       (String)
      Name of a column to be added to the output table which will
      contain the location (as specified in the input parameter(s))
      of the input table from which each row originated.

   uloccol = <colname>       (String)
      Name of a column to be added to the output table which will
      contain the unique part of the location (as specified in the
      input parameter(s)) of the input table from which each row
      originated. If not null, parameters will also be added to the
      output table giving the pre- and post-fix string common to all
      the locations. For example, if the input tables are
      "/data/cat_a1.fits" and "/data/cat_b2.fits" then the output
      table will contain a new column <colname> which takes the
      value "a1" for rows from the first table and "b2" for rows
      from the second, and new parameters "<colname>_prefix" and
      "<colname>_postfix" with the values "/data/cat_" and ".fits"
      respectively.

   countrows = true|false       (Boolean)
      Whether to count the rows in the table before starting the
      output. This is essentially a tuning parameter - if writing to
      an output format which requires the number of rows up front
      (such as normal FITS) it may result in skipping the number of
      passes through the input files required for processing. Unless
      you have a good understanding of the internals of the
      software, your best bet for working out whether to set this
      true or false is to try it both ways

      [Default: false]
'''
    task = _stilts.getTaskFactory().createObject('tcatn')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tcopy(in_, **kwargs):
    '''\
Converts between table formats.

Parameters:

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.
'''
    task = _stilts.getTaskFactory().createObject('tcopy')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def tcube(in_, **kwargs):
    '''\
Calculates N-dimensional histograms.

Parameters:

   cols = <expr> ... ...       (String[])
      Columns to use for this task. One or more <expr> elements,
      separated by spaces, should be given. Each one represents a
      numeric value from the table, provided as a column name or
      algebraic expression.

      The number of columns listed in the value of this parameter
      defines the dimensionality of the output data cube.

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   bounds = [<lo>]:[<hi>] ...       (double[][])
      Gives the bounds for each dimension of the cube in data
      coordinates. The form of the value is a space-separated list
      of words, each giving an optional lower bound, then a colon,
      then an optional upper bound, for instance "1:100 0:20" to
      represent a range for two-dimensional output between 1 and 100
      of the first coordinate (table column) and between 0 and 20
      for the second. Either or both numbers may be omitted to
      indicate that the bounds should be determined automatically by
      assessing the range of the data in the table. A null value for
      the parameter indicates that all bounds should be determined
      automatically for all the dimensions.

      If any of the bounds need to be determined automatically in
      this way, two passes through the data will be required, the
      first to determine bounds and the second to populate the cube.

   binsizes = <size> ...       (Double[])
      Gives the extent of of the data bins (cube pixels) in each
      dimension in data coordinates. The form of the value is a
      space-separated list of values, giving a list of extents for
      the first, second, ... dimension. Either this parameter or the
      nbins parameter must be supplied.

   nbins = <num> ...       (Integer[])
      Gives the number of bins (cube pixels) in each dimension. The
      form of the value is a space-separated list of integers,
      giving the number of pixels for the output cube in the first,
      second, ... dimension. Either this parameter or the binsizes
      parameter must be supplied.

   combine =
   sum|sum-per-unit|count|count-per-unit|mean|median|Q1|Q3|min|max|stdev|hit
         (uk.ac.starlink.ttools.plot2.layer.Combiner)
      Defines how values contributing to the same density map bin
      are combined together to produce the value assigned to that
      bin. Possible values are:

       * sum: the sum of all the combined values per bin
       * sum-per-unit: the sum of all the combined values per unit
            of bin size
       * count: the number of non-blank values per bin (weight is
            ignored)
       * count-per-unit: the number of non-blank values per unit of
            bin size (weight is ignored)
       * mean: the mean of the combined values
       * median: the median
       * Q1: first quartile
       * Q3: third quartile
       * min: the minimum of all the combined values
       * max: the maximum of all the combined values
       * stdev: the sample standard deviation of the combined values
       * hit: 1 if any values present, NaN otherwise (weight is
            ignored)

      [Default: sum]

   out = <out-file>       (uk.ac.starlink.util.Destination)
      The location of the output file. This is usually a filename to
      write to. If it is equal to the special value "-" the output
      will be written to standard output.

      The output cube is currently written as a single-HDU FITS
      file.

      [Default: -]

   otype = byte|short|int|long|float|double       (Class)
      The type of numeric value which will fill the output array. If
      no selection is made, the output type will be determined
      automatically as the shortest type required to hold all the
      values in the array. Currently, integers are always signed (no
      BSCALE/BZERO), so for instance the largest value that can be
      recorded in 8 bits is 127.

   scale = <expr>       (String)
      Optionally gives a weight for each entry contributing to
      histogram bins. The value of this expression is accumulated,
      in accordance with the combine parameter, into the bin defined
      by its coordinates. If no expression is given, the value 1 is
      assumed.
'''
    task = _stilts.getTaskFactory().createObject('tcube')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def tgridmap(in_, **kwargs):
    '''\
Calculates N-dimensional density maps.

The return value is the resulting table.

Parameters:

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   coords = <expr> ...       (String[])
      Defines the dimensions of the grid over which accumulation
      will take place. The form of this value is a space-separated
      list of words each giving a column name or algebraic
      expression defining one of the dimensions of the output grid.
      For a 1-dimensional histogram, only one value is required.

   logs = true|false ...       (Boolean[])
      Determines whether each coordinate axis is linear or
      logarithmic. By default the grid axes are linear, but if this
      parameter is supplied with one or more true values, the bins
      on the corresponding axes are assigned logarithmically
      instead.

      If supplied, this parameter must have the same number of words
      as the coords parameter.

   bounds = [<lo>]:[<hi>] ...       (double[][])
      Gives the bounds for each dimension of the cube in data
      coordinates. The form of the value is a space-separated list
      of words, each giving an optional lower bound, then a colon,
      then an optional upper bound, for instance "1:100 0:20" to
      represent a range for two-dimensional output between 1 and 100
      of the first coordinate (table column) and between 0 and 20
      for the second. Either or both numbers may be omitted to
      indicate that the bounds should be determined automatically by
      assessing the range of the data in the table. A null value for
      the parameter indicates that all bounds should be determined
      automatically for all the dimensions.

      If any of the bounds need to be determined automatically in
      this way, two passes through the data will be required, the
      first to determine bounds and the second to calculate the map.

      If supplied, this parameter must have the same number of words
      as the coords parameter.

   binsizes = <size> ...       (Double[])
      Gives the extent of of the data bins in each dimension in data
      coordinates. The form of the value is a space-separated list
      of values, giving a list of extents for the first, second, ...
      dimension. Either this parameter or the nbins parameter must
      be supplied.

      If supplied, this parameter must have the same number of words
      as the coords parameter.

   nbins = <num> ...       (Integer[])
      Gives the approximate number of bins in each dimension. The
      form of the value is a space-separated list of integers,
      giving the number of bins for the output histogram in the
      first, second, ... dimension. An attempt is made to use round
      numbers for bin sizes so the bin counts may not be exactly as
      specified. Either this parameter or the binsizes parameter
      must be supplied.

      If supplied, this parameter must have the same number of words
      as the coords parameter.

   cols = <expr>[;<combiner>[;<name>]] ...       (String[])
      Defines the quantities to be calculated. The value is a
      space-separated list of items, one for each aggregated column
      in the output table.

      Each item is composed of one, two or three tokens, separated
      by semicolon (";") characters:

       * <expr>: (required) column name or expression using the
            expression language for the quantity to be aggregated.
       * <combiner>: (optional) combination method, using the same
            options as for the combine parameter. If omitted, the
            value specified for that parameter will be used.
       * <name>: (optional) name of output column; if omitted, the
            <expr> value (perhaps somewhat sanitised) will be used.

      It is often sufficient just to supply a space-separated list
      of input table column names for this parameter, but the
      additional syntax may be required for instance if it's
      required to calculate both a sum and mean of the same input
      column.

      The default value is "1;count;COUNT" which simply provides an
      unweighted histogram, i.e. a count of the rows in each bin
      (aggregation of the value "1" using the combination method "
      count", yielding an output column named "COUNT").

      [Default: 1;count;COUNT]

   combine =
   sum|sum-per-unit|count|count-per-unit|mean|median|Q1|Q3|min|max|stdev|hit
         (uk.ac.starlink.ttools.plot2.layer.Combiner)
      Defines the default way that values contributing to the same
      density map bin are combined together to produce the value
      assigned to that bin. Possible values are:

       * sum: the sum of all the combined values per bin
       * sum-per-unit: the sum of all the combined values per unit
            of bin size
       * count: the number of non-blank values per bin (weight is
            ignored)
       * count-per-unit: the number of non-blank values per unit of
            bin size (weight is ignored)
       * mean: the mean of the combined values
       * median: the median
       * Q1: first quartile
       * Q3: third quartile
       * min: the minimum of all the combined values
       * max: the maximum of all the combined values
       * stdev: the sample standard deviation of the combined values
       * hit: 1 if any values present, NaN otherwise (weight is
            ignored)

      Note this value may be overridden on a per-column basis by the
      cols parameter.

      [Default: mean]

   sparse = true|false       (Boolean)
      Determines whether a row is written for every cell in the
      defined grid, or only for those cells in which data appears in
      the input. The result will usually be more compact if this is
      set false, but if you want to compare results from different
      runs it may be convenient to set it true.

      [Default: true]

   runner = sequential|parallel|parallel<n>|partest       
   (uk.ac.starlink.table.RowRunner)
      Selects the threading implementation, i.e. to what extent
      processing is done in parallel. The options are currently:

       * sequential: runs using only a single thread
       * parallel: runs using multiple threads for large tables,
            with parallelism given by the number of available
            processors
       * parallel<n>: runs using multiple threads for large tables,
            with parallelism given by the supplied value <n>
       * partest: runs using multiple threads even when tables are
            small (only intended for testing purposes)

      Using parallel processing can speed up execution considerably;
      however, depending on the I/O operations required, it can also
      slow it down by disrupting patterns of disk access. If the
      content of a file is on a solid state disk, or is already in
      cache for instance because a similar command has been run
      recently, then parallel will probably be faster. However, if
      the data is being read directly from a spinning disk, for
      instance because the file is too large to fit in RAM, then
      sequential or parallel<n> with a small <n> may be faster.

      The value of this parameter should make only very tiny
      differences to the output table. If you notice significant
      discrepancies please report them.

      [Default: parallel]
'''
    task = _stilts.getTaskFactory().createObject('tgridmap')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tjoin(**kwargs):
    '''\
Joins multiple tables side-to-side.

The return value is the resulting table.

Parameters:

   nin = <count>       (Integer)
      The number of input tables for this task. For each of the
      input tables N there will be associated parameters ifmtN, inN
      and icmdN.

   inN = <tableN>       (uk.ac.starlink.table.StarTable)
      Input table.

   fixcols = none|dups|all       
   (uk.ac.starlink.ttools.task.JoinFixActionParameter$Fixer)
      Determines how input columns are renamed before use in the
      output table. The choices are:

       * none: columns are not renamed
       * dups: columns which would otherwise have duplicate names in
            the output will be renamed to indicate which table they
            came from
       * all: all columns will be renamed to indicate which table
            they came from

      If columns are renamed, the new ones are determined by
      suffix* parameters.

      [Default: dups]

   suffixN = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from table N.

      [Default: _N]
'''
    task = _stilts.getTaskFactory().createObject('tjoin')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tloop(end, **kwargs):
    '''\
Generates a single-column table from a loop variable.

The return value is the resulting table.

Parameters:

   colname = <value>       (String)
      Gives the name of the single column produced by this command.

      [Default: i]

   start = <float-value>       (Double)
      Gives the starting value of the loop variable. This will the
      the value in the first row of the table.

      [Default: 0.0]

   end = <float-value>       (Double)
      Gives the value which the loop variable will not exceed.
      Exceeding is in the positive or negative sense according to
      the sense of the step parameter, as usual for a for-type loop.

   step = <float-value>       (Double)
      Amount by which the loop variable will be incremented at each
      iteration, i.e. each table row.

      [Default: 1.0]

   forcefloat = true|false       (Boolean)
      Affects the data type of the loop variable column. If true,
      the column is always floating point. If false, and if the
      other parameters are all of integer type, the column will be
      an integer column.

      [Default: false]
'''
    task = _stilts.getTaskFactory().createObject('tloop')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('end', _map_env_value(end))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tmatch1(in_, **kwargs):
    '''\
Performs a crossmatch internal to a single table.

The return value is the resulting table.

Parameters:

   matcher = <matcher-name>       
   (uk.ac.starlink.table.join.MatchEngine)
      Defines the nature of the matching that will be performed.
      Depending on the name supplied, this may be positional
      matching using celestial or Cartesian coordinates, exact
      matching on the value of a string column, or other things. A
      list and explanation of the available matching algorithms is
      given in SUN/256. The value supplied for this parameter
      determines the meanings of the values required by the params,
      values* and tuning parameter(s).

      [Default: sky]

   params = <match-params>       (String[])
      Determines the parameters of this match. This is typically one
      or more tolerances such as error radii. It may contain zero or
      more values; the values that are required depend on the match
      type selected by the matcher parameter. If it contains
      multiple values, they must be separated by spaces; values
      which contain a space can be 'quoted' or "quoted".

   tuning = <tuning-params>       (String[])
      Tuning values for the matching process, if appropriate. It may
      contain zero or more values; the values that are permitted
      depend on the match type selected by the matcher parameter. If
      it contains multiple values, they must be separated by spaces;
      values which contain a space can be 'quoted' or "quoted". If
      this optional parameter is not supplied, sensible defaults
      will be chosen.

   values = <expr-list>       (String[])
      Defines the values from the input table which are used to
      determine whether a match has occurred. These will typically
      be coordinate values such as RA and Dec and perhaps some
      per-row error values as well, though exactly what values are
      required is determined by the kind of match as determined by
      matcher. Depending on the kind of match, the number and type
      of the values required will be different. Multiple values
      should be separated by whitespace; if whitespace occurs within
      a single value it must be 'quoted' or "quoted". Elements of
      the expression list are commonly just column names, but may be
      algebraic expressions calculated from zero or more columns as
      explained in SUN/256.

   action = identify|keep0|keep1|wide2|wideN       
   (uk.ac.starlink.table.join.Match1Type)
      Determines the form of the table which will be output as a
      result of the internal match.

       * identify: The output table is the same as the input table
            except that it contains two additional columns, GroupID
            and GroupSize, following the input columns. Each group
            of rows which matched is assigned a unique integer,
            recorded in the GroupID column, and the size of each
            group is recorded in the GroupSize column. Rows which
            don't match any others (singles) have null values in
            both these columns.
       * keep0: The result is a new table containing only "single"
            rows, that is ones which don't match any other rows in
            the table. Any other rows are thrown out.
       * keep1: The result is a new table in which only one row (the
            first in the input table order) from each group of
            matching ones is retained. A subsequent intra-table
            match with the same criteria would therefore show no
            matches.
       * wideN: The result is a new "wide" table consisting of
            matched rows in the input table stacked next to each
            other. Only groups of exactly N rows in the input table
            are used to form the output table; each row of the
            output table consists of the columns of the first group
            member, followed by the columns of the second group
            member and so on. The output table therefore has N times
            as many columns as the input table. The column names in
            the new table have _1, _2, ... appended to them to avoid
            duplication.

      [Default: identify]

   progress = none|log|time|profile       (String)
      Determines whether information on progress of the match should
      be output to the standard error stream as it progresses. For
      lengthy matches this is a useful reassurance and can give
      guidance about how much longer it will take. It can also be
      useful as a performance diagnostic.

      The options are:

       * none: no progress is shown
       * log: progress information is shown
       * time: progress information and some time profiling
            information is shown
       * profile: progress information and limited time/memory
            profiling information are shown

      [Default: log]

   runner =
   parallel|parallel<n>|parallel-all|sequential|classic|partest
         (uk.ac.starlink.table.RowRunner)
      Selects the threading implementation. The options are
      currently:

       * parallel: uses multithreaded implementation for large
            tables, with default parallelism, which is the smaller
            of 6 and the number of available processors
       * parallel<n>: uses multithreaded implementation for large
            tables, with parallelism given by the supplied value
            <n>
       * parallel-all: uses multithreaded implementation for large
            tables, with a parallelism given by the number of
            available processors
       * sequential: uses multithreaded implementation but with only
            a single thread
       * classic: uses legacy sequential implementation
       * partest: uses multithreaded implementation even when tables
            are small

      The parallel* options should normally run faster than
      sequential or classic (which are provided mainly for testing
      purposes), at least for large matches and where multiple
      processing cores are available.

      The default value "parallel" is currently limited to a
      parallelism of 6 since larger values yield diminishing returns
      given that some parts of the matching algorithms run
      sequentially (Amdahl's Law), and using too many threads can
      sometimes end up doing more work or impacting on other
      operations on the same machine. But you can experiment with
      other concurrencies, e.g. "parallel16" to run on 16 cores (if
      available) or "parallel-all" to run on all available cores.

      The value of this parameter should make no difference to the
      matching results. If you notice any discrepancies please
      report them.

      [Default: parallel]

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.
'''
    task = _stilts.getTaskFactory().createObject('tmatch1')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tmatch2(in1, in2, **kwargs):
    '''\
Crossmatches 2 tables using flexible criteria.

The return value is the resulting table.

Parameters:

   in1 = <table1>       (uk.ac.starlink.table.StarTable)
      Input table.

   in2 = <table2>       (uk.ac.starlink.table.StarTable)
      Input table.

   matcher = <matcher-name>       
   (uk.ac.starlink.table.join.MatchEngine)
      Defines the nature of the matching that will be performed.
      Depending on the name supplied, this may be positional
      matching using celestial or Cartesian coordinates, exact
      matching on the value of a string column, or other things. A
      list and explanation of the available matching algorithms is
      given in SUN/256. The value supplied for this parameter
      determines the meanings of the values required by the params,
      values* and tuning parameter(s).

      [Default: sky]

   values1 = <expr-list>       (String[])
      Defines the values from table 1 which are used to determine
      whether a match has occurred. These will typically be
      coordinate values such as RA and Dec and perhaps some per-row
      error values as well, though exactly what values are required
      is determined by the kind of match as determined by matcher.
      Depending on the kind of match, the number and type of the
      values required will be different. Multiple values should be
      separated by whitespace; if whitespace occurs within a single
      value it must be 'quoted' or "quoted". Elements of the
      expression list are commonly just column names, but may be
      algebraic expressions calculated from zero or more columns as
      explained in SUN/256.

   values2 = <expr-list>       (String[])
      Defines the values from table 2 which are used to determine
      whether a match has occurred. These will typically be
      coordinate values such as RA and Dec and perhaps some per-row
      error values as well, though exactly what values are required
      is determined by the kind of match as determined by matcher.
      Depending on the kind of match, the number and type of the
      values required will be different. Multiple values should be
      separated by whitespace; if whitespace occurs within a single
      value it must be 'quoted' or "quoted". Elements of the
      expression list are commonly just column names, but may be
      algebraic expressions calculated from zero or more columns as
      explained in SUN/256.

   params = <match-params>       (String[])
      Determines the parameters of this match. This is typically one
      or more tolerances such as error radii. It may contain zero or
      more values; the values that are required depend on the match
      type selected by the matcher parameter. If it contains
      multiple values, they must be separated by spaces; values
      which contain a space can be 'quoted' or "quoted".

   tuning = <tuning-params>       (String[])
      Tuning values for the matching process, if appropriate. It may
      contain zero or more values; the values that are permitted
      depend on the match type selected by the matcher parameter. If
      it contains multiple values, they must be separated by spaces;
      values which contain a space can be 'quoted' or "quoted". If
      this optional parameter is not supplied, sensible defaults
      will be chosen.

   join = 1and2|1or2|all1|all2|1not2|2not1|1xor2       
   (uk.ac.starlink.table.join.JoinType)
      Determines which rows are included in the output table. The
      matching algorithm determines which of the rows from the first
      table correspond to which rows from the second. This parameter
      determines what to do with that information. Perhaps the most
      obvious thing is to write out a table containing only rows
      which correspond to a row in both of the two input tables.
      However, you may also want to see the unmatched rows from one
      or both input tables, or rows present in one table but
      unmatched in the other, or other possibilities. The options
      are:

       * 1and2: An output row for each row represented in both input
            tables (INNER JOIN)
       * 1or2: An output row for each row represented in either or
            both of the input tables (FULL OUTER JOIN)
       * all1: An output row for each matched or unmatched row in
            table 1 (LEFT OUTER JOIN)
       * all2: An output row for each matched or unmatched row in
            table 2 (RIGHT OUTER JOIN)
       * 1not2: An output row only for rows which appear in the
            first table but are not matched in the second table
       * 2not1: An output row only for rows which appear in the
            second table but are not matched in the first table
       * 1xor2: An output row only for rows represented in one of
            the input tables but not the other one

      [Default: 1and2]

   find = all|best|best1|best2       
   (uk.ac.starlink.table.join.PairMode)
      Determines what happens when a row in one table can be matched
      by more than one row in the other table. The options are:

       * all: All matches. Every match between the two tables is
            included in the result. Rows from both of the input
            tables may appear multiple times in the result.
       * best: Best match, symmetric. The best pairs are selected in
            a way which treats the two tables symmetrically. Any
            input row which appears in one result pair is
            disqualified from appearing in any other result pair, so
            each row from both input tables will appear in at most
            one row in the result.
       * best1: Best match for each Table 1 row. For each row in
            table 1, only the best match from table 2 will appear in
            the result. Each row from table 1 will appear a maximum
            of once in the result, but rows from table 2 may appear
            multiple times.
       * best2: Best match for each Table 2 row. For each row in
            table 2, only the best match from table 1 will appear in
            the result. Each row from table 2 will appear a maximum
            of once in the result, but rows from table 1 may appear
            multiple times.

      The differences between best, best1 and best2 are a bit
      subtle. In cases where it's obvious which object in each table
      is the best match for which object in the other, choosing
      betwen these options will not affect the result. However, in
      crowded fields (where the distance between objects within one
      or both tables is typically similar to or smaller than the
      specified match radius) it will make a difference. In this
      case one of the asymmetric options (best1 or best2) is usually
      more appropriate than best, but you'll have to think about
      which of them suits your requirements. The performance (time
      and memory usage) of the match may also differ between these
      options, especially if one table is much bigger than the
      other.

      [Default: best]

   fixcols = none|dups|all       
   (uk.ac.starlink.ttools.task.JoinFixActionParameter$Fixer)
      Determines how input columns are renamed before use in the
      output table. The choices are:

       * none: columns are not renamed
       * dups: columns which would otherwise have duplicate names in
            the output will be renamed to indicate which table they
            came from
       * all: all columns will be renamed to indicate which table
            they came from

      If columns are renamed, the new ones are determined by
      suffix* parameters.

      [Default: dups]

   suffix1 = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from table 1.

      [Default: _1]

   suffix2 = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from table 2.

      [Default: _2]

   scorecol = <col-name>       (String)
      Gives the name of a column in the output table to contain the
      "match score" for each pairwise match. The meaning of this
      column is dependent on the chosen matcher, but it typically
      represents a distance of some kind between the two matching
      points. If a null value is chosen, no score column will be
      inserted in the output table. The default value of this
      parameter depends on matcher.

      [Default: Score]

   progress = none|log|time|profile       (String)
      Determines whether information on progress of the match should
      be output to the standard error stream as it progresses. For
      lengthy matches this is a useful reassurance and can give
      guidance about how much longer it will take. It can also be
      useful as a performance diagnostic.

      The options are:

       * none: no progress is shown
       * log: progress information is shown
       * time: progress information and some time profiling
            information is shown
       * profile: progress information and limited time/memory
            profiling information are shown

      [Default: log]

   runner =
   parallel|parallel<n>|parallel-all|sequential|classic|partest
         (uk.ac.starlink.table.RowRunner)
      Selects the threading implementation. The options are
      currently:

       * parallel: uses multithreaded implementation for large
            tables, with default parallelism, which is the smaller
            of 6 and the number of available processors
       * parallel<n>: uses multithreaded implementation for large
            tables, with parallelism given by the supplied value
            <n>
       * parallel-all: uses multithreaded implementation for large
            tables, with a parallelism given by the number of
            available processors
       * sequential: uses multithreaded implementation but with only
            a single thread
       * classic: uses legacy sequential implementation
       * partest: uses multithreaded implementation even when tables
            are small

      The parallel* options should normally run faster than
      sequential or classic (which are provided mainly for testing
      purposes), at least for large matches and where multiple
      processing cores are available.

      The default value "parallel" is currently limited to a
      parallelism of 6 since larger values yield diminishing returns
      given that some parts of the matching algorithms run
      sequentially (Amdahl's Law), and using too many threads can
      sometimes end up doing more work or impacting on other
      operations on the same machine. But you can experiment with
      other concurrencies, e.g. "parallel16" to run on 16 cores (if
      available) or "parallel-all" to run on all available cores.

      The value of this parameter should make no difference to the
      matching results. If you notice any discrepancies please
      report them.

      [Default: parallel]
'''
    task = _stilts.getTaskFactory().createObject('tmatch2')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in1', _map_env_value(in1))
    env.setValue('in2', _map_env_value(in2))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tmatchn(**kwargs):
    '''\
Crossmatches multiple tables using flexible criteria.

The return value is the resulting table.

Parameters:

   nin = <count>       (Integer)
      The number of input tables for this task. For each of the
      input tables N there will be associated parameters ifmtN, inN
      and icmdN.

   inN = <tableN>       (uk.ac.starlink.table.StarTable)
      Input table.

   multimode = pairs|group       (String)
      Defines what is meant by a multi-table match. There are two
      possibilities:

       * pairs: Each output row corresponds to a single row of the
            reference table (see parameter iref) and contains
            entries from other tables which are pair matches to
            that. If a reference table row matches multiple rows
            from one of the other tables, only the best one is
            included.
       * group: Each output row corresponds to a group of entries
            from the input tables which are mutually linked by pair
            matches between them. This means that although you can
            get from any entry to any other entry via one or more
            pair matches, there is no guarantee that any entry is a
            pair match with any other entry. No table has privileged
            status in this case. If there are multiple entries from
            a given table in the match group, an arbitrary one is
            chosen for inclusion (there is no unique way to select
            the best). See SUN/256 for more discussion.

      Note that which rows actually appear in the output is also
      influenced by the joinN parameter.

      [Default: pairs]

   iref = <table-index>       (Integer)
      If multimode=pairs this parameter gives the index of the table
      in the input table list which is to serve as the reference
      table (the one which must be matched by other tables). Ignored
      in other modes.

      Row ordering in the output table is usually tidiest if the
      default setting of 1 is used (i.e. if the first input table is
      used as the reference table).

      [Default: 1]

   matcher = <matcher-name>       
   (uk.ac.starlink.table.join.MatchEngine)
      Defines the nature of the matching that will be performed.
      Depending on the name supplied, this may be positional
      matching using celestial or Cartesian coordinates, exact
      matching on the value of a string column, or other things. A
      list and explanation of the available matching algorithms is
      given in SUN/256. The value supplied for this parameter
      determines the meanings of the values required by the params,
      values* and tuning parameter(s).

      [Default: sky]

   params = <match-params>       (String[])
      Determines the parameters of this match. This is typically one
      or more tolerances such as error radii. It may contain zero or
      more values; the values that are required depend on the match
      type selected by the matcher parameter. If it contains
      multiple values, they must be separated by spaces; values
      which contain a space can be 'quoted' or "quoted".

   tuning = <tuning-params>       (String[])
      Tuning values for the matching process, if appropriate. It may
      contain zero or more values; the values that are permitted
      depend on the match type selected by the matcher parameter. If
      it contains multiple values, they must be separated by spaces;
      values which contain a space can be 'quoted' or "quoted". If
      this optional parameter is not supplied, sensible defaults
      will be chosen.

   valuesN = <expr-list>       (String[])
      Defines the values from table N which are used to determine
      whether a match has occurred. These will typically be
      coordinate values such as RA and Dec and perhaps some per-row
      error values as well, though exactly what values are required
      is determined by the kind of match as determined by matcher.
      Depending on the kind of match, the number and type of the
      values required will be different. Multiple values should be
      separated by whitespace; if whitespace occurs within a single
      value it must be 'quoted' or "quoted". Elements of the
      expression list are commonly just column names, but may be
      algebraic expressions calculated from zero or more columns as
      explained in SUN/256.

   joinN = default|match|nomatch|always       
   (uk.ac.starlink.table.join.MultiJoinType)
      Determines which rows from input table N are included in the
      output table. The matching algorithm determines which of the
      rows in each of the input tables correspond to which rows in
      the other input tables, and this parameter determines what to
      do with that information.

      The default behaviour is that a row will appear in the output
      table if it represents a match of rows from two or more of the
      input tables. This can be altered on a per-input-table basis
      however by choosing one of the non-default options below:

       * match: Rows are included only if they contain an entry from
            input table N.
       * nomatch: Rows are included only if they do not contain an
            entry from input table N.
       * always: Rows are included if they contain an entry from
            input table N (overrides any match and nomatch settings
            of other tables).
       * default: Input table N has no special effect on whether
            rows are included.

      [Default: default]

   fixcols = none|dups|all       
   (uk.ac.starlink.ttools.task.JoinFixActionParameter$Fixer)
      Determines how input columns are renamed before use in the
      output table. The choices are:

       * none: columns are not renamed
       * dups: columns which would otherwise have duplicate names in
            the output will be renamed to indicate which table they
            came from
       * all: all columns will be renamed to indicate which table
            they came from

      If columns are renamed, the new ones are determined by
      suffix* parameters.

      [Default: dups]

   suffixN = <label>       (String)
      If the fixcols parameter is set so that input columns are
      renamed for insertion into the output table, this parameter
      determines how the renaming is done. It gives a suffix which
      is appended to all renamed columns from table N.

      [Default: _N]

   progress = none|log|time|profile       (String)
      Determines whether information on progress of the match should
      be output to the standard error stream as it progresses. For
      lengthy matches this is a useful reassurance and can give
      guidance about how much longer it will take. It can also be
      useful as a performance diagnostic.

      The options are:

       * none: no progress is shown
       * log: progress information is shown
       * time: progress information and some time profiling
            information is shown
       * profile: progress information and limited time/memory
            profiling information are shown

      [Default: log]

   runner =
   parallel|parallel<n>|parallel-all|sequential|classic|partest
         (uk.ac.starlink.table.RowRunner)
      Selects the threading implementation. The options are
      currently:

       * parallel: uses multithreaded implementation for large
            tables, with default parallelism, which is the smaller
            of 6 and the number of available processors
       * parallel<n>: uses multithreaded implementation for large
            tables, with parallelism given by the supplied value
            <n>
       * parallel-all: uses multithreaded implementation for large
            tables, with a parallelism given by the number of
            available processors
       * sequential: uses multithreaded implementation but with only
            a single thread
       * classic: uses legacy sequential implementation
       * partest: uses multithreaded implementation even when tables
            are small

      The parallel* options should normally run faster than
      sequential or classic (which are provided mainly for testing
      purposes), at least for large matches and where multiple
      processing cores are available.

      The default value "parallel" is currently limited to a
      parallelism of 6 since larger values yield diminishing returns
      given that some parts of the matching algorithms run
      sequentially (Amdahl's Law), and using too many threads can
      sometimes end up doing more work or impacting on other
      operations on the same machine. But you can experiment with
      other concurrencies, e.g. "parallel16" to run on 16 cores (if
      available) or "parallel-all" to run on all available cores.

      The value of this parameter should make no difference to the
      matching results. If you notice any discrepancies please
      report them.

      [Default: parallel]
'''
    task = _stilts.getTaskFactory().createObject('tmatchn')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tmulti(in_, **kwargs):
    '''\
Writes multiple tables to a single container file.

Parameters:

   in_ = <table> [<table> ...]       
   (uk.ac.starlink.ttools.task.TableProducer[])
      Array of input tables.

   multi = true|false       (Boolean)
      Determines whether all tables, or just the first one, from
      input table files will be used. If set false, then just the
      first table from each file named by in will be used. If true,
      then all tables present in those input files will be used.
      This only has an effect for file formats which are capable of
      containing more than one table, which effectively means FITS
      and VOTable and their variants.

      [Default: false]

   out = <out-file>       (uk.ac.starlink.util.Destination)
      The location of the output file. This is usually a filename to
      write to. If it is equal to the special value "-" the output
      will be written to standard output.

      [Default: -]
'''
    task = _stilts.getTaskFactory().createObject('tmulti')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def tmultin(**kwargs):
    '''\
Writes multiple processed tables to single container file.

Parameters:

   nin = <count>       (Integer)
      The number of input tables for this task. For each of the
      input tables N there will be associated parameters ifmtN, inN
      and icmdN.

   inN = <tableN>       (uk.ac.starlink.table.StarTable)
      Input table.

   out = <out-file>       (uk.ac.starlink.util.Destination)
      The location of the output file. This is usually a filename to
      write to. If it is equal to the special value "-" the output
      will be written to standard output.

      [Default: -]
'''
    task = _stilts.getTaskFactory().createObject('tmultin')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def tpipe(in_, **kwargs):
    '''\
Performs pipeline processing on a table.

The return value is the resulting table.

Parameters:

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.
'''
    task = _stilts.getTaskFactory().createObject('tpipe')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tskymap(in_, **kwargs):
    '''\
Calculates sky density maps.

The return value is the resulting table.

Parameters:

   in_ = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   lon = <expr/deg>       (String)
      Longitude in degrees for the position of each row in the input
      table. This may simply be a column name, or it may be an
      algebraic expression as explained in SUN/256. The sky system
      used here will determine the grid on which the output map is
      built.

   lat = <expr/deg>       (String)
      Latitude in degrees for the position of each row in the input
      table. This may simply be a column name, or it may be an
      algebraic expression as explained in SUN/256. The sky system
      used here will determine the grid on which the output map is
      built.

   tiling = hpx<K>|healpixnest<K>|healpixring<K>|htm<K>       
   (uk.ac.starlink.ttools.cone.SkyTiling)
      Describes the sky tiling scheme that is in use. One of the
      following values may be used:

       * hpxK: alias for healpixnestK
       * healpixnestK: HEALPix using the Nest scheme at order K
       * healpixringK: HEALPix using the Ring scheme at order K
       * htmK: Hierarchical Triangular Mesh at level K

      So for instance hpx5 or healpixnest5 would both indicate the
      HEALPix NEST tiling scheme at order 5.

      At level K, there are 12*4^K HEALPix pixels, or 8*4^K HTM
      pixels on the sky. More information about these tiling schemes
      can be found at the HEALPix and HTM web sites.

      [Default: hpx5]

   count = true|false       (Boolean)
      Controls whether a COUNT column is added to the output table
      along with any other columns that may have been requested. If
      included, this reports the number of rows from the input table
      that fell within the corresponding bin.

      [Default: true]

   cols = <expr>[;<combiner>[;<name>]] ...       (String[])
      Defines the quantities to be calculated. The value is a
      space-separated list of items, one for each aggregated column
      in the output table.

      Each item is composed of one, two or three tokens, separated
      by semicolon (";") characters:

       * <expr>: (required) column name or expression using the
            expression language for the quantity to be aggregated.
       * <combiner>: (optional) combination method, using the same
            options as for the combine parameter. If omitted, the
            value specified for that parameter will be used.
       * <name>: (optional) name of output column; if omitted, the
            <expr> value (perhaps somewhat sanitised) will be used.

      It is often sufficient just to supply a space-separated list
      of input table column names for this parameter, but the
      additional syntax may be required for instance if it's
      required to calculate both a sum and mean of the same input
      column.

   combine =
   sum|sum-per-unit|count|count-per-unit|mean|median|Q1|Q3|min|max|stdev|hit
         (uk.ac.starlink.ttools.plot2.layer.Combiner)
      Defines the default way that values contributing to the same
      density map bin are combined together to produce the value
      assigned to that bin. Possible values are:

       * sum: the sum of all the combined values per bin
       * sum-per-unit: the sum of all the combined values per unit
            of bin size
       * count: the number of non-blank values per bin (weight is
            ignored)
       * count-per-unit: the number of non-blank values per unit of
            bin size (weight is ignored)
       * mean: the mean of the combined values
       * median: the median
       * Q1: first quartile
       * Q3: third quartile
       * min: the minimum of all the combined values
       * max: the maximum of all the combined values
       * stdev: the sample standard deviation of the combined values
       * hit: 1 if any values present, NaN otherwise (weight is
            ignored)

      For density-like values (count-per-unit, sum-per-unit) the
      scaling is additionally influenced by the perunit parameter.

      Note this value may be overridden on a per-column basis by the
      cols parameter.

      [Default: mean]

   perunit = steradian|degree2|arcmin2|arcsec2|mas2|uas2       
   (uk.ac.starlink.ttools.plot2.layer.SolidAngleUnit)
      Defines the unit of sky area used for scaling density-like
      combinations (e.g. combine=count-per-unit or sum-per-unit). If
      the combination mode is calculating values per unit area this
      configures the area scale in question. For non-density-like
      combination modes (e.g. combine=sum or mean) it has no effect.

      Possible values are:

       * steradian: steradian
       * degree2: square degree
       * arcmin2: square arcminute
       * arcsec2: square arcsecond
       * mas2: square milliarcsec
       * uas2: square microarcsec

      [Default: degree2]

   complete = true|false       (Boolean)
      Determines whether the output table contains a row for every
      pixel in the tiling, or only the rows for pixels in which some
      of the input data fell.

      The value of this parameter may affect performance as well as
      output. If you know that most pixels on the sky will be
      covered, it's probably a good idea to set this true, and if
      you know that only a small patch of sky will be covered, it's
      better to set it false.

      [Default: false]

   runner = sequential|parallel|parallel<n>|partest       
   (uk.ac.starlink.table.RowRunner)
      Selects the threading implementation, i.e. to what extent
      processing is done in parallel. The options are currently:

       * sequential: runs using only a single thread
       * parallel: runs using multiple threads for large tables,
            with parallelism given by the number of available
            processors
       * parallel<n>: runs using multiple threads for large tables,
            with parallelism given by the supplied value <n>
       * partest: runs using multiple threads even when tables are
            small (only intended for testing purposes)

      Using parallel processing can speed up execution considerably;
      however, depending on the I/O operations required, it can also
      slow it down by disrupting patterns of disk access. If the
      content of a file is on a solid state disk, or is already in
      cache for instance because a similar command has been run
      recently, then parallel will probably be faster. However, if
      the data is being read directly from a spinning disk, for
      instance because the file is too large to fit in RAM, then
      sequential or parallel<n> with a small <n> may be faster.

      The value of this parameter should make only very tiny
      differences to the output table. If you notice significant
      discrepancies please report them.

      [Default: parallel]
'''
    task = _stilts.getTaskFactory().createObject('tskymap')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in_', _map_env_value(in_))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def tskymatch2(in1, in2, **kwargs):
    '''\
Crossmatches 2 tables on sky position.

The return value is the resulting table.

Parameters:

   in1 = <table1>       (uk.ac.starlink.table.StarTable)
      Input table.

   in2 = <table2>       (uk.ac.starlink.table.StarTable)
      Input table.

   ra1 = <expr>       (String)
      Right ascension in degrees for the position of each row of
      table 1. This may simply be a column name, or it may be an
      algebraic expression calculated from columns as explained in
      SUN/256. If left blank, an attempt is made to guess from UCDs,
      column names and unit annotations what expression to use.

   dec1 = <expr>       (String)
      Declination in degrees for the position of each row of table
      1. This may simply be a column name, or it may be an algebraic
      expression calculated from columns as explained in SUN/256. If
      left blank, an attempt is made to guess from UCDs, column
      names and unit annotations what expression to use.

   ra2 = <expr>       (String)
      Right ascension in degrees for the position of each row of
      table 2. This may simply be a column name, or it may be an
      algebraic expression calculated from columns as explained in
      SUN/256. If left blank, an attempt is made to guess from UCDs,
      column names and unit annotations what expression to use.

   dec2 = <expr>       (String)
      Declination in degrees for the position of each row of table
      2. This may simply be a column name, or it may be an algebraic
      expression calculated from columns as explained in SUN/256. If
      left blank, an attempt is made to guess from UCDs, column
      names and unit annotations what expression to use.

   error = <value/arcsec>       (Double)
      The maximum separation permitted between two objects for them
      to count as a match. Units are arc seconds.

   tuning = <healpix-k>       (Integer)
      Tuning parameter that controls the pixel size used when
      binning the rows. The legal range is from 0 (corresponding to
      pixel size of about 60 degrees) to 20 (about 0.2 arcsec). The
      value of this parameter will not affect the result but may
      affect the performance in terms of CPU and memory resources
      required. A default value will be chosen based on the size of
      the error parameter, but it may be possible to improve
      performance by adjusting the default value. The value used can
      be seen by examining the progress output. If your match is
      taking a long time or is failing from lack of memory it may be
      worth trying different values for this parameter.

   join = 1and2|1or2|all1|all2|1not2|2not1|1xor2       
   (uk.ac.starlink.table.join.JoinType)
      Determines which rows are included in the output table. The
      matching algorithm determines which of the rows from the first
      table correspond to which rows from the second. This parameter
      determines what to do with that information. Perhaps the most
      obvious thing is to write out a table containing only rows
      which correspond to a row in both of the two input tables.
      However, you may also want to see the unmatched rows from one
      or both input tables, or rows present in one table but
      unmatched in the other, or other possibilities. The options
      are:

       * 1and2: An output row for each row represented in both input
            tables (INNER JOIN)
       * 1or2: An output row for each row represented in either or
            both of the input tables (FULL OUTER JOIN)
       * all1: An output row for each matched or unmatched row in
            table 1 (LEFT OUTER JOIN)
       * all2: An output row for each matched or unmatched row in
            table 2 (RIGHT OUTER JOIN)
       * 1not2: An output row only for rows which appear in the
            first table but are not matched in the second table
       * 2not1: An output row only for rows which appear in the
            second table but are not matched in the first table
       * 1xor2: An output row only for rows represented in one of
            the input tables but not the other one

      [Default: 1and2]

   find = all|best|best1|best2       
   (uk.ac.starlink.table.join.PairMode)
      Determines what happens when a row in one table can be matched
      by more than one row in the other table. The options are:

       * all: All matches. Every match between the two tables is
            included in the result. Rows from both of the input
            tables may appear multiple times in the result.
       * best: Best match, symmetric. The best pairs are selected in
            a way which treats the two tables symmetrically. Any
            input row which appears in one result pair is
            disqualified from appearing in any other result pair, so
            each row from both input tables will appear in at most
            one row in the result.
       * best1: Best match for each Table 1 row. For each row in
            table 1, only the best match from table 2 will appear in
            the result. Each row from table 1 will appear a maximum
            of once in the result, but rows from table 2 may appear
            multiple times.
       * best2: Best match for each Table 2 row. For each row in
            table 2, only the best match from table 1 will appear in
            the result. Each row from table 2 will appear a maximum
            of once in the result, but rows from table 1 may appear
            multiple times.

      The differences between best, best1 and best2 are a bit
      subtle. In cases where it's obvious which object in each table
      is the best match for which object in the other, choosing
      betwen these options will not affect the result. However, in
      crowded fields (where the distance between objects within one
      or both tables is typically similar to or smaller than the
      specified match radius) it will make a difference. In this
      case one of the asymmetric options (best1 or best2) is usually
      more appropriate than best, but you'll have to think about
      which of them suits your requirements. The performance (time
      and memory usage) of the match may also differ between these
      options, especially if one table is much bigger than the
      other.

      [Default: best]

   runner =
   parallel|parallel<n>|parallel-all|sequential|classic|partest
         (uk.ac.starlink.table.RowRunner)
      Selects the threading implementation. The options are
      currently:

       * parallel: uses multithreaded implementation for large
            tables, with default parallelism, which is the smaller
            of 6 and the number of available processors
       * parallel<n>: uses multithreaded implementation for large
            tables, with parallelism given by the supplied value
            <n>
       * parallel-all: uses multithreaded implementation for large
            tables, with a parallelism given by the number of
            available processors
       * sequential: uses multithreaded implementation but with only
            a single thread
       * classic: uses legacy sequential implementation
       * partest: uses multithreaded implementation even when tables
            are small

      The parallel* options should normally run faster than
      sequential or classic (which are provided mainly for testing
      purposes), at least for large matches and where multiple
      processing cores are available.

      The default value "parallel" is currently limited to a
      parallelism of 6 since larger values yield diminishing returns
      given that some parts of the matching algorithms run
      sequentially (Amdahl's Law), and using too many threads can
      sometimes end up doing more work or impacting on other
      operations on the same machine. But you can experiment with
      other concurrencies, e.g. "parallel16" to run on 16 cores (if
      available) or "parallel-all" to run on all available cores.

      The value of this parameter should make no difference to the
      matching results. If you notice any discrepancies please
      report them.

      [Default: parallel]
'''
    task = _stilts.getTaskFactory().createObject('tskymatch2')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('in1', _map_env_value(in1))
    env.setValue('in2', _map_env_value(in2))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    table = task.createProducer(env).getTable()
    _check_unused_args(env)
    return import_star_table(table)

def votcopy(**kwargs):
    '''\
Transforms between VOTable encodings.

Parameters:

   in_ = <location>       (String)
      Location of the input VOTable. May be a URL, filename, or "-"
      to indicate standard input. The input table may be compressed
      using one of the known compression formats (Unix compress,
      gzip or bzip2).

      [Default: -]

   out = <location>       (String)
      Location of the output VOTable. May be a filename or "-" to
      indicate standard output.

      [Default: -]

   format = TABLEDATA|BINARY|BINARY2|FITS       
   (uk.ac.starlink.votable.DataFormat)
      Determines the encoding format of the table data in the output
      document. If null is selected, then the tables will be
      data-less (will contain no DATA element), leaving only the
      document structure. Data-less tables are legal VOTable
      elements.

      The BINARY2 format is only available for version=1.3

      [Default: TABLEDATA]

   version = 1.0|1.1|1.2|1.3|1.4       
   (uk.ac.starlink.votable.VOTableVersion)
      Determines the version of the VOTable standard to which the
      output will conform. If null (the default), the output table
      will have the same version as the input table.

   charset = <xml-encoding>       (java.nio.charset.Charset)
      Selects the Unicode encoding used for the output XML. The
      available options are dependent on your JVM, use help=charset
      for a full listing. Setting the value null will use the JVM's
      system default.

      [Default: UTF-8]

   cache = true|false       (Boolean)
      Determines whether the input tables are read into a cache
      prior to being written out. The default is selected
      automatically depending on the input table; so you should
      normally leave this flag alone.

   href = true|false       (Boolean)
      In the case of BINARY or FITS encoding, this determines
      whether the STREAM elements output will contain their data
      inline or externally. If set false, the output document will
      be self-contained, with STREAM data inline as base64-encoded
      characters. If true, then for each TABLE in the document the
      binary data will be written to a separate file and referenced
      by an href attribute on the corresponding STREAM element. The
      name of these files is usually determined by the name of the
      main output file; but see also the base flag.

   nomagic = true|false       (Boolean)
      Eliminate the null attributes of VALUES elements where they
      are no longer required. In VOTable versions <=1.2, the only
      way to specify null values for integer-type scalar columns was
      to use the null attribute of the VALUES element to indicate an
      in-band magic value representing null. From VOTable v1.3, null
      values can be represented using empty <TD> elements or flagged
      specially in BINARY2 streams. In these cases, it is
      recommended (though not required) not to use the VALUES/null
      mechanism.

      If this parameter is set true, then any VALUES/null attributes
      will be removed in VOTable 1.3 BINARY2 or TABLEDATA output. If
      this results in an empty VALUES element, it too will be
      removed.

      This parameter is ignored if the output VOTable version is
      lower than 1.3 or if format=BINARY/FITS.

      [Default: true]

   base = <location>       (String)
      Determines the name of external output files written when the
      href flag is true. Normally these are given names based on the
      name of the output file. But if this flag is given, the names
      will be based on the <location> string. This flag is
      compulsory if href is true and out=- (output is to standard
      out), since in this case there is no default base name to use.
'''
    task = _stilts.getTaskFactory().createObject('votcopy')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def votlint(votable, **kwargs):
    '''\
Validates VOTable documents.

Parameters:

   votable = <location>       (java.io.InputStream)
      Location of the VOTable to be checked. This may be a filename,
      URL or "-" (the default), to indicate standard input. The
      input may be compressed using one of the known compression
      formats (Unix compress, gzip or bzip2).

   ucd = true|false       (Boolean)
      If true, the ucd attributes on FIELD and PARAM elements etc
      are checked for conformance against the UCD1+ standard or a
      list of known UCD1 terms.

      [Default: true]

   unit = true|false       (Boolean)
      If true, the unit attributes on FIELD and PARAM elements are
      checked for conformance against the VOUnits standard; if
      false, no such checks are made.

      The VOTable 1.4 standard recommends use of VOUnits, though
      there are some inconsistencies in the text on this topic.
      Earlier VOTable versions refer to a different (CDS) unit
      syntax, which is not checked by votlint. So by default unit
      syntax is checked when the VOTable is 1.4 or greater, and not
      for earlier versions, but that can be overridden by giving a
      true or false value for this parameter.

      The wording of the VOTable and VOUnit standards do not
      strictly require use of VOUnit syntax even at VOTable 1.4, so
      failed checks result in Warning rather than Error reports.

   maxrepeat = <int-value>       (Integer)
      Puts a limit on the number of times that the same issue will
      be reported. With this set to a relatively small number, the
      output is not cluttered with many repetitions of the same
      problem.

      [Default: 4]

   validate = true|false       (Boolean)
      Whether to validate the input document aganist the VOTable
      DTD. If true (the default), then as well as votlint's own
      checks, it is validated against an appropriate version of the
      VOTable DTD which picks up such things as the presence of
      unknown elements and attributes, elements in the wrong place,
      and so on. Sometimes however, particularly when XML namespaces
      are involved, the validator can get confused and may produce a
      lot of spurious errors. Setting this flag false prevents this
      validation step so that only votlint's own checks are
      performed. In this case many violations of the VOTable
      standard concerning document structure will go unnoticed.

      [Default: true]

   version = 1.0|1.1|1.2|1.3|1.4       
   (uk.ac.starlink.votable.VOTableVersion)
      Selects the version of the VOTable standard which the input
      table is supposed to exemplify. The version may also be
      specified within the document using the "version" attribute of
      the document's VOTABLE element; if it is and it conflicts with
      the value specified by this flag, a warning is issued.

      If no value is provided for this parameter (the default), the
      version will be determined from the VOTable itself.

   out = <location>       (uk.ac.starlink.util.Destination)
      Destination file for output messages. May be a filename or "-"
      to indicate standard output.

      [Default: -]
'''
    task = _stilts.getTaskFactory().createObject('votlint')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('votable', _map_env_value(votable))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def xsdvalidate(doc, **kwargs):
    '''\
Validates against XML Schema.

Parameters:

   doc = <location>       (java.io.InputStream)
      Location of XML document to validate.

   schemaloc = <namespace>=<location> ...       (String[])
      Assignments of override schema locations to XML namespaces.
      One or more assignments may be supplied, each of the form
      <namespace>=<location> where the location may be a filename or
      URL. Multiple assignments may be made by supplying the
      parameter multiple times, or using a space character as a
      separator.

      Each assignment causes any reference to the given namespace in
      the validated document to be validated with reference to the
      XSD schema at the given location rather than to a schema
      acquired in the default way (using xsi:schemaLocation
      attributes or using the namespace as a retrieval URL).

   topel = [{<ns-uri>}][<local-name>]       (String)
      Local name of the top-level element expected in the parsed
      document. If the actual parsed top-level element has a local
      name differing from this, an error will be reported. If no
      value is specified (the default) no checking is done.

   verbose = true|false       (Boolean)
      If true, some INFO reports will be displayed alongside any
      ERROR reports resulting from the parse. This may be useful for
      diagnosis or reassurance.

      [Default: false]

   uselocals = true|false       (Boolean)
      Whether to use local copies of VO schemas where available. If
      true, copies of some IVOA schemas stored within the
      application are used instead of retrieving them from their
      http://www.ivoa.net/ URLs. Setting this true is generally
      faster and more robust against network issues, though it may
      risk retrieving out of date copies of the schemas.

      [Default: false]
'''
    task = _stilts.getTaskFactory().createObject('xsdvalidate')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    env.setValue('doc', _map_env_value(doc))
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def plot2plane(**kwargs):
    '''\
Draws a plane plot.

Parameters:

   xpix = <int-value>       (Integer)
      Size of the output image in the X direction in pixels. This
      includes space for any axis labels, padding and other
      decoration outside the plot area itself. See also insets.

      [Default: 500]

   ypix = <int-value>       (Integer)
      Size of the output image in the Y direction in pixels. This
      includes space for any axis labels, padding and other
      decoration outside the plot area itself. See also insets.

      [Default: 400]

   insets = <top>,<left>,<bottom>,<right>       
   (uk.ac.starlink.ttools.plot2.Padding)
      Defines the amount of space in pixels around the actual
      plotting area. This space is used for axis labels, and other
      decorations and any left over forms an empty border.

      The size and position of the actual plotting area is
      determined by this parameter along with xpix and ypix.

      The value of this parameter is 4 comma separated integers:
      <top>,<left>,<bottom>,<right>. Any or all of these values may
      be left blank, in which case the corresponding margin will be
      calculated automatically according to how much space is
      required.

   omode = swing|out|cgi|discard|auto       
   (uk.ac.starlink.ttools.plottask.PaintMode)
      Determines how the drawn plot will be output, see SUN/256.

       * swing: Plot will be displayed in a window on the screen.
            This plot is "live"; it can be resized and (except for
            old-style plots) navigated around with mouse actions in
            the same way as plots in TOPCAT.
       * out: Plot will be written to a file given by out using the
            graphics format given by ofmt.
       * cgi: Plot will be written in a way suitable for CGI use
            direct from a web server. The output is in the graphics
            format given by ofmt, preceded by a suitable
            "Content-type" declaration.
       * discard: Plot is drawn, but discarded. There is no output.
       * auto: Behaves as swing or out mode depending on presence of
            out parameter

      [Default: auto]

   storage =
   simple|memory|disk|policy|cache|basic-cache|persistent|parallel
         (uk.ac.starlink.ttools.plot2.data.DataStoreFactory)
      Determines the way that data is accessed when constructing the
      plot. There are two main options, cached or not. If no caching
      is used then rows are read sequentially from the specified
      input table(s) every time they are required. This generally
      requires a small resource footprint (though that can depend on
      how the table is specified) and makes sense if the data only
      needs to be scanned once or perhaps if the table is very
      large. If caching is used then the required data is read once
      from the specified input table(s), then prepared and cached
      before any plotting is performed, and plots are done using
      this cached data. This may use a significant amount of storage
      for large tables but it's usually more sensible (faster) if
      the data will need to be scanned multiple times. There are
      various options for cache storage.

      The options are:

       * simple: no caching, data read directly from input table
       * memory: cached to memory; OutOfMemoryError possible for
            very large plots
       * disk: cached to disk
       * policy: cached using application-wide default storage
            policy, which is usually adaptive (memory/disk hybrid)
       * persistent: cached to persistent files on disk, in the
            system temporary directory (defined by system property
            java.io.tmpdir). If this is used, plot data will be
            stored on disk in a way that means they can be re-used
            between STILTS invocations, so data preparation can be
            avoided on subsequent runs. Note however it can leave
            potentially large files in your temporary directory.
       * cache: synonym for memory (backward compatibility)
       * basic-cache: dumber version of memory (no optimisation for
            constant-valued columns)
       * parallel: experimental version of memory-based cache that
            reads into the cache in parallel for large files. This
            will make the plot faster to prepare, but interaction is
            a bit slower and sequence-dependent attributes of the
            plot may not come out right. This experimental option
            may be withdrawn or modified in future releases.

      The default value is memory if a live plot is being generated
      (omode=swing), since in that case the plot needs to be redrawn
      every time the user performs plot navigation actions or
      resizes the window, or if animations are being produced.
      Otherwise (e.g. output to a graphics file) the default is
      simple.

      [Default: simple]

   seq = <suffix>[,...]       (String[])
      Contains a comma-separated list of layer suffixes to determine
      the order in which layers are drawn on the plot. This can
      affect which symbol are plotted on top of, and so potentially
      obscure, which other ones.

      When specifying a plot, multiple layers may be specified, each
      introduced by a parameter layer<N>, where <N> is a different
      (arbitrary) suffix labelling the layer, and is appended to all
      the parameters specific to defining that layer.

      By default the layers are drawn on the plot in the order in
      which the layer* parameters appear on the command line.
      However if this parameter is specified, each comma-separated
      element is interpreted as a layer suffix, giving the ordered
      list of layers to plot. Every element of the list must be a
      suffix with a corresponding layer parameter, but missing or
      repeated elements are allowed.

   legend = true|false       (Boolean)
      Whether to draw a legend or not. If no value is supplied, the
      decision is made automatically: a legend is drawn only if it
      would have more than one entry.

   legborder = true|false       (Boolean)
      If true, a line border is drawn around the legend.

      [Default: true]

   legopaque = true|false       (Boolean)
      If true, the background of the legend is opaque, and the
      legend obscures any plot components behind it. Otherwise, it's
      transparent.

      [Default: true]

   legseq = <suffix>[,...]       (String[])
      Determines which layers are represented in the legend (if
      present) and in which order they appear. The legend has a line
      for each layer label (as determined by the leglabelN
      parameter). If multiple layers have the same label, they will
      contribute to the same entry in the legend, with style icons
      plotted over each other. The value of this parameter is a
      comma-separated sequence of layer suffixes, which determines
      the order in which the legend entries appear. Layers with
      suffixes missing from this list do not show up in the legend
      at all.

      If no value is supplied (the default), the sequence is the
      same as the layer plotting sequence (see seq).

   legpos = <xfrac,yfrac>       (double[])
      Determines the internal position of the legend on the plot.
      The value is a comma-separated pair of values giving the X and
      Y positions of the legend within the plotting bounds, so for
      instance "0.5,0.5" will put the legend right in the middle of
      the plot. If no value is supplied, the legend will appear
      outside the plot boundary.

   title = <value>       (String)
      Text of a title to be displayed at the top of the plot. If
      null, the default, no title is shown and there's more space
      for the graphics.

   auxmap = <map-name>|<color>-<color>[-<color>...]       
   (uk.ac.starlink.ttools.plot.Shader)
      Color map used for Aux axis shading.

      A mixed bag of colour ramps are available as listed in
      SUN/256: inferno, magma, plasma, viridis, cividis, cubehelix,
      sron, rainbow, rainbow2, rainbow3, pastel, cosmic, ember,
      gothic, rainforest, voltage, bubblegum, gem, chroma, neon,
      tropical, accent, gnuplot, gnuplot2, specxby, set1, paired,
      hotcold, guppy, iceburn, redshift, pride, rdbu, piyg, brbg,
      cyan-magenta, red-blue, brg, heat, cold, light, greyscale,
      colour, standard, bugn, bupu, orrd, pubu, purd, painbow,
      huecl, infinity, hue, intensity, rgb_red, rgb_green, rgb_blue
      , hsv_h, hsv_s, hsv_v, yuv_y, yuv_u, yuv_v, scale_hsv_s,
      scale_hsv_v, scale_yuv_y, mask, blacker, whiter, transparency
      . Note: many of these, including rainbow-like ones, are
      frowned upon by the visualisation community.

      You can also construct your own custom colour map by giving a
      sequence of colour names separated by minus sign ("-")
      characters. In this case the ramp is a linear interpolation
      between each pair of colours named, using the same syntax as
      when specifying a colour value. So for instance "
      yellow-hotpink-#0000ff" would shade from yellow via hot pink
      to blue.

      [Default: inferno]

   auxclip = <lo>,<hi>       (uk.ac.starlink.ttools.plot2.Subrange)
      Defines a subrange of the colour ramp to be used for Aux
      shading. The value is specified as a (low,high)
      comma-separated pair of two numbers between 0 and 1.

      If the full range 0,1 is used, the whole range of colours
      specified by the selected shader will be used. But if for
      instance a value of 0,0.5 is given, only those colours at the
      left hand end of the ramp will be seen.

      If the null (default) value is chosen, a default clip will be
      used. This generally covers most or all of the range 0-1 but
      for colour maps which fade to white, a small proportion of the
      lower end may be excluded, to ensure that all the colours are
      visually distinguishable from a white background. This default
      is usually a good idea if the colour map is being used with
      something like a scatter plot, where markers are plotted
      against a white background. However, for something like a
      density map when the whole plotting area is tiled with colours
      from the map, it may be better to supply the whole range 0,1
      explicitly.

   auxflip = true|false       (Boolean)
      If true, the colour map on the Aux axis will be reversed.

      [Default: false]

   auxquant = <number>       (Double)
      Allows the colour map used for the Aux axis to be quantised.
      If an integer value N is chosen then the colour map will be
      viewed as N discrete evenly-spaced levels, so that only N
      different colours will appear in the plot. This can be used to
      generate a contour-like effect, and may make it easier to
      trace the boundaries of regions of interest by eye.

      If left blank, the colour map is nominally continuous (though
      in practice it may be quantised to a medium-sized number like
      256).

   auxfunc = log|linear|histogram|histolog|sqrt|square|acos|cos
         (uk.ac.starlink.ttools.plot2.Scaling)
      Defines the way that values in the Aux range are mapped to the
      selected colour ramp.

      The available options are:

       * log: Logarithmic scaling
       * linear: Linear scaling
       * histogram: Scaling follows data distribution, with linear
            axis
       * histolog: Scaling follows data distribution, with
            logarithmic axis
       * sqrt: Square root scaling
       * square: Square scaling
       * acos: Arccos Scaling
       * cos: Cos Scaling

      For all these options, the full range of data values is used,
      and displayed on the colour bar if applicable. The Linear,
      Log, Square and Sqrt options just apply the named function to
      the full data range. The histogram options on the other hand
      use a scaling function that corresponds to the actual
      distribution of the data, so that there are about the same
      number of points (or pixels, or whatever is being scaled) of
      each colour. The histogram options are somewhat more
      expensive, but can be a good choice if you are exploring data
      whose distribution is unknown or not well-behaved over its
      min-max range. The Histogram and HistoLog options both assign
      the colours in the same way, but they display the colour ramp
      with linear or logarithmic annotation respectively; the
      HistoLog option also ignores non-positive values.

      [Default: linear]

   auxmin = <number>       (Double)
      Minimum value of the data coordinate on the Aux axis. This
      sets the value before any subranging is applied. If not
      supplied, the value is determined from the plotted data.

   auxmax = <number>       (Double)
      Maximum value of the data coordinate on the Aux axis. This
      sets the value before any subranging is applied. If not
      supplied, the value is determined from the plotted data.

   auxlabel = <text>       (String)
      Sets the label used to annotate the aux axis, if it is
      visible.

   auxcrowd = <factor>       (Double)
      Determines how closely the tick marks are spaced on the Aux
      axis, if visible. The default value is 1, meaning normal
      crowding. Larger values result in more ticks, and smaller
      values fewer ticks. Tick marks will not however be spaced so
      closely that the labels overlap each other, so to get very
      closely spaced marks you may need to reduce the font size as
      well.

      [Default: 1.0]

   auxwidth = <pixels>       (Integer)
      Determines the lateral size of the aux colour ramp, if
      visible, in pixels.

      [Default: 15]

   auxvisible = true|false       (Boolean)
      Determines whether the aux axis colour ramp is displayed
      alongside the plot.

      If not supplied (the default), the aux axis will be visible
      when aux shading is used in any of the plotted layers.

   forcebitmap = true|false       (Boolean)
      Affects whether rendering of the data contents of a plot
      (though not axis labels etc) is always done to an intermediate
      bitmap rather than, where possible, being painted using
      graphics primitives. This is a rather arcane setting that may
      nevertheless have noticeable effects on the appearance and
      size of an output graphics file, as well as plotting time. For
      some types of plot (e.g. shadingN=auto or shadingN=density) it
      will have no effect, since this kind of rendering happens in
      any case.

      When writing to vector graphics formats (PDF and PostScript),
      setting it true will force the data contents to be bitmapped.
      This may make the output less beautiful (round markers will no
      longer be perfectly round), but it may result in a much
      smaller file if there are very many data points.

      When writing to bitmapped output formats (PNG, GIF, JPEG,
      ...), it fixes shapes to be the same as seen on the screen
      rather than be rendered at the mercy of the graphics system,
      which sometimes introduces small distortions.

      [Default: false]

   compositor = 0..1       
   (uk.ac.starlink.ttools.plot2.paper.Compositor)
      Defines how multiple overplotted partially transparent pixels
      are combined to form a resulting colour. The way this is used
      depends on the details of the specified plot.

      Currently, this parameter takes a "boost" value in the range
      0..1. If the value is zero, saturation semantics are used: RGB
      colours are added in proporition to their associated alpha
      value until the total alpha is saturated (reaches 1), after
      which additional pixels have no further effect. For larger
      boost values, the effect is similar, but any non-zero alpha in
      the output is boosted to the given minimum value. The effect
      of this is that even very slightly populated pixels can be
      visually distinguished from unpopulated ones which may not be
      the case for saturation composition.

      [Default: 0.05]

   animate = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   parallel = <int-value>       (Integer)
      Determines how many threads will run in parallel if animation
      output is being produced. Only used if the animate parameter
      is supplied. The default value is the number of processors
      apparently available to the JVM.

      [Default: 20]

   xlog = true|false       (Boolean)
      If false (the default), the scale on the X axis is linear, if
      true it is logarithmic.

      [Default: false]

   ylog = true|false       (Boolean)
      If false (the default), the scale on the Y axis is linear, if
      true it is logarithmic.

      [Default: false]

   xflip = true|false       (Boolean)
      If true, the scale on the X axis will increase in the opposite
      sense from usual (e.g. right to left rather than left to
      right).

      [Default: false]

   yflip = true|false       (Boolean)
      If true, the scale on the Y axis will increase in the opposite
      sense from usual (e.g. right to left rather than left to
      right).

      [Default: false]

   xlabel = <text>       (String)
      Gives a label to be used for annotating axis X A default value
      based on the plotted data will be used if no value is
      supplied.

      [Default: X]

   ylabel = <text>       (String)
      Gives a label to be used for annotating axis Y A default value
      based on the plotted data will be used if no value is
      supplied.

      [Default: Y]

   aspect = <number>       (Double)
      Ratio of the unit length on the X axis to the unit length on
      the Y axis. If set to 1, the space will be isotropic. If not
      set (the default) the ratio will be determined by the given or
      calculated data bounds on both axes and the shape of the
      plotting region.

   grid = true|false       (Boolean)
      If true, grid lines are drawn on the plot at positions
      determined by the major tick marks. If false, they are absent.

      [Default: false]

   xcrowd = <number>       (Double)
      Determines how closely the tick marks are spaced on the X
      axis. The default value is 1, meaning normal crowding. Larger
      values result in more ticks, and smaller values fewer ticks.
      Tick marks will not however be spaced so closely that the
      labels overlap each other, so to get very closely spaced marks
      you may need to reduce the font size as well.

      [Default: 1]

   ycrowd = <number>       (Double)
      Determines how closely the tick marks are spaced on the Y
      axis. The default value is 1, meaning normal crowding. Larger
      values result in more ticks, and smaller values fewer ticks.
      Tick marks will not however be spaced so closely that the
      labels overlap each other, so to get very closely spaced marks
      you may need to reduce the font size as well.

      [Default: 1]

   minor = true|false       (Boolean)
      If true, minor tick marks are painted along the axes as well
      as the major tick marks. Minor tick marks do not have
      associated grid lines.

      [Default: true]

   gridcolor = <rrggbb>|red|blue|...       (java.awt.Color)
      The color of the plot grid, given by name or as a hexadecimal
      RGB value.

      The standard plotting colour names are red, blue, green, grey
      , magenta, cyan, orange, pink, yellow, black, light_grey,
      white. However, many other common colour names (too many to
      list here) are also understood. The list currently contains
      those colour names understood by most web browsers, from
      AliceBlue to YellowGreen, listed e.g. in the Extended color
      keywords section of the CSS3 standard.

      Alternatively, a six-digit hexadecimal number RRGGBB may be
      supplied, optionally prefixed by "#" or "0x", giving red,
      green and blue intensities, e.g. "ff00ff", "#ff00ff" or "
      0xff00ff" for magenta.

      [Default: light_grey]

   labelcolor = <rrggbb>|red|blue|...       (java.awt.Color)
      The color of axis labels and other plot annotations, given by
      name or as a hexadecimal RGB value.

      The standard plotting colour names are red, blue, green, grey
      , magenta, cyan, orange, pink, yellow, black, light_grey,
      white. However, many other common colour names (too many to
      list here) are also understood. The list currently contains
      those colour names understood by most web browsers, from
      AliceBlue to YellowGreen, listed e.g. in the Extended color
      keywords section of the CSS3 standard.

      Alternatively, a six-digit hexadecimal number RRGGBB may be
      supplied, optionally prefixed by "#" or "0x", giving red,
      green and blue intensities, e.g. "ff00ff", "#ff00ff" or "
      0xff00ff" for magenta.

      [Default: black]

   texttype = plain|antialias|latex       (TextSyntax)
      Determines how to turn label text into characters on the plot.
      Plain and Antialias both take the text at face value, but
      Antialias smooths the characters. LaTeX interprets the text as
      LaTeX source code and typesets it accordingly.

      When not using LaTeX, antialiased text usually looks nicer,
      but can be perceptibly slower to plot. At time of writing, on
      MacOS antialiased text seems to be required to stop the
      writing coming out upside-down for non-horizontal text (MacOS
      java bug).

      [Default: plain]

   fontsize = <int-value>       (Integer)
      Size of the text font in points.

      [Default: 12]

   fontstyle = standard|serif|mono       (FontType)
      Font style for text.

      The available options are:

       * standard
       * serif
       * mono

      [Default: standard]

   fontweight = plain|bold|italic|bold_italic       (FontWeight)
      Font weight for text.

      The available options are:

       * plain
       * bold
       * italic
       * bold_italic

      [Default: plain]

   xmin = <number>       (Double)
      Minimum value of the data coordinate on the X axis. This sets
      the value before any subranging is applied. If not supplied,
      the value is determined from the plotted data.

   xmax = <number>       (Double)
      Maximum value of the data coordinate on the X axis. This sets
      the value before any subranging is applied. If not supplied,
      the value is determined from the plotted data.

   xsub = <lo>,<hi>       (uk.ac.starlink.ttools.plot2.Subrange)
      Defines a normalised adjustment to the data range of the X
      axis. The value may be specified as a comma-separated pair of
      two numbers, giving the lower and upper bounds of the range of
      of interest respectively. This sub-range is applied to the
      data range that would otherwise be used, either automatically
      calculated or explicitly supplied; zero corresponds to the
      lower bound and one to the upper.

      The default value "0,1" therefore has no effect. The range
      could be restricted to its lower half with the value 0,0.5.

      [Default: 0,1]

   ymin = <number>       (Double)
      Minimum value of the data coordinate on the Y axis. This sets
      the value before any subranging is applied. If not supplied,
      the value is determined from the plotted data.

   ymax = <number>       (Double)
      Maximum value of the data coordinate on the Y axis. This sets
      the value before any subranging is applied. If not supplied,
      the value is determined from the plotted data.

   ysub = <lo>,<hi>       (uk.ac.starlink.ttools.plot2.Subrange)
      Defines a normalised adjustment to the data range of the Y
      axis. The value may be specified as a comma-separated pair of
      two numbers, giving the lower and upper bounds of the range of
      of interest respectively. This sub-range is applied to the
      data range that would otherwise be used, either automatically
      calculated or explicitly supplied; zero corresponds to the
      lower bound and one to the upper.

      The default value "0,1" therefore has no effect. The range
      could be restricted to its lower half with the value 0,0.5.

      [Default: 0,1]

   navaxes = xy|x|y       (boolean[])
      Determines the axes which are affected by the interactive
      navigation actions (pan and zoom). The default is xy, which
      means that the various mouse gestures will provide panning and
      zooming in both X and Y directions. However, if it is set to
      (for instance) x then the mouse will only allow panning and
      zooming in the horizontal direction, with the vertical extent
      fixed.

      [Default: xy]

   xanchor = true|false       (Boolean)
      If true, then zoom actions will work in such a way that the
      zero point on the X axis stays in the same position on the
      plot.

      [Default: false]

   yanchor = true|false       (Boolean)
      If true, then zoom actions will work in such a way that the
      zero point on the Y axis stays in the same position on the
      plot.

      [Default: false]

   zoomfactor = <number>       (Double)
      Sets the amount by which the plot view zooms in or out for
      each unit of mouse wheel movement. A value of 1 means that
      mouse wheel zooming has no effect. A higher value means that
      the mouse wheel zooms faster and a value nearer 1 means it
      zooms slower. Values below 1 are not permitted.

      [Default: 1.2]

   leglabelN = <text>       (String)
      Sets the presentation label for the layer with a given suffix.
      This is the text which is displayed in the legend, if present.
      Multiple layers may use the same label, in which case they
      will be combined to form a single legend entry.

      If no value is supplied (the default), the suffix itself is
      used as the label.

   layerN = <layer-type> <layerN-specific-params>       
   (uk.ac.starlink.ttools.plot2.task.LayerType)
      Selects one of the available plot types for layerN. A plot
      consists of a plotting surface, set up using the various
      unsuffixed parameters of the plotting command, and zero or
      more plot layers. Each layer is introduced by a parameter with
      the name layer<N> where the suffix "<N>" is a label
      identifying the layer and is appended to all the parameter
      names which configure that layer. Suffixes may be any string,
      including the empty string.

      This parameter may take one of the following values, described
      in more detail in SUN/256:

       * mark
       * size
       * sizexy
       * xyvector
       * xyerror
       * xyellipse
       * xycorr
       * link2
       * mark2
       * poly4
       * mark4
       * polygon
       * area
       * central
       * lines
       * marks
       * handles
       * yerrors
       * xyerrors
       * statline
       * statmark
       * arrayquantile
       * line
       * linearfit
       * label
       * arealabel
       * contour
       * grid
       * fill
       * quantile
       * histogram
       * kde
       * knn
       * densogram
       * gaussian
       * function

      Each of these layer types comes with a list of type-specific
      parameters to define the details of that layer, including some
      or all of the following groups:

       * input table parameters (e.g. inN, icmdN)
       * coordinate params referring to input table columns (e.g.
            xN, yN)
       * layer style parameters (e.g. shadingN, colorN)

      Every parameter notionally carries the same suffix N. However,
      if the suffix is not present, the application will try looking
      for a parameter with the same name with no suffix instead. In
      this way, if several layers have the same value for a given
      parameter (for instance input table), you can supply it using
      one unsuffixed parameter to save having to supply several
      parameters with the same value but different suffixes.
'''
    task = _stilts.getTaskFactory().createObject('plot2plane')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def plot2sky(**kwargs):
    '''\
Draws a sky plot.

Parameters:

   xpix = <int-value>       (Integer)
      Size of the output image in the X direction in pixels. This
      includes space for any axis labels, padding and other
      decoration outside the plot area itself. See also insets.

      [Default: 500]

   ypix = <int-value>       (Integer)
      Size of the output image in the Y direction in pixels. This
      includes space for any axis labels, padding and other
      decoration outside the plot area itself. See also insets.

      [Default: 400]

   insets = <top>,<left>,<bottom>,<right>       
   (uk.ac.starlink.ttools.plot2.Padding)
      Defines the amount of space in pixels around the actual
      plotting area. This space is used for axis labels, and other
      decorations and any left over forms an empty border.

      The size and position of the actual plotting area is
      determined by this parameter along with xpix and ypix.

      The value of this parameter is 4 comma separated integers:
      <top>,<left>,<bottom>,<right>. Any or all of these values may
      be left blank, in which case the corresponding margin will be
      calculated automatically according to how much space is
      required.

   omode = swing|out|cgi|discard|auto       
   (uk.ac.starlink.ttools.plottask.PaintMode)
      Determines how the drawn plot will be output, see SUN/256.

       * swing: Plot will be displayed in a window on the screen.
            This plot is "live"; it can be resized and (except for
            old-style plots) navigated around with mouse actions in
            the same way as plots in TOPCAT.
       * out: Plot will be written to a file given by out using the
            graphics format given by ofmt.
       * cgi: Plot will be written in a way suitable for CGI use
            direct from a web server. The output is in the graphics
            format given by ofmt, preceded by a suitable
            "Content-type" declaration.
       * discard: Plot is drawn, but discarded. There is no output.
       * auto: Behaves as swing or out mode depending on presence of
            out parameter

      [Default: auto]

   storage =
   simple|memory|disk|policy|cache|basic-cache|persistent|parallel
         (uk.ac.starlink.ttools.plot2.data.DataStoreFactory)
      Determines the way that data is accessed when constructing the
      plot. There are two main options, cached or not. If no caching
      is used then rows are read sequentially from the specified
      input table(s) every time they are required. This generally
      requires a small resource footprint (though that can depend on
      how the table is specified) and makes sense if the data only
      needs to be scanned once or perhaps if the table is very
      large. If caching is used then the required data is read once
      from the specified input table(s), then prepared and cached
      before any plotting is performed, and plots are done using
      this cached data. This may use a significant amount of storage
      for large tables but it's usually more sensible (faster) if
      the data will need to be scanned multiple times. There are
      various options for cache storage.

      The options are:

       * simple: no caching, data read directly from input table
       * memory: cached to memory; OutOfMemoryError possible for
            very large plots
       * disk: cached to disk
       * policy: cached using application-wide default storage
            policy, which is usually adaptive (memory/disk hybrid)
       * persistent: cached to persistent files on disk, in the
            system temporary directory (defined by system property
            java.io.tmpdir). If this is used, plot data will be
            stored on disk in a way that means they can be re-used
            between STILTS invocations, so data preparation can be
            avoided on subsequent runs. Note however it can leave
            potentially large files in your temporary directory.
       * cache: synonym for memory (backward compatibility)
       * basic-cache: dumber version of memory (no optimisation for
            constant-valued columns)
       * parallel: experimental version of memory-based cache that
            reads into the cache in parallel for large files. This
            will make the plot faster to prepare, but interaction is
            a bit slower and sequence-dependent attributes of the
            plot may not come out right. This experimental option
            may be withdrawn or modified in future releases.

      The default value is memory if a live plot is being generated
      (omode=swing), since in that case the plot needs to be redrawn
      every time the user performs plot navigation actions or
      resizes the window, or if animations are being produced.
      Otherwise (e.g. output to a graphics file) the default is
      simple.

      [Default: simple]

   seq = <suffix>[,...]       (String[])
      Contains a comma-separated list of layer suffixes to determine
      the order in which layers are drawn on the plot. This can
      affect which symbol are plotted on top of, and so potentially
      obscure, which other ones.

      When specifying a plot, multiple layers may be specified, each
      introduced by a parameter layer<N>, where <N> is a different
      (arbitrary) suffix labelling the layer, and is appended to all
      the parameters specific to defining that layer.

      By default the layers are drawn on the plot in the order in
      which the layer* parameters appear on the command line.
      However if this parameter is specified, each comma-separated
      element is interpreted as a layer suffix, giving the ordered
      list of layers to plot. Every element of the list must be a
      suffix with a corresponding layer parameter, but missing or
      repeated elements are allowed.

   legend = true|false       (Boolean)
      Whether to draw a legend or not. If no value is supplied, the
      decision is made automatically: a legend is drawn only if it
      would have more than one entry.

   legborder = true|false       (Boolean)
      If true, a line border is drawn around the legend.

      [Default: true]

   legopaque = true|false       (Boolean)
      If true, the background of the legend is opaque, and the
      legend obscures any plot components behind it. Otherwise, it's
      transparent.

      [Default: true]

   legseq = <suffix>[,...]       (String[])
      Determines which layers are represented in the legend (if
      present) and in which order they appear. The legend has a line
      for each layer label (as determined by the leglabelN
      parameter). If multiple layers have the same label, they will
      contribute to the same entry in the legend, with style icons
      plotted over each other. The value of this parameter is a
      comma-separated sequence of layer suffixes, which determines
      the order in which the legend entries appear. Layers with
      suffixes missing from this list do not show up in the legend
      at all.

      If no value is supplied (the default), the sequence is the
      same as the layer plotting sequence (see seq).

   legpos = <xfrac,yfrac>       (double[])
      Determines the internal position of the legend on the plot.
      The value is a comma-separated pair of values giving the X and
      Y positions of the legend within the plotting bounds, so for
      instance "0.5,0.5" will put the legend right in the middle of
      the plot. If no value is supplied, the legend will appear
      outside the plot boundary.

   title = <value>       (String)
      Text of a title to be displayed at the top of the plot. If
      null, the default, no title is shown and there's more space
      for the graphics.

   auxmap = <map-name>|<color>-<color>[-<color>...]       
   (uk.ac.starlink.ttools.plot.Shader)
      Color map used for Aux axis shading.

      A mixed bag of colour ramps are available as listed in
      SUN/256: inferno, magma, plasma, viridis, cividis, cubehelix,
      sron, rainbow, rainbow2, rainbow3, pastel, cosmic, ember,
      gothic, rainforest, voltage, bubblegum, gem, chroma, neon,
      tropical, accent, gnuplot, gnuplot2, specxby, set1, paired,
      hotcold, guppy, iceburn, redshift, pride, rdbu, piyg, brbg,
      cyan-magenta, red-blue, brg, heat, cold, light, greyscale,
      colour, standard, bugn, bupu, orrd, pubu, purd, painbow,
      huecl, infinity, hue, intensity, rgb_red, rgb_green, rgb_blue
      , hsv_h, hsv_s, hsv_v, yuv_y, yuv_u, yuv_v, scale_hsv_s,
      scale_hsv_v, scale_yuv_y, mask, blacker, whiter, transparency
      . Note: many of these, including rainbow-like ones, are
      frowned upon by the visualisation community.

      You can also construct your own custom colour map by giving a
      sequence of colour names separated by minus sign ("-")
      characters. In this case the ramp is a linear interpolation
      between each pair of colours named, using the same syntax as
      when specifying a colour value. So for instance "
      yellow-hotpink-#0000ff" would shade from yellow via hot pink
      to blue.

      [Default: inferno]

   auxclip = <lo>,<hi>       (uk.ac.starlink.ttools.plot2.Subrange)
      Defines a subrange of the colour ramp to be used for Aux
      shading. The value is specified as a (low,high)
      comma-separated pair of two numbers between 0 and 1.

      If the full range 0,1 is used, the whole range of colours
      specified by the selected shader will be used. But if for
      instance a value of 0,0.5 is given, only those colours at the
      left hand end of the ramp will be seen.

      If the null (default) value is chosen, a default clip will be
      used. This generally covers most or all of the range 0-1 but
      for colour maps which fade to white, a small proportion of the
      lower end may be excluded, to ensure that all the colours are
      visually distinguishable from a white background. This default
      is usually a good idea if the colour map is being used with
      something like a scatter plot, where markers are plotted
      against a white background. However, for something like a
      density map when the whole plotting area is tiled with colours
      from the map, it may be better to supply the whole range 0,1
      explicitly.

   auxflip = true|false       (Boolean)
      If true, the colour map on the Aux axis will be reversed.

      [Default: false]

   auxquant = <number>       (Double)
      Allows the colour map used for the Aux axis to be quantised.
      If an integer value N is chosen then the colour map will be
      viewed as N discrete evenly-spaced levels, so that only N
      different colours will appear in the plot. This can be used to
      generate a contour-like effect, and may make it easier to
      trace the boundaries of regions of interest by eye.

      If left blank, the colour map is nominally continuous (though
      in practice it may be quantised to a medium-sized number like
      256).

   auxfunc = log|linear|histogram|histolog|sqrt|square|acos|cos
         (uk.ac.starlink.ttools.plot2.Scaling)
      Defines the way that values in the Aux range are mapped to the
      selected colour ramp.

      The available options are:

       * log: Logarithmic scaling
       * linear: Linear scaling
       * histogram: Scaling follows data distribution, with linear
            axis
       * histolog: Scaling follows data distribution, with
            logarithmic axis
       * sqrt: Square root scaling
       * square: Square scaling
       * acos: Arccos Scaling
       * cos: Cos Scaling

      For all these options, the full range of data values is used,
      and displayed on the colour bar if applicable. The Linear,
      Log, Square and Sqrt options just apply the named function to
      the full data range. The histogram options on the other hand
      use a scaling function that corresponds to the actual
      distribution of the data, so that there are about the same
      number of points (or pixels, or whatever is being scaled) of
      each colour. The histogram options are somewhat more
      expensive, but can be a good choice if you are exploring data
      whose distribution is unknown or not well-behaved over its
      min-max range. The Histogram and HistoLog options both assign
      the colours in the same way, but they display the colour ramp
      with linear or logarithmic annotation respectively; the
      HistoLog option also ignores non-positive values.

      [Default: linear]

   auxmin = <number>       (Double)
      Minimum value of the data coordinate on the Aux axis. This
      sets the value before any subranging is applied. If not
      supplied, the value is determined from the plotted data.

   auxmax = <number>       (Double)
      Maximum value of the data coordinate on the Aux axis. This
      sets the value before any subranging is applied. If not
      supplied, the value is determined from the plotted data.

   auxlabel = <text>       (String)
      Sets the label used to annotate the aux axis, if it is
      visible.

   auxcrowd = <factor>       (Double)
      Determines how closely the tick marks are spaced on the Aux
      axis, if visible. The default value is 1, meaning normal
      crowding. Larger values result in more ticks, and smaller
      values fewer ticks. Tick marks will not however be spaced so
      closely that the labels overlap each other, so to get very
      closely spaced marks you may need to reduce the font size as
      well.

      [Default: 1.0]

   auxwidth = <pixels>       (Integer)
      Determines the lateral size of the aux colour ramp, if
      visible, in pixels.

      [Default: 15]

   auxvisible = true|false       (Boolean)
      Determines whether the aux axis colour ramp is displayed
      alongside the plot.

      If not supplied (the default), the aux axis will be visible
      when aux shading is used in any of the plotted layers.

   forcebitmap = true|false       (Boolean)
      Affects whether rendering of the data contents of a plot
      (though not axis labels etc) is always done to an intermediate
      bitmap rather than, where possible, being painted using
      graphics primitives. This is a rather arcane setting that may
      nevertheless have noticeable effects on the appearance and
      size of an output graphics file, as well as plotting time. For
      some types of plot (e.g. shadingN=auto or shadingN=density) it
      will have no effect, since this kind of rendering happens in
      any case.

      When writing to vector graphics formats (PDF and PostScript),
      setting it true will force the data contents to be bitmapped.
      This may make the output less beautiful (round markers will no
      longer be perfectly round), but it may result in a much
      smaller file if there are very many data points.

      When writing to bitmapped output formats (PNG, GIF, JPEG,
      ...), it fixes shapes to be the same as seen on the screen
      rather than be rendered at the mercy of the graphics system,
      which sometimes introduces small distortions.

      [Default: false]

   compositor = 0..1       
   (uk.ac.starlink.ttools.plot2.paper.Compositor)
      Defines how multiple overplotted partially transparent pixels
      are combined to form a resulting colour. The way this is used
      depends on the details of the specified plot.

      Currently, this parameter takes a "boost" value in the range
      0..1. If the value is zero, saturation semantics are used: RGB
      colours are added in proporition to their associated alpha
      value until the total alpha is saturated (reaches 1), after
      which additional pixels have no further effect. For larger
      boost values, the effect is similar, but any non-zero alpha in
      the output is boosted to the given minimum value. The effect
      of this is that even very slightly populated pixels can be
      visually distinguished from unpopulated ones which may not be
      the case for saturation composition.

      [Default: 0.05]

   animate = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   parallel = <int-value>       (Integer)
      Determines how many threads will run in parallel if animation
      output is being produced. Only used if the animate parameter
      is supplied. The default value is the number of processors
      apparently available to the JVM.

      [Default: 20]

   projection = sin|aitoff|aitoff0|car|car0       
   (uk.ac.starlink.ttools.plot2.geom.Projection)
      Sky projection used to display the plot.

      The available options are:

       * sin: rotatable sphere
       * aitoff: Hammer-Aitoff projection with lon=0 at center
       * aitoff0: Hammer-Aitoff projection with lon=180 at center
       * car: Plate Carree projection (lon/lat on Cartesian axes)
            with lon=0 at center
       * car0: Plate Carree Projection (lon/lat on Cartesian axes)
            with lon=180 at center

      Note that for historical reasons the projections named "
      aitoff" denote the equal-area Hammer-Aitoff projection and not
      the Aitoff projection itself. The Hammer-Aitoff projection is
      defined as:

       * x = [2sqrt(2)/sqrt(1+cos(lat)cos(lon/2))]cos(lat)sin(lon/2)
       * y = [sqrt(2)/sqrt(1+cos(lat)cos(lon/2))]sin(lat)

      [Default: sin]

   viewsys = equatorial|galactic|supergalactic|ecliptic       
   (uk.ac.starlink.ttools.plot2.geom.SkySys)
      The sky coordinate system used for the generated plot.

      Choice of this value goes along with the data coordinate
      system that may be specified for plot layers. If unspecified,
      a generic longitude/latitude system is used, and all lon/lat
      coordinates in the plotted data layers are assumed to be in
      the same system. If a value is supplied for this parameter,
      then a sky system must (implicitly or explicitly) be supplied
      for each data layer, and the coordinates are converted from
      data to view system before being plotted.

      The available options are:

       * equatorial: J2000 equatorial system
       * galactic: IAU 1958 galactic system
       * supergalactic: De Vaucouleurs supergalactic system
       * ecliptic: ecliptic system based on conversion at 2000.0

   reflectlon = true|false       (Boolean)
      Whether to invert the celestial sphere by displaying the
      longitude axis increasing right-to-left rather than
      left-to-right. It is conventional to display the celestial
      sphere in this way because that's what it looks like from the
      earth, so the default is true. Set it false to see the sphere
      from the outside.

      [Default: true]

   grid = true|false       (Boolean)
      If true, sky coordinate grid lines are drawn on the plot. If
      false, they are absent.

      [Default: true]

   scalebar = true|false       (Boolean)
      If true, a small bar is drawn near the bottom left of the plot
      annotated with a distance in degrees, arc minutes or arc
      seconds, to make it easier to determine the size of features
      on the plot by eye.

      [Default: true]

   labelpos = Auto|External|Internal|Basic|Hybrid|None       
   (uk.ac.starlink.ttools.plot2.geom.SkyAxisLabeller)
      Controls whether and where the numeric annotations of the
      lon/lat axes are displayed. The default option Auto usually
      does the sensible thing, but other options exist to force
      labelling internally or externally to the plot region, or to
      remove numeric labels altogether.

      The available options are:

       * Auto: Uses External or Internal policy according to whether
            the sky fills the plot bounds or not
       * External: Labels are drawn outside the plot bounds
       * Internal: Labels are drawn inside the plot bounds
       * Basic: Labels are drawn somewhere near the grid line
       * Hybrid: Grid lines are labelled outside the plot bounds
            where possible, but inside if they would otherwise be
            invisible
       * None: Axes are not labelled

      [Default: Auto]

   sex = true|false       (Boolean)
      If true, grid line labels are written in sexagesimal notation,
      if false in decimal degrees.

      [Default: true]

   crowd = <number>       (Double)
      Determines how closely sky grid lines are spaced. The default
      value is 1, meaning normal crowding. Larger values result in
      more grid lines, and smaller values in fewer grid lines.

      [Default: 1]

   gridcolor = <rrggbb>|red|blue|...       (java.awt.Color)
      The color of the plot grid, given by name or as a hexadecimal
      RGB value.

      The standard plotting colour names are red, blue, green, grey
      , magenta, cyan, orange, pink, yellow, black, light_grey,
      white. However, many other common colour names (too many to
      list here) are also understood. The list currently contains
      those colour names understood by most web browsers, from
      AliceBlue to YellowGreen, listed e.g. in the Extended color
      keywords section of the CSS3 standard.

      Alternatively, a six-digit hexadecimal number RRGGBB may be
      supplied, optionally prefixed by "#" or "0x", giving red,
      green and blue intensities, e.g. "ff00ff", "#ff00ff" or "
      0xff00ff" for magenta.

      [Default: light_grey]

   labelcolor = <rrggbb>|red|blue|...       (java.awt.Color)
      The color of axis labels and other plot annotations, given by
      name or as a hexadecimal RGB value.

      The standard plotting colour names are red, blue, green, grey
      , magenta, cyan, orange, pink, yellow, black, light_grey,
      white. However, many other common colour names (too many to
      list here) are also understood. The list currently contains
      those colour names understood by most web browsers, from
      AliceBlue to YellowGreen, listed e.g. in the Extended color
      keywords section of the CSS3 standard.

      Alternatively, a six-digit hexadecimal number RRGGBB may be
      supplied, optionally prefixed by "#" or "0x", giving red,
      green and blue intensities, e.g. "ff00ff", "#ff00ff" or "
      0xff00ff" for magenta.

      [Default: black]

   gridaa = true|false       (Boolean)
      If true, grid lines are drawn with antialiasing. Antialiased
      lines look smoother, but may take perceptibly longer to draw.
      Only has any effect for bitmapped output formats.

      [Default: false]

   texttype = plain|antialias|latex       (TextSyntax)
      Determines how to turn label text into characters on the plot.
      Plain and Antialias both take the text at face value, but
      Antialias smooths the characters. LaTeX interprets the text as
      LaTeX source code and typesets it accordingly.

      When not using LaTeX, antialiased text usually looks nicer,
      but can be perceptibly slower to plot. At time of writing, on
      MacOS antialiased text seems to be required to stop the
      writing coming out upside-down for non-horizontal text (MacOS
      java bug).

      [Default: plain]

   fontsize = <int-value>       (Integer)
      Size of the text font in points.

      [Default: 12]

   fontstyle = standard|serif|mono       (FontType)
      Font style for text.

      The available options are:

       * standard
       * serif
       * mono

      [Default: standard]

   fontweight = plain|bold|italic|bold_italic       (FontWeight)
      Font weight for text.

      The available options are:

       * plain
       * bold
       * italic
       * bold_italic

      [Default: plain]

   clon = <degrees>       (Double)
      Longitude of the central position of the plot in decimal
      degrees. Use with clat and radius. If the center is not
      specified, the field of view is determined from the data.

   clat = <degrees>       (Double)
      Latitude of the central position of the plot in decimal
      degrees. Use with clon and radius. If the center is not
      specified, the field of view is determined from the data.

   radius = <degrees>       (Double)
      Approximate radius of the plot field of view in degrees. Only
      used if clon and clat are also specified.

      [Default: 1]

   zoomfactor = <number>       (Double)
      Sets the amount by which the plot view zooms in or out for
      each unit of mouse wheel movement. A value of 1 means that
      mouse wheel zooming has no effect. A higher value means that
      the mouse wheel zooms faster and a value nearer 1 means it
      zooms slower. Values below 1 are not permitted.

      [Default: 1.2]

   leglabelN = <text>       (String)
      Sets the presentation label for the layer with a given suffix.
      This is the text which is displayed in the legend, if present.
      Multiple layers may use the same label, in which case they
      will be combined to form a single legend entry.

      If no value is supplied (the default), the suffix itself is
      used as the label.

   layerN = <layer-type> <layerN-specific-params>       
   (uk.ac.starlink.ttools.plot2.task.LayerType)
      Selects one of the available plot types for layerN. A plot
      consists of a plotting surface, set up using the various
      unsuffixed parameters of the plotting command, and zero or
      more plot layers. Each layer is introduced by a parameter with
      the name layer<N> where the suffix "<N>" is a label
      identifying the layer and is appended to all the parameter
      names which configure that layer. Suffixes may be any string,
      including the empty string.

      This parameter may take one of the following values, described
      in more detail in SUN/256:

       * mark
       * size
       * sizexy
       * skyvector
       * skyellipse
       * skycorr
       * link2
       * mark2
       * poly4
       * mark4
       * polygon
       * area
       * central
       * label
       * arealabel
       * contour
       * skydensity
       * healpix
       * skygrid

      Each of these layer types comes with a list of type-specific
      parameters to define the details of that layer, including some
      or all of the following groups:

       * input table parameters (e.g. inN, icmdN)
       * coordinate params referring to input table columns (e.g.
            xN, yN)
       * layer style parameters (e.g. shadingN, colorN)

      Every parameter notionally carries the same suffix N. However,
      if the suffix is not present, the application will try looking
      for a parameter with the same name with no suffix instead. In
      this way, if several layers have the same value for a given
      parameter (for instance input table), you can supply it using
      one unsuffixed parameter to save having to supply several
      parameters with the same value but different suffixes.
'''
    task = _stilts.getTaskFactory().createObject('plot2sky')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def plot2cube(**kwargs):
    '''\
Draws a cube plot.

Parameters:

   xpix = <int-value>       (Integer)
      Size of the output image in the X direction in pixels. This
      includes space for any axis labels, padding and other
      decoration outside the plot area itself. See also insets.

      [Default: 500]

   ypix = <int-value>       (Integer)
      Size of the output image in the Y direction in pixels. This
      includes space for any axis labels, padding and other
      decoration outside the plot area itself. See also insets.

      [Default: 400]

   insets = <top>,<left>,<bottom>,<right>       
   (uk.ac.starlink.ttools.plot2.Padding)
      Defines the amount of space in pixels around the actual
      plotting area. This space is used for axis labels, and other
      decorations and any left over forms an empty border.

      The size and position of the actual plotting area is
      determined by this parameter along with xpix and ypix.

      The value of this parameter is 4 comma separated integers:
      <top>,<left>,<bottom>,<right>. Any or all of these values may
      be left blank, in which case the corresponding margin will be
      calculated automatically according to how much space is
      required.

   omode = swing|out|cgi|discard|auto       
   (uk.ac.starlink.ttools.plottask.PaintMode)
      Determines how the drawn plot will be output, see SUN/256.

       * swing: Plot will be displayed in a window on the screen.
            This plot is "live"; it can be resized and (except for
            old-style plots) navigated around with mouse actions in
            the same way as plots in TOPCAT.
       * out: Plot will be written to a file given by out using the
            graphics format given by ofmt.
       * cgi: Plot will be written in a way suitable for CGI use
            direct from a web server. The output is in the graphics
            format given by ofmt, preceded by a suitable
            "Content-type" declaration.
       * discard: Plot is drawn, but discarded. There is no output.
       * auto: Behaves as swing or out mode depending on presence of
            out parameter

      [Default: auto]

   storage =
   simple|memory|disk|policy|cache|basic-cache|persistent|parallel
         (uk.ac.starlink.ttools.plot2.data.DataStoreFactory)
      Determines the way that data is accessed when constructing the
      plot. There are two main options, cached or not. If no caching
      is used then rows are read sequentially from the specified
      input table(s) every time they are required. This generally
      requires a small resource footprint (though that can depend on
      how the table is specified) and makes sense if the data only
      needs to be scanned once or perhaps if the table is very
      large. If caching is used then the required data is read once
      from the specified input table(s), then prepared and cached
      before any plotting is performed, and plots are done using
      this cached data. This may use a significant amount of storage
      for large tables but it's usually more sensible (faster) if
      the data will need to be scanned multiple times. There are
      various options for cache storage.

      The options are:

       * simple: no caching, data read directly from input table
       * memory: cached to memory; OutOfMemoryError possible for
            very large plots
       * disk: cached to disk
       * policy: cached using application-wide default storage
            policy, which is usually adaptive (memory/disk hybrid)
       * persistent: cached to persistent files on disk, in the
            system temporary directory (defined by system property
            java.io.tmpdir). If this is used, plot data will be
            stored on disk in a way that means they can be re-used
            between STILTS invocations, so data preparation can be
            avoided on subsequent runs. Note however it can leave
            potentially large files in your temporary directory.
       * cache: synonym for memory (backward compatibility)
       * basic-cache: dumber version of memory (no optimisation for
            constant-valued columns)
       * parallel: experimental version of memory-based cache that
            reads into the cache in parallel for large files. This
            will make the plot faster to prepare, but interaction is
            a bit slower and sequence-dependent attributes of the
            plot may not come out right. This experimental option
            may be withdrawn or modified in future releases.

      The default value is memory if a live plot is being generated
      (omode=swing), since in that case the plot needs to be redrawn
      every time the user performs plot navigation actions or
      resizes the window, or if animations are being produced.
      Otherwise (e.g. output to a graphics file) the default is
      simple.

      [Default: simple]

   seq = <suffix>[,...]       (String[])
      Contains a comma-separated list of layer suffixes to determine
      the order in which layers are drawn on the plot. This can
      affect which symbol are plotted on top of, and so potentially
      obscure, which other ones.

      When specifying a plot, multiple layers may be specified, each
      introduced by a parameter layer<N>, where <N> is a different
      (arbitrary) suffix labelling the layer, and is appended to all
      the parameters specific to defining that layer.

      By default the layers are drawn on the plot in the order in
      which the layer* parameters appear on the command line.
      However if this parameter is specified, each comma-separated
      element is interpreted as a layer suffix, giving the ordered
      list of layers to plot. Every element of the list must be a
      suffix with a corresponding layer parameter, but missing or
      repeated elements are allowed.

   legend = true|false       (Boolean)
      Whether to draw a legend or not. If no value is supplied, the
      decision is made automatically: a legend is drawn only if it
      would have more than one entry.

   legborder = true|false       (Boolean)
      If true, a line border is drawn around the legend.

      [Default: true]

   legopaque = true|false       (Boolean)
      If true, the background of the legend is opaque, and the
      legend obscures any plot components behind it. Otherwise, it's
      transparent.

      [Default: true]

   legseq = <suffix>[,...]       (String[])
      Determines which layers are represented in the legend (if
      present) and in which order they appear. The legend has a line
      for each layer label (as determined by the leglabelN
      parameter). If multiple layers have the same label, they will
      contribute to the same entry in the legend, with style icons
      plotted over each other. The value of this parameter is a
      comma-separated sequence of layer suffixes, which determines
      the order in which the legend entries appear. Layers with
      suffixes missing from this list do not show up in the legend
      at all.

      If no value is supplied (the default), the sequence is the
      same as the layer plotting sequence (see seq).

   legpos = <xfrac,yfrac>       (double[])
      Determines the internal position of the legend on the plot.
      The value is a comma-separated pair of values giving the X and
      Y positions of the legend within the plotting bounds, so for
      instance "0.5,0.5" will put the legend right in the middle of
      the plot. If no value is supplied, the legend will appear
      outside the plot boundary.

   title = <value>       (String)
      Text of a title to be displayed at the top of the plot. If
      null, the default, no title is shown and there's more space
      for the graphics.

   auxmap = <map-name>|<color>-<color>[-<color>...]       
   (uk.ac.starlink.ttools.plot.Shader)
      Color map used for Aux axis shading.

      A mixed bag of colour ramps are available as listed in
      SUN/256: inferno, magma, plasma, viridis, cividis, cubehelix,
      sron, rainbow, rainbow2, rainbow3, pastel, cosmic, ember,
      gothic, rainforest, voltage, bubblegum, gem, chroma, neon,
      tropical, accent, gnuplot, gnuplot2, specxby, set1, paired,
      hotcold, guppy, iceburn, redshift, pride, rdbu, piyg, brbg,
      cyan-magenta, red-blue, brg, heat, cold, light, greyscale,
      colour, standard, bugn, bupu, orrd, pubu, purd, painbow,
      huecl, infinity, hue, intensity, rgb_red, rgb_green, rgb_blue
      , hsv_h, hsv_s, hsv_v, yuv_y, yuv_u, yuv_v, scale_hsv_s,
      scale_hsv_v, scale_yuv_y, mask, blacker, whiter, transparency
      . Note: many of these, including rainbow-like ones, are
      frowned upon by the visualisation community.

      You can also construct your own custom colour map by giving a
      sequence of colour names separated by minus sign ("-")
      characters. In this case the ramp is a linear interpolation
      between each pair of colours named, using the same syntax as
      when specifying a colour value. So for instance "
      yellow-hotpink-#0000ff" would shade from yellow via hot pink
      to blue.

      [Default: inferno]

   auxclip = <lo>,<hi>       (uk.ac.starlink.ttools.plot2.Subrange)
      Defines a subrange of the colour ramp to be used for Aux
      shading. The value is specified as a (low,high)
      comma-separated pair of two numbers between 0 and 1.

      If the full range 0,1 is used, the whole range of colours
      specified by the selected shader will be used. But if for
      instance a value of 0,0.5 is given, only those colours at the
      left hand end of the ramp will be seen.

      If the null (default) value is chosen, a default clip will be
      used. This generally covers most or all of the range 0-1 but
      for colour maps which fade to white, a small proportion of the
      lower end may be excluded, to ensure that all the colours are
      visually distinguishable from a white background. This default
      is usually a good idea if the colour map is being used with
      something like a scatter plot, where markers are plotted
      against a white background. However, for something like a
      density map when the whole plotting area is tiled with colours
      from the map, it may be better to supply the whole range 0,1
      explicitly.

   auxflip = true|false       (Boolean)
      If true, the colour map on the Aux axis will be reversed.

      [Default: false]

   auxquant = <number>       (Double)
      Allows the colour map used for the Aux axis to be quantised.
      If an integer value N is chosen then the colour map will be
      viewed as N discrete evenly-spaced levels, so that only N
      different colours will appear in the plot. This can be used to
      generate a contour-like effect, and may make it easier to
      trace the boundaries of regions of interest by eye.

      If left blank, the colour map is nominally continuous (though
      in practice it may be quantised to a medium-sized number like
      256).

   auxfunc = log|linear|histogram|histolog|sqrt|square|acos|cos
         (uk.ac.starlink.ttools.plot2.Scaling)
      Defines the way that values in the Aux range are mapped to the
      selected colour ramp.

      The available options are:

       * log: Logarithmic scaling
       * linear: Linear scaling
       * histogram: Scaling follows data distribution, with linear
            axis
       * histolog: Scaling follows data distribution, with
            logarithmic axis
       * sqrt: Square root scaling
       * square: Square scaling
       * acos: Arccos Scaling
       * cos: Cos Scaling

      For all these options, the full range of data values is used,
      and displayed on the colour bar if applicable. The Linear,
      Log, Square and Sqrt options just apply the named function to
      the full data range. The histogram options on the other hand
      use a scaling function that corresponds to the actual
      distribution of the data, so that there are about the same
      number of points (or pixels, or whatever is being scaled) of
      each colour. The histogram options are somewhat more
      expensive, but can be a good choice if you are exploring data
      whose distribution is unknown or not well-behaved over its
      min-max range. The Histogram and HistoLog options both assign
      the colours in the same way, but they display the colour ramp
      with linear or logarithmic annotation respectively; the
      HistoLog option also ignores non-positive values.

      [Default: linear]

   auxmin = <number>       (Double)
      Minimum value of the data coordinate on the Aux axis. This
      sets the value before any subranging is applied. If not
      supplied, the value is determined from the plotted data.

   auxmax = <number>       (Double)
      Maximum value of the data coordinate on the Aux axis. This
      sets the value before any subranging is applied. If not
      supplied, the value is determined from the plotted data.

   auxlabel = <text>       (String)
      Sets the label used to annotate the aux axis, if it is
      visible.

   auxcrowd = <factor>       (Double)
      Determines how closely the tick marks are spaced on the Aux
      axis, if visible. The default value is 1, meaning normal
      crowding. Larger values result in more ticks, and smaller
      values fewer ticks. Tick marks will not however be spaced so
      closely that the labels overlap each other, so to get very
      closely spaced marks you may need to reduce the font size as
      well.

      [Default: 1.0]

   auxwidth = <pixels>       (Integer)
      Determines the lateral size of the aux colour ramp, if
      visible, in pixels.

      [Default: 15]

   auxvisible = true|false       (Boolean)
      Determines whether the aux axis colour ramp is displayed
      alongside the plot.

      If not supplied (the default), the aux axis will be visible
      when aux shading is used in any of the plotted layers.

   forcebitmap = true|false       (Boolean)
      Affects whether rendering of the data contents of a plot
      (though not axis labels etc) is always done to an intermediate
      bitmap rather than, where possible, being painted using
      graphics primitives. This is a rather arcane setting that may
      nevertheless have noticeable effects on the appearance and
      size of an output graphics file, as well as plotting time. For
      some types of plot (e.g. shadingN=auto or shadingN=density) it
      will have no effect, since this kind of rendering happens in
      any case.

      When writing to vector graphics formats (PDF and PostScript),
      setting it true will force the data contents to be bitmapped.
      This may make the output less beautiful (round markers will no
      longer be perfectly round), but it may result in a much
      smaller file if there are very many data points.

      When writing to bitmapped output formats (PNG, GIF, JPEG,
      ...), it fixes shapes to be the same as seen on the screen
      rather than be rendered at the mercy of the graphics system,
      which sometimes introduces small distortions.

      [Default: false]

   compositor = 0..1       
   (uk.ac.starlink.ttools.plot2.paper.Compositor)
      Defines how multiple overplotted partially transparent pixels
      are combined to form a resulting colour. The way this is used
      depends on the details of the specified plot.

      Currently, this parameter takes a "boost" value in the range
      0..1. If the value is zero, saturation semantics are used: RGB
      colours are added in proporition to their associated alpha
      value until the total alpha is saturated (reaches 1), after
      which additional pixels have no further effect. For larger
      boost values, the effect is similar, but any non-zero alpha in
      the output is boosted to the given minimum value. The effect
      of this is that even very slightly populated pixels can be
      visually distinguished from unpopulated ones which may not be
      the case for saturation composition.

      [Default: 0.05]

   animate = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   parallel = <int-value>       (Integer)
      Determines how many threads will run in parallel if animation
      output is being produced. Only used if the animate parameter
      is supplied. The default value is the number of processors
      apparently available to the JVM.

      [Default: 20]

   xlog = true|false       (Boolean)
      If false (the default), the scale on the X axis is linear, if
      true it is logarithmic.

      [Default: false]

   ylog = true|false       (Boolean)
      If false (the default), the scale on the Y axis is linear, if
      true it is logarithmic.

      [Default: false]

   zlog = true|false       (Boolean)
      If false (the default), the scale on the Z axis is linear, if
      true it is logarithmic.

      [Default: false]

   xflip = true|false       (Boolean)
      If true, the scale on the X axis will increase in the opposite
      sense from usual (e.g. right to left rather than left to
      right).

      [Default: false]

   yflip = true|false       (Boolean)
      If true, the scale on the Y axis will increase in the opposite
      sense from usual (e.g. right to left rather than left to
      right).

      [Default: false]

   zflip = true|false       (Boolean)
      If true, the scale on the Z axis will increase in the opposite
      sense from usual (e.g. right to left rather than left to
      right).

      [Default: false]

   xlabel = <text>       (String)
      Gives a label to be used for annotating axis X A default value
      based on the plotted data will be used if no value is
      supplied.

      [Default: X]

   ylabel = <text>       (String)
      Gives a label to be used for annotating axis Y A default value
      based on the plotted data will be used if no value is
      supplied.

      [Default: Y]

   zlabel = <text>       (String)
      Gives a label to be used for annotating axis Z A default value
      based on the plotted data will be used if no value is
      supplied.

      [Default: Z]

   xcrowd = <number>       (Double)
      Determines how closely the tick marks are spaced on the X
      axis. The default value is 1, meaning normal crowding. Larger
      values result in more ticks, and smaller values fewer ticks.
      Tick marks will not however be spaced so closely that the
      labels overlap each other, so to get very closely spaced marks
      you may need to reduce the font size as well.

      [Default: 1]

   ycrowd = <number>       (Double)
      Determines how closely the tick marks are spaced on the Y
      axis. The default value is 1, meaning normal crowding. Larger
      values result in more ticks, and smaller values fewer ticks.
      Tick marks will not however be spaced so closely that the
      labels overlap each other, so to get very closely spaced marks
      you may need to reduce the font size as well.

      [Default: 1]

   zcrowd = <number>       (Double)
      Determines how closely the tick marks are spaced on the Z
      axis. The default value is 1, meaning normal crowding. Larger
      values result in more ticks, and smaller values fewer ticks.
      Tick marks will not however be spaced so closely that the
      labels overlap each other, so to get very closely spaced marks
      you may need to reduce the font size as well.

      [Default: 1]

   frame = true|false       (Boolean)
      If true, a cube wire frame with labelled axes is drawn to
      indicate the limits of the plotted 3D region. If false, no
      wire frame and no axes are drawn.

      [Default: true]

   minor = true|false       (Boolean)
      If true, minor tick marks are painted along the axes as well
      as the major tick marks. Minor tick marks do not have
      associated grid lines.

      [Default: true]

   gridaa = true|false       (Boolean)
      If true, grid lines are drawn with antialiasing. Antialiased
      lines look smoother, but may take perceptibly longer to draw.
      Only has any effect for bitmapped output formats.

      [Default: false]

   texttype = plain|antialias|latex       (TextSyntax)
      Determines how to turn label text into characters on the plot.
      Plain and Antialias both take the text at face value, but
      Antialias smooths the characters. LaTeX interprets the text as
      LaTeX source code and typesets it accordingly.

      When not using LaTeX, antialiased text usually looks nicer,
      but can be perceptibly slower to plot. At time of writing, on
      MacOS antialiased text seems to be required to stop the
      writing coming out upside-down for non-horizontal text (MacOS
      java bug).

      [Default: plain]

   fontsize = <int-value>       (Integer)
      Size of the text font in points.

      [Default: 12]

   fontstyle = standard|serif|mono       (FontType)
      Font style for text.

      The available options are:

       * standard
       * serif
       * mono

      [Default: standard]

   fontweight = plain|bold|italic|bold_italic       (FontWeight)
      Font weight for text.

      The available options are:

       * plain
       * bold
       * italic
       * bold_italic

      [Default: plain]

   xmin = <number>       (Double)
      Minimum value of the data coordinate on the X axis. This sets
      the value before any subranging is applied. If not supplied,
      the value is determined from the plotted data.

   xmax = <number>       (Double)
      Maximum value of the data coordinate on the X axis. This sets
      the value before any subranging is applied. If not supplied,
      the value is determined from the plotted data.

   xsub = <lo>,<hi>       (uk.ac.starlink.ttools.plot2.Subrange)
      Defines a normalised adjustment to the data range of the X
      axis. The value may be specified as a comma-separated pair of
      two numbers, giving the lower and upper bounds of the range of
      of interest respectively. This sub-range is applied to the
      data range that would otherwise be used, either automatically
      calculated or explicitly supplied; zero corresponds to the
      lower bound and one to the upper.

      The default value "0,1" therefore has no effect. The range
      could be restricted to its lower half with the value 0,0.5.

      [Default: 0,1]

   ymin = <number>       (Double)
      Minimum value of the data coordinate on the Y axis. This sets
      the value before any subranging is applied. If not supplied,
      the value is determined from the plotted data.

   ymax = <number>       (Double)
      Maximum value of the data coordinate on the Y axis. This sets
      the value before any subranging is applied. If not supplied,
      the value is determined from the plotted data.

   ysub = <lo>,<hi>       (uk.ac.starlink.ttools.plot2.Subrange)
      Defines a normalised adjustment to the data range of the Y
      axis. The value may be specified as a comma-separated pair of
      two numbers, giving the lower and upper bounds of the range of
      of interest respectively. This sub-range is applied to the
      data range that would otherwise be used, either automatically
      calculated or explicitly supplied; zero corresponds to the
      lower bound and one to the upper.

      The default value "0,1" therefore has no effect. The range
      could be restricted to its lower half with the value 0,0.5.

      [Default: 0,1]

   zmin = <number>       (Double)
      Minimum value of the data coordinate on the Z axis. This sets
      the value before any subranging is applied. If not supplied,
      the value is determined from the plotted data.

   zmax = <number>       (Double)
      Maximum value of the data coordinate on the Z axis. This sets
      the value before any subranging is applied. If not supplied,
      the value is determined from the plotted data.

   zsub = <lo>,<hi>       (uk.ac.starlink.ttools.plot2.Subrange)
      Defines a normalised adjustment to the data range of the Z
      axis. The value may be specified as a comma-separated pair of
      two numbers, giving the lower and upper bounds of the range of
      of interest respectively. This sub-range is applied to the
      data range that would otherwise be used, either automatically
      calculated or explicitly supplied; zero corresponds to the
      lower bound and one to the upper.

      The default value "0,1" therefore has no effect. The range
      could be restricted to its lower half with the value 0,0.5.

      [Default: 0,1]

   phi = <degrees>       (Double)
      First of the Euler angles, in the ZXZ sequence, defining the
      rotation of the plotted 3d space. Units are degrees. This is
      the rotation around the initial Z axis applied before the plot
      is viewed.

      [Default: 30]

   theta = <degrees>       (Double)
      Second of the Euler angles, in the ZXZ sequence, defining the
      rotation of the plotted 3d space. Units are degrees. This is
      the rotation towards the viewer.

      [Default: -15]

   psi = <degrees>       (Double)
      Second of the Euler angles, in the ZXZ sequence, defining the
      rotation of the plotted 3d space. Units are degrees.

      [Default: 0]

   zoom = <factor>       (Double)
      Sets the magnification factor at which the the plotted 3D
      region itself is viewed, without affecting its contents. The
      default value is 1, which means the cube fits into the
      plotting space however it is rotated. Much higher zoom factors
      will result in parts of the plotting region and axes being
      drawn outside of the plotting region (so invisible).

      [Default: 1]

   xoff = <pixels>       (Double)
      Shifts the whole plot within the plotting region by the given
      number of pixels in the horizontal direction.

      [Default: 0]

   yoff = <pixels>       (Double)
      Shifts the whole plot within the plotting region by the given
      number of pixels in the vertical direction.

      [Default: 0]

   zoomaxes = [[x][y][z]]       (boolean[])
      Determines which axes are affected by zoom navigation actions.

      If no value is supplied (the default), the mouse wheel zooms
      around the center of the cube, and right-button (or CTRL-)
      drag zooms in the two dimensions most closely aligned with the
      plane of the screen, with the reference position set by the
      initial position of the mouse.

      If this value is set (legal values are x, y, z, xy, yz, xz and
      xyz) then all zoom operations are around the cube center and
      affect the axes named.

   zoomfactor = <number>       (Double)
      Sets the amount by which the plot view zooms in or out for
      each unit of mouse wheel movement. A value of 1 means that
      mouse wheel zooming has no effect. A higher value means that
      the mouse wheel zooms faster and a value nearer 1 means it
      zooms slower. Values below 1 are not permitted.

      [Default: 1.2]

   leglabelN = <text>       (String)
      Sets the presentation label for the layer with a given suffix.
      This is the text which is displayed in the legend, if present.
      Multiple layers may use the same label, in which case they
      will be combined to form a single legend entry.

      If no value is supplied (the default), the suffix itself is
      used as the label.

   layerN = <layer-type> <layerN-specific-params>       
   (uk.ac.starlink.ttools.plot2.task.LayerType)
      Selects one of the available plot types for layerN. A plot
      consists of a plotting surface, set up using the various
      unsuffixed parameters of the plotting command, and zero or
      more plot layers. Each layer is introduced by a parameter with
      the name layer<N> where the suffix "<N>" is a label
      identifying the layer and is appended to all the parameter
      names which configure that layer. Suffixes may be any string,
      including the empty string.

      This parameter may take one of the following values, described
      in more detail in SUN/256:

       * mark
       * size
       * sizexy
       * xyzvector
       * xyzerror
       * link2
       * mark2
       * poly4
       * mark4
       * polygon
       * label
       * line3d
       * contour
       * spheregrid

      Each of these layer types comes with a list of type-specific
      parameters to define the details of that layer, including some
      or all of the following groups:

       * input table parameters (e.g. inN, icmdN)
       * coordinate params referring to input table columns (e.g.
            xN, yN)
       * layer style parameters (e.g. shadingN, colorN)

      Every parameter notionally carries the same suffix N. However,
      if the suffix is not present, the application will try looking
      for a parameter with the same name with no suffix instead. In
      this way, if several layers have the same value for a given
      parameter (for instance input table), you can supply it using
      one unsuffixed parameter to save having to supply several
      parameters with the same value but different suffixes.
'''
    task = _stilts.getTaskFactory().createObject('plot2cube')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def plot2sphere(**kwargs):
    '''\
Draws a sphere plot.

Parameters:

   xpix = <int-value>       (Integer)
      Size of the output image in the X direction in pixels. This
      includes space for any axis labels, padding and other
      decoration outside the plot area itself. See also insets.

      [Default: 500]

   ypix = <int-value>       (Integer)
      Size of the output image in the Y direction in pixels. This
      includes space for any axis labels, padding and other
      decoration outside the plot area itself. See also insets.

      [Default: 400]

   insets = <top>,<left>,<bottom>,<right>       
   (uk.ac.starlink.ttools.plot2.Padding)
      Defines the amount of space in pixels around the actual
      plotting area. This space is used for axis labels, and other
      decorations and any left over forms an empty border.

      The size and position of the actual plotting area is
      determined by this parameter along with xpix and ypix.

      The value of this parameter is 4 comma separated integers:
      <top>,<left>,<bottom>,<right>. Any or all of these values may
      be left blank, in which case the corresponding margin will be
      calculated automatically according to how much space is
      required.

   omode = swing|out|cgi|discard|auto       
   (uk.ac.starlink.ttools.plottask.PaintMode)
      Determines how the drawn plot will be output, see SUN/256.

       * swing: Plot will be displayed in a window on the screen.
            This plot is "live"; it can be resized and (except for
            old-style plots) navigated around with mouse actions in
            the same way as plots in TOPCAT.
       * out: Plot will be written to a file given by out using the
            graphics format given by ofmt.
       * cgi: Plot will be written in a way suitable for CGI use
            direct from a web server. The output is in the graphics
            format given by ofmt, preceded by a suitable
            "Content-type" declaration.
       * discard: Plot is drawn, but discarded. There is no output.
       * auto: Behaves as swing or out mode depending on presence of
            out parameter

      [Default: auto]

   storage =
   simple|memory|disk|policy|cache|basic-cache|persistent|parallel
         (uk.ac.starlink.ttools.plot2.data.DataStoreFactory)
      Determines the way that data is accessed when constructing the
      plot. There are two main options, cached or not. If no caching
      is used then rows are read sequentially from the specified
      input table(s) every time they are required. This generally
      requires a small resource footprint (though that can depend on
      how the table is specified) and makes sense if the data only
      needs to be scanned once or perhaps if the table is very
      large. If caching is used then the required data is read once
      from the specified input table(s), then prepared and cached
      before any plotting is performed, and plots are done using
      this cached data. This may use a significant amount of storage
      for large tables but it's usually more sensible (faster) if
      the data will need to be scanned multiple times. There are
      various options for cache storage.

      The options are:

       * simple: no caching, data read directly from input table
       * memory: cached to memory; OutOfMemoryError possible for
            very large plots
       * disk: cached to disk
       * policy: cached using application-wide default storage
            policy, which is usually adaptive (memory/disk hybrid)
       * persistent: cached to persistent files on disk, in the
            system temporary directory (defined by system property
            java.io.tmpdir). If this is used, plot data will be
            stored on disk in a way that means they can be re-used
            between STILTS invocations, so data preparation can be
            avoided on subsequent runs. Note however it can leave
            potentially large files in your temporary directory.
       * cache: synonym for memory (backward compatibility)
       * basic-cache: dumber version of memory (no optimisation for
            constant-valued columns)
       * parallel: experimental version of memory-based cache that
            reads into the cache in parallel for large files. This
            will make the plot faster to prepare, but interaction is
            a bit slower and sequence-dependent attributes of the
            plot may not come out right. This experimental option
            may be withdrawn or modified in future releases.

      The default value is memory if a live plot is being generated
      (omode=swing), since in that case the plot needs to be redrawn
      every time the user performs plot navigation actions or
      resizes the window, or if animations are being produced.
      Otherwise (e.g. output to a graphics file) the default is
      simple.

      [Default: simple]

   seq = <suffix>[,...]       (String[])
      Contains a comma-separated list of layer suffixes to determine
      the order in which layers are drawn on the plot. This can
      affect which symbol are plotted on top of, and so potentially
      obscure, which other ones.

      When specifying a plot, multiple layers may be specified, each
      introduced by a parameter layer<N>, where <N> is a different
      (arbitrary) suffix labelling the layer, and is appended to all
      the parameters specific to defining that layer.

      By default the layers are drawn on the plot in the order in
      which the layer* parameters appear on the command line.
      However if this parameter is specified, each comma-separated
      element is interpreted as a layer suffix, giving the ordered
      list of layers to plot. Every element of the list must be a
      suffix with a corresponding layer parameter, but missing or
      repeated elements are allowed.

   legend = true|false       (Boolean)
      Whether to draw a legend or not. If no value is supplied, the
      decision is made automatically: a legend is drawn only if it
      would have more than one entry.

   legborder = true|false       (Boolean)
      If true, a line border is drawn around the legend.

      [Default: true]

   legopaque = true|false       (Boolean)
      If true, the background of the legend is opaque, and the
      legend obscures any plot components behind it. Otherwise, it's
      transparent.

      [Default: true]

   legseq = <suffix>[,...]       (String[])
      Determines which layers are represented in the legend (if
      present) and in which order they appear. The legend has a line
      for each layer label (as determined by the leglabelN
      parameter). If multiple layers have the same label, they will
      contribute to the same entry in the legend, with style icons
      plotted over each other. The value of this parameter is a
      comma-separated sequence of layer suffixes, which determines
      the order in which the legend entries appear. Layers with
      suffixes missing from this list do not show up in the legend
      at all.

      If no value is supplied (the default), the sequence is the
      same as the layer plotting sequence (see seq).

   legpos = <xfrac,yfrac>       (double[])
      Determines the internal position of the legend on the plot.
      The value is a comma-separated pair of values giving the X and
      Y positions of the legend within the plotting bounds, so for
      instance "0.5,0.5" will put the legend right in the middle of
      the plot. If no value is supplied, the legend will appear
      outside the plot boundary.

   title = <value>       (String)
      Text of a title to be displayed at the top of the plot. If
      null, the default, no title is shown and there's more space
      for the graphics.

   auxmap = <map-name>|<color>-<color>[-<color>...]       
   (uk.ac.starlink.ttools.plot.Shader)
      Color map used for Aux axis shading.

      A mixed bag of colour ramps are available as listed in
      SUN/256: inferno, magma, plasma, viridis, cividis, cubehelix,
      sron, rainbow, rainbow2, rainbow3, pastel, cosmic, ember,
      gothic, rainforest, voltage, bubblegum, gem, chroma, neon,
      tropical, accent, gnuplot, gnuplot2, specxby, set1, paired,
      hotcold, guppy, iceburn, redshift, pride, rdbu, piyg, brbg,
      cyan-magenta, red-blue, brg, heat, cold, light, greyscale,
      colour, standard, bugn, bupu, orrd, pubu, purd, painbow,
      huecl, infinity, hue, intensity, rgb_red, rgb_green, rgb_blue
      , hsv_h, hsv_s, hsv_v, yuv_y, yuv_u, yuv_v, scale_hsv_s,
      scale_hsv_v, scale_yuv_y, mask, blacker, whiter, transparency
      . Note: many of these, including rainbow-like ones, are
      frowned upon by the visualisation community.

      You can also construct your own custom colour map by giving a
      sequence of colour names separated by minus sign ("-")
      characters. In this case the ramp is a linear interpolation
      between each pair of colours named, using the same syntax as
      when specifying a colour value. So for instance "
      yellow-hotpink-#0000ff" would shade from yellow via hot pink
      to blue.

      [Default: inferno]

   auxclip = <lo>,<hi>       (uk.ac.starlink.ttools.plot2.Subrange)
      Defines a subrange of the colour ramp to be used for Aux
      shading. The value is specified as a (low,high)
      comma-separated pair of two numbers between 0 and 1.

      If the full range 0,1 is used, the whole range of colours
      specified by the selected shader will be used. But if for
      instance a value of 0,0.5 is given, only those colours at the
      left hand end of the ramp will be seen.

      If the null (default) value is chosen, a default clip will be
      used. This generally covers most or all of the range 0-1 but
      for colour maps which fade to white, a small proportion of the
      lower end may be excluded, to ensure that all the colours are
      visually distinguishable from a white background. This default
      is usually a good idea if the colour map is being used with
      something like a scatter plot, where markers are plotted
      against a white background. However, for something like a
      density map when the whole plotting area is tiled with colours
      from the map, it may be better to supply the whole range 0,1
      explicitly.

   auxflip = true|false       (Boolean)
      If true, the colour map on the Aux axis will be reversed.

      [Default: false]

   auxquant = <number>       (Double)
      Allows the colour map used for the Aux axis to be quantised.
      If an integer value N is chosen then the colour map will be
      viewed as N discrete evenly-spaced levels, so that only N
      different colours will appear in the plot. This can be used to
      generate a contour-like effect, and may make it easier to
      trace the boundaries of regions of interest by eye.

      If left blank, the colour map is nominally continuous (though
      in practice it may be quantised to a medium-sized number like
      256).

   auxfunc = log|linear|histogram|histolog|sqrt|square|acos|cos
         (uk.ac.starlink.ttools.plot2.Scaling)
      Defines the way that values in the Aux range are mapped to the
      selected colour ramp.

      The available options are:

       * log: Logarithmic scaling
       * linear: Linear scaling
       * histogram: Scaling follows data distribution, with linear
            axis
       * histolog: Scaling follows data distribution, with
            logarithmic axis
       * sqrt: Square root scaling
       * square: Square scaling
       * acos: Arccos Scaling
       * cos: Cos Scaling

      For all these options, the full range of data values is used,
      and displayed on the colour bar if applicable. The Linear,
      Log, Square and Sqrt options just apply the named function to
      the full data range. The histogram options on the other hand
      use a scaling function that corresponds to the actual
      distribution of the data, so that there are about the same
      number of points (or pixels, or whatever is being scaled) of
      each colour. The histogram options are somewhat more
      expensive, but can be a good choice if you are exploring data
      whose distribution is unknown or not well-behaved over its
      min-max range. The Histogram and HistoLog options both assign
      the colours in the same way, but they display the colour ramp
      with linear or logarithmic annotation respectively; the
      HistoLog option also ignores non-positive values.

      [Default: linear]

   auxmin = <number>       (Double)
      Minimum value of the data coordinate on the Aux axis. This
      sets the value before any subranging is applied. If not
      supplied, the value is determined from the plotted data.

   auxmax = <number>       (Double)
      Maximum value of the data coordinate on the Aux axis. This
      sets the value before any subranging is applied. If not
      supplied, the value is determined from the plotted data.

   auxlabel = <text>       (String)
      Sets the label used to annotate the aux axis, if it is
      visible.

   auxcrowd = <factor>       (Double)
      Determines how closely the tick marks are spaced on the Aux
      axis, if visible. The default value is 1, meaning normal
      crowding. Larger values result in more ticks, and smaller
      values fewer ticks. Tick marks will not however be spaced so
      closely that the labels overlap each other, so to get very
      closely spaced marks you may need to reduce the font size as
      well.

      [Default: 1.0]

   auxwidth = <pixels>       (Integer)
      Determines the lateral size of the aux colour ramp, if
      visible, in pixels.

      [Default: 15]

   auxvisible = true|false       (Boolean)
      Determines whether the aux axis colour ramp is displayed
      alongside the plot.

      If not supplied (the default), the aux axis will be visible
      when aux shading is used in any of the plotted layers.

   forcebitmap = true|false       (Boolean)
      Affects whether rendering of the data contents of a plot
      (though not axis labels etc) is always done to an intermediate
      bitmap rather than, where possible, being painted using
      graphics primitives. This is a rather arcane setting that may
      nevertheless have noticeable effects on the appearance and
      size of an output graphics file, as well as plotting time. For
      some types of plot (e.g. shadingN=auto or shadingN=density) it
      will have no effect, since this kind of rendering happens in
      any case.

      When writing to vector graphics formats (PDF and PostScript),
      setting it true will force the data contents to be bitmapped.
      This may make the output less beautiful (round markers will no
      longer be perfectly round), but it may result in a much
      smaller file if there are very many data points.

      When writing to bitmapped output formats (PNG, GIF, JPEG,
      ...), it fixes shapes to be the same as seen on the screen
      rather than be rendered at the mercy of the graphics system,
      which sometimes introduces small distortions.

      [Default: false]

   compositor = 0..1       
   (uk.ac.starlink.ttools.plot2.paper.Compositor)
      Defines how multiple overplotted partially transparent pixels
      are combined to form a resulting colour. The way this is used
      depends on the details of the specified plot.

      Currently, this parameter takes a "boost" value in the range
      0..1. If the value is zero, saturation semantics are used: RGB
      colours are added in proporition to their associated alpha
      value until the total alpha is saturated (reaches 1), after
      which additional pixels have no further effect. For larger
      boost values, the effect is similar, but any non-zero alpha in
      the output is boosted to the given minimum value. The effect
      of this is that even very slightly populated pixels can be
      visually distinguished from unpopulated ones which may not be
      the case for saturation composition.

      [Default: 0.05]

   animate = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   parallel = <int-value>       (Integer)
      Determines how many threads will run in parallel if animation
      output is being produced. Only used if the animate parameter
      is supplied. The default value is the number of processors
      apparently available to the JVM.

      [Default: 20]

   crowd = <number>       (Double)
      Determines how closely tick marks are spaced on the wire frame
      axes. The default value is 1, meaning normal crowding. Larger
      values result in more grid lines, and smaller values in fewer
      grid lines.

      [Default: 1]

   frame = true|false       (Boolean)
      If true, a cube wire frame with labelled axes is drawn to
      indicate the limits of the plotted 3D region. If false, no
      wire frame and no axes are drawn.

      [Default: true]

   minor = true|false       (Boolean)
      If true, minor tick marks are painted along the axes as well
      as the major tick marks. Minor tick marks do not have
      associated grid lines.

      [Default: true]

   gridaa = true|false       (Boolean)
      If true, grid lines are drawn with antialiasing. Antialiased
      lines look smoother, but may take perceptibly longer to draw.
      Only has any effect for bitmapped output formats.

      [Default: false]

   texttype = plain|antialias|latex       (TextSyntax)
      Determines how to turn label text into characters on the plot.
      Plain and Antialias both take the text at face value, but
      Antialias smooths the characters. LaTeX interprets the text as
      LaTeX source code and typesets it accordingly.

      When not using LaTeX, antialiased text usually looks nicer,
      but can be perceptibly slower to plot. At time of writing, on
      MacOS antialiased text seems to be required to stop the
      writing coming out upside-down for non-horizontal text (MacOS
      java bug).

      [Default: plain]

   fontsize = <int-value>       (Integer)
      Size of the text font in points.

      [Default: 12]

   fontstyle = standard|serif|mono       (FontType)
      Font style for text.

      The available options are:

       * standard
       * serif
       * mono

      [Default: standard]

   fontweight = plain|bold|italic|bold_italic       (FontWeight)
      Font weight for text.

      The available options are:

       * plain
       * bold
       * italic
       * bold_italic

      [Default: plain]

   cx = <number>       (Double)
      Gives the central coordinate in the X dimension. This will be
      determined from the data range if not supplied.

   cy = <number>       (Double)
      Gives the central coordinate in the Y dimension. This will be
      determined from the data range if not supplied.

   cz = <number>       (Double)
      Gives the central coordinate in the Z dimension. This will be
      determined from the data range if not supplied.

   scale = <number>       (Double)
      The length of the cube sides in data coordinates. This will be
      determined from the data range if not supplied.

   phi = <degrees>       (Double)
      First of the Euler angles, in the ZXZ sequence, defining the
      rotation of the plotted 3d space. Units are degrees. This is
      the rotation around the initial Z axis applied before the plot
      is viewed.

      [Default: 30]

   theta = <degrees>       (Double)
      Second of the Euler angles, in the ZXZ sequence, defining the
      rotation of the plotted 3d space. Units are degrees. This is
      the rotation towards the viewer.

      [Default: -15]

   psi = <degrees>       (Double)
      Second of the Euler angles, in the ZXZ sequence, defining the
      rotation of the plotted 3d space. Units are degrees.

      [Default: 0]

   zoom = <factor>       (Double)
      Sets the magnification factor at which the the plotted 3D
      region itself is viewed, without affecting its contents. The
      default value is 1, which means the cube fits into the
      plotting space however it is rotated. Much higher zoom factors
      will result in parts of the plotting region and axes being
      drawn outside of the plotting region (so invisible).

      [Default: 1]

   xoff = <pixels>       (Double)
      Shifts the whole plot within the plotting region by the given
      number of pixels in the horizontal direction.

      [Default: 0]

   yoff = <pixels>       (Double)
      Shifts the whole plot within the plotting region by the given
      number of pixels in the vertical direction.

      [Default: 0]

   zoomfactor = <number>       (Double)
      Sets the amount by which the plot view zooms in or out for
      each unit of mouse wheel movement. A value of 1 means that
      mouse wheel zooming has no effect. A higher value means that
      the mouse wheel zooms faster and a value nearer 1 means it
      zooms slower. Values below 1 are not permitted.

      [Default: 1.2]

   leglabelN = <text>       (String)
      Sets the presentation label for the layer with a given suffix.
      This is the text which is displayed in the legend, if present.
      Multiple layers may use the same label, in which case they
      will be combined to form a single legend entry.

      If no value is supplied (the default), the suffix itself is
      used as the label.

   layerN = <layer-type> <layerN-specific-params>       
   (uk.ac.starlink.ttools.plot2.task.LayerType)
      Selects one of the available plot types for layerN. A plot
      consists of a plotting surface, set up using the various
      unsuffixed parameters of the plotting command, and zero or
      more plot layers. Each layer is introduced by a parameter with
      the name layer<N> where the suffix "<N>" is a label
      identifying the layer and is appended to all the parameter
      names which configure that layer. Suffixes may be any string,
      including the empty string.

      This parameter may take one of the following values, described
      in more detail in SUN/256:

       * mark
       * size
       * sizexy
       * link2
       * mark2
       * poly4
       * mark4
       * polygon
       * area
       * central
       * label
       * arealabel
       * line3d
       * contour
       * spheregrid

      Each of these layer types comes with a list of type-specific
      parameters to define the details of that layer, including some
      or all of the following groups:

       * input table parameters (e.g. inN, icmdN)
       * coordinate params referring to input table columns (e.g.
            xN, yN)
       * layer style parameters (e.g. shadingN, colorN)

      Every parameter notionally carries the same suffix N. However,
      if the suffix is not present, the application will try looking
      for a parameter with the same name with no suffix instead. In
      this way, if several layers have the same value for a given
      parameter (for instance input table), you can supply it using
      one unsuffixed parameter to save having to supply several
      parameters with the same value but different suffixes.
'''
    task = _stilts.getTaskFactory().createObject('plot2sphere')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def plot2time(**kwargs):
    '''\
Draws a time plot.

Parameters:

   xpix = <int-value>       (Integer)
      Size of the output image in the X direction in pixels. This
      includes space for any axis labels, padding and other
      decoration outside the plot area itself. See also insets.

      [Default: 500]

   ypix = <int-value>       (Integer)
      Size of the output image in the Y direction in pixels. This
      includes space for any axis labels, padding and other
      decoration outside the plot area itself. See also insets.

      [Default: 400]

   insets = <top>,<left>,<bottom>,<right>       
   (uk.ac.starlink.ttools.plot2.Padding)
      Defines the amount of space in pixels around the actual
      plotting area. This space is used for axis labels, and other
      decorations and any left over forms an empty border.

      The size and position of the actual plotting area is
      determined by this parameter along with xpix and ypix.

      The value of this parameter is 4 comma separated integers:
      <top>,<left>,<bottom>,<right>. Any or all of these values may
      be left blank, in which case the corresponding margin will be
      calculated automatically according to how much space is
      required.

   omode = swing|out|cgi|discard|auto       
   (uk.ac.starlink.ttools.plottask.PaintMode)
      Determines how the drawn plot will be output, see SUN/256.

       * swing: Plot will be displayed in a window on the screen.
            This plot is "live"; it can be resized and (except for
            old-style plots) navigated around with mouse actions in
            the same way as plots in TOPCAT.
       * out: Plot will be written to a file given by out using the
            graphics format given by ofmt.
       * cgi: Plot will be written in a way suitable for CGI use
            direct from a web server. The output is in the graphics
            format given by ofmt, preceded by a suitable
            "Content-type" declaration.
       * discard: Plot is drawn, but discarded. There is no output.
       * auto: Behaves as swing or out mode depending on presence of
            out parameter

      [Default: auto]

   storage =
   simple|memory|disk|policy|cache|basic-cache|persistent|parallel
         (uk.ac.starlink.ttools.plot2.data.DataStoreFactory)
      Determines the way that data is accessed when constructing the
      plot. There are two main options, cached or not. If no caching
      is used then rows are read sequentially from the specified
      input table(s) every time they are required. This generally
      requires a small resource footprint (though that can depend on
      how the table is specified) and makes sense if the data only
      needs to be scanned once or perhaps if the table is very
      large. If caching is used then the required data is read once
      from the specified input table(s), then prepared and cached
      before any plotting is performed, and plots are done using
      this cached data. This may use a significant amount of storage
      for large tables but it's usually more sensible (faster) if
      the data will need to be scanned multiple times. There are
      various options for cache storage.

      The options are:

       * simple: no caching, data read directly from input table
       * memory: cached to memory; OutOfMemoryError possible for
            very large plots
       * disk: cached to disk
       * policy: cached using application-wide default storage
            policy, which is usually adaptive (memory/disk hybrid)
       * persistent: cached to persistent files on disk, in the
            system temporary directory (defined by system property
            java.io.tmpdir). If this is used, plot data will be
            stored on disk in a way that means they can be re-used
            between STILTS invocations, so data preparation can be
            avoided on subsequent runs. Note however it can leave
            potentially large files in your temporary directory.
       * cache: synonym for memory (backward compatibility)
       * basic-cache: dumber version of memory (no optimisation for
            constant-valued columns)
       * parallel: experimental version of memory-based cache that
            reads into the cache in parallel for large files. This
            will make the plot faster to prepare, but interaction is
            a bit slower and sequence-dependent attributes of the
            plot may not come out right. This experimental option
            may be withdrawn or modified in future releases.

      The default value is memory if a live plot is being generated
      (omode=swing), since in that case the plot needs to be redrawn
      every time the user performs plot navigation actions or
      resizes the window, or if animations are being produced.
      Otherwise (e.g. output to a graphics file) the default is
      simple.

      [Default: simple]

   seq = <suffix>[,...]       (String[])
      Contains a comma-separated list of layer suffixes to determine
      the order in which layers are drawn on the plot. This can
      affect which symbol are plotted on top of, and so potentially
      obscure, which other ones.

      When specifying a plot, multiple layers may be specified, each
      introduced by a parameter layer<N>, where <N> is a different
      (arbitrary) suffix labelling the layer, and is appended to all
      the parameters specific to defining that layer.

      By default the layers are drawn on the plot in the order in
      which the layer* parameters appear on the command line.
      However if this parameter is specified, each comma-separated
      element is interpreted as a layer suffix, giving the ordered
      list of layers to plot. Every element of the list must be a
      suffix with a corresponding layer parameter, but missing or
      repeated elements are allowed.

   legend = true|false       (Boolean)
      Whether to draw a legend or not. If no value is supplied, the
      decision is made automatically: a legend is drawn only if it
      would have more than one entry.

   legborder = true|false       (Boolean)
      If true, a line border is drawn around the legend.

      [Default: true]

   legopaque = true|false       (Boolean)
      If true, the background of the legend is opaque, and the
      legend obscures any plot components behind it. Otherwise, it's
      transparent.

      [Default: true]

   legseq = <suffix>[,...]       (String[])
      Determines which layers are represented in the legend (if
      present) and in which order they appear. The legend has a line
      for each layer label (as determined by the leglabelN
      parameter). If multiple layers have the same label, they will
      contribute to the same entry in the legend, with style icons
      plotted over each other. The value of this parameter is a
      comma-separated sequence of layer suffixes, which determines
      the order in which the legend entries appear. Layers with
      suffixes missing from this list do not show up in the legend
      at all.

      If no value is supplied (the default), the sequence is the
      same as the layer plotting sequence (see seq).

   legpos = <xfrac,yfrac>       (double[])
      Determines the internal position of the legend on the plot.
      The value is a comma-separated pair of values giving the X and
      Y positions of the legend within the plotting bounds, so for
      instance "0.5,0.5" will put the legend right in the middle of
      the plot. If no value is supplied, the legend will appear
      outside the plot boundary.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. legposZ affects only zone Z.

   title = <value>       (String)
      Text of a title to be displayed at the top of the plot. If
      null, the default, no title is shown and there's more space
      for the graphics.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. titleZ affects only zone Z.

   auxmap = <map-name>|<color>-<color>[-<color>...]       
   (uk.ac.starlink.ttools.plot.Shader)
      Color map used for Aux axis shading.

      A mixed bag of colour ramps are available as listed in
      SUN/256: inferno, magma, plasma, viridis, cividis, cubehelix,
      sron, rainbow, rainbow2, rainbow3, pastel, cosmic, ember,
      gothic, rainforest, voltage, bubblegum, gem, chroma, neon,
      tropical, accent, gnuplot, gnuplot2, specxby, set1, paired,
      hotcold, guppy, iceburn, redshift, pride, rdbu, piyg, brbg,
      cyan-magenta, red-blue, brg, heat, cold, light, greyscale,
      colour, standard, bugn, bupu, orrd, pubu, purd, painbow,
      huecl, infinity, hue, intensity, rgb_red, rgb_green, rgb_blue
      , hsv_h, hsv_s, hsv_v, yuv_y, yuv_u, yuv_v, scale_hsv_s,
      scale_hsv_v, scale_yuv_y, mask, blacker, whiter, transparency
      . Note: many of these, including rainbow-like ones, are
      frowned upon by the visualisation community.

      You can also construct your own custom colour map by giving a
      sequence of colour names separated by minus sign ("-")
      characters. In this case the ramp is a linear interpolation
      between each pair of colours named, using the same syntax as
      when specifying a colour value. So for instance "
      yellow-hotpink-#0000ff" would shade from yellow via hot pink
      to blue.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. auxmapZ affects only zone Z.

      [Default: inferno]

   auxclip = <lo>,<hi>       (uk.ac.starlink.ttools.plot2.Subrange)
      Defines a subrange of the colour ramp to be used for Aux
      shading. The value is specified as a (low,high)
      comma-separated pair of two numbers between 0 and 1.

      If the full range 0,1 is used, the whole range of colours
      specified by the selected shader will be used. But if for
      instance a value of 0,0.5 is given, only those colours at the
      left hand end of the ramp will be seen.

      If the null (default) value is chosen, a default clip will be
      used. This generally covers most or all of the range 0-1 but
      for colour maps which fade to white, a small proportion of the
      lower end may be excluded, to ensure that all the colours are
      visually distinguishable from a white background. This default
      is usually a good idea if the colour map is being used with
      something like a scatter plot, where markers are plotted
      against a white background. However, for something like a
      density map when the whole plotting area is tiled with colours
      from the map, it may be better to supply the whole range 0,1
      explicitly.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. auxclipZ affects only zone Z.

   auxflip = true|false       (Boolean)
      If true, the colour map on the Aux axis will be reversed.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. auxflipZ affects only zone Z.

      [Default: false]

   auxquant = <number>       (Double)
      Allows the colour map used for the Aux axis to be quantised.
      If an integer value N is chosen then the colour map will be
      viewed as N discrete evenly-spaced levels, so that only N
      different colours will appear in the plot. This can be used to
      generate a contour-like effect, and may make it easier to
      trace the boundaries of regions of interest by eye.

      If left blank, the colour map is nominally continuous (though
      in practice it may be quantised to a medium-sized number like
      256).

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. auxquantZ affects only zone Z.

   auxfunc = log|linear|histogram|histolog|sqrt|square|acos|cos
         (uk.ac.starlink.ttools.plot2.Scaling)
      Defines the way that values in the Aux range are mapped to the
      selected colour ramp.

      The available options are:

       * log: Logarithmic scaling
       * linear: Linear scaling
       * histogram: Scaling follows data distribution, with linear
            axis
       * histolog: Scaling follows data distribution, with
            logarithmic axis
       * sqrt: Square root scaling
       * square: Square scaling
       * acos: Arccos Scaling
       * cos: Cos Scaling

      For all these options, the full range of data values is used,
      and displayed on the colour bar if applicable. The Linear,
      Log, Square and Sqrt options just apply the named function to
      the full data range. The histogram options on the other hand
      use a scaling function that corresponds to the actual
      distribution of the data, so that there are about the same
      number of points (or pixels, or whatever is being scaled) of
      each colour. The histogram options are somewhat more
      expensive, but can be a good choice if you are exploring data
      whose distribution is unknown or not well-behaved over its
      min-max range. The Histogram and HistoLog options both assign
      the colours in the same way, but they display the colour ramp
      with linear or logarithmic annotation respectively; the
      HistoLog option also ignores non-positive values.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. auxfuncZ affects only zone Z.

      [Default: linear]

   auxmin = <number>       (Double)
      Minimum value of the data coordinate on the Aux axis. This
      sets the value before any subranging is applied. If not
      supplied, the value is determined from the plotted data.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. auxminZ affects only zone Z.

   auxmax = <number>       (Double)
      Maximum value of the data coordinate on the Aux axis. This
      sets the value before any subranging is applied. If not
      supplied, the value is determined from the plotted data.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. auxmaxZ affects only zone Z.

   auxlabel = <text>       (String)
      Sets the label used to annotate the aux axis, if it is
      visible.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. auxlabelZ affects only zone Z.

   auxcrowd = <factor>       (Double)
      Determines how closely the tick marks are spaced on the Aux
      axis, if visible. The default value is 1, meaning normal
      crowding. Larger values result in more ticks, and smaller
      values fewer ticks. Tick marks will not however be spaced so
      closely that the labels overlap each other, so to get very
      closely spaced marks you may need to reduce the font size as
      well.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. auxcrowdZ affects only zone Z.

      [Default: 1.0]

   auxwidth = <pixels>       (Integer)
      Determines the lateral size of the aux colour ramp, if
      visible, in pixels.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. auxwidthZ affects only zone Z.

      [Default: 15]

   auxvisible = true|false       (Boolean)
      Determines whether the aux axis colour ramp is displayed
      alongside the plot.

      If not supplied (the default), the aux axis will be visible
      when aux shading is used in any of the plotted layers.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. auxvisibleZ affects only zone Z.

   forcebitmap = true|false       (Boolean)
      Affects whether rendering of the data contents of a plot
      (though not axis labels etc) is always done to an intermediate
      bitmap rather than, where possible, being painted using
      graphics primitives. This is a rather arcane setting that may
      nevertheless have noticeable effects on the appearance and
      size of an output graphics file, as well as plotting time. For
      some types of plot (e.g. shadingN=auto or shadingN=density) it
      will have no effect, since this kind of rendering happens in
      any case.

      When writing to vector graphics formats (PDF and PostScript),
      setting it true will force the data contents to be bitmapped.
      This may make the output less beautiful (round markers will no
      longer be perfectly round), but it may result in a much
      smaller file if there are very many data points.

      When writing to bitmapped output formats (PNG, GIF, JPEG,
      ...), it fixes shapes to be the same as seen on the screen
      rather than be rendered at the mercy of the graphics system,
      which sometimes introduces small distortions.

      [Default: false]

   compositor = 0..1       
   (uk.ac.starlink.ttools.plot2.paper.Compositor)
      Defines how multiple overplotted partially transparent pixels
      are combined to form a resulting colour. The way this is used
      depends on the details of the specified plot.

      Currently, this parameter takes a "boost" value in the range
      0..1. If the value is zero, saturation semantics are used: RGB
      colours are added in proporition to their associated alpha
      value until the total alpha is saturated (reaches 1), after
      which additional pixels have no further effect. For larger
      boost values, the effect is similar, but any non-zero alpha in
      the output is boosted to the given minimum value. The effect
      of this is that even very slightly populated pixels can be
      visually distinguished from unpopulated ones which may not be
      the case for saturation composition.

      [Default: 0.05]

   animate = <table>       (uk.ac.starlink.table.StarTable)
      Input table.

   parallel = <int-value>       (Integer)
      Determines how many threads will run in parallel if animation
      output is being produced. Only used if the animate parameter
      is supplied. The default value is the number of processors
      apparently available to the JVM.

      [Default: 20]

   ylog = true|false       (Boolean)
      If false (the default), the scale on the Y axis is linear, if
      true it is logarithmic.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. ylogZ affects only zone Z.

      [Default: false]

   yflip = true|false       (Boolean)
      If true, the scale on the Y axis will increase in the opposite
      sense from usual (e.g. right to left rather than left to
      right).

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. yflipZ affects only zone Z.

      [Default: false]

   tlabel = <text>       (String)
      Gives a label to be used for annotating the Time axis. If not
      supplied no label will be drawn.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. tlabelZ affects only zone Z.

   ylabel = <text>       (String)
      Gives a label to be used for annotating axis Y A default value
      based on the plotted data will be used if no value is
      supplied.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. ylabelZ affects only zone Z.

      [Default: Y]

   grid = true|false       (Boolean)
      If true, grid lines are drawn on the plot at positions
      determined by the major tick marks. If false, they are absent.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. gridZ affects only zone Z.

      [Default: false]

   tcrowd = <number>       (Double)
      Determines how closely the tick marks are spaced on the Time
      axis. The default value is 1, meaning normal crowding. Larger
      values result in more ticks, and smaller values fewer ticks.
      Tick marks will not however be spaced so closely that the
      labels overlap each other, so to get very closely spaced marks
      you may need to reduce the font size as well.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. tcrowdZ affects only zone Z.

      [Default: 1]

   ycrowd = <number>       (Double)
      Determines how closely the tick marks are spaced on the Y
      axis. The default value is 1, meaning normal crowding. Larger
      values result in more ticks, and smaller values fewer ticks.
      Tick marks will not however be spaced so closely that the
      labels overlap each other, so to get very closely spaced marks
      you may need to reduce the font size as well.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. ycrowdZ affects only zone Z.

      [Default: 1]

   tformat = iso-8601|year|mjd|unix       
   (uk.ac.starlink.ttools.plot2.geom.TimeFormat)
      Selects the way in which time values are represented when
      using them to label the time axis.

      The available options are:

       * iso-8601: ISO 8601 date, of the form yyyy-mm-ddThh:mm:ss.s
            (e.g. "2012-03-13T04")
       * year: Decimal year (e.g. "2012.197")
       * mjd: Modified Julian Date (e.g. "55999.2")
       * unix: Seconds since midnight of 1 Jan 1970 (e.g.
            "1331613420")

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. tformatZ affects only zone Z.

      [Default: iso-8601]

   minor = true|false       (Boolean)
      If true, minor tick marks are painted along the axes as well
      as the major tick marks. Minor tick marks do not have
      associated grid lines.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. minorZ affects only zone Z.

      [Default: true]

   texttype = plain|antialias|latex       (TextSyntax)
      Determines how to turn label text into characters on the plot.
      Plain and Antialias both take the text at face value, but
      Antialias smooths the characters. LaTeX interprets the text as
      LaTeX source code and typesets it accordingly.

      When not using LaTeX, antialiased text usually looks nicer,
      but can be perceptibly slower to plot. At time of writing, on
      MacOS antialiased text seems to be required to stop the
      writing coming out upside-down for non-horizontal text (MacOS
      java bug).

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. texttypeZ affects only zone Z.

      [Default: plain]

   fontsize = <int-value>       (Integer)
      Size of the text font in points.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. fontsizeZ affects only zone Z.

      [Default: 12]

   fontstyle = standard|serif|mono       (FontType)
      Font style for text.

      The available options are:

       * standard
       * serif
       * mono

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. fontstyleZ affects only zone Z.

      [Default: standard]

   fontweight = plain|bold|italic|bold_italic       (FontWeight)
      Font weight for text.

      The available options are:

       * plain
       * bold
       * italic
       * bold_italic

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. fontweightZ affects only zone Z.

      [Default: plain]

   tmin = <year-or-iso8601>       (Double)
      Minimum value of the time coordinate plotted. This sets the
      value before any subranging is applied. If not supplied, the
      value is determined from the plotted data.

      The value may be set with a string that can be interpreted as
      a decimal year (e.g. "2007.521") or an ISO-8601 string (e.g. "
      2007-07-10T03:57:36", "2007-07-10T03" or "2007-07-10"). Note
      however that the numeric value of this configuration item if
      accessed programmatically is seconds since 1 Jan 1970.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. tminZ affects only zone Z.

   tmax = <year-or-iso8601>       (Double)
      Maximum value of the time coordinate plotted. This sets the
      value before any subranging is applied. If not supplied, the
      value is determined from the plotted data.

      The value may be set with a string that can be interpreted as
      a decimal year (e.g. "2007.521") or an ISO-8601 string (e.g. "
      2007-07-10T03:57:36", "2007-07-10T03" or "2007-07-10"). Note
      however that the numeric value of this configuration item if
      accessed programmatically is seconds since 1 Jan 1970.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. tmaxZ affects only zone Z.

   tsub = <lo>,<hi>       (uk.ac.starlink.ttools.plot2.Subrange)
      Defines a normalised adjustment to the data range of the Time
      axis. The value may be specified as a comma-separated pair of
      two numbers, giving the lower and upper bounds of the range of
      of interest respectively. This sub-range is applied to the
      data range that would otherwise be used, either automatically
      calculated or explicitly supplied; zero corresponds to the
      lower bound and one to the upper.

      The default value "0,1" therefore has no effect. The range
      could be restricted to its lower half with the value 0,0.5.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. tsubZ affects only zone Z.

      [Default: 0,1]

   ymin = <number>       (Double)
      Minimum value of the data coordinate on the Y axis. This sets
      the value before any subranging is applied. If not supplied,
      the value is determined from the plotted data.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. yminZ affects only zone Z.

   ymax = <number>       (Double)
      Maximum value of the data coordinate on the Y axis. This sets
      the value before any subranging is applied. If not supplied,
      the value is determined from the plotted data.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. ymaxZ affects only zone Z.

   ysub = <lo>,<hi>       (uk.ac.starlink.ttools.plot2.Subrange)
      Defines a normalised adjustment to the data range of the Y
      axis. The value may be specified as a comma-separated pair of
      two numbers, giving the lower and upper bounds of the range of
      of interest respectively. This sub-range is applied to the
      data range that would otherwise be used, either automatically
      calculated or explicitly supplied; zero corresponds to the
      lower bound and one to the upper.

      The default value "0,1" therefore has no effect. The range
      could be restricted to its lower half with the value 0,0.5.

      If a zone suffix is appended to the parameter name, only that
      zone is affected, e.g. ysubZ affects only zone Z.

      [Default: 0,1]

   navaxes = t|y|ty       (boolean[])
      Determines the axes which are affected by the interactive
      navigation actions (pan and zoom). The default is t which
      means that the various mouse gestures will provide panning and
      zooming in the Time direction only. However, if it is set to
      ty mouse actions will affect both the horizontal and vertical
      axes.

      [Default: t]

   zoomfactor = <number>       (Double)
      Sets the amount by which the plot view zooms in or out for
      each unit of mouse wheel movement. A value of 1 means that
      mouse wheel zooming has no effect. A higher value means that
      the mouse wheel zooms faster and a value nearer 1 means it
      zooms slower. Values below 1 are not permitted.

      [Default: 1.2]

   leglabelN = <text>       (String)
      Sets the presentation label for the layer with a given suffix.
      This is the text which is displayed in the legend, if present.
      Multiple layers may use the same label, in which case they
      will be combined to form a single legend entry.

      If no value is supplied (the default), the suffix itself is
      used as the label.

   layerN = <layer-type> <layerN-specific-params>       
   (uk.ac.starlink.ttools.plot2.task.LayerType)
      Selects one of the available plot types for layerN. A plot
      consists of a plotting surface, set up using the various
      unsuffixed parameters of the plotting command, and zero or
      more plot layers. Each layer is introduced by a parameter with
      the name layer<N> where the suffix "<N>" is a label
      identifying the layer and is appended to all the parameter
      names which configure that layer. Suffixes may be any string,
      including the empty string.

      This parameter may take one of the following values, described
      in more detail in SUN/256:

       * line
       * linearfit
       * mark
       * fill
       * quantile
       * grid
       * histogram
       * kde
       * knn
       * densogram
       * gaussian
       * yerror
       * spectrogram
       * label
       * function

      Each of these layer types comes with a list of type-specific
      parameters to define the details of that layer, including some
      or all of the following groups:

       * input table parameters (e.g. inN, icmdN)
       * coordinate params referring to input table columns (e.g.
            xN, yN)
       * layer style parameters (e.g. shadingN, colorN)

      Every parameter notionally carries the same suffix N. However,
      if the suffix is not present, the application will try looking
      for a parameter with the same name with no suffix instead. In
      this way, if several layers have the same value for a given
      parameter (for instance input table), you can supply it using
      one unsuffixed parameter to save having to supply several
      parameters with the same value but different suffixes.

   zoneN = <text>       (String)
      Defines which plot zone the layer with suffix N will appear
      in. This only makes sense for multi-zone plots. The actual
      value of the parameter is not significant, it just serves as a
      label, but different layers will end up in the same plot zone
      if they give the same values for this parameter.
'''
    task = _stilts.getTaskFactory().createObject('plot2time')
    for param in task.getParameters():
        pname = param.getName()
        if pname in _param_alias_dict:
            param.setName(_param_alias_dict[pname])
    env = _JyEnvironment()
    for kw in kwargs.iteritems():
        key = kw[0]
        value = kw[1]
        env.setValue(key, _map_env_value(value))
    exe = task.createExecutable(env)
    _check_unused_args(env)
    exe.execute()

def cmd_addcol(table, *args):
    '''\
Add a new column called <col-name> defined by the algebraic
expression <expr>. By default the new column appears after the last
column of the table, but you can position it either before or after
a specified column using the -before or -after flags respectively.

The -units, -ucd, -utype and -desc flags can be used to define
textual metadata values for the new column.

The -shape flag can also be used, but is intended only for
array-valued columns, e.g. -shape 3,3 to declare a 3x3 array. The
final entry only in the shape list may be a "*" character to
indicate unknown extent. Array values with no specified shape
effectively have a shape of "*". The -elsize flag may be used to
specify the length of fixed length strings; use with non-string
columns is not recommended.

Syntax for the <expr> and <col-id> arguments is described in the
manual.

The filtered table is returned.

args is a list with words as elements:
    [-after <col-id> | -before <col-id>]
    [-units <units>] [-ucd <ucd>] [-utype <utype>] [-desc <descrip>]
    [-shape <n>[,<n>...][,*]] [-elsize <n>]
    <col-name> <expr>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("addcol")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_addpixsample(table, *args):
    '''\
Samples pixel data from an all-sky image file in HEALPix format. The
<healpix-file> argument must be the filename of a table containing
HEALPix pixel data. The URL of such a file can be used instead, but
local files are likely to be more efficient.

The <expr-lon> and <expr-lat> arguments give expressions for the
longitude and latitude in degrees for each row of the input table;
this is usually just the column names. The long/lat must usually be
in the same coordinate system as that used for the HEALPix data, so
if the one is in galactic coordinates the other must be as well. If
this is not the case, use the -systems flag to give the input
long/lat and healpix data coordinate system names respectively. The
available coordinate system names are:

 * icrs: ICRS (Right Ascension, Declination)
 * fk5: FK5 J2000.0 (Right Ascension, Declination)
 * fk4: FK4 B1950.0 (Right Ascension, Declination)
 * galactic: IAU 1958 Galactic (Longitude, Latitude)
 * supergalactic: de Vaucouleurs Supergalactic (Longitude, Latitude)
 * ecliptic: Ecliptic (Longitude, Latitude)

The <expr-rad>, if present, is a constant or expression giving the
radius in degrees over which pixels will be averaged to obtain the
result values. Note that this averaging is somewhat approximate;
pixels partly covered by the specified disc are weighted the same as
those fully covered. If no radius is specified, the value of the
pixel covering the central position will be used.

The <healpix-file> file is a table with one row per HEALPix pixel
and one or more columns representing pixel data. A new column will
be added to the output table corresponding to each of these pixel
columns. This type of data is available in FITS tables for a number
of all-sky data sets, particularly from the LAMBDA archive; see for
instance the page on foreground products (including dust emission,
reddening etc) or WMAP 7 year data. If the filename given does not
appear to point to a file of the appropriate format, an error will
result. Note the LAMBDA files mostly (all?) use galactic
coordinates, so coordinate conversion using the -systems flag may be
appropriate, see above.

Syntax for the <expr-lon> , <expr-lat> and <expr-rad> arguments is
described in the manual.

This filter is somewhat experimental, and its usage may be changed
or replaced in a future version.

Note: you may prefer to use the pixsample command instead.

The filtered table is returned.

args is a list with words as elements:
    [-radius <expr-rad>] [-systems <in-sys> <pix-sys>]
    <expr-lon> <expr-lat> <healpix-file>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("addpixsample")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_addresolve(table, *args):
    '''\
Performs name resolution on the string-valued column
<col-id-objname> and appends two new columns <col-name-ra> and
<col-name-dec> containing the resolved Right Ascension and
Declination in degrees.

Syntax for the <col-id-objname> argument is described in SUN/256.

UCDs are added to the new columns in a way which tries to be
consistent with any UCDs already existing in the table.

Since this filter works by interrogating a remote service, it will
obviously be slow. The current implementation is experimental; it
may be replaced in a future release by some way of doing the same
thing (perhaps a new STILTS task) which is able to work more
efficiently by dispatching multiple concurrent requests.

This is currently implemented using the Simbad service operated by
CDS.

The filtered table is returned.

args is a list with words as elements:
    <col-id-objname> <col-name-ra> <col-name-dec>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("addresolve")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_addskycoords(table, *args):
    '''\
Add new columns to the table representing position on the sky. The
values are determined by converting a sky position whose coordinates
are contained in existing columns. The <col-id> arguments give
identifiers for the two input coordinate columns in the coordinate
system named by <insys>, and the <col-name> arguments name the two
new columns, which will be in the coordinate system named by
<outsys>. The <insys> and <outsys> coordinate system specifiers are
one of

 * icrs: ICRS (Right Ascension, Declination)
 * fk5: FK5 J2000.0 (Right Ascension, Declination)
 * fk4: FK4 B1950.0 (Right Ascension, Declination)
 * galactic: IAU 1958 Galactic (Longitude, Latitude)
 * supergalactic: de Vaucouleurs Supergalactic (Longitude, Latitude)
 * ecliptic: Ecliptic (Longitude, Latitude)

The -inunit and -outunit flags may be used to indicate the units of
the existing coordinates and the units for the new coordinates
respectively; use one of degrees, radians or sexagesimal (may be
abbreviated), otherwise degrees will be assumed. For sexagesimal,
the two corresponding columns must be string-valued in forms like
hh:mm:ss.s and dd:mm:ss.s respectively.

For certain conversions, the value specified by the -epoch flag is
of significance. Where significant its value defaults to 2000.0.

Syntax for the <expr> , <col-id1> and <col-id2> arguments is
described in the manual.

The filtered table is returned.

args is a list with words as elements:
    [-epoch <expr>] [-inunit deg|rad|sex] [-outunit deg|rad|sex]
    <insys> <outsys> <col-id1> <col-id2> <col-name1> <col-name2>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("addskycoords")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_assert(table, *args):
    '''\
Check that a boolean expression is true for each row. If the
expression <test-expr> does not evaluate true for any row of the
table, execution terminates with an error. As long as no error
occurs, the output table is identical to the input one.

If the <msg-expr> parameter is supplied, then on failure it will be
evaluated and its value presented in the error message.

The exception generated by an assertion violation is of class
uk.ac.starlink.ttools.filter.AssertException although that is not
usually obvious if you are running from the shell in the usual way.

Syntax for the <test-expr> and <msg-expr> arguments is described in
the manual.

The filtered table is returned.

args is a list with words as elements:
    <test-expr> [<msg-expr>]
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("assert")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_badval(table, *args):
    '''\
For each column specified in <colid-list> any occurrence of the
value <bad-val> is replaced by a blank entry.

Syntax for the <colid-list> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    <bad-val> <colid-list>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("badval")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_cache(table):
    '''\
Stores in memory or on disk a temporary copy of the table at this
point in the pipeline. This can provide improvements in efficiency
if there is an expensive step upstream and a step which requires
more than one read of the data downstream. If you see an error like
"Can't re-read data from stream" then adding this step near the
start of the filters might help.

The output table contains no code-level reference to the input
table, so this filter can also be useful when managing tables that
have become deeply nested as the result of successively applying
many STILTS operations.

The result of this filter is guaranteed to be random-access.

See also the random filter, which caches only when the input table
is not random-access.

The filtered table is returned.
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("cache")
    sargs = []
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_check(table):
    '''\
Runs checks on the table at the indicated point in the processing
pipeline. This is strictly a debugging measure, and may be
time-consuming for large tables.

The filtered table is returned.
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("check")
    sargs = []
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_clearparams(table, *args):
    '''\
Clears the value of one or more named parameters. Each of the
<pname> values supplied may be either a parameter name or a simple
wildcard expression matching parameter names. Currently the only
wildcarding is a "*" to match any sequence of characters.
clearparams * will clear all the parameters in the table.

It is not an error to supply <pname>s which do not exist in the
table - these have no effect.

The filtered table is returned.

args is a list with words as elements:
    <pname> ...
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("clearparams")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_collapsecols(table, *args):
    '''\
Adds a new array-valued column by using the values from a specified
range of scalar columns as array elements. The new column is named
<array-colname>, and produced from the sequence of <ncol> scalar
columns starting with <col-id0>.

The array type of the output column is determined by the type of the
first input column (<col-id0>). If it is of type Double, the output
array column will be a double[] array, and similarly for types Long
, Integer, Float and Boolean. Other integer types are currently
mapped to int[], and object types, e.g. String, to the corresponding
array type. Array elements for null or mistyped input values are
mapped to NaN for floating point types, but note that they currently
just turn into zeros for integer array types and false for boolean.

By default the scalar columns that have been used are removed from
the output table and the new column replaces them at the same
position. However, if you supply the -keepscalars flag they will be
retained alongside the new array column (the new column will appear
just after the run of scalar columns).

This filter does the opposite of explodecols.

Syntax for the <col-id0> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    [-[no]keepscalars] <array-colname> <col-id0> <ncol>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("collapsecols")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_colmeta(table, *args):
    '''\
Modifies the metadata of one or more columns. Some or all of the
name, units, ucd, utype, description, shape and elementsize of the
column(s), identified by <colid-list> can be set by using some or
all of the listed flags. Typically, <colid-list> will simply be the
name of a single column.

The -name, -units, -ucd, -utype and -desc flags just take textual
arguments. The -shape flag can also be used, but is intended only
for array-valued columns, e.g. -shape 3,3 to declare a 3x3 array.
The final entry only in the shape list may be a "*" character to
indicate unknown extent. Array values with no specified shape
effectively have a shape of "*". The -elsize flag may be used to
specify the length of fixed length strings; use with non-string
columns is not recommended.

Syntax for the <colid-list> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    [-name <name>] [-units <units>] [-ucd <ucd>] [-utype <utype>]
    [-desc <descrip>] [-shape <n>[,<n>...][,*]] [-elsize <n>]
    <colid-list>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("colmeta")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_delcols(table, *args):
    '''\
Delete the specified columns. The same column may harmlessly be
specified more than once.

Syntax for the <colid-list> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    <colid-list>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("delcols")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_every(table, *args):
    '''\
Include only every <step>'th row in the result, starting with the
first row. The optional -approx/-exact argument controls whether the
selection needs to be exact; in some cases an approximate
calculation can take advantage of parallelism where an exact one
cannot.

The filtered table is returned.

args is a list with words as elements:
    [-exact|-approx] <step>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("every")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_explodecols(table, *args):
    '''\
Takes a list of specified columns which represent N-element arrays
and replaces each one with N scalar columns. Each of the columns
specified by <colid-list> must have a fixed-length array type,
though not all the arrays need to have the same number of elements.

This filter does the opposite of collapsecols.

Syntax for the <colid-list> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    <colid-list>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("explodecols")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_explodeall(table, *args):
    '''\
Replaces any columns which is an N-element arrays with N scalar
columns. Only columns with fixed array sizes are affected. The
action can be restricted to only columns of a certain shape using
the flags.

If the -ifndim flag is used, then only columns of dimensionality
<ndim> will be exploded. <ndim> may be 1, 2, ....

If the -ifshape flag is used, then only columns with a specific
shape will be exploded; <dims> is a space- or comma-separated list
of dimension extents, with the most rapidly-varying first, e.g. '2 5
' to explode all 2 x 5 element array columns.

The filtered table is returned.

args is a list with words as elements:
    [-ifndim <ndim>] [-ifshape <dims>]
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("explodeall")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_fixcolnames(table):
    '''\
Renames all columns and parameters in the input table so that they
have names which have convenient syntax for STILTS. For the most
part this means replacing spaces and other non-alphanumeric
characters with underscores. This is a convenience which lets you
use column names in algebraic expressions and other STILTS syntax.

Additionally, column names are adjusted if necessary to ensure that
they are all unique when compared case-insensitively. If the names
are all unique to start with then no changes are made, but if for
instance two columns exist with names gMag and GMag, one of them
will be altered (for instance to GMag_1).

The filtered table is returned.
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("fixcolnames")
    sargs = []
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_head(table, *args):
    '''\
Include only the first <nrows> rows of the table. If the table has
fewer than <nrows> rows then it will be unchanged.

The filtered table is returned.

args is a list with words as elements:
    <nrows>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("head")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_healpixmeta(table, *args):
    '''\
Adjusts the table metadata items that describe how HEALPix pixel
data is encoded in the table.

Zero or more of the following flags may be supplied:

 * -level <n>: Defines the HEALPix level; the sky is split into
      12*4^n pixels. This quantity is equal to logarithm base 2 of
      NSIDE.
 * -implicit: Declares that pixel indices are implicit, so that row
      i represents HEALPix pixel index i. The table should have
      12*4^level rows in this case. Not to be used with -column.
 * -column <col-id>: Declares that the column identified contains
      the (0-based) HEALPix pixel index. Not to be used with
      -implicit.
 * -csys C|G|E: Declares the sky coordinate system to which the
      HEALPix pixels apply: Celestial(=equatorial), Galactic or E
      cliptic. Some applications assume Galactic if this is not
      specified.
 * -nested: Declares that the NESTED ordering scheme is in use. Not
      to be used with -ring.
 * -ring: Declares that the RING ordering scheme is in use. Not to
      be used with -nested.

The effect of this filter is to write, or overwrite, certain special
table parameters (per-table metadata) that STIL uses to describe how
HEALPix pixel information is encoded in a table, specifically the
HEALPix level, the column containing pixel index, the ordering
scheme, and the sky coordinate system. Adding these parameters
doesn't do anything on its own, but some of the STIL I/O handlers
recognise these parameters, and they affect how the table will be
formatted for output. In particular, if you set these parameters and
then output to FITS format, the output table will contain headers
defined by the HEALPix-FITS serialization format which is understood
by several other applications to describe HEALPix maps. If you write
to VOTable format, the metadata will only be recognised by other
STIL-based applications but it means that if you, e.g., load the
table into TOPCAT and then write it out again as FITS, the HEALPix
information should be preserved.

When writing tables marked up like this to FITS, you have two
options. If you write to one of the "normal" FITS formats (e.g.
fits, fits-basic) then suitable headers will be added; in this case
if an explicit pixel index column is used it must be the first
column, and should be named "PIXEL". This may be enough for other
applications to recognise the HEALPix metadata. However, if you use
the special fits-healpix format more efforts will be made to conform
to the HEALPix-FITS convention, for instance moving and renaming the
explicit pixel index column if required.

The table parameters affected by this filter are: STIL_HPX_LEVEL,
STIL_HPX_ISNEST, STIL_HPX_COLNAME, STIL_HPX_CSYS. Note these are not
defined by any standard, they are defined and used only by STILTS
and related applications (TOPCAT).

Syntax for the <col-id> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    [-level <n>] [-implicit|-column <col-id>] [-csys C|G|E] [-nested|-ring] 
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("healpixmeta")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_keepcols(table, *args):
    '''\
Select the columns from the input table which will be included in
the output table. The output table will include only those columns
listed in <colid-list>, in that order. The same column may be listed
more than once, in which case it will appear in the output table
more than once.

Syntax for the <colid-list> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    <colid-list>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("keepcols")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_meta(table, *args):
    '''\
Provides information about the metadata for each column. This filter
turns the table sideways, so that each row of the output corresponds
to a column of the input. The columns of the output table contain
metadata items such as column name, units, UCD etc corresponding to
each column of the input table.

By default the output table contains columns for all metadata items
for which any of the columns have non-blank values.

However, the output may be customised by supplying one or more
<item> headings, in which case exactly those columns will appear,
regardless of whether they have entries. It is not an error to
specify an item for which no metadata exists in any of the columns
(such entries will result in empty columns).

Some of the metadata items commonly found are:

 * Index: Position of column in table
 * Name: Column name
 * Class: Data type of objects in column
 * Shape: Shape of array values
 * ElSize: Size of each element in column (mostly useful for
      strings)
 * Units: Unit string
 * Description: Description of data in the column
 * UCD: Unified Content Descriptor
 * Utype: Type in data model
 * Xtype: Extended data type
 * CoosysSystem: Sky coordinate system name from COOSYS
 * CoosysEpoch: Sky epoch from COOSYS
 * CoosysEquinox: Sky equinox from COOSYS
 * TimesysTimeorigin: Time origin from TIMESYS
 * TimesysTimescale: Timescale from TIMESYS
 * TimesysRefposition: Ref position from TIMESYS
 * STIL_HPX_LEVEL: Level of HEALPix pixels contained in the table
      (nside=2^level)
 * STIL_HPX_ISNEST: True for NEST indexation scheme, False for RING
 * STIL_HPX_COLNAME: Name of the table column containing HEALPix
      index; null value or empty string indicates implicit
 * STIL_HPX_CSYS: 'C'=celestial/equatorial, 'G'=galactic,
      'E'=ecliptic

Any table parameters of the input table are propagated to the output
one.

The filtered table is returned.

args is a list with words as elements:
    [<item> ...]
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("meta")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_progress(table):
    '''\
Monitors progress by displaying the number of rows processed so far
on the terminal (standard error). This number is updated every
second or thereabouts; if all the processing is done in under a
second you may not see any output. If the total number of rows in
the table is known, an ASCII-art progress bar is updated, otherwise
just the number of rows seen so far is written.

Note under some circumstances progress may appear to complete before
the actual work of the task is done since part of the processing
involves slurping up the whole table to provide random access on it.
In this case, applying the cache upstream may help.

The filtered table is returned.
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("progress")
    sargs = []
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_random(table):
    '''\
Ensures that random access is available on this table. If the table
currently has random access, it has no effect. If only sequential
access is available, the table is cached so that downstream steps
will see the cached, hence random-access, copy.

The filtered table is returned.
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("random")
    sargs = []
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_randomview(table):
    '''\
Ensures that steps downstream only use random access methods for
table access. If the table is sequential only, this will result in
an error. Only useful for debugging.

The filtered table is returned.
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("randomview")
    sargs = []
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_repeat(table, *args):
    '''\
Repeats the rows of a table multiple times to produce a longer
table. The output table will have <count> times as many rows as the
input table.

The optional flag determines the sequence of the output rows. If
<count>=2 and there are three rows, the output sequence will be
112233 for -row and 123123 for -table. The default behaviour is
currently -table.

The <count> value will usually be a constant integer value, but it
can be an expression evaluated in the context of the table.

The filtered table is returned.

args is a list with words as elements:
    [-row|-table] <count>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("repeat")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_replacecol(table, *args):
    '''\
Replaces the content of a column with the value of an algebraic
expression. The old values are discarded in favour of the result of
evaluating <expr>. You can specify the metadata for the new column
using the -name, -units, -ucd, -utype and -desc flags; for any of
these items which you do not specify, they will take the values from
the column being replaced.

It is legal to reference the replaced column in the expression, so
for example "replacecol pixsize pixsize*2" just multiplies the
values in column pixsize by 2.

Syntax for the <col-id> and <expr> arguments is described in the
manual.

The filtered table is returned.

args is a list with words as elements:
    [-name <name>] [-units <units>] [-ucd <ucd>] [-utype <utype>]
    [-desc <descrip>]
    <col-id> <expr>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("replacecol")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_replaceval(table, *args):
    '''\
For each column specified in <colid-list> any instance of <old-val>
is replaced by <new-val>. The value string 'null' can be used for
either <old-value> or <new-value> to indicate a blank value (but see
also the badval filter).

Syntax for the <colid-list> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    <old-val> <new-val> <colid-list>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("replaceval")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_rowrange(table, *args):
    '''\
Includes only rows in a given range. The range can either be
supplied as "<first> <last>", where row indices are inclusive, or "
<first> +<count>". In either case, the first row is numbered 1.

Thus, to get the first hundred rows, use either "rowrange 1 100" or
"rowrange 1 +100" and to get the second hundred, either "rowrange
101 200" or "rowrange 101 +100"

The filtered table is returned.

args is a list with words as elements:
    <first> <last>|+<count>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("rowrange")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_select(table, *args):
    '''\
Include in the output table only rows for which the expression
<expr> evaluates to true. <expr> must be an expression which
evaluates to a boolean value (true/false).

Syntax for the <expr> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    <expr>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("select")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_seqview(table):
    '''\
Ensures that steps downstream see the table as sequential access.
Any attempts at random access will fail. Only useful for debugging.

The filtered table is returned.
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("seqview")
    sargs = []
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_setparam(table, *args):
    '''\
Sets a named parameter in the table to a given value. The parameter
named <pname> is set to the value <pexpr>, which may be a literal
value or an expression involving mathematical operations and other
parameter names (using the param$<name> syntax). By default, the
data type of the parameter is determined by the type of the supplied
expression, but this can be overridden using the -type flag. The
parameter description, units, UCD and Utype attributes may
optionally be set using the other flags.

The filtered table is returned.

args is a list with words as elements:
    [-type byte|short|int|long|float|double|boolean|string]
    [-desc <descrip>] [-unit <units>] [-ucd <ucd>] [-utype <utype>]
    <pname> <pexpr>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("setparam")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_sort(table, *args):
    '''\
Sorts the table according to the value of one or more algebraic
expressions. The sort key expressions appear, as separate
(space-separated) words, in <key-list>; sorting is done on the first
expression first, but if that results in a tie then the second one
is used, and so on.

Each expression must evaluate to a type that it makes sense to sort,
for instance numeric. If the -down flag is used, the sort order is
descending rather than ascending.

Blank entries are by default considered to come at the end of the
collation sequence, but if the -nullsfirst flag is given then they
are considered to come at the start instead.

By default, sorting is done sequentially for small tables and in
parallel for large tables, but this can be controlled with the
-parallel or -noparallel flag.

Syntax for the <key-list> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    [-down] [-nullsfirst] [-[no]parallel] <key-list>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("sort")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_sorthead(table, *args):
    '''\
Performs a sort on the table according to the value of one or more
algebraic expressions, retaining only <nrows> rows at the head of
the resulting sorted table. The sort key expressions appear, as
separate (space-separated) words, in <key-list>; sorting is done on
the first expression first, but if that results in a tie then the
second one is used, and so on. Each expression must evaluate to a
type that it makes sense to sort, for instance numeric.

If the -tail flag is used, then the last <nrows> rows rather than
the first ones are retained.

If the -down flag is used the sort order is descending rather than
ascending.

Blank entries are by default considered to come at the end of the
collation sequence, but if the -nullsfirst flag is given then they
are considered to come at the start instead.

This filter is functionally equivalent to using sort followed by
head, but it can be done in one pass and is usually cheaper on
memory and faster, as long as <nrows> is significantly lower than
the size of the table.

Syntax for the <key-list> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    [-tail] [-down] [-nullsfirst] <nrows> <key-list>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("sorthead")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_stats(table, *args):
    '''\
Calculates statistics on the data in the table. This filter turns
the table sideways, so that each row of the output corresponds to a
column of the input. The columns of the output table contain
statistical items such as mean, standard deviation etc corresponding
to each column of the input table.

By default the output table contains columns for the following
items:

 * Name: Column name
 * Mean: Average
 * StDev: Population Standard deviation
 * Minimum: Numeric minimum
 * Maximum: Numeric maximum
 * NGood: Number of non-blank cells

However, the output may be customised by supplying one or more
<item> headings. These may be selected from the above as well as the
following:

 * NBad: Number of blank cells
 * Variance: Population Variance
 * SampStDev: Sample Standard Deviation
 * SampVariance: Sample Variance
 * MedAbsDev: Median Absolute Deviation
 * ScMedAbsDev: Median Absolute Deviation * 1.4826
 * Skew: Gamma 1 skewness measure
 * Kurtosis: Gamma 2 peakedness measure
 * Sum: Sum of values
 * MinPos: Row index of numeric minimum
 * MaxPos: Row index of numeric maximum
 * Cardinality: Number of distinct values in column; values >100
      ignored
 * Median: Middle value in sequence
 * Quartile1: First quartile
 * Quartile2: Second quartile
 * Quartile3: Third quartile
 * ArrayNGood: Per-element non-blank counts for fixed-length array
      columns
 * ArraySum: Per-element sums for fixed-length array columns
 * ArrayMean: Per-element means for fixed-length array columns
 * ArrayStDev: Per-element population standard deviation for
      fixed-length array columns

Additionally, the form "Q.nn" may be used to represent the quantile
corresponding to the proportion 0.nn, e.g.:

 * Q.25: First quartile
 * Q.625: Fifth octile

Any parameters of the input table are propagated to the output one.

The -qapprox or -qexact flag controls how quantiles are calculated.
With -qexact they are calculated exactly, but this requires memory
usage scaling with the number of rows. If the -qapprox flag is
supplied, an method is used which is typically slower and produces
only approximate values, but which will work in fixed memory and so
can be used for arbitrarily large tables. By default, exact
calculation is used. These flags are ignored if neither quantiles
nor the MAD are being calculated

The -noparallel flag may be supplied to inhibit multi-threaded
statistics accumulation. Calculation is done in parallel by default
if multi-threaded hardware is available, and it's usually faster.

The filtered table is returned.

args is a list with words as elements:
    [-[no]parallel] [-qapprox|-qexact] [<item> ...]
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("stats")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_tablename(table, *args):
    '''\
Sets the table's name attribute to the given string.

The filtered table is returned.

args is a list with words as elements:
    <name>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("tablename")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_tail(table, *args):
    '''\
Include only the last <nrows> rows of the table. If the table has
fewer than <nrows> rows then it will be unchanged.

The filtered table is returned.

args is a list with words as elements:
    <nrows>
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("tail")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_transpose(table, *args):
    '''\
Transposes the input table so that columns become rows and vice
versa. The -namecol flag can be used to specify a column in the
input table which will provide the column names for the output
table. The first column of the output table will contain the column
names of the input table.

Syntax for the <col-id> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    [-namecol <col-id>]
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("transpose")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def cmd_uniq(table, *args):
    '''\
Eliminates adjacent rows which have the same values. If used with no
arguments, then any row which has identical values to its
predecessor is removed.

If the <colid-list> parameter is given then only the values in the
specified columns must be equal in order for the row to be removed.

If the -count flag is given, then an additional column with the name
DupCount will be prepended to the table giving a count of the number
of duplicated input rows represented by each output row. A unique
row has a DupCount value of 1.

Syntax for the <colid-list> argument is described in SUN/256.

The filtered table is returned.

args is a list with words as elements:
    [-count] [<colid-list>]
'''
    pfilt = _StepFactory.getInstance().getFilterFactory().createObject("uniq")
    sargs = [str(a) for a in args]
    argList = _ArrayList(sargs)
    step = pfilt.createStep(argList.iterator())
    return import_star_table(step.wrap(table))

def mode_out(table, out='-', ofmt='(auto)'):
    '''\
Writes a new table.

Parameters:

   out = <out-table>       (uk.ac.starlink.ttools.TableConsumer)
      The location of the output table. This is usually a filename
      to write to. If it is equal to the special value "-" (the
      default) the output table will be written to standard output.

      [Default: -]

   ofmt = <out-format>       (String)
      Specifies the format in which the output table will be written
      (one of the ones in SUN/256 - matching is case-insensitive and
      you can use just the first few letters). If it has the special
      value "(auto)" (the default), then the output filename will be
      examined to try to guess what sort of file is required usually
      by looking at the extension. If it's not obvious from the
      filename what output format is intended, an error will result.

      [Default: (auto)]
'''
    env = _JyEnvironment()
    env.setValue('out', _map_env_value(out))
    env.setValue('ofmt', _map_env_value(ofmt))
    mode = _stilts.getModeFactory().createObject('out')
    consumer = mode.createConsumer(env)
    _check_unused_args(env)
    consumer.consume(table)

def mode_meta(table):
    '''\
Prints the table metadata to standard output. The name and type etc
of each column is tabulated, and table parameters are also shown.

See the meta filter for more flexible output of table metadata.
'''
    env = _JyEnvironment()
    mode = _stilts.getModeFactory().createObject('meta')
    consumer = mode.createConsumer(env)
    _check_unused_args(env)
    consumer.consume(table)

def mode_stats(table):
    '''\
Calculates and displays univariate statistics for each of the
numeric columns in the table. The following entries are shown for
each column as appropriate:

 * mean
 * population standard deviation
 * minimum
 * maximum
 * number of non-null entries

See the stats filter for more flexible statistical calculations.
'''
    env = _JyEnvironment()
    mode = _stilts.getModeFactory().createObject('stats')
    consumer = mode.createConsumer(env)
    _check_unused_args(env)
    consumer.consume(table)

def mode_count(table):
    '''\
Counts the number of rows and columns and writes the result to
standard output.
'''
    env = _JyEnvironment()
    mode = _stilts.getModeFactory().createObject('count')
    consumer = mode.createConsumer(env)
    _check_unused_args(env)
    consumer.consume(table)

def mode_checksum(table):
    '''\
Calculates a checksum from all the data in the table. The checksum
is written to standard output in hexadecimal; row and column counts
are also written.

If two tables have the same checksum it is extremely likely that
they contain the same cell data. If they have a different checksum,
their cell data differs. By default, the checksum implementation
uses Adler32, which is fast but not cryptographically secure.
'''
    env = _JyEnvironment()
    mode = _stilts.getModeFactory().createObject('checksum')
    consumer = mode.createConsumer(env)
    _check_unused_args(env)
    consumer.consume(table)

def mode_cgi(table, ofmt='votable'):
    '''\
Writes a table to standard output in a way suitable for use as
output from a CGI (Common Gateway Interface) program. This is very
much like out mode but a short CGI header giving the MIME
Content-Type is prepended to the output

Parameters:

   ofmt = <out-format>       (String)
      Specifies the format in which the output table will be written
      (one of the ones in SUN/256 - matching is case-insensitive and
      you can use just the first few letters).

      [Default: votable]
'''
    env = _JyEnvironment()
    env.setValue('ofmt', _map_env_value(ofmt))
    mode = _stilts.getModeFactory().createObject('cgi')
    consumer = mode.createConsumer(env)
    _check_unused_args(env)
    consumer.consume(table)

def mode_discard(table):
    '''\
Reads all the data in the table in sequential mode and discards it.
May be useful in conjunction with the assert filter.
'''
    env = _JyEnvironment()
    mode = _stilts.getModeFactory().createObject('discard')
    consumer = mode.createConsumer(env)
    _check_unused_args(env)
    consumer.consume(table)

def mode_topcat(table):
    '''\
Attempts to display the output table directly in TOPCAT. If a TOPCAT
instance is already running on the local host, an attempt will be
made to open the table in that. A variety of mechanisms are used to
attempt communication with an existing TOPCAT instance. In order:
 * SAMP using existing hub (TOPCAT v3.4+ only, requires SAMP hub to
      be running)
 * PLASTIC using existing hub (requires PLASTIC hub to be running)
 * SOAP (requires TOPCAT to run with somewhat deprecated -soap flag,
      may be limitations on table size)
 * SAMP using internal, short-lived hub (TOPCAT v3.4+ only, running
      hub not required, but may be slow. It's better to start an
      external hub, e.g. topcat -exthub) Failing that, an attempt
will be made to launch a new TOPCAT instance for display. This only
works if the TOPCAT classes are on the class path.

If large tables are involved, starting TOPCAT with the -disk flag is
probably a good idea.
'''
    env = _JyEnvironment()
    mode = _stilts.getModeFactory().createObject('topcat')
    consumer = mode.createConsumer(env)
    _check_unused_args(env)
    consumer.consume(table)

def mode_samp(table, format='votable fits', client=None):
    '''\
Sends the table to registered SAMP-aware applications subscribed to
a suitable table load MType. SAMP, the Simple Application Messaging
Protocol, is a tool interoperability protocol. A SAMP Hub must be
running for this to work.

Parameters:

   format = <value>       (String[])
      Gives one or more table format types for attempting the table
      transmission over SAMP. If multiple values are supplied, they
      should be separated by spaces. Each value supplied for this
      parameter corresponds to a different MType which may be used
      for the transmission. If a single value is used, a SAMP
      broadcast will be used. If multiple values are used, each
      registered client will be interrogated to see whether it
      subscribes to the corresponding MTypes in order; the first one
      to which it is subscribed will be used to send the table. The
      standard options are

       * votable: use MType table.load.votable
       * fits: use MType table.load.fits

      If any other string is used which corresponds to one of
      STILTS's known table output formats, an attempt will be made
      to use an ad-hoc MType of the form table.load.format.

      [Default: votable fits]

   client = <name-or-id>       (String)
      Identifies a registered SAMP client which is to receive the
      table. Either the client ID or the (case-insensitive)
      application name may be used. If a non-null value is given,
      then the table will be sent to only the first client with the
      given name or ID. If no value is supplied the table will be
      sent to all suitably subscribed clients.
'''
    env = _JyEnvironment()
    env.setValue('format', _map_env_value(format))
    env.setValue('client', _map_env_value(client))
    mode = _stilts.getModeFactory().createObject('samp')
    consumer = mode.createConsumer(env)
    _check_unused_args(env)
    consumer.consume(table)

def mode_plastic(table, transport=None, client=None):
    '''\
Broadcasts the table to any registered Plastic-aware applications.
PLASTIC, the PLatform for AStronomical Tool InterConnection, is a
tool interoperability protocol. A Plastic hub must be running in
order for this to work.

Parameters:

   transport = string|file       (String)
      Determines the method (PLASTIC message) used to perform the
      PLASTIC communication. The choices are

       * string: VOTable serialized as a string and passed as a call
            parameter (ivo://votech.org/votable/load). Not suitable
            for very large files.
       * file: VOTable written to a temporary file and the filename
            passed as a call parameter (
            ivo://votech.org/votable/loadFromURL). The file ought to
            be deleted once it has been loaded. Not suitable for
            inter-machine communication.

      If no value is set (null) then a decision will be taken based
      on the apparent size of the table.

   client = <app-name>       (String)
      Gives the name of a PLASTIC listener application which is to
      receive the broadcast table. If a non-null value is given,
      then only the first registered application which reports its
      application name as that value will receive the message. If no
      value is supplied, the broadcast will be to all listening
      applications.
'''
    env = _JyEnvironment()
    env.setValue('transport', _map_env_value(transport))
    env.setValue('client', _map_env_value(client))
    mode = _stilts.getModeFactory().createObject('plastic')
    consumer = mode.createConsumer(env)
    _check_unused_args(env)
    consumer.consume(table)

def mode_tosql(table, protocol, db, dbtable, host='localhost', write='create', user='mbt', password=None):
    '''\
Writes a new table to an SQL database. You need the appropriate JDBC
drivers and -Djdbc.drivers set as usual (see SUN/256).

Parameters:

   protocol = <jdbc-protocol>       (String)
      The driver-specific sub-protocol specifier for the JDBC
      connection. For MySQL's Connector/J driver, this is mysql, and
      for PostgreSQL's driver it is postgresql. For other drivers,
      you may have to consult the driver documentation.

   host = <value>       (String)
      The host which is acting as a database server.

      [Default: localhost]

   db = <db-name>       (String)
      The name of the database on the server into which the new
      table will be written.

      The value of this parameter forms the last part of the JDBC
      connection URL. That means that for some JDBC drivers, you can
      append parameter specifications to it to affect the way the
      connection is made to the database, e.g. "
      db=some_db?useSSL=false" for MySQL's Connector/J.

   dbtable = <table-name>       (String)
      The name of the table which will be written to the database.

   write = create|dropcreate|append       
   (uk.ac.starlink.table.jdbc.WriteMode)
      Controls how the values are written to a table in the
      database. The options are:

       * create: Creates a new table before writing. It is an error
            if a table of the same name already exists.
       * dropcreate: Creates a new database table before writing. If
            a table of the same name already exists, it is dropped
            first.
       * append: Appends to an existing table. An error results if
            the named table has the wrong structure (number or types
            of columns) for the data being written.

      [Default: create]

   user = <username>       (String)
      User name for the SQL connection to the database.

      [Default: mbt]

   password = <passwd>       (String)
      Password for the SQL connection to the database.
'''
    env = _JyEnvironment()
    env.setValue('protocol', _map_env_value(protocol))
    env.setValue('db', _map_env_value(db))
    env.setValue('dbtable', _map_env_value(dbtable))
    env.setValue('host', _map_env_value(host))
    env.setValue('write', _map_env_value(write))
    env.setValue('user', _map_env_value(user))
    env.setValue('password', _map_env_value(password))
    mode = _stilts.getModeFactory().createObject('tosql')
    consumer = mode.createConsumer(env)
    _check_unused_args(env)
    consumer.consume(table)

def mode_gui(table):
    '''\
Displays the table in a scrollable window.
'''
    env = _JyEnvironment()
    mode = _stilts.getModeFactory().createObject('gui')
    consumer = mode.createConsumer(env)
    _check_unused_args(env)
    consumer.consume(table)

