# Motopy

`Motopy` is a tool used to translate Matlab/Octave code TO PYthon.

## Introduce

`Motopy` is a powerful tool used to translate `Matlab`/`Octave` code to `PYthon`. In the process of translation, the python statement generated by `mopy` will be executed to ensure the translated correctness of subsequent code. For example, the following `Matlab`/`Octave` code:

```m
a = ones(1, 3);
b = a';
c = a * b;
```
will be translated to `python` code:

```py
import numpy as np
a = np.ones((1, 3))
b = a.T
c = a @ b
```

The type of the variables `a` and `b` are array. So the third statement `c = a * b` will be translate to: `c = a @ b`.

## install

Please use `pip` install `motopy`:

```bash
pip install motopy
```

## Quick Start

- `Motopy` is very easy to use. First please prepare your `Matlab`/`Octave` files, put the script file and the function files with extetion ".m" in a folder, and ensure that your `Matlab`/`Octave` script can be run without exception. And meet [the use requirements of motopy](#The_Use_Requirements_Of_Motopy).

- Create a `python` script file, and input the folowing code:

    ```py
    import motopy

    motopy.make(
        entryfile='<the script filename without extension(*.m)>',
        input_path='<the input path of *.m files>', 
        output_path='<the output path of *.py files>' 
    )
    ```
    You can see [demo.py](./demo.py).

- Just run.

## The Use Requirements Of Motopy

The translation will failed if your `Matlab`/`Octave` code don't satisfy the folowing requirements:

- Do not use blank spaces to separate elements in arrays and cells. The following code will make failed:

    ```m
    a = [1 2 3; 4 5 6];
    c = {1 2 'abc'};
    ```

- The first function name in a function file must be same as the filename.

- Arrays and cells should be defined before used and allocated enough space. The following code will make failed:

    ```m
    for k=1:5
        A(k) = 2*k; % The variable A is not defined before used.
    end
    ```

    ```m
    A = []; % The variable A has not enough space.
    for k=1:5
        A(k) = 2*k; % the size of variable A will grow in iteration.
    end
    ```
