"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationDeployStackInstancesAction = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const action_1 = require("../action");
const common_1 = require("../common");
const singleton_policy_1 = require("./private/singleton-policy");
/**
 * CodePipeline action to create/update Stack Instances of a StackSet
 *
 * After the initial creation of a stack set, you can add new stack instances by
 * using CloudFormationStackInstances. Template parameter values can be
 * overridden at the stack instance level during create or update stack set
 * instance operations.
 *
 * Each stack set has one template and set of template parameters. When you
 * update the template or template parameters, you update them for the entire
 * set. Then all instance statuses are set to OUTDATED until the changes are
 * deployed to that instance.
 */
class CloudFormationDeployStackInstancesAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            region: props.stackSetRegion,
            provider: 'CloudFormationStackInstances',
            category: codepipeline.ActionCategory.DEPLOY,
            artifactBounds: {
                minInputs: 0,
                maxInputs: 3,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [
                ...props.parameterOverrides?._artifactsReferenced ?? [],
                ...props.stackInstances?._artifactsReferenced ?? [],
            ],
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_actions_CloudFormationDeployStackInstancesActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudFormationDeployStackInstancesAction);
            }
            throw error;
        }
        this.props = props;
        common_1.validatePercentage('failureTolerancePercentage', props.failureTolerancePercentage);
        common_1.validatePercentage('maxAccountConcurrencyPercentage', props.maxAccountConcurrencyPercentage);
    }
    bound(scope, _stage, options) {
        const singletonPolicy = singleton_policy_1.SingletonPolicy.forRole(options.role);
        singletonPolicy.grantCreateUpdateStackSet(this.props);
        const instancesResult = this.props.stackInstances?._bind(scope);
        if ((this.actionProperties.inputs || []).length > 0) {
            options.bucket.grantRead(singletonPolicy);
        }
        return {
            configuration: {
                StackSetName: this.props.stackSetName,
                ParameterOverrides: this.props.parameterOverrides?._render(),
                FailureTolerancePercentage: this.props.failureTolerancePercentage,
                MaxConcurrentPercentage: this.props.maxAccountConcurrencyPercentage,
                ...instancesResult?.stackSetConfiguration,
            },
        };
    }
}
exports.CloudFormationDeployStackInstancesAction = CloudFormationDeployStackInstancesAction;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationDeployStackInstancesAction[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.CloudFormationDeployStackInstancesAction", version: "1.163.1" };
//# sourceMappingURL=data:application/json;base64,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