"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleSettingPropDefaults = exports.checkForMultipleApiKeys = exports.validateProps = void 0;
const loglevel_1 = require("loglevel");
const constants_1 = require("./constants");
function validateProps(props) {
    loglevel_1.default.debug("Validating props...");
    checkForMultipleApiKeys(props);
    const siteList = [
        "datadoghq.com",
        "datadoghq.eu",
        "us3.datadoghq.com",
        "us5.datadoghq.com",
        "ddog-gov.com",
    ];
    if (props.site !== undefined && !siteList.includes(props.site.toLowerCase())) {
        throw new Error("Warning: Invalid site URL. Must be either datadoghq.com, datadoghq.eu, us3.datadoghq.com, us5.datadoghq.com, or ddog-gov.com.");
    }
    if (props.apiKey === undefined &&
        props.apiKmsKey === undefined &&
        props.apiKeySecretArn === undefined &&
        props.flushMetricsToLogs === false) {
        throw new Error("When `flushMetricsToLogs` is false, `apiKey`, `apiKeySecretArn`, or `apiKmsKey` must also be set.");
    }
    if (props.extensionLayerVersion !== undefined) {
        if (props.apiKey === undefined && props.apiKeySecretArn === undefined && props.apiKmsKey === undefined) {
            throw new Error("When `extensionLayer` is set, `apiKey`, `apiKeySecretArn`, or `apiKmsKey` must also be set.");
        }
    }
}
exports.validateProps = validateProps;
function checkForMultipleApiKeys(props) {
    let multipleApiKeysMessage;
    if (props.apiKey !== undefined && props.apiKmsKey !== undefined && props.apiKeySecretArn !== undefined) {
        multipleApiKeysMessage = "`apiKey`, `apiKmsKey`, and `apiKeySecretArn`";
    }
    else if (props.apiKey !== undefined && props.apiKmsKey !== undefined) {
        multipleApiKeysMessage = "`apiKey` and `apiKmsKey`";
    }
    else if (props.apiKey !== undefined && props.apiKeySecretArn !== undefined) {
        multipleApiKeysMessage = "`apiKey` and `apiKeySecretArn`";
    }
    else if (props.apiKmsKey !== undefined && props.apiKeySecretArn !== undefined) {
        multipleApiKeysMessage = "`apiKmsKey` and `apiKeySecretArn`";
    }
    if (multipleApiKeysMessage) {
        throw new Error(`${multipleApiKeysMessage} should not be set at the same time.`);
    }
}
exports.checkForMultipleApiKeys = checkForMultipleApiKeys;
function handleSettingPropDefaults(props) {
    let addLayers = props.addLayers;
    let enableDatadogTracing = props.enableDatadogTracing;
    let injectLogContext = props.injectLogContext;
    const logLevel = props.logLevel;
    let enableDatadogLogs = props.enableDatadogLogs;
    let captureLambdaPayload = props.captureLambdaPayload;
    if (addLayers === undefined) {
        loglevel_1.default.debug(`No value provided for addLayers, defaulting to ${constants_1.DefaultDatadogProps.addLayers}`);
        addLayers = constants_1.DefaultDatadogProps.addLayers;
    }
    if (enableDatadogTracing === undefined) {
        loglevel_1.default.debug(`No value provided for enableDatadogTracing, defaulting to ${constants_1.DefaultDatadogProps.enableDatadogTracing}`);
        enableDatadogTracing = constants_1.DefaultDatadogProps.enableDatadogTracing;
    }
    if (injectLogContext === undefined) {
        loglevel_1.default.debug(`No value provided for injectLogContext, defaulting to ${constants_1.DefaultDatadogProps.injectLogContext}`);
        injectLogContext = constants_1.DefaultDatadogProps.injectLogContext;
    }
    if (logLevel === undefined) {
        loglevel_1.default.debug(`No value provided for logLevel`);
    }
    if (enableDatadogLogs === undefined) {
        loglevel_1.default.debug(`No value provided for enableDatadogLogs, defaulting to ${constants_1.DefaultDatadogProps.enableDatadogLogs}`);
        enableDatadogLogs = constants_1.DefaultDatadogProps.enableDatadogLogs;
    }
    if (captureLambdaPayload === undefined) {
        loglevel_1.default.debug(`No value provided for captureLambdaPayload, default to ${constants_1.DefaultDatadogProps.captureLambdaPayload}`);
        captureLambdaPayload = constants_1.DefaultDatadogProps.captureLambdaPayload;
    }
    return {
        addLayers: addLayers,
        enableDatadogTracing: enableDatadogTracing,
        injectLogContext: injectLogContext,
        logLevel: logLevel,
        enableDatadogLogs: enableDatadogLogs,
        captureLambdaPayload: captureLambdaPayload,
    };
}
exports.handleSettingPropDefaults = handleSettingPropDefaults;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YWRvZ1NoYXJlZExvZ2ljLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2NvbW1vbi9kYXRhZG9nU2hhcmVkTG9naWMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7R0FNRzs7O0FBRUgsdUNBQTJCO0FBQzNCLDJDQUFrRDtBQUdsRCxTQUFnQixhQUFhLENBQUMsS0FBbUI7SUFDL0Msa0JBQUcsQ0FBQyxLQUFLLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUVqQyx1QkFBdUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMvQixNQUFNLFFBQVEsR0FBYTtRQUN6QixlQUFlO1FBQ2YsY0FBYztRQUNkLG1CQUFtQjtRQUNuQixtQkFBbUI7UUFDbkIsY0FBYztLQUNmLENBQUM7SUFDRixJQUFJLEtBQUssQ0FBQyxJQUFJLEtBQUssU0FBUyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDLEVBQUU7UUFDNUUsTUFBTSxJQUFJLEtBQUssQ0FDYiwrSEFBK0gsQ0FDaEksQ0FBQztLQUNIO0lBRUQsSUFDRSxLQUFLLENBQUMsTUFBTSxLQUFLLFNBQVM7UUFDMUIsS0FBSyxDQUFDLFNBQVMsS0FBSyxTQUFTO1FBQzdCLEtBQUssQ0FBQyxlQUFlLEtBQUssU0FBUztRQUNuQyxLQUFLLENBQUMsa0JBQWtCLEtBQUssS0FBSyxFQUNsQztRQUNBLE1BQU0sSUFBSSxLQUFLLENBQ2IsbUdBQW1HLENBQ3BHLENBQUM7S0FDSDtJQUNELElBQUksS0FBSyxDQUFDLHFCQUFxQixLQUFLLFNBQVMsRUFBRTtRQUM3QyxJQUFJLEtBQUssQ0FBQyxNQUFNLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxlQUFlLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxTQUFTLEtBQUssU0FBUyxFQUFFO1lBQ3RHLE1BQU0sSUFBSSxLQUFLLENBQUMsNkZBQTZGLENBQUMsQ0FBQztTQUNoSDtLQUNGO0FBQ0gsQ0FBQztBQWhDRCxzQ0FnQ0M7QUFFRCxTQUFnQix1QkFBdUIsQ0FBQyxLQUFtQjtJQUN6RCxJQUFJLHNCQUFzQixDQUFDO0lBQzNCLElBQUksS0FBSyxDQUFDLE1BQU0sS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLFNBQVMsS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLGVBQWUsS0FBSyxTQUFTLEVBQUU7UUFDdEcsc0JBQXNCLEdBQUcsOENBQThDLENBQUM7S0FDekU7U0FBTSxJQUFJLEtBQUssQ0FBQyxNQUFNLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxTQUFTLEtBQUssU0FBUyxFQUFFO1FBQ3RFLHNCQUFzQixHQUFHLDBCQUEwQixDQUFDO0tBQ3JEO1NBQU0sSUFBSSxLQUFLLENBQUMsTUFBTSxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsZUFBZSxLQUFLLFNBQVMsRUFBRTtRQUM1RSxzQkFBc0IsR0FBRyxnQ0FBZ0MsQ0FBQztLQUMzRDtTQUFNLElBQUksS0FBSyxDQUFDLFNBQVMsS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLGVBQWUsS0FBSyxTQUFTLEVBQUU7UUFDL0Usc0JBQXNCLEdBQUcsbUNBQW1DLENBQUM7S0FDOUQ7SUFFRCxJQUFJLHNCQUFzQixFQUFFO1FBQzFCLE1BQU0sSUFBSSxLQUFLLENBQUMsR0FBRyxzQkFBc0Isc0NBQXNDLENBQUMsQ0FBQztLQUNsRjtBQUNILENBQUM7QUFmRCwwREFlQztBQUVELFNBQWdCLHlCQUF5QixDQUFDLEtBQW1CO0lBQzNELElBQUksU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7SUFDaEMsSUFBSSxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7SUFDdEQsSUFBSSxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUM7SUFDOUMsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztJQUNoQyxJQUFJLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztJQUNoRCxJQUFJLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQztJQUV0RCxJQUFJLFNBQVMsS0FBSyxTQUFTLEVBQUU7UUFDM0Isa0JBQUcsQ0FBQyxLQUFLLENBQUMsa0RBQWtELCtCQUFtQixDQUFDLFNBQVMsRUFBRSxDQUFDLENBQUM7UUFDN0YsU0FBUyxHQUFHLCtCQUFtQixDQUFDLFNBQVMsQ0FBQztLQUMzQztJQUNELElBQUksb0JBQW9CLEtBQUssU0FBUyxFQUFFO1FBQ3RDLGtCQUFHLENBQUMsS0FBSyxDQUFDLDZEQUE2RCwrQkFBbUIsQ0FBQyxvQkFBb0IsRUFBRSxDQUFDLENBQUM7UUFDbkgsb0JBQW9CLEdBQUcsK0JBQW1CLENBQUMsb0JBQW9CLENBQUM7S0FDakU7SUFDRCxJQUFJLGdCQUFnQixLQUFLLFNBQVMsRUFBRTtRQUNsQyxrQkFBRyxDQUFDLEtBQUssQ0FBQyx5REFBeUQsK0JBQW1CLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQyxDQUFDO1FBQzNHLGdCQUFnQixHQUFHLCtCQUFtQixDQUFDLGdCQUFnQixDQUFDO0tBQ3pEO0lBQ0QsSUFBSSxRQUFRLEtBQUssU0FBUyxFQUFFO1FBQzFCLGtCQUFHLENBQUMsS0FBSyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7S0FDN0M7SUFDRCxJQUFJLGlCQUFpQixLQUFLLFNBQVMsRUFBRTtRQUNuQyxrQkFBRyxDQUFDLEtBQUssQ0FBQywwREFBMEQsK0JBQW1CLENBQUMsaUJBQWlCLEVBQUUsQ0FBQyxDQUFDO1FBQzdHLGlCQUFpQixHQUFHLCtCQUFtQixDQUFDLGlCQUFpQixDQUFDO0tBQzNEO0lBQ0QsSUFBSSxvQkFBb0IsS0FBSyxTQUFTLEVBQUU7UUFDdEMsa0JBQUcsQ0FBQyxLQUFLLENBQUMsMERBQTBELCtCQUFtQixDQUFDLG9CQUFvQixFQUFFLENBQUMsQ0FBQztRQUNoSCxvQkFBb0IsR0FBRywrQkFBbUIsQ0FBQyxvQkFBb0IsQ0FBQztLQUNqRTtJQUVELE9BQU87UUFDTCxTQUFTLEVBQUUsU0FBUztRQUNwQixvQkFBb0IsRUFBRSxvQkFBb0I7UUFDMUMsZ0JBQWdCLEVBQUUsZ0JBQWdCO1FBQ2xDLFFBQVEsRUFBRSxRQUFRO1FBQ2xCLGlCQUFpQixFQUFFLGlCQUFpQjtRQUNwQyxvQkFBb0IsRUFBRSxvQkFBb0I7S0FDM0MsQ0FBQztBQUNKLENBQUM7QUF4Q0QsOERBd0NDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIFVubGVzcyBleHBsaWNpdGx5IHN0YXRlZCBvdGhlcndpc2UgYWxsIGZpbGVzIGluIHRoaXMgcmVwb3NpdG9yeSBhcmUgbGljZW5zZWRcbiAqIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSBWZXJzaW9uIDIuMC5cbiAqXG4gKiBUaGlzIHByb2R1Y3QgaW5jbHVkZXMgc29mdHdhcmUgZGV2ZWxvcGVkIGF0IERhdGFkb2cgKGh0dHBzOi8vd3d3LmRhdGFkb2docS5jb20vKS5cbiAqIENvcHlyaWdodCAyMDIxIERhdGFkb2csIEluYy5cbiAqL1xuXG5pbXBvcnQgbG9nIGZyb20gXCJsb2dsZXZlbFwiO1xuaW1wb3J0IHsgRGVmYXVsdERhdGFkb2dQcm9wcyB9IGZyb20gXCIuL2NvbnN0YW50c1wiO1xuaW1wb3J0IHsgRGF0YWRvZ1Byb3BzLCBEYXRhZG9nU3RyaWN0UHJvcHMgfSBmcm9tIFwiLi9pbnRlcmZhY2VzXCI7XG5cbmV4cG9ydCBmdW5jdGlvbiB2YWxpZGF0ZVByb3BzKHByb3BzOiBEYXRhZG9nUHJvcHMpIHtcbiAgbG9nLmRlYnVnKFwiVmFsaWRhdGluZyBwcm9wcy4uLlwiKTtcblxuICBjaGVja0Zvck11bHRpcGxlQXBpS2V5cyhwcm9wcyk7XG4gIGNvbnN0IHNpdGVMaXN0OiBzdHJpbmdbXSA9IFtcbiAgICBcImRhdGFkb2docS5jb21cIixcbiAgICBcImRhdGFkb2docS5ldVwiLFxuICAgIFwidXMzLmRhdGFkb2docS5jb21cIixcbiAgICBcInVzNS5kYXRhZG9naHEuY29tXCIsXG4gICAgXCJkZG9nLWdvdi5jb21cIixcbiAgXTtcbiAgaWYgKHByb3BzLnNpdGUgIT09IHVuZGVmaW5lZCAmJiAhc2l0ZUxpc3QuaW5jbHVkZXMocHJvcHMuc2l0ZS50b0xvd2VyQ2FzZSgpKSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgIFwiV2FybmluZzogSW52YWxpZCBzaXRlIFVSTC4gTXVzdCBiZSBlaXRoZXIgZGF0YWRvZ2hxLmNvbSwgZGF0YWRvZ2hxLmV1LCB1czMuZGF0YWRvZ2hxLmNvbSwgdXM1LmRhdGFkb2docS5jb20sIG9yIGRkb2ctZ292LmNvbS5cIixcbiAgICApO1xuICB9XG5cbiAgaWYgKFxuICAgIHByb3BzLmFwaUtleSA9PT0gdW5kZWZpbmVkICYmXG4gICAgcHJvcHMuYXBpS21zS2V5ID09PSB1bmRlZmluZWQgJiZcbiAgICBwcm9wcy5hcGlLZXlTZWNyZXRBcm4gPT09IHVuZGVmaW5lZCAmJlxuICAgIHByb3BzLmZsdXNoTWV0cmljc1RvTG9ncyA9PT0gZmFsc2VcbiAgKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgXCJXaGVuIGBmbHVzaE1ldHJpY3NUb0xvZ3NgIGlzIGZhbHNlLCBgYXBpS2V5YCwgYGFwaUtleVNlY3JldEFybmAsIG9yIGBhcGlLbXNLZXlgIG11c3QgYWxzbyBiZSBzZXQuXCIsXG4gICAgKTtcbiAgfVxuICBpZiAocHJvcHMuZXh0ZW5zaW9uTGF5ZXJWZXJzaW9uICE9PSB1bmRlZmluZWQpIHtcbiAgICBpZiAocHJvcHMuYXBpS2V5ID09PSB1bmRlZmluZWQgJiYgcHJvcHMuYXBpS2V5U2VjcmV0QXJuID09PSB1bmRlZmluZWQgJiYgcHJvcHMuYXBpS21zS2V5ID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihcIldoZW4gYGV4dGVuc2lvbkxheWVyYCBpcyBzZXQsIGBhcGlLZXlgLCBgYXBpS2V5U2VjcmV0QXJuYCwgb3IgYGFwaUttc0tleWAgbXVzdCBhbHNvIGJlIHNldC5cIik7XG4gICAgfVxuICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBjaGVja0Zvck11bHRpcGxlQXBpS2V5cyhwcm9wczogRGF0YWRvZ1Byb3BzKSB7XG4gIGxldCBtdWx0aXBsZUFwaUtleXNNZXNzYWdlO1xuICBpZiAocHJvcHMuYXBpS2V5ICE9PSB1bmRlZmluZWQgJiYgcHJvcHMuYXBpS21zS2V5ICE9PSB1bmRlZmluZWQgJiYgcHJvcHMuYXBpS2V5U2VjcmV0QXJuICE9PSB1bmRlZmluZWQpIHtcbiAgICBtdWx0aXBsZUFwaUtleXNNZXNzYWdlID0gXCJgYXBpS2V5YCwgYGFwaUttc0tleWAsIGFuZCBgYXBpS2V5U2VjcmV0QXJuYFwiO1xuICB9IGVsc2UgaWYgKHByb3BzLmFwaUtleSAhPT0gdW5kZWZpbmVkICYmIHByb3BzLmFwaUttc0tleSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgbXVsdGlwbGVBcGlLZXlzTWVzc2FnZSA9IFwiYGFwaUtleWAgYW5kIGBhcGlLbXNLZXlgXCI7XG4gIH0gZWxzZSBpZiAocHJvcHMuYXBpS2V5ICE9PSB1bmRlZmluZWQgJiYgcHJvcHMuYXBpS2V5U2VjcmV0QXJuICE9PSB1bmRlZmluZWQpIHtcbiAgICBtdWx0aXBsZUFwaUtleXNNZXNzYWdlID0gXCJgYXBpS2V5YCBhbmQgYGFwaUtleVNlY3JldEFybmBcIjtcbiAgfSBlbHNlIGlmIChwcm9wcy5hcGlLbXNLZXkgIT09IHVuZGVmaW5lZCAmJiBwcm9wcy5hcGlLZXlTZWNyZXRBcm4gIT09IHVuZGVmaW5lZCkge1xuICAgIG11bHRpcGxlQXBpS2V5c01lc3NhZ2UgPSBcImBhcGlLbXNLZXlgIGFuZCBgYXBpS2V5U2VjcmV0QXJuYFwiO1xuICB9XG5cbiAgaWYgKG11bHRpcGxlQXBpS2V5c01lc3NhZ2UpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoYCR7bXVsdGlwbGVBcGlLZXlzTWVzc2FnZX0gc2hvdWxkIG5vdCBiZSBzZXQgYXQgdGhlIHNhbWUgdGltZS5gKTtcbiAgfVxufVxuXG5leHBvcnQgZnVuY3Rpb24gaGFuZGxlU2V0dGluZ1Byb3BEZWZhdWx0cyhwcm9wczogRGF0YWRvZ1Byb3BzKTogRGF0YWRvZ1N0cmljdFByb3BzIHtcbiAgbGV0IGFkZExheWVycyA9IHByb3BzLmFkZExheWVycztcbiAgbGV0IGVuYWJsZURhdGFkb2dUcmFjaW5nID0gcHJvcHMuZW5hYmxlRGF0YWRvZ1RyYWNpbmc7XG4gIGxldCBpbmplY3RMb2dDb250ZXh0ID0gcHJvcHMuaW5qZWN0TG9nQ29udGV4dDtcbiAgY29uc3QgbG9nTGV2ZWwgPSBwcm9wcy5sb2dMZXZlbDtcbiAgbGV0IGVuYWJsZURhdGFkb2dMb2dzID0gcHJvcHMuZW5hYmxlRGF0YWRvZ0xvZ3M7XG4gIGxldCBjYXB0dXJlTGFtYmRhUGF5bG9hZCA9IHByb3BzLmNhcHR1cmVMYW1iZGFQYXlsb2FkO1xuXG4gIGlmIChhZGRMYXllcnMgPT09IHVuZGVmaW5lZCkge1xuICAgIGxvZy5kZWJ1ZyhgTm8gdmFsdWUgcHJvdmlkZWQgZm9yIGFkZExheWVycywgZGVmYXVsdGluZyB0byAke0RlZmF1bHREYXRhZG9nUHJvcHMuYWRkTGF5ZXJzfWApO1xuICAgIGFkZExheWVycyA9IERlZmF1bHREYXRhZG9nUHJvcHMuYWRkTGF5ZXJzO1xuICB9XG4gIGlmIChlbmFibGVEYXRhZG9nVHJhY2luZyA9PT0gdW5kZWZpbmVkKSB7XG4gICAgbG9nLmRlYnVnKGBObyB2YWx1ZSBwcm92aWRlZCBmb3IgZW5hYmxlRGF0YWRvZ1RyYWNpbmcsIGRlZmF1bHRpbmcgdG8gJHtEZWZhdWx0RGF0YWRvZ1Byb3BzLmVuYWJsZURhdGFkb2dUcmFjaW5nfWApO1xuICAgIGVuYWJsZURhdGFkb2dUcmFjaW5nID0gRGVmYXVsdERhdGFkb2dQcm9wcy5lbmFibGVEYXRhZG9nVHJhY2luZztcbiAgfVxuICBpZiAoaW5qZWN0TG9nQ29udGV4dCA9PT0gdW5kZWZpbmVkKSB7XG4gICAgbG9nLmRlYnVnKGBObyB2YWx1ZSBwcm92aWRlZCBmb3IgaW5qZWN0TG9nQ29udGV4dCwgZGVmYXVsdGluZyB0byAke0RlZmF1bHREYXRhZG9nUHJvcHMuaW5qZWN0TG9nQ29udGV4dH1gKTtcbiAgICBpbmplY3RMb2dDb250ZXh0ID0gRGVmYXVsdERhdGFkb2dQcm9wcy5pbmplY3RMb2dDb250ZXh0O1xuICB9XG4gIGlmIChsb2dMZXZlbCA9PT0gdW5kZWZpbmVkKSB7XG4gICAgbG9nLmRlYnVnKGBObyB2YWx1ZSBwcm92aWRlZCBmb3IgbG9nTGV2ZWxgKTtcbiAgfVxuICBpZiAoZW5hYmxlRGF0YWRvZ0xvZ3MgPT09IHVuZGVmaW5lZCkge1xuICAgIGxvZy5kZWJ1ZyhgTm8gdmFsdWUgcHJvdmlkZWQgZm9yIGVuYWJsZURhdGFkb2dMb2dzLCBkZWZhdWx0aW5nIHRvICR7RGVmYXVsdERhdGFkb2dQcm9wcy5lbmFibGVEYXRhZG9nTG9nc31gKTtcbiAgICBlbmFibGVEYXRhZG9nTG9ncyA9IERlZmF1bHREYXRhZG9nUHJvcHMuZW5hYmxlRGF0YWRvZ0xvZ3M7XG4gIH1cbiAgaWYgKGNhcHR1cmVMYW1iZGFQYXlsb2FkID09PSB1bmRlZmluZWQpIHtcbiAgICBsb2cuZGVidWcoYE5vIHZhbHVlIHByb3ZpZGVkIGZvciBjYXB0dXJlTGFtYmRhUGF5bG9hZCwgZGVmYXVsdCB0byAke0RlZmF1bHREYXRhZG9nUHJvcHMuY2FwdHVyZUxhbWJkYVBheWxvYWR9YCk7XG4gICAgY2FwdHVyZUxhbWJkYVBheWxvYWQgPSBEZWZhdWx0RGF0YWRvZ1Byb3BzLmNhcHR1cmVMYW1iZGFQYXlsb2FkO1xuICB9XG5cbiAgcmV0dXJuIHtcbiAgICBhZGRMYXllcnM6IGFkZExheWVycyxcbiAgICBlbmFibGVEYXRhZG9nVHJhY2luZzogZW5hYmxlRGF0YWRvZ1RyYWNpbmcsXG4gICAgaW5qZWN0TG9nQ29udGV4dDogaW5qZWN0TG9nQ29udGV4dCxcbiAgICBsb2dMZXZlbDogbG9nTGV2ZWwsXG4gICAgZW5hYmxlRGF0YWRvZ0xvZ3M6IGVuYWJsZURhdGFkb2dMb2dzLFxuICAgIGNhcHR1cmVMYW1iZGFQYXlsb2FkOiBjYXB0dXJlTGFtYmRhUGF5bG9hZCxcbiAgfTtcbn1cbiJdfQ==