# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetTaskTemplateResult',
    'AwaitableGetTaskTemplateResult',
    'get_task_template',
    'get_task_template_output',
]

@pulumi.output_type
class GetTaskTemplateResult:
    def __init__(__self__, arn=None, client_token=None, constraints=None, contact_flow_arn=None, defaults=None, description=None, fields=None, instance_arn=None, name=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if client_token and not isinstance(client_token, str):
            raise TypeError("Expected argument 'client_token' to be a str")
        pulumi.set(__self__, "client_token", client_token)
        if constraints and not isinstance(constraints, dict):
            raise TypeError("Expected argument 'constraints' to be a dict")
        pulumi.set(__self__, "constraints", constraints)
        if contact_flow_arn and not isinstance(contact_flow_arn, str):
            raise TypeError("Expected argument 'contact_flow_arn' to be a str")
        pulumi.set(__self__, "contact_flow_arn", contact_flow_arn)
        if defaults and not isinstance(defaults, list):
            raise TypeError("Expected argument 'defaults' to be a list")
        pulumi.set(__self__, "defaults", defaults)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if instance_arn and not isinstance(instance_arn, str):
            raise TypeError("Expected argument 'instance_arn' to be a str")
        pulumi.set(__self__, "instance_arn", instance_arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The identifier (arn) of the task template.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[str]:
        return pulumi.get(self, "client_token")

    @property
    @pulumi.getter
    def constraints(self) -> Optional['outputs.ConstraintsProperties']:
        """
        The constraints for the task template
        """
        return pulumi.get(self, "constraints")

    @property
    @pulumi.getter(name="contactFlowArn")
    def contact_flow_arn(self) -> Optional[str]:
        """
        The identifier of the contact flow.
        """
        return pulumi.get(self, "contact_flow_arn")

    @property
    @pulumi.getter
    def defaults(self) -> Optional[Sequence['outputs.TaskTemplateDefaultFieldValue']]:
        return pulumi.get(self, "defaults")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the task template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence['outputs.TaskTemplateField']]:
        """
        The list of task template's fields
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> Optional[str]:
        """
        The identifier (arn) of the instance.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the task template.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional['TaskTemplateStatus']:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.TaskTemplateTag']]:
        """
        One or more tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetTaskTemplateResult(GetTaskTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTaskTemplateResult(
            arn=self.arn,
            client_token=self.client_token,
            constraints=self.constraints,
            contact_flow_arn=self.contact_flow_arn,
            defaults=self.defaults,
            description=self.description,
            fields=self.fields,
            instance_arn=self.instance_arn,
            name=self.name,
            status=self.status,
            tags=self.tags)


def get_task_template(arn: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTaskTemplateResult:
    """
    Resource Type definition for AWS::Connect::TaskTemplate.


    :param str arn: The identifier (arn) of the task template.
    """
    __args__ = dict()
    __args__['arn'] = arn
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:connect:getTaskTemplate', __args__, opts=opts, typ=GetTaskTemplateResult).value

    return AwaitableGetTaskTemplateResult(
        arn=__ret__.arn,
        client_token=__ret__.client_token,
        constraints=__ret__.constraints,
        contact_flow_arn=__ret__.contact_flow_arn,
        defaults=__ret__.defaults,
        description=__ret__.description,
        fields=__ret__.fields,
        instance_arn=__ret__.instance_arn,
        name=__ret__.name,
        status=__ret__.status,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_task_template)
def get_task_template_output(arn: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTaskTemplateResult]:
    """
    Resource Type definition for AWS::Connect::TaskTemplate.


    :param str arn: The identifier (arn) of the task template.
    """
    ...
