"""
    wallet-api

    API  # noqa: E501

    The version of the OpenAPI document: 2.1.524
    Contact: development@wallet.inc
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from wallet.api_client import ApiClient, Endpoint as _Endpoint
from wallet.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from wallet.model.auth_error import AuthError
from wallet.model.create_static_voucher_campaign import CreateStaticVoucherCampaign
from wallet.model.create_static_voucher_campaign_with_voucher import CreateStaticVoucherCampaignWithVoucher
from wallet.model.create_static_voucher_campaign_with_voucher_with_csv import CreateStaticVoucherCampaignWithVoucherWithCSV
from wallet.model.falsum_error import FalsumError
from wallet.model.inline_response2002 import InlineResponse2002
from wallet.model.inline_response2004 import InlineResponse2004
from wallet.model.internal_server_error import InternalServerError
from wallet.model.reach_performance_stats import ReachPerformanceStats
from wallet.model.static_voucher_campaign_update import StaticVoucherCampaignUpdate
from wallet.model.update_static_voucher_campaign_with_voucher import UpdateStaticVoucherCampaignWithVoucher
from wallet.model.vs_campaign_generated_message import VSCampaignGeneratedMessage
from wallet.model.vs_campaign_generated_message_pagination import VSCampaignGeneratedMessagePagination
from wallet.model.wt_static_voucher import WTStaticVoucher
from wallet.model.wt_static_voucher_campaign import WTStaticVoucherCampaign
from wallet.model.wt_static_voucher_campaign_preview_messages import WTStaticVoucherCampaignPreviewMessages
from wallet.model.wt_static_voucher_campaign_preview_messages_by_page import WTStaticVoucherCampaignPreviewMessagesByPage
from wallet.model.wt_wallet_page_view import WTWalletPageView


class StaticVoucherCampaignsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.count_vouchers_loaded_endpoint = _Endpoint(
            settings={
                'response_type': (InlineResponse2002,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/count/vouchers/loaded/{campaignID}',
                'operation_id': 'count_vouchers_loaded',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                },
                'location_map': {
                    'campaign_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.count_vouchers_redeemed_endpoint = _Endpoint(
            settings={
                'response_type': (InlineResponse2002,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/count/vouchers/redeemed/{campaignID}',
                'operation_id': 'count_vouchers_redeemed',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                },
                'location_map': {
                    'campaign_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_static_voucher_campaign_endpoint = _Endpoint(
            settings={
                'response_type': (WTStaticVoucherCampaign,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign',
                'operation_id': 'create_static_voucher_campaign',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_static_voucher_campaign',
                ],
                'required': [
                    'create_static_voucher_campaign',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_static_voucher_campaign':
                        (CreateStaticVoucherCampaign,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_static_voucher_campaign': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_static_voucher_campaign_from_csv_endpoint = _Endpoint(
            settings={
                'response_type': (WTStaticVoucherCampaign,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/csv',
                'operation_id': 'create_static_voucher_campaign_from_csv',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_static_voucher_campaign_with_voucher_with_csv',
                ],
                'required': [
                    'create_static_voucher_campaign_with_voucher_with_csv',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_static_voucher_campaign_with_voucher_with_csv':
                        (CreateStaticVoucherCampaignWithVoucherWithCSV,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_static_voucher_campaign_with_voucher_with_csv': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_static_voucher_campaign_with_voucher_endpoint = _Endpoint(
            settings={
                'response_type': (WTStaticVoucherCampaign,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/voucher',
                'operation_id': 'create_static_voucher_campaign_with_voucher',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_static_voucher_campaign_with_voucher',
                ],
                'required': [
                    'create_static_voucher_campaign_with_voucher',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_static_voucher_campaign_with_voucher':
                        (CreateStaticVoucherCampaignWithVoucher,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_static_voucher_campaign_with_voucher': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.duplicate_static_voucher_campaign_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (WTStaticVoucherCampaign,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/duplicate/{campaignID}',
                'operation_id': 'duplicate_static_voucher_campaign_by_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                },
                'location_map': {
                    'campaign_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_performance_overview_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/overview/performance/{campaignID}',
                'operation_id': 'fetch_performance_overview',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                },
                'location_map': {
                    'campaign_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_reach_stats_of_all_static_voucher_campaigns_endpoint = _Endpoint(
            settings={
                'response_type': (ReachPerformanceStats,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/reach/all',
                'operation_id': 'fetch_reach_stats_of_all_static_voucher_campaigns',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'broadcast_scheduled_start_at',
                    'broadcast_scheduled_end_at',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'broadcast_scheduled_start_at':
                        (datetime,),
                    'broadcast_scheduled_end_at':
                        (datetime,),
                },
                'attribute_map': {
                    'broadcast_scheduled_start_at': 'broadcastScheduledStartAt',
                    'broadcast_scheduled_end_at': 'broadcastScheduledEndAt',
                },
                'location_map': {
                    'broadcast_scheduled_start_at': 'query',
                    'broadcast_scheduled_end_at': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_reach_stats_of_individual_static_voucher_campaign_endpoint = _Endpoint(
            settings={
                'response_type': (ReachPerformanceStats,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/reach/{staticVoucherCampaignID}',
                'operation_id': 'fetch_reach_stats_of_individual_static_voucher_campaign',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'static_voucher_campaign_id',
                    'broadcast_scheduled_start_at',
                    'broadcast_scheduled_end_at',
                ],
                'required': [
                    'static_voucher_campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'static_voucher_campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'broadcast_scheduled_start_at':
                        (datetime,),
                    'broadcast_scheduled_end_at':
                        (datetime,),
                },
                'attribute_map': {
                    'static_voucher_campaign_id': 'staticVoucherCampaignID',
                    'broadcast_scheduled_start_at': 'broadcastScheduledStartAt',
                    'broadcast_scheduled_end_at': 'broadcastScheduledEndAt',
                },
                'location_map': {
                    'static_voucher_campaign_id': 'path',
                    'broadcast_scheduled_start_at': 'query',
                    'broadcast_scheduled_end_at': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_static_voucher_campaign_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (WTStaticVoucherCampaign,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/{id}',
                'operation_id': 'fetch_static_voucher_campaign_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_static_voucher_campaigns_endpoint = _Endpoint(
            settings={
                'response_type': ([WTStaticVoucherCampaign],),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/all',
                'operation_id': 'fetch_static_voucher_campaigns',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'is_archive_included',
                    'source_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'is_archive_included':
                        (bool,),
                    'source_id':
                        (float,),
                },
                'attribute_map': {
                    'is_archive_included': 'isArchiveIncluded',
                    'source_id': 'sourceID',
                },
                'location_map': {
                    'is_archive_included': 'query',
                    'source_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_static_vouchers_endpoint = _Endpoint(
            settings={
                'response_type': ([WTStaticVoucher],),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/staticVouchers/{campaignID}',
                'operation_id': 'fetch_static_vouchers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                },
                'location_map': {
                    'campaign_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_static_vouchers_page_endpoint = _Endpoint(
            settings={
                'response_type': (InlineResponse2004,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/staticVouchers/page/{campaignID}',
                'operation_id': 'fetch_static_vouchers_page',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'pagenum',
                    'pagesize',
                ],
                'required': [
                    'campaign_id',
                    'pagenum',
                    'pagesize',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'pagenum':
                        (float,),
                    'pagesize':
                        (float,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                    'pagenum': 'pagenum',
                    'pagesize': 'pagesize',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'pagenum': 'query',
                    'pagesize': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_views_endpoint = _Endpoint(
            settings={
                'response_type': ([WTWalletPageView],),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/views/{campaignID}',
                'operation_id': 'fetch_views',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                },
                'location_map': {
                    'campaign_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_vouchers_redeemed_endpoint = _Endpoint(
            settings={
                'response_type': ([WTStaticVoucher],),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/vouchers/redeemed/{campaignID}',
                'operation_id': 'fetch_vouchers_redeemed',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                },
                'location_map': {
                    'campaign_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.preview_messages_endpoint = _Endpoint(
            settings={
                'response_type': ([VSCampaignGeneratedMessage],),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/preview/{campaignID}',
                'operation_id': 'preview_messages',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'wt_static_voucher_campaign_preview_messages',
                ],
                'required': [
                    'campaign_id',
                    'wt_static_voucher_campaign_preview_messages',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'wt_static_voucher_campaign_preview_messages':
                        (WTStaticVoucherCampaignPreviewMessages,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'wt_static_voucher_campaign_preview_messages': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.preview_messages_by_page_endpoint = _Endpoint(
            settings={
                'response_type': (VSCampaignGeneratedMessagePagination,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/preview/page/{campaignID}',
                'operation_id': 'preview_messages_by_page',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'wt_static_voucher_campaign_preview_messages_by_page',
                ],
                'required': [
                    'campaign_id',
                    'wt_static_voucher_campaign_preview_messages_by_page',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'wt_static_voucher_campaign_preview_messages_by_page':
                        (WTStaticVoucherCampaignPreviewMessagesByPage,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'wt_static_voucher_campaign_preview_messages_by_page': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_static_voucher_campaign_endpoint = _Endpoint(
            settings={
                'response_type': (WTStaticVoucherCampaign,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/{campaignID}',
                'operation_id': 'update_static_voucher_campaign',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'static_voucher_campaign_update',
                ],
                'required': [
                    'campaign_id',
                    'static_voucher_campaign_update',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'static_voucher_campaign_update':
                        (StaticVoucherCampaignUpdate,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'static_voucher_campaign_update': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_static_voucher_campaign_with_voucher_endpoint = _Endpoint(
            settings={
                'response_type': (WTStaticVoucherCampaign,),
                'auth': [],
                'endpoint_path': '/v2/payment/staticVoucherCampaign/voucher/{campaignID}',
                'operation_id': 'update_static_voucher_campaign_with_voucher',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'update_static_voucher_campaign_with_voucher',
                ],
                'required': [
                    'campaign_id',
                    'update_static_voucher_campaign_with_voucher',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                    'update_static_voucher_campaign_with_voucher':
                        (UpdateStaticVoucherCampaignWithVoucher,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'update_static_voucher_campaign_with_voucher': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def count_vouchers_loaded(
        self,
        campaign_id,
        **kwargs
    ):
        """Count loaded vouchers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_vouchers_loaded(campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InlineResponse2002
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        return self.count_vouchers_loaded_endpoint.call_with_http_info(**kwargs)

    def count_vouchers_redeemed(
        self,
        campaign_id,
        **kwargs
    ):
        """Count redeemed vouchers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_vouchers_redeemed(campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InlineResponse2002
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        return self.count_vouchers_redeemed_endpoint.call_with_http_info(**kwargs)

    def create_static_voucher_campaign(
        self,
        create_static_voucher_campaign,
        **kwargs
    ):
        """Create static voucher campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_static_voucher_campaign(create_static_voucher_campaign, async_req=True)
        >>> result = thread.get()

        Args:
            create_static_voucher_campaign (CreateStaticVoucherCampaign):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTStaticVoucherCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['create_static_voucher_campaign'] = \
            create_static_voucher_campaign
        return self.create_static_voucher_campaign_endpoint.call_with_http_info(**kwargs)

    def create_static_voucher_campaign_from_csv(
        self,
        create_static_voucher_campaign_with_voucher_with_csv,
        **kwargs
    ):
        """Import static voucher campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_static_voucher_campaign_from_csv(create_static_voucher_campaign_with_voucher_with_csv, async_req=True)
        >>> result = thread.get()

        Args:
            create_static_voucher_campaign_with_voucher_with_csv (CreateStaticVoucherCampaignWithVoucherWithCSV):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTStaticVoucherCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['create_static_voucher_campaign_with_voucher_with_csv'] = \
            create_static_voucher_campaign_with_voucher_with_csv
        return self.create_static_voucher_campaign_from_csv_endpoint.call_with_http_info(**kwargs)

    def create_static_voucher_campaign_with_voucher(
        self,
        create_static_voucher_campaign_with_voucher,
        **kwargs
    ):
        """Create static voucher campaign with voucher  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_static_voucher_campaign_with_voucher(create_static_voucher_campaign_with_voucher, async_req=True)
        >>> result = thread.get()

        Args:
            create_static_voucher_campaign_with_voucher (CreateStaticVoucherCampaignWithVoucher):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTStaticVoucherCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['create_static_voucher_campaign_with_voucher'] = \
            create_static_voucher_campaign_with_voucher
        return self.create_static_voucher_campaign_with_voucher_endpoint.call_with_http_info(**kwargs)

    def duplicate_static_voucher_campaign_by_id(
        self,
        campaign_id,
        **kwargs
    ):
        """Duplicate static voucher campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.duplicate_static_voucher_campaign_by_id(campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTStaticVoucherCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        return self.duplicate_static_voucher_campaign_by_id_endpoint.call_with_http_info(**kwargs)

    def fetch_performance_overview(
        self,
        campaign_id,
        **kwargs
    ):
        """Fetch performance overview  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_performance_overview(campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        return self.fetch_performance_overview_endpoint.call_with_http_info(**kwargs)

    def fetch_reach_stats_of_all_static_voucher_campaigns(
        self,
        **kwargs
    ):
        """Get the reach statistics of all the static voucher campaigns  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_reach_stats_of_all_static_voucher_campaigns(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            broadcast_scheduled_start_at (datetime): [optional]
            broadcast_scheduled_end_at (datetime): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ReachPerformanceStats
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.fetch_reach_stats_of_all_static_voucher_campaigns_endpoint.call_with_http_info(**kwargs)

    def fetch_reach_stats_of_individual_static_voucher_campaign(
        self,
        static_voucher_campaign_id,
        **kwargs
    ):
        """Get the reach statistics of an individual static voucher campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_reach_stats_of_individual_static_voucher_campaign(static_voucher_campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            static_voucher_campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):

        Keyword Args:
            broadcast_scheduled_start_at (datetime): [optional]
            broadcast_scheduled_end_at (datetime): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ReachPerformanceStats
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['static_voucher_campaign_id'] = \
            static_voucher_campaign_id
        return self.fetch_reach_stats_of_individual_static_voucher_campaign_endpoint.call_with_http_info(**kwargs)

    def fetch_static_voucher_campaign_by_id(
        self,
        id,
        **kwargs
    ):
        """Fetch static voucher campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_static_voucher_campaign_by_id(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (bool, date, datetime, dict, float, int, list, str, none_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTStaticVoucherCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.fetch_static_voucher_campaign_by_id_endpoint.call_with_http_info(**kwargs)

    def fetch_static_voucher_campaigns(
        self,
        **kwargs
    ):
        """Fetches all static vouchers campaigns  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_static_voucher_campaigns(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            is_archive_included (bool): [optional]
            source_id (float): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [WTStaticVoucherCampaign]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.fetch_static_voucher_campaigns_endpoint.call_with_http_info(**kwargs)

    def fetch_static_vouchers(
        self,
        campaign_id,
        **kwargs
    ):
        """Fetch static vouchers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_static_vouchers(campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [WTStaticVoucher]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        return self.fetch_static_vouchers_endpoint.call_with_http_info(**kwargs)

    def fetch_static_vouchers_page(
        self,
        campaign_id,
        pagenum,
        pagesize,
        **kwargs
    ):
        """Fetch static vouchers by page  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_static_vouchers_page(campaign_id, pagenum, pagesize, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):
            pagenum (float):
            pagesize (float):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InlineResponse2004
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        kwargs['pagenum'] = \
            pagenum
        kwargs['pagesize'] = \
            pagesize
        return self.fetch_static_vouchers_page_endpoint.call_with_http_info(**kwargs)

    def fetch_views(
        self,
        campaign_id,
        **kwargs
    ):
        """Fetch views  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_views(campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [WTWalletPageView]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        return self.fetch_views_endpoint.call_with_http_info(**kwargs)

    def fetch_vouchers_redeemed(
        self,
        campaign_id,
        **kwargs
    ):
        """Fetch redeemed vouchers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_vouchers_redeemed(campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [WTStaticVoucher]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        return self.fetch_vouchers_redeemed_endpoint.call_with_http_info(**kwargs)

    def preview_messages(
        self,
        campaign_id,
        wt_static_voucher_campaign_preview_messages,
        **kwargs
    ):
        """Preview static vouchers. This method has been deprecated. Please use /preview/page/{campaignID} for better performance.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.preview_messages(campaign_id, wt_static_voucher_campaign_preview_messages, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):
            wt_static_voucher_campaign_preview_messages (WTStaticVoucherCampaignPreviewMessages):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [VSCampaignGeneratedMessage]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        kwargs['wt_static_voucher_campaign_preview_messages'] = \
            wt_static_voucher_campaign_preview_messages
        return self.preview_messages_endpoint.call_with_http_info(**kwargs)

    def preview_messages_by_page(
        self,
        campaign_id,
        wt_static_voucher_campaign_preview_messages_by_page,
        **kwargs
    ):
        """Preview static vouchers by page  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.preview_messages_by_page(campaign_id, wt_static_voucher_campaign_preview_messages_by_page, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):
            wt_static_voucher_campaign_preview_messages_by_page (WTStaticVoucherCampaignPreviewMessagesByPage):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            VSCampaignGeneratedMessagePagination
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        kwargs['wt_static_voucher_campaign_preview_messages_by_page'] = \
            wt_static_voucher_campaign_preview_messages_by_page
        return self.preview_messages_by_page_endpoint.call_with_http_info(**kwargs)

    def update_static_voucher_campaign(
        self,
        campaign_id,
        static_voucher_campaign_update,
        **kwargs
    ):
        """Update static voucher campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_static_voucher_campaign(campaign_id, static_voucher_campaign_update, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):
            static_voucher_campaign_update (StaticVoucherCampaignUpdate):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTStaticVoucherCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        kwargs['static_voucher_campaign_update'] = \
            static_voucher_campaign_update
        return self.update_static_voucher_campaign_endpoint.call_with_http_info(**kwargs)

    def update_static_voucher_campaign_with_voucher(
        self,
        campaign_id,
        update_static_voucher_campaign_with_voucher,
        **kwargs
    ):
        """Update static voucher campaign with voucher  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_static_voucher_campaign_with_voucher(campaign_id, update_static_voucher_campaign_with_voucher, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):
            update_static_voucher_campaign_with_voucher (UpdateStaticVoucherCampaignWithVoucher):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WTStaticVoucherCampaign
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        kwargs['update_static_voucher_campaign_with_voucher'] = \
            update_static_voucher_campaign_with_voucher
        return self.update_static_voucher_campaign_with_voucher_endpoint.call_with_http_info(**kwargs)

