"""
    wallet-api

    API  # noqa: E501

    The version of the OpenAPI document: 2.1.524
    Contact: development@wallet.inc
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from wallet.api_client import ApiClient, Endpoint as _Endpoint
from wallet.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from wallet.model.auth_error import AuthError
from wallet.model.falsum_error import FalsumError
from wallet.model.internal_server_error import InternalServerError
from wallet.model.ms_analytics_member_count_partitioned_by_date import MSAnalyticsMemberCountPartitionedByDate
from wallet.model.ms_analytics_member_points_redeemed_partitioned_by_date import MSAnalyticsMemberPointsRedeemedPartitionedByDate
from wallet.model.ms_analytics_member_points_refunded_partitioned_by_date import MSAnalyticsMemberPointsRefundedPartitionedByDate
from wallet.model.ms_analytics_membership_tier_amount_redeemed_partitioned_by_date import MSAnalyticsMembershipTierAmountRedeemedPartitionedByDate
from wallet.model.ms_analytics_membership_tier_amount_refunded_partitioned_by_date import MSAnalyticsMembershipTierAmountRefundedPartitionedByDate
from wallet.model.wt_wallet_object_prefix_counts import WTWalletObjectPrefixCounts
from wallet.model.wt_wallet_page_view import WTWalletPageView
from wallet.model.wallet_page_view import WalletPageView


class AnalyticsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.count_verified_wallet_page_views_endpoint = _Endpoint(
            settings={
                'response_type': ([WTWalletObjectPrefixCounts],),
                'auth': [],
                'endpoint_path': '/v2/analytics/walletPageViews/sessions/verified/distinct/walletObjectsCount',
                'operation_id': 'count_verified_wallet_page_views',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.count_wallet_page_views_endpoint = _Endpoint(
            settings={
                'response_type': ([WTWalletObjectPrefixCounts],),
                'auth': [],
                'endpoint_path': '/v2/analytics/walletPageViews/sessions/distinct/walletObjectsCount',
                'operation_id': 'count_wallet_page_views',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_count_partitioned_by_employee_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/count/employee',
                'operation_id': 'fetch_analytics_ad_credits_count_partitioned_by_employee',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_count_partitioned_by_payment_design_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/count/paymentDesign',
                'operation_id': 'fetch_analytics_ad_credits_count_partitioned_by_payment_design',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_count_partitioned_by_value_type_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/count/valueType',
                'operation_id': 'fetch_analytics_ad_credits_count_partitioned_by_value_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_redemptions_amount_partitioned_by_ad_credit_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/redemptions/amount/adCredit',
                'operation_id': 'fetch_analytics_ad_credits_redemptions_amount_partitioned_by_ad_credit_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_redemptions_amount_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/redemptions/amount/date',
                'operation_id': 'fetch_analytics_ad_credits_redemptions_amount_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_redemptions_count_partitioned_by_ad_credit_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/redemptions/count/adCredit',
                'operation_id': 'fetch_analytics_ad_credits_redemptions_count_partitioned_by_ad_credit_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_redemptions_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/redemptions/count/date',
                'operation_id': 'fetch_analytics_ad_credits_redemptions_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_refunds_amount_partitioned_by_ad_credit_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/refunds/amount/adCredit',
                'operation_id': 'fetch_analytics_ad_credits_refunds_amount_partitioned_by_ad_credit_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_refunds_amount_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/refunds/amount/date',
                'operation_id': 'fetch_analytics_ad_credits_refunds_amount_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_refunds_count_partitioned_by_ad_credit_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/refunds/count/adCredit',
                'operation_id': 'fetch_analytics_ad_credits_refunds_count_partitioned_by_ad_credit_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_refunds_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/refunds/count/date',
                'operation_id': 'fetch_analytics_ad_credits_refunds_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_scans_count_partitioned_by_ad_credit_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/scans/count/adCredit',
                'operation_id': 'fetch_analytics_ad_credits_scans_count_partitioned_by_ad_credit_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_ad_credits_scans_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/advertisementCredits/scans/count/date',
                'operation_id': 'fetch_analytics_ad_credits_scans_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaign_wallet_page_views_endpoint = _Endpoint(
            settings={
                'response_type': ([WTWalletPageView],),
                'auth': [],
                'endpoint_path': '/v2/analytics/walletPageViews/campaign/{campaignID}',
                'operation_id': 'fetch_analytics_campaign_wallet_page_views',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignID',
                },
                'location_map': {
                    'campaign_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaigns_count_partitioned_by_campaign_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/count/campaign/created',
                'operation_id': 'fetch_analytics_campaigns_count_partitioned_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaigns_count_partitioned_by_employee_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/count/employee',
                'operation_id': 'fetch_analytics_campaigns_count_partitioned_by_employee',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaigns_count_partitioned_by_payment_design_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/count/paymentDesign',
                'operation_id': 'fetch_analytics_campaigns_count_partitioned_by_payment_design',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaigns_count_partitioned_by_value_type_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/count/valueType',
                'operation_id': 'fetch_analytics_campaigns_count_partitioned_by_value_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaigns_redemptions_amount_partitioned_by_campaign_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/redemptions/amount/campaign',
                'operation_id': 'fetch_analytics_campaigns_redemptions_amount_partitioned_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaigns_redemptions_amount_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/redemptions/amount/date',
                'operation_id': 'fetch_analytics_campaigns_redemptions_amount_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaigns_redemptions_count_partitioned_by_campaign_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/redemptions/count/campaign',
                'operation_id': 'fetch_analytics_campaigns_redemptions_count_partitioned_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaigns_redemptions_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/redemptions/count/date',
                'operation_id': 'fetch_analytics_campaigns_redemptions_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaigns_refunds_amount_partitioned_by_campaign_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/refunds/amount/campaign',
                'operation_id': 'fetch_analytics_campaigns_refunds_amount_partitioned_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaigns_refunds_amount_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/refunds/amount/date',
                'operation_id': 'fetch_analytics_campaigns_refunds_amount_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaigns_refunds_count_partitioned_by_campaign_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/refunds/count/campaign',
                'operation_id': 'fetch_analytics_campaigns_refunds_count_partitioned_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_campaigns_refunds_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/refunds/count/date',
                'operation_id': 'fetch_analytics_campaigns_refunds_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_delivered_outbound_messages_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/outboundSMS/count/date/delivered',
                'operation_id': 'fetch_analytics_delivered_outbound_messages_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_delivered_outbound_messages_count_partitioned_by_phone_number_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/outboundSMS/count/phoneNumber/delivered',
                'operation_id': 'fetch_analytics_delivered_outbound_messages_count_partitioned_by_phone_number',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_distinct_wallet_sessions_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/walletPageViews/sessions/distinct',
                'operation_id': 'fetch_analytics_distinct_wallet_sessions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_dynamic_vouchers_count_partitioned_by_employee_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/dynamicVouchers/count/employee',
                'operation_id': 'fetch_analytics_dynamic_vouchers_count_partitioned_by_employee',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_dynamic_vouchers_count_partitioned_by_payment_design_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/dynamicVouchers/count/paymentDesign',
                'operation_id': 'fetch_analytics_dynamic_vouchers_count_partitioned_by_payment_design',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/dynamicVouchers/redemptions/amount/date',
                'operation_id': 'fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_dynamic_voucher_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/dynamicVouchers/redemptions/amount/dynamicVoucher',
                'operation_id': 'fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_dynamic_voucher_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/dynamicVouchers/redemptions/count/date',
                'operation_id': 'fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_dynamic_voucher_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/dynamicVouchers/redemptions/count/dynamicVoucher',
                'operation_id': 'fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_dynamic_voucher_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/dynamicVouchers/refunds/amount/date',
                'operation_id': 'fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_dynamic_voucher_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/dynamicVouchers/refunds/amount/dynamicVoucher',
                'operation_id': 'fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_dynamic_voucher_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/dynamicVouchers/refunds/count/date',
                'operation_id': 'fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_dynamic_voucher_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/dynamicVouchers/refunds/count/dynamicVoucher',
                'operation_id': 'fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_dynamic_voucher_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_help_desk_requests_created_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/helpdeskrequests/count/date/created',
                'operation_id': 'fetch_analytics_help_desk_requests_created_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_help_desk_requests_resolved_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/helpdeskrequests/count/date/resolved',
                'operation_id': 'fetch_analytics_help_desk_requests_resolved_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_help_desk_requests_resolved_count_partitioned_by_employee_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/helpdeskrequests/count/employee/resolved',
                'operation_id': 'fetch_analytics_help_desk_requests_resolved_count_partitioned_by_employee',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_help_desk_requests_unresolved_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/helpdeskrequests/count/date/unresolved',
                'operation_id': 'fetch_analytics_help_desk_requests_unresolved_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_item_wallet_page_views_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/walletPageViews/item/{itemID}',
                'operation_id': 'fetch_analytics_item_wallet_page_views',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'item_id',
                ],
                'required': [
                    'item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'item_id':
                        (str,),
                },
                'attribute_map': {
                    'item_id': 'itemID',
                },
                'location_map': {
                    'item_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_member_count_endpoint = _Endpoint(
            settings={
                'response_type': ([MSAnalyticsMemberCountPartitionedByDate],),
                'auth': [],
                'endpoint_path': '/v2/analytics/membership/member/count',
                'operation_id': 'fetch_analytics_member_count',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_merchant_credit_count_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/membership/merchantCredit/count',
                'operation_id': 'fetch_analytics_merchant_credit_count',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_offer_vs_redeemed_amount_partitioned_by_campaign_id_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/campaigns/amount/campaign/offerVsRedeemed',
                'operation_id': 'fetch_analytics_offer_vs_redeemed_amount_partitioned_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_payment_object_broadcasts_created_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/paymentObjectBroadcasts/count/date/created',
                'operation_id': 'fetch_analytics_payment_object_broadcasts_created_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_payment_object_broadcasts_individual_execution_time_of_completed_broadcasts_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/paymentObjectBroadcasts/executionTime/completed',
                'operation_id': 'fetch_analytics_payment_object_broadcasts_individual_execution_time_of_completed_broadcasts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/paymentObjectBroadcasts/count/date/scheduled',
                'operation_id': 'fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_employee_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/paymentObjectBroadcasts/count/employee/scheduled',
                'operation_id': 'fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_employee',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_phone_number_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/paymentObjectBroadcasts/count/phoneNumber/scheduled',
                'operation_id': 'fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_phone_number',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_payment_object_broadcasts_scheduled_sms_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/paymentObjectBroadcasts/sms/count/date/scheduled',
                'operation_id': 'fetch_analytics_payment_object_broadcasts_scheduled_sms_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_sent_outbound_messages_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/outboundSMS/count/date/sent',
                'operation_id': 'fetch_analytics_sent_outbound_messages_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_sent_outbound_messages_count_partitioned_by_phone_number_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/outboundSMS/count/phoneNumber/sent',
                'operation_id': 'fetch_analytics_sent_outbound_messages_count_partitioned_by_phone_number',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_static_voucher_wallet_page_views_endpoint = _Endpoint(
            settings={
                'response_type': ([WTWalletPageView],),
                'auth': [],
                'endpoint_path': '/v2/analytics/walletPageViews/staticVoucher/{voucherID}',
                'operation_id': 'fetch_analytics_static_voucher_wallet_page_views',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'voucher_id',
                ],
                'required': [
                    'voucher_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'voucher_id':
                        (bool, date, datetime, dict, float, int, list, str, none_type,),
                },
                'attribute_map': {
                    'voucher_id': 'voucherID',
                },
                'location_map': {
                    'voucher_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_tcpa_stop_count_partitioned_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/tcpa/count/date/stop',
                'operation_id': 'fetch_analytics_tcpa_stop_count_partitioned_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_tcpa_stop_count_partitioned_by_phone_number_endpoint = _Endpoint(
            settings={
                'response_type': ([bool, date, datetime, dict, float, int, list, str, none_type],),
                'auth': [],
                'endpoint_path': '/v2/analytics/tcpa/count/phoneNumber/stop',
                'operation_id': 'fetch_analytics_tcpa_stop_count_partitioned_by_phone_number',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_total_amount_redeemed_per_merchant_credit_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/membership/merchantCredit/amount/redeemed',
                'operation_id': 'fetch_analytics_total_amount_redeemed_per_merchant_credit',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_total_amount_redeemed_per_tier_endpoint = _Endpoint(
            settings={
                'response_type': ([MSAnalyticsMembershipTierAmountRedeemedPartitionedByDate],),
                'auth': [],
                'endpoint_path': '/v2/analytics/membership/tier/amount/redeemed',
                'operation_id': 'fetch_analytics_total_amount_redeemed_per_tier',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_total_amount_refunded_per_merchant_credit_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/v2/analytics/membership/merchantCredit/amount/refunded',
                'operation_id': 'fetch_analytics_total_amount_refunded_per_merchant_credit',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_total_amount_refunded_per_tier_endpoint = _Endpoint(
            settings={
                'response_type': ([MSAnalyticsMembershipTierAmountRefundedPartitionedByDate],),
                'auth': [],
                'endpoint_path': '/v2/analytics/membership/tier/amount/refunded',
                'operation_id': 'fetch_analytics_total_amount_refunded_per_tier',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_total_points_redeemed_endpoint = _Endpoint(
            settings={
                'response_type': ([MSAnalyticsMemberPointsRedeemedPartitionedByDate],),
                'auth': [],
                'endpoint_path': '/v2/analytics/membership/member/points/redeemed',
                'operation_id': 'fetch_analytics_total_points_redeemed',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_total_points_refunded_endpoint = _Endpoint(
            settings={
                'response_type': ([MSAnalyticsMemberPointsRefundedPartitionedByDate],),
                'auth': [],
                'endpoint_path': '/v2/analytics/membership/member/points/refunded',
                'operation_id': 'fetch_analytics_total_points_refunded',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'required': [
                    'start_date',
                    'end_date',
                    'locale',
                    'timezone',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'locale':
                        (str,),
                    'timezone':
                        (str,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'locale': 'locale',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'locale': 'query',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_analytics_wallet_session_activity_endpoint = _Endpoint(
            settings={
                'response_type': ([WTWalletPageView],),
                'auth': [],
                'endpoint_path': '/v2/analytics/walletPageViews/session/activity/{sessionID}',
                'operation_id': 'fetch_analytics_wallet_session_activity',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_id',
                ],
                'required': [
                    'session_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_id':
                        (str,),
                },
                'attribute_map': {
                    'session_id': 'sessionID',
                },
                'location_map': {
                    'session_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_wallet_page_view_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (WalletPageView,),
                'auth': [],
                'endpoint_path': '/v2/analytics/walletPageViews/activity/{id}',
                'operation_id': 'fetch_wallet_page_view_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def count_verified_wallet_page_views(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Fetch wallet object counts within a given time frame that have a valid phone verification token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_verified_wallet_page_views(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [WTWalletObjectPrefixCounts]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.count_verified_wallet_page_views_endpoint.call_with_http_info(**kwargs)

    def count_wallet_page_views(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Fetch wallet object counts within a given time frame  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.count_wallet_page_views(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [WTWalletObjectPrefixCounts]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.count_wallet_page_views_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_count_partitioned_by_employee(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count ad credits by employee  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_count_partitioned_by_employee(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_ad_credits_count_partitioned_by_employee_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_count_partitioned_by_payment_design(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count ad credits by payment design  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_count_partitioned_by_payment_design(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_ad_credits_count_partitioned_by_payment_design_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_count_partitioned_by_value_type(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count ad credits by value type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_count_partitioned_by_value_type(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_ad_credits_count_partitioned_by_value_type_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_redemptions_amount_partitioned_by_ad_credit_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Fetch redemption amount of ad credits by Ad Credit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_redemptions_amount_partitioned_by_ad_credit_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_ad_credits_redemptions_amount_partitioned_by_ad_credit_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_redemptions_amount_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Fetch redemption amount of ad credits by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_redemptions_amount_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_ad_credits_redemptions_amount_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_redemptions_count_partitioned_by_ad_credit_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count redemptions of ad credits by Ad Credit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_redemptions_count_partitioned_by_ad_credit_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_ad_credits_redemptions_count_partitioned_by_ad_credit_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_redemptions_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count redemptions of ad credits by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_redemptions_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_ad_credits_redemptions_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_refunds_amount_partitioned_by_ad_credit_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Fetch refund amount of ad credits by Ad Credit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_refunds_amount_partitioned_by_ad_credit_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_ad_credits_refunds_amount_partitioned_by_ad_credit_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_refunds_amount_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Fetch refund amount of ad credits by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_refunds_amount_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_ad_credits_refunds_amount_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_refunds_count_partitioned_by_ad_credit_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count refunds of ad credits by Ad Credit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_refunds_count_partitioned_by_ad_credit_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_ad_credits_refunds_count_partitioned_by_ad_credit_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_refunds_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count refunds of ad credits by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_refunds_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_ad_credits_refunds_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_scans_count_partitioned_by_ad_credit_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count scans of ad credits by Ad Credit  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_scans_count_partitioned_by_ad_credit_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_ad_credits_scans_count_partitioned_by_ad_credit_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_ad_credits_scans_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count scans of ad credits by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_ad_credits_scans_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_ad_credits_scans_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaign_wallet_page_views(
        self,
        campaign_id,
        **kwargs
    ):
        """Fetch a campaign's wallet page views  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaign_wallet_page_views(campaign_id, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_id (bool, date, datetime, dict, float, int, list, str, none_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [WTWalletPageView]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['campaign_id'] = \
            campaign_id
        return self.fetch_analytics_campaign_wallet_page_views_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaigns_count_partitioned_by_campaign_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count created campaigns by campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaigns_count_partitioned_by_campaign_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_campaigns_count_partitioned_by_campaign_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaigns_count_partitioned_by_employee(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count campaigns by employee  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaigns_count_partitioned_by_employee(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_campaigns_count_partitioned_by_employee_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaigns_count_partitioned_by_payment_design(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count campaigns by payment design  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaigns_count_partitioned_by_payment_design(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_campaigns_count_partitioned_by_payment_design_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaigns_count_partitioned_by_value_type(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count campaigns by value type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaigns_count_partitioned_by_value_type(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_campaigns_count_partitioned_by_value_type_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaigns_redemptions_amount_partitioned_by_campaign_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Fetch redemption amount of campaigns by Campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaigns_redemptions_amount_partitioned_by_campaign_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_campaigns_redemptions_amount_partitioned_by_campaign_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaigns_redemptions_amount_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Fetch redemption amount of campaigns by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaigns_redemptions_amount_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_campaigns_redemptions_amount_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaigns_redemptions_count_partitioned_by_campaign_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count redemptions of campaigns by Campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaigns_redemptions_count_partitioned_by_campaign_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_campaigns_redemptions_count_partitioned_by_campaign_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaigns_redemptions_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count redemptions of campaigns by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaigns_redemptions_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_campaigns_redemptions_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaigns_refunds_amount_partitioned_by_campaign_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Fetch refund amount of campaigns by Campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaigns_refunds_amount_partitioned_by_campaign_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_campaigns_refunds_amount_partitioned_by_campaign_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaigns_refunds_amount_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Fetch refund amount of campaigns by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaigns_refunds_amount_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_campaigns_refunds_amount_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaigns_refunds_count_partitioned_by_campaign_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Fetch refund amount of campaigns by Campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaigns_refunds_count_partitioned_by_campaign_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_campaigns_refunds_count_partitioned_by_campaign_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_campaigns_refunds_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Fetch refund amount of campaigns by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_campaigns_refunds_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_campaigns_refunds_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_delivered_outbound_messages_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count delivered outbound messages by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_delivered_outbound_messages_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_delivered_outbound_messages_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_delivered_outbound_messages_count_partitioned_by_phone_number(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count delivered outbound messages by phone number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_delivered_outbound_messages_count_partitioned_by_phone_number(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_delivered_outbound_messages_count_partitioned_by_phone_number_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_distinct_wallet_sessions(
        self,
        **kwargs
    ):
        """Fetch distinct wallet sessions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_distinct_wallet_sessions(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.fetch_analytics_distinct_wallet_sessions_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_dynamic_vouchers_count_partitioned_by_employee(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count dynamic vouchers by employee  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_dynamic_vouchers_count_partitioned_by_employee(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_dynamic_vouchers_count_partitioned_by_employee_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_dynamic_vouchers_count_partitioned_by_payment_design(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count dynamic vouchers by payment design  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_dynamic_vouchers_count_partitioned_by_payment_design(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_dynamic_vouchers_count_partitioned_by_payment_design_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Fetch redemption amount of dynamic vouchers by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_dynamic_voucher_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Fetch redemption amount of dynamic vouchers by dynamic voucher  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_dynamic_voucher_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_dynamic_voucher_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count redemptions of dynamic vouchers by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_dynamic_voucher_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count redemptions of dynamic vouchers by dynamic voucher  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_dynamic_voucher_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_dynamic_voucher_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Fetch refund amount of dynamic vouchers by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_dynamic_voucher_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Fetch refund amount of dynamic vouchers by dynamic voucher  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_dynamic_voucher_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_dynamic_voucher_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count refunds of dynamic vouchers by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_dynamic_voucher_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count refunds of dynamic vouchers by dynamic voucher  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_dynamic_voucher_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_dynamic_voucher_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_help_desk_requests_created_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count help desk requests by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_help_desk_requests_created_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_help_desk_requests_created_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_help_desk_requests_resolved_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count resolved help desk requests by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_help_desk_requests_resolved_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_help_desk_requests_resolved_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_help_desk_requests_resolved_count_partitioned_by_employee(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count resolved help desk requests by employee  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_help_desk_requests_resolved_count_partitioned_by_employee(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_help_desk_requests_resolved_count_partitioned_by_employee_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_help_desk_requests_unresolved_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count unresolved help desk requests by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_help_desk_requests_unresolved_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_help_desk_requests_unresolved_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_item_wallet_page_views(
        self,
        item_id,
        **kwargs
    ):
        """Fetch wallet page views of item  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_item_wallet_page_views(item_id, async_req=True)
        >>> result = thread.get()

        Args:
            item_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['item_id'] = \
            item_id
        return self.fetch_analytics_item_wallet_page_views_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_member_count(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count members  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_member_count(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [MSAnalyticsMemberCountPartitionedByDate]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_member_count_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_merchant_credit_count(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count merchant credits  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_merchant_credit_count(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_merchant_credit_count_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_offer_vs_redeemed_amount_partitioned_by_campaign_id(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Fetch offer vs redeemed amount by campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_offer_vs_redeemed_amount_partitioned_by_campaign_id(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_offer_vs_redeemed_amount_partitioned_by_campaign_id_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_payment_object_broadcasts_created_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count created broadcasts by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_payment_object_broadcasts_created_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_payment_object_broadcasts_created_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_payment_object_broadcasts_individual_execution_time_of_completed_broadcasts(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Fetch execution time of completed broadcasts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_payment_object_broadcasts_individual_execution_time_of_completed_broadcasts(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_payment_object_broadcasts_individual_execution_time_of_completed_broadcasts_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count scheduled broadcasts by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_employee(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count scheduled broadcasts by employee  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_employee(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_employee_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_phone_number(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count scheduled broadcasts by phone number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_phone_number(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_phone_number_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_payment_object_broadcasts_scheduled_sms_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count scheduled SMS broadcasts by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_payment_object_broadcasts_scheduled_sms_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_payment_object_broadcasts_scheduled_sms_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_sent_outbound_messages_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count sent outbound messages by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_sent_outbound_messages_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_sent_outbound_messages_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_sent_outbound_messages_count_partitioned_by_phone_number(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count sent outbound messages by phone number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_sent_outbound_messages_count_partitioned_by_phone_number(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_sent_outbound_messages_count_partitioned_by_phone_number_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_static_voucher_wallet_page_views(
        self,
        voucher_id,
        **kwargs
    ):
        """Fetch a static voucher's wallet page views  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_static_voucher_wallet_page_views(voucher_id, async_req=True)
        >>> result = thread.get()

        Args:
            voucher_id (bool, date, datetime, dict, float, int, list, str, none_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [WTWalletPageView]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['voucher_id'] = \
            voucher_id
        return self.fetch_analytics_static_voucher_wallet_page_views_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_tcpa_stop_count_partitioned_by_date(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count TCPA (STOP) entries by date  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_tcpa_stop_count_partitioned_by_date(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_tcpa_stop_count_partitioned_by_date_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_tcpa_stop_count_partitioned_by_phone_number(
        self,
        start_date,
        end_date,
        **kwargs
    ):
        """Count TCPA (STOP) entries by phone number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_tcpa_stop_count_partitioned_by_phone_number(start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [bool, date, datetime, dict, float, int, list, str, none_type]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.fetch_analytics_tcpa_stop_count_partitioned_by_phone_number_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_total_amount_redeemed_per_merchant_credit(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Fetch redeemed amount of merchant credits  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_total_amount_redeemed_per_merchant_credit(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_total_amount_redeemed_per_merchant_credit_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_total_amount_redeemed_per_tier(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Fetch redeemed amoun̥t of tiers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_total_amount_redeemed_per_tier(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [MSAnalyticsMembershipTierAmountRedeemedPartitionedByDate]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_total_amount_redeemed_per_tier_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_total_amount_refunded_per_merchant_credit(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Fetch refunded amount of merchant credits  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_total_amount_refunded_per_merchant_credit(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_total_amount_refunded_per_merchant_credit_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_total_amount_refunded_per_tier(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Fetch refunded amount of tiers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_total_amount_refunded_per_tier(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [MSAnalyticsMembershipTierAmountRefundedPartitionedByDate]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_total_amount_refunded_per_tier_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_total_points_redeemed(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count redeemed points  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_total_points_redeemed(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [MSAnalyticsMemberPointsRedeemedPartitionedByDate]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_total_points_redeemed_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_total_points_refunded(
        self,
        start_date,
        end_date,
        locale,
        timezone,
        **kwargs
    ):
        """Count refunded points  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_total_points_refunded(start_date, end_date, locale, timezone, async_req=True)
        >>> result = thread.get()

        Args:
            start_date (datetime):
            end_date (datetime):
            locale (str):
            timezone (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [MSAnalyticsMemberPointsRefundedPartitionedByDate]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['locale'] = \
            locale
        kwargs['timezone'] = \
            timezone
        return self.fetch_analytics_total_points_refunded_endpoint.call_with_http_info(**kwargs)

    def fetch_analytics_wallet_session_activity(
        self,
        session_id,
        **kwargs
    ):
        """Fetch session activity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_analytics_wallet_session_activity(session_id, async_req=True)
        >>> result = thread.get()

        Args:
            session_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [WTWalletPageView]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_id'] = \
            session_id
        return self.fetch_analytics_wallet_session_activity_endpoint.call_with_http_info(**kwargs)

    def fetch_wallet_page_view_by_id(
        self,
        id,
        **kwargs
    ):
        """Fetch session activity by wallet page view ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_wallet_page_view_by_id(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WalletPageView
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.fetch_wallet_page_view_by_id_endpoint.call_with_http_info(**kwargs)

