# wallet
API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.1.524
- Package version: 2.1.524
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import wallet
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import wallet
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import wallet
from pprint import pprint
from wallet.api import advertisement_credits_api
from wallet.model.auth_error import AuthError
from wallet.model.duplicate_row_found import DuplicateRowFound
from wallet.model.falsum_error import FalsumError
from wallet.model.foreign_key_does_not_exist import ForeignKeyDoesNotExist
from wallet.model.internal_server_error import InternalServerError
from wallet.model.merchant_not_initialized import MerchantNotInitialized
from wallet.model.wt_advertisement_credit import WTAdvertisementCredit
from wallet.model.wt_advertisement_credit_create_params import WTAdvertisementCreditCreateParams
from wallet.model.wt_advertisement_credit_scan import WTAdvertisementCreditScan
from wallet.model.wt_advertisement_credit_update_params import WTAdvertisementCreditUpdateParams
# Defining the host is optional and defaults to https://api.wall.et
# See configuration.py for a list of all supported configuration parameters.
configuration = wallet.Configuration(
    host = "https://api.wall.et"
)



# Enter a context with an instance of the API client
with wallet.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = advertisement_credits_api.AdvertisementCreditsApi(api_client)
    id = None # bool, date, datetime, dict, float, int, list, str, none_type | 

    try:
        # Archive ad credit
        api_response = api_instance.archive_advertisement_credit(id)
        pprint(api_response)
    except wallet.ApiException as e:
        print("Exception when calling AdvertisementCreditsApi->archive_advertisement_credit: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.wall.et*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdvertisementCreditsApi* | [**archive_advertisement_credit**](docs/AdvertisementCreditsApi.md#archive_advertisement_credit) | **DELETE** /v2/payment/advertisementCredit/{id} | Archive ad credit
*AdvertisementCreditsApi* | [**create_advertisement_credit**](docs/AdvertisementCreditsApi.md#create_advertisement_credit) | **POST** /v2/payment/advertisementCredit | Create ad credit
*AdvertisementCreditsApi* | [**fetch_advertisement_credit_by_id**](docs/AdvertisementCreditsApi.md#fetch_advertisement_credit_by_id) | **GET** /v2/payment/advertisementCredit/{id} | Fetch ad credit
*AdvertisementCreditsApi* | [**fetch_advertisement_credit_scans**](docs/AdvertisementCreditsApi.md#fetch_advertisement_credit_scans) | **GET** /v2/payment/advertisementCredit/scans/{id} | Fetch scans
*AdvertisementCreditsApi* | [**fetch_all_advertisement_credits**](docs/AdvertisementCreditsApi.md#fetch_all_advertisement_credits) | **GET** /v2/payment/advertisementCredit/all | Fetch all active ad credits
*AdvertisementCreditsApi* | [**restore_advertisement_credit**](docs/AdvertisementCreditsApi.md#restore_advertisement_credit) | **PATCH** /v2/payment/advertisementCredit/{id} | Restore ad credit
*AdvertisementCreditsApi* | [**update_advertisement_credit**](docs/AdvertisementCreditsApi.md#update_advertisement_credit) | **PUT** /v2/payment/advertisementCredit/{id} | Update ad credit
*AnalyticsApi* | [**count_verified_wallet_page_views**](docs/AnalyticsApi.md#count_verified_wallet_page_views) | **GET** /v2/analytics/walletPageViews/sessions/verified/distinct/walletObjectsCount | Fetch wallet object counts within a given time frame that have a valid phone verification token
*AnalyticsApi* | [**count_wallet_page_views**](docs/AnalyticsApi.md#count_wallet_page_views) | **GET** /v2/analytics/walletPageViews/sessions/distinct/walletObjectsCount | Fetch wallet object counts within a given time frame
*AnalyticsApi* | [**fetch_analytics_ad_credits_count_partitioned_by_employee**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_count_partitioned_by_employee) | **GET** /v2/analytics/advertisementCredits/count/employee | Count ad credits by employee
*AnalyticsApi* | [**fetch_analytics_ad_credits_count_partitioned_by_payment_design**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_count_partitioned_by_payment_design) | **GET** /v2/analytics/advertisementCredits/count/paymentDesign | Count ad credits by payment design
*AnalyticsApi* | [**fetch_analytics_ad_credits_count_partitioned_by_value_type**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_count_partitioned_by_value_type) | **GET** /v2/analytics/advertisementCredits/count/valueType | Count ad credits by value type
*AnalyticsApi* | [**fetch_analytics_ad_credits_redemptions_amount_partitioned_by_ad_credit_id**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_redemptions_amount_partitioned_by_ad_credit_id) | **GET** /v2/analytics/advertisementCredits/redemptions/amount/adCredit | Fetch redemption amount of ad credits by Ad Credit
*AnalyticsApi* | [**fetch_analytics_ad_credits_redemptions_amount_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_redemptions_amount_partitioned_by_date) | **GET** /v2/analytics/advertisementCredits/redemptions/amount/date | Fetch redemption amount of ad credits by date
*AnalyticsApi* | [**fetch_analytics_ad_credits_redemptions_count_partitioned_by_ad_credit_id**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_redemptions_count_partitioned_by_ad_credit_id) | **GET** /v2/analytics/advertisementCredits/redemptions/count/adCredit | Count redemptions of ad credits by Ad Credit
*AnalyticsApi* | [**fetch_analytics_ad_credits_redemptions_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_redemptions_count_partitioned_by_date) | **GET** /v2/analytics/advertisementCredits/redemptions/count/date | Count redemptions of ad credits by date
*AnalyticsApi* | [**fetch_analytics_ad_credits_refunds_amount_partitioned_by_ad_credit_id**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_refunds_amount_partitioned_by_ad_credit_id) | **GET** /v2/analytics/advertisementCredits/refunds/amount/adCredit | Fetch refund amount of ad credits by Ad Credit
*AnalyticsApi* | [**fetch_analytics_ad_credits_refunds_amount_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_refunds_amount_partitioned_by_date) | **GET** /v2/analytics/advertisementCredits/refunds/amount/date | Fetch refund amount of ad credits by date
*AnalyticsApi* | [**fetch_analytics_ad_credits_refunds_count_partitioned_by_ad_credit_id**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_refunds_count_partitioned_by_ad_credit_id) | **GET** /v2/analytics/advertisementCredits/refunds/count/adCredit | Count refunds of ad credits by Ad Credit
*AnalyticsApi* | [**fetch_analytics_ad_credits_refunds_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_refunds_count_partitioned_by_date) | **GET** /v2/analytics/advertisementCredits/refunds/count/date | Count refunds of ad credits by date
*AnalyticsApi* | [**fetch_analytics_ad_credits_scans_count_partitioned_by_ad_credit_id**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_scans_count_partitioned_by_ad_credit_id) | **GET** /v2/analytics/advertisementCredits/scans/count/adCredit | Count scans of ad credits by Ad Credit
*AnalyticsApi* | [**fetch_analytics_ad_credits_scans_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_ad_credits_scans_count_partitioned_by_date) | **GET** /v2/analytics/advertisementCredits/scans/count/date | Count scans of ad credits by date
*AnalyticsApi* | [**fetch_analytics_campaign_wallet_page_views**](docs/AnalyticsApi.md#fetch_analytics_campaign_wallet_page_views) | **GET** /v2/analytics/walletPageViews/campaign/{campaignID} | Fetch a campaign&#39;s wallet page views
*AnalyticsApi* | [**fetch_analytics_campaigns_count_partitioned_by_campaign_id**](docs/AnalyticsApi.md#fetch_analytics_campaigns_count_partitioned_by_campaign_id) | **GET** /v2/analytics/campaigns/count/campaign/created | Count created campaigns by campaign
*AnalyticsApi* | [**fetch_analytics_campaigns_count_partitioned_by_employee**](docs/AnalyticsApi.md#fetch_analytics_campaigns_count_partitioned_by_employee) | **GET** /v2/analytics/campaigns/count/employee | Count campaigns by employee
*AnalyticsApi* | [**fetch_analytics_campaigns_count_partitioned_by_payment_design**](docs/AnalyticsApi.md#fetch_analytics_campaigns_count_partitioned_by_payment_design) | **GET** /v2/analytics/campaigns/count/paymentDesign | Count campaigns by payment design
*AnalyticsApi* | [**fetch_analytics_campaigns_count_partitioned_by_value_type**](docs/AnalyticsApi.md#fetch_analytics_campaigns_count_partitioned_by_value_type) | **GET** /v2/analytics/campaigns/count/valueType | Count campaigns by value type
*AnalyticsApi* | [**fetch_analytics_campaigns_redemptions_amount_partitioned_by_campaign_id**](docs/AnalyticsApi.md#fetch_analytics_campaigns_redemptions_amount_partitioned_by_campaign_id) | **GET** /v2/analytics/campaigns/redemptions/amount/campaign | Fetch redemption amount of campaigns by Campaign
*AnalyticsApi* | [**fetch_analytics_campaigns_redemptions_amount_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_campaigns_redemptions_amount_partitioned_by_date) | **GET** /v2/analytics/campaigns/redemptions/amount/date | Fetch redemption amount of campaigns by date
*AnalyticsApi* | [**fetch_analytics_campaigns_redemptions_count_partitioned_by_campaign_id**](docs/AnalyticsApi.md#fetch_analytics_campaigns_redemptions_count_partitioned_by_campaign_id) | **GET** /v2/analytics/campaigns/redemptions/count/campaign | Count redemptions of campaigns by Campaign
*AnalyticsApi* | [**fetch_analytics_campaigns_redemptions_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_campaigns_redemptions_count_partitioned_by_date) | **GET** /v2/analytics/campaigns/redemptions/count/date | Count redemptions of campaigns by date
*AnalyticsApi* | [**fetch_analytics_campaigns_refunds_amount_partitioned_by_campaign_id**](docs/AnalyticsApi.md#fetch_analytics_campaigns_refunds_amount_partitioned_by_campaign_id) | **GET** /v2/analytics/campaigns/refunds/amount/campaign | Fetch refund amount of campaigns by Campaign
*AnalyticsApi* | [**fetch_analytics_campaigns_refunds_amount_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_campaigns_refunds_amount_partitioned_by_date) | **GET** /v2/analytics/campaigns/refunds/amount/date | Fetch refund amount of campaigns by date
*AnalyticsApi* | [**fetch_analytics_campaigns_refunds_count_partitioned_by_campaign_id**](docs/AnalyticsApi.md#fetch_analytics_campaigns_refunds_count_partitioned_by_campaign_id) | **GET** /v2/analytics/campaigns/refunds/count/campaign | Fetch refund amount of campaigns by Campaign
*AnalyticsApi* | [**fetch_analytics_campaigns_refunds_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_campaigns_refunds_count_partitioned_by_date) | **GET** /v2/analytics/campaigns/refunds/count/date | Fetch refund amount of campaigns by date
*AnalyticsApi* | [**fetch_analytics_delivered_outbound_messages_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_delivered_outbound_messages_count_partitioned_by_date) | **GET** /v2/analytics/outboundSMS/count/date/delivered | Count delivered outbound messages by date
*AnalyticsApi* | [**fetch_analytics_delivered_outbound_messages_count_partitioned_by_phone_number**](docs/AnalyticsApi.md#fetch_analytics_delivered_outbound_messages_count_partitioned_by_phone_number) | **GET** /v2/analytics/outboundSMS/count/phoneNumber/delivered | Count delivered outbound messages by phone number
*AnalyticsApi* | [**fetch_analytics_distinct_wallet_sessions**](docs/AnalyticsApi.md#fetch_analytics_distinct_wallet_sessions) | **GET** /v2/analytics/walletPageViews/sessions/distinct | Fetch distinct wallet sessions
*AnalyticsApi* | [**fetch_analytics_dynamic_vouchers_count_partitioned_by_employee**](docs/AnalyticsApi.md#fetch_analytics_dynamic_vouchers_count_partitioned_by_employee) | **GET** /v2/analytics/dynamicVouchers/count/employee | Count dynamic vouchers by employee
*AnalyticsApi* | [**fetch_analytics_dynamic_vouchers_count_partitioned_by_payment_design**](docs/AnalyticsApi.md#fetch_analytics_dynamic_vouchers_count_partitioned_by_payment_design) | **GET** /v2/analytics/dynamicVouchers/count/paymentDesign | Count dynamic vouchers by payment design
*AnalyticsApi* | [**fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_date) | **GET** /v2/analytics/dynamicVouchers/redemptions/amount/date | Fetch redemption amount of dynamic vouchers by date
*AnalyticsApi* | [**fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_dynamic_voucher_id**](docs/AnalyticsApi.md#fetch_analytics_dynamic_vouchers_redemptions_amount_partitioned_by_dynamic_voucher_id) | **GET** /v2/analytics/dynamicVouchers/redemptions/amount/dynamicVoucher | Fetch redemption amount of dynamic vouchers by dynamic voucher
*AnalyticsApi* | [**fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_date) | **GET** /v2/analytics/dynamicVouchers/redemptions/count/date | Count redemptions of dynamic vouchers by date
*AnalyticsApi* | [**fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_dynamic_voucher_id**](docs/AnalyticsApi.md#fetch_analytics_dynamic_vouchers_redemptions_count_partitioned_by_dynamic_voucher_id) | **GET** /v2/analytics/dynamicVouchers/redemptions/count/dynamicVoucher | Count redemptions of dynamic vouchers by dynamic voucher
*AnalyticsApi* | [**fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_date) | **GET** /v2/analytics/dynamicVouchers/refunds/amount/date | Fetch refund amount of dynamic vouchers by date
*AnalyticsApi* | [**fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_dynamic_voucher_id**](docs/AnalyticsApi.md#fetch_analytics_dynamic_vouchers_refunds_amount_partitioned_by_dynamic_voucher_id) | **GET** /v2/analytics/dynamicVouchers/refunds/amount/dynamicVoucher | Fetch refund amount of dynamic vouchers by dynamic voucher
*AnalyticsApi* | [**fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_date) | **GET** /v2/analytics/dynamicVouchers/refunds/count/date | Count refunds of dynamic vouchers by date
*AnalyticsApi* | [**fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_dynamic_voucher_id**](docs/AnalyticsApi.md#fetch_analytics_dynamic_vouchers_refunds_count_partitioned_by_dynamic_voucher_id) | **GET** /v2/analytics/dynamicVouchers/refunds/count/dynamicVoucher | Count refunds of dynamic vouchers by dynamic voucher
*AnalyticsApi* | [**fetch_analytics_help_desk_requests_created_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_help_desk_requests_created_count_partitioned_by_date) | **GET** /v2/analytics/helpdeskrequests/count/date/created | Count help desk requests by date
*AnalyticsApi* | [**fetch_analytics_help_desk_requests_resolved_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_help_desk_requests_resolved_count_partitioned_by_date) | **GET** /v2/analytics/helpdeskrequests/count/date/resolved | Count resolved help desk requests by date
*AnalyticsApi* | [**fetch_analytics_help_desk_requests_resolved_count_partitioned_by_employee**](docs/AnalyticsApi.md#fetch_analytics_help_desk_requests_resolved_count_partitioned_by_employee) | **GET** /v2/analytics/helpdeskrequests/count/employee/resolved | Count resolved help desk requests by employee
*AnalyticsApi* | [**fetch_analytics_help_desk_requests_unresolved_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_help_desk_requests_unresolved_count_partitioned_by_date) | **GET** /v2/analytics/helpdeskrequests/count/date/unresolved | Count unresolved help desk requests by date
*AnalyticsApi* | [**fetch_analytics_item_wallet_page_views**](docs/AnalyticsApi.md#fetch_analytics_item_wallet_page_views) | **GET** /v2/analytics/walletPageViews/item/{itemID} | Fetch wallet page views of item
*AnalyticsApi* | [**fetch_analytics_member_count**](docs/AnalyticsApi.md#fetch_analytics_member_count) | **GET** /v2/analytics/membership/member/count | Count members
*AnalyticsApi* | [**fetch_analytics_merchant_credit_count**](docs/AnalyticsApi.md#fetch_analytics_merchant_credit_count) | **GET** /v2/analytics/membership/merchantCredit/count | Count merchant credits
*AnalyticsApi* | [**fetch_analytics_offer_vs_redeemed_amount_partitioned_by_campaign_id**](docs/AnalyticsApi.md#fetch_analytics_offer_vs_redeemed_amount_partitioned_by_campaign_id) | **GET** /v2/analytics/campaigns/amount/campaign/offerVsRedeemed | Fetch offer vs redeemed amount by campaign
*AnalyticsApi* | [**fetch_analytics_payment_object_broadcasts_created_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_payment_object_broadcasts_created_count_partitioned_by_date) | **GET** /v2/analytics/paymentObjectBroadcasts/count/date/created | Count created broadcasts by date
*AnalyticsApi* | [**fetch_analytics_payment_object_broadcasts_individual_execution_time_of_completed_broadcasts**](docs/AnalyticsApi.md#fetch_analytics_payment_object_broadcasts_individual_execution_time_of_completed_broadcasts) | **GET** /v2/analytics/paymentObjectBroadcasts/executionTime/completed | Fetch execution time of completed broadcasts
*AnalyticsApi* | [**fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_date) | **GET** /v2/analytics/paymentObjectBroadcasts/count/date/scheduled | Count scheduled broadcasts by date
*AnalyticsApi* | [**fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_employee**](docs/AnalyticsApi.md#fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_employee) | **GET** /v2/analytics/paymentObjectBroadcasts/count/employee/scheduled | Count scheduled broadcasts by employee
*AnalyticsApi* | [**fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_phone_number**](docs/AnalyticsApi.md#fetch_analytics_payment_object_broadcasts_scheduled_count_partitioned_by_phone_number) | **GET** /v2/analytics/paymentObjectBroadcasts/count/phoneNumber/scheduled | Count scheduled broadcasts by phone number
*AnalyticsApi* | [**fetch_analytics_payment_object_broadcasts_scheduled_sms_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_payment_object_broadcasts_scheduled_sms_count_partitioned_by_date) | **GET** /v2/analytics/paymentObjectBroadcasts/sms/count/date/scheduled | Count scheduled SMS broadcasts by date
*AnalyticsApi* | [**fetch_analytics_sent_outbound_messages_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_sent_outbound_messages_count_partitioned_by_date) | **GET** /v2/analytics/outboundSMS/count/date/sent | Count sent outbound messages by date
*AnalyticsApi* | [**fetch_analytics_sent_outbound_messages_count_partitioned_by_phone_number**](docs/AnalyticsApi.md#fetch_analytics_sent_outbound_messages_count_partitioned_by_phone_number) | **GET** /v2/analytics/outboundSMS/count/phoneNumber/sent | Count sent outbound messages by phone number
*AnalyticsApi* | [**fetch_analytics_static_voucher_wallet_page_views**](docs/AnalyticsApi.md#fetch_analytics_static_voucher_wallet_page_views) | **GET** /v2/analytics/walletPageViews/staticVoucher/{voucherID} | Fetch a static voucher&#39;s wallet page views
*AnalyticsApi* | [**fetch_analytics_tcpa_stop_count_partitioned_by_date**](docs/AnalyticsApi.md#fetch_analytics_tcpa_stop_count_partitioned_by_date) | **GET** /v2/analytics/tcpa/count/date/stop | Count TCPA (STOP) entries by date
*AnalyticsApi* | [**fetch_analytics_tcpa_stop_count_partitioned_by_phone_number**](docs/AnalyticsApi.md#fetch_analytics_tcpa_stop_count_partitioned_by_phone_number) | **GET** /v2/analytics/tcpa/count/phoneNumber/stop | Count TCPA (STOP) entries by phone number
*AnalyticsApi* | [**fetch_analytics_total_amount_redeemed_per_merchant_credit**](docs/AnalyticsApi.md#fetch_analytics_total_amount_redeemed_per_merchant_credit) | **GET** /v2/analytics/membership/merchantCredit/amount/redeemed | Fetch redeemed amount of merchant credits
*AnalyticsApi* | [**fetch_analytics_total_amount_redeemed_per_tier**](docs/AnalyticsApi.md#fetch_analytics_total_amount_redeemed_per_tier) | **GET** /v2/analytics/membership/tier/amount/redeemed | Fetch redeemed amoun̥t of tiers
*AnalyticsApi* | [**fetch_analytics_total_amount_refunded_per_merchant_credit**](docs/AnalyticsApi.md#fetch_analytics_total_amount_refunded_per_merchant_credit) | **GET** /v2/analytics/membership/merchantCredit/amount/refunded | Fetch refunded amount of merchant credits
*AnalyticsApi* | [**fetch_analytics_total_amount_refunded_per_tier**](docs/AnalyticsApi.md#fetch_analytics_total_amount_refunded_per_tier) | **GET** /v2/analytics/membership/tier/amount/refunded | Fetch refunded amount of tiers
*AnalyticsApi* | [**fetch_analytics_total_points_redeemed**](docs/AnalyticsApi.md#fetch_analytics_total_points_redeemed) | **GET** /v2/analytics/membership/member/points/redeemed | Count redeemed points
*AnalyticsApi* | [**fetch_analytics_total_points_refunded**](docs/AnalyticsApi.md#fetch_analytics_total_points_refunded) | **GET** /v2/analytics/membership/member/points/refunded | Count refunded points
*AnalyticsApi* | [**fetch_analytics_wallet_session_activity**](docs/AnalyticsApi.md#fetch_analytics_wallet_session_activity) | **GET** /v2/analytics/walletPageViews/session/activity/{sessionID} | Fetch session activity
*AnalyticsApi* | [**fetch_wallet_page_view_by_id**](docs/AnalyticsApi.md#fetch_wallet_page_view_by_id) | **GET** /v2/analytics/walletPageViews/activity/{id} | Fetch session activity by wallet page view ID
*AppleWalletSubscribersApi* | [**fetch_apple_wallet_subscriber_activity**](docs/AppleWalletSubscribersApi.md#fetch_apple_wallet_subscriber_activity) | **GET** /v2/apple/wallet/pass/subscriber/activity/{subscriptionID} | Fetch subscriber activity
*AppleWalletSubscribersApi* | [**fetch_apple_wallet_subscribers**](docs/AppleWalletSubscribersApi.md#fetch_apple_wallet_subscribers) | **GET** /v2/apple/wallet/pass/subscribers/all | Fetch all subscribers
*BillingApi* | [**cancel_plan**](docs/BillingApi.md#cancel_plan) | **DELETE** /v2/billing/plan | Cancel billing plan and revert to default
*BillingApi* | [**change_plan**](docs/BillingApi.md#change_plan) | **PUT** /v2/billing/plan | Change billing plan
*BillingApi* | [**fetch_industry**](docs/BillingApi.md#fetch_industry) | **GET** /v2/billing/industry | Fetch merchant&#39;s industry
*BillingApi* | [**fetch_invoices**](docs/BillingApi.md#fetch_invoices) | **GET** /v2/billing/invoices/all | Fetch all invoices
*BillingApi* | [**fetch_subscription**](docs/BillingApi.md#fetch_subscription) | **GET** /v2/billing/subscription | Fetch subscription
*BillingApi* | [**fetch_usage_summary**](docs/BillingApi.md#fetch_usage_summary) | **GET** /v2/billing/summary | Fetch usage summary
*BillingApi* | [**save_payment_method**](docs/BillingApi.md#save_payment_method) | **PUT** /v2/billing/paymentMethod | Save payment method
*BillingApi* | [**upcoming_invoices**](docs/BillingApi.md#upcoming_invoices) | **GET** /v2/billing/invoices/upcoming | Fetch upcoming invoices
*BillingApi* | [**verify_payment_method**](docs/BillingApi.md#verify_payment_method) | **GET** /v2/billing/paymentMethod | Verify payment method
*ClubMembersPointsApi* | [**archive_member**](docs/ClubMembersPointsApi.md#archive_member) | **DELETE** /v2/membership/member/{id} | Archive member
*ClubMembersPointsApi* | [**create_member**](docs/ClubMembersPointsApi.md#create_member) | **POST** /v2/membership/member | Create member
*ClubMembersPointsApi* | [**fetch_member_by_id**](docs/ClubMembersPointsApi.md#fetch_member_by_id) | **GET** /v2/membership/member/{id} | Fetch member
*ClubMembersPointsApi* | [**fetch_member_history_log**](docs/ClubMembersPointsApi.md#fetch_member_history_log) | **POST** /v2/membership/member/history/log | Fetch history
*ClubMembersPointsApi* | [**fetch_member_redemption_log**](docs/ClubMembersPointsApi.md#fetch_member_redemption_log) | **POST** /v2/membership/member/redemption/log | Fetch redemption log
*ClubMembersPointsApi* | [**fetch_members_by_page**](docs/ClubMembersPointsApi.md#fetch_members_by_page) | **POST** /v2/membership/member/page | Fetch members by page
*ClubMembersPointsApi* | [**fetch_members_count**](docs/ClubMembersPointsApi.md#fetch_members_count) | **GET** /v2/membership/member/count | Count active members
*ClubMembersPointsApi* | [**restore_member**](docs/ClubMembersPointsApi.md#restore_member) | **PATCH** /v2/membership/member/{id} | Restore member
*ClubMembersPointsApi* | [**search_members**](docs/ClubMembersPointsApi.md#search_members) | **POST** /v2/membership/member/search | Search for members
*ClubMembersPointsApi* | [**update_member**](docs/ClubMembersPointsApi.md#update_member) | **PUT** /v2/membership/member/{id} | Update member
*ConfigurationApi* | [**create_public_chat_room**](docs/ConfigurationApi.md#create_public_chat_room) | **POST** /v2/wallet/createPublicChatRoom | 
*ConfigurationApi* | [**save_wallet_record**](docs/ConfigurationApi.md#save_wallet_record) | **PUT** /v2/wallet | Update wallet record
*CountriesApi* | [**fetch_all_countries**](docs/CountriesApi.md#fetch_all_countries) | **GET** /system/countries/all | Fetch all countries
*CustomerApi* | [**fetch_active_vouchers**](docs/CustomerApi.md#fetch_active_vouchers) | **GET** /v2/customer/vouchers/active | Fetch active static vouchers
*CustomerApi* | [**fetch_all_vouchers**](docs/CustomerApi.md#fetch_all_vouchers) | **GET** /v2/customer/vouchers/all | Fetch all static vouchers
*CustomerApi* | [**fetch_expired_vouchers**](docs/CustomerApi.md#fetch_expired_vouchers) | **GET** /v2/customer/vouchers/expired | Fetch expired static vouchers
*CustomerApi* | [**fetch_redeemed_vouchers**](docs/CustomerApi.md#fetch_redeemed_vouchers) | **GET** /v2/customer/vouchers/redeemed | Fetch redeemed static vouchers
*CustomerApi* | [**fetch_refunded_vouchers**](docs/CustomerApi.md#fetch_refunded_vouchers) | **GET** /v2/customer/vouchers/refunded | Fetch refunded static vouchers
*CustomerApi* | [**fetch_upcoming_vouchers**](docs/CustomerApi.md#fetch_upcoming_vouchers) | **GET** /v2/customer/vouchers/upcoming | Fetch upcoming static vouchers
*CustomerApi* | [**fetch_wallet_views_for_session**](docs/CustomerApi.md#fetch_wallet_views_for_session) | **GET** /v2/customer/walletViews/session/{id} | Fetch Wallet Views for Session
*CustomerApi* | [**search_by_member_id**](docs/CustomerApi.md#search_by_member_id) | **POST** /v2/customer/search/memberID | Find members with memberID
*CustomerApi* | [**search_by_phone_number**](docs/CustomerApi.md#search_by_phone_number) | **POST** /v2/customer/search/phoneNumber | Find members with phone number
*DashboardApi* | [**fetch_dashboard_active_static_voucher_campaigns_count**](docs/DashboardApi.md#fetch_dashboard_active_static_voucher_campaigns_count) | **GET** /v2/dashboard/count/staticVoucherCampaigns/active | Count active static voucher campaigns
*DashboardApi* | [**fetch_dashboard_active_static_vouchers_count**](docs/DashboardApi.md#fetch_dashboard_active_static_vouchers_count) | **GET** /v2/dashboard/count/staticVouchers/active | Count active static vouchers
*DashboardApi* | [**fetch_dashboard_apple_wallet_subscribers_count**](docs/DashboardApi.md#fetch_dashboard_apple_wallet_subscribers_count) | **GET** /v2/dashboard/count/appleWallet/subscribers | Count Apple Wallet Subscribers
*DashboardApi* | [**fetch_dashboard_employees_count**](docs/DashboardApi.md#fetch_dashboard_employees_count) | **GET** /v2/dashboard/count/employees | Count employees
*DashboardApi* | [**fetch_dashboard_members_count**](docs/DashboardApi.md#fetch_dashboard_members_count) | **GET** /v2/dashboard/count/members | Count members
*DashboardApi* | [**fetch_dashboard_membership_tiers_count**](docs/DashboardApi.md#fetch_dashboard_membership_tiers_count) | **GET** /v2/dashboard/count/membershipTiers | Count tiers
*DashboardApi* | [**fetch_dashboard_news_articles_count**](docs/DashboardApi.md#fetch_dashboard_news_articles_count) | **GET** /v2/dashboard/count/newsArticles | Count News Articles
*DashboardApi* | [**fetch_dashboard_opt_in_lists_count**](docs/DashboardApi.md#fetch_dashboard_opt_in_lists_count) | **GET** /v2/dashboard/count/optInLists | Count opt in lists
*DashboardApi* | [**fetch_dashboard_opt_in_sources_count**](docs/DashboardApi.md#fetch_dashboard_opt_in_sources_count) | **GET** /v2/dashboard/count/optInSources | Count opt in sources
*DashboardApi* | [**fetch_dashboard_outbound_sms_count**](docs/DashboardApi.md#fetch_dashboard_outbound_sms_count) | **GET** /v2/dashboard/count/sms/outbound | Count Outbound SMS
*DashboardApi* | [**fetch_dashboard_performances_count**](docs/DashboardApi.md#fetch_dashboard_performances_count) | **GET** /v2/dashboard/count/performances | Count Performances
*DashboardApi* | [**fetch_dashboard_phone_numbers_count**](docs/DashboardApi.md#fetch_dashboard_phone_numbers_count) | **GET** /v2/dashboard/count/phoneNumbers | Count phone numbers
*DashboardApi* | [**fetch_dashboard_pos_machines_count**](docs/DashboardApi.md#fetch_dashboard_pos_machines_count) | **GET** /v2/dashboard/count/pos/machines | Count POS Machines
*DashboardApi* | [**fetch_dashboard_pos_transactions_count**](docs/DashboardApi.md#fetch_dashboard_pos_transactions_count) | **GET** /v2/dashboard/count/pos/transactions | Count POS Transactions
*DashboardApi* | [**fetch_dashboard_redemptions_count**](docs/DashboardApi.md#fetch_dashboard_redemptions_count) | **GET** /v2/dashboard/count/pos/redemptions | Count POS redemptions
*DashboardApi* | [**fetch_dashboard_refunds_count**](docs/DashboardApi.md#fetch_dashboard_refunds_count) | **GET** /v2/dashboard/count/pos/refunds | Count POS refunds
*DashboardApi* | [**fetch_dashboard_wallet_page_views_count**](docs/DashboardApi.md#fetch_dashboard_wallet_page_views_count) | **GET** /v2/dashboard/count/wallet/pageViews | Count Wallet page views
*DashboardApi* | [**fetch_dashboard_widgets_catalog**](docs/DashboardApi.md#fetch_dashboard_widgets_catalog) | **GET** /v2/dashboard/widgets | Fetch widgets catalog
*DynamicVouchersApi* | [**create_dynamic_voucher**](docs/DynamicVouchersApi.md#create_dynamic_voucher) | **POST** /v2/payment/dynamicVoucher | Create dynamic voucher
*DynamicVouchersApi* | [**fetch_all_dynamic_vouchers**](docs/DynamicVouchersApi.md#fetch_all_dynamic_vouchers) | **GET** /v2/payment/dynamicVoucher/all | Fetch all active dynamic vouchers
*DynamicVouchersApi* | [**fetch_dynamic_voucher_by_id**](docs/DynamicVouchersApi.md#fetch_dynamic_voucher_by_id) | **GET** /v2/payment/dynamicVoucher/{id} | Fetch dynamic voucher
*DynamicVouchersApi* | [**fetch_dynamic_voucher_redemptions**](docs/DynamicVouchersApi.md#fetch_dynamic_voucher_redemptions) | **GET** /v2/payment/dynamicVoucher/redemptions/{id} | Fetch redemptions
*DynamicVouchersApi* | [**fetch_reach_stats_of_all_dynamic_vouchers**](docs/DynamicVouchersApi.md#fetch_reach_stats_of_all_dynamic_vouchers) | **GET** /v2/payment/dynamicVoucher/reach/all | Get the reach statistics of all the dynamic vouchers
*DynamicVouchersApi* | [**fetch_reach_stats_of_individual_dynamic_voucher**](docs/DynamicVouchersApi.md#fetch_reach_stats_of_individual_dynamic_voucher) | **GET** /v2/payment/dynamicVoucher/reach/{dynamicVoucherID} | Get the reach statistics of an individual dynamic voucher
*DynamicVouchersApi* | [**save_dynamic_voucher**](docs/DynamicVouchersApi.md#save_dynamic_voucher) | **PUT** /v2/payment/dynamicVoucher/{id} | Update dynamic voucher
*EmployeeAPIKeysApi* | [**archive_employee_api_keys**](docs/EmployeeAPIKeysApi.md#archive_employee_api_keys) | **DELETE** /v2/employee/apiKeys/{id} | Archive employee API Key
*EmployeeAPIKeysApi* | [**create_employee_api_keys**](docs/EmployeeAPIKeysApi.md#create_employee_api_keys) | **POST** /v2/employee/apiKeys | Create employee API Key
*EmployeeAPIKeysApi* | [**fetch_all_employee_api_keys**](docs/EmployeeAPIKeysApi.md#fetch_all_employee_api_keys) | **GET** /v2/employee/apiKeys/all | Fetch all employee API Keys
*EmployeeAPIKeysApi* | [**fetch_employee_api_key_by_id**](docs/EmployeeAPIKeysApi.md#fetch_employee_api_key_by_id) | **GET** /v2/employee/apiKeys/{id} | Fetch API Key
*EmployeeAPIKeysApi* | [**update_employee_api_keys**](docs/EmployeeAPIKeysApi.md#update_employee_api_keys) | **PUT** /v2/employee/apiKeys/{id} | Update employee API Key
*EmployeeAccessApi* | [**register**](docs/EmployeeAccessApi.md#register) | **POST** /authentication/register | Register
*EmployeesApi* | [**add_peer_to_roles**](docs/EmployeesApi.md#add_peer_to_roles) | **POST** /v2/employee/roles/peer/{userID} | Add peer to roles
*EmployeesApi* | [**create_alert**](docs/EmployeesApi.md#create_alert) | **POST** /v2/employee/alert | Create employee alert
*EmployeesApi* | [**create_document**](docs/EmployeesApi.md#create_document) | **POST** /v2/employee/document | Create document
*EmployeesApi* | [**create_employee_peer**](docs/EmployeesApi.md#create_employee_peer) | **POST** /v2/employee/peer | Create employee peer
*EmployeesApi* | [**create_file**](docs/EmployeesApi.md#create_file) | **POST** /v2/employee/file/create | Create file
*EmployeesApi* | [**create_media_file**](docs/EmployeesApi.md#create_media_file) | **POST** /v2/employee/mediaFile | Create media file
*EmployeesApi* | [**create_static_voucher_campaigns_group**](docs/EmployeesApi.md#create_static_voucher_campaigns_group) | **POST** /v2/employee/staticVoucherCampaignsGroup | Create static voucher campaign group
*EmployeesApi* | [**delete_document**](docs/EmployeesApi.md#delete_document) | **DELETE** /v2/employee/document/{documentID} | Delete document
*EmployeesApi* | [**delete_media_file**](docs/EmployeesApi.md#delete_media_file) | **DELETE** /v2/employee/mediaFile/{mediaFileID} | Delete media file
*EmployeesApi* | [**download_file**](docs/EmployeesApi.md#download_file) | **GET** /v2/employee/file/download/{fileID} | Fetch URL for file download
*EmployeesApi* | [**export_club_members**](docs/EmployeesApi.md#export_club_members) | **PUT** /v2/employee/export/members | Export club members
*EmployeesApi* | [**export_merchant_credits**](docs/EmployeesApi.md#export_merchant_credits) | **PUT** /v2/employee/export/merchantCredits | Export merchant credits
*EmployeesApi* | [**export_static_voucher_campaign**](docs/EmployeesApi.md#export_static_voucher_campaign) | **PUT** /v2/employee/export/staticVoucherCampaign/{campaignID} | Export static voucher campaign
*EmployeesApi* | [**failed_import**](docs/EmployeesApi.md#failed_import) | **GET** /v2/employee/file/imports/failed/{fileID} | Fetch URL to download a failed import
*EmployeesApi* | [**fetch_documents**](docs/EmployeesApi.md#fetch_documents) | **GET** /v2/employee/documents/all | Fetch all documents
*EmployeesApi* | [**fetch_dynamic_vouchers**](docs/EmployeesApi.md#fetch_dynamic_vouchers) | **GET** /v2/employee/dynamicVouchers/all | Fetch all dynamic vouchers
*EmployeesApi* | [**fetch_employee_static_voucher_campaign_groups**](docs/EmployeesApi.md#fetch_employee_static_voucher_campaign_groups) | **GET** /v2/employee/staticVoucherCampaignGroups/all | Fetch static voucher campaign groups
*EmployeesApi* | [**fetch_employee_static_voucher_campaigns**](docs/EmployeesApi.md#fetch_employee_static_voucher_campaigns) | **GET** /v2/employee/staticVoucherCampaigns/all | Fetch static voucher campaigns
*EmployeesApi* | [**fetch_media_files**](docs/EmployeesApi.md#fetch_media_files) | **GET** /v2/employee/mediaFiles/all | Fetch all media files
*EmployeesApi* | [**fetch_merchant**](docs/EmployeesApi.md#fetch_merchant) | **GET** /v2/employee/merchant | Fetch merchant information
*EmployeesApi* | [**fetch_messages**](docs/EmployeesApi.md#fetch_messages) | **GET** /v2/employee/messages/all | Fetch all messages
*EmployeesApi* | [**fetch_opt_in_list_source**](docs/EmployeesApi.md#fetch_opt_in_list_source) | **GET** /v2/employee/optInListSource/{sourceID} | Fetch opt in list source
*EmployeesApi* | [**fetch_opt_in_list_sources_created_by_employee**](docs/EmployeesApi.md#fetch_opt_in_list_sources_created_by_employee) | **GET** /v2/employee/optInListSources/all | Fetch all opt in list sources
*EmployeesApi* | [**fetch_peer_activity**](docs/EmployeesApi.md#fetch_peer_activity) | **GET** /v2/employee/peer/activity/{employeeID} | Fetch peer activity
*EmployeesApi* | [**fetch_peers_permissions**](docs/EmployeesApi.md#fetch_peers_permissions) | **GET** /v2/employee/peer/permissions/{userID} | Fetch peer permissions
*EmployeesApi* | [**import_club_members**](docs/EmployeesApi.md#import_club_members) | **POST** /v2/employee/import/members | Import club members
*EmployeesApi* | [**import_merchant_credits**](docs/EmployeesApi.md#import_merchant_credits) | **POST** /v2/employee/import/merchantCredits | Import merchant credits
*EmployeesApi* | [**load_webpages_of_employee**](docs/EmployeesApi.md#load_webpages_of_employee) | **GET** /v2/employee/webpages/all | Retrieve employee&#39;s webpages
*EmployeesApi* | [**modify_peers_roles**](docs/EmployeesApi.md#modify_peers_roles) | **PUT** /v2/employee/peer/permissions/{userID} | Modify peer&#39;s roles
*EmployeesApi* | [**presign_file**](docs/EmployeesApi.md#presign_file) | **POST** /v2/employee/file/presign | Presign file for upload
*EmployeesApi* | [**remove_peer_from_all_roles**](docs/EmployeesApi.md#remove_peer_from_all_roles) | **DELETE** /v2/employee/peer/permissions/{userID} | Remove peer from all roles
*EmployeesApi* | [**schedule_advertisement_credit**](docs/EmployeesApi.md#schedule_advertisement_credit) | **POST** /v2/employee/sms/schedule/adCredit/{advertisementCreditID} | Schedule Ad Credit
*EmployeesApi* | [**schedule_dynamic_voucher**](docs/EmployeesApi.md#schedule_dynamic_voucher) | **POST** /v2/employee/sms/schedule/dynamicVoucher/{dynamicVoucherID} | Schedule Dynamic Voucher to list
*EmployeesApi* | [**schedule_dynamic_voucher_to_recipient**](docs/EmployeesApi.md#schedule_dynamic_voucher_to_recipient) | **POST** /v2/employee/sms/schedule/recipient/dynamicVoucher/{dynamicVoucherID} | Schedule Dyanamic Voucher to recipient
*EmployeesApi* | [**schedule_simple_sms**](docs/EmployeesApi.md#schedule_simple_sms) | **POST** /v2/employee/sms/schedule/simple | Schedule Simple SMS broadcast to list
*EmployeesApi* | [**schedule_simple_smsto_recipient**](docs/EmployeesApi.md#schedule_simple_smsto_recipient) | **POST** /v2/employee/sms/schedule/recipient/simple | Schedule Simple SMS broadcast to recipient
*EmployeesApi* | [**send_help_desk_response**](docs/EmployeesApi.md#send_help_desk_response) | **POST** /v2/employee/helpDesk/response | Send help desk response
*EmployeesApi* | [**send_sms_campaign_broadcast**](docs/EmployeesApi.md#send_sms_campaign_broadcast) | **POST** /v2/employee/sms/schedule/campaign/{staticVoucherCampaignID} | Schedule SMS Campaign Broadcast
*EmployeesApi* | [**set_alerts_read**](docs/EmployeesApi.md#set_alerts_read) | **PATCH** /v2/employee/alerts | Mark alerts as read
*EmployeesApi* | [**set_export_data_files_read**](docs/EmployeesApi.md#set_export_data_files_read) | **PUT** /v2/employee/export/dataFiles | Mark export data files as read
*EmployeesApi* | [**set_help_desk_request_resolved**](docs/EmployeesApi.md#set_help_desk_request_resolved) | **PATCH** /v2/employee/helpDesk/request/{helpDeskRequestID} | Resolve help desk request
*EmployeesApi* | [**set_messages_read**](docs/EmployeesApi.md#set_messages_read) | **PATCH** /v2/employee/messages | Mark messages as read
*EmployeesApi* | [**set_profile_picture**](docs/EmployeesApi.md#set_profile_picture) | **PUT** /v2/employee/profile/picture | Set profile picture
*EmployeesApi* | [**update_club_members**](docs/EmployeesApi.md#update_club_members) | **PUT** /v2/employee/update/members | Update club members
*EmployeesApi* | [**update_employee_peer**](docs/EmployeesApi.md#update_employee_peer) | **PUT** /v2/employee/peer/{userID} | Update peer
*ImageGridApi* | [**archive_image_grid**](docs/ImageGridApi.md#archive_image_grid) | **DELETE** /v2/imageGrid/{id} | Archive image
*ImageGridApi* | [**create_image_grid**](docs/ImageGridApi.md#create_image_grid) | **POST** /v2/imageGrid | Create image
*ImageGridApi* | [**fetch_all_image_grid**](docs/ImageGridApi.md#fetch_all_image_grid) | **GET** /v2/imageGrid/all | Fetch all images
*ImageGridApi* | [**restore_image_grid**](docs/ImageGridApi.md#restore_image_grid) | **PATCH** /v2/imageGrid/{id} | Restore image
*ImageGridApi* | [**update_image_grid**](docs/ImageGridApi.md#update_image_grid) | **PUT** /v2/imageGrid/{id} | Update image
*IndustriesApi* | [**fetch_all_industries**](docs/IndustriesApi.md#fetch_all_industries) | **GET** /system/industries/all | Fetch all industries
*InfoGenesisReportsApi* | [**count_ad_credits_redemptions**](docs/InfoGenesisReportsApi.md#count_ad_credits_redemptions) | **POST** /v2/pos/infogenesis/count/adCredits/redemptions | Count redeemed ad credits
*InfoGenesisReportsApi* | [**count_ad_credits_refunds**](docs/InfoGenesisReportsApi.md#count_ad_credits_refunds) | **POST** /v2/pos/infogenesis/count/adCredits/refunds | Count refunded ad credits
*InfoGenesisReportsApi* | [**count_dynamic_voucher_redemptions**](docs/InfoGenesisReportsApi.md#count_dynamic_voucher_redemptions) | **POST** /v2/pos/infogenesis/count/dynamicVoucher/redemptions | Count dynamic voucher redemptions
*InfoGenesisReportsApi* | [**count_dynamic_voucher_refunds**](docs/InfoGenesisReportsApi.md#count_dynamic_voucher_refunds) | **POST** /v2/pos/infogenesis/count/dynamicVoucher/refunds | Count dynamic voucher refunds
*InfoGenesisReportsApi* | [**count_membership_points_redemptions**](docs/InfoGenesisReportsApi.md#count_membership_points_redemptions) | **POST** /v2/pos/infogenesis/count/membershipPoints/redemptions | Count redeemed membership points
*InfoGenesisReportsApi* | [**count_membership_points_refunds**](docs/InfoGenesisReportsApi.md#count_membership_points_refunds) | **POST** /v2/pos/infogenesis/count/membershipPoints/refunds | Count refunded membership points
*InfoGenesisReportsApi* | [**count_membership_tier_redemptions**](docs/InfoGenesisReportsApi.md#count_membership_tier_redemptions) | **POST** /v2/pos/infogenesis/count/membershipTier/redemptions | Count tier redemptions
*InfoGenesisReportsApi* | [**count_membership_tier_refunds**](docs/InfoGenesisReportsApi.md#count_membership_tier_refunds) | **POST** /v2/pos/infogenesis/count/membershipTier/refunds | Count tier refunds
*InfoGenesisReportsApi* | [**count_merchant_credit_redemptions**](docs/InfoGenesisReportsApi.md#count_merchant_credit_redemptions) | **POST** /v2/pos/infogenesis/count/merchantCredit/redemptions | Count redeemed merchant credits
*InfoGenesisReportsApi* | [**count_merchant_credit_refunds**](docs/InfoGenesisReportsApi.md#count_merchant_credit_refunds) | **POST** /v2/pos/infogenesis/count/merchantCredit/refunds | Count refunded merchant credits
*InfoGenesisReportsApi* | [**count_static_voucher_redemptions**](docs/InfoGenesisReportsApi.md#count_static_voucher_redemptions) | **POST** /v2/pos/infogenesis/count/staticVoucher/redemptions | Count static voucher redemptions
*InfoGenesisReportsApi* | [**count_static_voucher_refunds**](docs/InfoGenesisReportsApi.md#count_static_voucher_refunds) | **POST** /v2/pos/infogenesis/count/staticVoucher/refunds | Count static voucher refunds
*InfoGenesisReportsApi* | [**fetch_info_genesis_authorizations**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_authorizations) | **POST** /v2/pos/infogenesis/authorizations | Fetch InfoGenesis authorizations
*InfoGenesisReportsApi* | [**fetch_info_genesis_campaign_data**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_campaign_data) | **POST** /v2/pos/infogenesis/campaign | Fetch campaign information
*InfoGenesisReportsApi* | [**fetch_info_genesis_lookup_requests**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_lookup_requests) | **POST** /v2/pos/infogenesis/requests/lookup | Fetch InfoGenesis lookup requests
*InfoGenesisReportsApi* | [**fetch_info_genesis_lookup_requests_errors**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_lookup_requests_errors) | **POST** /v2/pos/infogenesis/requests/lookup/errors | Fetch InfoGenesis lookup request errors
*InfoGenesisReportsApi* | [**fetch_info_genesis_redeemed_static_vouchers**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_redeemed_static_vouchers) | **POST** /v2/pos/infogenesis/staticVouchers/redeemed | Fetch redeemed static vouchers
*InfoGenesisReportsApi* | [**fetch_info_genesis_redeemed_unique_posting_ids**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_redeemed_unique_posting_ids) | **GET** /v2/pos/infogenesis/postingIDs/redeemed | Fetch redeemed InfoGenesis unique posting IDs
*InfoGenesisReportsApi* | [**fetch_info_genesis_redemptions**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_redemptions) | **POST** /v2/pos/infogenesis/redemptions | Fetch InfoGenesis redemptions
*InfoGenesisReportsApi* | [**fetch_info_genesis_refunded_routing_ids**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_refunded_routing_ids) | **POST** /v2/pos/infogenesis/routingIDs/refunded | Fetch refunded InfoGenesis unique posting IDs
*InfoGenesisReportsApi* | [**fetch_info_genesis_refunded_static_vouchers**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_refunded_static_vouchers) | **POST** /v2/pos/infogenesis/staticVouchers/refunded | Fetch refunded static vouchers
*InfoGenesisReportsApi* | [**fetch_info_genesis_refunds**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_refunds) | **POST** /v2/pos/infogenesis/refunds | Fetch InfoGenesis refunds
*InfoGenesisReportsApi* | [**fetch_info_genesis_request**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_request) | **GET** /v2/pos/infogenesis/request/{transactionID} | Fetch InfoGenesis request with transaction ID
*InfoGenesisReportsApi* | [**fetch_info_genesis_requests**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_requests) | **POST** /v2/pos/infogenesis/requests | Fetch InfoGenesis requests with routing IDs
*InfoGenesisReportsApi* | [**fetch_info_genesis_response_errors**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_response_errors) | **GET** /v2/pos/infogenesis/responses/errors | Fetch InfoGenesis response errors
*InfoGenesisReportsApi* | [**fetch_info_genesis_responses**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_responses) | **POST** /v2/pos/infogenesis/responses | Fetch InfoGenesis responses with routing IDs
*InfoGenesisReportsApi* | [**fetch_info_genesis_transactions_with_unique_posting_ids**](docs/InfoGenesisReportsApi.md#fetch_info_genesis_transactions_with_unique_posting_ids) | **POST** /v2/pos/infogenesis/transactions | Fetch InfoGenesis transactions
*IntegratedTerminalsApi* | [**archive_pos_machine**](docs/IntegratedTerminalsApi.md#archive_pos_machine) | **DELETE** /v2/pos/machine/{id} | Archive POS machine
*IntegratedTerminalsApi* | [**create_pos_machine**](docs/IntegratedTerminalsApi.md#create_pos_machine) | **POST** /v2/pos/machine | Create POS machine
*IntegratedTerminalsApi* | [**fetch_all_pos_machines**](docs/IntegratedTerminalsApi.md#fetch_all_pos_machines) | **GET** /v2/pos/machine/all | Fetch all POS machines
*IntegratedTerminalsApi* | [**restore_pos_machine**](docs/IntegratedTerminalsApi.md#restore_pos_machine) | **PATCH** /v2/pos/machine/{id} | Restore POS machine
*IntegratedTerminalsApi* | [**update_pos_machine**](docs/IntegratedTerminalsApi.md#update_pos_machine) | **PUT** /v2/pos/machine/{id} | Update POS machine
*InteractionsApi* | [**create_advertisement_credit_scan**](docs/InteractionsApi.md#create_advertisement_credit_scan) | **POST** /wallet/advertisementCredit/scan/{adCreditID} | Create ad credit scan
*InteractionsApi* | [**create_employee_v_card**](docs/InteractionsApi.md#create_employee_v_card) | **GET** /wallet/employee/vcard/{id} | Fetch an employee&#39;s VCard
*InteractionsApi* | [**create_ics_file**](docs/InteractionsApi.md#create_ics_file) | **GET** /wallet/liveevent/ics/{id} | Fetch ICS for live event
*InteractionsApi* | [**fetch_all_static_vouchers_associated_with_customer_with_voucher_id**](docs/InteractionsApi.md#fetch_all_static_vouchers_associated_with_customer_with_voucher_id) | **GET** /wallet/staticVoucher/all | Fetch a customer&#39;s static vouchers on the basis of a given voucher ID
*InteractionsApi* | [**fetch_dynamic_voucher_with_voucher_id**](docs/InteractionsApi.md#fetch_dynamic_voucher_with_voucher_id) | **GET** /wallet/dynamicVoucher/{voucherID} | Fetch dynamic voucher
*InteractionsApi* | [**fetch_member_information**](docs/InteractionsApi.md#fetch_member_information) | **GET** /wallet/member | Fetch member information
*InteractionsApi* | [**fetch_static_voucher_with_voucher_id**](docs/InteractionsApi.md#fetch_static_voucher_with_voucher_id) | **GET** /wallet/staticVoucher/{voucherID} | Fetch static voucher
*InteractionsApi* | [**fetch_wallet_page_with_token**](docs/InteractionsApi.md#fetch_wallet_page_with_token) | **POST** /wallet/page/token | Fetch page with token NOTE: This route exists because a token can completely change the dataset returned to the client. A simple fetch just logs the token with the request, but a fetchWithToken request can have a very different object returned to the client.
*InteractionsApi* | [**fetch_wallet_payment_object_with_token**](docs/InteractionsApi.md#fetch_wallet_payment_object_with_token) | **POST** /wallet/paymentObject/token | Fetch payment object with token NOTE: This route exists because a token can completely change the dataset returned to the client. A simple fetch just logs the token with the request, but a fetchWithToken request can have a very different object returned to the client.
*InteractionsApi* | [**find_by_vanity_handle**](docs/InteractionsApi.md#find_by_vanity_handle) | **GET** /wallet/vanityHandle/{handle} | Fetch vanity handle
*InteractionsApi* | [**identify_item**](docs/InteractionsApi.md#identify_item) | **GET** /wallet/item/identify/{itemID} | Identify item
*LinkBookApi* | [**archive_link_book**](docs/LinkBookApi.md#archive_link_book) | **DELETE** /v2/linkBook/{id} | Archive link
*LinkBookApi* | [**create_link_book**](docs/LinkBookApi.md#create_link_book) | **POST** /v2/linkBook | Create link
*LinkBookApi* | [**fetch_all_link_book**](docs/LinkBookApi.md#fetch_all_link_book) | **GET** /v2/linkBook/all | Fetch all links
*LinkBookApi* | [**fetch_link_book_by_id**](docs/LinkBookApi.md#fetch_link_book_by_id) | **GET** /v2/linkBook/{id} | Fetch link book by id
*LinkBookApi* | [**restore_link_book**](docs/LinkBookApi.md#restore_link_book) | **PATCH** /v2/linkBook/{id} | Restore link
*LinkBookApi* | [**update_link_book**](docs/LinkBookApi.md#update_link_book) | **PUT** /v2/linkBook/{id} | Update link
*LinkBookSectionApi* | [**archive_link_book_section**](docs/LinkBookSectionApi.md#archive_link_book_section) | **DELETE** /v2/linkBookSection/{id} | Archive link book section
*LinkBookSectionApi* | [**create_link_book_section**](docs/LinkBookSectionApi.md#create_link_book_section) | **POST** /v2/linkBookSection | Create link book section
*LinkBookSectionApi* | [**fetch_all_link_book_sections**](docs/LinkBookSectionApi.md#fetch_all_link_book_sections) | **GET** /v2/linkBookSection/all | Fetch all link book sections
*LinkBookSectionApi* | [**restore_link_book_section**](docs/LinkBookSectionApi.md#restore_link_book_section) | **PATCH** /v2/linkBookSection/{id} | Restore link book section
*LinkBookSectionApi* | [**update_link_book_section**](docs/LinkBookSectionApi.md#update_link_book_section) | **PUT** /v2/linkBookSection/{id} | Update link book section
*LoginAndLogoutApi* | [**login**](docs/LoginAndLogoutApi.md#login) | **POST** /authentication/login | Login
*LoginAndLogoutApi* | [**login_status**](docs/LoginAndLogoutApi.md#login_status) | **GET** /authentication/status/{token} | Retrieve status of session token
*LoginAndLogoutApi* | [**logout**](docs/LoginAndLogoutApi.md#logout) | **DELETE** /authentication/logout | Logout
*MembershipTiersApi* | [**archive_membership_tier**](docs/MembershipTiersApi.md#archive_membership_tier) | **DELETE** /v2/membership/tier/{id} | Archive tier
*MembershipTiersApi* | [**create_membership_tier**](docs/MembershipTiersApi.md#create_membership_tier) | **POST** /v2/membership/tier | Create tier
*MembershipTiersApi* | [**fetch_all_membership_tiers**](docs/MembershipTiersApi.md#fetch_all_membership_tiers) | **GET** /v2/membership/tier/all | Fetch all tiers
*MembershipTiersApi* | [**fetch_all_membership_tiers_with_member_count**](docs/MembershipTiersApi.md#fetch_all_membership_tiers_with_member_count) | **GET** /v2/membership/tier/allWithMemberCount | Fetch all tiers with member count
*MembershipTiersApi* | [**fetch_membership_tier_by_id**](docs/MembershipTiersApi.md#fetch_membership_tier_by_id) | **GET** /v2/membership/tier/{id} | Fetch tier
*MembershipTiersApi* | [**fetch_membership_tier_history_log**](docs/MembershipTiersApi.md#fetch_membership_tier_history_log) | **POST** /v2/membership/tier/history/log | Fetch history
*MembershipTiersApi* | [**fetch_membership_tier_redemption_log**](docs/MembershipTiersApi.md#fetch_membership_tier_redemption_log) | **POST** /v2/membership/tier/redemption/log | Fetch redemption log
*MembershipTiersApi* | [**restore_membership_tier**](docs/MembershipTiersApi.md#restore_membership_tier) | **PATCH** /v2/membership/tier/{id} | Restore tier
*MembershipTiersApi* | [**update_membership_tier**](docs/MembershipTiersApi.md#update_membership_tier) | **PUT** /v2/membership/tier/{id} | Update tier
*MerchantApi* | [**archive_merchant_profile**](docs/MerchantApi.md#archive_merchant_profile) | **DELETE** /v2/merchant/delete | Archive Merchant
*MerchantApi* | [**archive_payment_object_broadcast**](docs/MerchantApi.md#archive_payment_object_broadcast) | **DELETE** /v2/merchant/paymentObjectBroadcast/{broadcastID} | Archive payment object broadcast
*MerchantApi* | [**count_inbound_sms**](docs/MerchantApi.md#count_inbound_sms) | **GET** /v2/merchant/sms/inbound/count/{phoneNumberID} | Count inbound SMSes
*MerchantApi* | [**export_inbound_messages**](docs/MerchantApi.md#export_inbound_messages) | **PUT** /v2/merchant/sms/inbound/export/{phoneNumberID} | Export inbound messages
*MerchantApi* | [**export_outbound_messages**](docs/MerchantApi.md#export_outbound_messages) | **PUT** /v2/merchant/sms/outbound/export/{phoneNumberID} | Export outbound messages
*MerchantApi* | [**fetch_advertisement_credit_broadcasts**](docs/MerchantApi.md#fetch_advertisement_credit_broadcasts) | **GET** /v2/merchant/broadcasts/adCredits/all | Fetch all ad credit broadcasts
*MerchantApi* | [**fetch_custom_roles**](docs/MerchantApi.md#fetch_custom_roles) | **GET** /v2/merchant/roles/custom | Fetch custom roles
*MerchantApi* | [**fetch_dynamic_voucher_broadcasts**](docs/MerchantApi.md#fetch_dynamic_voucher_broadcasts) | **GET** /v2/merchant/broadcasts/dynamicVouchers/all | Fetch all dynamic voucher broadcasts
*MerchantApi* | [**fetch_employees**](docs/MerchantApi.md#fetch_employees) | **GET** /v2/merchant/employees/all | Fetch all employees
*MerchantApi* | [**fetch_help_desk_requests**](docs/MerchantApi.md#fetch_help_desk_requests) | **GET** /v2/merchant/helpDeskRequests/{phoneNumberID} | Fetch help desk requests
*MerchantApi* | [**fetch_imported_list**](docs/MerchantApi.md#fetch_imported_list) | **GET** /v2/merchant/lists/imported/{listID} | Fetch imported list
*MerchantApi* | [**fetch_imported_lists**](docs/MerchantApi.md#fetch_imported_lists) | **GET** /v2/merchant/lists/imported/all | Fetch all imported lists
*MerchantApi* | [**fetch_inbound_sms**](docs/MerchantApi.md#fetch_inbound_sms) | **GET** /v2/merchant/sms/inbound/{phoneNumberID} | Fetch inbound SMSes
*MerchantApi* | [**fetch_inbound_smsby_page**](docs/MerchantApi.md#fetch_inbound_smsby_page) | **GET** /v2/merchant/sms/inbound/page/{phoneNumberID} | Fetch inbound SMSes by page
*MerchantApi* | [**fetch_merchant_outbound_sms**](docs/MerchantApi.md#fetch_merchant_outbound_sms) | **GET** /v2/merchant/sms/outbound/{phoneNumberID} | Fetch outbound SMSes
*MerchantApi* | [**fetch_merchant_phone_numbers**](docs/MerchantApi.md#fetch_merchant_phone_numbers) | **GET** /v2/merchant/phoneNumbers/all | Fetch all phone numbers
*MerchantApi* | [**fetch_opt_in_list**](docs/MerchantApi.md#fetch_opt_in_list) | **GET** /v2/merchant/lists/optIn/{listID} | Fetch opt in list
*MerchantApi* | [**fetch_opt_in_lists**](docs/MerchantApi.md#fetch_opt_in_lists) | **GET** /v2/merchant/lists/optIn/all | Fetch all opt in lists
*MerchantApi* | [**fetch_phone_number**](docs/MerchantApi.md#fetch_phone_number) | **GET** /v2/merchant/phoneNumber/{phoneNumberID} | Fetch phone number
*MerchantApi* | [**fetch_public_employees**](docs/MerchantApi.md#fetch_public_employees) | **GET** /v2/merchant/employees/public | Fetch public representative employees of the merchant
*MerchantApi* | [**fetch_simple_sms_broadcasts**](docs/MerchantApi.md#fetch_simple_sms_broadcasts) | **GET** /v2/merchant/broadcasts/simpleSMS/all | Fetch all simple SMS broadcasts
*MerchantApi* | [**fetch_static_voucher_campaign_broadcasts**](docs/MerchantApi.md#fetch_static_voucher_campaign_broadcasts) | **GET** /v2/merchant/broadcasts/staticVoucherCampaign/all | Fetch all static voucher campaign broadcasts
*MerchantApi* | [**fetch_tcpa_filter**](docs/MerchantApi.md#fetch_tcpa_filter) | **GET** /v2/merchant/tcpa/filter/all | Fetch all TCPA Filters
*MerchantApi* | [**fetch_wallet_configuration**](docs/MerchantApi.md#fetch_wallet_configuration) | **GET** /v2/merchant/wallet/configuration | Fetch wallet configuration
*MerchantApi* | [**update_billing_contact**](docs/MerchantApi.md#update_billing_contact) | **PUT** /v2/merchant/billing/contact | Update billing contact
*MerchantApi* | [**update_merchant**](docs/MerchantApi.md#update_merchant) | **PUT** /v2/merchant | Update merchant details
*MerchantApi* | [**update_pos_integration**](docs/MerchantApi.md#update_pos_integration) | **PUT** /v2/merchant/pos/integration | Update POS Integration
*MerchantCreditsApi* | [**archive_merchant_credit**](docs/MerchantCreditsApi.md#archive_merchant_credit) | **DELETE** /v2/payment/merchantcredit/{id} | Archive merchant credit
*MerchantCreditsApi* | [**create_merchant_credit**](docs/MerchantCreditsApi.md#create_merchant_credit) | **POST** /v2/payment/merchantcredit | Create merchant credit
*MerchantCreditsApi* | [**fetch_merchant_credit_by_id**](docs/MerchantCreditsApi.md#fetch_merchant_credit_by_id) | **GET** /v2/payment/merchantcredit/{id} | Fetch merchant credit
*MerchantCreditsApi* | [**fetch_merchant_credit_count**](docs/MerchantCreditsApi.md#fetch_merchant_credit_count) | **GET** /v2/payment/merchantcredit/count | Fetch all active merchant credits
*MerchantCreditsApi* | [**fetch_merchant_credit_history_log**](docs/MerchantCreditsApi.md#fetch_merchant_credit_history_log) | **POST** /v2/payment/merchantcredit/history/log | Fetch history
*MerchantCreditsApi* | [**fetch_merchant_credit_redemption_log**](docs/MerchantCreditsApi.md#fetch_merchant_credit_redemption_log) | **POST** /v2/payment/merchantcredit/redemption/log | Fetch redemption log
*MerchantCreditsApi* | [**fetch_merchant_credits_by_page**](docs/MerchantCreditsApi.md#fetch_merchant_credits_by_page) | **POST** /v2/payment/merchantcredit/page | Fetch merchant credits by page
*MerchantCreditsApi* | [**restore_merchant_credit**](docs/MerchantCreditsApi.md#restore_merchant_credit) | **PATCH** /v2/payment/merchantcredit/{id} | Restore merchant credit
*MerchantCreditsApi* | [**search_merchant_credits**](docs/MerchantCreditsApi.md#search_merchant_credits) | **POST** /v2/payment/merchantcredit/search | Search for merchant credits
*MerchantCreditsApi* | [**update_merchant_credit**](docs/MerchantCreditsApi.md#update_merchant_credit) | **PUT** /v2/payment/merchantcredit/{id} | Update merchant credit
*MerchantURLsApi* | [**archive_merchant_url**](docs/MerchantURLsApi.md#archive_merchant_url) | **DELETE** /v2/business/merchantUrl/{id} | Archive merchant url
*MerchantURLsApi* | [**create_merchant_url**](docs/MerchantURLsApi.md#create_merchant_url) | **POST** /v2/business/merchantUrl | Create merchant url
*MerchantURLsApi* | [**fetch_all_merchant_urls**](docs/MerchantURLsApi.md#fetch_all_merchant_urls) | **GET** /v2/business/merchantUrl/all | Fetch all merchant urls
*MerchantURLsApi* | [**fetch_merchant_url**](docs/MerchantURLsApi.md#fetch_merchant_url) | **GET** /v2/business/merchantUrl/{id} | Fetch merchant url
*MerchantURLsApi* | [**fetch_merchant_url_requests**](docs/MerchantURLsApi.md#fetch_merchant_url_requests) | **GET** /v2/business/merchantUrl/requests/{id} | Fetch requests
*MerchantURLsApi* | [**restore_merchant_url**](docs/MerchantURLsApi.md#restore_merchant_url) | **PATCH** /v2/business/merchantUrl/{id} | Restore merchant url
*MerchantURLsApi* | [**update_merchant_url**](docs/MerchantURLsApi.md#update_merchant_url) | **PUT** /v2/business/merchantUrl/{id} | Update merchant url
*MobileTerminalApi* | [**fetch_wallet_item_from_mobile_terminal**](docs/MobileTerminalApi.md#fetch_wallet_item_from_mobile_terminal) | **GET** /v2/pos/mobile/item/{itemID} | Fetch item
*MobileTerminalApi* | [**find_member_by_id**](docs/MobileTerminalApi.md#find_member_by_id) | **GET** /v2/pos/mobile/member/{memberID} | Find member
*MobileTerminalApi* | [**redeem_wallet_item_from_mobile_terminal**](docs/MobileTerminalApi.md#redeem_wallet_item_from_mobile_terminal) | **POST** /v2/pos/mobile/item/redeem/{itemID} | Redeem item
*NewsApi* | [**archive_news_article**](docs/NewsApi.md#archive_news_article) | **DELETE** /v2/news/{id} | Archive news article
*NewsApi* | [**create_news_article**](docs/NewsApi.md#create_news_article) | **POST** /v2/news | Create news article
*NewsApi* | [**fetch_all_news_articles**](docs/NewsApi.md#fetch_all_news_articles) | **GET** /v2/news/all | Fetch all news articles
*NewsApi* | [**restore_news_article**](docs/NewsApi.md#restore_news_article) | **PATCH** /v2/news/{id} | Restore news article
*NewsApi* | [**update_news_article**](docs/NewsApi.md#update_news_article) | **PUT** /v2/news/{id} | Update news article
*PaymentDesignsApi* | [**archive_payment_design**](docs/PaymentDesignsApi.md#archive_payment_design) | **DELETE** /v2/payment/design/{id} | Archive payment design
*PaymentDesignsApi* | [**create_payment_design**](docs/PaymentDesignsApi.md#create_payment_design) | **POST** /v2/payment/design | Create payment design
*PaymentDesignsApi* | [**fetch_all_payment_designs**](docs/PaymentDesignsApi.md#fetch_all_payment_designs) | **GET** /v2/payment/design/all | Fetch all active payment designs
*PaymentDesignsApi* | [**fetch_payment_design_by_id**](docs/PaymentDesignsApi.md#fetch_payment_design_by_id) | **GET** /v2/payment/design/{id} | Fetch payment design
*PaymentDesignsApi* | [**restore_payment_design**](docs/PaymentDesignsApi.md#restore_payment_design) | **PATCH** /v2/payment/design/{id} | Restore payment design
*PaymentDesignsApi* | [**update_payment_design**](docs/PaymentDesignsApi.md#update_payment_design) | **PUT** /v2/payment/design/{id} | Update payment design
*PerformancesApi* | [**archive_performance**](docs/PerformancesApi.md#archive_performance) | **DELETE** /v2/performances/{id} | Archive performance
*PerformancesApi* | [**create_performance**](docs/PerformancesApi.md#create_performance) | **POST** /v2/performances | Create performance
*PerformancesApi* | [**fetch_all_performances**](docs/PerformancesApi.md#fetch_all_performances) | **GET** /v2/performances/all | Fetch all performances
*PerformancesApi* | [**restore_performance**](docs/PerformancesApi.md#restore_performance) | **PATCH** /v2/performances/{id} | Restore performance
*PerformancesApi* | [**update_performance**](docs/PerformancesApi.md#update_performance) | **PUT** /v2/performances/{id} | Update performance
*PromoCodesApi* | [**archive_promo_code**](docs/PromoCodesApi.md#archive_promo_code) | **DELETE** /v2/promoCodes/{id} | Archive promo code
*PromoCodesApi* | [**create_promo_code**](docs/PromoCodesApi.md#create_promo_code) | **POST** /v2/promoCodes | Create promo code
*PromoCodesApi* | [**fetch_all_promo_codes**](docs/PromoCodesApi.md#fetch_all_promo_codes) | **GET** /v2/promoCodes/all | Fetch all promo codes
*PromoCodesApi* | [**restore_promo_code**](docs/PromoCodesApi.md#restore_promo_code) | **PATCH** /v2/promoCodes/{id} | Restore promo code
*PromoCodesApi* | [**update_promo_code**](docs/PromoCodesApi.md#update_promo_code) | **PUT** /v2/promoCodes/{id} | Update promo code
*SMSApi* | [**acquire_phone_number**](docs/SMSApi.md#acquire_phone_number) | **POST** /v2/sms/phoneNumber/acquire | Acquire phone number
*SMSApi* | [**archive_phone_number**](docs/SMSApi.md#archive_phone_number) | **DELETE** /v2/sms/phoneNumber/{phoneNumberID} | Archive phone number
*SMSApi* | [**archive_recipient**](docs/SMSApi.md#archive_recipient) | **DELETE** /v2/sms/importedList/recipients/{id} | Archive recipient
*SMSApi* | [**count_imported_list_recipients**](docs/SMSApi.md#count_imported_list_recipients) | **GET** /v2/sms/importedList/recipients/count/{listID} | Count imported list recipients
*SMSApi* | [**count_opt_in_list_subscribers**](docs/SMSApi.md#count_opt_in_list_subscribers) | **GET** /v2/sms/optInList/subscribers/count/{listID} | Count opt in list subscribers
*SMSApi* | [**count_opt_in_source_subscribers**](docs/SMSApi.md#count_opt_in_source_subscribers) | **GET** /v2/sms/optInSource/subscribers/count/{sourceID} | Count opt in source subscribers
*SMSApi* | [**count_outbound_sms**](docs/SMSApi.md#count_outbound_sms) | **GET** /v2/sms/outbound/count/{phoneNumberID} | Count outbound SMS
*SMSApi* | [**create_imported_list**](docs/SMSApi.md#create_imported_list) | **POST** /v2/sms/importedList | Create imported list
*SMSApi* | [**create_opt_in_list**](docs/SMSApi.md#create_opt_in_list) | **POST** /v2/sms/optInList | Create opt in list
*SMSApi* | [**create_opt_in_list_source**](docs/SMSApi.md#create_opt_in_list_source) | **POST** /v2/sms/optInListSource | Send SMS to opt in list
*SMSApi* | [**create_recipient_in_imported_list**](docs/SMSApi.md#create_recipient_in_imported_list) | **POST** /v2/sms/importedList/recipients/create | Add new recipient in an imported list
*SMSApi* | [**create_sms_agreement**](docs/SMSApi.md#create_sms_agreement) | **POST** /v2/sms/agreement/create | Accept SMS agreement
*SMSApi* | [**export_imported_list_recipients**](docs/SMSApi.md#export_imported_list_recipients) | **POST** /v2/sms/importedList/recipients/export/{importedListID} | Export imported list recipients
*SMSApi* | [**export_opt_in_list_subscribers**](docs/SMSApi.md#export_opt_in_list_subscribers) | **POST** /v2/sms/optInList/subscribers/export/{listID} | Export opt in list subscribers
*SMSApi* | [**fetch_blocked_tcpa_entries**](docs/SMSApi.md#fetch_blocked_tcpa_entries) | **GET** /v2/sms/phoneNumber/blocked/{phoneNumberID} | Fetch blocked TCPA entries
*SMSApi* | [**fetch_imported_list_recipients**](docs/SMSApi.md#fetch_imported_list_recipients) | **GET** /v2/sms/importedList/recipients/{listID} | Fetch imported list recipients
*SMSApi* | [**fetch_imported_list_recipients_by_page**](docs/SMSApi.md#fetch_imported_list_recipients_by_page) | **GET** /v2/sms/importedList/recipients/page/{listID} | Fetch imported list recipients by page
*SMSApi* | [**fetch_opt_in_list_sources**](docs/SMSApi.md#fetch_opt_in_list_sources) | **GET** /v2/sms/optInListSources/all | Fetch all opt in list sources
*SMSApi* | [**fetch_opt_in_list_subscribers**](docs/SMSApi.md#fetch_opt_in_list_subscribers) | **GET** /v2/sms/optInList/subscribers/{listID} | Fetch opt in list subscribers
*SMSApi* | [**fetch_opt_in_list_subscribers_by_page**](docs/SMSApi.md#fetch_opt_in_list_subscribers_by_page) | **GET** /v2/sms/optInList/subscribers/page/{listID} | Fetch opt in list subscribers by page
*SMSApi* | [**fetch_opt_in_lists_associated_with_phone_number**](docs/SMSApi.md#fetch_opt_in_lists_associated_with_phone_number) | **GET** /v2/sms/phoneNumber/lists/{phoneNumberID} | Fetch opt in lists
*SMSApi* | [**fetch_opt_in_source_subscribers**](docs/SMSApi.md#fetch_opt_in_source_subscribers) | **GET** /v2/sms/optInSource/subscribers/{sourceID} | Fetch opt in source subscribers
*SMSApi* | [**fetch_opt_in_sources_associated_with_phone_number**](docs/SMSApi.md#fetch_opt_in_sources_associated_with_phone_number) | **GET** /v2/sms/phoneNumber/sources/{phoneNumberID} | Fetch opt in sources
*SMSApi* | [**fetch_outbound_sms**](docs/SMSApi.md#fetch_outbound_sms) | **GET** /v2/sms/outbound/{phoneNumberID} | Fetch outbound SMS
*SMSApi* | [**fetch_outbound_smsby_page**](docs/SMSApi.md#fetch_outbound_smsby_page) | **GET** /v2/sms/outbound/page/{phoneNumberID} | Fetch outbound SMSes by page
*SMSApi* | [**fetch_payment_object_broadcasts**](docs/SMSApi.md#fetch_payment_object_broadcasts) | **GET** /v2/sms/paymentObjectBroadcasts/{phoneNumberID} | Fetch payment object broadcasts
*SMSApi* | [**fetch_sms_agreement**](docs/SMSApi.md#fetch_sms_agreement) | **GET** /v2/sms/agreement | Fetch SMS agreement
*SMSApi* | [**import_imported_list_recipients**](docs/SMSApi.md#import_imported_list_recipients) | **POST** /v2/sms/importedList/recipients/import/{importedListID} | Import imported list recipients
*SMSApi* | [**import_imported_list_recipients_from_membership_tier**](docs/SMSApi.md#import_imported_list_recipients_from_membership_tier) | **POST** /v2/sms/importedList/recipients/import-from-tier | Import imported list recipients from a given membership tier
*SMSApi* | [**import_opt_in_list_subscribers**](docs/SMSApi.md#import_opt_in_list_subscribers) | **POST** /v2/sms/optInList/subscribers/import/{listID} | Import opt in list subscribers
*SMSApi* | [**restore_phone_number**](docs/SMSApi.md#restore_phone_number) | **PATCH** /v2/sms/phoneNumber/{phoneNumberID} | Restore phone number
*SMSApi* | [**restore_recipient**](docs/SMSApi.md#restore_recipient) | **PATCH** /v2/sms/importedList/recipients/{id} | Restore recipient
*SMSApi* | [**retrieve_sent_and_max_count_of_messages**](docs/SMSApi.md#retrieve_sent_and_max_count_of_messages) | **GET** /v2/sms/sent | Retrieve the number of messages sent by the merchant within the current billing cycle
*SMSApi* | [**save_imported_list**](docs/SMSApi.md#save_imported_list) | **PUT** /v2/sms/importedList/{listID} | Save imported list
*SMSApi* | [**save_opt_in_list**](docs/SMSApi.md#save_opt_in_list) | **PUT** /v2/sms/optInList/{listID} | Save opt in list
*SMSApi* | [**save_opt_in_list_source**](docs/SMSApi.md#save_opt_in_list_source) | **PUT** /v2/sms/optInListSource/{sourceID} | Save opt in list source
*SMSApi* | [**send_phone_number_for_verification**](docs/SMSApi.md#send_phone_number_for_verification) | **PUT** /v2/sms/phoneNumber/verification/{phoneNumberID} | Request phone number verification
*SMSApi* | [**update_phone_number**](docs/SMSApi.md#update_phone_number) | **PUT** /v2/sms/phoneNumber/{phoneNumberID} | Update phone number
*SettingsApi* | [**get_active_campaigns**](docs/SettingsApi.md#get_active_campaigns) | **GET** /v2/settings/campaigns/active | Get active campaigns
*SettingsApi* | [**get_vouchers_count**](docs/SettingsApi.md#get_vouchers_count) | **GET** /v2/settings/vouchers/count | Get vouchers count
*ShopifyTerminalApi* | [**fetch_wallet_item_from_shopify_terminal**](docs/ShopifyTerminalApi.md#fetch_wallet_item_from_shopify_terminal) | **GET** /v2/pos/shopify/item/{itemID} | Fetch item
*ShopifyTerminalApi* | [**redeem_wallet_item_from_shopify_terminal**](docs/ShopifyTerminalApi.md#redeem_wallet_item_from_shopify_terminal) | **POST** /v2/pos/shopify/item/redeem/{itemID} | Redeem item
*ShopifyTerminalApi* | [**refund_wallet_item_from_shopify_terminal**](docs/ShopifyTerminalApi.md#refund_wallet_item_from_shopify_terminal) | **POST** /v2/pos/shopify/item/refund/{ledgerEntryID} | Refund transaction
*StaticVoucherCampaignGroupsApi* | [**fetch_static_voucher_campaign_groups**](docs/StaticVoucherCampaignGroupsApi.md#fetch_static_voucher_campaign_groups) | **GET** /v2/payment/staticVoucherCampaignGroups/campaigns/{campaignsGroupID} | Fetch all campaigns
*StaticVoucherCampaignsApi* | [**count_vouchers_loaded**](docs/StaticVoucherCampaignsApi.md#count_vouchers_loaded) | **GET** /v2/payment/staticVoucherCampaign/count/vouchers/loaded/{campaignID} | Count loaded vouchers
*StaticVoucherCampaignsApi* | [**count_vouchers_redeemed**](docs/StaticVoucherCampaignsApi.md#count_vouchers_redeemed) | **GET** /v2/payment/staticVoucherCampaign/count/vouchers/redeemed/{campaignID} | Count redeemed vouchers
*StaticVoucherCampaignsApi* | [**create_static_voucher_campaign**](docs/StaticVoucherCampaignsApi.md#create_static_voucher_campaign) | **POST** /v2/payment/staticVoucherCampaign | Create static voucher campaign
*StaticVoucherCampaignsApi* | [**create_static_voucher_campaign_from_csv**](docs/StaticVoucherCampaignsApi.md#create_static_voucher_campaign_from_csv) | **POST** /v2/payment/staticVoucherCampaign/csv | Import static voucher campaign
*StaticVoucherCampaignsApi* | [**create_static_voucher_campaign_with_voucher**](docs/StaticVoucherCampaignsApi.md#create_static_voucher_campaign_with_voucher) | **POST** /v2/payment/staticVoucherCampaign/voucher | Create static voucher campaign with voucher
*StaticVoucherCampaignsApi* | [**duplicate_static_voucher_campaign_by_id**](docs/StaticVoucherCampaignsApi.md#duplicate_static_voucher_campaign_by_id) | **POST** /v2/payment/staticVoucherCampaign/duplicate/{campaignID} | Duplicate static voucher campaign
*StaticVoucherCampaignsApi* | [**fetch_performance_overview**](docs/StaticVoucherCampaignsApi.md#fetch_performance_overview) | **GET** /v2/payment/staticVoucherCampaign/overview/performance/{campaignID} | Fetch performance overview
*StaticVoucherCampaignsApi* | [**fetch_reach_stats_of_all_static_voucher_campaigns**](docs/StaticVoucherCampaignsApi.md#fetch_reach_stats_of_all_static_voucher_campaigns) | **GET** /v2/payment/staticVoucherCampaign/reach/all | Get the reach statistics of all the static voucher campaigns
*StaticVoucherCampaignsApi* | [**fetch_reach_stats_of_individual_static_voucher_campaign**](docs/StaticVoucherCampaignsApi.md#fetch_reach_stats_of_individual_static_voucher_campaign) | **GET** /v2/payment/staticVoucherCampaign/reach/{staticVoucherCampaignID} | Get the reach statistics of an individual static voucher campaign
*StaticVoucherCampaignsApi* | [**fetch_static_voucher_campaign_by_id**](docs/StaticVoucherCampaignsApi.md#fetch_static_voucher_campaign_by_id) | **GET** /v2/payment/staticVoucherCampaign/{id} | Fetch static voucher campaign
*StaticVoucherCampaignsApi* | [**fetch_static_voucher_campaigns**](docs/StaticVoucherCampaignsApi.md#fetch_static_voucher_campaigns) | **GET** /v2/payment/staticVoucherCampaign/all | Fetches all static vouchers campaigns
*StaticVoucherCampaignsApi* | [**fetch_static_vouchers**](docs/StaticVoucherCampaignsApi.md#fetch_static_vouchers) | **GET** /v2/payment/staticVoucherCampaign/staticVouchers/{campaignID} | Fetch static vouchers
*StaticVoucherCampaignsApi* | [**fetch_static_vouchers_page**](docs/StaticVoucherCampaignsApi.md#fetch_static_vouchers_page) | **GET** /v2/payment/staticVoucherCampaign/staticVouchers/page/{campaignID} | Fetch static vouchers by page
*StaticVoucherCampaignsApi* | [**fetch_views**](docs/StaticVoucherCampaignsApi.md#fetch_views) | **GET** /v2/payment/staticVoucherCampaign/views/{campaignID} | Fetch views
*StaticVoucherCampaignsApi* | [**fetch_vouchers_redeemed**](docs/StaticVoucherCampaignsApi.md#fetch_vouchers_redeemed) | **GET** /v2/payment/staticVoucherCampaign/vouchers/redeemed/{campaignID} | Fetch redeemed vouchers
*StaticVoucherCampaignsApi* | [**preview_messages**](docs/StaticVoucherCampaignsApi.md#preview_messages) | **PUT** /v2/payment/staticVoucherCampaign/preview/{campaignID} | Preview static vouchers. This method has been deprecated. Please use /preview/page/{campaignID} for better performance.
*StaticVoucherCampaignsApi* | [**preview_messages_by_page**](docs/StaticVoucherCampaignsApi.md#preview_messages_by_page) | **PUT** /v2/payment/staticVoucherCampaign/preview/page/{campaignID} | Preview static vouchers by page
*StaticVoucherCampaignsApi* | [**update_static_voucher_campaign**](docs/StaticVoucherCampaignsApi.md#update_static_voucher_campaign) | **PUT** /v2/payment/staticVoucherCampaign/{campaignID} | Update static voucher campaign
*StaticVoucherCampaignsApi* | [**update_static_voucher_campaign_with_voucher**](docs/StaticVoucherCampaignsApi.md#update_static_voucher_campaign_with_voucher) | **PUT** /v2/payment/staticVoucherCampaign/voucher/{campaignID} | Update static voucher campaign with voucher
*StaticVouchersApi* | [**create_static_voucher**](docs/StaticVouchersApi.md#create_static_voucher) | **POST** /v2/payment/staticVoucher | Create static voucher
*StaticVouchersApi* | [**delete_static_voucher**](docs/StaticVouchersApi.md#delete_static_voucher) | **DELETE** /v2/payment/staticVoucher/{id} | Delete static voucher
*StaticVouchersApi* | [**fetch_reach_stats_of_all_static_vouchers**](docs/StaticVouchersApi.md#fetch_reach_stats_of_all_static_vouchers) | **GET** /v2/payment/staticVoucher/reach/all | Get the reach statistics of all the static vouchers
*StaticVouchersApi* | [**fetch_reach_stats_of_individual_static_voucher**](docs/StaticVouchersApi.md#fetch_reach_stats_of_individual_static_voucher) | **GET** /v2/payment/staticVoucher/reach/{staticVoucherID} | Get the reach statistics of an individual static voucher
*StaticVouchersApi* | [**fetch_static_voucher**](docs/StaticVouchersApi.md#fetch_static_voucher) | **GET** /v2/payment/staticVoucher/{id} | Fetch static voucher
*StaticVouchersApi* | [**update_static_voucher**](docs/StaticVouchersApi.md#update_static_voucher) | **PUT** /v2/payment/staticVoucher/{id} | Update static voucher
*SystemApi* | [**create_role**](docs/SystemApi.md#create_role) | **POST** /v2/system/roles | Create role
*SystemApi* | [**delete_role**](docs/SystemApi.md#delete_role) | **DELETE** /v2/system/roles/{roleID} | Delete role
*SystemApi* | [**fetch_audit_log_of_roles**](docs/SystemApi.md#fetch_audit_log_of_roles) | **GET** /v2/system/roles/auditLog | Fetch role&#39;s audit log
*SystemApi* | [**fetch_employees_with_role**](docs/SystemApi.md#fetch_employees_with_role) | **GET** /v2/system/roles/employees/{roleID} | Fetch employees with role
*SystemApi* | [**fetch_webpages_for_role**](docs/SystemApi.md#fetch_webpages_for_role) | **GET** /v2/system/roles/webpages/{roleID} | Fetch webpages for role
*SystemApi* | [**load_role**](docs/SystemApi.md#load_role) | **GET** /v2/system/roles/{roleID} | Fetch role
*SystemApi* | [**save_role**](docs/SystemApi.md#save_role) | **PUT** /v2/system/roles/{roleID} | Update role
*TransactionLedgerApi* | [**fetch_all_ledger_transactions**](docs/TransactionLedgerApi.md#fetch_all_ledger_transactions) | **GET** /v2/pos/ledger/transactions/all | Fetch ledger transactions by page
*UtilitiesApi* | [**get_payment_prefixes**](docs/UtilitiesApi.md#get_payment_prefixes) | **GET** /v2/payment/prefixes | Get payment prefixes
*WebTerminalApi* | [**fetch_wallet_item_from_web_terminal**](docs/WebTerminalApi.md#fetch_wallet_item_from_web_terminal) | **GET** /v2/pos/web/item/{itemID} | Fetch item
*WebTerminalApi* | [**redeem_wallet_item_from_web_terminal**](docs/WebTerminalApi.md#redeem_wallet_item_from_web_terminal) | **POST** /v2/pos/web/item/redeem/{itemID} | Redeem item
*WebTerminalApi* | [**refund_wallet_item_from_web_terminal**](docs/WebTerminalApi.md#refund_wallet_item_from_web_terminal) | **POST** /v2/pos/web/item/refund/{ledgerEntryID} | Refund transaction
*WixTerminalApi* | [**fetch_wallet_item_from_wix_terminal**](docs/WixTerminalApi.md#fetch_wallet_item_from_wix_terminal) | **GET** /v2/pos/wix/item/{itemID} | Fetch item
*WixTerminalApi* | [**redeem_wallet_item_from_wix_terminal**](docs/WixTerminalApi.md#redeem_wallet_item_from_wix_terminal) | **POST** /v2/pos/wix/item/redeem/{itemID} | Redeem item
*WixTerminalApi* | [**refund_wallet_item_from_wix_terminal**](docs/WixTerminalApi.md#refund_wallet_item_from_wix_terminal) | **POST** /v2/pos/wix/item/refund/{ledgerEntryID} | Refund transaction
*WooCommerceTerminalApi* | [**fetch_wallet_item_from_woo_commerce_terminal**](docs/WooCommerceTerminalApi.md#fetch_wallet_item_from_woo_commerce_terminal) | **GET** /v2/pos/woocommerce/item/{itemID} | Fetch item
*WooCommerceTerminalApi* | [**redeem_wallet_item_from_woo_commerce_terminal**](docs/WooCommerceTerminalApi.md#redeem_wallet_item_from_woo_commerce_terminal) | **POST** /v2/pos/woocommerce/item/redeem/{itemID} | Redeem item
*WooCommerceTerminalApi* | [**refund_wallet_item_from_woo_commerce_terminal**](docs/WooCommerceTerminalApi.md#refund_wallet_item_from_woo_commerce_terminal) | **POST** /v2/pos/woocommerce/item/refund/{ledgerEntryID} | Refund transaction


## Documentation For Models

 - [AdvertisementCredit](docs/AdvertisementCredit.md)
 - [AdvertisementCreditBroadcast](docs/AdvertisementCreditBroadcast.md)
 - [AdvertisementCreditScan](docs/AdvertisementCreditScan.md)
 - [Agreement](docs/Agreement.md)
 - [Alert](docs/Alert.md)
 - [Announcement](docs/Announcement.md)
 - [ApplicableTerminals](docs/ApplicableTerminals.md)
 - [ApplicableTerminalsAnyOf](docs/ApplicableTerminalsAnyOf.md)
 - [ApplicableTerminalsAnyOf1](docs/ApplicableTerminalsAnyOf1.md)
 - [ApplicableTerminalsAnyOf2](docs/ApplicableTerminalsAnyOf2.md)
 - [ApplicableTerminalsAnyOf3](docs/ApplicableTerminalsAnyOf3.md)
 - [ApplicableTerminalsAnyOf4](docs/ApplicableTerminalsAnyOf4.md)
 - [ApplicableTerminalsAnyOf5](docs/ApplicableTerminalsAnyOf5.md)
 - [ApplicableTerminalsAnyOf6](docs/ApplicableTerminalsAnyOf6.md)
 - [AuthError](docs/AuthError.md)
 - [AvailablePhoneNumbersRequest](docs/AvailablePhoneNumbersRequest.md)
 - [ClickFunnelAmount](docs/ClickFunnelAmount.md)
 - [ClickFunnelContact](docs/ClickFunnelContact.md)
 - [ClickFunnelContactProfile](docs/ClickFunnelContactProfile.md)
 - [ClickFunnelEvent](docs/ClickFunnelEvent.md)
 - [ClickFunnelOriginalAmount](docs/ClickFunnelOriginalAmount.md)
 - [ClickFunnelProduct](docs/ClickFunnelProduct.md)
 - [ClickFunnelPurchase](docs/ClickFunnelPurchase.md)
 - [ClickFunnelRegistration](docs/ClickFunnelRegistration.md)
 - [CreateStaticVoucherCampaign](docs/CreateStaticVoucherCampaign.md)
 - [CreateStaticVoucherCampaignWithVoucher](docs/CreateStaticVoucherCampaignWithVoucher.md)
 - [CreateStaticVoucherCampaignWithVoucherWithCSV](docs/CreateStaticVoucherCampaignWithVoucherWithCSV.md)
 - [DashboardWidget](docs/DashboardWidget.md)
 - [Document](docs/Document.md)
 - [DuplicateRowFound](docs/DuplicateRowFound.md)
 - [DynamicVoucher](docs/DynamicVoucher.md)
 - [DynamicVoucherBroadcast](docs/DynamicVoucherBroadcast.md)
 - [Employee](docs/Employee.md)
 - [EmployeeAPIKey](docs/EmployeeAPIKey.md)
 - [EmployeeActivityLog](docs/EmployeeActivityLog.md)
 - [EntityTooLarge](docs/EntityTooLarge.md)
 - [ExportDataFile](docs/ExportDataFile.md)
 - [FalsumError](docs/FalsumError.md)
 - [FalsumField](docs/FalsumField.md)
 - [Feature](docs/Feature.md)
 - [ForbiddenRequest](docs/ForbiddenRequest.md)
 - [ForeignKeyDoesNotExist](docs/ForeignKeyDoesNotExist.md)
 - [HelpDeskRequest](docs/HelpDeskRequest.md)
 - [ImageGrid](docs/ImageGrid.md)
 - [ImportedList](docs/ImportedList.md)
 - [ImportedListRecipient](docs/ImportedListRecipient.md)
 - [InboundSMS](docs/InboundSMS.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse20010](docs/InlineResponse20010.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse2006](docs/InlineResponse2006.md)
 - [InlineResponse2007](docs/InlineResponse2007.md)
 - [InlineResponse2008](docs/InlineResponse2008.md)
 - [InlineResponse2009](docs/InlineResponse2009.md)
 - [InternalServerError](docs/InternalServerError.md)
 - [LedgerEntry](docs/LedgerEntry.md)
 - [LinkBook](docs/LinkBook.md)
 - [LinkBookSection](docs/LinkBookSection.md)
 - [MSAnalyticsMemberCountPartitionedByDate](docs/MSAnalyticsMemberCountPartitionedByDate.md)
 - [MSAnalyticsMemberPointsRedeemedPartitionedByDate](docs/MSAnalyticsMemberPointsRedeemedPartitionedByDate.md)
 - [MSAnalyticsMemberPointsRefundedPartitionedByDate](docs/MSAnalyticsMemberPointsRefundedPartitionedByDate.md)
 - [MSAnalyticsMembershipTierAmountRedeemedPartitionedByDate](docs/MSAnalyticsMembershipTierAmountRedeemedPartitionedByDate.md)
 - [MSAnalyticsMembershipTierAmountRefundedPartitionedByDate](docs/MSAnalyticsMembershipTierAmountRefundedPartitionedByDate.md)
 - [MSMemberHistory](docs/MSMemberHistory.md)
 - [MSMemberHistoryPagination](docs/MSMemberHistoryPagination.md)
 - [MSMemberRedemption](docs/MSMemberRedemption.md)
 - [MSMemberRedemptionPagination](docs/MSMemberRedemptionPagination.md)
 - [MSMembershipTierHistory](docs/MSMembershipTierHistory.md)
 - [MSMembershipTierHistoryPagination](docs/MSMembershipTierHistoryPagination.md)
 - [MSMembershipTierRedemption](docs/MSMembershipTierRedemption.md)
 - [MSMembershipTierRedemptionPagination](docs/MSMembershipTierRedemptionPagination.md)
 - [MSMerchantCreditHistory](docs/MSMerchantCreditHistory.md)
 - [MSMerchantCreditHistoryPagination](docs/MSMerchantCreditHistoryPagination.md)
 - [MSMerchantCreditRedemption](docs/MSMerchantCreditRedemption.md)
 - [MSMerchantCreditRedemptionPagination](docs/MSMerchantCreditRedemptionPagination.md)
 - [MSMerchantID](docs/MSMerchantID.md)
 - [MSNanoID](docs/MSNanoID.md)
 - [MSPrefixedNanoID](docs/MSPrefixedNanoID.md)
 - [MediaFile](docs/MediaFile.md)
 - [Member](docs/Member.md)
 - [MemberSearch](docs/MemberSearch.md)
 - [Merchant](docs/Merchant.md)
 - [MerchantCreditSearch](docs/MerchantCreditSearch.md)
 - [MerchantID](docs/MerchantID.md)
 - [MerchantNotInitialized](docs/MerchantNotInitialized.md)
 - [MerchantURL](docs/MerchantURL.md)
 - [Message](docs/Message.md)
 - [ModuleError](docs/ModuleError.md)
 - [NanoID](docs/NanoID.md)
 - [NewsArticle](docs/NewsArticle.md)
 - [OptInList](docs/OptInList.md)
 - [OptInListSource](docs/OptInListSource.md)
 - [OptInListSubscriber](docs/OptInListSubscriber.md)
 - [OutboundSMS](docs/OutboundSMS.md)
 - [PaginatedWTMembers](docs/PaginatedWTMembers.md)
 - [PaginatedWTMerchantCredits](docs/PaginatedWTMerchantCredits.md)
 - [PaginationRequestWithIDAndWithoutSortOptions](docs/PaginationRequestWithIDAndWithoutSortOptions.md)
 - [PaginationRequestWithSortOptions](docs/PaginationRequestWithSortOptions.md)
 - [PaymentDesign](docs/PaymentDesign.md)
 - [PaymentPrefixes](docs/PaymentPrefixes.md)
 - [Performance](docs/Performance.md)
 - [PhoneNumber](docs/PhoneNumber.md)
 - [PickCreateStaticVoucherCampaignWithVoucherExcludeKeyofcreateStaticVoucherCampaignWithVoucherSourceID](docs/PickCreateStaticVoucherCampaignWithVoucherExcludeKeyofcreateStaticVoucherCampaignWithVoucherSourceID.md)
 - [PickMSEmployeeAPIKeyCreateParamsExcludeKeyofMSEmployeeAPIKeyCreateParamsEmployeeID](docs/PickMSEmployeeAPIKeyCreateParamsExcludeKeyofMSEmployeeAPIKeyCreateParamsEmployeeID.md)
 - [PickMSEmployeeAPIKeyUpdateParamsExcludeKeyofMSEmployeeAPIKeyUpdateParamsId](docs/PickMSEmployeeAPIKeyUpdateParamsExcludeKeyofMSEmployeeAPIKeyUpdateParamsId.md)
 - [PickMSMemberCreationParamsExcludeKeyofMSMemberCreationParamsMemberIdentifier](docs/PickMSMemberCreationParamsExcludeKeyofMSMemberCreationParamsMemberIdentifier.md)
 - [PickMSMemberExcludeKeyofMSMemberMemberIdentifier](docs/PickMSMemberExcludeKeyofMSMemberMemberIdentifier.md)
 - [PickMSMerchantCreditCreationParamsExcludeKeyofMSMerchantCreditCreationParamsMemberIdentifier](docs/PickMSMerchantCreditCreationParamsExcludeKeyofMSMerchantCreditCreationParamsMemberIdentifier.md)
 - [PickMSMerchantCreditExcludeKeyofMSMerchantCreditMemberIdentifier](docs/PickMSMerchantCreditExcludeKeyofMSMerchantCreditMemberIdentifier.md)
 - [PickPaginationRequestWithSortOptionsExcludeKeyofPaginationRequestWithSortOptionsSortKey](docs/PickPaginationRequestWithSortOptionsExcludeKeyofPaginationRequestWithSortOptionsSortKey.md)
 - [PickPaginationRequestWithoutSortOptionsExcludeKeyofPaginationRequestWithoutSortOptionsIsArchiveIncluded](docs/PickPaginationRequestWithoutSortOptionsExcludeKeyofPaginationRequestWithoutSortOptionsIsArchiveIncluded.md)
 - [PickSSImportedListRecipientFromMembershipTierImportExcludeKeyofSSImportedListRecipientFromMembershipTierImportEmployeeIDOrTierID](docs/PickSSImportedListRecipientFromMembershipTierImportExcludeKeyofSSImportedListRecipientFromMembershipTierImportEmployeeIDOrTierID.md)
 - [PickSSImportedListUpdateParamsExcludeKeyofSSImportedListUpdateParamsId](docs/PickSSImportedListUpdateParamsExcludeKeyofSSImportedListUpdateParamsId.md)
 - [PickSSMobileNumberUpdateParamsExcludeKeyofSSMobileNumberUpdateParamsId](docs/PickSSMobileNumberUpdateParamsExcludeKeyofSSMobileNumberUpdateParamsId.md)
 - [PickSSOptInListCreateParamsExcludeKeyofSSOptInListCreateParamsEmployeeIDOrOptInConfirmedMediaURLsOrOptOutConfirmedMediaURLs](docs/PickSSOptInListCreateParamsExcludeKeyofSSOptInListCreateParamsEmployeeIDOrOptInConfirmedMediaURLsOrOptOutConfirmedMediaURLs.md)
 - [PickSSOptInListMemberCreateParamsExcludeKeyofSSOptInListMemberCreateParamsMerchantCreatedAtOrMaxSMSCount](docs/PickSSOptInListMemberCreateParamsExcludeKeyofSSOptInListMemberCreateParamsMerchantCreatedAtOrMaxSMSCount.md)
 - [PickSSOptInListUpdateParamsExcludeKeyofSSOptInListUpdateParamsId](docs/PickSSOptInListUpdateParamsExcludeKeyofSSOptInListUpdateParamsId.md)
 - [PickSSOptInSourceUpdateParamsExcludeKeyofSSOptInSourceUpdateParamsId](docs/PickSSOptInSourceUpdateParamsExcludeKeyofSSOptInSourceUpdateParamsId.md)
 - [PickSSOutboundMessageLogExcludeKeyofSSOutboundMessageLogToCellPhone](docs/PickSSOutboundMessageLogExcludeKeyofSSOutboundMessageLogToCellPhone.md)
 - [PickVSAdvertisementCreditCreateParamsExcludeKeyofVSAdvertisementCreditCreateParamsEmployeeID](docs/PickVSAdvertisementCreditCreateParamsExcludeKeyofVSAdvertisementCreditCreateParamsEmployeeID.md)
 - [PickVSAdvertisementCreditScanExcludeKeyofVSAdvertisementCreditScanRedeemedAtOrRefundedAt](docs/PickVSAdvertisementCreditScanExcludeKeyofVSAdvertisementCreditScanRedeemedAtOrRefundedAt.md)
 - [PickVSAdvertisementCreditUpdateParamsExcludeKeyofVSAdvertisementCreditUpdateParamsId](docs/PickVSAdvertisementCreditUpdateParamsExcludeKeyofVSAdvertisementCreditUpdateParamsId.md)
 - [PickVSCampaignUpdateParamsExcludeKeyofVSCampaignUpdateParamsStartDateOrExpirationDate](docs/PickVSCampaignUpdateParamsExcludeKeyofVSCampaignUpdateParamsStartDateOrExpirationDate.md)
 - [PickVSDynamicVoucherExcludeKeyofVSDynamicVoucherTemporalDecreaseFrequencyType](docs/PickVSDynamicVoucherExcludeKeyofVSDynamicVoucherTemporalDecreaseFrequencyType.md)
 - [PickVSPaymentDesignCreateParamsExcludeKeyofVSPaymentDesignCreateParamsBackgroundImageURLOrCompanyLogoURLOrEmployeeID](docs/PickVSPaymentDesignCreateParamsExcludeKeyofVSPaymentDesignCreateParamsBackgroundImageURLOrCompanyLogoURLOrEmployeeID.md)
 - [PickVSPaymentDesignUpdateParamsExcludeKeyofVSPaymentDesignUpdateParamsId](docs/PickVSPaymentDesignUpdateParamsExcludeKeyofVSPaymentDesignUpdateParamsId.md)
 - [PickVSStaticVoucherExcludeKeyofVSStaticVoucherRedeemedAtOrRefundedAtOrLastViewedAt](docs/PickVSStaticVoucherExcludeKeyofVSStaticVoucherRedeemedAtOrRefundedAtOrLastViewedAt.md)
 - [PickWTEmployeeCreateExcludeKeyofWTEmployeeCreateEmail](docs/PickWTEmployeeCreateExcludeKeyofWTEmployeeCreateEmail.md)
 - [PickWTMemberMemberIDOrFirstNameOrLastNameOrMembershipTierIDOrPointsAccruedOrMobileNumber](docs/PickWTMemberMemberIDOrFirstNameOrLastNameOrMembershipTierIDOrPointsAccruedOrMobileNumber.md)
 - [PickWTMerchantCreditMemberIDOrCreditAmountOrMobileNumber](docs/PickWTMerchantCreditMemberIDOrCreditAmountOrMobileNumber.md)
 - [PickWTMerchantURLUpdateExcludeKeyofWTMerchantURLUpdateUrlID](docs/PickWTMerchantURLUpdateExcludeKeyofWTMerchantURLUpdateUrlID.md)
 - [PickWTNewsArticleUpdateParamsExcludeKeyofWTNewsArticleUpdateParamsId](docs/PickWTNewsArticleUpdateParamsExcludeKeyofWTNewsArticleUpdateParamsId.md)
 - [PickWTPaymentObjectBroadcastExcludeKeyofWTPaymentObjectBroadcastListTypeOrListID](docs/PickWTPaymentObjectBroadcastExcludeKeyofWTPaymentObjectBroadcastListTypeOrListID.md)
 - [PickWTStaticVoucherCampaignCreateParamsExcludeKeyofWTStaticVoucherCampaignCreateParamsStartDateTimeOrExpirationDateTime](docs/PickWTStaticVoucherCampaignCreateParamsExcludeKeyofWTStaticVoucherCampaignCreateParamsStartDateTimeOrExpirationDateTime.md)
 - [PickWTStaticVoucherCreateParamsExcludeKeyofWTStaticVoucherCreateParamsCampaignID](docs/PickWTStaticVoucherCreateParamsExcludeKeyofWTStaticVoucherCreateParamsCampaignID.md)
 - [Plan](docs/Plan.md)
 - [PortalPage](docs/PortalPage.md)
 - [PrefixedNanoID](docs/PrefixedNanoID.md)
 - [PresignedPost](docs/PresignedPost.md)
 - [PresignedPostFields](docs/PresignedPostFields.md)
 - [Product](docs/Product.md)
 - [PromoCode](docs/PromoCode.md)
 - [ReachPerformanceStats](docs/ReachPerformanceStats.md)
 - [Request](docs/Request.md)
 - [Response](docs/Response.md)
 - [Role](docs/Role.md)
 - [RoleAuditLog](docs/RoleAuditLog.md)
 - [SSImportedListRecipientCreateParams](docs/SSImportedListRecipientCreateParams.md)
 - [SSMerchantID](docs/SSMerchantID.md)
 - [SSNanoID](docs/SSNanoID.md)
 - [SSOptInSource](docs/SSOptInSource.md)
 - [SimpleSMSBroadcast](docs/SimpleSMSBroadcast.md)
 - [StaticVoucher](docs/StaticVoucher.md)
 - [StaticVoucherCampaign](docs/StaticVoucherCampaign.md)
 - [StaticVoucherCampaignBroadcast](docs/StaticVoucherCampaignBroadcast.md)
 - [StaticVoucherCampaignGroup](docs/StaticVoucherCampaignGroup.md)
 - [StaticVoucherCampaignUpdate](docs/StaticVoucherCampaignUpdate.md)
 - [Status](docs/Status.md)
 - [StatusAnyOf](docs/StatusAnyOf.md)
 - [StatusAnyOf1](docs/StatusAnyOf1.md)
 - [StatusAnyOf2](docs/StatusAnyOf2.md)
 - [StatusAnyOf3](docs/StatusAnyOf3.md)
 - [SubscriptionFeature](docs/SubscriptionFeature.md)
 - [SubscriptionPlan](docs/SubscriptionPlan.md)
 - [SubscriptionProduct](docs/SubscriptionProduct.md)
 - [Tcpa](docs/Tcpa.md)
 - [UpdateStaticVoucherCampaignWithVoucher](docs/UpdateStaticVoucherCampaignWithVoucher.md)
 - [VSCampaignGeneratedMessage](docs/VSCampaignGeneratedMessage.md)
 - [VSCampaignGeneratedMessagePagination](docs/VSCampaignGeneratedMessagePagination.md)
 - [VSDynamicVoucherStatus](docs/VSDynamicVoucherStatus.md)
 - [WTAdvertisementCredit](docs/WTAdvertisementCredit.md)
 - [WTAdvertisementCreditCreateParams](docs/WTAdvertisementCreditCreateParams.md)
 - [WTAdvertisementCreditScan](docs/WTAdvertisementCreditScan.md)
 - [WTAdvertisementCreditUpdateParams](docs/WTAdvertisementCreditUpdateParams.md)
 - [WTAuthenticationCheckSessionTokenStatusResponse](docs/WTAuthenticationCheckSessionTokenStatusResponse.md)
 - [WTAuthenticationForgotPassword](docs/WTAuthenticationForgotPassword.md)
 - [WTAuthenticationLoginRequest](docs/WTAuthenticationLoginRequest.md)
 - [WTAuthenticationLoginResponse](docs/WTAuthenticationLoginResponse.md)
 - [WTAuthenticationRegister](docs/WTAuthenticationRegister.md)
 - [WTAuthenticationRequestResetPassword](docs/WTAuthenticationRequestResetPassword.md)
 - [WTAuthenticationResetPassword](docs/WTAuthenticationResetPassword.md)
 - [WTAuthenticationSSOLoginForDiscourse](docs/WTAuthenticationSSOLoginForDiscourse.md)
 - [WTBillingChangePlan](docs/WTBillingChangePlan.md)
 - [WTBillingSavePaymentMethod](docs/WTBillingSavePaymentMethod.md)
 - [WTBillingVerifyPaymentMethodResponse](docs/WTBillingVerifyPaymentMethodResponse.md)
 - [WTCountResult](docs/WTCountResult.md)
 - [WTCustomerSearchByMemberID](docs/WTCustomerSearchByMemberID.md)
 - [WTCustomerSearchByPhoneNumber](docs/WTCustomerSearchByPhoneNumber.md)
 - [WTDynamicVoucher](docs/WTDynamicVoucher.md)
 - [WTDynamicVoucherCreateParams](docs/WTDynamicVoucherCreateParams.md)
 - [WTDynamicVoucherRedemption](docs/WTDynamicVoucherRedemption.md)
 - [WTDynamicVoucherSummary](docs/WTDynamicVoucherSummary.md)
 - [WTDynamicVoucherUpdateParams](docs/WTDynamicVoucherUpdateParams.md)
 - [WTEmployee](docs/WTEmployee.md)
 - [WTEmployeeAPIKey](docs/WTEmployeeAPIKey.md)
 - [WTEmployeeAPIKeyCreateParams](docs/WTEmployeeAPIKeyCreateParams.md)
 - [WTEmployeeAPIKeyUpdateParams](docs/WTEmployeeAPIKeyUpdateParams.md)
 - [WTEmployeeCreate](docs/WTEmployeeCreate.md)
 - [WTEmployeeCreateAlert](docs/WTEmployeeCreateAlert.md)
 - [WTEmployeeCreateDocument](docs/WTEmployeeCreateDocument.md)
 - [WTEmployeeCreateMediaFile](docs/WTEmployeeCreateMediaFile.md)
 - [WTEmployeeCreateStaticVoucherCampaignGroup](docs/WTEmployeeCreateStaticVoucherCampaignGroup.md)
 - [WTEmployeeFileCreate](docs/WTEmployeeFileCreate.md)
 - [WTEmployeeImportRecords](docs/WTEmployeeImportRecords.md)
 - [WTEmployeeNotification](docs/WTEmployeeNotification.md)
 - [WTEmployeePeerRoles](docs/WTEmployeePeerRoles.md)
 - [WTEmployeeS3FilePresign](docs/WTEmployeeS3FilePresign.md)
 - [WTEmployeeScheduleSMSCampaignBroadcast](docs/WTEmployeeScheduleSMSCampaignBroadcast.md)
 - [WTEmployeeScheduleSimpleSMS](docs/WTEmployeeScheduleSimpleSMS.md)
 - [WTEmployeeScheduleSimpleSMSToRecipient](docs/WTEmployeeScheduleSimpleSMSToRecipient.md)
 - [WTEmployeeSendHelpDeskResponse](docs/WTEmployeeSendHelpDeskResponse.md)
 - [WTEmployeeUpdate](docs/WTEmployeeUpdate.md)
 - [WTEmployeeUpdateRecords](docs/WTEmployeeUpdateRecords.md)
 - [WTFetchWalletPaymentObjectWithToken](docs/WTFetchWalletPaymentObjectWithToken.md)
 - [WTImageGridCreateParams](docs/WTImageGridCreateParams.md)
 - [WTImageGridUpdateParams](docs/WTImageGridUpdateParams.md)
 - [WTImportedList](docs/WTImportedList.md)
 - [WTImportedListRecipientFromMembershipTierImport](docs/WTImportedListRecipientFromMembershipTierImport.md)
 - [WTInfoGenesisLookupRequestErrors](docs/WTInfoGenesisLookupRequestErrors.md)
 - [WTInfoGenesisRecordFilterParameters](docs/WTInfoGenesisRecordFilterParameters.md)
 - [WTInfoGenesisRoutingIDs](docs/WTInfoGenesisRoutingIDs.md)
 - [WTInfoGenesisUniquePostingIDs](docs/WTInfoGenesisUniquePostingIDs.md)
 - [WTLinkBook](docs/WTLinkBook.md)
 - [WTLinkBookCreateParams](docs/WTLinkBookCreateParams.md)
 - [WTLinkBookSectionCreateParams](docs/WTLinkBookSectionCreateParams.md)
 - [WTLinkBookSectionUpdateParams](docs/WTLinkBookSectionUpdateParams.md)
 - [WTLinkBookUpdateParams](docs/WTLinkBookUpdateParams.md)
 - [WTMember](docs/WTMember.md)
 - [WTMemberCreationParams](docs/WTMemberCreationParams.md)
 - [WTMembershipTier](docs/WTMembershipTier.md)
 - [WTMembershipTierCreationParams](docs/WTMembershipTierCreationParams.md)
 - [WTMembershipTierUpdateParams](docs/WTMembershipTierUpdateParams.md)
 - [WTMembershipTierWithMemberCount](docs/WTMembershipTierWithMemberCount.md)
 - [WTMerchantCredit](docs/WTMerchantCredit.md)
 - [WTMerchantCreditCreationParams](docs/WTMerchantCreditCreationParams.md)
 - [WTMerchantURLCreate](docs/WTMerchantURLCreate.md)
 - [WTMerchantURLUpdate](docs/WTMerchantURLUpdate.md)
 - [WTMerchantUpdate](docs/WTMerchantUpdate.md)
 - [WTMerchantUpdateBillingContact](docs/WTMerchantUpdateBillingContact.md)
 - [WTMerchantUpdatePOSIntegration](docs/WTMerchantUpdatePOSIntegration.md)
 - [WTNewsArticleCreateParams](docs/WTNewsArticleCreateParams.md)
 - [WTNewsArticleUpdateParams](docs/WTNewsArticleUpdateParams.md)
 - [WTOptInList](docs/WTOptInList.md)
 - [WTOptInListCreationParams](docs/WTOptInListCreationParams.md)
 - [WTPaymentDesign](docs/WTPaymentDesign.md)
 - [WTPaymentDesignCreateParams](docs/WTPaymentDesignCreateParams.md)
 - [WTPaymentDesignUpdateParams](docs/WTPaymentDesignUpdateParams.md)
 - [WTPerformanceCreateParams](docs/WTPerformanceCreateParams.md)
 - [WTPerformanceUpdateParams](docs/WTPerformanceUpdateParams.md)
 - [WTPosMachine](docs/WTPosMachine.md)
 - [WTPosMachineCreateParams](docs/WTPosMachineCreateParams.md)
 - [WTPosMachineUpdateParams](docs/WTPosMachineUpdateParams.md)
 - [WTPromoCodeCreateParams](docs/WTPromoCodeCreateParams.md)
 - [WTPromoCodeUpdateParams](docs/WTPromoCodeUpdateParams.md)
 - [WTRole](docs/WTRole.md)
 - [WTSMSAcquirePhoneNumber](docs/WTSMSAcquirePhoneNumber.md)
 - [WTSMSCreateAgreement](docs/WTSMSCreateAgreement.md)
 - [WTSMSImportOptInListSubscribers](docs/WTSMSImportOptInListSubscribers.md)
 - [WTSMSImportedListCreate](docs/WTSMSImportedListCreate.md)
 - [WTSMSLimits](docs/WTSMSLimits.md)
 - [WTSMSOptInListSourceCreate](docs/WTSMSOptInListSourceCreate.md)
 - [WTSMSUpdatePhoneNumberConfig](docs/WTSMSUpdatePhoneNumberConfig.md)
 - [WTSettingsSetPassword](docs/WTSettingsSetPassword.md)
 - [WTStaticVoucher](docs/WTStaticVoucher.md)
 - [WTStaticVoucherCampaign](docs/WTStaticVoucherCampaign.md)
 - [WTStaticVoucherCampaignPreviewMessages](docs/WTStaticVoucherCampaignPreviewMessages.md)
 - [WTStaticVoucherCampaignPreviewMessagesByPage](docs/WTStaticVoucherCampaignPreviewMessagesByPage.md)
 - [WTStaticVoucherCreateParams](docs/WTStaticVoucherCreateParams.md)
 - [WTStaticVoucherUpdateParams](docs/WTStaticVoucherUpdateParams.md)
 - [WTSystemApprovePhoneNumber](docs/WTSystemApprovePhoneNumber.md)
 - [WTSystemRoleCreate](docs/WTSystemRoleCreate.md)
 - [WTTCPAOpt](docs/WTTCPAOpt.md)
 - [WTTwilioRequestAuthyCode](docs/WTTwilioRequestAuthyCode.md)
 - [WTTwilioVerifyAuthyCode](docs/WTTwilioVerifyAuthyCode.md)
 - [WTWalletConfigurationSaveWalletRecord](docs/WTWalletConfigurationSaveWalletRecord.md)
 - [WTWalletItemRedemption](docs/WTWalletItemRedemption.md)
 - [WTWalletObjectPrefixCounts](docs/WTWalletObjectPrefixCounts.md)
 - [WTWalletPageView](docs/WTWalletPageView.md)
 - [WTWalletPageViewCount](docs/WTWalletPageViewCount.md)
 - [WTWalletPageViewGeoPoint](docs/WTWalletPageViewGeoPoint.md)
 - [WalletConfiguration](docs/WalletConfiguration.md)
 - [WalletPageView](docs/WalletPageView.md)
 - [Webpage](docs/Webpage.md)


## Documentation For Authorization


## api_key

- **Type**: API key
- **API key parameter name**: access-token
- **Location**: HTTP header


## Author

development@wallet.inc


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in wallet.apis and wallet.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from wallet.api.default_api import DefaultApi`
- `from wallet.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import wallet
from wallet.apis import *
from wallet.models import *
```

